/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lookup.entry;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Comparator;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.ServiceControlled;

public class LookupAttributes {
    private static final FieldComparator comparator = new FieldComparator();
    private static final Class[] noArg = new Class[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;

    private LookupAttributes() {
    }

    public static Entry[] add(Entry[] entryArray, Entry[] entryArray2) {
        return LookupAttributes.add(entryArray, entryArray2, false);
    }

    public static Entry[] add(Entry[] entryArray, Entry[] entryArray2, boolean bl) {
        LookupAttributes.check(entryArray2, false);
        Entry[] entryArray3 = LookupAttributes.concat(entryArray, entryArray2);
        int n = entryArray3.length;
        while (--n >= entryArray.length) {
            if (bl) {
                LookupAttributes.check(entryArray3[n]);
            }
            if (!LookupAttributes.isDup(entryArray3, n)) continue;
            entryArray3 = LookupAttributes.delete(entryArray3, n);
        }
        return entryArray3;
    }

    private static void check(Entry entry) {
        if (entry instanceof ServiceControlled) {
            throw new SecurityException("attempt to add or modify a ServiceControlled attribute set");
        }
    }

    public static void check(Entry[] entryArray, boolean bl) {
        int n = entryArray.length;
        while (--n >= 0) {
            Entry entry = entryArray[n];
            if (entry == null && bl) continue;
            Class<?> clazz = entry.getClass();
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new IllegalArgumentException("entry class " + clazz.getName() + " is not public");
            }
            try {
                clazz.getConstructor(noArg);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("entry class " + clazz.getName() + " does not have a public no-arg constructor");
            }
            Field[] fieldArray = clazz.getFields();
            int n2 = fieldArray.length;
            while (--n2 >= 0) {
                if ((fieldArray[n2].getModifiers() & 0x98) != 0 || !fieldArray[n2].getType().isPrimitive()) continue;
                throw new IllegalArgumentException("entry class " + clazz.getName() + " has a primitive field");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static Entry[] concat(Entry[] entryArray, Entry[] entryArray2) {
        Entry[] entryArray3 = new Entry[entryArray.length + entryArray2.length];
        System.arraycopy(entryArray, 0, entryArray3, 0, entryArray.length);
        System.arraycopy(entryArray2, 0, entryArray3, entryArray.length, entryArray2.length);
        return entryArray3;
    }

    private static boolean contains(Entry[] entryArray, Entry entry) {
        int n = 0;
        while (n < entryArray.length) {
            if (LookupAttributes.equal(entryArray[n], entry)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean contains(Entry[] entryArray, Entry[] entryArray2) {
        int n = 0;
        int n2 = 0;
        if (entryArray != null) {
            n = entryArray.length;
        }
        if (entryArray2 != null) {
            n2 = entryArray2.length;
        }
        if (n < n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!LookupAttributes.contains(entryArray, entryArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static Entry[] delete(Entry[] entryArray, int n) {
        int n2 = entryArray.length - 1;
        Entry[] entryArray2 = new Entry[n2];
        System.arraycopy(entryArray, 0, entryArray2, 0, n);
        System.arraycopy(entryArray, n + 1, entryArray2, n, n2 - n);
        return entryArray2;
    }

    private static boolean equal(Class clazz, Class clazz2) {
        return clazz.equals(clazz2) || clazz.getName().equals(clazz2.getName());
    }

    private static boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = LookupAttributes.class$("java.lang.String"))) || clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = LookupAttributes.class$("java.lang.Integer"))) || clazz == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = LookupAttributes.class$("java.lang.Boolean"))) || clazz == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = LookupAttributes.class$("java.lang.Character"))) || clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = LookupAttributes.class$("java.lang.Long"))) || clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = LookupAttributes.class$("java.lang.Float"))) || clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = LookupAttributes.class$("java.lang.Double"))) || clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = LookupAttributes.class$("java.lang.Byte"))) || clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = LookupAttributes.class$("java.lang.Short")))) {
            return object.equals(object2);
        }
        try {
            return new MarshalledObject<Object>(object).equals(new MarshalledObject<Object>(object2));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unexpected IOException");
        }
    }

    public static boolean equal(Entry entry, Entry entry2) {
        if (!LookupAttributes.equal(entry.getClass(), entry2.getClass())) {
            return false;
        }
        Field[] fieldArray = LookupAttributes.getFields(entry);
        Field[] fieldArray2 = LookupAttributes.getFields(entry2, entry, fieldArray);
        try {
            int n = fieldArray.length;
            while (--n >= 0) {
                if (LookupAttributes.equal(fieldArray[n].get(entry), fieldArray2[n].get(entry2))) continue;
                return false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("unexpected IllegalAccessException");
        }
        return true;
    }

    public static boolean equal(Entry[] entryArray, Entry[] entryArray2) {
        return LookupAttributes.contains(entryArray, entryArray2) && LookupAttributes.contains(entryArray2, entryArray);
    }

    private static Field[] getFields(Entry entry) {
        Field[] fieldArray = entry.getClass().getFields();
        Arrays.sort(fieldArray, comparator);
        int n = 0;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if ((fieldArray[n2].getModifiers() & 0x98) == 0) {
                fieldArray[n++] = fieldArray[n2];
            }
            ++n2;
        }
        if (n < fieldArray.length) {
            Field[] fieldArray2 = new Field[n];
            System.arraycopy(fieldArray, 0, fieldArray2, 0, n);
            fieldArray = fieldArray2;
        }
        return fieldArray;
    }

    private static Field[] getFields(Entry entry, Entry entry2, Field[] fieldArray) {
        if (entry.getClass().equals(entry2.getClass())) {
            return fieldArray;
        }
        Field[] fieldArray2 = LookupAttributes.getFields(entry);
        if (fieldArray2.length < fieldArray.length) {
            throw new IllegalArgumentException("type mismatch");
        }
        return fieldArray2;
    }

    private static boolean isAssignableFrom(Class clazz, Class clazz2) {
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        String string = clazz.getName();
        Class clazz3 = clazz2;
        while (clazz3 != null) {
            if (string.equals(clazz3.getName())) {
                return true;
            }
            clazz3 = clazz3.getSuperclass();
        }
        return false;
    }

    private static boolean isDup(Entry[] entryArray, int n) {
        Entry entry = entryArray[n];
        int n2 = n;
        while (--n2 >= 0) {
            if (!LookupAttributes.equal(entry, entryArray[n2])) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Entry entry, Entry entry2) {
        if (!LookupAttributes.isAssignableFrom(entry.getClass(), entry2.getClass())) {
            return false;
        }
        Field[] fieldArray = LookupAttributes.getFields(entry);
        Field[] fieldArray2 = LookupAttributes.getFields(entry2, entry, fieldArray);
        try {
            int n = fieldArray.length;
            while (--n >= 0) {
                Object object = fieldArray[n].get(entry);
                if (object == null || LookupAttributes.equal(object, fieldArray2[n].get(entry2))) continue;
                return false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("unexpected IllegalAccessException");
        }
        return true;
    }

    public static Entry[] modify(Entry[] entryArray, Entry[] entryArray2, Entry[] entryArray3) {
        return LookupAttributes.modify(entryArray, entryArray2, entryArray3, false);
    }

    public static Entry[] modify(Entry[] entryArray, Entry[] entryArray2, Entry[] entryArray3, boolean bl) {
        if (entryArray2.length != entryArray3.length) {
            throw new IllegalArgumentException("attribute set length mismatch");
        }
        int n = entryArray3.length;
        while (--n >= 0) {
            if (entryArray3[n] == null || LookupAttributes.isAssignableFrom(entryArray3[n].getClass(), entryArray2[n].getClass())) continue;
            throw new IllegalArgumentException("attribute set type mismatch");
        }
        LookupAttributes.check(entryArray2, false);
        LookupAttributes.check(entryArray3, true);
        entryArray = (Entry[])entryArray.clone();
        int n2 = entryArray.length;
        block1: while (--n2 >= 0) {
            Entry entry = entryArray[n2];
            int n3 = entryArray2.length;
            while (--n3 >= 0) {
                Entry entry2;
                if (!LookupAttributes.matches(entryArray2[n3], entry)) continue;
                if (bl) {
                    LookupAttributes.check(entry);
                }
                if ((entry2 = entryArray3[n3]) == null) {
                    entryArray = LookupAttributes.delete(entryArray, n2);
                    continue block1;
                }
                entryArray[n2] = LookupAttributes.update(entryArray[n2], entry2);
            }
        }
        int n4 = entryArray.length;
        while (--n4 >= 0) {
            if (!LookupAttributes.isDup(entryArray, n4)) continue;
            entryArray = LookupAttributes.delete(entryArray, n4);
        }
        return entryArray;
    }

    private static Entry update(Entry entry, Entry entry2) {
        try {
            Entry entry3 = (Entry)entry.getClass().newInstance();
            Field[] fieldArray = LookupAttributes.getFields(entry2);
            Field[] fieldArray2 = LookupAttributes.getFields(entry, entry2, fieldArray);
            int n = fieldArray2.length;
            while (--n >= 0) {
                fieldArray2[n].set(entry3, fieldArray2[n].get(entry));
            }
            int n2 = fieldArray.length;
            while (--n2 >= 0) {
                Object object = fieldArray[n2].get(entry2);
                if (object == null) continue;
                fieldArray2[n2].set(entry3, object);
            }
            return entry3;
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("unexpected InstantiationException");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("unexpected IllegalAccessException");
        }
    }

    private static class FieldComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Field field = (Field)object;
            Field field2 = (Field)object2;
            if (field == field2) {
                return 0;
            }
            if (field.getDeclaringClass() == field2.getDeclaringClass()) {
                return field.getName().compareTo(field2.getName());
            }
            if (field.getDeclaringClass().isAssignableFrom(field2.getDeclaringClass())) {
                return -1;
            }
            return 1;
        }
    }
}

