/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.sun.jini.constants.TimeConstants;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.ThreadDebug;
import com.sun.jini.thread.WakeupManager;
import java.io.PrintWriter;
import java.util.List;

public abstract class RetryTask
implements TaskManager.Task,
TimeConstants {
    private TaskManager manager;
    private RetryTime retry;
    private boolean cancelled;
    private boolean complete;
    private WakeupManager.Ticket ticket;
    private long startTime;
    private int attempt;
    private WakeupManager wakeup;
    private static final WakeupManager defaultWakeup = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
    private static final long[] delays = new long[]{1000L, 5000L, 10000L, 60000L, 60000L, 300000L};
    private static long LAST_DELAY;
    private static final PrintWriter DEBUG;

    static {
        int n = 1;
        while (n < delays.length) {
            int n2 = n;
            delays[n2] = delays[n2] + delays[n - 1];
            ++n;
        }
        LAST_DELAY = delays[delays.length - 1];
        DEBUG = ThreadDebug.getWriter("retryTask");
    }

    public RetryTask(TaskManager taskManager) {
        this(taskManager, defaultWakeup);
    }

    public RetryTask(TaskManager taskManager, WakeupManager wakeupManager) {
        this.manager = taskManager;
        this.wakeup = wakeupManager == null ? defaultWakeup : wakeupManager;
        this.reset();
    }

    static /* synthetic */ WakeupManager.Ticket access$0(RetryTask retryTask) {
        return retryTask.ticket;
    }

    public synchronized int attempt() {
        return this.attempt;
    }

    public synchronized void cancel() {
        this.cancelled = true;
        if (this.ticket != null) {
            this.wakeup.cancel(this.ticket);
        }
        this.notifyAll();
    }

    public synchronized boolean cancelled() {
        return this.cancelled;
    }

    public synchronized boolean complete() {
        return this.complete;
    }

    public void reset() {
        this.cancel();
        this.startTime = System.currentTimeMillis();
        this.cancelled = false;
        this.complete = false;
        this.ticket = null;
        this.attempt = 0;
    }

    public long retryTime() {
        long l = this.attempt < delays.length ? delays[this.attempt] : LAST_DELAY;
        long l2 = this.startTime + l;
        if (DEBUG != null) {
            DEBUG.println("delay of " + l / 1000L + " seconds");
        }
        return l2;
    }

    public void run() {
        RetryTask retryTask = this;
        synchronized (retryTask) {
            if (this.cancelled) {
                Object var2_3 = null;
                return;
            }
        }
        boolean bl = this.tryOnce();
        RetryTask retryTask2 = this;
        synchronized (retryTask2) {
            if (!bl) {
                ++this.attempt;
                long l = this.retryTime();
                if (DEBUG != null) {
                    DEBUG.println("retry in " + (l - this.startTime));
                }
                if (this.retry == null) {
                    this.retry = new RetryTime();
                }
                this.ticket = this.wakeup.schedule(l, this.retry);
            } else {
                this.complete = true;
                this.notifyAll();
            }
        }
    }

    public abstract boolean runAfter(List var1, int var2);

    public synchronized long startTime() {
        return this.startTime;
    }

    public abstract boolean tryOnce();

    public synchronized boolean waitFor() throws InterruptedException {
        while (!this.cancelled && !this.complete) {
            this.wait();
        }
        return this.complete;
    }

    private class RetryTime
    implements Runnable {
        RetryTime() {
        }

        public void run() {
            RetryTask retryTask = RetryTask.this;
            synchronized (retryTask) {
                RetryTask.this.ticket = null;
            }
            RetryTask.this.manager.add(RetryTask.this);
        }
    }
}

