/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TaskManager {
    protected final ArrayList tasks = new ArrayList();
    protected int firstPending = 0;
    protected final List roTasks = Collections.unmodifiableList(this.tasks);
    protected final List threads = new ArrayList();
    protected final int maxThreads;
    protected final long timeout;
    protected final float loadFactor;
    protected boolean terminated = false;

    public TaskManager() {
        this(10, 15000L, 3.0f);
    }

    public TaskManager(int n, long l, float f) {
        this.maxThreads = n;
        this.timeout = l;
        this.loadFactor = f;
    }

    public synchronized void add(Task task) {
        this.tasks.add(task);
        this.pokeThread();
    }

    public synchronized void addAll(Collection collection) {
        this.tasks.addAll(collection);
        int n = collection.size();
        while (--n >= 0) {
            this.pokeThread();
        }
    }

    public synchronized void addIfNew(Task task) {
        if (!this.tasks.contains(task)) {
            this.add(task);
        }
    }

    public synchronized ArrayList getPending() {
        ArrayList arrayList = (ArrayList)this.tasks.clone();
        int n = this.firstPending;
        while (--n >= 0) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    protected boolean needThread() {
        return (float)this.tasks.size() > this.loadFactor * (float)this.threads.size();
    }

    private void pokeThread() {
        if (this.threads.size() < this.maxThreads && this.needThread()) {
            TaskThread taskThread = new TaskThread();
            this.threads.add(taskThread);
            taskThread.start();
        } else {
            this.notify();
        }
    }

    public synchronized boolean remove(Task task) {
        return this.removeTask(task, 0);
    }

    public synchronized boolean removeIfPending(Task task) {
        return this.removeTask(task, this.firstPending);
    }

    private boolean removeTask(Task task, int n) {
        int n2 = this.tasks.size();
        while (--n2 >= n) {
            if (this.tasks.get(n2) != task) continue;
            this.tasks.remove(n2);
            if (n2 < this.firstPending) {
                --this.firstPending;
                int n3 = this.threads.size();
                while (--n3 >= 0) {
                    TaskThread taskThread = (TaskThread)this.threads.get(n3);
                    if (taskThread.task != task) continue;
                    taskThread.interrupt();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public synchronized void terminate() {
        this.terminated = true;
        int n = this.threads.size();
        while (--n >= 0) {
            ((Thread)this.threads.get(n)).interrupt();
        }
    }

    public static interface Task
    extends Runnable {
        public boolean runAfter(List var1, int var2);
    }

    private class TaskThread
    extends Thread {
        public Task task = null;

        public TaskThread() {
            super("task");
            this.setDaemon(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    TaskManager taskManager = TaskManager.this;
                    synchronized (taskManager) {
                        if (TaskManager.this.terminated) {
                            return;
                        }
                        if (this.task != null) {
                            int n = TaskManager.this.firstPending;
                            while (--n >= 0) {
                                if (TaskManager.this.tasks.get(n) != this.task) continue;
                                TaskManager.this.tasks.remove(n);
                                --TaskManager.this.firstPending;
                                break;
                            }
                            this.task = null;
                            Thread.interrupted();
                        }
                        if (!this.takeTask()) {
                            TaskManager.this.wait(TaskManager.this.timeout);
                            if (TaskManager.this.terminated || !this.takeTask()) {
                                TaskManager.this.threads.remove(TaskManager.this.threads.indexOf(this));
                                return;
                            }
                        }
                    }
                    this.task.run();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private boolean takeTask() {
            int n = TaskManager.this.tasks.size();
            int n2 = TaskManager.this.firstPending;
            while (n2 < n) {
                Task task = (Task)TaskManager.this.tasks.get(n2);
                if (!task.runAfter(TaskManager.this.roTasks, n2)) {
                    if (n2 > TaskManager.this.firstPending) {
                        TaskManager.this.tasks.remove(n2);
                        TaskManager.this.tasks.add(TaskManager.this.firstPending, task);
                    }
                    ++TaskManager.this.firstPending;
                    this.task = task;
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

