/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.sun.jini.constants.TimeConstants;
import com.sun.jini.thread.ThreadDebug;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.SortedMap;
import java.util.TreeMap;

public class WakeupManager
implements TimeConstants {
    private SortedMap contents;
    private long nextBreaker = 0L;
    private Ticket head = null;
    private Kicker kicker;
    private ThreadDesc kickerDesc;
    private Thread kickerThread;
    private static DateFormat dateFmt = DateFormat.getTimeInstance(1);
    private static final PrintWriter DEBUG = ThreadDebug.getWriter("wakeupQueue");

    public WakeupManager() {
        this(new ThreadDesc());
    }

    public WakeupManager(ThreadDesc threadDesc) {
        this.kickerDesc = threadDesc;
        this.contents = new TreeMap();
        this.kicker = new Kicker();
        this.kickerThread = this.kickerDesc.thread(this.kicker);
        this.kickerThread.start();
    }

    public void cancel(Ticket ticket) {
        SortedMap sortedMap = this.contents;
        synchronized (sortedMap) {
            this.contents.remove(ticket);
            this.checkHead();
        }
    }

    public void cancelAll() {
        SortedMap sortedMap = this.contents;
        synchronized (sortedMap) {
            this.contents.clear();
            this.checkHead();
        }
    }

    private void checkHead() {
        Ticket ticket = this.head;
        this.head = this.contents.isEmpty() ? null : (Ticket)this.contents.firstKey();
        if (this.head == ticket) {
            return;
        }
        this.kicker.newTime();
    }

    public boolean isEmpty() {
        SortedMap sortedMap = this.contents;
        synchronized (sortedMap) {
            boolean bl = this.contents.isEmpty();
            Object var3_3 = null;
            return bl;
        }
    }

    public Ticket schedule(long l, Runnable runnable) {
        return this.schedule(l, runnable, null);
    }

    public Ticket schedule(long l, Runnable runnable, ThreadDesc threadDesc) {
        if (runnable == null) {
            throw new NullPointerException("task");
        }
        SortedMap sortedMap = this.contents;
        synchronized (sortedMap) {
            Ticket ticket = new Ticket(l, runnable, threadDesc, this.nextBreaker++);
            this.contents.put(ticket, ticket);
            this.checkHead();
            Ticket ticket2 = ticket;
            Object var7_7 = null;
            return ticket2;
        }
    }

    public void stop() {
        this.kicker.kill();
    }

    public static class ThreadDesc {
        private final ThreadGroup group;
        private final boolean daemon;
        private final int priority;

        public ThreadDesc() {
            this(null, false);
        }

        public ThreadDesc(ThreadGroup threadGroup, boolean bl) {
            this(threadGroup, bl, 5);
        }

        public ThreadDesc(ThreadGroup threadGroup, boolean bl, int n) {
            this.group = threadGroup;
            this.daemon = bl;
            this.priority = n;
        }

        private Thread thread(Runnable runnable) {
            Thread thread = this.group == null ? new Thread(runnable) : new Thread(this.group, runnable);
            thread.setDaemon(this.daemon);
            thread.setPriority(this.priority);
            return thread;
        }

        public String toString() {
            return "[" + this.group + ", " + this.daemon + ", " + this.priority + "]";
        }
    }

    public static class Ticket
    implements Comparable {
        public final long when;
        public final Runnable task;
        public final ThreadDesc desc;
        private final long breaker;

        Ticket(long l, Runnable runnable, ThreadDesc threadDesc, long l2) {
            if (runnable == null) {
                throw new NullPointerException("task not specified");
            }
            this.when = l;
            this.task = runnable;
            this.desc = threadDesc;
            this.breaker = l2;
        }

        public int compareTo(Object object) {
            Ticket ticket = (Ticket)object;
            long l = this.when - ticket.when;
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            long l2 = this.breaker - ticket.breaker;
            if (l2 > 0L) {
                return 1;
            }
            if (l2 < 0L) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Ticket)) {
                return false;
            }
            Ticket ticket = (Ticket)object;
            return ticket.when == this.when && ticket.breaker == this.breaker;
        }

        public String toString() {
            return String.valueOf(dateFmt.format(new Long(this.when))) + "(" + this.when + ")" + ", " + this.task.getClass().getName() + ", " + this.desc;
        }
    }

    private class Kicker
    implements Runnable {
        private long sleepTime;
        private boolean sleepTimeValid;
        private boolean die = false;

        Kicker() {
        }

        private void doTasks() {
            do {
                Ticket ticket;
                Object var3_3;
                SortedMap sortedMap = WakeupManager.this.contents;
                synchronized (sortedMap) {
                    Kicker kicker = this;
                    synchronized (kicker) {
                        this.sleepTimeValid = true;
                    }
                    if (WakeupManager.this.contents.isEmpty()) {
                        this.sleepTime = Long.MAX_VALUE;
                        var3_3 = null;
                        continue;
                    }
                    ticket = (Ticket)WakeupManager.this.contents.firstKey();
                }
                this.sleepTime = ticket.when - System.currentTimeMillis();
                if (this.sleepTime > 0L) continue;
                sortedMap = WakeupManager.this.contents;
                synchronized (sortedMap) {
                    if (ticket != WakeupManager.this.contents.remove(ticket)) {
                        var3_3 = null;
                        continue;
                    }
                }
                if (ticket.desc == null) {
                    ticket.task.run();
                } else {
                    ticket.desc.thread(ticket.task).start();
                }
                if (!WakeupManager.this.kickerThread.isInterrupted()) continue;
                return;
            } while (this.sleepTime <= 0L);
        }

        private synchronized void kill() {
            this.die = true;
            WakeupManager.this.kickerThread.interrupt();
        }

        private synchronized void newTime() {
            this.sleepTimeValid = false;
            this.notifyAll();
        }

        public void run() {
            while (true) {
                this.doTasks();
                if (DEBUG != null) {
                    DEBUG.println("sleepTime = " + (this.sleepTime == Long.MAX_VALUE ? "***FOREVER***" : String.valueOf(this.sleepTime)));
                }
                Kicker kicker = this;
                synchronized (kicker) {
                    try {
                        if (this.sleepTimeValid && this.sleepTime > 0L && !this.die) {
                            this.wait(this.sleepTime);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.die) {
                        Object var2_2 = null;
                        return;
                    }
                }
            }
        }
    }
}

