/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.Constants;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.DiscoveryPermission;
import net.jini.discovery.IncomingMulticastAnnouncement;
import net.jini.discovery.IncomingUnicastResponse;
import net.jini.discovery.OutgoingMulticastRequest;
import net.jini.discovery.OutgoingUnicastRequest;

public class LookupDiscovery
implements DiscoveryManagement,
DiscoveryGroupManagement {
    public static final String[] ALL_GROUPS = DiscoveryGroupManagement.ALL_GROUPS;
    public static final String[] NO_GROUPS = DiscoveryGroupManagement.NO_GROUPS;
    private static final int MAX_N_TASKS = 15;
    private InetAddress[] nicAddresses;
    private boolean terminated = false;
    private ArrayList listeners = new ArrayList(1);
    private Set groups = null;
    private Map registrars = new HashMap(11);
    private Set pendingDiscoveries = new HashSet(11);
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private TaskManager unicastDiscoveryTaskMgr = new TaskManager(15, 15000L, 1.0f);
    private AnnouncementListener announceeThread;
    private Collection requestors = new LinkedList();
    private ResponseListener respondeeThread = null;
    private final AccessControlContext acc = AccessController.getContext();
    private HashMap regTimes = new HashMap(11);
    private AnnouncementTimerThread announcementTimerThread;
    private static final int DISCOVERED = 0;
    private static final int DISCARDED = 1;
    private static final int CHANGED = 2;

    public LookupDiscovery(String[] stringArray) throws IOException {
        this.testArrayForNullElement(stringArray);
        LookupDiscovery.checkGroups(stringArray);
        if (stringArray != null) {
            this.groups = new HashSet(stringArray.length * 2);
            int n = 0;
            while (n < stringArray.length) {
                this.groups.add(stringArray[n]);
                ++n;
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    LookupDiscovery.this.nicAddresses = LookupDiscovery.getNICAddresses();
                    LookupDiscovery.this.announceeThread = new AnnouncementListener();
                    LookupDiscovery.this.announcementTimerThread = new AnnouncementTimerThread();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        if (this.groups == null || !this.groups.isEmpty()) {
            this.requestGroups(this.groups);
        }
        this.announceeThread.start();
        this.announcementTimerThread.start();
    }

    static /* synthetic */ Map access$16(LookupDiscovery lookupDiscovery, HashMap hashMap) {
        return lookupDiscovery.deepCopy(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new NullPointerException("can't add null listener");
        }
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.listeners.indexOf(discoveryListener) >= 0) {
                return;
            }
            this.listeners.add(discoveryListener);
            if (this.registrars.isEmpty()) {
                return;
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iterator = this.registrars.values().iterator();
            int n = 0;
            while (true) {
                Object object;
                if (!iterator.hasNext()) {
                    object = new ArrayList(1);
                    ((ArrayList)object).add(discoveryListener);
                    this.addNotify((ArrayList)object, hashMap, 0);
                    return;
                }
                object = (IncomingUnicastResponse)iterator.next();
                hashMap.put(((IncomingUnicastResponse)object).registrar, ((IncomingUnicastResponse)object).groups);
                ++n;
            }
        }
    }

    public void addGroups(String[] stringArray) throws IOException {
        this.testArrayForNullElement(stringArray);
        LookupDiscovery.checkGroups(stringArray);
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't add to \"any groups\"");
            }
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (this.groups.add(stringArray[n])) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                this.requestGroups(arrayList);
            }
        }
    }

    private void addNotify(ArrayList arrayList, Map map, int n) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(arrayList, map, n));
            if (this.notifierThread == null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        LookupDiscovery.this.notifierThread = new Notifier();
                        LookupDiscovery.this.notifierThread.start();
                        return null;
                    }
                });
            }
        }
    }

    private static void checkGroups(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                securityManager.checkPermission(new DiscoveryPermission(stringArray[n]));
                ++n;
            }
        } else {
            securityManager.checkPermission(new DiscoveryPermission("*"));
        }
    }

    private static final String[] collectionToStrings(Collection collection) {
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    private Map deepCopy(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return hashMap2;
    }

    public void discard(ServiceRegistrar serviceRegistrar) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (serviceRegistrar == null) {
                Object var3_3 = null;
                return;
            }
            this.sendDiscarded(serviceRegistrar, null);
        }
    }

    private String[] getActualGroups(ServiceRegistrar serviceRegistrar) {
        try {
            return serviceRegistrar.getGroups();
        }
        catch (RemoteException remoteException) {
            this.discard(serviceRegistrar);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getGroups() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                return ALL_GROUPS;
            }
            if (!this.groups.isEmpty()) return LookupDiscovery.collectionToStrings(this.groups);
            return NO_GROUPS;
        }
    }

    private static InetAddress[] getNICAddresses() throws UnknownHostException {
        String string = null;
        try {
            string = System.getProperty("net.jini.discovery.interface");
        }
        catch (SecurityException securityException) {}
        if (string == null) {
            return null;
        }
        InetAddress[] inetAddressArray = null;
        String string2 = ",";
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            inetAddressArray = new InetAddress[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens() && n2 < n) {
                inetAddressArray[n2] = InetAddress.getByName(stringTokenizer.nextToken());
                ++n2;
            }
            return inetAddressArray;
        }
        return inetAddressArray;
    }

    public ServiceRegistrar[] getRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.registrars.isEmpty()) {
                ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[]{};
                Object var3_4 = null;
                return serviceRegistrarArray;
            }
            Iterator iterator = this.registrars.values().iterator();
            ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.registrars.size()];
            int n = 0;
            while (iterator.hasNext()) {
                serviceRegistrarArray[n] = ((IncomingUnicastResponse)iterator.next()).registrar;
                ++n;
            }
            ServiceRegistrar[] serviceRegistrarArray2 = serviceRegistrarArray;
            Object var3_5 = null;
            return serviceRegistrarArray2;
        }
    }

    private ServiceID[] getServiceIDs() {
        Map map = this.registrars;
        synchronized (map) {
            ServiceID[] serviceIDArray = this.registrars.keySet().toArray(new ServiceID[this.registrars.size()]);
            Object var3_3 = null;
            return serviceIDArray;
        }
    }

    private static boolean groupSetsEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            block4: {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (!stringArray[n].equals(stringArray2[n2])) {
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean groupsOverlap(String[] stringArray) {
        if (this.groups == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (this.groups.contains(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Map mapRegToGroups(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
        hashMap.put(serviceRegistrar, stringArray);
        return hashMap;
    }

    private void maybeAddNewRegistrar(IncomingUnicastResponse incomingUnicastResponse) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.groupsOverlap(incomingUnicastResponse.groups) && !incomingUnicastResponse.equals(this.registrars.put(incomingUnicastResponse.registrar.getServiceID(), incomingUnicastResponse))) {
                this.regTimes.put(incomingUnicastResponse.registrar.getServiceID(), new Long(System.currentTimeMillis()));
                if (!this.listeners.isEmpty()) {
                    this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(incomingUnicastResponse.registrar, incomingUnicastResponse.groups), 0);
                }
            }
        }
    }

    private void maybeDiscardRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iterator = this.registrars.values().iterator();
            while (iterator.hasNext()) {
                IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)iterator.next();
                if (this.groupsOverlap(incomingUnicastResponse.groups)) continue;
                hashMap.put(incomingUnicastResponse.registrar, incomingUnicastResponse.groups);
                this.regTimes.remove(incomingUnicastResponse.registrar.getServiceID());
                iterator.remove();
            }
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, 1);
            }
        }
    }

    private void maybeSendEvent(IncomingUnicastResponse incomingUnicastResponse, String[] stringArray) {
        ServiceRegistrar serviceRegistrar = incomingUnicastResponse.getRegistrar();
        String[] stringArray2 = incomingUnicastResponse.getGroups();
        boolean bl = true;
        if (stringArray == null) {
            stringArray = this.getActualGroups(serviceRegistrar);
            if (stringArray == null) {
                return;
            }
            bl = false;
        }
        if (LookupDiscovery.groupSetsEqual(stringArray2, stringArray)) {
            return;
        }
        String[] stringArray3 = stringArray;
        if (bl && stringArray.length > 0 && (stringArray3 = this.getActualGroups(serviceRegistrar)) == null) {
            return;
        }
        this.notifyOnGroupChange(serviceRegistrar, stringArray2, stringArray3);
    }

    private void notifyOnGroupChange(ServiceRegistrar serviceRegistrar, String[] stringArray, String[] stringArray2) {
        boolean bl = LookupDiscovery.groupSetsEqual(stringArray, stringArray2);
        boolean bl2 = this.groupsOverlap(stringArray2);
        if (!bl && bl2) {
            this.sendChanged(serviceRegistrar, stringArray2);
        } else if (!bl2) {
            this.sendDiscarded(serviceRegistrar, stringArray2);
        }
    }

    private void nukeThreads() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LookupDiscovery.this.announcementTimerThread.interrupt();
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    Iterator iterator = LookupDiscovery.this.requestors.iterator();
                    while (iterator.hasNext()) {
                        Thread thread = (Thread)iterator.next();
                        thread.interrupt();
                    }
                    if (LookupDiscovery.this.respondeeThread != null) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                    }
                }
                LookupDiscovery.this.announceeThread.interrupt();
                collection = LookupDiscovery.this.pendingDiscoveries;
                synchronized (collection) {
                    LookupDiscovery.this.terminateTaskMgr();
                }
                return null;
            }
        });
    }

    private static void printException(Exception exception) {
        try {
            if (System.getProperty("net.jini.discovery.debug") != null) {
                exception.printStackTrace();
            }
        }
        catch (SecurityException securityException) {}
    }

    public void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            ((AbstractCollection)this.listeners).remove(discoveryListener);
        }
    }

    public void removeGroups(String[] stringArray) {
        boolean bl;
        this.testArrayForNullElement(stringArray);
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't remove from \"any groups\"");
            }
            bl = this.removeGroupsInt(stringArray);
        }
        if (bl) {
            this.maybeDiscardRegistrars();
        }
    }

    private boolean removeGroupsInt(String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            bl |= this.groups.remove(stringArray[n]);
            ++n;
        }
        return bl;
    }

    private void requestGroups(final Collection collection) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Requestor requestor;
                    Collection collection2 = requestors;
                    synchronized (collection2) {
                        if (respondeeThread == null) {
                            respondeeThread = new ResponseListener();
                            respondeeThread.start();
                        }
                        requestor = new Requestor(LookupDiscovery.collectionToStrings(collection), respondeeThread.getPort());
                        requestors.add(requestor);
                    }
                    requestor.start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void sendChanged(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)this.registrars.get(serviceRegistrar.getServiceID());
        incomingUnicastResponse.groups = (String[])stringArray.clone();
        if (!this.listeners.isEmpty()) {
            this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(serviceRegistrar, stringArray), 2);
        }
    }

    private void sendDiscarded(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        ServiceID serviceID = serviceRegistrar.getServiceID();
        if (stringArray == null) {
            IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)this.registrars.get(serviceID);
            if (incomingUnicastResponse == null) {
                return;
            }
            stringArray = incomingUnicastResponse.getGroups();
        }
        if (this.registrars.remove(serviceID) != null) {
            this.regTimes.remove(serviceID);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(serviceRegistrar, stringArray), 1);
            }
        }
    }

    private static void sendPacket(MulticastSocket multicastSocket, DatagramPacket[] datagramPacketArray) throws InterruptedIOException {
        int n = 0;
        while (n < datagramPacketArray.length) {
            try {
                multicastSocket.send(datagramPacketArray[n]);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                LookupDiscovery.printException(iOException);
            }
            ++n;
        }
    }

    private static void sendPacketByNIC(MulticastSocket multicastSocket, DatagramPacket[] datagramPacketArray, InetAddress[] inetAddressArray) throws InterruptedIOException {
        if (inetAddressArray != null && inetAddressArray.length > 0) {
            int n = 0;
            while (n < inetAddressArray.length) {
                block5: {
                    try {
                        multicastSocket.setInterface(inetAddressArray[n]);
                    }
                    catch (SocketException socketException) {
                        LookupDiscovery.printException(socketException);
                        break block5;
                    }
                    LookupDiscovery.sendPacket(multicastSocket, datagramPacketArray);
                }
                ++n;
            }
        } else {
            LookupDiscovery.sendPacket(multicastSocket, datagramPacketArray);
        }
    }

    public void setGroups(String[] stringArray) throws IOException {
        this.testArrayForNullElement(stringArray);
        boolean bl = false;
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>(stringArray.length * 2);
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (stringArray == null) {
                if (this.groups != null) {
                    this.groups = null;
                    this.requestGroups(null);
                }
                Object var5_6 = null;
                return;
            }
            if (this.groups == null) {
                this.groups = new HashSet(11);
                bl = true;
            }
            HashSet hashSet2 = new HashSet(hashSet);
            hashSet2.removeAll(this.groups);
            HashSet hashSet3 = new HashSet(this.groups);
            hashSet3.removeAll(hashSet);
            this.groups.addAll(hashSet2);
            if (!hashSet3.isEmpty()) {
                bl |= this.removeGroupsInt(LookupDiscovery.collectionToStrings(hashSet3));
            }
            if (!hashSet2.isEmpty()) {
                this.requestGroups(hashSet2);
            }
        }
        if (bl) {
            this.maybeDiscardRegistrars();
        }
    }

    public void terminate() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                Object var2_2 = null;
                return;
            }
            this.terminated = true;
        }
        this.nukeThreads();
    }

    private void terminateTaskMgr() {
        TaskManager taskManager = this.unicastDiscoveryTaskMgr;
        Object object = taskManager;
        synchronized (object) {
            ArrayList arrayList = taskManager.getPending();
            int n = 0;
            while (n < arrayList.size()) {
                taskManager.remove((TaskManager.Task)arrayList.get(n));
                ++n;
            }
            Set set = this.pendingDiscoveries;
            synchronized (set) {
                Iterator iterator = this.pendingDiscoveries.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    iterator.remove();
                    if (!(e instanceof Socket)) continue;
                    try {
                        ((Socket)e).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            taskManager.terminate();
            taskManager = null;
        }
        object = this.pendingNotifies;
        synchronized (object) {
            this.pendingNotifies.clear();
        }
    }

    private void testArrayForNullElement(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new NullPointerException("null element in group array");
            }
            ++n;
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final int eventType;

        public NotifyTask(ArrayList arrayList, Map map, int n) {
            this.listeners = arrayList;
            this.groupsMap = map;
            this.eventType = n;
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event listener notification");
            this.setDaemon(true);
        }

        static /* synthetic */ LookupDiscovery access$0(Notifier notifier) {
            return notifier.LookupDiscovery.this;
        }

        public void run() {
            while (true) {
                NotifyTask notifyTask;
                LinkedList linkedList = LookupDiscovery.this.pendingNotifies;
                synchronized (linkedList) {
                    if (LookupDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupDiscovery.this.notifierThread = null;
                        Object var3_3 = null;
                        return;
                    }
                    notifyTask = (NotifyTask)LookupDiscovery.this.pendingNotifies.removeFirst();
                }
                AccessController.doPrivileged(new PrivilegedAction(notifyTask, this){
                    private final /* synthetic */ Notifier this$1;
                    private final /* synthetic */ NotifyTask val$task;
                    {
                        this.val$task = notifyTask;
                        this.this$1 = notifier;
                    }

                    public Object run() {
                        Iterator<E> iterator = ((AbstractList)this.val$task.listeners).iterator();
                        while (iterator.hasNext()) {
                            DiscoveryListener discoveryListener = (DiscoveryListener)iterator.next();
                            if (this.val$task.eventType == 2 && !(discoveryListener instanceof DiscoveryChangeListener)) continue;
                            DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)Notifier.access$0(this.this$1), LookupDiscovery.access$16(Notifier.access$0(this.this$1), (HashMap)this.val$task.groupsMap));
                            switch (this.val$task.eventType) {
                                case 0: {
                                    discoveryListener.discovered(discoveryEvent);
                                    break;
                                }
                                case 1: {
                                    discoveryListener.discarded(discoveryEvent);
                                    break;
                                }
                                case 2: {
                                    ((DiscoveryChangeListener)discoveryListener).changed(discoveryEvent);
                                    break;
                                }
                            }
                        }
                        return null;
                    }
                }, LookupDiscovery.this.acc);
            }
        }
    }

    private class AnnouncementListener
    extends Thread {
        private MulticastSocket sock;
        private boolean interrupted = false;

        public AnnouncementListener() throws IOException {
            super("multicast discovery announcement listener");
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            if (LookupDiscovery.this.nicAddresses != null && LookupDiscovery.this.nicAddresses.length > 0) {
                int n = 0;
                while (n < LookupDiscovery.this.nicAddresses.length) {
                    this.sock.setInterface(LookupDiscovery.this.nicAddresses[n]);
                    this.sock.joinGroup(Constants.getAnnouncementAddress());
                    ++n;
                }
            } else {
                this.sock.joinGroup(Constants.getAnnouncementAddress());
            }
        }

        public void interrupt() {
            this.interrupted = true;
            this.sock.close();
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            byte[] byArray = new byte[512];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            while (!this.isInterrupted()) {
                try {
                    Object object;
                    IncomingMulticastAnnouncement incomingMulticastAnnouncement;
                    block22: {
                        datagramPacket.setLength(byArray.length);
                        try {
                            this.sock.receive(datagramPacket);
                        }
                        catch (NullPointerException nullPointerException) {
                            break;
                        }
                        incomingMulticastAnnouncement = new IncomingMulticastAnnouncement(datagramPacket);
                        ServiceID serviceID = incomingMulticastAnnouncement.getServiceID();
                        object = LookupDiscovery.this.registrars;
                        synchronized (object) {
                            IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)LookupDiscovery.this.registrars.get(serviceID);
                            if (incomingUnicastResponse != null) {
                                LookupDiscovery.this.regTimes.put(serviceID, new Long(System.currentTimeMillis()));
                                Set set = LookupDiscovery.this.pendingDiscoveries;
                                synchronized (set) {
                                    if (LookupDiscovery.this.pendingDiscoveries.add(incomingMulticastAnnouncement)) {
                                        LookupDiscovery.this.unicastDiscoveryTaskMgr.add(new UnicastDiscoveryTask());
                                    }
                                }
                            }
                            if (LookupDiscovery.this.groupsOverlap(incomingMulticastAnnouncement.getGroups())) break block22;
                            Object var6_7 = null;
                            continue;
                        }
                    }
                    object = LookupDiscovery.this.pendingDiscoveries;
                    synchronized (object) {
                        if (LookupDiscovery.this.pendingDiscoveries.add(incomingMulticastAnnouncement.getLocator())) {
                            LookupDiscovery.this.unicastDiscoveryTaskMgr.add(new UnicastDiscoveryTask());
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    LookupDiscovery.printException(exception);
                }
            }
            this.sock.close();
            this.sock = null;
        }
    }

    private class ResponseListener
    extends Thread {
        public ServerSocket serv;
        private boolean interrupted = false;

        public ResponseListener() throws IOException {
            super("multicast discovery response listener");
            this.setDaemon(true);
            this.serv = new ServerSocket(0);
        }

        public int getPort() {
            return this.serv.getLocalPort();
        }

        public void interrupt() {
            this.interrupted = true;
            try {
                new Socket(InetAddress.getLocalHost(), this.getPort()).close();
            }
            catch (IOException iOException) {}
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Socket socket = this.serv.accept();
                    if (this.isInterrupted()) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    Set set = LookupDiscovery.this.pendingDiscoveries;
                    synchronized (set) {
                        LookupDiscovery.this.pendingDiscoveries.add(socket);
                        LookupDiscovery.this.unicastDiscoveryTaskMgr.add(new UnicastDiscoveryTask());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    LookupDiscovery.printException(exception);
                }
            }
            try {
                this.serv.close();
            }
            catch (IOException iOException) {
                LookupDiscovery.printException(iOException);
            }
        }
    }

    private class Requestor
    extends Thread {
        private MulticastSocket sock;
        private int responsePort;
        private String[] groups;

        public Requestor(String[] stringArray, int n) throws IOException {
            super("multicast discovery request");
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            int n2 = 15;
            try {
                n2 = Integer.getInteger("net.jini.discovery.ttl", n2);
            }
            catch (SecurityException securityException) {}
            this.sock.setTimeToLive(n2);
            this.responsePort = n;
            this.groups = stringArray == null ? new String[]{} : stringArray;
        }

        public void run() {
            Object object;
            try {
                try {
                    int n = 7;
                    while (--n >= 0 && !this.isInterrupted()) {
                        try {
                            object = OutgoingMulticastRequest.marshal(this.responsePort, this.groups, LookupDiscovery.this.getServiceIDs());
                            try {
                                LookupDiscovery.sendPacketByNIC(this.sock, object, LookupDiscovery.this.nicAddresses);
                            }
                            catch (InterruptedIOException interruptedIOException) {
                                Object var3_6 = null;
                                object = LookupDiscovery.this.requestors;
                                synchronized (object) {
                                    LookupDiscovery.this.requestors.remove(Thread.currentThread());
                                    if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                                        LookupDiscovery.this.respondeeThread.interrupt();
                                        LookupDiscovery.this.respondeeThread = null;
                                    }
                                }
                                this.sock.close();
                                return;
                            }
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            break;
                        }
                        catch (Exception exception) {
                            LookupDiscovery.printException(exception);
                        }
                        Thread.sleep(n > 0 ? 5000 : 120000);
                    }
                }
                catch (InterruptedException interruptedException) {
                    LookupDiscovery.printException(interruptedException);
                }
                Object var3_7 = null;
            }
            catch (Throwable throwable) {
                Object var3_8 = null;
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    LookupDiscovery.this.requestors.remove(Thread.currentThread());
                    if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                        LookupDiscovery.this.respondeeThread = null;
                    }
                }
                this.sock.close();
                throw throwable;
            }
            object = LookupDiscovery.this.requestors;
            synchronized (object) {
                LookupDiscovery.this.requestors.remove(Thread.currentThread());
                if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                    LookupDiscovery.this.respondeeThread.interrupt();
                    LookupDiscovery.this.respondeeThread = null;
                }
            }
            this.sock.close();
        }
    }

    private class AnnouncementTimerThread
    extends Thread {
        private static final int INTERVAL = 120000;
        private static final int N_INTERVALS = 3;

        public AnnouncementTimerThread() {
            super("multicast announcement timer");
            this.setDaemon(true);
        }

        public synchronized void run() {
            int n = 120000;
            try {
                n = Integer.getInteger("net.jini.discovery.announce", n);
            }
            catch (SecurityException securityException) {}
            int n2 = 3 * n;
            try {
                while (!this.isInterrupted()) {
                    this.wait(n);
                    long l = System.currentTimeMillis();
                    Map map = LookupDiscovery.this.registrars;
                    synchronized (map) {
                        HashMap hashMap = (HashMap)LookupDiscovery.this.regTimes.clone();
                        Set set = hashMap.entrySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            ServiceID serviceID = (ServiceID)entry.getKey();
                            long l2 = (Long)entry.getValue();
                            long l3 = l - l2;
                            if (l3 <= (long)n2) continue;
                            IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)LookupDiscovery.this.registrars.get(serviceID);
                            Set set2 = LookupDiscovery.this.pendingDiscoveries;
                            synchronized (set2) {
                                if (LookupDiscovery.this.pendingDiscoveries.add(incomingUnicastResponse)) {
                                    LookupDiscovery.this.unicastDiscoveryTaskMgr.add(new UnicastDiscoveryTask());
                                }
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class UnicastDiscoveryTask
    implements TaskManager.Task {
        public void run() {
            int n = 60000;
            try {
                n = Integer.getInteger("net.jini.discovery.timeout", n);
            }
            catch (SecurityException securityException) {}
            while (true) {
                Object var2_2 = null;
                try {
                    Object object;
                    Object object2;
                    IncomingMulticastAnnouncement incomingMulticastAnnouncement;
                    Object object3;
                    block30: {
                        Object var9_11;
                        boolean bl = false;
                        Object object4 = LookupDiscovery.this.pendingDiscoveries;
                        synchronized (object4) {
                            object3 = LookupDiscovery.this.pendingDiscoveries.iterator();
                            if (!object3.hasNext()) {
                                LookupDiscovery.this.unicastDiscoveryTaskMgr.remove(this);
                                bl = true;
                                incomingMulticastAnnouncement = null;
                                return;
                            }
                            var2_2 = object3.next();
                            object3.remove();
                        }
                        object4 = null;
                        incomingMulticastAnnouncement = null;
                        object3 = null;
                        if (var2_2 instanceof Socket) {
                            object4 = var2_2;
                        } else if (var2_2 instanceof LookupLocator) {
                            object4 = new Socket(((LookupLocator)var2_2).getHost(), ((LookupLocator)var2_2).getPort());
                        } else if (var2_2 instanceof IncomingMulticastAnnouncement) {
                            incomingMulticastAnnouncement = var2_2;
                        } else if (var2_2 instanceof IncomingUnicastResponse) {
                            object3 = var2_2;
                        }
                        if (object4 == null) break block30;
                        try {
                            ((Socket)object4).setSoTimeout(n);
                            object2 = ((Socket)object4).getOutputStream();
                            InputStream inputStream = ((Socket)object4).getInputStream();
                            OutgoingUnicastRequest.marshal((OutputStream)object2);
                            object = new IncomingUnicastResponse(inputStream);
                        }
                        catch (Throwable throwable) {
                            var9_11 = null;
                            try {
                                ((Socket)object4).close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        var9_11 = null;
                        try {
                            ((Socket)object4).close();
                        }
                        catch (IOException iOException) {}
                        LookupDiscovery.this.maybeAddNewRegistrar((IncomingUnicastResponse)object);
                        continue;
                    }
                    if (incomingMulticastAnnouncement != null) {
                        object = incomingMulticastAnnouncement.getServiceID();
                        Map map = LookupDiscovery.this.registrars;
                        synchronized (map) {
                            object2 = (IncomingUnicastResponse)LookupDiscovery.this.registrars.get(object);
                            if (object2 != null) {
                                LookupDiscovery.this.maybeSendEvent((IncomingUnicastResponse)object2, incomingMulticastAnnouncement.getGroups());
                            }
                            continue;
                        }
                    }
                    if (object3 == null) continue;
                    object = LookupDiscovery.this.registrars;
                    synchronized (object) {
                        LookupDiscovery.this.maybeSendEvent((IncomingUnicastResponse)object3, null);
                        continue;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (Exception exception) {
                    LookupDiscovery.printException(exception);
                    continue;
                }
                break;
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }
}

