/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.IncomingUnicastResponse;
import net.jini.discovery.OutgoingUnicastRequest;

public class LookupLocatorDiscovery
implements DiscoveryManagement,
DiscoveryLocatorManagement {
    private static final int MAX_N_TASKS = 15;
    private TaskManager discoveryTaskMgr = new TaskManager(15, 15000L, 1.0f);
    private WakeupManager discoveryWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
    private final HashSet undiscoveredLocators = new HashSet(11);
    private final ArrayList discoveredLocators = new ArrayList(11);
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private final ArrayList listeners = new ArrayList(1);
    private boolean terminated = false;
    private static final int unicastSocketTimeout = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            int n = 60000;
            try {
                return Integer.getInteger("net.jini.discovery.timeout", n);
            }
            catch (SecurityException securityException) {
                return new Integer(n);
            }
        }
    });

    public LookupLocatorDiscovery(LookupLocator[] lookupLocatorArray) {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            this.discoverLocators(lookupLocatorArray);
        }
    }

    static /* synthetic */ Notifier access$3(LookupLocatorDiscovery lookupLocatorDiscovery) {
        return lookupLocatorDiscovery.notifierThread;
    }

    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new NullPointerException("can't add null listener");
        }
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.listeners.contains(discoveryListener)) {
                Object var3_3 = null;
                return;
            }
            this.listeners.add(discoveryListener);
            if (!this.discoveredLocators.isEmpty()) {
                Object object;
                HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.discoveredLocators.size());
                Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object = (LocatorReg)iterator.next();
                    hashMap.put(((LocatorReg)object).proxy, ((LocatorReg)object).memberGroups);
                    ++n;
                }
                object = new ArrayList(1);
                ((ArrayList)object).add(discoveryListener);
                this.addNotify((ArrayList)object, hashMap, false);
            }
        }
    }

    public synchronized void addLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        this.discoverLocators(lookupLocatorArray);
    }

    private void addNotify(ArrayList arrayList, Map map, boolean bl) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(arrayList, map, bl));
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier();
                this.notifierThread.start();
            }
        }
    }

    private void addToMap(LocatorReg locatorReg) {
        this.undiscoveredLocators.add(locatorReg);
        this.queueDiscoveryTask(locatorReg);
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int n = 0;
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.discoveredLocators.size()];
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            serviceRegistrarArray[n++] = locatorReg.proxy;
        }
        return serviceRegistrarArray;
    }

    private Map deepCopy(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return hashMap2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discard(ServiceRegistrar serviceRegistrar) {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (serviceRegistrar == null) {
                return;
            }
            LookupLocator lookupLocator = this.findRegFromProxy(serviceRegistrar);
            if (lookupLocator == null) return;
            LocatorReg locatorReg = this.removeDiscoveredLocator(lookupLocator);
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
            locatorReg.proxy = null;
            locatorReg.memberGroups = null;
            locatorReg.fixupNextTryTime();
            this.addToMap(locatorReg);
            if (this.listeners.isEmpty()) return;
            this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            return;
        }
    }

    private void discoverLocators(LookupLocator[] lookupLocatorArray) {
        if (lookupLocatorArray == null) {
            return;
        }
        int n = 0;
        while (n < lookupLocatorArray.length) {
            LocatorReg locatorReg;
            if (!this.isDiscovered(lookupLocatorArray[n]) && (locatorReg = this.findReg(lookupLocatorArray[n])) == null) {
                locatorReg = new LocatorReg(lookupLocatorArray[n]);
                this.addToMap(locatorReg);
            }
            ++n;
        }
    }

    private LocatorReg findReg(LookupLocator lookupLocator) {
        Iterator iterator = this.undiscoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals(lookupLocator)) continue;
            return locatorReg;
        }
        return null;
    }

    private LookupLocator findRegFromProxy(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.proxy.equals(serviceRegistrar)) continue;
            return locatorReg.l;
        }
        return null;
    }

    public synchronized LookupLocator[] getDiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int n = this.discoveredLocators.size();
        LookupLocator[] lookupLocatorArray = new LookupLocator[n];
        int n2 = 0;
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        return lookupLocatorArray;
    }

    public synchronized LookupLocator[] getLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int n = this.discoveredLocators.size() + this.undiscoveredLocators.size();
        LookupLocator[] lookupLocatorArray = new LookupLocator[n];
        int n2 = 0;
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        iterator = this.undiscoveredLocators.iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        return lookupLocatorArray;
    }

    public ServiceRegistrar[] getRegistrars() {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.discoveredLocators == null || this.discoveredLocators.isEmpty()) {
                ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[]{};
                Object var3_4 = null;
                return serviceRegistrarArray;
            }
            ServiceRegistrar[] serviceRegistrarArray = this.buildServiceRegistrar();
            Object var3_5 = null;
            return serviceRegistrarArray;
        }
    }

    public synchronized LookupLocator[] getUndiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        LookupLocator[] lookupLocatorArray = new LookupLocator[this.undiscoveredLocators.size()];
        Iterator iterator = this.undiscoveredLocators.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            lookupLocatorArray[n] = ((LocatorReg)iterator.next()).l;
            ++n;
        }
        return lookupLocatorArray;
    }

    private boolean isArrayContains(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isDiscovered(LookupLocator lookupLocator) {
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals(lookupLocator)) continue;
            return true;
        }
        return false;
    }

    private Map mapRegToGroups(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
        hashMap.put(serviceRegistrar, stringArray);
        return hashMap;
    }

    private static void printException(Exception exception) {
        try {
            if (System.getProperty("net.jini.discovery.debug") != null) {
                exception.printStackTrace();
            }
        }
        catch (SecurityException securityException) {}
    }

    private void printMap() {
        Iterator iterator = this.undiscoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            System.out.println("printMap reg:" + locatorReg.id);
        }
    }

    private void queueDiscoveryTask(LocatorReg locatorReg) {
        this.discoveryTaskMgr.add(new DiscoveryTask(locatorReg, this.discoveryTaskMgr, this.discoveryWakeupMgr));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean regTryGetProxy(LocatorReg locatorReg) {
        boolean bl = locatorReg.tryGetProxy();
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (!this.undiscoveredLocators.contains(locatorReg)) {
                return true;
            }
            if (!bl) {
                return false;
            }
            this.undiscoveredLocators.remove(locatorReg);
            this.discoveredLocators.add(locatorReg);
            if (this.listeners.isEmpty()) return true;
            this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(locatorReg.proxy, locatorReg.memberGroups), false);
            return true;
        }
    }

    private LocatorReg removeDiscoveredLocator(LookupLocator lookupLocator) {
        Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals(lookupLocator)) continue;
            iterator.remove();
            return locatorReg;
        }
        return null;
    }

    public synchronized void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int n = this.listeners.indexOf(discoveryListener);
        if (n != -1) {
            this.listeners.remove(n);
        }
    }

    public void removeLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            int n = 0;
            while (n < lookupLocatorArray.length) {
                LocatorReg locatorReg = this.removeDiscoveredLocator(lookupLocatorArray[n]);
                if (locatorReg != null) {
                    hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
                } else {
                    locatorReg = this.findReg(lookupLocatorArray[n]);
                    if (locatorReg != null) {
                        this.undiscoveredLocators.remove(locatorReg);
                    }
                }
                ++n;
            }
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    public void setLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            LocatorReg locatorReg;
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            Iterator iterator = ((AbstractList)this.discoveredLocators).iterator();
            while (iterator.hasNext()) {
                locatorReg = (LocatorReg)iterator.next();
                if (this.isArrayContains(lookupLocatorArray, locatorReg.l)) continue;
                iterator.remove();
                hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
            }
            iterator = this.undiscoveredLocators.iterator();
            while (iterator.hasNext()) {
                locatorReg = (LocatorReg)iterator.next();
                if (this.isArrayContains(lookupLocatorArray, locatorReg.l)) continue;
                iterator.remove();
            }
            this.discoverLocators(lookupLocatorArray);
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    public synchronized void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.terminateTaskMgr();
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.clear();
        }
    }

    private void terminateTaskMgr() {
        if (this.discoveryWakeupMgr != null) {
            this.discoveryWakeupMgr.cancelAll();
            this.discoveryWakeupMgr.stop();
        }
        if (this.discoveryTaskMgr != null) {
            ArrayList arrayList = this.discoveryTaskMgr.getPending();
            int n = 0;
            while (n < arrayList.size()) {
                RetryTask retryTask = (RetryTask)arrayList.get(n);
                retryTask.cancel();
                this.discoveryTaskMgr.remove(retryTask);
                ++n;
            }
            this.discoveryTaskMgr.terminate();
            this.discoveryTaskMgr = null;
            this.discoveryWakeupMgr = null;
        }
    }

    private void testSetForNull(LookupLocator[] lookupLocatorArray) {
        if (lookupLocatorArray == null) {
            throw new NullPointerException("null locator array");
        }
        int n = 0;
        while (n < lookupLocatorArray.length) {
            if (lookupLocatorArray[n] == null) {
                throw new NullPointerException("null element in locator array");
            }
            ++n;
        }
    }

    private static class LocatorReg {
        public ServiceRegistrar proxy = null;
        public final LookupLocator l;
        public String[] memberGroups = null;
        private static int cnt = 0;
        private static final long MIN_RETRY = 15000L;
        private static final long[] sleepTime = new long[]{5000L, 10000L, 20000L, 30000L, 60000L, 120000L, 240000L, 480000L, 900000L};
        private int tryIndx = 0;
        private long nextTryTime;
        private final int id = cnt++;
        private long time = 0L;

        public LocatorReg(LookupLocator lookupLocator) {
            this.l = lookupLocator;
            this.nextTryTime = System.currentTimeMillis();
        }

        public void calcNextTryTime() {
            this.nextTryTime = System.currentTimeMillis() + sleepTime[this.tryIndx];
            if (this.tryIndx < sleepTime.length - 1) {
                ++this.tryIndx;
            }
        }

        private void doUnicastDiscovery(LookupLocator lookupLocator) throws UnknownHostException, SocketException, IOException, ClassNotFoundException {
            Socket socket = new Socket(lookupLocator.getHost(), lookupLocator.getPort());
            try {
                socket.setSoTimeout(unicastSocketTimeout);
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = socket.getInputStream();
                OutgoingUnicastRequest.marshal(outputStream);
                IncomingUnicastResponse incomingUnicastResponse = new IncomingUnicastResponse(inputStream);
                this.proxy = incomingUnicastResponse.getRegistrar();
                this.memberGroups = incomingUnicastResponse.getGroups();
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            Object var4_6 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }

        public boolean equals(Object object) {
            if (!(object instanceof LocatorReg)) {
                return false;
            }
            return this.l.equals(((LocatorReg)object).l);
        }

        public void fixupNextTryTime() {
            long l = System.currentTimeMillis();
            if (l - this.time > 15000L) {
                this.tryIndx = 0;
                this.nextTryTime = l;
            } else {
                this.calcNextTryTime();
            }
        }

        public synchronized long getNextTryTime() {
            return this.nextTryTime;
        }

        public int hashCode() {
            return this.l.hashCode();
        }

        public boolean tryGetProxy() {
            if (this.proxy != null) {
                throw new IllegalArgumentException("LookupLocator has been discovered already");
            }
            try {
                this.doUnicastDiscovery(this.l);
                this.time = System.currentTimeMillis();
                return true;
            }
            catch (Exception exception) {
                LookupLocatorDiscovery.printException(exception);
                this.calcNextTryTime();
                return false;
            }
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final boolean discard;

        public NotifyTask(ArrayList arrayList, Map map, boolean bl) {
            this.listeners = arrayList;
            this.groupsMap = map;
            this.discard = bl;
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event notifier");
            this.setDaemon(true);
        }

        public void run() {
            block3: while (true) {
                NotifyTask notifyTask;
                DiscoveryListener discoveryListener;
                Object object = LookupLocatorDiscovery.this.pendingNotifies;
                synchronized (object) {
                    if (LookupLocatorDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupLocatorDiscovery.this.notifierThread = null;
                        discoveryListener = null;
                        return;
                    }
                    notifyTask = (NotifyTask)LookupLocatorDiscovery.this.pendingNotifies.removeFirst();
                }
                object = ((AbstractList)notifyTask.listeners).iterator();
                while (true) {
                    if (!object.hasNext()) continue block3;
                    discoveryListener = (DiscoveryListener)object.next();
                    DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)LookupLocatorDiscovery.this, LookupLocatorDiscovery.this.deepCopy((HashMap)notifyTask.groupsMap));
                    if (notifyTask.discard) {
                        discoveryListener.discarded(discoveryEvent);
                        continue;
                    }
                    discoveryListener.discovered(discoveryEvent);
                }
                break;
            }
        }
    }

    private class DiscoveryTask
    extends RetryTask {
        private LocatorReg reg;

        public DiscoveryTask(LocatorReg locatorReg, TaskManager taskManager, WakeupManager wakeupManager) {
            super(taskManager, wakeupManager);
            this.reg = locatorReg;
        }

        public long retryTime() {
            return this.reg.getNextTryTime();
        }

        public boolean runAfter(List list, int n) {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean tryOnce() {
            LookupLocatorDiscovery lookupLocatorDiscovery = LookupLocatorDiscovery.this;
            synchronized (lookupLocatorDiscovery) {
                if (LookupLocatorDiscovery.this.undiscoveredLocators.isEmpty()) {
                    return true;
                }
                if (LookupLocatorDiscovery.this.undiscoveredLocators.contains(this.reg)) return LookupLocatorDiscovery.this.regTryGetProxy(this.reg);
                return true;
            }
        }
    }
}

