/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.Constants;

public class OutgoingMulticastRequest {
    protected static final int minMaxPacketSize = 512;
    protected static final int maxPacketSize = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return Integer.getInteger("net.jini.discovery.mtu", 512);
            }
            catch (SecurityException securityException) {
                return new Integer(512);
            }
        }
    });
    protected static final int protocolVersion = 1;

    public static DatagramPacket[] marshal(int n, String[] stringArray, ServiceID[] serviceIDArray) throws IOException {
        Object object;
        DatagramPacket[] datagramPacketArray;
        Object object2;
        Object object3;
        if (maxPacketSize < 512) {
            throw new RuntimeException("value of net.jini.discovery.mtu property is less than 512");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(n);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[][] byArray2 = new byte[stringArray.length][];
        int n2 = -1;
        int n3 = 0;
        while (n3 < stringArray.length) {
            object3 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream((OutputStream)object3);
            dataOutputStream2.writeUTF(stringArray[n3]);
            dataOutputStream2.flush();
            byArray2[n3] = ((ByteArrayOutputStream)object3).toByteArray();
            if (byArray.length + 4 + 4 + byArray2[n3].length > maxPacketSize) {
                throw new IllegalArgumentException("group name marshals too large (" + byArray2[n3].length + " bytes)");
            }
            if (byArray2[n3].length > n2) {
                n2 = byArray2[n3].length;
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream2);
        int n6 = 0;
        while (n6 < serviceIDArray.length) {
            serviceIDArray[n6].writeBytes(dataOutputStream3);
            n4 = n5;
            n5 = byteArrayOutputStream2.size();
            if (byArray.length + 4 + n2 + 4 + n5 > maxPacketSize) break;
            ++n6;
        }
        dataOutputStream3.flush();
        byteArrayOutputStream2.flush();
        byte[] byArray3 = byteArrayOutputStream2.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
        dataOutputStream4.writeInt(n6);
        dataOutputStream4.write(byArray3, 0, n6 == serviceIDArray.length ? n5 : n4);
        dataOutputStream4.flush();
        object3 = byteArrayOutputStream3.toByteArray();
        Vector<DatagramPacket> vector = new Vector<DatagramPacket>();
        InetAddress inetAddress = Constants.getRequestAddress();
        if (stringArray.length == 0) {
            object2 = new ByteArrayOutputStream(maxPacketSize);
            datagramPacketArray = new DataOutputStream((OutputStream)object2);
            datagramPacketArray.write(byArray);
            datagramPacketArray.write((byte[])object3);
            datagramPacketArray.writeInt(0);
            datagramPacketArray.flush();
            object = ((ByteArrayOutputStream)object2).toByteArray();
            vector.add(new DatagramPacket((byte[])object, ((Object)object).length, inetAddress, 4160));
        } else {
            int n7 = 0;
            while (n7 < byArray2.length) {
                datagramPacketArray = new ByteArrayOutputStream(maxPacketSize);
                object = new DataOutputStream((OutputStream)datagramPacketArray);
                ((FilterOutputStream)object).write(byArray);
                ((FilterOutputStream)object).write((byte[])object3);
                ((DataOutputStream)object).flush();
                int n8 = datagramPacketArray.size() + 4;
                int n9 = n7;
                while (n9 < byArray2.length && n8 + byArray2[n9].length <= maxPacketSize) {
                    n8 += byArray2[n9].length;
                    ++n9;
                }
                ((DataOutputStream)object).writeInt(n9 - n7);
                while (n7 < n9) {
                    ((FilterOutputStream)object).write(byArray2[n7++]);
                }
                ((DataOutputStream)object).flush();
                byte[] byArray4 = datagramPacketArray.toByteArray();
                vector.add(new DatagramPacket(byArray4, byArray4.length, inetAddress, 4160));
            }
        }
        object2 = vector.iterator();
        datagramPacketArray = new DatagramPacket[vector.size()];
        int n10 = 0;
        while (object2.hasNext()) {
            datagramPacketArray[n10] = (DatagramPacket)object2.next();
            ++n10;
        }
        return datagramPacketArray;
    }
}

