/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceIDListener;

public class JoinManager {
    private static final int MAX_N_TASKS = 15;
    private int taskSeqN = 0;
    private TaskManager taskMgr = new TaskManager(15, 15000L, 1.0f);
    private int maxNRetries = 6;
    private WakeupManager wakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
    private ServiceItem serviceItem;
    private Entry[] lookupAttr = null;
    private ServiceIDListener callback;
    private final ArrayList joinSet = new ArrayList(1);
    private DiscoveryManagement discMgr = null;
    private DiscMgrListener discMgrListener = new DiscMgrListener();
    private boolean bCreateDiscMgr = false;
    private LeaseRenewalManager leaseRenewalMgr = null;
    private boolean bTerminated = false;

    public JoinManager(Object object, Entry[] entryArray, ServiceID serviceID, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        this.discMgr = discoveryManagement;
        this.createJoinManager(serviceID, object, entryArray, this.callback, leaseRenewalManager);
    }

    public JoinManager(Object object, Entry[] entryArray, ServiceIDListener serviceIDListener, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        this.discMgr = discoveryManagement;
        this.createJoinManager(null, object, entryArray, serviceIDListener, leaseRenewalManager);
    }

    public void addAttributes(Entry[] entryArray) {
        this.addAttributes(entryArray, false);
    }

    public void addAttributes(Entry[] entryArray, boolean bl) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = LookupAttributes.add(this.lookupAttr, entryArray, bl);
            this.serviceItem.attributeSets = this.lookupAttr;
            int n = 0;
            while (n < this.joinSet.size()) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(n);
                proxyReg.addTask(new AddAttributesTask(proxyReg, entryArray));
                ++n;
            }
        }
    }

    private ServiceRegistrar[] buildServiceRegistrar(ArrayList arrayList) {
        int n = 0;
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[arrayList.size()];
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            serviceRegistrarArray[n++] = proxyReg.proxy;
        }
        return serviceRegistrarArray;
    }

    private void createJoinManager(ServiceID serviceID, Object object, Entry[] entryArray, ServiceIDListener serviceIDListener, LeaseRenewalManager leaseRenewalManager) throws IOException {
        if (!(object instanceof Serializable)) {
            if (object instanceof Remote) {
                try {
                    RemoteObject.toStub((Remote)object);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new IllegalArgumentException("obj must be Serializable or a RemoteStub or an exported RemoteObject");
                }
            } else {
                throw new IllegalArgumentException("obj must be Serializable or a RemoteStub or an exported RemoteObject");
            }
        }
        try {
            this.maxNRetries = Integer.getInteger("com.sun.jini.join.retries", this.maxNRetries);
        }
        catch (SecurityException securityException) {}
        if (entryArray == null) {
            this.lookupAttr = new Entry[0];
        } else {
            LookupAttributes.check(entryArray, false);
            this.lookupAttr = (Entry[])entryArray.clone();
        }
        this.serviceItem = new ServiceItem(serviceID, object, this.lookupAttr);
        this.leaseRenewalMgr = leaseRenewalManager != null ? leaseRenewalManager : new LeaseRenewalManager();
        this.callback = serviceIDListener;
        if (this.discMgr == null) {
            this.bCreateDiscMgr = true;
            this.discMgr = new LookupDiscoveryManager(new String[]{""}, null, null);
        }
        this.discMgr.addDiscoveryListener(this.discMgrListener);
    }

    private ProxyReg findReg(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = ((AbstractList)this.joinSet).iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            if (!proxyReg.proxy.equals(serviceRegistrar)) continue;
            return proxyReg;
        }
        return null;
    }

    public Entry[] getAttributes() {
        Entry[] entryArray = this;
        synchronized (entryArray) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            entryArray = (Entry[])this.lookupAttr.clone();
            Object var3_3 = null;
            return entryArray;
        }
    }

    public DiscoveryManagement getDiscoveryManager() {
        JoinManager joinManager = this;
        synchronized (joinManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        return this.discMgr;
    }

    public ServiceRegistrar[] getJoinSet() {
        ServiceRegistrar[] serviceRegistrarArray = this;
        synchronized (serviceRegistrarArray) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            ArrayList<ServiceRegistrar> arrayList2 = new ArrayList<ServiceRegistrar>(this.joinSet.size());
            boolean bl = false;
            Iterator iterator = ((AbstractList)this.joinSet).iterator();
            while (iterator.hasNext()) {
                ProxyReg proxyReg = (ProxyReg)iterator.next();
                if (proxyReg.srvcRegistration == null) continue;
                arrayList2.add(proxyReg.proxy);
            }
            serviceRegistrarArray = arrayList2.toArray(new ServiceRegistrar[arrayList2.size()]);
            Object var3_7 = null;
            return serviceRegistrarArray;
        }
    }

    public LeaseRenewalManager getLeaseRenewalManager() {
        JoinManager joinManager = this;
        synchronized (joinManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        return this.leaseRenewalMgr;
    }

    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2) {
        this.modifyAttributes(entryArray, entryArray2, false);
    }

    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2, boolean bl) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = LookupAttributes.modify(this.lookupAttr, entryArray, entryArray2, bl);
            this.serviceItem.attributeSets = this.lookupAttr;
            int n = 0;
            while (n < this.joinSet.size()) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(n);
                proxyReg.addTask(new ModifyAttributesTask(proxyReg, entryArray, entryArray2));
                ++n;
            }
        }
    }

    private static void printException(Throwable throwable) {
        try {
            if (System.getProperty("com.sun.jini.join.debug") != null) {
                throwable.printStackTrace();
            }
        }
        catch (SecurityException securityException) {}
    }

    private void removeJoinSet(ProxyReg proxyReg) {
        if (proxyReg.proxy == null) {
            throw new IllegalArgumentException("bad proxy");
        }
        Lease lease = null;
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            ((AbstractCollection)this.joinSet).remove(proxyReg);
            if (proxyReg.srvcRegistration != null) {
                lease = proxyReg.srvcRegistration.getLease();
            }
        }
        if (lease == null) {
            return;
        }
        try {
            this.leaseRenewalMgr.cancel(lease);
        }
        catch (Exception exception) {}
    }

    private void removePendingTasks(ProxyReg proxyReg) {
        if (proxyReg == null) {
            return;
        }
        if (this.taskMgr == null) {
            return;
        }
        TaskManager taskManager = this.taskMgr;
        synchronized (taskManager) {
            ArrayList arrayList = this.taskMgr.getPending();
            int n = 0;
            while (n < arrayList.size()) {
                ProxyRegTask proxyRegTask = (ProxyRegTask)arrayList.get(n);
                if (proxyReg.equals(proxyRegTask.getProxyReg())) {
                    this.taskMgr.remove(proxyRegTask);
                    List list = proxyReg.taskList;
                    synchronized (list) {
                        proxyReg.taskList.clear();
                    }
                }
                ++n;
            }
        }
    }

    public void setAttributes(Entry[] entryArray) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        this.testForNullElement(entryArray);
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = (Entry[])entryArray.clone();
            this.serviceItem.attributeSets = this.lookupAttr;
            int n = 0;
            while (n < this.joinSet.size()) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(n);
                proxyReg.addTask(new SetAttributesTask(proxyReg, entryArray));
                ++n;
            }
        }
    }

    public void terminate() {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                Object var2_2 = null;
                return;
            }
            this.bTerminated = true;
            this.discMgr.removeDiscoveryListener(this.discMgrListener);
            if (this.bCreateDiscMgr) {
                this.discMgr.terminate();
            }
        }
        this.terminateTaskMgr();
        object = null;
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            object = new ArrayList(this.joinSet.size());
            Iterator iterator = ((AbstractList)this.joinSet).iterator();
            while (iterator.hasNext()) {
                ((ArrayList)object).add(((ProxyReg)iterator.next()).srvcRegistration.getLease());
            }
            this.joinSet.clear();
        }
        if (object == null) {
            return;
        }
        int n = 0;
        while (n < ((ArrayList)object).size()) {
            try {
                this.leaseRenewalMgr.cancel((Lease)((ArrayList)object).get(n));
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    private void terminateTaskMgr() {
        WakeupManager wakeupManager = this.wakeupMgr;
        synchronized (wakeupManager) {
            this.wakeupMgr.cancelAll();
            this.wakeupMgr.stop();
            TaskManager taskManager = this.taskMgr;
            synchronized (taskManager) {
                ArrayList arrayList = this.taskMgr.getPending();
                int n = 0;
                while (n < arrayList.size()) {
                    RetryTask retryTask = (RetryTask)arrayList.get(n);
                    retryTask.cancel();
                    this.taskMgr.remove(retryTask);
                    ++n;
                }
                this.taskMgr.terminate();
                this.taskMgr = null;
            }
            this.wakeupMgr = null;
        }
    }

    private void testForNullElement(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                throw new NullPointerException("input array contains at least one null element");
            }
            ++n;
        }
    }

    private class ProxyRegTask
    extends RetryTask {
        private final long[] sleepTime = new long[]{5000L, 10000L, 15000L, 20000L, 25000L, 30000L};
        protected int tryIndx = 0;
        protected int nRetries = 0;
        protected ProxyReg proxyReg;
        protected int seqN;

        ProxyRegTask(ProxyReg proxyReg, int n) {
            super(JoinManager.this.taskMgr, JoinManager.this.wakeupMgr);
            this.proxyReg = proxyReg;
            this.seqN = n;
        }

        public ProxyReg getProxyReg() {
            return this.proxyReg;
        }

        public int getSeqN() {
            return this.seqN;
        }

        public long retryTime() {
            long l = System.currentTimeMillis() + this.sleepTime[this.tryIndx];
            if (this.tryIndx < this.sleepTime.length - 1) {
                ++this.tryIndx;
            }
            ++this.nRetries;
            return l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean runAfter(List list, int n) {
            ServiceItem serviceItem = JoinManager.this.serviceItem;
            synchronized (serviceItem) {
                if (((JoinManager)JoinManager.this).serviceItem.serviceID != null) {
                    return false;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    TaskManager.Task task = (TaskManager.Task)iterator.next();
                    int n2 = ((ProxyRegTask)task).getSeqN();
                    if (this.seqN <= n2) continue;
                    return true;
                }
                return false;
            }
        }

        protected boolean stopTrying(Exception exception) {
            int n = ThrowableConstants.retryable(exception);
            if (n != 0 || this.nRetries >= JoinManager.this.maxNRetries) {
                ArrayList arrayList = JoinManager.this.joinSet;
                synchronized (arrayList) {
                    JoinManager.this.removePendingTasks(this.proxyReg);
                }
                this.cancel();
                this.proxyReg.fail(exception);
                return true;
            }
            JoinManager.printException(exception);
            return false;
        }

        public boolean tryOnce() {
            while (true) {
                JoinTask joinTask = null;
                List list = this.proxyReg.taskList;
                synchronized (list) {
                    if (this.proxyReg.taskList.isEmpty()) {
                        boolean bl = true;
                        Object var4_6 = null;
                        return bl;
                    }
                    joinTask = (JoinTask)this.proxyReg.taskList.get(0);
                }
                try {
                    joinTask.run();
                    List list2 = this.proxyReg.taskList;
                    synchronized (list2) {
                        if (!this.proxyReg.taskList.isEmpty()) {
                            this.proxyReg.taskList.remove(0);
                        }
                    }
                    this.tryIndx = 0;
                    this.nRetries = 0;
                }
                catch (Exception exception) {
                    return this.stopTrying(exception);
                }
            }
        }
    }

    private abstract class JoinTask {
        protected ProxyReg proxyReg;

        JoinTask(ProxyReg proxyReg) {
            this.proxyReg = proxyReg;
        }

        public abstract void run() throws Exception;
    }

    private class RegisterTask
    extends JoinTask {
        Entry[] regAttrs;

        RegisterTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg);
            this.regAttrs = entryArray;
        }

        public void run() throws Exception {
            this.proxyReg.register(this.regAttrs);
        }
    }

    private class LeaseExpireNotifyTask
    extends JoinTask {
        Entry[] regAttrs;

        LeaseExpireNotifyTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg);
            this.regAttrs = entryArray;
        }

        public void run() throws Exception {
            boolean bl = false;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                bl = JoinManager.this.joinSet.contains(this.proxyReg);
            }
            if (bl) {
                this.proxyReg.register(this.regAttrs);
            }
        }
    }

    private class DiscardProxyTask
    extends JoinTask {
        DiscardProxyTask(ProxyReg proxyReg) {
            super(proxyReg);
        }

        public void run() {
            JoinManager.this.removeJoinSet(this.proxyReg);
        }
    }

    private class AddAttributesTask
    extends JoinTask {
        protected Entry[] attrSets;

        AddAttributesTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg);
            this.attrSets = (Entry[])entryArray.clone();
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            proxyReg.addAttributes(this.attrSets);
        }

        public void run() throws Exception {
            this.doAttributes(this.proxyReg);
        }
    }

    private final class SetAttributesTask
    extends AddAttributesTask {
        SetAttributesTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg, entryArray);
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            proxyReg.setAttributes(this.attrSets);
        }
    }

    private final class ModifyAttributesTask
    extends AddAttributesTask {
        private Entry[] attrSetTemplates;

        ModifyAttributesTask(ProxyReg proxyReg, Entry[] entryArray, Entry[] entryArray2) {
            super(proxyReg, entryArray2);
            this.attrSetTemplates = (Entry[])entryArray.clone();
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            proxyReg.modifyAttributes(this.attrSetTemplates, this.attrSets);
        }
    }

    private class ProxyReg {
        public ServiceRegistrar proxy;
        public ServiceRegistration srvcRegistration = null;
        public List taskList = new ArrayList(1);
        private DiscLeaseListener dListener = new DiscLeaseListener();

        public ProxyReg(ServiceRegistrar serviceRegistrar) {
            if (serviceRegistrar == null) {
                throw new IllegalArgumentException("proxy can't be null");
            }
            this.proxy = serviceRegistrar;
        }

        public void addAttributes(Entry[] entryArray) throws Exception {
            this.srvcRegistration.addAttributes(entryArray);
        }

        public void addTask(JoinTask joinTask) {
            Object object = JoinManager.this;
            synchronized (object) {
                if (JoinManager.this.bTerminated) {
                    Object var3_3 = null;
                    return;
                }
            }
            object = this.taskList;
            synchronized (object) {
                if (this.taskList.isEmpty()) {
                    this.taskList.add(joinTask);
                    TaskManager taskManager = JoinManager.this.taskMgr;
                    synchronized (taskManager) {
                        TaskManager taskManager2 = JoinManager.this.taskMgr;
                        JoinManager joinManager = JoinManager.this;
                        int n = joinManager.taskSeqN;
                        joinManager.taskSeqN = n + 1;
                        taskManager2.add(new ProxyRegTask(this, n));
                    }
                } else {
                    this.taskList.add(joinTask);
                }
            }
        }

        public boolean equals(Object object) {
            if (object instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)object).proxy);
            }
            return false;
        }

        public void fail(Throwable throwable) {
            ProxyReg proxyReg = this;
            synchronized (proxyReg) {
                if (JoinManager.this.bTerminated) {
                    Object var3_3 = null;
                    return;
                }
                JoinManager.printException(throwable);
                try {
                    JoinManager.this.discMgr.discard(this.proxy);
                }
                catch (IllegalStateException illegalStateException) {
                    JoinManager.printException(illegalStateException);
                }
            }
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }

        public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2) throws Exception {
            this.srvcRegistration.modifyAttributes(entryArray, entryArray2);
        }

        public void register(Entry[] entryArray) throws Exception {
            if (this.proxy == null) {
                throw new RuntimeException("proxy is null");
            }
            ServiceItem serviceItem = null;
            Object object = JoinManager.this.joinSet;
            synchronized (object) {
                this.srvcRegistration = null;
                serviceItem = new ServiceItem(((JoinManager)JoinManager.this).serviceItem.serviceID, ((JoinManager)JoinManager.this).serviceItem.service, entryArray);
            }
            object = this.proxy.register(serviceItem, Long.MAX_VALUE);
            Lease lease = object.getLease();
            JoinManager.this.leaseRenewalMgr.renewUntil(lease, Long.MAX_VALUE, this.dListener);
            Serializable serializable = JoinManager.this.joinSet;
            synchronized (serializable) {
                this.srvcRegistration = object;
            }
            serializable = JoinManager.this.serviceItem;
            synchronized (serializable) {
                if (((JoinManager)JoinManager.this).serviceItem.serviceID == null) {
                    ((JoinManager)JoinManager.this).serviceItem.serviceID = this.srvcRegistration.getServiceID();
                    if (JoinManager.this.callback != null) {
                        JoinManager.this.callback.serviceIDNotify(((JoinManager)JoinManager.this).serviceItem.serviceID);
                    }
                }
            }
        }

        public void setAttributes(Entry[] entryArray) throws Exception {
            this.srvcRegistration.setAttributes(entryArray);
        }

        private class DiscLeaseListener
        implements LeaseListener {
            DiscLeaseListener() {
            }

            public void notify(LeaseRenewalEvent leaseRenewalEvent) {
                Throwable throwable = leaseRenewalEvent.getException();
                if (throwable == null || throwable instanceof UnknownLeaseException) {
                    ArrayList arrayList = JoinManager.this.joinSet;
                    synchronized (arrayList) {
                        JoinManager.this.removePendingTasks(ProxyReg.this);
                        JoinManager joinManager = JoinManager.this;
                        joinManager.getClass();
                        ProxyReg.this.addTask(joinManager.new LeaseExpireNotifyTask(ProxyReg.this, (Entry[])JoinManager.this.lookupAttr.clone()));
                    }
                } else {
                    ProxyReg.this.fail(throwable);
                }
            }
        }
    }

    private class DiscMgrListener
    implements DiscoveryListener {
        DiscMgrListener() {
        }

        public void discarded(DiscoveryEvent discoveryEvent) {
            Object var2_2 = null;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
                int n = 0;
                while (n < serviceRegistrarArray.length) {
                    ProxyReg proxyReg = JoinManager.this.findReg(serviceRegistrarArray[n]);
                    if (proxyReg != null) {
                        JoinManager.this.removePendingTasks(proxyReg);
                        proxyReg.addTask(new DiscardProxyTask(proxyReg));
                    }
                    ++n;
                }
            }
        }

        public void discovered(DiscoveryEvent discoveryEvent) {
            Object var2_2 = null;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
                int n = 0;
                while (n < serviceRegistrarArray.length) {
                    if (!serviceRegistrarArray[n].equals(((JoinManager)JoinManager.this).serviceItem.service)) {
                        ProxyReg proxyReg = new ProxyReg(serviceRegistrarArray[n]);
                        if (!JoinManager.this.joinSet.contains(proxyReg)) {
                            JoinManager.this.joinSet.add(proxyReg);
                            proxyReg.addTask(new RegisterTask(proxyReg, (Entry[])JoinManager.this.lookupAttr.clone()));
                        }
                    }
                    ++n;
                }
            }
        }
    }
}

