/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup;

import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceItemFilter;

public class ServiceDiscoveryManager {
    private DiscoveryManagement discMgr;
    private boolean discMgrInternal;
    private DiscMgrListener discMgrListener;
    private LeaseRenewalManager leaseRenewalMgr;
    private final ArrayList proxyRegSet = new ArrayList(1);
    private final ArrayList listeners = new ArrayList(1);
    private final Random random = new Random();
    private final ArrayList caches = new ArrayList(1);
    private int nTaskThreads = 10;
    private boolean bTerminated = false;

    public ServiceDiscoveryManager(DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        try {
            this.nTaskThreads = Integer.getInteger("com.sun.jini.sdm.nTaskThreads", this.nTaskThreads);
        }
        catch (SecurityException securityException) {}
        DiscMgrListener discMgrListener = new DiscMgrListener();
        LeaseRenewalManager leaseRenewalManager2 = this.leaseRenewalMgr = leaseRenewalManager != null ? leaseRenewalManager : new LeaseRenewalManager();
        if (discoveryManagement == null) {
            this.discMgr = new LookupDiscoveryManager(new String[]{""}, null, null);
            this.discMgrInternal = true;
        } else {
            this.discMgr = discoveryManagement;
            this.discMgrInternal = false;
        }
        this.discMgr.addDiscoveryListener(discMgrListener);
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int n = 0;
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.proxyRegSet.size()];
        Iterator iterator = ((AbstractList)this.proxyRegSet).iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            serviceRegistrarArray[n++] = proxyReg.proxy;
        }
        return serviceRegistrarArray;
    }

    private void cacheAddProxy(ProxyReg proxyReg) {
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.caches).iterator();
            while (iterator.hasNext()) {
                LookupCacheImpl lookupCacheImpl = (LookupCacheImpl)iterator.next();
                lookupCacheImpl.addProxyReg(proxyReg);
            }
        }
    }

    private void cancelLease(Lease lease) {
        try {
            this.leaseRenewalMgr.cancel(lease);
        }
        catch (Exception exception) {
            ServiceDiscoveryManager.printThrowable(exception);
        }
    }

    private void checkTerminated() {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("service discovery manager was terminated");
            }
        }
    }

    private static ServiceTemplate copyServiceTemplate(ServiceTemplate serviceTemplate) {
        int n;
        Class[] classArray = null;
        Entry[] entryArray = null;
        if (serviceTemplate.serviceTypes != null) {
            n = serviceTemplate.serviceTypes.length;
            classArray = new Class[n];
            System.arraycopy(serviceTemplate.serviceTypes, 0, classArray, 0, n);
        }
        if (serviceTemplate.attributeSetTemplates != null) {
            n = serviceTemplate.attributeSetTemplates.length;
            entryArray = new Entry[n];
            System.arraycopy(serviceTemplate.attributeSetTemplates, 0, entryArray, 0, n);
        }
        return new ServiceTemplate(serviceTemplate.serviceID, classArray, entryArray);
    }

    public LookupCache createLookupCache(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, ServiceDiscoveryListener serviceDiscoveryListener) throws RemoteException {
        this.checkTerminated();
        return this.createLookupCache(serviceTemplate, serviceItemFilter, serviceDiscoveryListener, Long.MAX_VALUE);
    }

    private LookupCacheImpl createLookupCache(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, ServiceDiscoveryListener serviceDiscoveryListener, long l) throws RemoteException {
        if (serviceTemplate == null) {
            serviceTemplate = new ServiceTemplate(null, null, null);
        }
        LookupCacheImpl lookupCacheImpl = new LookupCacheImpl(serviceTemplate, serviceItemFilter, serviceDiscoveryListener, l);
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            this.caches.add(lookupCacheImpl);
        }
        return lookupCacheImpl;
    }

    private void discard(ServiceRegistrar serviceRegistrar) {
        this.discMgr.discard(serviceRegistrar);
    }

    private void dropProxy(ProxyReg proxyReg) {
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.caches).iterator();
            while (iterator.hasNext()) {
                LookupCacheImpl lookupCacheImpl = (LookupCacheImpl)iterator.next();
                lookupCacheImpl.removeProxyReg(proxyReg);
            }
        }
    }

    private void fail(Throwable throwable, ServiceRegistrar serviceRegistrar) {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            if (this.bTerminated) {
                Object var4_4 = null;
                return;
            }
            if (throwable != null) {
                ServiceDiscoveryManager.printThrowable(throwable);
            }
            try {
                this.discard(serviceRegistrar);
            }
            catch (IllegalStateException illegalStateException) {
                ServiceDiscoveryManager.printThrowable(illegalStateException);
            }
        }
    }

    private ProxyReg findReg(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = ((AbstractList)this.proxyRegSet).iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            if (!proxyReg.proxy.equals(serviceRegistrar)) continue;
            return proxyReg;
        }
        return null;
    }

    public DiscoveryManagement getDiscoveryManager() {
        this.checkTerminated();
        return this.discMgr;
    }

    public LeaseRenewalManager getLeaseRenewalManager() {
        this.checkTerminated();
        return this.leaseRenewalMgr;
    }

    private ServiceItem getMatchedServiceItem(ServiceMatches serviceMatches, ServiceItemFilter serviceItemFilter) {
        int n = serviceMatches.items.length;
        if (n > 0) {
            int n2 = Math.abs(this.random.nextInt()) % n;
            int n3 = 0;
            while (n3 < n) {
                ServiceItem serviceItem = serviceMatches.items[(n3 + n2) % n];
                if (serviceItem != null && (serviceItemFilter == null || serviceItemFilter.check(serviceItem))) {
                    return serviceItem;
                }
                ++n3;
            }
        }
        return null;
    }

    private static boolean isArrayContainsServiceItem(ArrayList arrayList, ServiceItem serviceItem) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ServiceItem)) continue;
            ServiceItem serviceItem2 = (ServiceItem)e;
            if (!serviceItem2.serviceID.equals(serviceItem.serviceID) || !LookupAttributes.equal(serviceItem2.attributeSets, serviceItem.attributeSets) || !serviceItem2.service.equals(serviceItem.service)) continue;
            return true;
        }
        return false;
    }

    private void listenerDiscovered(ServiceRegistrar serviceRegistrar, ArrayList arrayList) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)this, new ServiceRegistrar[]{serviceRegistrar});
            ((DiscoveryListener)iterator.next()).discovered(discoveryEvent);
        }
    }

    private void listenerDropped(ArrayList arrayList, ArrayList arrayList2) {
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[arrayList.size()];
        arrayList.toArray(serviceRegistrarArray);
        this.listenerDropped(serviceRegistrarArray, arrayList2);
    }

    private void listenerDropped(ServiceRegistrar[] serviceRegistrarArray, ArrayList arrayList) {
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)this, (ServiceRegistrar[])serviceRegistrarArray.clone());
            ((DiscoveryListener)iterator.next()).discarded(discoveryEvent);
        }
    }

    public ServiceItem[] lookup(ServiceTemplate serviceTemplate, int n, int n2, ServiceItemFilter serviceItemFilter, long l) throws InterruptedException, RemoteException {
        this.checkTerminated();
        if (n < 1) {
            throw new IllegalArgumentException("minMatches must be > 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("maxMatches must be > minMatches");
        }
        ServiceItem[] serviceItemArray = this.lookup(serviceTemplate, n2, serviceItemFilter);
        if (serviceItemArray.length >= n) {
            return serviceItemArray;
        }
        ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(serviceItemArray.length);
        int n3 = 0;
        while (n3 < serviceItemArray.length) {
            arrayList.add(serviceItemArray[n3]);
            ++n3;
        }
        ServiceItem[] serviceItemArray2 = new ServiceDiscoveryListenerImpl();
        LookupCacheImpl lookupCacheImpl = null;
        ServiceItem[] serviceItemArray3 = serviceItemArray2;
        synchronized (serviceItemArray3) {
            lookupCacheImpl = this.createLookupCache(serviceTemplate, serviceItemFilter, (ServiceDiscoveryListener)serviceItemArray2, l);
            long l2 = lookupCacheImpl.getLeaseDuration();
            while (l2 > 0L) {
                serviceItemArray2.wait(l2);
                ServiceItem[] serviceItemArray4 = serviceItemArray2.getServiceItem();
                int n4 = 0;
                while (n4 < serviceItemArray4.length) {
                    if (!ServiceDiscoveryManager.isArrayContainsServiceItem(arrayList, serviceItemArray4[n4])) {
                        arrayList.add(serviceItemArray4[n4]);
                    }
                    ++n4;
                }
                if (arrayList.size() == n) break;
                l2 = lookupCacheImpl.getLeaseDuration();
            }
        }
        lookupCacheImpl.terminate();
        serviceItemArray3 = new ServiceItem[arrayList.size()];
        arrayList.toArray(serviceItemArray3);
        return serviceItemArray3;
    }

    public ServiceItem[] lookup(ServiceTemplate serviceTemplate, int n, ServiceItemFilter serviceItemFilter) {
        ServiceRegistrar[] serviceRegistrarArray;
        this.checkTerminated();
        if (n < 1) {
            throw new IllegalArgumentException("maxMatches must be > 0");
        }
        ArrayList arrayList = this.proxyRegSet;
        synchronized (arrayList) {
            serviceRegistrarArray = this.buildServiceRegistrar();
        }
        int n2 = serviceRegistrarArray.length;
        ArrayList<ServiceItem> arrayList2 = new ArrayList<ServiceItem>(n2);
        if (n2 > 0) {
            int n3 = Math.abs(this.random.nextInt()) % n2;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n;
                ServiceRegistrar serviceRegistrar = serviceRegistrarArray[(n4 + n3) % n2];
                try {
                    if (serviceItemFilter != null) {
                        n5 = Integer.MAX_VALUE;
                    }
                    ServiceMatches serviceMatches = serviceRegistrar.lookup(serviceTemplate, n5);
                    int n6 = serviceMatches.items.length;
                    if (n6 != 0) {
                        int n7 = Math.abs(this.random.nextInt()) % n6;
                        int n8 = 0;
                        while (n8 < n6) {
                            ServiceItem serviceItem = serviceMatches.items[(n8 + n7) % n6];
                            if (serviceItem != null && (serviceItemFilter == null || serviceItemFilter.check(serviceItem))) {
                                if (!ServiceDiscoveryManager.isArrayContainsServiceItem(arrayList2, serviceItem)) {
                                    arrayList2.add(serviceItem);
                                }
                                if (arrayList2.size() >= n) {
                                    return arrayList2.toArray(new ServiceItem[arrayList2.size()]);
                                }
                            }
                            ++n8;
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    ServiceDiscoveryManager.printThrowable(remoteException);
                    this.discard(serviceRegistrar);
                }
                catch (Exception exception) {
                    ServiceDiscoveryManager.printThrowable(exception);
                }
                ++n4;
            }
        }
        return arrayList2.toArray(new ServiceItem[arrayList2.size()]);
    }

    public ServiceItem lookup(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter) {
        ServiceRegistrar[] serviceRegistrarArray;
        this.checkTerminated();
        ArrayList arrayList = this.proxyRegSet;
        synchronized (arrayList) {
            serviceRegistrarArray = this.buildServiceRegistrar();
        }
        int n = serviceRegistrarArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = Math.abs(this.random.nextInt()) % n;
        int n3 = 0;
        while (n3 < n) {
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[(n3 + n2) % n];
            ServiceItem serviceItem = null;
            try {
                int n4 = serviceItemFilter != null ? Integer.MAX_VALUE : 1;
                ServiceMatches serviceMatches = serviceRegistrar.lookup(serviceTemplate, n4);
                serviceItem = this.getMatchedServiceItem(serviceMatches, serviceItemFilter);
            }
            catch (RemoteException remoteException) {
                ServiceDiscoveryManager.printThrowable(remoteException);
                this.discard(serviceRegistrar);
            }
            catch (Exception exception) {
                ServiceDiscoveryManager.printThrowable(exception);
            }
            if (serviceItem != null) {
                return serviceItem;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceItem lookup(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, long l) throws InterruptedException, RemoteException {
        ServiceItem serviceItem;
        ServiceItem serviceItem2 = this.lookup(serviceTemplate, serviceItemFilter);
        if (serviceItem2 != null) {
            return serviceItem2;
        }
        ServiceDiscoveryListenerImpl serviceDiscoveryListenerImpl = new ServiceDiscoveryListenerImpl();
        LookupCacheImpl lookupCacheImpl = null;
        try {
            block9: {
                ServiceItem serviceItem3;
                ServiceDiscoveryListenerImpl serviceDiscoveryListenerImpl2 = serviceDiscoveryListenerImpl;
                synchronized (serviceDiscoveryListenerImpl2) {
                    lookupCacheImpl = this.createLookupCache(serviceTemplate, serviceItemFilter, serviceDiscoveryListenerImpl, l);
                    long l2 = lookupCacheImpl.getLeaseDuration();
                    while (true) {
                        if (l2 <= 0L) {
                            break block9;
                        }
                        serviceDiscoveryListenerImpl.wait(l2);
                        serviceItem2 = lookupCacheImpl.lookup(null);
                        if (serviceItem2 != null) {
                            serviceItem3 = serviceItem2;
                            Object var13_10 = null;
                            break;
                        }
                        l2 = lookupCacheImpl.getLeaseDuration();
                    }
                }
                Object var10_11 = null;
                if (lookupCacheImpl == null) return serviceItem3;
                lookupCacheImpl.terminate();
                return serviceItem3;
            }
            serviceItem = serviceItem2;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (lookupCacheImpl == null) throw throwable;
            lookupCacheImpl.terminate();
            throw throwable;
        }
        Object var10_12 = null;
        if (lookupCacheImpl == null) return serviceItem;
        lookupCacheImpl.terminate();
        return serviceItem;
    }

    private static void printDebug(String string) {
        try {
            if (System.getProperty("com.sun.jini.sdm.debug") != null) {
                System.out.println(string);
            }
        }
        catch (SecurityException securityException) {}
    }

    private static void printThrowable(Throwable throwable) {
        try {
            if (System.getProperty("com.sun.jini.sdm.debug") != null) {
                throwable.printStackTrace();
            }
        }
        catch (SecurityException securityException) {}
    }

    private EventRegistration registerListener(ServiceRegistrar serviceRegistrar, ServiceTemplate serviceTemplate, RemoteEventListener remoteEventListener, long l) throws RemoteException {
        EventRegistration eventRegistration = null;
        int n = 7;
        eventRegistration = serviceRegistrar.notify(serviceTemplate, n, remoteEventListener, null, l);
        this.leaseRenewalMgr.renewFor(eventRegistration.getLease(), l, new LeaseListenerImpl(serviceRegistrar));
        return eventRegistration;
    }

    public void terminate() {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            if (this.bTerminated) {
                Object var2_3 = null;
                return;
            }
            this.bTerminated = true;
            this.discMgr.removeDiscoveryListener(this.discMgrListener);
            if (this.discMgrInternal) {
                this.discMgr.terminate();
            }
        }
        boolean bl = false;
        ArrayList arrayList = null;
        Object object = this.caches;
        synchronized (object) {
            if (!this.caches.isEmpty()) {
                bl = true;
                arrayList = (ArrayList)this.caches.clone();
            }
        }
        if (bl) {
            object = ((AbstractList)arrayList).iterator();
            while (object.hasNext()) {
                LookupCacheImpl lookupCacheImpl = (LookupCacheImpl)object.next();
                lookupCacheImpl.terminate();
            }
        }
    }

    private static abstract class CacheTask
    implements TaskManager.Task {
        protected ProxyReg reg;

        public CacheTask(ProxyReg proxyReg) {
            this.reg = proxyReg;
        }

        public boolean isFromProxy(ProxyReg proxyReg) {
            if (this.reg == null) {
                return false;
            }
            return this.reg.equals(proxyReg);
        }

        public abstract void run();

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private static final class ServiceDiscoveryListenerImpl
    implements ServiceDiscoveryListener {
        ArrayList items = new ArrayList(1);

        ServiceDiscoveryListenerImpl() {
        }

        public synchronized ServiceItem[] getServiceItem() {
            ServiceItem[] serviceItemArray = new ServiceItem[this.items.size()];
            this.items.toArray(serviceItemArray);
            this.items.clear();
            return serviceItemArray;
        }

        public synchronized void serviceAdded(ServiceDiscoveryEvent serviceDiscoveryEvent) {
            this.items.add(serviceDiscoveryEvent.getPostEventServiceItem());
            this.notifyAll();
        }

        public void serviceChanged(ServiceDiscoveryEvent serviceDiscoveryEvent) {
        }

        public void serviceRemoved(ServiceDiscoveryEvent serviceDiscoveryEvent) {
        }
    }

    private static final class EventReg {
        public Lease lease;
        public long seqNo;

        public EventReg(Lease lease, long l) {
            this.lease = lease;
            this.seqNo = l;
        }
    }

    private static final class ServiceItemReg {
        private final ArrayList proxys = new ArrayList(1);
        private boolean bDiscarded = false;
        public ServiceItem item;

        public ServiceItemReg(ServiceRegistrar serviceRegistrar, ServiceItem serviceItem) {
            this.addProxy(serviceRegistrar);
            this.item = serviceItem;
        }

        public void addProxy(ServiceRegistrar serviceRegistrar) {
            if (!this.proxys.contains(serviceRegistrar)) {
                this.proxys.add(serviceRegistrar);
            }
        }

        public boolean hasNoProxys() {
            return this.proxys.isEmpty();
        }

        public boolean isDiscarded() {
            return this.bDiscarded;
        }

        public void printProxys() {
            Iterator iterator = ((AbstractList)this.proxys).iterator();
            System.out.println("----------- proxys --------------");
            while (iterator.hasNext()) {
                try {
                    ServiceRegistrar serviceRegistrar = (ServiceRegistrar)iterator.next();
                    System.out.println("proxy:" + serviceRegistrar.getLocator());
                }
                catch (Exception exception) {}
            }
            System.out.println("------------------ --------------");
        }

        public void removeProxy(ServiceRegistrar serviceRegistrar) {
            int n = this.proxys.indexOf(serviceRegistrar);
            if (n != -1) {
                this.proxys.remove(n);
            }
        }

        public void setDiscarded(boolean bl) {
            this.bDiscarded = bl;
        }
    }

    private static final class ProxyReg {
        public ServiceRegistrar proxy;

        public ProxyReg(ServiceRegistrar serviceRegistrar) {
            if (serviceRegistrar == null) {
                throw new IllegalArgumentException("proxy cannot be null");
            }
            this.proxy = serviceRegistrar;
        }

        public boolean equals(Object object) {
            if (object instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)object).proxy);
            }
            return false;
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }
    }

    private final class LeaseListenerImpl
    implements LeaseListener {
        private ServiceRegistrar proxy;

        public LeaseListenerImpl(ServiceRegistrar serviceRegistrar) {
            this.proxy = serviceRegistrar;
        }

        public void notify(LeaseRenewalEvent leaseRenewalEvent) {
            ServiceDiscoveryManager.this.fail(leaseRenewalEvent.getException(), this.proxy);
        }
    }

    private final class LookupCacheImpl
    implements LookupCache {
        private static final int ITEM_ADDED = 0;
        private static final int ITEM_REMOVED = 2;
        private static final int ITEM_CHANGED = 3;
        private LookupListener lookupListener;
        private RemoteEventListener lookupListenerStub;
        private TaskManager cacheTaskMgr;
        private boolean bCacheTerminated = false;
        private final ArrayList sItemListeners = new ArrayList(1);
        private final HashMap serviceIdMap = new HashMap();
        private final HashMap eventRegMap = new HashMap();
        private ServiceTemplate tmpl;
        private ServiceItemFilter filter = null;
        private long leaseDuration;
        private final long startTime = System.currentTimeMillis();
        private TaskManager serviceDiscardTimerTaskMgr = new TaskManager(10, 15000L, 1.0f);
        private Object serviceDiscardMutex = new Object();

        public LookupCacheImpl(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, ServiceDiscoveryListener serviceDiscoveryListener, long l) throws RemoteException {
            ArrayList arrayList;
            this.tmpl = ServiceDiscoveryManager.copyServiceTemplate(serviceTemplate);
            this.leaseDuration = l;
            this.filter = serviceItemFilter;
            this.lookupListener = new LookupListener();
            this.lookupListenerStub = (RemoteEventListener)RemoteObject.toStub(this.lookupListener);
            ArrayList arrayList2 = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (arrayList2) {
                arrayList = (ArrayList)ServiceDiscoveryManager.this.proxyRegSet.clone();
                int n = arrayList.size();
                int n2 = ServiceDiscoveryManager.this.nTaskThreads < n ? n : ServiceDiscoveryManager.this.nTaskThreads;
                this.cacheTaskMgr = new TaskManager(n2, 15000L, 1.0f);
            }
            arrayList2 = this.sItemListeners;
            synchronized (arrayList2) {
                if (serviceDiscoveryListener != null) {
                    this.sItemListeners.add(serviceDiscoveryListener);
                }
            }
            int n = 0;
            while (n < arrayList.size()) {
                ProxyReg proxyReg = (ProxyReg)arrayList.get(n);
                this.addProxyReg(proxyReg);
                ++n;
            }
        }

        public void addListener(ServiceDiscoveryListener serviceDiscoveryListener) {
            this.checkCacheTerminated();
            if (serviceDiscoveryListener == null) {
                throw new NullPointerException("can't add null listener");
            }
            ServiceItem[] serviceItemArray = this.sItemListeners;
            synchronized (serviceItemArray) {
                this.sItemListeners.add(serviceDiscoveryListener);
            }
            serviceItemArray = this.getServiceItems(null);
            int n = 0;
            while (n < serviceItemArray.length) {
                this.addServiceNotify(serviceItemArray[n]);
                ++n;
            }
        }

        public void addProxyReg(ProxyReg proxyReg) {
            RegisterListenerTask registerListenerTask = new RegisterListenerTask(proxyReg);
            this.cacheTaskMgr.add(registerListenerTask);
        }

        private void addService(ServiceRegistrar serviceRegistrar, ServiceItem serviceItem) {
            ServiceItemReg serviceItemReg;
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                serviceItemReg = (ServiceItemReg)this.serviceIdMap.get(serviceItem.serviceID);
            }
            if (serviceItemReg == null) {
                serviceItemReg = new ServiceItemReg(serviceRegistrar, serviceItem);
                hashMap = this.serviceIdMap;
                synchronized (hashMap) {
                    this.serviceIdMap.put(serviceItem.serviceID, serviceItemReg);
                }
                this.addServiceNotify(serviceItem);
            } else {
                this.itemMatchMatchChange(serviceRegistrar, serviceItem, serviceItemReg);
            }
        }

        private void addServiceNotify(ServiceItem serviceItem) {
            this.serviceNotifyDo(null, serviceItem, 0);
        }

        private void changeServiceNotify(ServiceItem serviceItem, ServiceItem serviceItem2) {
            this.serviceNotifyDo(serviceItem2, serviceItem, 3);
        }

        private void checkCacheTerminated() {
            ServiceDiscoveryManager.this.checkTerminated();
            HashMap hashMap = this.eventRegMap;
            synchronized (hashMap) {
                if (this.bCacheTerminated) {
                    throw new IllegalStateException("this lookup cache was terminated");
                }
            }
        }

        private boolean checkItem(ServiceItem serviceItem) {
            if (serviceItem == null || serviceItem.service == null) {
                return false;
            }
            if (this.filter == null) {
                return true;
            }
            return this.filter.check(serviceItem);
        }

        public void discard(Object object) {
            Object object2;
            this.checkCacheTerminated();
            Iterator iterator = this.getServiceIdMapEntrySetIterator();
            while (iterator.hasNext()) {
                ServiceItemReg serviceItemReg;
                object2 = (Map.Entry)iterator.next();
                ServiceItemReg serviceItemReg2 = serviceItemReg = (ServiceItemReg)object2.getValue();
                synchronized (serviceItemReg2) {
                    if (serviceItemReg.item.service.equals(object)) {
                        serviceItemReg.setDiscarded(true);
                    }
                }
            }
            object2 = new DiscardServiceTask(object);
            this.cacheTaskMgr.add((TaskManager.Task)object2);
        }

        private ServiceItem findItem(ServiceID serviceID, ServiceItem[] serviceItemArray) {
            if (serviceItemArray != null) {
                int n = 0;
                while (n < serviceItemArray.length) {
                    if (serviceItemArray[n].serviceID.equals(serviceID)) {
                        return serviceItemArray[n];
                    }
                    ++n;
                }
            }
            return null;
        }

        public long getLeaseDuration() {
            if (this.leaseDuration == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.leaseDuration + this.startTime - System.currentTimeMillis();
        }

        private Iterator getServiceIdMapEntrySetIterator() {
            HashMap hashMap;
            Object object = this.serviceIdMap;
            synchronized (object) {
                hashMap = (HashMap)this.serviceIdMap.clone();
            }
            object = hashMap.entrySet();
            return object.iterator();
        }

        private ServiceItem[] getServiceItems(ServiceItemFilter serviceItemFilter) {
            Object object;
            ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(1);
            Iterator iterator = this.getServiceIdMapEntrySetIterator();
            while (iterator.hasNext()) {
                ServiceItem serviceItem;
                ServiceItemReg serviceItemReg;
                object = (Map.Entry)iterator.next();
                ServiceItemReg serviceItemReg2 = serviceItemReg = (ServiceItemReg)object.getValue();
                synchronized (serviceItemReg2) {
                    if (serviceItemReg.isDiscarded()) {
                        Object var8_8 = null;
                        continue;
                    }
                    serviceItem = serviceItemReg.item;
                }
                if (serviceItemFilter != null && !serviceItemFilter.check(serviceItem)) continue;
                arrayList.add(serviceItem);
            }
            object = new ServiceItem[arrayList.size()];
            arrayList.toArray((T[])object);
            return object;
        }

        private void itemMatchMatchChange(ServiceRegistrar serviceRegistrar, ServiceItem serviceItem, ServiceItemReg serviceItemReg) {
            ServiceItem serviceItem2 = serviceItemReg.item;
            ServiceItemReg serviceItemReg2 = serviceItemReg;
            synchronized (serviceItemReg2) {
                if (serviceItemReg.isDiscarded()) {
                    Object var6_6 = null;
                    return;
                }
                serviceItemReg.item = serviceItem;
            }
            serviceItemReg.addProxy(serviceRegistrar);
            if (serviceItem.service.equals(serviceItem2.service)) {
                if (!LookupAttributes.equal(serviceItem.attributeSets, serviceItem2.attributeSets)) {
                    this.changeServiceNotify(serviceItem, serviceItem2);
                }
            } else {
                this.removeServiceNotify(serviceItem2);
                this.addServiceNotify(serviceItem);
            }
        }

        public ServiceItem lookup(ServiceItemFilter serviceItemFilter) {
            this.checkCacheTerminated();
            ServiceItem[] serviceItemArray = this.getServiceItems(serviceItemFilter);
            if (serviceItemArray.length == 0) {
                return null;
            }
            int n = Math.abs(ServiceDiscoveryManager.this.random.nextInt()) % serviceItemArray.length;
            return serviceItemArray[n];
        }

        public ServiceItem[] lookup(ServiceItemFilter serviceItemFilter, int n) {
            this.checkCacheTerminated();
            if (n < 1) {
                throw new IllegalArgumentException("maxMatches must be > 0");
            }
            ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(1);
            ServiceItem[] serviceItemArray = this.getServiceItems(serviceItemFilter);
            int n2 = serviceItemArray.length;
            if (n2 == 0) {
                return new ServiceItem[0];
            }
            int n3 = Math.abs(ServiceDiscoveryManager.this.random.nextInt()) % n2;
            int n4 = 0;
            while (n4 < n2) {
                arrayList.add(serviceItemArray[(n4 + n3) % n2]);
                if (arrayList.size() == n) break;
                ++n4;
            }
            ServiceItem[] serviceItemArray2 = new ServiceItem[arrayList.size()];
            arrayList.toArray(serviceItemArray2);
            return serviceItemArray2;
        }

        private void notifyServiceMap(ServiceRegistrar serviceRegistrar, ServiceID serviceID, ServiceItem serviceItem, int n, long l) {
            ProxyReg proxyReg;
            Object object = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (object) {
                proxyReg = ServiceDiscoveryManager.this.findReg(serviceRegistrar);
                if (proxyReg == null) {
                    Object var9_8 = null;
                    return;
                }
            }
            object = this.updateSeqNumber(proxyReg, l) ? new NotifyEventTask(proxyReg, serviceID, serviceItem, n) : new LookupTask(proxyReg);
            this.cacheTaskMgr.add((TaskManager.Task)object);
        }

        private void printServiceIdMap() {
            if (this.serviceIdMap.isEmpty()) {
                System.out.println("************************** sid:");
                System.out.println("serviceIdMap is empty");
            }
            Iterator iterator = this.getServiceIdMapEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ServiceItemReg serviceItemReg = (ServiceItemReg)entry.getValue();
                ServiceID serviceID = (ServiceID)entry.getKey();
                System.out.println("************************** sid:" + serviceID);
                serviceItemReg.printProxys();
            }
        }

        public void removeListener(ServiceDiscoveryListener serviceDiscoveryListener) {
            this.checkCacheTerminated();
            if (serviceDiscoveryListener == null) {
                return;
            }
            ArrayList arrayList = this.sItemListeners;
            synchronized (arrayList) {
                int n = this.sItemListeners.indexOf(serviceDiscoveryListener);
                if (n != -1) {
                    ((AbstractCollection)this.sItemListeners).remove(serviceDiscoveryListener);
                }
            }
        }

        public void removeProxyReg(ProxyReg proxyReg) {
            EventReg eventReg;
            Object object = this.eventRegMap;
            synchronized (object) {
                eventReg = (EventReg)this.eventRegMap.get(proxyReg);
            }
            if (eventReg != null) {
                ServiceDiscoveryManager.this.cancelLease(eventReg.lease);
            }
            object = new ProxyRegDropTask(proxyReg);
            this.removeUselessTask(proxyReg);
            this.cacheTaskMgr.add((TaskManager.Task)object);
        }

        private void removeServiceIdMap(ServiceID serviceID, ServiceItem serviceItem) {
            this.removeServiceIdMapSendNoEvent(serviceID);
            this.removeServiceNotify(serviceItem);
        }

        private void removeServiceIdMapSendNoEvent(ServiceID serviceID) {
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                this.serviceIdMap.remove(serviceID);
            }
        }

        private void removeServiceNotify(ServiceItem serviceItem) {
            this.serviceNotifyDo(serviceItem, null, 2);
        }

        private void removeUselessTask(ProxyReg proxyReg) {
            ArrayList arrayList = this.cacheTaskMgr.getPending();
            int n = 0;
            while (n < arrayList.size()) {
                CacheTask cacheTask = (CacheTask)arrayList.get(n);
                if (cacheTask.isFromProxy(proxyReg)) {
                    this.cacheTaskMgr.remove(cacheTask);
                }
                ++n;
            }
        }

        private void serviceNotifyDo(ServiceItem serviceItem, ServiceItem serviceItem2, int n) {
            ArrayList arrayList;
            Object object = this.sItemListeners;
            synchronized (object) {
                if (this.sItemListeners.isEmpty()) {
                    Object var6_5 = null;
                    return;
                }
                arrayList = (ArrayList)this.sItemListeners.clone();
            }
            object = ((AbstractList)arrayList).iterator();
            ServiceDiscoveryEvent serviceDiscoveryEvent = new ServiceDiscoveryEvent(this, serviceItem, serviceItem2);
            while (object.hasNext()) {
                ServiceDiscoveryListener serviceDiscoveryListener = (ServiceDiscoveryListener)object.next();
                switch (n) {
                    case 0: {
                        serviceDiscoveryListener.serviceAdded(serviceDiscoveryEvent);
                        break;
                    }
                    case 2: {
                        serviceDiscoveryListener.serviceRemoved(serviceDiscoveryEvent);
                        break;
                    }
                    case 3: {
                        serviceDiscoveryListener.serviceChanged(serviceDiscoveryEvent);
                        break;
                    }
                }
            }
        }

        public void terminate() {
            Object object = this.eventRegMap;
            synchronized (object) {
                if (this.bCacheTerminated) {
                    Object var2_3 = null;
                    return;
                }
                this.bCacheTerminated = true;
            }
            object = ServiceDiscoveryManager.this.caches;
            synchronized (object) {
                int n = ServiceDiscoveryManager.this.caches.indexOf(this);
                if (n != -1) {
                    ServiceDiscoveryManager.this.caches.remove(n);
                }
            }
            this.terminateTaskMgr(this.cacheTaskMgr);
            object = this.serviceDiscardMutex;
            synchronized (object) {
                this.terminateTaskMgr(this.serviceDiscardTimerTaskMgr);
            }
            object = this.eventRegMap;
            synchronized (object) {
                Set set = this.eventRegMap.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    EventReg eventReg = (EventReg)entry.getValue();
                    ServiceDiscoveryManager.this.cancelLease(eventReg.lease);
                }
            }
            try {
                UnicastRemoteObject.unexportObject(this.lookupListener, true);
            }
            catch (Exception exception) {
                ServiceDiscoveryManager.printThrowable(exception);
            }
        }

        private void terminateTaskMgr(TaskManager taskManager) {
            TaskManager taskManager2 = taskManager;
            synchronized (taskManager2) {
                ArrayList arrayList = taskManager.getPending();
                int n = 0;
                while (n < arrayList.size()) {
                    taskManager.remove((TaskManager.Task)arrayList.get(n));
                    ++n;
                }
                taskManager.terminate();
                taskManager = null;
            }
        }

        private boolean updateSeqNumber(ProxyReg proxyReg, long l) {
            long l2;
            HashMap hashMap = this.eventRegMap;
            synchronized (hashMap) {
                EventReg eventReg = (EventReg)this.eventRegMap.get(proxyReg);
                l2 = eventReg.seqNo;
                eventReg.seqNo = l;
            }
            return l == ++l2;
        }

        private void updateServiceMap(ServiceRegistrar serviceRegistrar, ServiceItem[] serviceItemArray) {
            ArrayList arrayList = new ArrayList(1);
            Iterator iterator = this.getServiceIdMapEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ServiceItemReg serviceItemReg = (ServiceItemReg)entry.getValue();
                ServiceID serviceID = (ServiceID)entry.getKey();
                ServiceItem serviceItem = this.findItem(serviceID, serviceItemArray);
                if (serviceItem != null) {
                    if (serviceItem.service == null) continue;
                    if (this.checkItem(serviceItem)) {
                        this.itemMatchMatchChange(serviceRegistrar, serviceItem, serviceItemReg);
                        continue;
                    }
                    this.removeServiceIdMap(serviceID, serviceItemReg.item);
                    continue;
                }
                serviceItemReg.removeProxy(serviceRegistrar);
                if (!serviceItemReg.hasNoProxys()) continue;
                this.removeServiceIdMap(serviceID, serviceItemReg.item);
            }
        }

        private final class LookupListener
        extends UnicastRemoteObject
        implements RemoteEventListener,
        Serializable {
            public void notify(RemoteEvent remoteEvent) {
                ServiceEvent serviceEvent = (ServiceEvent)remoteEvent;
                LookupCacheImpl.this.notifyServiceMap((ServiceRegistrar)serviceEvent.getSource(), serviceEvent.getServiceID(), serviceEvent.getServiceItem(), serviceEvent.getTransition(), serviceEvent.getSequenceNumber());
            }
        }

        private final class RegisterListenerTask
        extends CacheTask {
            public RegisterListenerTask(ProxyReg proxyReg) {
                super(proxyReg);
            }

            public void run() {
                long l = LookupCacheImpl.this.getLeaseDuration();
                if (l < 0L) {
                    return;
                }
                try {
                    EventRegistration eventRegistration = ServiceDiscoveryManager.this.registerListener(this.reg.proxy, LookupCacheImpl.this.tmpl, LookupCacheImpl.this.lookupListenerStub, l);
                    if (eventRegistration != null) {
                        Lease lease = eventRegistration.getLease();
                        HashMap hashMap = LookupCacheImpl.this.eventRegMap;
                        synchronized (hashMap) {
                            if (LookupCacheImpl.this.bCacheTerminated) {
                                ServiceDiscoveryManager.this.cancelLease(lease);
                            } else {
                                LookupCacheImpl.this.eventRegMap.put(this.reg, new EventReg(lease, eventRegistration.getSequenceNumber()));
                            }
                        }
                    }
                    LookupCacheImpl.this.cacheTaskMgr.add(new LookupTask(this.reg));
                }
                catch (RemoteException remoteException) {
                    ServiceDiscoveryManager.this.fail(remoteException, this.reg.proxy);
                }
            }
        }

        private final class LookupTask
        extends CacheTask {
            public LookupTask(ProxyReg proxyReg) {
                super(proxyReg);
            }

            public void run() {
                ServiceMatches serviceMatches;
                ServiceRegistrar serviceRegistrar = this.reg.proxy;
                try {
                    serviceMatches = serviceRegistrar.lookup(LookupCacheImpl.this.tmpl, Integer.MAX_VALUE);
                }
                catch (RemoteException remoteException) {
                    ServiceDiscoveryManager.this.fail(remoteException, serviceRegistrar);
                    return;
                }
                LookupCacheImpl.this.updateServiceMap(serviceRegistrar, serviceMatches.items.length > 0 ? serviceMatches.items : null);
                int n = 0;
                while (n < serviceMatches.items.length) {
                    if (LookupCacheImpl.this.checkItem(serviceMatches.items[n])) {
                        LookupCacheImpl.this.addService(serviceRegistrar, serviceMatches.items[n]);
                    }
                    ++n;
                }
            }
        }

        private final class ProxyRegDropTask
        extends CacheTask {
            public ProxyRegDropTask(ProxyReg proxyReg) {
                super(proxyReg);
            }

            public void run() {
                HashMap hashMap = LookupCacheImpl.this.eventRegMap;
                synchronized (hashMap) {
                    if (LookupCacheImpl.this.eventRegMap.containsKey(this.reg)) {
                        LookupCacheImpl.this.eventRegMap.remove(this.reg);
                    }
                }
                LookupCacheImpl.this.updateServiceMap(this.reg.proxy, null);
            }
        }

        private final class DiscardServiceTask
        extends CacheTask {
            private Object service;

            public DiscardServiceTask(Object object) {
                super(null);
                this.service = object;
            }

            public void run() {
                Iterator iterator = LookupCacheImpl.this.getServiceIdMapEntrySetIterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    ServiceItemReg serviceItemReg = (ServiceItemReg)entry.getValue();
                    if (!serviceItemReg.item.service.equals(this.service)) continue;
                    ServiceID serviceID = (ServiceID)entry.getKey();
                    LookupCacheImpl.this.removeServiceNotify(serviceItemReg.item);
                    LookupCacheImpl.this.serviceDiscardTimerTaskMgr.add(new ServiceDiscardTimerTask(serviceID));
                    return;
                }
            }
        }

        private final class NotifyEventTask
        extends CacheTask {
            private ServiceID sid;
            private ServiceItem item;
            private int transition;

            public NotifyEventTask(ProxyReg proxyReg, ServiceID serviceID, ServiceItem serviceItem, int n) {
                super(proxyReg);
                this.sid = serviceID;
                this.item = serviceItem;
                this.transition = n;
            }

            public void run() {
                if (this.item != null && this.item.service == null) {
                    return;
                }
                if (this.transition == 1 || !LookupCacheImpl.this.checkItem(this.item)) {
                    ServiceItemReg serviceItemReg = null;
                    HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        serviceItemReg = (ServiceItemReg)LookupCacheImpl.this.serviceIdMap.get(this.sid);
                    }
                    if (serviceItemReg != null) {
                        serviceItemReg.removeProxy(this.reg.proxy);
                        boolean bl = serviceItemReg.hasNoProxys();
                        boolean bl2 = serviceItemReg.isDiscarded();
                        if (this.item != null || bl) {
                            if (bl2 && this.transition == 1) {
                                LookupCacheImpl.this.removeServiceIdMapSendNoEvent(this.sid);
                                Object object = LookupCacheImpl.this.serviceDiscardMutex;
                                synchronized (object) {
                                    LookupCacheImpl.this.serviceDiscardMutex.notifyAll();
                                }
                            } else {
                                LookupCacheImpl.this.removeServiceIdMap(this.sid, serviceItemReg.item);
                            }
                        }
                    }
                } else {
                    LookupCacheImpl.this.addService(this.reg.proxy, this.item);
                }
            }
        }

        private final class ServiceDiscardTimerTask
        implements TaskManager.Task {
            private ServiceID serviceID;

            public ServiceDiscardTimerTask(ServiceID serviceID) {
                this.serviceID = serviceID;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                HashMap hashMap = LookupCacheImpl.this.eventRegMap;
                synchronized (hashMap) {
                    if (LookupCacheImpl.this.bCacheTerminated) {
                        return;
                    }
                }
                hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    if (!LookupCacheImpl.this.serviceIdMap.containsKey(this.serviceID)) {
                        return;
                    }
                }
                long l = Long.getLong("com.sun.jini.sdm.discardWait", 600000L);
                long l2 = System.currentTimeMillis();
                Object object = LookupCacheImpl.this.serviceDiscardMutex;
                synchronized (object) {
                    while (l > 0L) {
                        try {
                            LookupCacheImpl.this.serviceDiscardMutex.wait(l);
                        }
                        catch (InterruptedException interruptedException) {}
                        HashMap hashMap2 = LookupCacheImpl.this.eventRegMap;
                        synchronized (hashMap2) {
                            if (LookupCacheImpl.this.bCacheTerminated) {
                                return;
                            }
                        }
                        hashMap2 = LookupCacheImpl.this.serviceIdMap;
                        synchronized (hashMap2) {
                            if (!LookupCacheImpl.this.serviceIdMap.containsKey(this.serviceID)) {
                                return;
                            }
                        }
                        l = l + l2 - System.currentTimeMillis();
                    }
                }
                object = null;
                HashMap hashMap3 = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap3) {
                    if (LookupCacheImpl.this.serviceIdMap.containsKey(this.serviceID)) {
                        object = (ServiceItemReg)LookupCacheImpl.this.serviceIdMap.get(this.serviceID);
                    }
                }
                if (object == null) return;
                ((ServiceItemReg)object).setDiscarded(false);
                LookupCacheImpl.this.addServiceNotify(((ServiceItemReg)object).item);
            }

            public boolean runAfter(List list, int n) {
                return false;
            }
        }
    }

    private class DiscMgrListener
    implements DiscoveryListener {
        DiscMgrListener() {
        }

        public void discarded(DiscoveryEvent discoveryEvent) {
            ArrayList arrayList;
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            ArrayList<ProxyReg> arrayList2 = new ArrayList<ProxyReg>(1);
            Object object = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (object) {
                int n = 0;
                while (n < serviceRegistrarArray.length) {
                    ProxyReg proxyReg = ServiceDiscoveryManager.this.findReg(serviceRegistrarArray[n]);
                    if (proxyReg == null) {
                        throw new RuntimeException("discard error");
                    }
                    ServiceDiscoveryManager.this.proxyRegSet.remove(ServiceDiscoveryManager.this.proxyRegSet.indexOf(proxyReg));
                    arrayList2.add(proxyReg);
                    ++n;
                }
            }
            object = ((AbstractList)arrayList2).iterator();
            while (object.hasNext()) {
                ServiceDiscoveryManager.this.dropProxy((ProxyReg)object.next());
            }
            ArrayList arrayList3 = ServiceDiscoveryManager.this.listeners;
            synchronized (arrayList3) {
                if (ServiceDiscoveryManager.this.listeners.isEmpty()) {
                    Object var7_6 = null;
                    return;
                }
                arrayList = (ArrayList)ServiceDiscoveryManager.this.listeners.clone();
            }
            ServiceDiscoveryManager.this.listenerDropped(arrayList2, arrayList);
        }

        public void discovered(DiscoveryEvent discoveryEvent) {
            Object object;
            Iterator iterator;
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            ArrayList arrayList = new ArrayList(1);
            ArrayList arrayList2 = null;
            int n = 0;
            while (n < serviceRegistrarArray.length) {
                iterator = new ProxyReg(serviceRegistrarArray[n]);
                object = ServiceDiscoveryManager.this.proxyRegSet;
                synchronized (object) {
                    ServiceDiscoveryManager.this.proxyRegSet.add(iterator);
                    arrayList.add(iterator);
                }
                ++n;
            }
            iterator = ServiceDiscoveryManager.this.listeners;
            synchronized (iterator) {
                if (!ServiceDiscoveryManager.this.listeners.isEmpty()) {
                    arrayList2 = (ArrayList)ServiceDiscoveryManager.this.listeners.clone();
                }
            }
            iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                object = (ProxyReg)iterator.next();
                ServiceDiscoveryManager.this.cacheAddProxy((ProxyReg)object);
                if (arrayList2 == null) continue;
                ServiceDiscoveryManager.this.listenerDiscovered(((ProxyReg)object).proxy, arrayList2);
            }
        }
    }
}

