/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.naming.NamingException;

public class DirectoryServiceHelper {
    private SyInterfacesDriver _interfacesDriver = null;
    private LibctlDriver _libtclDriver = null;

    public DirectoryServiceHelper() {
    }

    public DirectoryServiceHelper(boolean bl, boolean bl2) throws Exception, InterfacesException, LDAPException {
        this.init(bl, bl2);
    }

    public void init(boolean bl, boolean bl2) throws Exception, InterfacesException, LDAPException {
        if (bl) {
            this.initInterfacesDriver();
        }
        if (bl2) {
            this.initLibtclDriver();
        }
    }

    public void initInterfacesDriver() throws Exception, InterfacesException {
        this._interfacesDriver = new SyInterfacesDriver();
        this._interfacesDriver.open();
    }

    public void initInterfacesDriver(String string) throws Exception, InterfacesException {
        this._interfacesDriver = new SyInterfacesDriver(string);
        this._interfacesDriver.open(string);
    }

    public void initLibtclDriver() throws FileNotFoundException, IOException, LDAPException {
        this._libtclDriver = new LibctlDriver();
    }

    public SyInterfacesDriver getInterfacesDriver(Boolean bl) throws Exception, InterfacesException {
        if (this._interfacesDriver == null || bl.booleanValue()) {
            this.initInterfacesDriver();
        }
        return this._interfacesDriver;
    }

    public LibctlDriver getLibctlDriver() throws FileNotFoundException, IOException, LDAPException {
        if (this._libtclDriver == null) {
            this.initLibtclDriver();
        }
        return this._libtclDriver;
    }

    public String[] doesServerEntryExistInInterfaces(String string) {
        SyInterfacesEntry syInterfacesEntry = this._interfacesDriver.getEntry(string);
        if (syInterfacesEntry != null) {
            return new String[]{syInterfacesEntry.getHost(), syInterfacesEntry.getPort()};
        }
        return null;
    }

    public String[] doesServerEntryExistInLDAP(String string, String string2, String string3) throws NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return null;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return null;
        }
        SyASEServer syASEServer = syLDAPServer.getASEServer(string3);
        if (syASEServer == null) {
            return null;
        }
        return new String[]{syASEServer.getHost(), syASEServer.getPort()};
    }

    public List doesHostPortExistInInterfaces(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = this._interfacesDriver.getEntries();
        block0: for (int i = 0; i < vector.size(); ++i) {
            SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)vector.get(i);
            List list = syInterfacesEntry.getServices();
            for (int j = 0; j < list.size(); ++j) {
                Service service = (Service)list.get(j);
                if (service.getHost() == null || !service.getHost().equalsIgnoreCase(string) || service.getPort() == null || !service.getPort().equalsIgnoreCase(string2)) continue;
                arrayList.add(syInterfacesEntry.getName());
                continue block0;
            }
        }
        return arrayList;
    }

    public List doesHostPortExistInLDAP(String string, String string2, String string3, String string4) throws NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("") || string4 == null || string4.trim().equals("")) {
            return null;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = syLDAPServer.getASEServers();
        block0: for (int i = 0; i < vector.size(); ++i) {
            SyInterfacesEntry syInterfacesEntry = ((SyASEServer)vector.get(i)).getInterfacesEntry();
            List list = syInterfacesEntry.getServices();
            for (int j = 0; j < list.size(); ++j) {
                Service service = (Service)list.get(j);
                if (!service.getHost().equalsIgnoreCase(string3) || !service.getPort().equalsIgnoreCase(string4)) continue;
                arrayList.add(syInterfacesEntry.getName());
                continue block0;
            }
        }
        return arrayList;
    }

    public void addEntryToInterfaces(String string, String string2, String string3) throws IOException {
        this._interfacesDriver.setSaveOnChange(true);
        if (Utils.OS_WINDOWS) {
            this._interfacesDriver.setValue(string, new Service(0, "NLWNSCK", string2, string3));
            this._interfacesDriver.setValue(string, new Service(1, "NLWNSCK", string2, string3));
        } else {
            this._interfacesDriver.setValue(string, new Service(0, "tcp ether", string2, string3));
            this._interfacesDriver.setValue(string, new Service(1, "tcp ether", string2, string3));
        }
        this._interfacesDriver.setSaveOnChange(false);
    }

    public void addEntryToInterfaces(SyInterfacesEntry syInterfacesEntry) throws IOException {
        this._interfacesDriver.setSaveOnChange(true);
        this._interfacesDriver.addEntry(syInterfacesEntry);
        this._interfacesDriver.setSaveOnChange(false);
    }

    public void addEntryToLDAP(String string, String string2, SyInterfacesEntry syInterfacesEntry) throws IOException, NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || syInterfacesEntry == null) {
            return;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return;
        }
        syLDAPServer.addEntry(syInterfacesEntry);
    }

    public Enumeration getEntriesFromInterfacesFile() {
        return this._interfacesDriver.getASEServers().elements();
    }

    public Enumeration getUniqueEntriesFromInterfaces() {
        Object object;
        Object object2;
        Vector vector = this._interfacesDriver.getASEServers();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (SyASEServer)vector.get(i);
            object = ((SyASEServer)object2).getInterfacesEntry();
            List list = ((SyInterfacesEntry)object).getServices("query");
            for (int j = 0; j < list.size(); ++j) {
                Service service = (Service)list.get(j);
                String string = service.getHost();
                String string2 = service.getPort();
                String string3 = string + ":" + string2;
                if (hashtable.containsKey(string3)) {
                    SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)hashtable.get(string3);
                    int n = syInterfacesEntry.getServices("query").size();
                    if (((SyInterfacesEntry)object).getServices("query").size() <= n) continue;
                    hashtable.put(string3, object);
                    continue;
                }
                hashtable.put(string3, object);
            }
        }
        Vector<Object> vector2 = new Vector<Object>();
        object2 = hashtable.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (vector2.contains(object)) continue;
            vector2.add(object);
        }
        object = new Vector();
        for (int i = 0; i < vector2.size(); ++i) {
            ((Vector)object).add(new SyASEServer((SyInterfacesEntry)vector2.get(i)));
        }
        return ((Vector)object).elements();
    }

    public Vector getLDAPServers() {
        return this._libtclDriver.getLDAPServers();
    }

    public Enumeration getEntriesFromLDAP(Integer n) {
        Vector vector = new Vector();
        if (this._libtclDriver == null) {
            return vector.elements();
        }
        Vector vector2 = this._libtclDriver.getLDAPServers();
        for (int i = 0; i < vector2.size(); ++i) {
            SyLDAPServer syLDAPServer = (SyLDAPServer)vector2.elementAt(i);
            try {
                if (!syLDAPServer.connectLDAP(n)) continue;
                syLDAPServer.initASEEntries();
                vector.addAll(syLDAPServer.getASEServers());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector.elements();
    }

    public String getHostFromInterfaces(String string) {
        SyInterfacesEntry syInterfacesEntry;
        String string2 = null;
        if (this._interfacesDriver != null && string != null && !string.equals("") && (syInterfacesEntry = this._interfacesDriver.getEntry(string)) != null) {
            string2 = syInterfacesEntry.getHost();
        }
        return string2;
    }

    public String getHostFromLDAP(String string, String string2, String string3) throws NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return null;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return null;
        }
        SyASEServer syASEServer = syLDAPServer.getASEServer(string3);
        if (syASEServer != null) {
            return syASEServer.getHost();
        }
        return null;
    }

    public String getPortFromInterfaces(String string) {
        SyInterfacesEntry syInterfacesEntry;
        String string2 = null;
        if (this._interfacesDriver != null && string != null && !string.equals("") && (syInterfacesEntry = this._interfacesDriver.getEntry(string)) != null) {
            string2 = syInterfacesEntry.getPort();
        }
        return string2;
    }

    private SyLDAPServer initLDAPConnection(String string, String string2) throws NamingException {
        SyLDAPServer syLDAPServer;
        if (this._libtclDriver != null && (syLDAPServer = this._libtclDriver.getLDAPServer(string + ":" + string2)) != null) {
            syLDAPServer.connectLDAP();
            syLDAPServer.initASEEntries();
            return syLDAPServer;
        }
        return null;
    }

    public String getPortFromLDAP(String string, String string2, String string3) throws NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return null;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return null;
        }
        SyASEServer syASEServer = syLDAPServer.getASEServer(string3);
        if (syASEServer != null) {
            return syASEServer.getPort();
        }
        return null;
    }

    public void deleteEntry(String string) throws IOException {
        this._interfacesDriver.setSaveOnChange(true);
        this._interfacesDriver.deleteSubject(string);
        this._interfacesDriver.setSaveOnChange(false);
    }

    public void deleteEntryFromLDAP(String string, String string2, String string3) throws IOException, NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return;
        }
        syLDAPServer.deleteEntry(string3);
    }

    public void deleteServiceFromEntry(String string, Service service) throws IOException {
        this._interfacesDriver.setSaveOnChange(true);
        this._interfacesDriver.deleteService(string, service);
        this._interfacesDriver.setSaveOnChange(false);
    }

    public void deleteServiceFromEntryInLDAP(String string, String string2, String string3, Service service) throws NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return;
        }
        syLDAPServer.deleteServiceFromEntry(string3, service);
    }

    public void addServiceToEntry(String string, Service service) throws IOException {
        this._interfacesDriver.setSaveOnChange(true);
        this._interfacesDriver.setValue(string, service);
        this._interfacesDriver.setSaveOnChange(false);
    }

    public void addServiceToEntryInLDAP(String string, String string2, String string3, Service service) throws NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return;
        }
        syLDAPServer.addServiceToEntry(string3, service);
    }

    public void modifyServiceToEntryInLDAP(String string, String string2, String string3, Service service, Service service2) throws NamingException, IOException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return;
        }
        syLDAPServer.modifyServiceToEntry(string3, service, service2);
    }

    public List getServicesForEntryFromLDAP(String string, String string2, String string3) throws NamingException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("")) {
            return null;
        }
        SyLDAPServer syLDAPServer = this.initLDAPConnection(string, string2);
        if (syLDAPServer == null) {
            return null;
        }
        return syLDAPServer.getServicesForEntry(string3);
    }

    public List getServices(String string) {
        SyInterfacesEntry syInterfacesEntry = this._interfacesDriver.getEntry(string);
        if (syInterfacesEntry != null) {
            return syInterfacesEntry.getServices();
        }
        return null;
    }
}

