/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.ColorChoiceRenderer;
import com.sybase.central.editor.ColorFillIcon;
import com.sybase.central.editor.ResourceManager;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class ColorChoiceComboBox
extends JComboBox
implements ActionListener {
    boolean _ignoreColorChange = false;
    String _what = null;
    String _property = null;

    ColorChoiceComboBox() {
        this.addActionListener(this);
        String string = ResourceManager.getI18NMessage("Custom");
        this.setRenderer(new ColorChoiceRenderer());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(string) + n + 2 + new JLabel().getIconTextGap();
        this.addItem(new ColorFillIcon(Color.black, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.blue, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.cyan, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.darkGray, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.gray, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.green, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.lightGray, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.magenta, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.orange, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.pink, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.red, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.white, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.yellow, n2, n, 1));
        this.addItem(new JLabel(string, new ColorFillIcon(Color.white, n, n, 1), 2));
    }

    Color getColor() {
        Object object = this.getSelectedItem();
        if (object instanceof JLabel) {
            JLabel jLabel = (JLabel)object;
            return ((ColorFillIcon)jLabel.getIcon()).getFillColor();
        }
        if (object instanceof ColorFillIcon) {
            return ((ColorFillIcon)object).getFillColor();
        }
        return null;
    }

    void setColor(Color color) {
        this.setColor(color, null, null);
    }

    void setColor(Color color, String string, String string2) {
        this._ignoreColorChange = true;
        this._what = string;
        this._property = string2;
        if (color.getRGB() == Color.black.getRGB()) {
            this.setSelectedIndex(0);
        } else if (color.getRGB() == Color.blue.getRGB()) {
            this.setSelectedIndex(1);
        } else if (color.getRGB() == Color.cyan.getRGB()) {
            this.setSelectedIndex(2);
        } else if (color.getRGB() == Color.darkGray.getRGB()) {
            this.setSelectedIndex(3);
        } else if (color.getRGB() == Color.gray.getRGB()) {
            this.setSelectedIndex(4);
        } else if (color.getRGB() == Color.green.getRGB()) {
            this.setSelectedIndex(5);
        } else if (color.getRGB() == Color.lightGray.getRGB()) {
            this.setSelectedIndex(6);
        } else if (color.getRGB() == Color.magenta.getRGB()) {
            this.setSelectedIndex(7);
        } else if (color.getRGB() == Color.orange.getRGB()) {
            this.setSelectedIndex(8);
        } else if (color.getRGB() == Color.pink.getRGB()) {
            this.setSelectedIndex(9);
        } else if (color.getRGB() == Color.red.getRGB()) {
            this.setSelectedIndex(10);
        } else if (color.getRGB() == Color.white.getRGB()) {
            this.setSelectedIndex(11);
        } else if (color.getRGB() == Color.yellow.getRGB()) {
            this.setSelectedIndex(12);
        } else {
            this.setSelectedIndex(13);
            Object object = this.getSelectedItem();
            if (object instanceof JLabel) {
                JLabel jLabel = (JLabel)object;
                ((ColorFillIcon)jLabel.getIcon()).setFillColor(color);
                this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
            }
        }
        this._ignoreColorChange = false;
    }

    void setCustomColor(Color color) {
        Object e = this.getItemAt(13);
        if (e instanceof JLabel) {
            JLabel jLabel = (JLabel)e;
            ((ColorFillIcon)jLabel.getIcon()).setFillColor(color);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this._ignoreColorChange) {
            Object object = this.getSelectedItem();
            if (object instanceof JLabel) {
                Color color;
                JLabel jLabel = (JLabel)object;
                StringBuffer stringBuffer = new StringBuffer();
                if (this._what != null && this._what.length() > 0) {
                    stringBuffer.append(this._what);
                }
                if (this._property != null && this._property.length() > 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" - ");
                    }
                    stringBuffer.append(this._property);
                }
                if ((color = JColorChooser.showDialog(this, stringBuffer.toString(), ((ColorFillIcon)jLabel.getIcon()).getFillColor())) != null) {
                    ((ColorFillIcon)jLabel.getIcon()).setFillColor(color);
                }
                this.selectedItemChanged();
            }
        } else {
            this._ignoreColorChange = false;
        }
    }
}

