/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

class ColorFillIcon
implements Icon {
    protected int _width;
    protected int _height;
    protected Color _fillColor;
    protected Color _shadow;
    protected int _borderSize;
    protected int _fillHeight;
    protected int _fillWidth;
    public static final int BORDER_SIZE = 2;
    public static final int DEFAULT_SIZE = 32;

    ColorFillIcon(Color color, int n, int n2, int n3) {
        this._fillColor = color;
        this._borderSize = n3;
        this._width = n;
        this._height = n2;
        this._shadow = Color.black;
        this._fillWidth = n - 2 * n3;
        this._fillHeight = n2 - 2 * n3;
    }

    ColorFillIcon(Color color, int n) {
        this(color, n, n, 2);
    }

    ColorFillIcon(Color color) {
        this(color, 32, 32, 2);
    }

    void setShadow(Color color) {
        this._shadow = color;
    }

    void setFillColor(Color color) {
        this._fillColor = color;
    }

    @Override
    public int getIconWidth() {
        return this._width;
    }

    @Override
    public int getIconHeight() {
        return this._height;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        if (this._borderSize > 0) {
            graphics.setColor(this._shadow);
            for (int i = 0; i < this._borderSize; ++i) {
                graphics.drawRect(n + i, n2 + i, this._width - 2 * i - 1, this._height - 2 * i - 1);
            }
        }
        graphics.setColor(this._fillColor);
        graphics.fillRect(n + this._borderSize, n2 + this._borderSize, this._fillWidth, this._fillHeight);
        graphics.setColor(color);
    }

    Color getFillColor() {
        return this._fillColor;
    }
}

