/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.SCEditorProperties;
import com.sybase.customization.CustomizationPage;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.SybCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class EditorCustomizationPage
extends JPanel
implements ItemListener,
CustomizationPage {
    private static HelpViewer _helpViewer = null;
    SybCheckBox _verticalScrollBar;
    SybCheckBox _horizontalScrollBar;
    SybCheckBox _dragAndDrop;
    Insets _insets3333 = new Insets(3, 3, 3, 3);

    EditorCustomizationPage() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this._verticalScrollBar = new SybCheckBox();
        this.add((Component)this._verticalScrollBar);
        this._horizontalScrollBar = new SybCheckBox();
        this.add((Component)this._horizontalScrollBar);
        this._dragAndDrop = new SybCheckBox();
        this._verticalScrollBar.addItemListener((ItemListener)this);
        this._verticalScrollBar.setText(ResourceManager.getI18NMessage("verticalScrollBar"));
        this._verticalScrollBar.setToolTipText(ResourceManager.getI18NMessage("verticalScrollBarTip"));
        this._horizontalScrollBar.addItemListener((ItemListener)this);
        this._horizontalScrollBar.setText(ResourceManager.getI18NMessage("horizontalScrollBar"));
        this._horizontalScrollBar.setToolTipText(ResourceManager.getI18NMessage("horizontalScrollBarTip"));
        this._dragAndDrop.addItemListener((ItemListener)this);
        this._dragAndDrop.setText(ResourceManager.getI18NMessage("dragAndDrop"));
        this._dragAndDrop.setToolTipText(ResourceManager.getI18NMessage("dragAndDropTip"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = this._insets3333;
        gridBagLayout.setConstraints((Component)this._verticalScrollBar, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints((Component)this._horizontalScrollBar, gridBagConstraints);
    }

    public void initialize() {
        this._verticalScrollBar.setSelected(SCEditorProperties.getVerticalScrollBar());
        this._horizontalScrollBar.setSelected(SCEditorProperties.getHorizontalScrollBar());
        this._dragAndDrop.setSelected(SCEditorProperties.getDragAndDropEditing());
    }

    public boolean validateChanges() {
        return true;
    }

    public String getTitle() {
        return ResourceManager.getI18NMessage("Editor");
    }

    public void destroy() {
        this._verticalScrollBar.removeItemListener((ItemListener)this);
        this._horizontalScrollBar.removeItemListener((ItemListener)this);
        this._dragAndDrop.removeItemListener((ItemListener)this);
    }

    private HelpViewer getHelpViewer() {
        if (_helpViewer == null) {
            try {
                _helpViewer = FactoryHelp.getHelpViewer((String)SCEditor._helpFolder, (String)SCEditor._helpFile, (String)SCEditor._helpVersion);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                // empty catch block
            }
        }
        return _helpViewer;
    }

    public void showHelp() {
        if (this.getHelpViewer() != null) {
            this.getHelpViewer().turnPage("HELP_SCEDITOR_EDITOR_CUSTOMIZATION", SwingUtilities.windowForComponent(this));
        }
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._verticalScrollBar) {
            SCEditorProperties.setVerticalScrollBar(this._verticalScrollBar.isSelected());
        } else if (object == this._horizontalScrollBar) {
            SCEditorProperties.setHorizontalScrollBar(this._horizontalScrollBar.isSelected());
        } else if (object == this._dragAndDrop) {
            SCEditorProperties.setDragAndDropEditing(this._dragAndDrop.isSelected());
        }
    }
}

