/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.FindReplaceListener;
import com.sybase.central.editor.JavaParser;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.PlainParser;
import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.SCEditorFrame;
import com.sybase.central.editor.SCEditorProperties;
import com.sybase.central.editor.WsqlParser;
import com.sybase.util.PrintJobListener;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

class FileHolder
implements CaretListener,
PropertyChangeListener,
FindReplaceListener {
    String _fileName = null;
    JInternalFrame _internalFrame = null;
    JPanel _internalPanel = null;
    SCEditor _editor = null;
    File _file = null;
    long _lastModified = 0L;
    JScrollPane _scrollPane = null;
    SCEditorFrame _parent = null;
    Charset _charset = null;

    FileHolder(String string, Container container, boolean bl, SCEditorFrame sCEditorFrame, Parser parser, Charset charset) {
        this._fileName = string;
        this._file = new File(this._fileName);
        this._parent = sCEditorFrame;
        this._parent._progressBar.setMaximum((int)this._file.length());
        if (parser == null) {
            parser = string.endsWith(".java") ? JavaParser.getInstance() : (string.endsWith(".sql") ? WsqlParser.getInstance() : PlainParser.getInstance());
        }
        this._charset = charset;
        this.reload(parser, this._charset);
        this._editor.setEditable(bl);
        this._editor.addCaretListener(this);
        this._editor.setFileName(this._fileName);
        this._scrollPane = new JScrollPane(this._editor);
        if (SCEditorProperties.getHorizontalScrollBar()) {
            this._scrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._scrollPane.setHorizontalScrollBarPolicy(31);
        }
        if (SCEditorProperties.getVerticalScrollBar()) {
            this._scrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this._scrollPane.setVerticalScrollBarPolicy(21);
        }
        if (container instanceof JInternalFrame) {
            this._internalFrame = (JInternalFrame)container;
            this._internalFrame.setTitle(this._fileName);
            this._internalFrame.setContentPane(this._scrollPane);
            this._internalFrame.addPropertyChangeListener(this);
        } else {
            this._internalPanel = (JPanel)container;
            this._internalPanel.add((Component)this._scrollPane, "Center");
            this._internalPanel.updateUI();
        }
        this.updateUndoRedoState();
    }

    void updateUndoRedoState() {
        boolean bl;
        if (this._parent._undoMenuItem != null) {
            bl = this._editor.getUndoManager().canUndo();
            this._parent._undoAction.setEnabled(bl);
        }
        if (this._parent._redoMenuItem != null) {
            bl = this._editor.getUndoManager().canRedo();
            this._parent._redoAction.setEnabled(bl);
        }
    }

    public void undo() {
        if (this._editor.getUndoManager().canUndo()) {
            this._editor.getUndoManager().undo();
        }
        this.updateUndoRedoState();
    }

    public void redo() {
        if (this._editor.getUndoManager().canRedo()) {
            this._editor.getUndoManager().redo();
        }
        this.updateUndoRedoState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Caret caret;
        if (propertyChangeEvent.getPropertyName().equals("selected") && (caret = this._editor.getCaret()) != null) {
            caret.setVisible(true);
            this.updateLineAndColumnLabel(caret.getDot());
        }
    }

    void updateTitle() {
        if (this._internalFrame != null) {
            if (this.isChanged()) {
                this._internalFrame.setTitle(this._fileName + "*");
                this._internalFrame.putClientProperty("windowModified", Boolean.TRUE);
            } else {
                this._internalFrame.setTitle(this._fileName);
                this._internalFrame.putClientProperty("windowModified", Boolean.FALSE);
            }
        } else {
            JRootPane jRootPane = SwingUtilities.getRootPane(this._internalPanel);
            if (jRootPane != null) {
                if (this.isChanged()) {
                    this._parent.setTitle(this._parent._title + "*", false);
                    jRootPane.putClientProperty("windowModified", Boolean.TRUE);
                } else {
                    this._parent.setTitle(this._parent._title, false);
                    jRootPane.putClientProperty("windowModified", Boolean.FALSE);
                }
            }
        }
    }

    void setChanged(boolean bl) {
        this._editor.setChanged(bl);
    }

    boolean isChanged() {
        return this._editor.isChanged();
    }

    void setFileName(String string) {
        this._fileName = string;
        this._file = null;
        this._file = new File(this._fileName);
        this._lastModified = this._file.lastModified();
        if (this._internalFrame != null) {
            this._internalFrame.setTitle(this._fileName);
            this.updateTitle();
        }
        this._editor.setFileName(this._fileName);
    }

    String getFileName() {
        return this._fileName;
    }

    void setEditorType(String string) {
        this._editor.setEditorType(string);
    }

    void saveFile(Charset charset) throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this._file);
            OutputStreamWriter outputStreamWriter = charset == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, charset);
            this._editor.write(outputStreamWriter);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            this._editor.setChanged(false);
            this._lastModified = this._file.lastModified();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this._internalFrame != null) {
                SybOptionPane.showInternalMessageDialog((Component)this._internalFrame, (Object)(ResourceManager.getI18NMessage("Failed to write to \"") + this._fileName + ".\n\n" + fileNotFoundException.getLocalizedMessage() + "\n"), (String)ResourceManager.getI18NMessage("Error"), (int)0);
            } else {
                SybOptionPane.showMessageDialog((Component)this._parent, (Object)("Failed to write to \"" + this._fileName + ".\n\n" + fileNotFoundException.getLocalizedMessage() + "\n"), (String)ResourceManager.getI18NMessage("Error"), (int)0);
            }
            Toolkit.getDefaultToolkit().beep();
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            if (this._internalFrame != null) {
                SybOptionPane.showInternalMessageDialog((Component)this._internalFrame, (Object)(ResourceManager.getI18NMessage("Failed to write to \"") + this._fileName + ".\n\n" + iOException.getLocalizedMessage() + "\n"), (String)ResourceManager.getI18NMessage("Error"), (int)0);
            } else {
                this._lastModified = this._file.lastModified();
                SybOptionPane.showMessageDialog((Component)this._parent, (Object)(ResourceManager.getI18NMessage("Failed to write to \"") + this._fileName + ".\n\n" + iOException.getLocalizedMessage() + "\n"), (String)ResourceManager.getI18NMessage("Error"), (int)0);
            }
            Toolkit.getDefaultToolkit().beep();
            throw iOException;
        }
    }

    void print() {
        this._editor.print(this._fileName, (PrintJobListener)this._parent);
    }

    boolean isPrinting() {
        return this._editor.isPrinting();
    }

    void cancelPrint() {
        this._editor.cancelPrint();
    }

    void cut() {
        this._editor.cut();
    }

    void copy() {
        this._editor.copy();
    }

    void paste() {
        this._editor.paste();
    }

    void selectAll() {
        this._editor.selectAll();
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateLineAndColumnLabel(caretEvent.getDot());
    }

    void updateLineAndColumnLabel(int n) {
        Point point = this._editor.getCaretLineAndColumn(n);
        int n2 = point.x;
        int n3 = point.y;
        if (this._parent._xLabel != null) {
            this._parent._xLabel.setText(Integer.toString(n2));
        }
        if (this._parent._yLabel != null) {
            this._parent._yLabel.setText(Integer.toString(n3));
        }
    }

    UndoManager getUndoManager() {
        return this._editor.getUndoManager();
    }

    JInternalFrame getInternalFrame() {
        return this._internalFrame;
    }

    @Override
    public boolean find(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this._editor.find(string, bl, bl2, bl3, bl4);
    }

    @Override
    public boolean replace(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        return this._editor.replace(string, string2, bl, bl2, bl3);
    }

    @Override
    public boolean replaceAll(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        return this._editor.replaceAll(string, string2, bl, bl2, bl3);
    }

    @Override
    public boolean replace(String string, String string2) {
        return this._editor.replace(string, string2);
    }

    @Override
    public boolean replaceAll(String string, String string2) {
        return this._editor.replaceAll(string, string2);
    }

    @Override
    public String getSelectedText() {
        return this._editor.getSelectedText();
    }

    SCEditor getEditor() {
        return this._editor;
    }

    void setEditorStyles() {
        this._editor.setEditorStyles();
    }

    @Override
    public String getText() {
        try {
            return this._editor.getDocument().getText(0, this._editor.getDocument().getLength());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Document getDocument() {
        try {
            return this._editor.getDocument();
        }
        catch (Exception exception) {
            return null;
        }
    }

    void setText(String string) {
        this._editor.setText(string);
    }

    void setText(String string, Parser parser) {
        this._editor.setText(string, parser);
    }

    @Override
    public boolean isEditable() {
        return this._editor.isEditable();
    }

    void setEditable(boolean bl) {
        this._editor.setEditable(bl);
    }

    File getFile() {
        return this._file;
    }

    void setFile(File file) {
        this._file = file;
    }

    long getLastModified() {
        return this._lastModified;
    }

    void setLastModified(long l) {
        this._lastModified = l;
    }

    void updateLastModified() {
        this._lastModified = this._file.lastModified();
    }

    void reload() {
        this.reload(null, null);
    }

    void reload(Parser parser, Charset charset) {
        InputStreamReader inputStreamReader = null;
        if (charset == null) {
            try {
                inputStreamReader = new FileReader(this._fileName);
            }
            catch (Exception exception) {}
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(this._file);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = false;
        try {
            bl = this._file.exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl || inputStreamReader == null) {
            this._editor = new SCEditor(null, false, false, this, parser, this._parent._progressBar.getModel());
        } else if (this._editor == null) {
            this._editor = new SCEditor(inputStreamReader, false, false, this, parser, this._parent._progressBar.getModel());
        } else {
            this._editor.reload(inputStreamReader, this._editor.getCaretPosition());
        }
        this._editor.addAsynchronousTaskListener(this._parent);
        this.updateLastModified();
        this.setChanged(false);
    }

    @Override
    public void setCaretPosition(int n) {
        this._editor.setCaretPosition(n);
    }

    @Override
    public int getCaretPosition() {
        return this._editor.getCaretPosition();
    }

    void goTo(int n) {
        this._editor.goTo(n);
    }

    void goTo(int n, int n2) {
        this._editor.goTo(n, n2);
    }

    Charset getCharset() {
        return this._charset;
    }

    void destroy() {
        this._editor.transferFocus();
        this._editor.removeCaretListener(this);
        if (this._internalFrame != null) {
            this._internalFrame.removePropertyChangeListener(this);
            this._internalFrame = null;
        } else if (this._internalPanel != null) {
            this._internalPanel.remove(0);
            this._internalPanel = null;
        }
        this._fileName = null;
        this._file = null;
        this._scrollPane = null;
        this._editor.destroy();
        this._editor = null;
        this._parent = null;
        this._charset = null;
    }
}

