/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.FindInFilesDialog;
import com.sybase.central.editor.SCEditorListModel;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JList;
import javax.swing.SwingUtilities;

class FindInFiles
extends Thread {
    FindInFilesDialog _parent = null;
    String _what = null;
    String _fileType = null;
    String _folder = null;
    boolean _matchWholeWord = false;
    boolean _matchCase = false;
    boolean _lookInSubfolders = false;
    JList _list = null;
    boolean _stop = false;
    String[] _filterStartsWith = null;
    String[] _filterEndsWith = null;
    int _occurrenceCount = 0;
    char[] _lineBuffer = new char[2048];
    int _lineBufferLength = 0;
    char[] _cb = new char[8192];
    int _nChars;
    int _nextChar;
    boolean _eof = false;
    FileReader _fReader = null;
    int _lineNumber = 0;
    SCEditorListModel _listDataModel;

    FindInFiles(FindInFilesDialog findInFilesDialog, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, JList jList) {
        super(string);
        this._parent = findInFilesDialog;
        this._what = string;
        this._fileType = string2;
        this._folder = string3;
        this._matchWholeWord = bl;
        this._matchCase = bl2;
        this._lookInSubfolders = bl3;
        this._list = jList;
        this._listDataModel = new SCEditorListModel();
        this._list.setModel(this._listDataModel);
    }

    void cancelFind() {
        this._stop = true;
    }

    @Override
    public void run() {
        if (this._what == null || this._what.equals("")) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this._fileType, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.updateListNow(new StringBuffer("Searching for '").append(this._what).append("'..."));
        this._list.updateUI();
        this.buildFileFilter(arrayList.toArray());
        if (!this._matchCase) {
            this._what = this._what.toUpperCase();
        }
        this.search(this._folder);
        if (this._stop) {
            this.updateListNow("Canceled");
        } else {
            this.updateListNow(new StringBuffer().append(this._occurrenceCount).append(" occurrence(s) have been found."));
            Runnable runnable = new Runnable(){

                @Override
                public synchronized void run() {
                    FindInFiles.this._parent.findFinished();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    void search(String string) {
        if (this._stop) {
            return;
        }
        File file = new File(string);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(string + File.separator + stringArray[i]);
            if (this._lookInSubfolders && file2.isDirectory()) {
                this.search(file2.getAbsolutePath());
            } else if (file2.isFile()) {
                for (int j = 0; j < this._filterStartsWith.length; ++j) {
                    boolean bl = false;
                    boolean bl2 = false;
                    if (this._filterEndsWith[j] == null || stringArray[i].endsWith(this._filterEndsWith[j])) {
                        bl = true;
                    }
                    if (this._filterStartsWith[j] == null || stringArray[i].startsWith(this._filterStartsWith[j])) {
                        bl2 = true;
                    }
                    if (!bl || !bl2) continue;
                    this.scanFile(file2);
                    FindInFiles.yield();
                }
            }
            if (!this._stop) continue;
            return;
        }
    }

    void scanFile(File file) {
        try {
            this._fReader = new FileReader(file);
            this._nChars = 0;
            this._nextChar = 0;
            this._eof = false;
            this._lineNumber = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                this.readLine();
                if (this.indexOf(this._what) == -1) continue;
                arrayList.add(new StringBuffer(file.getAbsolutePath()).append("(").append(this._lineNumber).append("): ").append(this._lineBuffer, 0, this._lineBufferLength).toString());
                ++this._occurrenceCount;
            } while (!this._eof && !this._stop);
            this._fReader.close();
            if (arrayList.size() > 0) {
                this.updateList(arrayList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void readLine() throws IOException {
        char c;
        boolean bl;
        this._lineBufferLength = 0;
        do {
            int n;
            if (this._nextChar >= this._nChars) {
                this.fill();
            }
            if (this._nextChar >= this._nChars) {
                this._eof = true;
                return;
            }
            bl = false;
            c = '\u0000';
            for (n = this._nextChar; n < this._nChars; ++n) {
                c = this._cb[n];
                if (c == '\n' || c == '\r') {
                    bl = true;
                    break;
                }
                this._lineBuffer[this._lineBufferLength++] = c;
            }
            this._nextChar = n;
        } while (!bl);
        ++this._nextChar;
        if (c == '\r') {
            if (this._nextChar >= this._nChars) {
                this.fill();
            }
            if (this._nextChar < this._nChars && this._cb[this._nextChar] == '\n') {
                ++this._nextChar;
            }
        }
        ++this._lineNumber;
    }

    private void fill() throws IOException {
        int n;
        while ((n = this._fReader.read(this._cb, 0, this._cb.length)) == 0) {
        }
        if (n > 0) {
            this._nChars = n;
            this._nextChar = 0;
        }
    }

    int indexOf(String string) {
        char[] cArray = this._matchCase ? string.toCharArray() : string.toUpperCase().toCharArray();
        int n = this._lineBufferLength - string.length();
        if (this._lineBufferLength == 0) {
            if (string.length() == 0) {
                return 0;
            }
            return -1;
        }
        if (string.length() == 0) {
            return 0;
        }
        char c = cArray[0];
        int n2 = 0;
        block0: while (true) {
            int n3;
            if (n2 <= n && (this._matchCase ? this._lineBuffer[n2] : Character.toUpperCase(this._lineBuffer[n2])) != c) {
                ++n2;
                continue;
            }
            if (n2 > n) {
                return -1;
            }
            if (this._matchWholeWord && n2 > 0 && !Character.isLetterOrDigit(this._lineBuffer[n2])) continue;
            int n4 = n2 + 1;
            int n5 = n4 + string.length() - 1;
            int n6 = 1;
            while (n4 < n5) {
                if ((this._matchCase ? this._lineBuffer[n4++] : Character.toUpperCase(this._lineBuffer[n4++])) == cArray[n6++]) continue;
                ++n2;
                continue block0;
            }
            if (!this._matchWholeWord || (n3 = n4 - 1) >= this._lineBufferLength || Character.isLetterOrDigit(this._lineBuffer[n3])) break;
        }
        return n2;
    }

    void buildFileFilter(Object[] objectArray) {
        this._filterStartsWith = new String[objectArray.length];
        this._filterEndsWith = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            int n = string.indexOf(42);
            this._filterStartsWith[i] = n < 1 ? null : string.substring(0, n);
            int n2 = string.indexOf(46);
            this._filterEndsWith[i] = n2 < 0 ? null : string.substring(n2);
        }
    }

    private final void updateList(final List<String> list) {
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                FindInFiles.this._listDataModel.addElements(list);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private final void updateListNow(final Object object) {
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                FindInFiles.this._listDataModel.addElement(object);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

