/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.FindReplaceListener;
import com.sybase.central.editor.ResourceManager;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

class FindReplaceDialog
extends SybModalDialog
implements WindowListener,
ActionListener,
KeyListener,
DocumentListener {
    ButtonGroup directionPanel_searchDirection;
    JPanel commandPanel;
    SybButton findButton;
    SybButton _cancelButton;
    SybButton replaceButton;
    SybButton replaceAllButton;
    JPanel centerPanel;
    JPanel inputPanel;
    SybLabel findLabel;
    JComboBox findComponent;
    SybLabel replaceLabel;
    JComboBox replaceComponent;
    JPanel directionPanel;
    SybRadioButton upDirection;
    SybRadioButton downDirection;
    JPanel optionPanel;
    SybCheckBox matchCase;
    SybCheckBox wholeWord;
    SybCheckBox searchInSelection;
    JPanel dummyPanel;
    private String _oldFindValue;
    private String _oldReplaceValue;
    FindReplaceListener _listener = null;

    void destroy() {
        this.removeWindowListener(this);
        this.removeKeyListener(this);
        this.findComponent.getEditor().getEditorComponent().removeKeyListener(this);
        ((JTextField)this.findComponent.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this);
        this.findButton.removeActionListener((ActionListener)this);
        this._cancelButton.removeActionListener((ActionListener)this);
        this.replaceButton.removeActionListener((ActionListener)this);
        this.replaceAllButton.removeActionListener((ActionListener)this);
        DialogUtils.removeComponents((Container)((Object)this));
        this.dispose();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() == 0) {
            this.findButton.setEnabled(false);
            this.replaceButton.setEnabled(false);
            this.replaceAllButton.setEnabled(false);
        } else {
            this.findButton.setEnabled(true);
            if (this._listener != null && this._listener.isEditable()) {
                this.replaceButton.setEnabled(true);
                this.replaceAllButton.setEnabled(true);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.detachListener();
        this.setVisible(false);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void find() {
        this._oldFindValue = this.findComponent.getEditor().getItem().toString();
        this.find(false);
    }

    private void find(boolean bl) {
        int n = this._listener.getCaretPosition();
        if (!(!bl && this._listener.find(this._oldFindValue, this.matchCase.isSelected(), this.wholeWord.isSelected(), this.searchInSelection.isEnabled() && this.searchInSelection.isSelected(), this.downDirection.isSelected()) || bl && this._listener.replace(this._oldFindValue, this._oldReplaceValue, this.matchCase.isSelected(), this.wholeWord.isSelected(), this.downDirection.isSelected()))) {
            Object[] objectArray = new Object[]{ResourceManager.getI18NMessage("Yes"), ResourceManager.getI18NMessage("No")};
            Object[] objectArray2 = new Object[]{ResourceManager.getI18NMessage("OK")};
            if (!this.searchInSelection.isEnabled() || !this.searchInSelection.isSelected()) {
                int n2 = 1;
                if (this.downDirection.isSelected()) {
                    String string;
                    boolean bl2 = false;
                    try {
                        string = this._listener.getDocument().getText(0, this._listener.getDocument().getLength());
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    if (n > 0) {
                        int n3 = string.length() - 1;
                        int n4 = string.trim().length();
                        char c = string.charAt(n3);
                        while (n3 >= n4 && Character.isWhitespace(c)) {
                            c = string.charAt(--n3);
                        }
                        if (n > n3) {
                            bl2 = true;
                        }
                    } else if (n == 0) {
                        bl2 = true;
                    }
                    if (bl2) {
                        SybOptionPane.showOptionDialog((Component)((Object)this), (Object)ResourceManager.getI18NMessage("Finished searching."), (String)ResourceManager.getI18NMessage("Find/Replace"), (int)0, (int)3, null, (Object[])objectArray2, (Object)objectArray2[0]);
                    } else {
                        n2 = SybOptionPane.showOptionDialog((Component)((Object)this), (Object)ResourceManager.getI18NMessage("The search text was not found.  Do you wish to continue searching from the beginning?"), (String)ResourceManager.getI18NMessage("Find/Replace"), (int)0, (int)3, null, (Object[])objectArray, (Object)objectArray[0]);
                    }
                } else {
                    String string;
                    boolean bl3 = false;
                    try {
                        string = this._listener.getDocument().getText(0, this._listener.getDocument().getLength());
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    if (n == 0) {
                        bl3 = true;
                    } else if (n > 0) {
                        int n5 = string.length() - 1;
                        int n6 = string.trim().length();
                        char c = string.charAt(n5);
                        while (n5 >= n6 && Character.isWhitespace(c)) {
                            c = string.charAt(--n5);
                        }
                        if (n > n5) {
                            bl3 = true;
                        }
                    }
                    if (bl3) {
                        SybOptionPane.showOptionDialog((Component)((Object)this), (Object)ResourceManager.getI18NMessage("Finished searching."), (String)ResourceManager.getI18NMessage("Find/Replace"), (int)0, (int)3, null, (Object[])objectArray2, (Object)objectArray2[0]);
                    } else {
                        n2 = SybOptionPane.showOptionDialog((Component)((Object)this), (Object)ResourceManager.getI18NMessage("The search text was not found.  Do you wish to continue searching from the end?"), (String)ResourceManager.getI18NMessage("Find/Replace"), (int)0, (int)3, null, (Object[])objectArray, (Object)objectArray[0]);
                    }
                }
                if (n2 == 0) {
                    if (this.downDirection.isSelected()) {
                        this._listener.setCaretPosition(0);
                    } else {
                        this._listener.setCaretPosition(this._listener.getDocument().getLength());
                    }
                    if (!(!bl && this._listener.find(this._oldFindValue, this.matchCase.isSelected(), this.wholeWord.isSelected(), this.searchInSelection.isEnabled() && this.searchInSelection.isSelected(), this.downDirection.isSelected()) || bl && this._listener.replace(this._oldFindValue, this._oldReplaceValue, this.matchCase.isSelected(), this.wholeWord.isSelected(), this.downDirection.isSelected()))) {
                        SybOptionPane.showOptionDialog((Component)((Object)this), (Object)ResourceManager.getI18NMessage("Finished searching."), (String)ResourceManager.getI18NMessage("Find/Replace"), (int)0, (int)3, null, (Object[])objectArray2, (Object)objectArray2[0]);
                    }
                }
            } else {
                SybOptionPane.showOptionDialog((Component)((Object)this), (Object)ResourceManager.getI18NMessage("Finished searching."), (String)ResourceManager.getI18NMessage("Find/Replace"), (int)0, (int)3, null, (Object[])objectArray2, (Object)objectArray2[0]);
            }
        }
        this.searchInSelection.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this._listener != null) {
            if (object == this.findButton || object == this.replaceButton || object == this.replaceAllButton) {
                this._oldFindValue = this.findComponent.getEditor().getItem().toString();
                this._oldReplaceValue = this.replaceComponent.getEditor().getItem().toString();
                if (this.findComponent.getItemCount() > 0) {
                    if (!this.findComponent.getItemAt(0).toString().equals(this._oldFindValue)) {
                        this.findComponent.insertItemAt(this._oldFindValue, 0);
                    }
                } else {
                    this.findComponent.addItem(this._oldFindValue);
                }
                if (this.replaceComponent.getItemCount() > 0) {
                    if (!this.replaceComponent.getItemAt(0).toString().equals(this._oldReplaceValue)) {
                        this.replaceComponent.insertItemAt(this._oldReplaceValue, 0);
                    }
                } else {
                    this.replaceComponent.addItem(this._oldReplaceValue);
                }
            }
            if (object == this.findButton) {
                this.find(false);
            } else if (object == this.replaceButton) {
                String string;
                String string2 = string = this._listener.getSelectedText() == null ? "" : this._listener.getSelectedText();
                if (this.matchCase.isSelected() && string.equals(this.getSearchText()) || string.equalsIgnoreCase(this.getSearchText())) {
                    this.find(true);
                } else {
                    this.find(false);
                }
            } else if (object == this.replaceAllButton) {
                this._listener.replaceAll(this._oldFindValue, this._oldReplaceValue, this.matchCase.isSelected(), this.wholeWord.isSelected(), this.searchInSelection.isSelected());
            }
        }
        if (object == this._cancelButton) {
            this.findComponent.getEditor().getEditorComponent().requestFocusInWindow();
            this._cancelButton.transferFocusBackward();
            this.windowClosing(null);
            this.findComponent.getEditor().setItem(this._oldFindValue);
            this.replaceComponent.getEditor().setItem(this._oldReplaceValue);
        }
    }

    FindReplaceDialog(Frame frame) {
        super(frame);
        this.setTitle(ResourceManager.getI18NMessage("Find/Replace"));
        this.setResizable(true);
        Container container = this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(gridBagLayout);
        container.add((Component)this.centerPanel, "Center");
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(gridBagLayout2);
        this.centerPanel.add(this.inputPanel);
        this.replaceLabel = new SybLabel(ResourceManager.getI18NMessage("Replace:"));
        this.inputPanel.add((Component)this.replaceLabel);
        this.findComponent = new JComboBox();
        new FontHelper(this.findComponent);
        this.inputPanel.add(this.findComponent);
        this.replaceComponent = new JComboBox();
        new FontHelper(this.replaceComponent);
        this.inputPanel.add(this.replaceComponent);
        this.findLabel = new SybLabel(ResourceManager.getI18NMessage("Find:"));
        this.inputPanel.add((Component)this.findLabel);
        GridLayout gridLayout = new GridLayout();
        this.directionPanel = new JPanel();
        this.directionPanel.setLayout(gridLayout);
        gridLayout.setHgap(0);
        gridLayout.setVgap(0);
        gridLayout.setRows(2);
        gridLayout.setColumns(0);
        this.centerPanel.add(this.directionPanel);
        this.upDirection = new SybRadioButton();
        this.directionPanel.add((Component)this.upDirection);
        this.downDirection = new SybRadioButton();
        this.directionPanel.add((Component)this.downDirection);
        GridLayout gridLayout2 = new GridLayout();
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(gridLayout2);
        gridLayout2.setHgap(0);
        gridLayout2.setVgap(0);
        gridLayout2.setRows(3);
        gridLayout2.setColumns(0);
        this.centerPanel.add(this.optionPanel);
        this.matchCase = new SybCheckBox();
        this.optionPanel.add((Component)this.matchCase);
        this.wholeWord = new SybCheckBox();
        this.optionPanel.add((Component)this.wholeWord);
        this.searchInSelection = new SybCheckBox();
        this.optionPanel.add((Component)this.searchInSelection);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        this.commandPanel = new JPanel();
        this.commandPanel.setLayout(gridBagLayout3);
        container.add((Component)this.commandPanel, "East");
        this.findButton = new SybButton();
        this.findButton.setDefaultCapable(true);
        this.commandPanel.add((Component)this.findButton);
        this._cancelButton = new SybButton();
        this.commandPanel.add((Component)this._cancelButton);
        this.replaceButton = new SybButton();
        this.commandPanel.add((Component)this.replaceButton);
        this.replaceAllButton = new SybButton();
        this.commandPanel.add((Component)this.replaceAllButton);
        this.dummyPanel = new JPanel();
        this.commandPanel.add(this.dummyPanel);
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.findComponent.getEditor().getEditorComponent().addKeyListener(this);
        ((JTextField)this.findComponent.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.findButton.addActionListener((ActionListener)this);
        this.findButton.setText(ResourceManager.getI18NMessage("Find"));
        this.findButton.setToolTipText(ResourceManager.getI18NMessage("findTip"));
        this.findButton.setEnabled(false);
        this._cancelButton.addActionListener((ActionListener)this);
        this._cancelButton.setText(ResourceManager.getI18NMessage("CancelFind"));
        this._cancelButton.setToolTipText(ResourceManager.getI18NMessage("cancelTip"));
        this.replaceButton.addActionListener((ActionListener)this);
        this.replaceButton.setText(ResourceManager.getI18NMessage("Replace"));
        this.replaceButton.setToolTipText(ResourceManager.getI18NMessage("replaceTip"));
        this.replaceButton.setEnabled(false);
        this.replaceAllButton.addActionListener((ActionListener)this);
        this.replaceAllButton.setText(ResourceManager.getI18NMessage("Replace All"));
        this.replaceAllButton.setToolTipText(ResourceManager.getI18NMessage("replaceAllTip"));
        this.replaceAllButton.setEnabled(false);
        this.replaceComponent.setEditable(true);
        this.replaceComponent.getAccessibleContext().setAccessibleDescription(ResourceManager.getI18NMessage("replaceComponent"));
        this.replaceLabel.setLabelFor(this.replaceComponent.getEditor().getEditorComponent());
        this.findComponent.setEditable(true);
        this.findComponent.getAccessibleContext().setAccessibleDescription(ResourceManager.getI18NMessage("findComponent"));
        this.findLabel.setLabelFor(this.findComponent.getEditor().getEditorComponent());
        this.directionPanel.setBorder(BorderFactory.createTitledBorder(ResourceManager.getI18NMessage("Search Direction")));
        this.directionPanel_searchDirection = new ButtonGroup();
        this.directionPanel_searchDirection.add((AbstractButton)this.upDirection);
        this.upDirection.setText(ResourceManager.getI18NMessage("Up"));
        this.upDirection.setToolTipText(ResourceManager.getI18NMessage("UpTip"));
        this.directionPanel_searchDirection.add((AbstractButton)this.downDirection);
        this.downDirection.setText(ResourceManager.getI18NMessage("Down"));
        this.downDirection.setSelected(true);
        this.downDirection.setToolTipText(ResourceManager.getI18NMessage("DownTip"));
        this.matchCase.setText(ResourceManager.getI18NMessage("Match Case"));
        this.matchCase.setToolTipText(ResourceManager.getI18NMessage("matchCaseTip"));
        this.wholeWord.setText(ResourceManager.getI18NMessage("Whole Word"));
        this.wholeWord.setToolTipText(ResourceManager.getI18NMessage("wholeWordTip"));
        this.searchInSelection.setText(ResourceManager.getI18NMessage("Look In Selection"));
        this.searchInSelection.setToolTipText(ResourceManager.getI18NMessage("lookInSelectionTip"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.ipadx = 22;
        gridBagLayout3.setConstraints((Component)this.findButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 14;
        gridBagLayout3.setConstraints((Component)this._cancelButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 10;
        gridBagLayout3.setConstraints((Component)this.replaceButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagLayout3.setConstraints((Component)this.replaceAllButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout3.setConstraints(this.dummyPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.ipadx = 10;
        gridBagConstraints2.ipady = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagLayout2.setConstraints((Component)this.findLabel, gridBagConstraints2);
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.ipadx = 70;
        gridBagConstraints2.ipady = 2;
        gridBagLayout2.setConstraints((Component)this.replaceLabel, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 5);
        gridBagConstraints2.ipadx = 42;
        gridBagLayout2.setConstraints(this.findComponent, gridBagConstraints2);
        gridBagConstraints2.gridy = 3;
        gridBagLayout2.setConstraints(this.replaceComponent, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 2;
        gridBagLayout.setConstraints(this.inputPanel, gridBagConstraints3);
        gridBagConstraints3.anchor = 16;
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.ipadx = 66;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout.setConstraints(this.directionPanel, gridBagConstraints3);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.ipadx = 32;
        gridBagLayout.setConstraints(this.optionPanel, gridBagConstraints3);
        this.setResizable(true);
        this.pack();
        this.findComponent.requestFocusInWindow();
        this.setLocationRelativeTo(frame);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.windowClosing(null);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = this._cancelButton.getInputMap(2);
        ActionMap actionMap = this._cancelButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
    }

    public void attachListener(FindReplaceListener findReplaceListener) {
        this._listener = findReplaceListener;
    }

    public void detachListener() {
        if (this._listener != null) {
            this._listener = null;
        }
    }

    public String getSearchText() {
        String string = this.findComponent.getEditor().getItem().toString();
        if (string != null && string.length() == 0) {
            return "";
        }
        return string;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this._oldFindValue = this.findComponent.getEditor().getItem().toString();
            this._oldReplaceValue = this.replaceComponent.getEditor().getItem().toString();
            this.findComponent.getEditor().getEditorComponent().requestFocusInWindow();
            ((JTextComponent)this.findComponent.getEditor().getEditorComponent()).selectAll();
        }
        super.setVisible(bl);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            if (this._listener != null) {
                this.find();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

