/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class IntegerTextField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.getDefault());

    IntegerTextField() {
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(0);
    }

    IntegerTextField(int n, int n2) {
        super(n2);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(n);
    }

    IntegerTextField(String string, int n) {
        super(n);
        this.integerFormatter.setParseIntegerOnly(true);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValue(n2);
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        return n;
    }

    @Override
    public String getText() {
        String string = super.getText();
        if (string == null || string.length() == 0) {
            string = "0";
        }
        return string;
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    @Override
    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    private class IntegerDocument
    extends PlainDocument {
        private IntegerDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                IntegerTextField.this.toolkit.beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

