/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.Parser;
import com.sybase.central.editor.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaParser
implements Parser {
    private String _singleLineComment = "//[^\n]*";
    private String _multiLineComment = "/\\*[^*].*?\\*/";
    private String _inMultiLineComment = "/\\*[^*].*?$";
    private String _formalComment = "/\\*\\*.*?\\*/";
    private String _inFormalComment = "/\\*\\*.*?$";
    private String _character = "'(?:''|[^'\\\\\n]++|\\\\[^\n])*'";
    private String _openCharacter = "'(?:''[^']|[^'\\\\\n]++|\\\\[^\n])*(?:\n|$)";
    private String _string = "\"(?:[^\"\\\\\n]++|\\\\.)*\"";
    private String _openString = "\"(?:[^\"\\\\\n]++|\\\\.)*(?:\n|$)";
    private String _punctuation = "\\(|\\)|\\{|\\}|\\[|\\]|;|,|\\.";
    private String _operators = "[=]|[>]|[<]|[!]|[~]|[?]|[:]|[=][=]|[<][=]|[>][=]|[!][=]|[|][|]|[&][&]|[+][+]|[\\-][\\-]|[+]|[-]|[*]|[/]|[&]|[|]|[\\^]|[%]|[<][<]|[>][>]|[>][>][>]|[+][=]|[\\-][=]|[*][=]|[/][=]|[&][=]|[|][=]|[\\^][=]|[%][=]|[<][<][=]|[>][>][=]|[>][>][>][=]";
    private String _words = "\\b[a-zA-Z$_]\\w*\\b";
    private String _whiteSpace = "\\s";
    private String _hexNumber = "(?:[0][xX][0-9a-fA-F]+[lL]?)";
    private String _wholeNumber = "(?:[0-9]+(?![xX.eE])[lLdDfF]?)";
    private String _decimalNumber = "(?:[0-9]*[.][0-9]+[dDfF]?)";
    private String _exponentialNumber = "(?:(?:[0-9]*[.][0-9]+|[0-9]+[.]?[0-9]*)(?:[eE][+-]?[0-9]+)?[dDfF]?)";
    private String _number = "[+-]?(?:" + this._hexNumber + "|" + this._wholeNumber + "|" + this._decimalNumber + "|" + this._exponentialNumber + ")";
    private static final int PATTERN_COUNT = 14;
    private HashMap<String, String> _keywordHash = new HashMap(50);
    private Token _token;
    private Token _blankToken;
    private Pattern _pattern;
    private Matcher _matcher;
    private static JavaParser INSTANCE;

    public JavaParser() {
        this._keywordHash.put("abstract", "");
        this._keywordHash.put("boolean", "");
        this._keywordHash.put("break", "");
        this._keywordHash.put("byte", "");
        this._keywordHash.put("case", "");
        this._keywordHash.put("catch", "");
        this._keywordHash.put("char", "");
        this._keywordHash.put("class", "");
        this._keywordHash.put("const", "");
        this._keywordHash.put("continue", "");
        this._keywordHash.put("default", "");
        this._keywordHash.put("do", "");
        this._keywordHash.put("double", "");
        this._keywordHash.put("else", "");
        this._keywordHash.put("extends", "");
        this._keywordHash.put("false", "");
        this._keywordHash.put("final", "");
        this._keywordHash.put("finally", "");
        this._keywordHash.put("float", "");
        this._keywordHash.put("for", "");
        this._keywordHash.put("goto", "");
        this._keywordHash.put("if", "");
        this._keywordHash.put("implements", "");
        this._keywordHash.put("import", "");
        this._keywordHash.put("instanceof", "");
        this._keywordHash.put("int", "");
        this._keywordHash.put("interface", "");
        this._keywordHash.put("long", "");
        this._keywordHash.put("native", "");
        this._keywordHash.put("new", "");
        this._keywordHash.put("null", "");
        this._keywordHash.put("package", "");
        this._keywordHash.put("private", "");
        this._keywordHash.put("protected", "");
        this._keywordHash.put("public", "");
        this._keywordHash.put("return", "");
        this._keywordHash.put("short", "");
        this._keywordHash.put("static", "");
        this._keywordHash.put("super", "");
        this._keywordHash.put("switch", "");
        this._keywordHash.put("synchronized", "");
        this._keywordHash.put("this", "");
        this._keywordHash.put("throw", "");
        this._keywordHash.put("throws", "");
        this._keywordHash.put("transient", "");
        this._keywordHash.put("true", "");
        this._keywordHash.put("try", "");
        this._keywordHash.put("void", "");
        this._keywordHash.put("volatile", "");
        this._keywordHash.put("while", "");
        this._pattern = Pattern.compile("(" + this._singleLineComment + ")|(" + this._multiLineComment + ")|(" + this._inMultiLineComment + ")|(" + this._formalComment + ")|(" + this._inFormalComment + ")|(" + this._character + ")|(" + this._openCharacter + ")|(" + this._string + ")|(" + this._openString + ")|(" + this._number + ")|(" + this._punctuation + ")|(" + this._operators + ")|(" + this._words + ")|(" + this._whiteSpace + ")", 32);
        this._blankToken = new Token();
        this._blankToken.image = "";
        this._blankToken.beginsAt = 0;
        this._blankToken.kind = 99;
    }

    @Override
    public void ReInit(InputStream inputStream) {
    }

    @Override
    public void ReInit(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            int n = reader.read();
            while (n > -1) {
                stringBuffer.append((char)n);
                n = reader.read();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._matcher = this._pattern.matcher(stringBuffer);
    }

    @Override
    public Token getNextToken() {
        if (this._matcher.find()) {
            for (int i = 1; i <= 14; ++i) {
                String string = this._matcher.group(i);
                if (string == null) continue;
                this._token = new Token();
                this._token.image = string;
                this._token.beginsAt = this._matcher.start();
                this._token.kind = i - 1;
                break;
            }
        }
        return this._blankToken;
    }

    @Override
    public int getBeginOffset() {
        return this._matcher.start();
    }

    @Override
    public int getEndOffset() {
        try {
            return this._matcher.end() - 1;
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    @Override
    public char readChar() throws IOException {
        return '\u0000';
    }

    @Override
    public Token getToken(int n) {
        if (this._token != null) {
            return this._token;
        }
        return this._blankToken;
    }

    @Override
    public int getCategory(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 7;
            }
            case 12: {
                if (this._keywordHash.containsKey(this._token.toString())) {
                    return 1;
                }
                return 0;
            }
            case 13: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String getBlockBegin() {
        return "{";
    }

    @Override
    public String getBlockEnd() {
        return "}";
    }

    @Override
    public String getStatementEnd() {
        return ";";
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public boolean isScanWholeDocument() {
        return true;
    }

    public Set<String> getKeywords() {
        return JavaParser.getInstance()._keywordHash.keySet();
    }

    public static JavaParser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaParser();
        }
        return INSTANCE;
    }
}

