/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.Parser;
import com.sybase.central.editor.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlainParser
implements Parser {
    private String _words = "\\b[a-zA-Z$_]\\w*\\b";
    private String _whiteSpace = "\\s";
    private static final int PATTERN_COUNT = 2;
    private Token _token;
    private Token _blankToken;
    private Pattern _pattern = Pattern.compile("()|(" + this._words + ")|(" + this._whiteSpace + ")", 32);
    private Matcher _matcher;
    private static PlainParser INSTANCE;

    public PlainParser() {
        this._blankToken = new Token();
        this._blankToken.image = "";
        this._blankToken.beginsAt = 0;
        this._blankToken.kind = 99;
    }

    @Override
    public void ReInit(InputStream inputStream) {
    }

    @Override
    public void ReInit(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            int n = reader.read();
            while (n > -1) {
                stringBuffer.append((char)n);
                n = reader.read();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._matcher = this._pattern.matcher(stringBuffer);
    }

    @Override
    public Token getNextToken() {
        if (this._matcher.find()) {
            for (int i = 1; i <= 2; ++i) {
                String string = this._matcher.group(i);
                if (string == null) continue;
                this._token = new Token();
                this._token.image = string;
                this._token.beginsAt = this._matcher.start();
                this._token.kind = i - 1;
                break;
            }
        }
        return this._blankToken;
    }

    @Override
    public int getBeginOffset() {
        return this._matcher.start();
    }

    @Override
    public int getEndOffset() {
        try {
            return this._matcher.end() - 1;
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    @Override
    public char readChar() throws IOException {
        return '\u0000';
    }

    @Override
    public Token getToken(int n) {
        if (this._token != null) {
            return this._token;
        }
        return this._blankToken;
    }

    @Override
    public int getCategory(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String getBlockBegin() {
        return "\u0000";
    }

    @Override
    public String getBlockEnd() {
        return "\u0000";
    }

    @Override
    public String getStatementEnd() {
        return "\u0000";
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public boolean isScanWholeDocument() {
        return true;
    }

    public Set<String> getKeywords() {
        return Collections.emptySet();
    }

    public static PlainParser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlainParser();
        }
        return INSTANCE;
    }
}

