/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.IntegerComboBoxEditor;
import com.sybase.central.editor.IntegerTextField;
import com.sybase.central.editor.ReflectiveAction;
import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.SCEditorProperties;
import com.sybase.customization.CustomizationPage;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class PrintCustomizationPage
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener,
CustomizationPage {
    private static HelpViewer _helpViewer = null;
    JTextField _header = new JTextField();
    SybButton _headerHelperButton = new SybButton();
    JTextField _footer = new JTextField();
    SybButton _footerHelperButton = new SybButton();
    JComboBox _printFontSize = new JComboBox();
    JPopupMenu _popupMenu = new JPopupMenu();
    boolean _insertIntoHeader = false;

    public PrintCustomizationPage() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        SybLabel sybLabel = new SybLabel();
        SybLabel sybLabel2 = new SybLabel();
        SybLabel sybLabel3 = new SybLabel();
        JPanel jPanel = new JPanel();
        this.add((Component)sybLabel);
        this.add(this._header);
        this.add((Component)this._headerHelperButton);
        this.add((Component)sybLabel2);
        this.add(this._footer);
        this.add((Component)this._footerHelperButton);
        this.add((Component)sybLabel3);
        this.add(this._printFontSize);
        jPanel.setLayout(null);
        this.add(jPanel);
        sybLabel.setText(ResourceManager.getI18NMessage("PrintHeader"));
        sybLabel.setLabelFor((Component)this._header);
        this._header.getDocument().addDocumentListener(this);
        this._headerHelperButton.addActionListener((ActionListener)this);
        this._headerHelperButton.setText(">");
        this._headerHelperButton.setToolTipText(ResourceManager.getI18NMessage("PrintHeaderTip"));
        sybLabel2.setText(ResourceManager.getI18NMessage("PrintFooter"));
        sybLabel2.setLabelFor((Component)this._footer);
        this._footer.getDocument().addDocumentListener(this);
        this._footerHelperButton.addActionListener((ActionListener)this);
        this._footerHelperButton.setText(">");
        this._footerHelperButton.setToolTipText(ResourceManager.getI18NMessage("PrintFooterTip"));
        this._printFontSize.setEditable(true);
        this._printFontSize.setEditor(new IntegerComboBoxEditor());
        this._printFontSize.addItem("8");
        this._printFontSize.addItem("10");
        this._printFontSize.addItem("12");
        this._printFontSize.addItem("14");
        this._printFontSize.addItem("16");
        this._printFontSize.addItem("18");
        this._printFontSize.addItem("20");
        this._printFontSize.addItem("22");
        this._printFontSize.addItem("24");
        this._printFontSize.setSelectedItem(String.valueOf(SCEditorProperties.getPrintFontSize()));
        this._printFontSize.addItemListener(this);
        sybLabel3.setText(ResourceManager.getI18NMessage("PrintFontSize"));
        sybLabel3.setLabelFor(this._printFontSize.getEditor().getEditorComponent());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this._header, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)this._headerHelperButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagLayout.setConstraints((Component)sybLabel2, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this._footer, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagLayout.setConstraints((Component)this._footerHelperButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagLayout.setConstraints((Component)sybLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this._printFontSize, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this._popupMenu.add(new ReflectiveAction(this, "insertFileNameCode", ResourceManager.getI18NMessage("PrintFilename")));
        this._popupMenu.add(new ReflectiveAction(this, "insertFileTimeCode", ResourceManager.getI18NMessage("PrintFileTime")));
        this._popupMenu.add(new ReflectiveAction(this, "insertFileDateCode", ResourceManager.getI18NMessage("PrintFileDate")));
        this._popupMenu.addSeparator();
        this._popupMenu.add(new ReflectiveAction(this, "insertPageNumberCode", ResourceManager.getI18NMessage("PrintPageNumber")));
        this._popupMenu.add(new ReflectiveAction(this, "insertPageCountCode", ResourceManager.getI18NMessage("PrintPageCount")));
        this._popupMenu.add(new ReflectiveAction(this, "insertCurrentTimeCode", ResourceManager.getI18NMessage("PrintCurrentTime")));
        this._popupMenu.add(new ReflectiveAction(this, "insertCurrentDateCode", ResourceManager.getI18NMessage("PrintCurrentDate")));
        this._popupMenu.addSeparator();
        this._popupMenu.add(new ReflectiveAction(this, "insertLeftAlignCode", ResourceManager.getI18NMessage("PrintLeftAlign")));
        this._popupMenu.add(new ReflectiveAction(this, "insertCenterCode", ResourceManager.getI18NMessage("PrintCenter")));
        this._popupMenu.add(new ReflectiveAction(this, "insertRightAlignCode", ResourceManager.getI18NMessage("PrintRightAlign")));
    }

    public void initialize() {
        this._header.setText(SCEditorProperties.getPrintHeader());
        this._footer.setText(SCEditorProperties.getPrintFooter());
        ((IntegerTextField)this._printFontSize.getEditor().getEditorComponent()).setValue(SCEditorProperties.getPrintFontSize());
    }

    public boolean validateChanges() {
        return true;
    }

    public String getTitle() {
        return ResourceManager.getI18NMessage("Print");
    }

    public void destroy() {
        this._printFontSize.removeItemListener(this);
        this._headerHelperButton.removeActionListener((ActionListener)this);
        this._footerHelperButton.removeActionListener((ActionListener)this);
        this._printFontSize.removeItemListener(this);
        this._header.getDocument().removeDocumentListener(this);
        this._footer.getDocument().removeDocumentListener(this);
    }

    private HelpViewer getHelpViewer() {
        if (_helpViewer == null) {
            try {
                _helpViewer = FactoryHelp.getHelpViewer((String)SCEditor._helpFolder, (String)SCEditor._helpFile, (String)SCEditor._helpVersion);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                // empty catch block
            }
        }
        return _helpViewer;
    }

    public void showHelp() {
        if (this.getHelpViewer() != null) {
            this.getHelpViewer().turnPage("HELP_SCEDITOR_PRINT_CUSTOMIZATION", SwingUtilities.windowForComponent(this));
        }
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._headerHelperButton) {
            this._insertIntoHeader = true;
            this.showJPopupMenu((JComponent)this._headerHelperButton, new Point(0, 0));
        } else if (object == this._footerHelperButton) {
            this._insertIntoHeader = false;
            this.showJPopupMenu((JComponent)this._footerHelperButton, new Point(0, 0));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._printFontSize) {
            int n = ((IntegerTextField)this._printFontSize.getEditor().getEditorComponent()).getValue();
            if (n < 4) {
                n = 4;
            } else if (n > 255) {
                n = 255;
            }
            SCEditorProperties.setPrintFontSize(n);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._header.getDocument()) {
            SCEditorProperties.setPrintHeader(this._header.getText());
        } else if (documentEvent.getDocument() == this._footer.getDocument()) {
            SCEditorProperties.setPrintFooter(this._footer.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertFileNameCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&F");
        } else {
            this._footer.setText(this._footer.getText() + "&F");
        }
    }

    public void insertPageNumberCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&P");
        } else {
            this._footer.setText(this._footer.getText() + "&P");
        }
    }

    public void insertPageCountCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&p");
        } else {
            this._footer.setText(this._footer.getText() + "&p");
        }
    }

    public void insertFileTimeCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&t");
        } else {
            this._footer.setText(this._footer.getText() + "&t");
        }
    }

    public void insertFileDateCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&d");
        } else {
            this._footer.setText(this._footer.getText() + "&d");
        }
    }

    public void insertCurrentTimeCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&T");
        } else {
            this._footer.setText(this._footer.getText() + "&T");
        }
    }

    public void insertCurrentDateCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&D");
        } else {
            this._footer.setText(this._footer.getText() + "&D");
        }
    }

    public void insertLeftAlignCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&L");
        } else {
            this._footer.setText(this._footer.getText() + "&L");
        }
    }

    public void insertCenterCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&C");
        } else {
            this._footer.setText(this._footer.getText() + "&C");
        }
    }

    public void insertRightAlignCode() {
        if (this._insertIntoHeader) {
            this._header.setText(this._header.getText() + "&R");
        } else {
            this._footer.setText(this._footer.getText() + "&R");
        }
    }

    void showJPopupMenu(JComponent jComponent, Point point) {
        Dimension dimension = jComponent.getToolkit().getScreenSize();
        Dimension dimension2 = this._popupMenu.getPreferredSize();
        Point point2 = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point2, jComponent);
        Point point3 = new Point(point2.x + point.x, point2.y + point.y);
        Point point4 = new Point(point3.x, point3.y);
        if (point3.x + dimension2.width > dimension.width) {
            point4.x = dimension.width - dimension2.width;
        }
        if (point3.y + dimension2.height > dimension.height) {
            point4.y = dimension.height - dimension2.height;
        }
        SwingUtilities.convertPointFromScreen(point4, jComponent);
        this._popupMenu.show(jComponent, point4.x, point4.y);
    }
}

