/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.SCEditorProperties;
import com.sybase.central.editor.Utilities;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class PrintView
extends BoxView
implements TabExpander {
    int _firstOnPage = 0;
    int _lastOnPage = 0;
    int _pageIndex = 0;
    FontMetrics metrics;
    Segment lineBuffer;
    boolean widthChanging;
    int tabSize;
    boolean wordWrap;

    PrintView(Element element, View view, int n, int n2, FontMetrics fontMetrics) {
        super(element, 1);
        this.metrics = fontMetrics;
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        this.lineBuffer = new Segment();
        this.wordWrap = false;
        this.setParent(view);
        this.setSize(n, n2);
        this.layout(n, n2);
    }

    int calculateTotalLineCount() {
        int n = 0;
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            int n3 = view.getEndOffset();
            int n4 = view.getStartOffset();
            while (n4 < n3) {
                ++n;
                int n5 = this.calculateBreakPosition(n4, n3);
                n4 = n5 == n4 ? n3 : n5;
            }
        }
        return n;
    }

    protected int getTabSize() {
        return SCEditorProperties.getIndentSize();
    }

    boolean paintPage(Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
        if (n2 > this._pageIndex) {
            this._firstOnPage = this._lastOnPage + 1;
            if (this._firstOnPage >= this.getViewCount()) {
                return false;
            }
            this._pageIndex = n2;
        }
        int n3 = this.getOffset(1, this._firstOnPage);
        int n4 = n3 + n - (bl2 ? this.metrics.getHeight() : 0);
        Rectangle rectangle = new Rectangle();
        int n5 = this.getViewCount();
        for (int i = this._firstOnPage; i < n5; ++i) {
            rectangle.x = this.getOffset(0, i);
            rectangle.y = this.getOffset(1, i) + (bl ? this.metrics.getHeight() : 0);
            rectangle.width = this.getSpan(0, i);
            rectangle.height = this.getSpan(1, i);
            if (rectangle.y + rectangle.height > n4) break;
            this._lastOnPage = i;
            rectangle.y -= n3;
            this.paintChild(graphics, rectangle, i);
        }
        return true;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        int n = rectangle.y + this.metrics.getAscent();
        int n2 = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Highlighter highlighter = jTextComponent.getHighlighter();
        LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        int n3 = this.getEndOffset();
        int n4 = this.getStartOffset();
        while (n4 < n3) {
            int n5 = this.calculateBreakPosition(n4, n3);
            if (layeredHighlighter != null) {
                if (n5 == n3) {
                    layeredHighlighter.paintLayeredHighlights(graphics, n4, n5 - 1, shape, jTextComponent, this);
                } else {
                    layeredHighlighter.paintLayeredHighlights(graphics, n4, n5, shape, jTextComponent, this);
                }
            }
            this.drawLine(n4, n5, graphics, n2, n);
            n4 = n5 == n4 ? n3 : n5;
            n += this.metrics.getHeight();
        }
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        Element element = this.getElement();
        Element element2 = element.getElement(element.getElementIndex(n));
        try {
            if (element2.isLeaf()) {
                this.drawText(n, n2, graphics, n3, n4);
            } else {
                int n5 = element2.getElementIndex(n2);
                for (int i = element2.getElementIndex(n); i <= n5; ++i) {
                    Element element3 = element2.getElement(i);
                    int n6 = Math.max(element3.getStartOffset(), n);
                    int n7 = Math.min(element3.getEndOffset(), n2);
                    n3 = this.drawText(n6, n7, graphics, n3, n4);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private int drawText(int n, int n2, Graphics graphics, int n3, int n4) throws BadLocationException {
        n2 = Math.min(this.getDocument().getLength(), n2);
        Document document = this.getDocument();
        document.getText(n, n2 - n, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n3, n4, graphics, this, n);
    }

    protected final Segment getLineBuffer() {
        return this.lineBuffer;
    }

    protected int calculateBreakPosition(int n, int n2) {
        this.loadText(n, n2);
        int n3 = this.wordWrap ? n + Utilities.getBreakLocation(this.lineBuffer, this.metrics, 0, this.getWidth(), this, n) : n + Utilities.getTabbedTextOffset(this.lineBuffer, this.metrics, 0, this.getWidth(), this, n);
        return n3;
    }

    @Override
    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = new WrappedLine(element.getElement(i));
            }
            this.replace(0, 0, viewArray);
        }
    }

    void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            for (int i = 0; i < elementArray2.length; ++i) {
                viewArray[i] = new WrappedLine(elementArray2[i]);
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
    }

    final void loadText(int n, int n2) {
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, this.lineBuffer);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public float nextTabStop(float f, int n) {
        int n2 = (int)f / this.tabSize;
        return (n2 + 1) * this.tabSize;
    }

    @Override
    public void setSize(float f, float f2) {
        if ((int)f != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(f, f2);
        this.widthChanging = false;
    }

    @Override
    public float getPreferredSpan(int n) {
        return super.getPreferredSpan(n);
    }

    @Override
    public float getMinimumSpan(int n) {
        return super.getMinimumSpan(n);
    }

    @Override
    public float getMaximumSpan(int n) {
        return super.getMaximumSpan(n);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    class WrappedLine
    extends View {
        int nlines;

        WrappedLine(Element element) {
            super(element);
        }

        final int calculateLineCount() {
            int n = 0;
            int n2 = this.getEndOffset();
            int n3 = this.getStartOffset();
            while (n3 < n2) {
                ++n;
                int n4 = PrintView.this.calculateBreakPosition(n3, n2);
                n3 = n4 == n3 ? n2 : n4;
            }
            return n;
        }

        @Override
        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    return PrintView.this.getWidth();
                }
                case 1: {
                    if (this.nlines == 0 || PrintView.this.widthChanging) {
                        this.nlines = this.calculateLineCount();
                    }
                    return this.nlines * PrintView.this.metrics.getHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            int n = rectangle.y + PrintView.this.metrics.getAscent();
            int n2 = rectangle.x;
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            while (n4 < n3) {
                int n5 = PrintView.this.calculateBreakPosition(n4, n3);
                PrintView.this.drawLine(n4, n5, graphics, n2, n);
                n4 = n5 == n4 ? n3 : n5;
                n += PrintView.this.metrics.getHeight();
            }
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            int n2;
            Rectangle rectangle = shape.getBounds();
            rectangle.height = PrintView.this.metrics.getHeight();
            rectangle.width = 1;
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            int n5 = n2 = bias == Position.Bias.Forward ? n : Math.max(n4, n - 1);
            while (n4 < n3) {
                int n6 = PrintView.this.calculateBreakPosition(n4, n3);
                if (n >= n4 && n2 < n6) {
                    PrintView.this.loadText(n4, n);
                    rectangle.x += Utilities.getTabbedTextWidth(PrintView.this.lineBuffer, PrintView.this.metrics, rectangle.x, PrintView.this, n4);
                    return rectangle;
                }
                if (n6 == n3 && n == n3) {
                    if (n > n4) {
                        PrintView.this.loadText(n4, n);
                        rectangle.x += Utilities.getTabbedTextWidth(PrintView.this.lineBuffer, PrintView.this.metrics, rectangle.x, PrintView.this, n4);
                    }
                    return rectangle;
                }
                n4 = n6 == n4 ? n3 : n6;
                rectangle.y += rectangle.height;
            }
            throw new BadLocationException(null, n);
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            biasArray[0] = Position.Bias.Forward;
            Rectangle rectangle = (Rectangle)shape;
            int n = (int)f;
            int n2 = (int)f2;
            if (n2 < rectangle.y) {
                return this.getStartOffset();
            }
            if (n2 > rectangle.y + rectangle.height) {
                return this.getEndOffset() - 1;
            }
            rectangle.height = PrintView.this.metrics.getHeight();
            int n3 = this.getEndOffset();
            int n4 = this.getStartOffset();
            while (n4 < n3) {
                int n5 = PrintView.this.calculateBreakPosition(n4, n3);
                if (n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                    if (n < rectangle.x) {
                        return n4;
                    }
                    if (n > rectangle.x + rectangle.width) {
                        return n5;
                    }
                    int n6 = Utilities.getTabbedTextOffset(PrintView.this.lineBuffer, PrintView.this.metrics, rectangle.x, n, PrintView.this, n4);
                    return Math.min(n4 + n6, n3 - 1);
                }
                n4 = n5 == n4 ? n3 : n5;
                rectangle.y += rectangle.height;
            }
            return this.getEndOffset() - 1;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                PrintView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                PrintView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

