/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.Parser;
import com.sybase.central.editor.SCDocument;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.SCEditorProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;

class SCContext
extends StyleContext
implements ViewFactory {
    Style[] _tokenStyles;
    transient Color[] _tokenForegroundColors;
    transient Color[] _tokenBackgroundColors;
    transient Font[] _tokenFonts;
    SCEditor _editor = null;
    ArrayList<View> _viewList = null;

    SCContext(SCEditor sCEditor) {
        this._editor = sCEditor;
        this._viewList = new ArrayList();
        Style style = this.getStyle("default");
        this._tokenStyles = new Style[15];
        for (int i = 0; i < 15; ++i) {
            Style style2 = this.getStyle("SCEditor");
            if (style2 == null) {
                style2 = this.addStyle("SCEditor", style);
            }
            Style style3 = this.addStyle(null, style2);
            style3.addAttribute("SCEditor", Parser.CATEGORIES[i]);
            this._tokenStyles[i] = style3;
        }
    }

    private Color getForeground(int n) {
        if (this._tokenForegroundColors == null) {
            this._tokenForegroundColors = new Color[15];
        }
        if (n > -1 && n < this._tokenForegroundColors.length) {
            Color color = this._tokenForegroundColors[n];
            if (color == null) {
                Style style = this._tokenStyles[n];
                if (style != null) {
                    this._tokenForegroundColors[n] = color = StyleConstants.getForeground(style);
                } else {
                    return SystemColor.textText;
                }
            }
            return color;
        }
        return SystemColor.textText;
    }

    private Color getBackground(int n) {
        if (this._tokenBackgroundColors == null) {
            this._tokenBackgroundColors = new Color[15];
        }
        if (n > -1 && n < this._tokenBackgroundColors.length) {
            Color color = this._tokenBackgroundColors[n];
            if (color == null) {
                Style style = this._tokenStyles[n];
                if (style != null) {
                    this._tokenBackgroundColors[n] = color = StyleConstants.getBackground(style);
                } else {
                    return SystemColor.window;
                }
            }
            return color;
        }
        return SystemColor.window;
    }

    private Font getFont(int n) {
        if (this._tokenFonts == null) {
            this._tokenFonts = new Font[15];
        }
        if (n > -1 && n < this._tokenFonts.length) {
            Font font = this._tokenFonts[n];
            if (font == null) {
                Style style = this._tokenStyles[n];
                if (style != null) {
                    this._tokenFonts[n] = font = this.getFont(style);
                } else {
                    return null;
                }
            }
            return font;
        }
        return null;
    }

    Style getStyleForScanValue(int n) {
        if (n < this._tokenStyles.length) {
            return this._tokenStyles[n];
        }
        return null;
    }

    @Override
    public View create(Element element) {
        View view = this._editor.getLineWrap() ? new SCWrappedView(element, this._editor.getWrapStyleWord()) : new SCView(element);
        this._viewList.add(view);
        return view;
    }

    void destroy() {
        this._editor = null;
        if (this._viewList != null) {
            int n = this._viewList.size();
            for (int i = 0; i < n; ++i) {
                if (!(this._viewList.get(i) instanceof SCView)) continue;
                ((SCView)this._viewList.get(i)).destroy();
            }
            this._viewList.removeAll(this._viewList);
            this._viewList = null;
        }
        this._tokenStyles = null;
        this._tokenForegroundColors = null;
        this._tokenBackgroundColors = null;
        this._tokenFonts = null;
    }

    class SCView
    extends PlainView {
        SCDocument.Scanner _lexer;
        boolean _lexerValid;
        TreeSet<Integer> _startCache;

        SCView(Element element) {
            super(element);
            this._startCache = new TreeSet();
            Document document = this.getDocument();
            if (document instanceof SCDocument) {
                this._lexer = ((SCDocument)document).createScanner();
            }
            this._lexerValid = false;
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
            this._lexerValid = false;
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Document document = this.getDocument();
            Color color = null;
            Color color2 = null;
            Font font = null;
            int n5 = n3;
            while (n3 < n4) {
                this.updateScanner(n3);
                int n6 = Math.min(this._lexer.getEndOffset(), n4);
                n6 = n6 <= n3 ? n4 : n6;
                int n7 = SCContext.this._editor.getParser().getCategory(this._lexer.getTokenType());
                Color color3 = SCContext.this.getForeground(n7);
                Color color4 = SCContext.this.getBackground(n7);
                Font font2 = SCContext.this.getFont(n7);
                if (color3 != color || color4 != color2 || font2 != font) {
                    if (color == null) {
                        color = color3;
                    }
                    if (color2 == null) {
                        color2 = color4;
                    }
                    if (font == null) {
                        font = font2;
                    }
                    Segment segment = this.getLineBuffer();
                    document.getText(n5, n3 - n5, segment);
                    n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color, color2, font);
                    n5 = n3;
                }
                color = color3;
                color2 = color4;
                font = font2;
                n3 = n6;
            }
            graphics.setColor(color);
            Segment segment = this.getLineBuffer();
            document.getText(n5, n4 - n5, segment);
            n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color, color2, font);
            SCContext.this._editor.doRepaint();
            return n;
        }

        @Override
        protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Color color;
            Color color2;
            Document document = this.getDocument();
            Font font = null;
            int n5 = n3;
            if (SCContext.this._editor._hasFocus) {
                color2 = SCEditorProperties.getTextSelectionForeground();
                color = SCEditorProperties.getTextSelectionBackground();
            } else {
                color2 = SystemColor.controlText;
                color = SystemColor.control;
            }
            while (n3 < n4) {
                this.updateScanner(n3);
                int n6 = Math.min(this._lexer.getEndOffset(), n4);
                n6 = n6 <= n3 ? n4 : n6;
                int n7 = SCContext.this._editor.getParser().getCategory(this._lexer.getTokenType());
                Font font2 = SCContext.this.getFont(n7);
                if (font2 != font) {
                    if (font == null) {
                        font = font2;
                    }
                    Segment segment = this.getLineBuffer();
                    document.getText(n5, n3 - n5, segment);
                    n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color2, color, font);
                    n5 = n3;
                }
                font = font2;
                n3 = n6;
            }
            graphics.setColor(color2);
            Segment segment = this.getLineBuffer();
            document.getText(n5, n4 - n5, segment);
            n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color2, color, font);
            SCContext.this._editor.doRepaint();
            return n;
        }

        @Override
        protected void updateMetrics() {
            if (this.getContainer() == null) {
                return;
            }
            super.updateMetrics();
        }

        final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3, Color color, Color color2, Font font) {
            Color color3 = graphics.getColor();
            Font font2 = graphics.getFont();
            int n4 = n;
            char[] cArray = segment.array;
            int n5 = 0;
            int n6 = segment.offset;
            int n7 = segment.offset + segment.count;
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            for (int i = segment.offset; i < n7; ++i) {
                char c = cArray[i];
                if (c == '\t') {
                    if (n5 > 0) {
                        this.drawText(n, n2, graphics, color, color2, cArray, fontMetrics, n5, n6);
                        n5 = 0;
                    }
                    n6 = i + 1;
                    n4 = tabExpander != null ? (int)tabExpander.nextTabStop(n4, n3 + i - segment.offset) : (n4 += fontMetrics.charWidth(' '));
                    n = n4;
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    if (n5 > 0) {
                        this.drawText(n, n2, graphics, color, color2, cArray, fontMetrics, n5, n6);
                        n5 = 0;
                    }
                    n6 = i + 1;
                    n = n4;
                    continue;
                }
                ++n5;
                n4 += fontMetrics.charWidth(c);
            }
            if (n5 > 0) {
                this.drawText(n, n2, graphics, color, color2, cArray, fontMetrics, n5, n6);
            }
            graphics.setColor(color3);
            graphics.setFont(font2);
            return n4;
        }

        private void drawText(int n, int n2, Graphics graphics, Color color, Color color2, char[] cArray, FontMetrics fontMetrics, int n3, int n4) {
            if (n4 + n3 <= cArray.length) {
                graphics.setColor(color2);
                int n5 = fontMetrics.charsWidth(cArray, n4, n3);
                graphics.fillRect(n, n2 - fontMetrics.getAscent(), n5, fontMetrics.getHeight());
                graphics.setColor(color);
                graphics.drawChars(cArray, n4, n3, n, n2);
            }
        }

        private int getStartPoint(SCDocument sCDocument, int n) {
            int n2;
            int n3;
            int n4;
            Iterator<Integer> iterator;
            int n5 = 0;
            if (sCDocument.isRecentlyChanged()) {
                iterator = this._startCache.iterator();
                int n6 = sCDocument.getChangeOffset();
                n4 = this._startCache.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = iterator.next();
                    if (n2 <= n6) continue;
                    iterator.remove();
                }
                if (this._startCache.size() > 0) {
                    this._startCache.remove(this._startCache.last());
                }
                sCDocument.setRecentlyChanged(false);
            }
            iterator = this._startCache.iterator();
            n4 = this._startCache.size();
            for (n3 = 0; n3 < n4 && (n2 = iterator.next().intValue()) < n; ++n3) {
                n5 = n2;
            }
            return n5;
        }

        private void updateScanner(int n) {
            try {
                if (!this._lexerValid) {
                    SCDocument sCDocument = (SCDocument)this.getDocument();
                    int n2 = SCContext.this._editor.getParser() != null && SCContext.this._editor.getParser().isScanWholeDocument() ? this.getStartPoint(sCDocument, n) : sCDocument.getScannerStart(n);
                    this._lexer.setRange(n2, sCDocument.getLength());
                    this._lexerValid = true;
                    this._lexer.getNextToken();
                    this._startCache.add(this._lexer.getStartOffset());
                }
                while (this._lexer.getEndOffset() <= n) {
                    this._lexer.getNextToken();
                    this._startCache.add(this._lexer.getStartOffset());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        protected int getTabSize() {
            return SCEditorProperties.getIndentSize();
        }

        void destroy() {
            this.setParent(null);
            if (this._lexer != null) {
                this._lexer.destroy();
                this._lexer = null;
            }
            this._startCache = null;
        }
    }

    class SCWrappedView
    extends WrappedPlainView {
        SCDocument.Scanner _lexer;
        boolean _lexerValid;
        TreeSet<Integer> _startCache;

        SCWrappedView(Element element) {
            super(element, false);
            this._startCache = new TreeSet();
            this.init();
        }

        SCWrappedView(Element element, boolean bl) {
            super(element, bl);
            this._startCache = new TreeSet();
            this.init();
        }

        private void init() {
            Document document = this.getDocument();
            if (document instanceof SCDocument) {
                this._lexer = ((SCDocument)document).createScanner();
            }
            this._lexerValid = false;
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
            this._lexerValid = false;
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Document document = this.getDocument();
            Color color = null;
            Color color2 = null;
            Font font = null;
            int n5 = n3;
            while (n3 < n4) {
                this.updateScanner(n3);
                int n6 = Math.min(this._lexer.getEndOffset(), n4);
                n6 = n6 <= n3 ? n4 : n6;
                int n7 = SCContext.this._editor.getParser().getCategory(this._lexer.getTokenType());
                Color color3 = SCContext.this.getForeground(n7);
                Color color4 = SCContext.this.getBackground(n7);
                Font font2 = SCContext.this.getFont(n7);
                if (color3 != color || color4 != color2 || font2 != font) {
                    if (color == null) {
                        color = color3;
                    }
                    if (color2 == null) {
                        color2 = color4;
                    }
                    if (font == null) {
                        font = font2;
                    }
                    Segment segment = this.getLineBuffer();
                    document.getText(n5, n3 - n5, segment);
                    n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color, color2, font);
                    n5 = n3;
                }
                color = color3;
                color2 = color4;
                font = font2;
                n3 = n6;
            }
            graphics.setColor(color);
            Segment segment = this.getLineBuffer();
            document.getText(n5, n4 - n5, segment);
            n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color, color2, font);
            SCContext.this._editor.doRepaint();
            return n;
        }

        @Override
        protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Color color;
            Color color2;
            Document document = this.getDocument();
            Font font = null;
            int n5 = n3;
            if (SCContext.this._editor._hasFocus) {
                color2 = SCEditorProperties.getTextSelectionForeground();
                color = SCEditorProperties.getTextSelectionBackground();
            } else {
                color2 = SystemColor.controlText;
                color = SystemColor.control;
            }
            while (n3 < n4) {
                this.updateScanner(n3);
                int n6 = Math.min(this._lexer.getEndOffset(), n4);
                n6 = n6 <= n3 ? n4 : n6;
                int n7 = SCContext.this._editor.getParser().getCategory(this._lexer.getTokenType());
                Font font2 = SCContext.this.getFont(n7);
                if (font2 != font) {
                    if (font == null) {
                        font = font2;
                    }
                    Segment segment = this.getLineBuffer();
                    document.getText(n5, n3 - n5, segment);
                    n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color2, color, font);
                    n5 = n3;
                }
                font = font2;
                n3 = n6;
            }
            graphics.setColor(color2);
            Segment segment = this.getLineBuffer();
            document.getText(n5, n4 - n5, segment);
            n = this.drawTabbedText(segment, n, n2, graphics, this, n5, color2, color, font);
            SCContext.this._editor.doRepaint();
            return n;
        }

        final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3, Color color, Color color2, Font font) {
            Color color3 = graphics.getColor();
            Font font2 = graphics.getFont();
            int n4 = n;
            char[] cArray = segment.array;
            int n5 = 0;
            int n6 = segment.offset;
            int n7 = segment.offset + segment.count;
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            for (int i = segment.offset; i < n7; ++i) {
                char c = cArray[i];
                if (c == '\t') {
                    if (n5 > 0) {
                        this.drawText(n, n2, graphics, color, color2, cArray, fontMetrics, n5, n6);
                        n5 = 0;
                    }
                    n6 = i + 1;
                    n4 = tabExpander != null ? (int)tabExpander.nextTabStop(n4, n3 + i - segment.offset) : (n4 += fontMetrics.charWidth(' '));
                    n = n4;
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    if (n5 > 0) {
                        this.drawText(n, n2, graphics, color, color2, cArray, fontMetrics, n5, n6);
                        n5 = 0;
                    }
                    n6 = i + 1;
                    n = n4;
                    continue;
                }
                ++n5;
                n4 += fontMetrics.charWidth(c);
            }
            if (n5 > 0) {
                this.drawText(n, n2, graphics, color, color2, cArray, fontMetrics, n5, n6);
            }
            graphics.setColor(color3);
            graphics.setFont(font2);
            return n4;
        }

        private void drawText(int n, int n2, Graphics graphics, Color color, Color color2, char[] cArray, FontMetrics fontMetrics, int n3, int n4) {
            if (n4 + n3 <= cArray.length) {
                graphics.setColor(color2);
                int n5 = fontMetrics.charsWidth(cArray, n4, n3);
                graphics.fillRect(n, n2 - fontMetrics.getAscent(), n5, fontMetrics.getHeight());
                graphics.setColor(color);
                graphics.drawChars(cArray, n4, n3, n, n2);
            }
        }

        private int getStartPoint(SCDocument sCDocument, int n) {
            int n2;
            int n3;
            int n4;
            Iterator<Integer> iterator;
            int n5 = 0;
            if (sCDocument.isRecentlyChanged()) {
                int n6 = sCDocument.getChangeOffset();
                iterator = this._startCache.iterator();
                n4 = this._startCache.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = iterator.next();
                    if (n2 <= n6) continue;
                    iterator.remove();
                }
                if (this._startCache.size() > 0) {
                    this._startCache.remove(this._startCache.last());
                }
                sCDocument.setRecentlyChanged(false);
            }
            iterator = this._startCache.iterator();
            n4 = this._startCache.size();
            for (n3 = 0; n3 < n4 && (n2 = iterator.next().intValue()) < n; ++n3) {
                n5 = n2;
            }
            return n5;
        }

        private void updateScanner(int n) {
            try {
                if (!this._lexerValid) {
                    SCDocument sCDocument = (SCDocument)this.getDocument();
                    int n2 = SCContext.this._editor.getParser() != null && SCContext.this._editor.getParser().isScanWholeDocument() ? this.getStartPoint(sCDocument, n) : sCDocument.getScannerStart(n);
                    this._lexer.setRange(n2, sCDocument.getLength());
                    this._lexerValid = true;
                    this._lexer.getNextToken();
                    this._startCache.add(this._lexer.getStartOffset());
                }
                while (this._lexer.getEndOffset() <= n) {
                    this._lexer.getNextToken();
                    this._startCache.add(this._lexer.getStartOffset());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        protected int getTabSize() {
            return SCEditorProperties.getIndentSize();
        }

        void destroy() {
            this.setParent(null);
            if (this._lexer != null) {
                this._lexer.destroy();
                this._lexer = null;
            }
            this._startCache = null;
        }
    }
}

