/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

class SCDesktopPane
extends JDesktopPane {
    protected int nextX;
    protected int nextY;
    protected int offsetX = 24;
    protected int offsetY = 24;
    protected static final int DEFAULT_OFFSETX = 24;
    protected static final int DEFAULT_OFFSETY = 24;
    protected static final int UNUSED_HEIGHT = 48;

    SCDesktopPane() {
    }

    void addCascaded(Component component, Integer n) {
        this.add(component, n);
        if (component instanceof JInternalFrame) {
            this.cascade(component);
        }
        this.moveToFront(component);
    }

    void cascadeAll() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        this.nextX = 0;
        this.nextY = 0;
        for (int i = n - 1; i >= 0; --i) {
            Component component = componentArray[i];
            if (!(component instanceof JInternalFrame) || !component.isVisible()) continue;
            this.cascade(component);
        }
    }

    void tileAll() {
        Component component;
        DesktopManager desktopManager = this.getDesktopManager();
        if (desktopManager == null) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            component = componentArray[i];
            if (!(component instanceof JInternalFrame) || !component.isVisible()) continue;
            ++n;
        }
        if (n != 0) {
            double d = Math.sqrt(n);
            int n2 = (int)d;
            int n3 = n / n2;
            int n4 = n - n3 * n2;
            Dimension dimension = this.getSize();
            int n5 = dimension.width / n3;
            int n6 = dimension.height - 48;
            int n7 = n6 / n2;
            int n8 = n6 / (n2 + 1);
            int n9 = n7;
            int n10 = 0;
            int n11 = 0;
            int n12 = n2;
            int n13 = n3 - n4;
            for (int i = componentArray.length - 1; i >= 0; --i) {
                component = componentArray[i];
                if (!(component instanceof JInternalFrame) || !component.isVisible()) continue;
                desktopManager.setBoundsForFrame((JComponent)component, n10, n11, n5, n9);
                n11 += n9;
                if (--n12 != 0) continue;
                n11 = 0;
                n10 += n5;
                if (--n13 <= 0) {
                    n12 = n2 + 1;
                    n9 = n8;
                    continue;
                }
                n12 = n2;
            }
        }
    }

    void setCascadeOffsets(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
    }

    void setCascadeOffsets(Point point) {
        this.offsetX = point.x;
        this.offsetY = point.y;
    }

    Point getCascadeOffsets() {
        return new Point(this.offsetX, this.offsetY);
    }

    protected void cascade(Component component) {
        Dimension dimension = this.getSize();
        int n = 3 * dimension.width / 4;
        int n2 = 3 * dimension.height / 4;
        DesktopManager desktopManager = this.getDesktopManager();
        if (desktopManager == null) {
            component.setBounds(0, 0, n, n2);
            return;
        }
        if (this.nextX + n > dimension.width || this.nextY + n2 > dimension.height) {
            this.nextX = 0;
            this.nextY = 0;
        }
        desktopManager.setBoundsForFrame((JComponent)component, this.nextX, this.nextY, n, n2);
        this.nextX += this.offsetX;
        this.nextY += this.offsetY;
    }
}

