/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.Token;
import com.sybase.central.editor.TokenMgrError;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CompoundEdit;

class SCDocument
extends PlainDocument {
    static final Object CommentAttribute = new AttributeKey();
    private boolean _inUndoableSequence = false;
    private CompoundEdit _compoundEdit = null;
    String _language = "plain";
    Parser _parser = null;
    boolean _recentlyChanged = false;
    int _changeOffset = 0;
    ArrayList<DocumentListener> _documentListenerList = new ArrayList();
    ArrayList<UndoableEditListener> _undoableEditListenerList = new ArrayList();

    SCDocument(String string, Parser parser) {
        super(new GapContent(1024));
        this._language = string;
        this._parser = parser;
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        super.addDocumentListener(documentListener);
        if (this._documentListenerList == null) {
            this._documentListenerList = new ArrayList();
        }
        this._documentListenerList.add(documentListener);
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        int n;
        super.removeDocumentListener(documentListener);
        if (this._documentListenerList != null && (n = this._documentListenerList.indexOf(documentListener)) != -1) {
            this._documentListenerList.remove(n);
        }
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        super.addUndoableEditListener(undoableEditListener);
        if (this._undoableEditListenerList == null) {
            this._undoableEditListenerList = new ArrayList();
        }
        this._undoableEditListenerList.add(undoableEditListener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        super.removeUndoableEditListener(undoableEditListener);
        int n = this._undoableEditListenerList.indexOf(undoableEditListener);
        if (n != -1) {
            this._undoableEditListenerList.remove(n);
        }
    }

    Scanner createScanner() {
        return new Scanner(this._parser);
    }

    int getScannerStart(int n) {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        AttributeSet attributeSet = element2.getAttributes();
        while (attributeSet.isDefined(CommentAttribute) && n2 > 0) {
            element2 = element.getElement(--n2);
            attributeSet = element2.getAttributes();
        }
        return element2.getStartOffset();
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        this.setRecentlyChanged(true);
        this._changeOffset = defaultDocumentEvent.getOffset();
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        this.setRecentlyChanged(true);
        this._changeOffset = defaultDocumentEvent.getOffset();
        super.removeUpdate(defaultDocumentEvent);
    }

    protected void setRecentlyChanged(boolean bl) {
        this._recentlyChanged = bl;
    }

    protected boolean isRecentlyChanged() {
        return this._recentlyChanged;
    }

    protected int getChangeOffset() {
        return this._changeOffset;
    }

    void destroy() {
        this._language = null;
        this._parser = null;
        if (this._documentListenerList != null) {
            this._documentListenerList.clear();
            this._documentListenerList = null;
        }
        if (this._undoableEditListenerList != null) {
            this._undoableEditListenerList.clear();
            this._undoableEditListenerList = null;
        }
    }

    void startUndoableSequence() {
        this.endUndoableSequence();
        this._inUndoableSequence = true;
    }

    void endUndoableSequence() {
        if (this._compoundEdit != null && this._compoundEdit.isInProgress()) {
            this._compoundEdit.end();
        }
        this._compoundEdit = null;
        this._inUndoableSequence = false;
    }

    @Override
    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        if (this._inUndoableSequence) {
            this.getUndoableSequence().addEdit(undoableEditEvent.getEdit());
        } else {
            super.fireUndoableEditUpdate(undoableEditEvent);
        }
    }

    private CompoundEdit getUndoableSequence() {
        if (this._compoundEdit == null) {
            this._compoundEdit = new CompoundEdit();
            super.fireUndoableEditUpdate(new UndoableEditEvent(this, this._compoundEdit));
        }
        return this._compoundEdit;
    }

    class DocumentReader
    extends Reader {
        private String str;
        private int length;
        private int next;
        private int mark;

        DocumentReader(int n, int n2) {
            super(SCDocument.this);
            this.next = 0;
            this.mark = 0;
            try {
                this.str = SCDocument.this.getText(n, n2 - n);
                this.length = this.str.length();
            }
            catch (Exception exception) {
                this.str = " ";
                this.length = 1;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.str == null) {
                throw new IOException("Stream closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.next >= this.length) {
                    return -1;
                }
                return this.str.charAt(this.next++);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return 0;
                }
                if (this.next >= this.length) {
                    return -1;
                }
                int n3 = Math.min(this.length - this.next, n2);
                this.str.getChars(this.next, this.next + n3, cArray, n);
                this.next += n3;
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.next >= this.length) {
                    return 0L;
                }
                long l2 = Math.min((long)(this.length - this.next), l);
                this.next = (int)((long)this.next + l2);
                return l2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                return true;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mark(int n) throws IOException {
            if (n < 0) {
                throw new IllegalArgumentException("Read-ahead limit < 0");
            }
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.mark = this.next;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.next = this.mark;
            }
        }

        @Override
        public void close() {
            this.str = null;
        }
    }

    class Scanner {
        int _p0 = 0;
        Parser _scannerParser = null;

        Scanner() {
            this._scannerParser = null;
            this.init();
        }

        Scanner(Parser parser) {
            this._scannerParser = parser;
            this.init();
        }

        private void init() {
            if (this._scannerParser == null) {
                try {
                    this._scannerParser = (Parser)Class.forName("com.sybase.central.editor." + Character.toUpperCase(SCDocument.this._language.charAt(0)) + SCDocument.this._language.substring(1) + "Parser").newInstance();
                }
                catch (Exception exception) {
                    try {
                        this._scannerParser = (Parser)Class.forName("com.sybase.central.editor.PlainParser").newInstance();
                    }
                    catch (Exception exception2) {
                        ExceptionHandler.handleException((Throwable)exception2);
                    }
                }
            }
            this._scannerParser.ReInit(new DocumentReader(0, SCDocument.this.getLength()));
        }

        void setRange(int n, int n2) {
            this._scannerParser.ReInit(new DocumentReader(n, n2));
            this._p0 = n;
        }

        final int getStartOffset() {
            return this._scannerParser.getBeginOffset() + this._p0;
        }

        final int getEndOffset() {
            return this._scannerParser.getEndOffset() + this._p0 + 1;
        }

        String getToken() {
            Token token = this._scannerParser.getToken(0);
            return token.image;
        }

        int getTokenType() {
            Token token = this._scannerParser.getToken(0);
            return token.kind;
        }

        String getNextToken() {
            try {
                Token token = this._scannerParser.getNextToken();
                return token.image;
            }
            catch (TokenMgrError tokenMgrError) {
                try {
                    this._scannerParser.readChar();
                    return this.getNextToken();
                }
                catch (Exception exception) {
                    return "";
                }
            }
        }

        void destroy() {
            this._scannerParser = null;
        }
    }

    static class AttributeKey {
        private AttributeKey() {
        }

        public String toString() {
            return "comment";
        }
    }
}

