/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.central.editor.AsynchronousTaskListener;
import com.sybase.central.editor.BreakPoint;
import com.sybase.central.editor.BreakPointClient;
import com.sybase.central.editor.BreakPointEvent;
import com.sybase.central.editor.BreakPointListener;
import com.sybase.central.editor.BreakPointLocation;
import com.sybase.central.editor.BreakPointRenderer;
import com.sybase.central.editor.Editor;
import com.sybase.central.editor.EditorCustomizationPage;
import com.sybase.central.editor.FileHolder;
import com.sybase.central.editor.FindReplaceDialog;
import com.sybase.central.editor.FindReplaceListener;
import com.sybase.central.editor.FormatCustomizationPage;
import com.sybase.central.editor.IntegerTextField;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.PlainParser;
import com.sybase.central.editor.PrintCustomizationPage;
import com.sybase.central.editor.PrintView;
import com.sybase.central.editor.PrinterJobListener;
import com.sybase.central.editor.ReflectiveAction;
import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCContext;
import com.sybase.central.editor.SCDocument;
import com.sybase.central.editor.SCEditorImageLoader;
import com.sybase.central.editor.SCEditorKit;
import com.sybase.central.editor.SCEditorProperties;
import com.sybase.central.editor.TabsCustomizationPage;
import com.sybase.central.editor.ToolTipClient;
import com.sybase.central.editor.Utilities;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.customization.CustomizeDialog;
import com.sybase.customization.CustomizerHost;
import com.sybase.util.ClipboardManager;
import com.sybase.util.DialogUtils;
import com.sybase.util.Platform;
import com.sybase.util.PrintDialog;
import com.sybase.util.PrintJobListener;
import com.sybase.util.PrintJobThread;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybModalDialog;
import com.sybase.util.UIUtils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.undo.UndoManager;

public class SCEditor
extends JEditorPane
implements Editor,
DocumentListener,
Printable,
KeyListener,
TabExpander,
UndoableEditListener,
MouseListener,
FindReplaceListener,
FocusListener,
ComponentListener,
AncestorListener,
ListSelectionListener,
Customizable,
CustomizerHost {
    private MemoryLimitingDocumentFilter _filter = null;
    private static int _memoryPerChar = 8;
    private boolean _fontIsChanged = true;
    private boolean _fontIsMonoSpaced = true;
    private int _fontHeight;
    private int _fontWidth;
    private boolean _lineWrap = false;
    private boolean _wrapStyleWord = false;
    private boolean _repaintRequired = false;
    private boolean _contentChanged = false;
    boolean _hasFocus = false;
    private Keymap _keymap;
    Action _cutAction;
    Action _copyAction;
    Action _pasteAction;
    Action _customizeAction;
    Action _findReplaceAction;
    Action _findNextAction;
    Action _findNextSelectedAction;
    Action _findPreviousAction;
    Action _findPreviousSelectedAction;
    Action _findMatchingBraceAction;
    Action _selectToMatchingBraceAction;
    Action _undoAction;
    Action _redoAction;
    Action _deleteNextWordAction;
    Action _deletePreviousWordAction;
    Action _beginLineAction;
    Action _endLineAction;
    Action _selectionBeginLineAction;
    Action _homeAction;
    Action _homeSelectAction;
    Action _upAction;
    Action _selectionUpAction;
    Action _lineCutAction;
    Action _lineDeleteAction;
    Action _selectionEndLineAction;
    Action _selectionForwardAction;
    Action _goToLineAction;
    Action _toUpperCaseAction;
    Action _toLowerCaseAction;
    Action _toggleBreakPointAction;
    protected boolean _hasChanged;
    protected int _lastLinePrinted = 0;
    protected boolean _printJobComplete = true;
    protected PrintView _printView;
    PrintJobThread _printJobThread = null;
    PrintJobListener _printJobListener = null;
    protected StringTokenizer _stringTokenizer = null;
    protected String _editorType = "plain";
    EditorKit _kit = null;
    private SCContext _styles = null;
    private boolean _settingTextQuietly = false;
    private String _fileName;
    protected Parser _parserClass = null;
    protected ArrayList _pages = new ArrayList();
    protected char _lastBlockBeginChar;
    protected char _lastBlockEndChar;
    protected UndoManager _undo = new UndoManager();
    protected JPopupMenu _popupMenu;
    protected boolean _popupMenuEnabled = true;
    boolean _showCustomizeOnPopup = false;
    boolean _showFindReplaceOnPopup = false;
    CustomizeDialog _customizeDialog = null;
    CustomizerHost _customizerHost = null;
    protected JDialog _findReplaceDialog = null;
    private JScrollPane _scrollPane = null;
    protected FileHolder _parent = null;
    protected Thread _loader = null;
    private boolean _killLoader = false;
    static String _helpFolder;
    static String _helpFile;
    static String _helpVersion;
    static final Cursor WAIT_CURSOR;
    static final Cursor TEXT_CURSOR;
    EventListenerList _asynchronousTaskListenerList = new EventListenerList();
    String _leftHeader = null;
    String _centerHeader = null;
    String _rightHeader = null;
    String _leftFooter = null;
    String _centerFooter = null;
    String _rightFooter = null;
    boolean _hasPrintHeader = false;
    boolean _hasPrintFooter = false;
    int _breakPointActionLine = -1;
    JPopupMenu _breakPointPopupMenu;
    boolean _debuggingEditor = false;
    JList _breakPointList;
    DefaultListModel _breakPointListModel;
    StringBuffer _breakPointContextBuffer;
    int _currentLine = -1;
    BreakPointClient _breakPointClient = null;
    EventListenerList _breakPointListenerList = new EventListenerList();
    static ImageIcon BREAK_POINT_ICON;
    static ImageIcon DISABLED_BREAK_POINT_ICON;
    static ImageIcon NO_BREAK_POINT_ICON;
    static ImageIcon BREAK_POINT_CURRENT_STATEMENT_ICON;
    static ImageIcon DISABLED_BREAK_POINT_CURRENT_STATEMENT_ICON;
    static ImageIcon NO_BREAK_POINT_CURRENT_STATEMENT_ICON;
    Action _enableBreakPointAction;
    Action _disableBreakPointAction;
    Action _insertBreakPointAction;
    Action _removeBreakPointAction;
    Action _showPropertyBreakPointAction;
    ToolTipClient _toolTipClient = null;
    boolean _matchDottedPairsForToolTips = false;
    static ImageIcon EDITOR_ICON;
    static ArrayList<Editor> _customizerList;

    public SCEditor() {
        this((FileReader)null);
    }

    public SCEditor(FileReader fileReader) {
        this(fileReader, true, true, null, null, null);
    }

    public SCEditor(Reader reader) {
        this(reader, true, true, null, null, null);
    }

    public SCEditor(FileReader fileReader, BoundedRangeModel boundedRangeModel) {
        this(fileReader, true, true, null, null, boundedRangeModel);
    }

    public SCEditor(Reader reader, BoundedRangeModel boundedRangeModel) {
        this(reader, true, true, null, null, boundedRangeModel);
    }

    protected SCEditor(Reader reader, boolean bl, boolean bl2, FileHolder fileHolder, Parser parser, BoundedRangeModel boundedRangeModel) {
        Action[] actionArray;
        ToolTipManager.sharedInstance().registerComponent(this);
        _customizerList.add(this);
        this._showCustomizeOnPopup = bl;
        this._showFindReplaceOnPopup = bl2;
        this._keymap = SCEditor.addKeymap("SCEditorKeyBindings", this.getKeymap());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(34, 1);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(33, 1);
        for (Action action : actionArray = this.getEditorKit().getActions()) {
            if (action.getValue("Name").equals("selection-page-down")) {
                this._keymap.addActionForKeyStroke(keyStroke, action);
                continue;
            }
            if (!action.getValue("Name").equals("selection-page-up")) continue;
            this._keymap.addActionForKeyStroke(keyStroke2, action);
        }
        this.setFont(new Font("Monospaced", 0, 12));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addComponentListener(this);
        this.addAncestorListener(this);
        this._findNextSelectedAction = new ReflectiveAction(this, "findNextSelectedActionPerformed", null, null);
        this._findPreviousAction = new ReflectiveAction(this, "findPreviousActionPerformed", null, null);
        this._findPreviousSelectedAction = new ReflectiveAction(this, "findPreviousSelectedActionPerformed", null, null);
        this._findMatchingBraceAction = new ReflectiveAction(this, "findMatchingBraceActionPerformed", null, null);
        this._selectToMatchingBraceAction = new ReflectiveAction(this, "selectToMatchingBraceActionPerformed", null, null);
        this._undoAction = new ReflectiveAction(this, "undoActionPerformed", null, null);
        this._redoAction = new ReflectiveAction(this, "redoActionPerformed", null, null);
        this._deleteNextWordAction = new ReflectiveAction(this, "deleteNextActionPerformed", null, null);
        this._deletePreviousWordAction = new ReflectiveAction(this, "deletePreviousActionPerformed", null, null);
        this._homeAction = new ReflectiveAction(this, "homeActionPerformed", null, null);
        this._homeSelectAction = new ReflectiveAction(this, "homeSelectActionPerformed", null, null);
        this._lineCutAction = new ReflectiveAction(this, "lineCutActionPerformed", null, null);
        this._lineDeleteAction = new ReflectiveAction(this, "lineDeleteActionPerformed", null, null);
        this._goToLineAction = new ReflectiveAction(this, "goToLineActionPerformed", ResourceManager.getI18NMessage("GoToMenu"), SCEditorImageLoader.getImageIcon("blank", 1004));
        this._toUpperCaseAction = new ReflectiveAction(this, "toUpperCaseActionPerformed", null, null);
        this._toLowerCaseAction = new ReflectiveAction(this, "toLowerCaseActionPerformed", null, null);
        this._toggleBreakPointAction = new ReflectiveAction(this, "toggleBreakPoint", null, null);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke3, this.getFindReplaceAction());
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(114, 0);
        this._keymap.addActionForKeyStroke(keyStroke4, this.getFindNextAction());
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(114, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke5, this._findNextSelectedAction);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(114, 1);
        this._keymap.addActionForKeyStroke(keyStroke6, this._findPreviousAction);
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(114, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1);
        this._keymap.addActionForKeyStroke(keyStroke7, this._findPreviousSelectedAction);
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke8, this._undoAction);
        KeyStroke keyStroke9 = KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke9, this._redoAction);
        KeyStroke keyStroke10 = KeyStroke.getKeyStroke(127, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke10, this._deleteNextWordAction);
        KeyStroke keyStroke11 = KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke11, this._deletePreviousWordAction);
        KeyStroke keyStroke12 = KeyStroke.getKeyStroke(36, 0);
        this._keymap.addActionForKeyStroke(keyStroke12, this._homeAction);
        KeyStroke keyStroke13 = KeyStroke.getKeyStroke(36, 1);
        this._keymap.addActionForKeyStroke(keyStroke13, this._homeSelectAction);
        KeyStroke keyStroke14 = KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke14, this._lineCutAction);
        KeyStroke keyStroke15 = KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1);
        this._keymap.addActionForKeyStroke(keyStroke15, this._lineDeleteAction);
        KeyStroke keyStroke16 = KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke16, this._goToLineAction);
        KeyStroke keyStroke17 = KeyStroke.getKeyStroke(93, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke17, this._findMatchingBraceAction);
        KeyStroke keyStroke18 = KeyStroke.getKeyStroke(93, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1);
        this._keymap.addActionForKeyStroke(keyStroke18, this._selectToMatchingBraceAction);
        KeyStroke keyStroke19 = KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._keymap.addActionForKeyStroke(keyStroke19, this._toLowerCaseAction);
        KeyStroke keyStroke20 = KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1);
        this._keymap.addActionForKeyStroke(keyStroke20, this._toUpperCaseAction);
        ReflectiveAction reflectiveAction = new ReflectiveAction(this, "dumpUnicode", null, null);
        KeyStroke keyStroke21 = KeyStroke.getKeyStroke(68, 11);
        this._keymap.addActionForKeyStroke(keyStroke21, reflectiveAction);
        this.getInputMap().put(KeyStroke.getKeyStroke("control RIGHT"), "caret-next-word");
        this.getActionMap().put("caret-next-word", new NextWordAction("caret-next-word", false));
        this.getInputMap().put(KeyStroke.getKeyStroke("control shift RIGHT"), "selection-next-word");
        this.getActionMap().put("selection-next-word", new NextWordAction("selection-next-word", true));
        this.getInputMap().put(KeyStroke.getKeyStroke("control LEFT"), "caret-previous-word");
        this.getActionMap().put("caret-previous-word", new PreviousWordAction("caret-previous-word", false));
        this.getInputMap().put(KeyStroke.getKeyStroke("control shift LEFT"), "selection-previous-word");
        this.getActionMap().put("selection-previous-word", new PreviousWordAction("selection-previous-word", true));
        this._parent = fileHolder;
        SCEditorProperties.load();
        if (parser == null) {
            this.setEditorType((String)null);
        } else {
            this.setEditorType(parser);
        }
        this.getDocument().addUndoableEditListener(this);
        this.getDocument().addDocumentListener(this);
        this.setKeymap(this._keymap);
        this.getAccessibleContext().setAccessibleName(ResourceManager.getI18NMessage("EditorAccessibleName"));
        this.setDoubleBuffered(true);
        if (reader != null) {
            this.reload(reader, 0, boundedRangeModel);
        }
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.getCutAction().setEnabled(bl);
        this.getPasteAction().setEnabled(bl);
        this.setFocusCycleRoot(bl);
    }

    public void destroy() {
        ToolTipManager.sharedInstance().unregisterComponent(this);
        try {
            Caret caret;
            this.transferFocus();
            if (this._loader != null && this._loader.isAlive()) {
                this._killLoader = true;
            }
            if ((caret = this.getCaret()) != null) {
                caret.setBlinkRate(0);
                caret.deinstall(this);
                this.setCaret(null);
            }
            _customizerList.remove(_customizerList.indexOf(this));
            this.getDocument().removeDocumentListener(this);
            this.getDocument().removeUndoableEditListener(this);
            this.removeKeyListener(this);
            this.removeMouseListener(this);
            this.removeFocusListener(this);
            this.removeComponentListener(this);
            this._keymap.removeBindings();
            if (this._customizeDialog != null) {
                this._customizeDialog.destroy();
                this._customizeDialog = null;
            }
            if (this._findReplaceDialog != null) {
                ((FindReplaceDialog)((Object)this._findReplaceDialog)).destroy();
                this._findReplaceDialog = null;
            }
            if (this._popupMenu != null) {
                int n = this._popupMenu.getComponentCount();
                for (int i = n - 1; i >= 0; --i) {
                    this._popupMenu.remove(i);
                }
                this._popupMenu = null;
            }
            if (this._breakPointPopupMenu != null) {
                this._breakPointList.removeMouseListener(this);
            }
            DialogUtils.removeComponents((Container)this);
            this._homeAction = null;
            this._cutAction = null;
            this._copyAction = null;
            this._pasteAction = null;
            this._customizeAction = null;
            this._findReplaceAction = null;
            this._findNextAction = null;
            this._editorType = null;
            this._stringTokenizer = null;
            this._parserClass = null;
            this._styles.destroy();
            this._styles = null;
            this._scrollPane = null;
            this._kit.deinstall(this);
            this._kit = null;
            Document document = this.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).setDocumentFilter(null);
            }
            this._filter = null;
            if (document instanceof SCDocument) {
                ((SCDocument)document).destroy();
            }
            this._pages = null;
            this._undo = null;
            this._parent = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setDebuggingEditor(boolean bl) {
        if (this._debuggingEditor == bl) {
            return;
        }
        if (!bl) {
            this._debuggingEditor = bl;
            this._keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(120, 0));
            if (this._scrollPane == null && this.getParent() instanceof JViewport && this.getParent().getParent() instanceof JScrollPane) {
                this._scrollPane = (JScrollPane)this.getParent().getParent();
            }
            if (this._scrollPane != null) {
                this._scrollPane.setRowHeaderView(null);
            }
        } else {
            this._debuggingEditor = bl;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(120, 0);
            this._keymap.addActionForKeyStroke(keyStroke, this._toggleBreakPointAction);
            this._breakPointListModel = new DefaultListModel();
            this._breakPointContextBuffer = new StringBuffer(1000).append(this.getText());
            this._breakPointList = new JList(this._breakPointListModel);
            this._breakPointList.setForeground(SCEditorProperties.getBreakPointMarginForeground());
            this._breakPointList.setBackground(SCEditorProperties.getBreakPointMarginBackground());
            this._breakPointList.addListSelectionListener(this);
            this._breakPointList.setCellRenderer(new BreakPointRenderer());
            while (this._loader != null && this._loader.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String string = this.getText();
            int n = this.countLinesInBlock(string) + 1;
            for (int i = 0; i < n; ++i) {
                this._breakPointListModel.addElement(new BreakPoint());
            }
            this.updateBreakPointUI();
            if (this._breakPointPopupMenu == null) {
                this._enableBreakPointAction = new ReflectiveAction(this, "enableBreakPointActionPerformed", ResourceManager.getI18NMessage("EnableBreakPoint"), SCEditorImageLoader.getImageIcon("breakpoint16", 1006));
                this._disableBreakPointAction = new ReflectiveAction(this, "disableBreakPointActionPerformed", ResourceManager.getI18NMessage("DisableBreakPoint"), SCEditorImageLoader.getImageIcon("disabledbreakpoint16", 1006));
                this._insertBreakPointAction = new ReflectiveAction(this, "insertBreakPointActionPerformed", ResourceManager.getI18NMessage("InsertBreakPoint"), SCEditorImageLoader.getImageIcon("insertbreakpoint16", 1006));
                this._removeBreakPointAction = new ReflectiveAction(this, "removeBreakPointActionPerformed", ResourceManager.getI18NMessage("RemoveBreakPoint"), SCEditorImageLoader.getImageIcon("removebreakpoint16", 1006));
                this._showPropertyBreakPointAction = new ReflectiveAction(this, "editBreakPointActionPerformed", ResourceManager.getI18NMessage("EditBreakPoint"), SCEditorImageLoader.getImageIcon("properties", 1001));
                this._breakPointPopupMenu = new JPopupMenu();
                this._breakPointPopupMenu.add((JMenuItem)new SybMenuItem(this._enableBreakPointAction));
                this._breakPointPopupMenu.add((JMenuItem)new SybMenuItem(this._disableBreakPointAction));
                this._breakPointPopupMenu.add((JMenuItem)new SybMenuItem(this._insertBreakPointAction));
                this._breakPointPopupMenu.add((JMenuItem)new SybMenuItem(this._removeBreakPointAction));
                this._breakPointPopupMenu.addSeparator();
                this._breakPointPopupMenu.add((JMenuItem)new SybMenuItem(this._showPropertyBreakPointAction));
                this._breakPointList.addMouseListener(this);
            }
        }
    }

    private void updateBreakPointUI() {
        if (this._debuggingEditor && this.isDisplayable()) {
            int n = this.getGraphics().getFontMetrics().getHeight();
            this._breakPointList.setFixedCellHeight(n);
            this._breakPointList.setFixedCellWidth(n + 1);
            BREAK_POINT_ICON = new ImageIcon(SCEditorImageLoader.getImage("breakpoint16", 1006).getScaledInstance(n, n, 4));
            DISABLED_BREAK_POINT_ICON = new ImageIcon(SCEditorImageLoader.getImage("disabledbreakpoint16", 1006).getScaledInstance(n, n, 4));
            NO_BREAK_POINT_ICON = new ImageIcon(SCEditorImageLoader.getImage("blank", 1001).getScaledInstance(n, n, 2));
            BREAK_POINT_CURRENT_STATEMENT_ICON = new ImageIcon(SCEditorImageLoader.getImage("breakpointcurrentstatement16", 1006).getScaledInstance(n, n, 4));
            DISABLED_BREAK_POINT_CURRENT_STATEMENT_ICON = new ImageIcon(SCEditorImageLoader.getImage("disabledbreakpointcurrentstatement16", 1006).getScaledInstance(n, n, 4));
            NO_BREAK_POINT_CURRENT_STATEMENT_ICON = new ImageIcon(SCEditorImageLoader.getImage("currentstatement16", 1006).getScaledInstance(n, n, 4));
            if (this._scrollPane == null && this.getParent() instanceof JViewport && this.getParent().getParent() instanceof JScrollPane) {
                this._scrollPane = (JScrollPane)this.getParent().getParent();
            }
            if (this._scrollPane != null && this._breakPointList.getParent() == null) {
                this._scrollPane.setRowHeaderView(this._breakPointList);
            }
            this._breakPointList.setForeground(SCEditorProperties.getBreakPointMarginForeground());
            this._breakPointList.setBackground(SCEditorProperties.getBreakPointMarginBackground());
        }
    }

    public void enableBreakPointActionPerformed() {
        this.setBreakPoint(this._breakPointActionLine + 1, 0, false);
    }

    public void disableBreakPointActionPerformed() {
        this.setBreakPoint(this._breakPointActionLine + 1, 1, false);
    }

    public void insertBreakPointActionPerformed() {
        this.setBreakPoint(this._breakPointActionLine + 1, 0, false);
    }

    public void removeBreakPointActionPerformed() {
        this.setBreakPoint(this._breakPointActionLine + 1, 2, false);
    }

    public void editBreakPointActionPerformed() {
        if (this._breakPointClient != null) {
            this._breakPointClient.showProperties(this._breakPointActionLine + 1);
        }
    }

    @Override
    public boolean isDebuggingEditor() {
        return this._debuggingEditor;
    }

    @Override
    public void reload(FileReader fileReader, int n) {
        this.doReload(fileReader, n, null);
    }

    @Override
    public void reload(Reader reader, int n) {
        this.doReload(reader, n, null);
    }

    @Override
    public void reload(FileReader fileReader, int n, BoundedRangeModel boundedRangeModel) {
        this.doReload(fileReader, n, boundedRangeModel);
    }

    @Override
    public void reload(Reader reader, int n, BoundedRangeModel boundedRangeModel) {
        this.doReload(reader, n, boundedRangeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doReload(Reader reader, int n, BoundedRangeModel boundedRangeModel) {
        this.getDocument().removeDocumentListener(this);
        this.getDocument().removeUndoableEditListener(this);
        if (boundedRangeModel == null) {
            try {
                this.setCursor(WAIT_CURSOR);
                try {
                    this.read(reader, null);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Document document = this.getDocument();
                    if (document instanceof SCDocument) {
                        ((SCDocument)document).destroy();
                    }
                    System.gc();
                    this.setDocument(this._kit.createDefaultDocument());
                    System.gc();
                    this.fireAsynchronousTaskEvent(outOfMemoryError);
                }
                this.setCaretPosition(n);
                this.getDocument().addUndoableEditListener(this);
                this.getDocument().addDocumentListener(this);
                this._undo.discardAllEdits();
                if (this._parent == null) return;
                this._parent.updateUndoRedoState();
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                this.setCursor(TEXT_CURSOR);
            }
        }
        if (this._loader != null && this._loader.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._loader != null && this._loader.isAlive()) {
                throw new IllegalStateException("Loader thread is already active!");
            }
        }
        this._loader = new FileLoader(reader, n, boundedRangeModel, 0, true);
        this._loader.start();
    }

    @Override
    public void setKeepTabs(boolean bl) {
        SCEditorProperties.setKeepTabs(bl);
    }

    @Override
    public boolean getKeepTabs() {
        return SCEditorProperties.getKeepTabs();
    }

    @Override
    public void setIndentSize(int n) {
        SCEditorProperties.setIndentSize(n);
    }

    @Override
    public int getIndentSize() {
        return SCEditorProperties.getIndentSize();
    }

    @Override
    public void setTabSize(int n) {
        SCEditorProperties.setTabSize(n);
    }

    @Override
    public int getTabSize() {
        return SCEditorProperties.getTabSize();
    }

    public void setFontSize(int n) {
        SCEditorProperties.setFontSize(n);
    }

    public int getFontSize() {
        return SCEditorProperties.getFontSize();
    }

    public void setFontName(String string) {
        SCEditorProperties.setFont(string);
    }

    public String getFontName() {
        return SCEditorProperties.getFont();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        block78: {
            if (keyEvent.isActionKey()) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (c == '\t') {
                if (this.getSelectionStart() != this.getSelectionEnd() && this.getSelectedText().indexOf(10) != -1) {
                    int n;
                    CharSequence charSequence;
                    keyEvent.consume();
                    int n2 = this.getSelectionStart();
                    int n3 = this.getSelectionEnd() - 1;
                    String string = "\t";
                    if (!SCEditorProperties.getKeepTabs() && keyEvent.getModifiers() == 0) {
                        charSequence = new StringBuffer();
                        for (n = 0; n < SCEditorProperties.getIndentSize(); ++n) {
                            ((StringBuffer)charSequence).append(' ');
                        }
                        string = ((StringBuffer)charSequence).toString();
                    }
                    try {
                        int n4;
                        int n5;
                        if (n2 != 0) {
                            charSequence = this.getDocument().getText(0, n2);
                            for (n = n2 - 1; n > -1 && ((String)charSequence).charAt(n) != '\n'; --n) {
                            }
                            n2 = n + 1;
                        }
                        if (this.getDocument().getText(0, this.getDocument().getLength()).charAt(n3) == '\n') {
                            --n3;
                        }
                        String string2 = this.getDocument().getText(0, this.getDocument().getLength()).substring(n2, n3);
                        for (n = n5 = string2.length() - 1; n > -1; --n) {
                            if (string2.charAt(n) != '\n') continue;
                            if (keyEvent.getModifiers() == 0) {
                                this.getDocument().insertString(n + n2 + 1, string, null);
                                continue;
                            }
                            if (keyEvent.getModifiers() != 1) continue;
                            String string3 = string2.substring(n + 1, n5);
                            int c2 = string3.length();
                            for (n4 = 0; n4 < SCEditorProperties.getIndentSize() && n4 < c2; ++n4) {
                                char c3 = string3.charAt(n4);
                                if (c3 == '\n' || !Character.isWhitespace(c3)) {
                                    --n4;
                                    break;
                                }
                                if (c3 == '\t') break;
                            }
                            if (n4 > -1) {
                                this.getDocument().remove(n + n2 + 1, n4);
                            }
                            n5 = n;
                        }
                        if (keyEvent.getModifiers() == 0) {
                            this.getDocument().insertString(n2, string, null);
                        } else if (keyEvent.getModifiers() == 1) {
                            int n6;
                            String string4 = string2.substring(0, n5);
                            n4 = string4.length();
                            for (n6 = 0; n6 < SCEditorProperties.getIndentSize() && n6 < n4; ++n6) {
                                char n14 = string4.charAt(n6);
                                if (n14 == '\n' || !Character.isWhitespace(n14)) {
                                    --n6;
                                    break;
                                }
                                if (n14 == '\t') break;
                            }
                            if (n6 > -1) {
                                this.getDocument().remove(n2, n6);
                            }
                        }
                        this.setSelectionStart(n2);
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                } else if (!SCEditorProperties.getKeepTabs()) {
                    int n = 0;
                    try {
                        int n7;
                        int n8;
                        Caret caret = this.getCaret();
                        if (caret != null) {
                            Rectangle rectangle = this.modelToView(caret.getDot());
                            n8 = this.getGraphics().getFontMetrics().charWidth('W');
                            n = rectangle.x / n8;
                        }
                        if (SCEditorProperties.getIndentSize() > 0) {
                            for (n7 = 0; n7 <= n; n7 += SCEditorProperties.getIndentSize()) {
                            }
                        }
                        keyEvent.consume();
                        n8 = n7 - n;
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < n8; ++i) {
                            stringBuffer.append(' ');
                        }
                        if (caret != null) {
                            this.getDocument().insertString(caret.getDot(), stringBuffer.toString(), null);
                            break block78;
                        }
                        this.getDocument().insertString(0, stringBuffer.toString(), null);
                    }
                    catch (Exception exception) {}
                }
            } else {
                switch (SCEditorProperties.getAutoIndent()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!this.isEditable() || c != '\n' || this.getSelectionStart() != this.getSelectionEnd()) break;
                        keyEvent.consume();
                        this.indentNewLine(false);
                        break;
                    }
                    case 3: {
                        CharSequence exception;
                        String string;
                        String string5;
                        if (!this.isEditable()) break;
                        if (c == '\n' && this.getSelectionStart() == this.getSelectionEnd()) {
                            keyEvent.consume();
                            this.indentNewLine(true);
                            break;
                        }
                        if (c == '\n') break;
                        if (this._parserClass.isCaseSensitive() && c == this._lastBlockBeginChar || !this._parserClass.isCaseSensitive() && Character.toUpperCase(c) == Character.toUpperCase(this._lastBlockBeginChar)) {
                            String string6;
                            String string7;
                            int n = this.getCaretPosition();
                            try {
                                string7 = this.getDocument().getText(0, n);
                            }
                            catch (Exception exception2) {
                                string7 = "";
                            }
                            boolean bl = false;
                            if (this._parserClass.isCaseSensitive()) {
                                if (string7.endsWith(this._parserClass.getBlockBegin().substring(0, this._parserClass.getBlockBegin().length() - 1))) {
                                    bl = true;
                                }
                            } else if (string7.toUpperCase().endsWith(this._parserClass.getBlockBegin().substring(0, this._parserClass.getBlockBegin().length() - 1).toUpperCase())) {
                                bl = true;
                            }
                            if (!bl) break;
                            int n9 = string7.lastIndexOf(10);
                            n9 = n9 == -1 ? 0 : ++n9;
                            if (n9 <= 0 || !(string6 = string7.substring(n9).trim()).toUpperCase().equals(this._parserClass.getBlockBegin().toUpperCase().substring(0, this._parserClass.getBlockBegin().length() - 1)) || !SCEditorProperties.getSmartIndentOpenBrace()) break;
                            StringBuffer stringBuffer = new StringBuffer();
                            if (!SCEditorProperties.getKeepTabs()) {
                                for (int i = 0; i < SCEditorProperties.getIndentSize(); ++i) {
                                    stringBuffer.append(' ');
                                }
                            } else {
                                stringBuffer.append('\t');
                            }
                            try {
                                this.getDocument().insertString(n + 1 - this._parserClass.getBlockBegin().length(), stringBuffer.toString(), null);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            keyEvent.consume();
                            break;
                        }
                        if (SCEditorProperties.getSmartIndentClosingBrace() || c != this._lastBlockEndChar && (this._parserClass.isCaseSensitive() || Character.toUpperCase(c) != Character.toUpperCase(this._lastBlockEndChar))) break;
                        int n = this.getCaretPosition();
                        try {
                            string5 = this.getDocument().getText(0, n);
                        }
                        catch (Exception exception3) {
                            string5 = "";
                        }
                        boolean bl = false;
                        if (this._parserClass.isCaseSensitive()) {
                            if (string5.endsWith(this._parserClass.getBlockEnd().substring(0, this._parserClass.getBlockEnd().length() - 1))) {
                                bl = true;
                            }
                        } else if (string5.toUpperCase().endsWith(this._parserClass.getBlockEnd().toUpperCase().substring(0, this._parserClass.getBlockEnd().length() - 1))) {
                            bl = true;
                        }
                        if (!bl) break;
                        int n10 = string5.lastIndexOf(10);
                        n10 = n10 == -1 ? 0 : ++n10;
                        int n11 = n10;
                        int n12 = n - n10;
                        if (n10 <= 0 || !(string = string5.substring(n10).trim()).toUpperCase().equals(this._parserClass.getBlockEnd().toUpperCase().substring(0, this._parserClass.getBlockEnd().length() - 1))) break;
                        int n13 = 0;
                        boolean bl2 = false;
                        int n2 = 0;
                        while (string5.length() > 0) {
                            n10 = string5.lastIndexOf(10);
                            if (n10 == -1) {
                                n10 = 0;
                            }
                            if (n10 > 0) {
                                void var11_44;
                                exception = string5.substring(n10);
                                if (this._parserClass.isCaseSensitive() && ((String)exception).indexOf(this._parserClass.getBlockEnd()) != -1 || !this._parserClass.isCaseSensitive() && ((String)exception).toUpperCase().indexOf(this._parserClass.getBlockEnd().toUpperCase()) != -1) {
                                    ++var11_44;
                                }
                                if (this._parserClass.isCaseSensitive() && ((String)exception).indexOf(this._parserClass.getBlockBegin()) != -1 || !this._parserClass.isCaseSensitive() && ((String)exception).toUpperCase().indexOf(this._parserClass.getBlockBegin().toUpperCase()) != -1) {
                                    ++n2;
                                }
                                if ((this._parserClass.isCaseSensitive() && ((String)exception).trim().endsWith(this._parserClass.getBlockBegin()) || !this._parserClass.isCaseSensitive() && ((String)exception).trim().toUpperCase().endsWith(this._parserClass.getBlockBegin().toUpperCase())) && n2 > var11_44) {
                                    if (SCEditorProperties.getSmartIndentOpenBrace()) {
                                        try {
                                            string5 = this.getDocument().getText(0, n10);
                                        }
                                        catch (Exception n16) {
                                            string5 = "";
                                        }
                                        n10 = string5.lastIndexOf(10);
                                        if (n10 == -1) {
                                            n10 = 0;
                                        }
                                        exception = n10 > 0 ? string5.substring(n10) : string5.substring(0);
                                    }
                                    n13 = this.getIndentForLine((String)exception);
                                    break;
                                }
                            } else {
                                n13 = 0;
                                break;
                            }
                            try {
                                string5 = this.getDocument().getText(0, n10);
                            }
                            catch (Exception exception4) {
                                // empty catch block
                                break;
                            }
                        }
                        try {
                            this.getDocument().remove(n11, n12 - this._parserClass.getBlockEnd().length() + 1);
                        }
                        catch (Exception exception5) {
                            // empty catch block
                        }
                        exception = new StringBuffer();
                        if (!SCEditorProperties.getKeepTabs()) {
                            for (int exception6 = 0; exception6 < n13; ++exception6) {
                                ((StringBuffer)exception).append(' ');
                            }
                        } else {
                            int n3;
                            for (n3 = 0; n3 < n13 / SCEditorProperties.getIndentSize(); ++n3) {
                                ((StringBuffer)exception).append('\t');
                            }
                            n3 = n13 % SCEditorProperties.getIndentSize();
                            if (n3 > 0) {
                                for (int i = 0; i < n3; ++i) {
                                    ((StringBuffer)exception).append(' ');
                                }
                            }
                        }
                        try {
                            this.getDocument().insertString(n11, ((StringBuffer)exception).toString(), null);
                        }
                        catch (Exception exception7) {
                            // empty catch block
                        }
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    private void indentNewLine(boolean bl) {
        String string;
        int n = this.getCaretPosition();
        try {
            string = this.getDocument().getText(0, n);
        }
        catch (Exception exception) {
            string = "";
        }
        int n2 = n;
        String string2 = string.substring(n2);
        int n3 = 0;
        if (bl && !string2.trim().endsWith(this._parserClass.getStatementEnd())) {
            CharSequence charSequence;
            while (string.length() > 0) {
                n2 = string.lastIndexOf(10);
                if (n2 == -1) {
                    n2 = 0;
                }
                if (n2 > 0) {
                    charSequence = string.substring(n2);
                    String string3 = ((String)charSequence).trim();
                    if (this._parserClass.isCaseSensitive() && string3.endsWith(this._parserClass.getBlockBegin()) || !this._parserClass.isCaseSensitive() && string3.toUpperCase().endsWith(this._parserClass.getBlockBegin().toUpperCase())) {
                        n3 = this.getIndentForLine((String)charSequence);
                        if (!SCEditorProperties.getSmartIndentOpenBrace()) {
                            n3 += SCEditorProperties.getIndentSize();
                            break;
                        }
                        if ((!this._parserClass.isCaseSensitive() || string3.equals(this._parserClass.getBlockBegin())) && (this._parserClass.isCaseSensitive() || string3.toUpperCase().equals(this._parserClass.getBlockBegin().toUpperCase()))) break;
                        n3 += SCEditorProperties.getIndentSize();
                        break;
                    }
                    if (this._parserClass.isCaseSensitive() && string3.endsWith(this._parserClass.getBlockEnd()) || !this._parserClass.isCaseSensitive() && string3.toUpperCase().endsWith(this._parserClass.getBlockEnd().toUpperCase())) {
                        n3 = this.getIndentForLine((String)charSequence);
                        if (!SCEditorProperties.getSmartIndentClosingBrace()) break;
                        n3 -= SCEditorProperties.getIndentSize();
                        break;
                    }
                    if (this._parserClass.isCaseSensitive() && string3.endsWith(this._parserClass.getStatementEnd()) || !this._parserClass.isCaseSensitive() && string3.toUpperCase().endsWith(this._parserClass.getStatementEnd().toUpperCase())) {
                        n3 = this.getIndentForLine((String)charSequence);
                        break;
                    }
                    n3 += SCEditorProperties.getIndentSize();
                } else {
                    charSequence = string.trim();
                    if (this._parserClass.isCaseSensitive() && ((String)charSequence).endsWith(this._parserClass.getBlockBegin()) || !this._parserClass.isCaseSensitive() && ((String)charSequence).toUpperCase().endsWith(this._parserClass.getBlockBegin().toUpperCase())) {
                        n3 = this.getIndentForLine(string);
                        if (!SCEditorProperties.getSmartIndentOpenBrace()) {
                            n3 += SCEditorProperties.getIndentSize();
                            break;
                        }
                        if ((!this._parserClass.isCaseSensitive() || ((String)charSequence).equals(this._parserClass.getBlockBegin())) && (this._parserClass.isCaseSensitive() || ((String)charSequence).toUpperCase().equals(this._parserClass.getBlockBegin().toUpperCase()))) break;
                        n3 += SCEditorProperties.getIndentSize();
                        break;
                    }
                    n3 = this.getIndentForLine(string);
                    break;
                }
                try {
                    string = this.getDocument().getText(0, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            charSequence = new StringBuffer().append("\n");
            if (!SCEditorProperties.getKeepTabs()) {
                for (int i = 0; i < n3; ++i) {
                    ((StringBuffer)charSequence).append(' ');
                }
            } else if (SCEditorProperties.getIndentSize() > 0) {
                int n4;
                for (n4 = 0; n4 < n3 / SCEditorProperties.getIndentSize(); ++n4) {
                    ((StringBuffer)charSequence).append('\t');
                }
                n4 = n3 % SCEditorProperties.getIndentSize();
                if (n4 > 0) {
                    for (int i = 0; i < n4; ++i) {
                        ((StringBuffer)charSequence).append(' ');
                    }
                }
            }
            try {
                this.getDocument().insertString(n, ((StringBuffer)charSequence).toString(), null);
            }
            catch (Exception exception) {}
        } else {
            try {
                this.getDocument().insertString(n, "\n", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getIndentForLine(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
            stringBuffer.append(string.charAt(n));
        }
        n = 0;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == ' ') {
                ++n;
                continue;
            }
            if (stringBuffer.charAt(i) != '\t') continue;
            int n2 = (n += SCEditorProperties.getIndentSize()) / SCEditorProperties.getIndentSize();
            n = n2 * SCEditorProperties.getIndentSize();
        }
        return n;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private int countLinesInBlock(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().endsWith("\n")) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        block19: {
            this.setChanged(true);
            this._contentChanged = true;
            if (this._debuggingEditor) {
                try {
                    int n = documentEvent.getLength();
                    int n2 = documentEvent.getOffset();
                    Document document = documentEvent.getDocument();
                    DocumentEvent.EventType eventType = documentEvent.getType();
                    if (eventType == DocumentEvent.EventType.CHANGE) {
                        String string = this._breakPointContextBuffer.substring(n2, n2 + n);
                        this._breakPointContextBuffer.replace(n2, n2 + n, string);
                        break block19;
                    }
                    if (eventType == DocumentEvent.EventType.INSERT) {
                        int n3 = 0;
                        if (n2 > 0) {
                            n3 = this.countLinesInBlock(this._breakPointContextBuffer.substring(0, n2));
                        }
                        String string = document.getText(n2, n);
                        this._breakPointContextBuffer.insert(n2, string);
                        int n4 = this.countLinesInBlock(string);
                        if (document.getLength() <= n2 + n) {
                            if (!string.endsWith("\n")) {
                                ++n4;
                            }
                            int n5 = n3 + n4;
                            for (int i = n3; i < n5; ++i) {
                                this._breakPointListModel.addElement(new BreakPoint());
                            }
                            if (n4 != 0) break block19;
                            try {
                                Object e = this._breakPointListModel.get(n3);
                                if (e == null) {
                                    this._breakPointListModel.addElement(new BreakPoint());
                                }
                                break block19;
                            }
                            catch (Exception exception) {
                                this._breakPointListModel.addElement(new BreakPoint());
                            }
                            break block19;
                        }
                        int n6 = n3 + n4 + 1;
                        for (int i = n3 + 1; i < n6; ++i) {
                            this._breakPointListModel.insertElementAt(new BreakPoint(), i);
                        }
                        break block19;
                    }
                    int n7 = 0;
                    if (n2 > 0) {
                        n7 = this.countLinesInBlock(this._breakPointContextBuffer.substring(0, n2));
                    }
                    String string = "";
                    try {
                        string = this._breakPointContextBuffer.substring(n2, n2 + n);
                    }
                    catch (Exception exception) {
                        this._breakPointContextBuffer.setLength(0);
                    }
                    this._breakPointContextBuffer.replace(n2, n2 + n, "");
                    int n8 = this.countLinesInBlock(string);
                    if (n2 != 0 && this._breakPointContextBuffer.charAt(n2 - 1) != '\n') {
                        ++n7;
                    }
                    int n9 = n7;
                    int n10 = n7 + n8 - 1;
                    if (n10 >= this._breakPointListModel.size()) {
                        n10 = this._breakPointListModel.size() - 1;
                    }
                    if (n8 > 0 && n10 >= n10) {
                        this._breakPointListModel.removeRange(n9, n10);
                    }
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._breakPointList.getSelectedIndex() == -1) {
            return;
        }
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int n = this._breakPointList.getSelectedIndex();
            this.toggleBreakPoint(n + 1);
            this.requestFocusInWindow();
            this.goTo(n + 1);
            this._breakPointList.clearSelection();
        }
    }

    @Override
    public void setChanged(boolean bl) {
        if (!this._settingTextQuietly) {
            this._hasChanged = bl;
            if (this._parent != null) {
                this._parent.updateTitle();
            } else {
                JRootPane jRootPane = SwingUtilities.getRootPane(this);
                if (jRootPane != null) {
                    if (bl) {
                        jRootPane.putClientProperty("windowModified", Boolean.TRUE);
                    } else {
                        jRootPane.putClientProperty("windowModified", Boolean.FALSE);
                    }
                }
            }
        }
    }

    void doRepaint() {
        this._repaintRequired = true;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._repaintRequired && this._contentChanged) {
            super.repaint(this.getBounds());
        }
        this._repaintRequired = false;
        this._contentChanged = false;
    }

    @Override
    public boolean isChanged() {
        return this._hasChanged;
    }

    public int getLineCount() {
        int n;
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement((n = element.getElementCount()) - 1);
        if (element2.getEndOffset() - element2.getStartOffset() > 1) {
            return n;
        }
        return n - 1;
    }

    @Override
    public void print(String string, PrintJobListener printJobListener) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            this.print(window, printJobListener);
        }
    }

    @Override
    @Deprecated
    public void print(String string, PrinterJobListener printerJobListener) {
        this.print(string, (PrintJobListener)new PrinterJobListenerShim(printerJobListener));
    }

    public void print(JDialog jDialog, String string, PrintJobListener printJobListener) {
        this.print(jDialog, printJobListener);
    }

    public void print(JFrame jFrame, String string, PrintJobListener printJobListener) {
        this.print(jFrame, printJobListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(Window window, PrintJobListener printJobListener) {
        if (this._printJobThread != null) {
            while (this._printJobThread.isBusy()) {
                SCEditor sCEditor = this;
                synchronized (sCEditor) {
                    try {
                        this.wait(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        PrintDialog printDialog = window instanceof JDialog ? new PrintDialog((Dialog)((JDialog)window)) : new PrintDialog((Frame)((JFrame)window));
        this._printJobListener = printJobListener;
        if (printDialog.showDialog(1, printerJob, pageFormat)) {
            this._printJobThread = new PrintJobThread((Printable)this, printerJob, pageFormat, printJobListener);
            this._printJobThread.start();
        }
    }

    @Override
    public boolean isPrinting() {
        return this._printJobThread != null && this._printJobThread.isBusy();
    }

    @Override
    public void cancelPrint() {
        if (this._printJobThread != null) {
            this._printJobThread.cancel();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Object object;
        Font font = new Font(SCEditorProperties.getFont(), 0, SCEditorProperties.getPrintFontSize());
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.getDescent();
        int n5 = (int)pageFormat.getImageableWidth();
        int n6 = (int)pageFormat.getImageableHeight();
        if (this._printView == null) {
            String[] stringArray;
            Object object2;
            Object object3;
            this._leftHeader = null;
            this._centerHeader = null;
            this._rightHeader = null;
            this._leftFooter = null;
            this._centerFooter = null;
            this._rightFooter = null;
            this._hasPrintHeader = false;
            this._hasPrintFooter = false;
            char[] cArray = SCEditorProperties.getPrintHeader().trim().toCharArray();
            char[] cArray2 = SCEditorProperties.getPrintFooter().trim().toCharArray();
            DateFormat dateFormat = DateFormat.getDateInstance();
            DateFormat dateFormat2 = DateFormat.getTimeInstance();
            object = new Date();
            String string = dateFormat2.format((Date)object);
            String string2 = dateFormat.format((Date)object);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (this._fileName != null) {
                object3 = new File(this._fileName);
                string5 = ((File)object3).getName();
                object2 = new Date(((File)object3).lastModified());
                string3 = dateFormat2.format((Date)object2);
                string4 = dateFormat.format((Date)object2);
            }
            if (cArray.length != 0) {
                this._hasPrintHeader = true;
            }
            if (cArray2.length != 0) {
                this._hasPrintFooter = true;
            }
            object3 = (BasicTextUI)this.getUI();
            object2 = ((BasicTextUI)object3).getRootView(this);
            this._printView = new PrintView(this.getDocument().getDefaultRootElement(), (View)object2, n5, n6, fontMetrics);
            int n7 = (n6 - (this._hasPrintHeader ? n2 : 0) - (this._hasPrintFooter ? n2 : 0)) / n2;
            int n8 = this._printView.calculateTotalLineCount();
            int n9 = n8 / n7 + (n8 % n7 > 0 ? 1 : 0);
            if (cArray.length != 0) {
                stringArray = SCEditor.parsePrintHeader(cArray, string, string2, string3, string4, string5, n9);
                this._leftHeader = stringArray[0];
                this._centerHeader = stringArray[1];
                this._rightHeader = stringArray[2];
            }
            if (cArray2.length != 0) {
                stringArray = SCEditor.parsePrintHeader(cArray2, string, string2, string3, string4, string5, n9);
                this._leftFooter = stringArray[0];
                this._centerFooter = stringArray[1];
                this._rightFooter = stringArray[2];
            }
        }
        if (this._printJobListener != null) {
            this._printJobListener.printingPage(n + 1);
        }
        boolean bl = this._printView.paintPage(graphics, n6, n, this._hasPrintHeader, this._hasPrintFooter);
        int n10 = 0;
        int n11 = n3;
        int n12 = n + 1;
        if (this._hasPrintHeader) {
            if (this._leftHeader != null) {
                graphics.drawString(SCEditor.insertPrintPageNumber(this._leftHeader, n12), n10, n11);
            }
            if (this._centerHeader != null) {
                object = SCEditor.insertPrintPageNumber(this._centerHeader, n12);
                n10 = n5 / 2 - (int)(fontMetrics.getStringBounds((String)object, graphics).getWidth() / 2.0);
                graphics.drawString((String)object, n10, n11);
            }
            if (this._rightHeader != null) {
                object = SCEditor.insertPrintPageNumber(this._rightHeader, n12);
                n10 = n5 - (int)fontMetrics.getStringBounds((String)object, graphics).getWidth() - 1;
                graphics.drawString((String)object, n10, n11);
            }
        }
        if (this._hasPrintFooter) {
            n11 = n6 - n4;
            if (this._leftFooter != null) {
                n10 = 0;
                graphics.drawString(SCEditor.insertPrintPageNumber(this._leftFooter, n12), n10, n11);
            }
            if (this._centerFooter != null) {
                object = SCEditor.insertPrintPageNumber(this._centerFooter, n12);
                n10 = n5 / 2 - (int)(fontMetrics.getStringBounds((String)object, graphics).getWidth() / 2.0);
                graphics.drawString((String)object, n10, n11);
            }
            if (this._rightFooter != null) {
                object = SCEditor.insertPrintPageNumber(this._rightFooter, n12);
                n10 = n5 - (int)fontMetrics.getStringBounds((String)object, graphics).getWidth() - 1;
                graphics.drawString((String)object, n10, n11);
            }
        }
        if (bl) {
            return 0;
        }
        this._printView = null;
        return 1;
    }

    static String insertPrintPageNumber(String string, int n) {
        int n2 = string.indexOf("&P");
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n2 != -1) {
            stringBuffer.replace(n2, n2 + 2, String.valueOf(n));
            n2 = stringBuffer.toString().indexOf("&P");
        }
        return stringBuffer.toString();
    }

    static String[] parsePrintHeader(char[] cArray, String string, String string2, String string3, String string4, String string5, int n) {
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        StringBuffer stringBuffer2 = new StringBuffer(cArray.length);
        StringBuffer stringBuffer3 = new StringBuffer(cArray.length);
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '&') {
                if (i + 1 < cArray.length) {
                    char c = cArray[i + 1];
                    if (c == 'L') {
                        bl = true;
                        bl2 = false;
                        ++i;
                        continue;
                    }
                    if (c == 'C') {
                        bl = false;
                        bl2 = true;
                        ++i;
                        continue;
                    }
                    if (c == 'R') {
                        bl = false;
                        bl2 = false;
                        ++i;
                        continue;
                    }
                    if (c == 'F') {
                        if (bl) {
                            stringBuffer.append(string5);
                        } else if (bl2) {
                            stringBuffer2.append(string5);
                        } else {
                            stringBuffer3.append(string5);
                        }
                        ++i;
                        continue;
                    }
                    if (c == 'P') {
                        if (bl) {
                            stringBuffer.append("&P");
                        } else if (bl2) {
                            stringBuffer2.append("&P");
                        } else {
                            stringBuffer3.append("&P");
                        }
                        ++i;
                        continue;
                    }
                    if (c == 'p') {
                        if (bl) {
                            stringBuffer.append(n);
                        } else if (bl2) {
                            stringBuffer2.append(n);
                        } else {
                            stringBuffer3.append(n);
                        }
                        ++i;
                        continue;
                    }
                    if (c == 'T') {
                        if (bl) {
                            stringBuffer.append(string);
                        } else if (bl2) {
                            stringBuffer2.append(string);
                        } else {
                            stringBuffer3.append(string);
                        }
                        ++i;
                        continue;
                    }
                    if (c == 't') {
                        if (bl) {
                            stringBuffer.append(string3);
                        } else if (bl2) {
                            stringBuffer2.append(string3);
                        } else {
                            stringBuffer3.append(string3);
                        }
                        ++i;
                        continue;
                    }
                    if (c == 'D') {
                        if (bl) {
                            stringBuffer.append(string2);
                        } else if (bl2) {
                            stringBuffer2.append(string2);
                        } else {
                            stringBuffer3.append(string2);
                        }
                        ++i;
                        continue;
                    }
                    if (c == 'd') {
                        if (bl) {
                            stringBuffer.append(string4);
                        } else if (bl2) {
                            stringBuffer2.append(string4);
                        } else {
                            stringBuffer3.append(string4);
                        }
                        ++i;
                        continue;
                    }
                    if (bl) {
                        stringBuffer.append(cArray[i]).append(c);
                        continue;
                    }
                    if (bl2) {
                        stringBuffer2.append(cArray[i]).append(c);
                        continue;
                    }
                    stringBuffer3.append(cArray[i]).append(c);
                    continue;
                }
                if (bl) {
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                if (bl2) {
                    stringBuffer2.append(cArray[i]);
                    continue;
                }
                stringBuffer3.append(cArray[i]);
                continue;
            }
            if (bl) {
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (bl2) {
                stringBuffer2.append(cArray[i]);
                continue;
            }
            stringBuffer3.append(cArray[i]);
        }
        return new String[]{stringBuffer.toString(), stringBuffer2.toString(), stringBuffer3.toString()};
    }

    @Override
    public float nextTabStop(float f, int n) {
        int n2 = SCEditorProperties.getIndentSize();
        int n3 = (int)f / n2;
        return (n3 + 1) * n2;
    }

    @Override
    public void setEditorStyles() {
        String string = "";
        try {
            string = this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = this.getCaretPosition();
        SCEditorProperties.load();
        this.setForeground(SCEditorProperties.getTextForeground());
        this.setBackground(SCEditorProperties.getTextBackground());
        this.setCaretColor(SCEditorProperties.getCaretColor());
        this.setSelectedTextColor(SCEditorProperties.getTextSelectionForeground());
        this.setSelectionColor(SCEditorProperties.getTextSelectionBackground());
        int n2 = SCEditor.isWindows() ? (int)Math.round((double)SCEditorProperties.getFontSize() * 4.0 / 3.0) : SCEditorProperties.getFontSize();
        String string2 = SCEditorProperties.getFont();
        this.setFont(new Font(string2, SCEditorProperties.getTextStyle(), n2));
        if (this._parserClass == null) {
            try {
                this._parserClass = (Parser)Class.forName("com.sybase.central.editor." + Character.toUpperCase(this._editorType.charAt(0)) + this._editorType.substring(1) + "Parser").newInstance();
            }
            catch (Exception exception) {
                try {
                    this._parserClass = PlainParser.getInstance();
                }
                catch (Exception exception2) {
                    ExceptionHandler.handleException((Throwable)exception2);
                }
            }
        }
        this._lastBlockBeginChar = this._parserClass.getBlockBegin().length() > 0 ? this._parserClass.getBlockBegin().charAt(this._parserClass.getBlockBegin().length() - 1) : (char)32;
        this._lastBlockEndChar = this._parserClass.getBlockEnd().length() > 0 ? this._parserClass.getBlockEnd().charAt(this._parserClass.getBlockEnd().length() - 1) : (char)32;
        if (this.getDocument() instanceof SCDocument) {
            ((SCDocument)this.getDocument()).destroy();
        } else {
            this.getDocument().removeDocumentListener(this);
            this.getDocument().removeUndoableEditListener(this);
        }
        if (this._kit != null) {
            this._kit.deinstall(this);
        }
        if (this._styles != null) {
            this._styles.destroy();
        }
        this._kit = new SCEditorKit(this._editorType, this);
        this.setEditorKitForContentType("text/" + this._editorType, this._kit);
        this.setContentType("text/" + this._editorType);
        this._styles = ((SCEditorKit)this._kit).getStylePreferences();
        this.setStyles(0, SCEditorProperties.getTextForeground(), SCEditorProperties.getTextBackground(), string2, SCEditorProperties.getTextStyle(), n2);
        this.setStyles(1, SCEditorProperties.getKeywordsForeground(), SCEditorProperties.getKeywordsBackground(), string2, SCEditorProperties.getKeywordsStyle(), n2);
        this.setStyles(2, SCEditorProperties.getCommentForeground(), SCEditorProperties.getCommentBackground(), string2, SCEditorProperties.getCommentStyle(), n2);
        this.setStyles(3, SCEditorProperties.getFormalCommentForeground(), SCEditorProperties.getFormalCommentBackground(), string2, SCEditorProperties.getFormalCommentStyle(), n2);
        this.setStyles(6, SCEditorProperties.getNumberForeground(), SCEditorProperties.getNumberBackground(), string2, SCEditorProperties.getNumberStyle(), n2);
        this.setStyles(4, SCEditorProperties.getStringForeground(), SCEditorProperties.getStringBackground(), string2, SCEditorProperties.getStringStyle(), n2);
        this.setStyles(5, SCEditorProperties.getOpenStringForeground(), SCEditorProperties.getOpenStringBackground(), string2, SCEditorProperties.getOpenStringStyle(), n2);
        this.setStyles(7, SCEditorProperties.getOperatorsForeground(), SCEditorProperties.getOperatorsBackground(), string2, SCEditorProperties.getOperatorsStyle(), n2);
        this.setStyles(8, SCEditorProperties.getPunctuationForeground(), SCEditorProperties.getPunctuationBackground(), string2, SCEditorProperties.getPunctuationStyle(), n2);
        this.setStyles(9, SCEditorProperties.getHTMLElementNameForeground(), SCEditorProperties.getHTMLElementNameBackground(), string2, SCEditorProperties.getHTMLElementNameStyle(), n2);
        this.setStyles(10, SCEditorProperties.getHTMLAttributeNameForeground(), SCEditorProperties.getHTMLAttributeNameBackground(), string2, SCEditorProperties.getHTMLAttributeNameStyle(), n2);
        this.setStyles(11, SCEditorProperties.getHTMLAttributeValueForeground(), SCEditorProperties.getHTMLElementNameBackground(), string2, SCEditorProperties.getHTMLAttributeValueStyle(), n2);
        this.setStyles(12, SCEditorProperties.getHTMLCommentForeground(), SCEditorProperties.getHTMLCommentBackground(), string2, SCEditorProperties.getHTMLCommentStyle(), n2);
        this.setStyles(13, SCEditorProperties.getHTMLTagDelimiterForeground(), SCEditorProperties.getHTMLTagDelimiterBackground(), string2, SCEditorProperties.getHTMLTagDelimiterStyle(), n2);
        this.setStyles(14, SCEditorProperties.getHTMLOperatorForeground(), SCEditorProperties.getHTMLOperatorBackground(), string2, SCEditorProperties.getHTMLOperatorStyle(), n2);
        this.getDocument().putProperty("tabSize", SCEditorProperties.getIndentSize());
        BreakPointLocation[] breakPointLocationArray = this.getBreakPoints();
        this.setText(string);
        this.setBreakPoints(breakPointLocationArray);
        this.getDocument().addUndoableEditListener(this);
        this.getDocument().addDocumentListener(this);
        int n3 = this.getDocument().getLength();
        if (n > n3) {
            n = n3;
        } else if (n < 0) {
            n = 0;
        }
        this.setCaretPosition(n);
        this.updateParentScrollbars();
        this.updateBreakPointUI();
    }

    private void updateParentScrollbars() {
        if (this._scrollPane == null && this.getParent() instanceof JViewport && this.getParent().getParent() instanceof JScrollPane) {
            this._scrollPane = (JScrollPane)this.getParent().getParent();
        }
        if (this._scrollPane != null) {
            if (SCEditorProperties.getHorizontalScrollBar()) {
                this._scrollPane.setHorizontalScrollBarPolicy(32);
            } else {
                this._scrollPane.setHorizontalScrollBarPolicy(31);
            }
            if (SCEditorProperties.getVerticalScrollBar()) {
                this._scrollPane.setVerticalScrollBarPolicy(22);
            } else {
                this._scrollPane.setVerticalScrollBarPolicy(21);
            }
            this._scrollPane.getViewport().setBackground(this.getBackground());
        }
    }

    @Override
    public void setText(String string) {
        this._settingTextQuietly = true;
        super.setText(string);
        this.setCaretPosition(0);
        this.setChanged(false);
        this._settingTextQuietly = false;
    }

    @Override
    public void setText(String string, Parser parser) {
        this.setEditorType(parser);
        this.setText(string);
    }

    private void replaceSelection(String string, boolean bl) {
        if (bl) {
            try {
                Document document = this.getDocument();
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    document.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    document.insertString(n, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        } else {
            this.replaceSelection(string);
        }
    }

    @Override
    public void insert(String string, int n) {
        this.setSelectionStart(n);
        this.setSelectionEnd(n);
        this.replaceSelection(string, true);
    }

    @Override
    public void insert(String string, int n, BoundedRangeModel boundedRangeModel) {
        this.insert(new StringReader(string), n, boundedRangeModel);
    }

    @Override
    public void insert(Reader reader, int n, BoundedRangeModel boundedRangeModel) {
        if (this._loader != null && this._loader.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._loader != null && this._loader.isAlive()) {
                throw new IllegalStateException("Loader thread is already active!");
            }
        }
        this._loader = new FileLoader(reader, this.getCaretPosition(), boundedRangeModel, n, false);
        this._loader.start();
    }

    @Override
    public void append(String string) {
        this.insert(string, this.getDocument().getLength());
    }

    public void append(String string, BoundedRangeModel boundedRangeModel) {
        this.insert(string, this.getDocument().getLength(), boundedRangeModel);
    }

    @Override
    public void setEditorType(String string) {
        if (string == null) {
            this._editorType = "plain";
        } else if (!this._editorType.equals(string.toLowerCase())) {
            this._editorType = string.toLowerCase();
            this._parserClass = null;
        }
        this.setEditorStyles();
    }

    @Override
    public void setEditorType(Parser parser) {
        String string;
        int n;
        if (this._parserClass == parser) {
            return;
        }
        this._parserClass = parser;
        string = this._parserClass != null ? ((n = (string = (n = (string = this._parserClass.getClass().getName()).indexOf("Parser")) > 0 ? string.substring(0, n) : "X").lastIndexOf(".")) > 0 ? string.substring(n + 1) : "X") : "X";
        this._editorType = string == null ? "plain" : string.toLowerCase();
        this._editorType = this._editorType + Long.toString(System.currentTimeMillis(), 16);
        this.setEditorStyles();
    }

    void setStyles(int n, Color color, Color color2, String string, int n2, int n3) {
        Style style = this._styles.getStyleForScanValue(n);
        if (style != null) {
            StyleConstants.setForeground(style, color);
            StyleConstants.setBackground(style, color2);
            StyleConstants.setFontFamily(style, string);
            StyleConstants.setFontSize(style, n3);
            switch (n2) {
                case 0: {
                    StyleConstants.setBold(style, false);
                    StyleConstants.setItalic(style, false);
                    break;
                }
                case 1: {
                    StyleConstants.setBold(style, true);
                    StyleConstants.setItalic(style, false);
                    break;
                }
                case 2: {
                    StyleConstants.setBold(style, false);
                    StyleConstants.setItalic(style, true);
                    break;
                }
                case 3: {
                    StyleConstants.setBold(style, true);
                    StyleConstants.setItalic(style, true);
                    break;
                }
                default: {
                    StyleConstants.setBold(style, false);
                    StyleConstants.setItalic(style, false);
                }
            }
        }
    }

    @Override
    public String getEditorType() {
        return this._editorType;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (undoableEditEvent != null) {
            this._undo.addEdit(undoableEditEvent.getEdit());
        }
        this.setChanged(true);
        if (this._parent != null) {
            this._parent.updateUndoRedoState();
        }
    }

    public UndoManager getUndoManager() {
        return this._undo;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this._hasFocus = true;
        this.getCaret().setVisible(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        block8: {
            if (!focusEvent.isTemporary()) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null) {
                    try {
                        if (component.getClass().getPackage().getName().equals("com.sybase.central.editor")) break block8;
                        boolean bl = false;
                        for (component = component.getParent(); component != null; component = component.getParent()) {
                            if (!component.getClass().getPackage().getName().equals("com.sybase.central.editor")) {
                                continue;
                            }
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this._hasFocus = false;
                        }
                    }
                    catch (Exception exception) {
                        this._hasFocus = false;
                    }
                } else {
                    this._hasFocus = false;
                }
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updateParentScrollbars();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.updateParentScrollbars();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.updateBreakPointUI();
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void processEvent(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getModifiers() == 17) {
            this.moveCaretPosition(this.viewToModel(mouseEvent.getPoint()));
            return;
        }
        super.processEvent(aWTEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            if (mouseEvent.getSource() == this) {
                this.showPopupMenu(new Point(mouseEvent.getX(), mouseEvent.getY()));
            } else if (mouseEvent.getSource() == this._breakPointList) {
                this._breakPointActionLine = this._breakPointList.locationToIndex(mouseEvent.getPoint());
                Object e = this._breakPointListModel.get(this._breakPointActionLine);
                if (e instanceof BreakPoint) {
                    BreakPoint breakPoint = (BreakPoint)e;
                    if (breakPoint.getState() == 0) {
                        this._enableBreakPointAction.setEnabled(false);
                        this._disableBreakPointAction.setEnabled(true);
                        this._insertBreakPointAction.setEnabled(false);
                        this._removeBreakPointAction.setEnabled(true);
                        this._showPropertyBreakPointAction.setEnabled(true);
                    } else if (breakPoint.getState() == 1) {
                        this._enableBreakPointAction.setEnabled(true);
                        this._disableBreakPointAction.setEnabled(false);
                        this._insertBreakPointAction.setEnabled(false);
                        this._removeBreakPointAction.setEnabled(true);
                        this._showPropertyBreakPointAction.setEnabled(true);
                    } else if (breakPoint.getState() == 2) {
                        if (this._breakPointClient != null) {
                            if (this._breakPointClient.canBreakOnLine(this._breakPointActionLine + 1)) {
                                this._enableBreakPointAction.setEnabled(false);
                                this._disableBreakPointAction.setEnabled(false);
                                this._insertBreakPointAction.setEnabled(true);
                                this._removeBreakPointAction.setEnabled(false);
                                this._showPropertyBreakPointAction.setEnabled(false);
                            } else {
                                this._enableBreakPointAction.setEnabled(false);
                                this._disableBreakPointAction.setEnabled(false);
                                this._insertBreakPointAction.setEnabled(false);
                                this._removeBreakPointAction.setEnabled(false);
                                this._showPropertyBreakPointAction.setEnabled(false);
                            }
                        } else {
                            this._enableBreakPointAction.setEnabled(false);
                            this._disableBreakPointAction.setEnabled(false);
                            this._insertBreakPointAction.setEnabled(true);
                            this._removeBreakPointAction.setEnabled(false);
                            this._showPropertyBreakPointAction.setEnabled(false);
                        }
                    }
                }
                UIUtils.showJPopupMenu((JPopupMenu)this._breakPointPopupMenu, (JComponent)this, (Point)new Point(mouseEvent.getX(), mouseEvent.getY()));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            if (mouseEvent.getSource() == this) {
                this.showPopupMenu(new Point(mouseEvent.getX(), mouseEvent.getY()));
            } else if (mouseEvent.getSource() == this._breakPointList) {
                this._breakPointActionLine = this._breakPointList.locationToIndex(mouseEvent.getPoint());
                Object e = this._breakPointListModel.get(this._breakPointActionLine);
                if (e instanceof BreakPoint) {
                    BreakPoint breakPoint = (BreakPoint)e;
                    if (breakPoint.getState() == 0) {
                        this._enableBreakPointAction.setEnabled(false);
                        this._disableBreakPointAction.setEnabled(true);
                        this._insertBreakPointAction.setEnabled(false);
                        this._removeBreakPointAction.setEnabled(true);
                        this._showPropertyBreakPointAction.setEnabled(true);
                    } else if (breakPoint.getState() == 1) {
                        this._enableBreakPointAction.setEnabled(true);
                        this._disableBreakPointAction.setEnabled(false);
                        this._insertBreakPointAction.setEnabled(false);
                        this._removeBreakPointAction.setEnabled(true);
                        this._showPropertyBreakPointAction.setEnabled(true);
                    } else if (breakPoint.getState() == 2) {
                        if (this._breakPointClient != null) {
                            if (this._breakPointClient.canBreakOnLine(this._breakPointActionLine + 1)) {
                                this._enableBreakPointAction.setEnabled(false);
                                this._disableBreakPointAction.setEnabled(false);
                                this._insertBreakPointAction.setEnabled(true);
                                this._removeBreakPointAction.setEnabled(false);
                                this._showPropertyBreakPointAction.setEnabled(false);
                            } else {
                                this._enableBreakPointAction.setEnabled(false);
                                this._disableBreakPointAction.setEnabled(false);
                                this._insertBreakPointAction.setEnabled(false);
                                this._removeBreakPointAction.setEnabled(false);
                                this._showPropertyBreakPointAction.setEnabled(false);
                            }
                        } else {
                            this._enableBreakPointAction.setEnabled(false);
                            this._disableBreakPointAction.setEnabled(false);
                            this._insertBreakPointAction.setEnabled(true);
                            this._removeBreakPointAction.setEnabled(false);
                            this._showPropertyBreakPointAction.setEnabled(false);
                        }
                    }
                }
                UIUtils.showJPopupMenu((JPopupMenu)this._breakPointPopupMenu, (JComponent)this, (Point)new Point(mouseEvent.getX(), mouseEvent.getY()));
            }
        }
    }

    private void showPopupMenu(Point point) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = this.viewToModel(point);
        if (n3 < n || n3 > n2) {
            this.setCaretPosition(n3);
        }
        UIUtils.showJPopupMenu((JPopupMenu)this.getPopupMenu(), (JComponent)this, (Point)point);
    }

    public void cutActionPerformed() {
        this.getPopupMenu().setVisible(false);
        this.cut();
    }

    public void copyActionPerformed() {
        this.getPopupMenu().setVisible(false);
        this.copy();
    }

    public void pasteActionPerformed() {
        this.getPopupMenu().setVisible(false);
        this.paste();
    }

    @Override
    public void startUndoableSequence() {
        ((SCDocument)this.getDocument()).startUndoableSequence();
    }

    @Override
    public void endUndoableSequence() {
        ((SCDocument)this.getDocument()).endUndoableSequence();
        this.setChanged(true);
        if (this._parent != null) {
            this._parent.updateUndoRedoState();
        }
    }

    @Override
    public void paste() {
        if (!this.isEditable()) {
            return;
        }
        this.startUndoableSequence();
        int n = this.getClipboardTextSize();
        if (SCEditor.hasEnoughMemory(n)) {
            super.paste();
        } else {
            this.fireAsynchronousTaskEvent(null);
        }
        this.endUndoableSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClipboardTextSize() {
        int n = 0;
        Reader reader = null;
        ClipboardManager clipboardManager = ClipboardManager.getContents((Clipboard)this.getToolkit().getSystemClipboard());
        if (clipboardManager != null && clipboardManager.contents != null) {
            try {
                DataFlavor[] dataFlavorArray = clipboardManager.contents.getTransferDataFlavors();
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!dataFlavorArray[i].getMimeType().startsWith("text/plain")) continue;
                    reader = dataFlavorArray[i].getReaderForText(clipboardManager.contents);
                    while (reader.read() != -1) {
                        ++n;
                    }
                    break;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return n;
    }

    Frame getParentFrame() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        return (Frame)container;
    }

    Dialog getParentDialog() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Dialog); container = container.getParent()) {
        }
        return (Dialog)container;
    }

    public void customizeActionPerformed() {
        this.getPopupMenu().setVisible(false);
        CustomizeDialog customizeDialog = this.getCustomizeDialog(SwingUtilities.windowForComponent(this));
        customizeDialog.selectComponent((Customizable)this);
        UIUtils.ensureWindowIsVisible((Window)customizeDialog);
        customizeDialog.setVisible(true);
    }

    public void findReplaceActionPerformed() {
        this._hasFocus = true;
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).attachListener(this);
        String string = this.getSelectedText();
        if (this.isEditable() && ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).getSearchText().length() > 0) {
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).replaceButton.setEnabled(true);
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).replaceAllButton.setEnabled(true);
        } else {
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).replaceButton.setEnabled(false);
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).replaceAllButton.setEnabled(false);
        }
        if (string != null && string.length() > 0) {
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).searchInSelection.setEnabled(true);
            if (string.indexOf(10) == -1) {
                ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).findComponent.getEditor().setItem(string);
            } else {
                ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).searchInSelection.setSelected(true);
            }
        } else {
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).searchInSelection.setSelected(false);
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).searchInSelection.setEnabled(false);
        }
        UIUtils.ensureWindowIsVisible((Window)this.getFindReplaceDialog());
        this.getFindReplaceDialog().setVisible(true);
        this.requestFocusInWindow();
    }

    public void findNextActionPerformed() {
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).downDirection.setSelected(true);
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).attachListener(this);
        if (((FindReplaceDialog)((Object)this.getFindReplaceDialog())).getSearchText() == null || ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).getSearchText().length() == 0) {
            UIUtils.ensureWindowIsVisible((Window)this.getFindReplaceDialog());
            this.getFindReplaceDialog().setVisible(true);
        } else {
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).find();
        }
    }

    public void findPreviousActionPerformed() {
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).upDirection.setSelected(true);
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).attachListener(this);
        if (((FindReplaceDialog)((Object)this.getFindReplaceDialog())).getSearchText() == null || ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).getSearchText().length() == 0) {
            UIUtils.ensureWindowIsVisible((Window)this.getFindReplaceDialog());
            this.getFindReplaceDialog().setVisible(true);
        } else {
            ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).find();
        }
    }

    public void findNextSelectedActionPerformed() {
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).downDirection.setSelected(true);
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).attachListener(this);
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).findComponent.getEditor().setItem(this.getSelectedText());
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).find();
    }

    public void findPreviousSelectedActionPerformed() {
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).upDirection.setSelected(true);
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).attachListener(this);
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).findComponent.getEditor().setItem(this.getSelectedText());
        ((FindReplaceDialog)((Object)this.getFindReplaceDialog())).find();
    }

    public void findMatchingBraceActionPerformed() {
        this.findMatchingBrace(false);
    }

    public void selectToMatchingBraceActionPerformed() {
        this.findMatchingBrace(true);
    }

    public void undoActionPerformed() {
        if (!this.isEditable()) {
            return;
        }
        if (this.getUndoManager().canUndo()) {
            this.getUndoManager().undo();
            this.undoableEditHappened(null);
        }
    }

    public void redoActionPerformed() {
        if (!this.isEditable()) {
            return;
        }
        if (this.getUndoManager().canRedo()) {
            this.getUndoManager().redo();
            this.undoableEditHappened(null);
        }
    }

    private void findMatchingBrace(boolean bl) {
        int n;
        int n2 = this.getDocument().getLength();
        char[] cArray = new char[n2];
        try {
            String string = this.getDocument().getText(0, n2);
            string.getChars(0, n2, cArray, 0);
        }
        catch (Exception exception) {
            return;
        }
        int n3 = this.getCaretPosition();
        if (n3 >= n2) {
            n3 = n2 - 1;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        char c = cArray[n3];
        char c2 = '(';
        switch (c) {
            case '(': {
                bl2 = true;
                bl3 = true;
                c2 = ')';
                break;
            }
            case '{': {
                bl2 = true;
                bl3 = true;
                c2 = '}';
                break;
            }
            case '[': {
                bl2 = true;
                bl3 = true;
                c2 = ']';
                break;
            }
            case '<': {
                bl2 = true;
                bl3 = true;
                c2 = '>';
                break;
            }
            case ')': {
                bl2 = true;
                c2 = '(';
                break;
            }
            case '}': {
                bl2 = true;
                c2 = '{';
                break;
            }
            case ']': {
                bl2 = true;
                c2 = '[';
                break;
            }
            case '>': {
                bl2 = true;
                c2 = '<';
                break;
            }
        }
        if (!bl2 && n3 > 0) {
            c = cArray[--n3];
            switch (c) {
                case '(': {
                    bl2 = true;
                    bl3 = true;
                    c2 = ')';
                    break;
                }
                case '{': {
                    bl2 = true;
                    bl3 = true;
                    c2 = '}';
                    break;
                }
                case '[': {
                    bl2 = true;
                    bl3 = true;
                    c2 = ']';
                    break;
                }
                case '<': {
                    bl2 = true;
                    bl3 = true;
                    c2 = '>';
                    break;
                }
                case ')': {
                    bl2 = true;
                    c2 = '(';
                    break;
                }
                case '}': {
                    bl2 = true;
                    c2 = '{';
                    break;
                }
                case ']': {
                    bl2 = true;
                    c2 = '[';
                    break;
                }
                case '>': {
                    bl2 = true;
                    c2 = '<';
                    break;
                }
            }
        }
        if (!bl2) {
            return;
        }
        int n4 = 1;
        if (bl3) {
            for (n = ++n3; n < n2; ++n) {
                if (cArray[n] == c) {
                    ++n4;
                    continue;
                }
                if (cArray[n] != c2 || --n4 != 0) {
                    continue;
                }
                break;
            }
        } else {
            for (n = --n3; n > -1; --n) {
                if (cArray[n] == c) {
                    ++n4;
                    continue;
                }
                if (cArray[n] != c2 || --n4 != 0) {
                    continue;
                }
                break;
            }
        }
        if (n4 == 0) {
            if (bl) {
                if (bl3) {
                    this.setSelectionStart(--n3);
                    this.setSelectionEnd(++n);
                } else {
                    this.setSelectionStart(n);
                    this.setSelectionEnd(n3 + 2);
                }
            } else {
                this.setCaretPosition(n);
            }
        }
    }

    public void deleteNextActionPerformed() {
        this.nextWord(true);
        this.deleteSelection();
    }

    public void deletePreviousActionPerformed() {
        this.previousWord(true);
        this.deleteSelection();
    }

    private void nextWord(boolean bl) {
        int n = this.getCaretPosition();
        try {
            n = Utilities.getNextWord(this, n);
            if (bl) {
                this.moveCaretPosition(n);
            } else {
                this.setCaretPosition(n);
            }
        }
        catch (BadLocationException badLocationException) {
            try {
                int n2 = Utilities.getParagraphElement(this, n).getEndOffset();
                if (bl) {
                    this.moveCaretPosition(n2);
                } else {
                    this.setCaretPosition(n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void previousWord(boolean bl) {
        try {
            int n = this.getCaretPosition();
            n = Utilities.getPreviousWord(this, n);
            if (bl) {
                this.moveCaretPosition(n);
            } else {
                this.setCaretPosition(n);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void homeActionPerformed() {
        this.homeActionPerformed(false);
    }

    public void homeSelectActionPerformed() {
        this.homeActionPerformed(true);
    }

    private int getFirstTextPositionForLine(int n) {
        try {
            int n2 = Utilities.getRowStart(this, n);
            int n3 = Utilities.getRowEnd(this, n);
            char[] cArray = this.getDocument().getText(n2, n3 - n2).toCharArray();
            int n4 = 0;
            for (char c : cArray) {
                if (c == ' ') {
                    ++n4;
                } else if (c == '\t') {
                    int n5 = (n4 += SCEditorProperties.getIndentSize()) / SCEditorProperties.getIndentSize();
                    n4 = n5 * SCEditorProperties.getIndentSize();
                }
                if (Character.isWhitespace(c)) continue;
                return n4 + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private void homeActionPerformed(boolean bl) {
        Point point = this.getCaretLineAndColumn();
        int n = point.x;
        int n2 = point.y;
        int n3 = this.getFirstTextPositionForLine(this.getCaret().getDot());
        int n4 = n <= n3 && n > 1 ? this.getOffset(n2, 0) : this.getOffset(n2, n3);
        if (bl) {
            this.moveCaretPosition(n4);
        } else {
            this.setCaretPosition(n4);
        }
    }

    public void lineCutActionPerformed() {
        this.doBeginLineAction();
        this.doSelectionEndLineAction();
        this.doSelectionForwardAction();
        this.cut();
    }

    public void lineDeleteActionPerformed() {
        this.doBeginLineAction();
        this.doSelectionEndLineAction();
        this.doSelectionForwardAction();
        this.deleteSelection();
    }

    public void goToLineActionPerformed() {
        Window window = SwingUtilities.windowForComponent(this);
        GoToDialog goToDialog = window instanceof Frame ? new GoToDialog((Frame)window, this.getCaretLineAndColumn().y) : new GoToDialog((Dialog)window, this.getCaretLineAndColumn().y);
        goToDialog.setVisible(true);
        goToDialog.dispose();
        int n = goToDialog.getValue();
        if (n == -1) {
            return;
        }
        this.goTo(n);
    }

    public void toUpperCaseActionPerformed() {
        if (this.getSelectedText() == null) {
            return;
        }
        String string = this.getSelectedText().toUpperCase();
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = n2 - n;
        try {
            this.getDocument().remove(n, n3);
            this.getDocument().insertString(n, string, null);
            this.setSelectionStart(n);
            this.setSelectionEnd(n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void toLowerCaseActionPerformed() {
        if (this.getSelectedText() == null) {
            return;
        }
        String string = this.getSelectedText().toLowerCase();
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = n2 - n;
        try {
            this.getDocument().remove(n, n3);
            this.getDocument().insertString(n, string, null);
            this.setSelectionStart(n);
            this.setSelectionEnd(n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void dumpUnicode() {
        int n = this.getDocument().getLength();
        char[] cArray = new char[n];
        try {
            String string = this.getDocument().getText(0, n);
            string.getChars(0, n, cArray, 0);
        }
        catch (Exception exception) {
            return;
        }
        for (char c : cArray) {
            StringBuffer stringBuffer = new StringBuffer(32);
            if (Character.isDefined(c)) {
                stringBuffer.append("Defined ");
            }
            if (Character.isDigit(c)) {
                stringBuffer.append("Digit ");
            }
            if (Character.isIdentifierIgnorable(c)) {
                stringBuffer.append("IdentifierIgnorable ");
            }
            if (Character.isISOControl(c)) {
                stringBuffer.append("ISOControl ");
            }
            if (Character.isLetter(c)) {
                stringBuffer.append("Letter ");
            }
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append("LetterOrDigit ");
            }
            if (Character.isMirrored(c)) {
                stringBuffer.append("Mirrored ");
            }
            if (Character.isSpaceChar(c)) {
                stringBuffer.append("SpaceChar ");
            }
            if (Character.isWhitespace(c)) {
                stringBuffer.append("Whitespace ");
            }
            if (Character.isJavaIdentifierStart(c)) {
                stringBuffer.append("JavaIdentifierStart ");
            }
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append("JavaIdentifierPart ");
            }
            if (Character.isUnicodeIdentifierStart(c)) {
                stringBuffer.append("UnicodeIdentifierStart ");
            }
            if (Character.isUnicodeIdentifierPart(c)) {
                stringBuffer.append("UnicodeIdentifierPart ");
            }
            switch (Character.getType(c)) {
                case 8: {
                    stringBuffer.append("COMBINING_SPACING_MARK ");
                    break;
                }
                case 23: {
                    stringBuffer.append("CONNECTOR_PUNCTUATION ");
                    break;
                }
                case 15: {
                    stringBuffer.append("CONTROL ");
                    break;
                }
                case 26: {
                    stringBuffer.append("CURRENCY_SYMBOL ");
                    break;
                }
                case 20: {
                    stringBuffer.append("DASH_PUNCTUATION ");
                    break;
                }
                case 9: {
                    stringBuffer.append("DECIMAL_DIGIT_NUMBER ");
                    break;
                }
                case 7: {
                    stringBuffer.append("ENCLOSING_MARK ");
                    break;
                }
                case 22: {
                    stringBuffer.append("END_PUNCTUATION ");
                    break;
                }
                case 30: {
                    stringBuffer.append("FINAL_QUOTE_PUNCTUATION ");
                    break;
                }
                case 16: {
                    stringBuffer.append("FORMAT ");
                    break;
                }
                case 29: {
                    stringBuffer.append("INITIAL_QUOTE_PUNCTUATION ");
                    break;
                }
                case 10: {
                    stringBuffer.append("LETTER_NUMBER ");
                    break;
                }
                case 13: {
                    stringBuffer.append("LINE_SEPARATOR ");
                    break;
                }
                case 2: {
                    stringBuffer.append("LOWERCASE_LETTER ");
                    break;
                }
                case 25: {
                    stringBuffer.append("MATH_SYMBOL ");
                    break;
                }
                case 4: {
                    stringBuffer.append("MODIFIER_LETTER ");
                    break;
                }
                case 27: {
                    stringBuffer.append("MODIFIER_SYMBOL ");
                    break;
                }
                case 6: {
                    stringBuffer.append("NON_SPACING_MARK ");
                    break;
                }
                case 5: {
                    stringBuffer.append("OTHER_LETTER ");
                    break;
                }
                case 11: {
                    stringBuffer.append("OTHER_NUMBER ");
                    break;
                }
                case 24: {
                    stringBuffer.append("OTHER_PUNCTUATION ");
                    break;
                }
                case 28: {
                    stringBuffer.append("OTHER_SYMBOL ");
                    break;
                }
                case 14: {
                    stringBuffer.append("PARAGRAPH_SEPARATOR ");
                    break;
                }
                case 18: {
                    stringBuffer.append("PRIVATE_USE ");
                    break;
                }
                case 12: {
                    stringBuffer.append("SPACE_SEPARATOR ");
                    break;
                }
                case 21: {
                    stringBuffer.append("START_PUNCTUATION ");
                    break;
                }
                case 19: {
                    stringBuffer.append("SURROGATE ");
                    break;
                }
                case 3: {
                    stringBuffer.append("TITLECASE_LETTER ");
                    break;
                }
                case 0: {
                    stringBuffer.append("UNASSIGNED ");
                    break;
                }
                case 1: {
                    stringBuffer.append("UPPERCASE_LETTER ");
                    break;
                }
                default: {
                    stringBuffer.append("UNKNOWN? ");
                }
            }
            System.out.println(c + " - " + Integer.toHexString(c) + " - " + stringBuffer);
        }
    }

    public void deleteSelection() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd() - n;
        try {
            this.getDocument().remove(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doBeginLineAction() {
        this.getBeginLineAction().actionPerformed(null);
    }

    private void doSelectionEndLineAction() {
        this.getSelectEndLineAction().actionPerformed(null);
    }

    private void doSelectionForwardAction() {
        if (this._selectionForwardAction == null) {
            Action[] actionArray;
            for (Action action : actionArray = this.getEditorKit().getActions()) {
                if (!action.getValue("Name").equals("selection-forward")) continue;
                this._selectionForwardAction = action;
                break;
            }
        }
        this._selectionForwardAction.actionPerformed(null);
    }

    @Override
    public void setPopupMenuEnabled(boolean bl) {
        this._popupMenuEnabled = bl;
    }

    @Override
    public boolean isPopupMenuEnabled() {
        return this._popupMenuEnabled;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
            this._popupMenu.add((JMenuItem)new SybMenuItem(this.getCutAction()));
            this._popupMenu.add((JMenuItem)new SybMenuItem(this.getCopyAction()));
            this._popupMenu.add((JMenuItem)new SybMenuItem(this.getPasteAction()));
            this._popupMenu.addSeparator();
            this._popupMenu.add((JMenuItem)new SybMenuItem(this.getGoToLineAction()));
            if (this._showCustomizeOnPopup) {
                this._popupMenu.addSeparator();
                this._popupMenu.add((JMenuItem)new SybMenuItem(this.getCustomizeAction()));
            }
            if (this._showFindReplaceOnPopup) {
                this._popupMenu.addSeparator();
                this._popupMenu.add((JMenuItem)new SybMenuItem(this.getFindReplaceAction()));
                this._popupMenu.add((JMenuItem)new SybMenuItem(this.getFindNextAction()));
            }
        } else {
            this.getCutAction();
            this.getCopyAction();
        }
        return this._popupMenu;
    }

    @Override
    public boolean find(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        char c;
        int n;
        int n2;
        String string2;
        if (string == null) {
            return false;
        }
        if (bl3) {
            try {
                int n3 = this.getSelectionStart();
                int n4 = this.getSelectionEnd();
                string2 = this.getDocument().getText(n3, n4 - n3);
            }
            catch (BadLocationException badLocationException) {
                string2 = "";
            }
            n2 = 0;
        } else {
            try {
                string2 = this.getDocument().getText(0, this.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
                string2 = "";
            }
            n2 = bl4 ? this.getSelectionEnd() : this.getSelectionStart();
            if (n2 > 0 && bl4) {
                int n5 = string2.length() - 1;
                n = string2.trim().length();
                c = string2.charAt(n5);
                while (n5 >= n && Character.isWhitespace(c)) {
                    c = string2.charAt(--n5);
                }
                if (n2 > n5) {
                    n2 = 0;
                }
            }
        }
        int n6 = -1;
        n = 1;
        while (n != 0) {
            n6 = bl ? (bl4 ? string2.indexOf(string, n2) : string2.substring(0, n2).lastIndexOf(string)) : (bl4 ? string2.toLowerCase().indexOf(string.toLowerCase(), n2) : string2.substring(0, n2).toLowerCase().lastIndexOf(string.toLowerCase()));
            if (n6 > -1 && bl2) {
                char c2;
                c = '\u0001';
                boolean bl5 = true;
                if (n6 != 0 && !Character.isWhitespace(c2 = string2.charAt(n6 - 1)) && Character.isLetter(c2)) {
                    c = '\u0000';
                }
                if (n6 + string.length() < string2.length() && !Character.isWhitespace(c2 = string2.charAt(n6 + string.length())) && Character.isLetter(c2)) {
                    bl5 = false;
                }
                if (c != '\u0000' && bl5) {
                    n = 0;
                    continue;
                }
                n2 = n6 + string.length();
                continue;
            }
            n = 0;
        }
        if (n6 > -1) {
            if (bl3) {
                n6 += this.getSelectionStart();
            }
            this.setCaretPosition(n6);
            this.setSelectionStart(n6);
            this.setSelectionEnd(n6 + string.length());
            try {
                this.scrollRectToVisible(this.modelToView(n6));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(String string, String string2) {
        return this.replace(string, string2, false, false, true);
    }

    @Override
    public boolean replace(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (string == null || string2 == null || string.length() == 0) {
            return false;
        }
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            String string3 = this.getSelectedText();
            boolean bl4 = !bl ? string.equalsIgnoreCase(string3) : string.equals(string3);
            if (bl4 && bl2) {
                try {
                    char c;
                    boolean bl5 = true;
                    boolean bl6 = true;
                    if (n2 > 0 && !Character.isWhitespace(c = this.getDocument().getText(n2 - 1, 1).charAt(0)) && Character.isLetter(c)) {
                        bl5 = false;
                    }
                    if (n < this.getDocument().getLength() && !Character.isWhitespace(c = this.getDocument().getText(n, 1).charAt(0)) && Character.isLetter(c)) {
                        bl6 = false;
                    }
                    if (!bl5 || !bl6) {
                        bl4 = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    bl4 = false;
                }
            }
            if (bl4) {
                this.replaceSelection(string2);
            }
        }
        return this.find(string, bl, bl2, false, bl3);
    }

    @Override
    public boolean replaceAll(String string, String string2) {
        return this.replaceAll(string, string2, false, false, false);
    }

    @Override
    public boolean replaceAll(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        String string3;
        int n;
        int n2;
        if (string == null || string2 == null || string.isEmpty()) {
            return false;
        }
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        if (bl3) {
            n2 = this.getSelectionStart();
            n = this.getSelectionEnd();
        } else {
            n2 = 0;
            n = abstractDocument.getLength();
        }
        if (n2 == n) {
            return false;
        }
        try {
            string3 = abstractDocument.getText(n2, n - n2);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        String string4 = bl2 ? "\\b" + Pattern.quote(string) + "\\b" : Pattern.quote(string);
        Pattern pattern = Pattern.compile(string4, bl ? 0 : 2);
        Matcher matcher = pattern.matcher(string3);
        String string5 = matcher.replaceAll(Matcher.quoteReplacement(string2));
        try {
            abstractDocument.replace(n2, n - n2, string5, null);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (bl3) {
            this.setSelectionStart(n2);
            this.setSelectionEnd(n2 + string5.length());
        }
        return true;
    }

    @Override
    public void goTo(int n) {
        this.goTo(n, 0);
    }

    @Override
    public void goTo(int n, int n2) {
        this.getCaret().setVisible(true);
        int n3 = this.getOffset(n, n2);
        this.setCaretPosition(n3);
        try {
            this.scrollRectToVisible(this.modelToView(n3));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getOffset(int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        try {
            char[] cArray = this.getDocument().getText(0, this.getDocument().getLength()).toCharArray();
            if (n < 1) {
                n = 1;
            }
            if (n > 1) {
                for (n4 = 0; n4 < cArray.length && (cArray[n4] != '\n' || ++n3 != n); ++n4) {
                }
                ++n4;
            }
            int n5 = 1;
            for (int i = 0; i < n2 && n4 < cArray.length; ++i) {
                if (cArray[n4] == ' ') {
                    ++n4;
                    ++n5;
                    continue;
                }
                if (cArray[n4] != '\t') continue;
                ++n4;
                int n6 = n5 + SCEditorProperties.getIndentSize();
                int n7 = n6 / SCEditorProperties.getIndentSize();
                n6 = n7 * SCEditorProperties.getIndentSize();
                n2 = n2 - (n6 - n5) + 1;
                n5 = n6;
            }
            if (n4 > cArray.length) {
                n4 = cArray.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n4;
    }

    private JDialog loadDialog(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Frame.class};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object[] objectArray = new Object[]{this.getParentFrame()};
            return (JDialog)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
            return null;
        }
    }

    public Point getCaretLineAndColumn() {
        return this.getCaretLineAndColumn(this.getCaret().getDot());
    }

    public Point getCaretLineAndColumn(int n) {
        int n2 = 1;
        int n3 = 1;
        try {
            if (this._fontIsChanged) {
                this._fontIsMonoSpaced = true;
                this._fontHeight = this.getGraphics().getFontMetrics().getHeight();
                this._fontWidth = this.getGraphics().getFontMetrics().charWidth('W');
                if (this._fontWidth != this.getGraphics().getFontMetrics().charWidth('i')) {
                    this._fontIsMonoSpaced = false;
                }
                this._fontIsChanged = false;
            }
            Rectangle rectangle = this.modelToView(n);
            n2 = this._fontIsMonoSpaced ? rectangle.x / this._fontWidth + 1 : -1;
            n3 = rectangle.y / this._fontHeight + 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Point(n2, n3);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._fontIsChanged = true;
    }

    @Override
    public void addAction(Action action, KeyStroke keyStroke) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon == null) {
            action.putValue("SmallIcon", SCEditorImageLoader.getImage("blank", 1001));
        }
        this.getPopupMenu().addSeparator();
        JMenuItem jMenuItem = new JMenuItem(action);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.addMouseListener(this);
        this.getPopupMenu().add(jMenuItem);
    }

    private JDialog getFindReplaceDialog() {
        if (this._findReplaceDialog == null) {
            if (this._parent != null) {
                if (this._parent._parent._findReplaceDialog == null) {
                    this._parent._parent._findReplaceDialog = this.loadDialog("com.sybase.central.editor.FindReplaceDialog");
                }
                this._findReplaceDialog = this._parent._parent._findReplaceDialog;
            } else {
                this._findReplaceDialog = this.loadDialog("com.sybase.central.editor.FindReplaceDialog");
            }
        }
        return this._findReplaceDialog;
    }

    public boolean isFindReplaceDialogVisible() {
        return this._findReplaceDialog != null && this._findReplaceDialog.isVisible();
    }

    @Override
    public Action getCutAction() {
        if (this._cutAction == null) {
            this._cutAction = new ReflectiveAction(this, "cutActionPerformed", ResourceManager.getI18NMessage("Cut"), SCEditorImageLoader.getImageIcon("cut", 1004));
        }
        try {
            if (this.getSelectionStart() != this.getSelectionEnd()) {
                this._cutAction.setEnabled(true);
            } else {
                this._cutAction.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._cutAction;
    }

    @Override
    public Action getCopyAction() {
        if (this._copyAction == null) {
            this._copyAction = new ReflectiveAction(this, "copyActionPerformed", ResourceManager.getI18NMessage("Copy"), SCEditorImageLoader.getImageIcon("copy", 1004));
        }
        try {
            if (this.getSelectionStart() != this.getSelectionEnd()) {
                this._copyAction.setEnabled(true);
            } else {
                this._copyAction.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._copyAction;
    }

    @Override
    public Action getPasteAction() {
        if (this._pasteAction == null) {
            this._pasteAction = new ReflectiveAction(this, "pasteActionPerformed", ResourceManager.getI18NMessage("Paste"), SCEditorImageLoader.getImageIcon("paste", 1004));
        }
        return this._pasteAction;
    }

    @Override
    public Action getCustomizeAction() {
        if (this._customizeAction == null) {
            this._customizeAction = new ReflectiveAction(this, "customizeActionPerformed", Platform.isMacOS() ? ResourceManager.getI18NMessage("Customize..._Mac") : ResourceManager.getI18NMessage("Customize..."), SCEditorImageLoader.getImageIcon("blank", 1004));
        }
        return this._customizeAction;
    }

    @Override
    public Action getFindReplaceAction() {
        if (this._findReplaceAction == null) {
            this._findReplaceAction = new ReflectiveAction(this, "findReplaceActionPerformed", ResourceManager.getI18NMessage("Find/Replace..."), SCEditorImageLoader.getImageIcon("findintext", 1004));
        }
        return this._findReplaceAction;
    }

    @Override
    public Action getFindNextAction() {
        if (this._findNextAction == null) {
            this._findNextAction = new ReflectiveAction(this, "findNextActionPerformed", ResourceManager.getI18NMessage("Find Next"), SCEditorImageLoader.getImageIcon("blank", 1004));
        }
        return this._findNextAction;
    }

    @Override
    public Action getFindNextSelectedAction() {
        return this._findNextSelectedAction;
    }

    @Override
    public Action getFindPreviousAction() {
        return this._findPreviousAction;
    }

    @Override
    public Action getFindPreviousSelectedAction() {
        return this._findPreviousSelectedAction;
    }

    @Override
    public Action getFindMatchingBraceAction() {
        return this._findMatchingBraceAction;
    }

    @Override
    public Action getSelectToMatchingBraceAction() {
        return this._selectToMatchingBraceAction;
    }

    @Override
    public Action getDeleteNextWordAction() {
        return this._deleteNextWordAction;
    }

    @Override
    public Action getDeletePreviousWordAction() {
        return this._deletePreviousWordAction;
    }

    @Override
    public Action getBeginLineAction() {
        if (this._beginLineAction == null) {
            Action[] actionArray;
            for (Action action : actionArray = this.getEditorKit().getActions()) {
                if (!action.getValue("Name").equals("caret-begin-line")) continue;
                this._beginLineAction = action;
                break;
            }
        }
        return this._beginLineAction;
    }

    @Override
    public Action getEndLineAction() {
        if (this._endLineAction == null) {
            Action[] actionArray;
            for (Action action : actionArray = this.getEditorKit().getActions()) {
                if (!action.getValue("Name").equals("caret-end-line")) continue;
                this._endLineAction = action;
                break;
            }
        }
        return this._endLineAction;
    }

    @Override
    public Action getSelectBeginLineAction() {
        if (this._selectionBeginLineAction == null) {
            Action[] actionArray;
            for (Action action : actionArray = this.getEditorKit().getActions()) {
                if (!action.getValue("Name").equals("selection-begin-line")) continue;
                this._selectionBeginLineAction = action;
                break;
            }
        }
        return this._selectionBeginLineAction;
    }

    @Override
    public Action getHomeAction() {
        return this._homeAction;
    }

    @Override
    public Action getHomeSelectAction() {
        return this._homeSelectAction;
    }

    @Override
    public Action getLineCutAction() {
        return this._lineCutAction;
    }

    @Override
    public Action getLineDeleteAction() {
        return this._lineDeleteAction;
    }

    @Override
    public Action getSelectEndLineAction() {
        if (this._selectionEndLineAction == null) {
            Action[] actionArray;
            for (Action action : actionArray = this.getEditorKit().getActions()) {
                if (!action.getValue("Name").equals("selection-end-line")) continue;
                this._selectionEndLineAction = action;
                break;
            }
        }
        return this._selectionEndLineAction;
    }

    @Override
    public Action getGoToLineAction() {
        return this._goToLineAction;
    }

    @Override
    public Action getToUpperCaseAction() {
        return this._toUpperCaseAction;
    }

    @Override
    public Action getToLowerCaseAction() {
        return this._toLowerCaseAction;
    }

    private static boolean hasEnoughMemory(int n) {
        boolean bl = SCEditor.hasEnoughMemory0(n, false);
        if (!bl) {
            bl = SCEditor.hasEnoughMemory0(n, true);
        }
        return bl;
    }

    private static boolean hasEnoughMemory0(int n, boolean bl) {
        boolean bl2;
        Runtime runtime = Runtime.getRuntime();
        if (bl) {
            System.gc();
        }
        long l = runtime.maxMemory();
        long l2 = runtime.totalMemory();
        long l3 = n * _memoryPerChar;
        long l4 = runtime.freeMemory() + (l - l2) - 0x1400000L;
        if (l3 > l4) {
            if (bl) {
                // empty if block
            }
            bl2 = false;
        } else {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void setDocument(Document document) {
        if (document instanceof AbstractDocument) {
            if (this._filter == null) {
                this._filter = new MemoryLimitingDocumentFilter();
            }
            ((AbstractDocument)document).setDocumentFilter(this._filter);
        }
        super.setDocument(document);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this._lineWrap || super.getScrollableTracksViewportWidth();
    }

    @Override
    public boolean getLineWrap() {
        return this._lineWrap;
    }

    @Override
    public void setLineWrap(boolean bl) {
        this._lineWrap = bl;
        this.setEditorStyles();
    }

    @Override
    public void setWrapStyleWord(boolean bl) {
        this._wrapStyleWord = bl;
        this.setEditorStyles();
    }

    @Override
    public boolean getWrapStyleWord() {
        return this._wrapStyleWord;
    }

    static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String string) {
        this._fileName = string;
    }

    @Override
    public void toggleBreakPoint() {
        Point point = this.getCaretLineAndColumn();
        this.toggleBreakPoint(point.y);
    }

    @Override
    public void toggleBreakPoint(int n) {
        try {
            Object e = this._breakPointListModel.get(n - 1);
            if (e instanceof BreakPoint) {
                BreakPoint breakPoint = (BreakPoint)e;
                if (breakPoint.getState() == 0) {
                    breakPoint.setState(1);
                } else if (breakPoint.getState() == 1) {
                    breakPoint.setState(2);
                } else if (breakPoint.getState() == 2) {
                    breakPoint.setState(0);
                }
                this.fireBreakPointEvent(n, breakPoint);
                if (this._breakPointList.isDisplayable()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public synchronized void run() {
                            SCEditor.this._breakPointList.updateUI();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setBreakPoint(int n, int n2) {
        this.setBreakPoint(n, n2, false);
    }

    void setBreakPoint(int n, int n2, boolean bl) {
        try {
            Object e = this._breakPointListModel.get(n - 1);
            if (e instanceof BreakPoint) {
                BreakPoint breakPoint = (BreakPoint)e;
                breakPoint.setState(n2);
                if (!bl) {
                    this.fireBreakPointEvent(n, breakPoint);
                    if (this._breakPointList.isDisplayable()) {
                        this._breakPointList.updateUI();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentLine(int n) {
        if (n == this._currentLine) {
            return;
        }
        try {
            BreakPoint breakPoint;
            Object e;
            if (n > -1 && (e = this._breakPointListModel.get(n - 1)) instanceof BreakPoint) {
                breakPoint = (BreakPoint)e;
                breakPoint.setCurrentStatement(true);
            }
            if (this._currentLine > -1 && (e = this._breakPointListModel.get(this._currentLine - 1)) instanceof BreakPoint) {
                breakPoint = (BreakPoint)e;
                breakPoint.setCurrentStatement(false);
            }
            this._currentLine = n;
            if (this._breakPointList.isDisplayable()) {
                this._breakPointList.updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getCurrentLine() {
        return this._currentLine;
    }

    @Override
    public void addBreakPointListener(BreakPointListener breakPointListener) {
        this._breakPointListenerList.add(BreakPointListener.class, breakPointListener);
    }

    @Override
    public void removeBreakPointListener(BreakPointListener breakPointListener) {
        this._breakPointListenerList.remove(BreakPointListener.class, breakPointListener);
    }

    @Override
    public void setBreakPointClient(BreakPointClient breakPointClient) {
        this._breakPointClient = breakPointClient;
    }

    @Override
    public BreakPointClient getBreakPointClient() {
        return this._breakPointClient;
    }

    void fireBreakPointEvent(int n, BreakPoint breakPoint) {
        Object[] objectArray = this._breakPointListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != BreakPointListener.class || objectArray[i + 1] == null) continue;
            ((BreakPointListener)objectArray[i + 1]).breakPointChanged(new BreakPointEvent(this, n, breakPoint));
        }
    }

    @Override
    public void setBreakPoints(BreakPointLocation[] breakPointLocationArray) {
        for (BreakPointLocation breakPointLocation : breakPointLocationArray) {
            this.setBreakPoint(breakPointLocation.line, breakPointLocation.state, true);
        }
    }

    @Override
    public BreakPointLocation[] getBreakPoints() {
        int n;
        ArrayList<BreakPointLocation> arrayList = new ArrayList<BreakPointLocation>();
        try {
            int n2 = this._breakPointListModel.size();
            for (n = 0; n < n2; ++n) {
                BreakPoint breakPoint = (BreakPoint)this._breakPointListModel.get(n);
                int n3 = breakPoint.getState();
                if (n3 == 2) continue;
                arrayList.add(new BreakPointLocation(n + 1, n3));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = arrayList.size();
        BreakPointLocation[] breakPointLocationArray = new BreakPointLocation[n];
        for (int i = 0; i < n; ++i) {
            breakPointLocationArray[i] = (BreakPointLocation)arrayList.get(i);
        }
        return breakPointLocationArray;
    }

    @Override
    public void setToolTipClient(ToolTipClient toolTipClient) {
        this._toolTipClient = toolTipClient;
    }

    @Override
    public ToolTipClient getToolTipClient() {
        return this._toolTipClient;
    }

    @Override
    public void setMatchDottedPairsForToolTips(boolean bl) {
        this._matchDottedPairsForToolTips = bl;
    }

    @Override
    public boolean getMatchDottedPairsForToolTips() {
        return this._matchDottedPairsForToolTips;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._toolTipClient != null) {
            int n = this.viewToModel(mouseEvent.getPoint());
            try {
                String string;
                int n2 = Utilities.getWordStart(this, n);
                int n3 = Utilities.getWordEnd(this, n);
                if (this._matchDottedPairsForToolTips) {
                    while (n2 > 1 && this.getText(n2 - 1, 1).equals(".")) {
                        n2 = Utilities.getWordStart(this, n2 - 2);
                    }
                    int n4 = this.getDocument().getLength() - 2;
                    while (n3 < n4 && this.getText(n3, 1).equals(".")) {
                        n3 = Utilities.getWordEnd(this, n3 + 2);
                    }
                }
                if ((string = this.getText(n2, n3 - n2).trim()).length() == 0) {
                    return null;
                }
                return this._toolTipClient.getToolTipForString(string);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    public CustomizationPage[] getCustomizationPages() {
        return new CustomizationPage[]{new EditorCustomizationPage(), new TabsCustomizationPage(), new FormatCustomizationPage(), new PrintCustomizationPage()};
    }

    public Icon getCustomizationGroupIcon() {
        return EDITOR_ICON;
    }

    public String getCustomizationGroupTitle() {
        return ResourceManager.getI18NMessage("customizationGroupTitle");
    }

    public void acceptChanges() {
        SCEditorProperties.store();
        int n = _customizerList.size();
        for (int i = 0; i < n; ++i) {
            SCEditor sCEditor = (SCEditor)_customizerList.get(i);
            sCEditor.setCursor(WAIT_CURSOR);
            sCEditor.setEditorStyles();
            sCEditor.setCursor(TEXT_CURSOR);
        }
    }

    public void rejectChanges() {
        SCEditorProperties.reset();
    }

    public CustomizerHost getCustomizerHost() {
        return this._customizerHost;
    }

    public void setCustomizerHost(CustomizerHost customizerHost) {
        this._customizerHost = customizerHost;
    }

    public CustomizeDialog getCustomizeDialog(Window window) {
        if (this.getCustomizerHost() != null) {
            return this.getCustomizerHost().getCustomizeDialog(window);
        }
        if (this._customizeDialog == null) {
            this._customizeDialog = window instanceof Dialog ? new CustomizeDialog((Dialog)window) : new CustomizeDialog((Frame)window);
            this._customizeDialog.addCustomizationPages((Customizable)this);
        }
        return this._customizeDialog;
    }

    public static void setHelpFolder(String string, String string2, String string3) {
        _helpFolder = string;
        _helpFile = string2;
        _helpVersion = string3;
    }

    @Override
    public void addAsynchronousTaskListener(AsynchronousTaskListener asynchronousTaskListener) {
        this._asynchronousTaskListenerList.add(AsynchronousTaskListener.class, asynchronousTaskListener);
    }

    @Override
    public void removeAsynchronousTaskListener(AsynchronousTaskListener asynchronousTaskListener) {
        this._asynchronousTaskListenerList.remove(AsynchronousTaskListener.class, asynchronousTaskListener);
    }

    void fireAsynchronousTaskEvent(Throwable throwable) {
        Object[] objectArray = this._asynchronousTaskListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AsynchronousTaskListener.class || objectArray[i + 1] == null) continue;
            ((AsynchronousTaskListener)objectArray[i + 1]).loadFailed(throwable, this);
        }
    }

    Parser getParser() {
        return this._parserClass;
    }

    @Override
    public void indentText(boolean bl) {
        int n;
        Position position = null;
        Position position2 = null;
        String string = null;
        this.startUndoableSequence();
        int n2 = this.getSelectionStart();
        int n3 = this.getCaretLineAndColumn((int)n2).y;
        int n4 = this.getSelectionEnd();
        int n5 = this.getCaretLineAndColumn((int)n4).y;
        try {
            position = this.getDocument().createPosition(n2);
            position2 = this.getDocument().createPosition(n4);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        boolean bl2 = this.getKeepTabs();
        int n6 = this.getIndentSize();
        if (!bl2) {
            StringBuilder stringBuilder = new StringBuilder(n6);
            for (n = 0; n < n6; ++n) {
                stringBuilder.append(' ');
            }
            string = stringBuilder.toString();
        }
        boolean bl3 = !bl;
        for (n = n3; n <= n5; ++n) {
            this.goTo(n);
            int n7 = this.getCaretPosition();
            if (bl) {
                if (bl2) {
                    this.insert("\t", n7);
                    continue;
                }
                this.insert(string, n7);
                continue;
            }
            String string2 = bl2 ? "\t" : string;
            try {
                String string3 = this.getText(n7, string2.length());
                if (!string3.equals(string2)) continue;
                this.getDocument().remove(n7, string2.length());
                bl3 = false;
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (bl3) {
            Toolkit.getDefaultToolkit().beep();
        }
        this.setSelectionStart(position.getOffset());
        this.setSelectionEnd(position2.getOffset());
        this.endUndoableSequence();
    }

    @Override
    public void addRemoveComment(String string) {
        Position position = null;
        Position position2 = null;
        this.startUndoableSequence();
        int n = this.getSelectionStart();
        int n2 = this.getCaretLineAndColumn((int)n).y;
        int n3 = this.getSelectionEnd();
        int n4 = this.getCaretLineAndColumn((int)n3).y;
        try {
            String string2;
            int n5;
            position = this.getDocument().createPosition(n);
            position2 = this.getDocument().createPosition(n3);
            boolean bl = false;
            for (n5 = n2; n5 <= n4; ++n5) {
                this.goTo(n5);
                n = this.getCaretPosition();
                this.goTo(n5 + 1);
                n3 = this.getCaretPosition();
                string2 = this.getText(n, n3 - n).trim();
                if (string2.startsWith(string)) continue;
                bl = true;
                break;
            }
            for (n5 = n2; n5 <= n4; ++n5) {
                this.goTo(n5);
                int n6 = this.getCaretPosition();
                if (bl) {
                    this.insert(string, n6);
                    continue;
                }
                n = this.getCaretPosition();
                this.goTo(n5 + 1);
                n3 = this.getCaretPosition();
                string2 = this.getText(n, n3 - n);
                int n7 = string2.indexOf(string);
                this.getDocument().remove(n6 + n7, 2);
            }
            this.setSelectionStart(position.getOffset());
            this.setSelectionEnd(position2.getOffset());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.endUndoableSequence();
    }

    static {
        WAIT_CURSOR = new Cursor(3);
        TEXT_CURSOR = new Cursor(2);
        BREAK_POINT_ICON = SCEditorImageLoader.getImageIcon("breakpoint16", 1006);
        DISABLED_BREAK_POINT_ICON = SCEditorImageLoader.getImageIcon("disabledbreakpoint16", 1006);
        NO_BREAK_POINT_ICON = SCEditorImageLoader.getImageIcon("blank", 1001);
        BREAK_POINT_CURRENT_STATEMENT_ICON = SCEditorImageLoader.getImageIcon("breakpointcurrentstatement16", 1006);
        DISABLED_BREAK_POINT_CURRENT_STATEMENT_ICON = SCEditorImageLoader.getImageIcon("disabledbreakpointcurrentstatement16", 1006);
        NO_BREAK_POINT_CURRENT_STATEMENT_ICON = SCEditorImageLoader.getImageIcon("currentstatement16", 1006);
        EDITOR_ICON = SCEditorImageLoader.getImageIcon("editor16", 1006);
        _customizerList = new ArrayList();
    }

    static class GoToDialog
    extends SybModalDialog
    implements WindowListener,
    ActionListener {
        IntegerTextField _goTo = new IntegerTextField();
        JButton _okButton = new JButton();
        JButton _cancelButton = new JButton();
        int _value = -1;

        GoToDialog(Frame frame, int n) {
            super(frame);
            this.init(frame, n);
        }

        GoToDialog(Dialog dialog, int n) {
            super(dialog);
            this.init(dialog, n);
        }

        private void init(Window window, int n) {
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GoToDialog.this.windowClosing(null);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            InputMap inputMap = this._cancelButton.getInputMap(2);
            ActionMap actionMap = this._cancelButton.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(keyStroke, "cancel");
                actionMap.put("cancel", abstractAction);
            }
            this.setTitle(ResourceManager.getI18NMessage("Go To"));
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            container.add(jLabel);
            container.add(this._goTo);
            GridLayout gridLayout = new GridLayout();
            jPanel.setLayout(gridLayout);
            gridLayout.setHgap(5);
            gridLayout.setVgap(5);
            gridLayout.setRows(1);
            gridLayout.setColumns(2);
            container.add(jPanel);
            jPanel.add(this._okButton);
            jPanel.add(this._cancelButton);
            this.addWindowListener(this);
            jLabel.setText(ResourceManager.getI18NMessage("Go to line:"));
            this._goTo.setValue(n);
            this._goTo.selectAll();
            this._okButton.addActionListener(this);
            this._okButton.setText(ResourceManager.getI18NMessage("OK"));
            this._cancelButton.addActionListener(this);
            this._cancelButton.setText(ResourceManager.getI18NMessage("Cancel"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this._goTo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(window);
            this.getRootPane().setDefaultButton(this._okButton);
            this._goTo.requestFocusInWindow();
        }

        public void dispose() {
            this.removeWindowListener(this);
            this._okButton.removeActionListener(this);
            this._cancelButton.removeActionListener(this);
            super.dispose();
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.setVisible(false);
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._okButton) {
                this._value = this._goTo.getValue();
                this.windowClosing(null);
            } else if (object == this._cancelButton) {
                this.windowClosing(null);
            }
        }

        int getValue() {
            return this._value;
        }
    }

    static class EndWordAction
    extends TextAction {
        private boolean _select;

        EndWordAction(String string, boolean bl) {
            super(string);
            this._select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordEnd(jTextComponent, n);
                    if (this._select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        private boolean _select;

        BeginWordAction(String string, boolean bl) {
            super(string);
            this._select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordStart(jTextComponent, n);
                    if (this._select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class SelectWordAction
    extends TextAction {
        private Action start = new BeginWordAction("pigdog", false);
        private Action end = new EndWordAction("pigdog", true);

        SelectWordAction() {
            super("select-word");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class PreviousWordAction
    extends TextAction {
        private boolean _select;

        PreviousWordAction(String string, boolean bl) {
            super(string);
            this._select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    n = Utilities.getPreviousWord(jTextComponent, n);
                    if (this._select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    static class NextWordAction
    extends TextAction {
        private boolean _select;

        NextWordAction(String string, boolean bl) {
            super(string);
            this._select = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (this._select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    class GiveNoticeToAsynchronousTaskListener
    implements Runnable {
        Throwable _throwable;

        GiveNoticeToAsynchronousTaskListener(Throwable throwable) {
            this._throwable = throwable;
        }

        @Override
        public void run() {
            SCEditor.this.fireAsynchronousTaskEvent(this._throwable);
        }
    }

    private class FileLoader
    extends Thread {
        Reader _in;
        int _caretPositon;
        BoundedRangeModel _boundedRangeModel;
        int _pos;
        boolean _newDocument;

        FileLoader(Reader reader, int n, BoundedRangeModel boundedRangeModel, int n2, boolean bl) {
            this.setName("SCEditor.FileLoader");
            this.setPriority(4);
            this._in = reader;
            this._boundedRangeModel = boundedRangeModel;
            this._caretPositon = n;
            this._pos = n2;
            this._newDocument = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = true;
                boolean bl5 = SCEditor.this.isEditable();
                StringBuffer stringBuffer = new StringBuffer(4096);
                int n = 0;
                int n2 = 0;
                boolean bl6 = false;
                if (this._in == null) {
                    return;
                }
                SCEditor.this.setCursor(WAIT_CURSOR);
                Document document = SCEditor.this.getDocument();
                if (this._newDocument || document == null) {
                    document = SCEditor.this._kit.createDefaultDocument();
                    bl6 = true;
                    if (SCEditor.this._debuggingEditor) {
                        SCEditor.this._breakPointListModel.clear();
                    }
                }
                if (SCEditor.this._debuggingEditor && this._pos > 0) {
                    try {
                        n = SCEditor.this.countLinesInBlock(document.getText(0, this._pos));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                try {
                    int n3;
                    if (SCEditor.this._parent != null) {
                        SCEditor.this._parent._parent._statusText.setVisible(false);
                        SCEditor.this._parent._parent._progressBar.setVisible(true);
                    }
                    if (this._boundedRangeModel != null) {
                        this._boundedRangeModel.setValue(0);
                    }
                    SCEditor.this.setEditable(false);
                    char[] cArray = new char[4096];
                    boolean bl7 = bl4 = document.getLength() == 0;
                    while ((n3 = this._in.read(cArray, 0, cArray.length)) != -1) {
                        if (SCEditor.this._killLoader) {
                            return;
                        }
                        int n4 = 0;
                        block41: for (int i = 0; i < n3; ++i) {
                            switch (cArray[i]) {
                                case '\r': {
                                    if (bl) {
                                        bl3 = true;
                                        if (i == 0) {
                                            stringBuffer.append("\n");
                                        } else {
                                            cArray[i - 1] = 10;
                                        }
                                        if (!SCEditor.this._debuggingEditor) continue block41;
                                        SCEditor.this._breakPointListModel.insertElementAt(new BreakPoint(), n++);
                                        continue block41;
                                    }
                                    bl = true;
                                    continue block41;
                                }
                                case '\n': {
                                    if (!bl) continue block41;
                                    if (i > n4 + 1) {
                                        stringBuffer.append(cArray, n4, i - n4 - 1);
                                    }
                                    bl = false;
                                    n4 = i;
                                    bl2 = true;
                                    if (!SCEditor.this._debuggingEditor) continue block41;
                                    SCEditor.this._breakPointListModel.insertElementAt(new BreakPoint(), n++);
                                    continue block41;
                                }
                                default: {
                                    if (!bl) continue block41;
                                    bl3 = true;
                                    if (i == 0) {
                                        stringBuffer.append("\n");
                                    } else {
                                        cArray[i - 1] = 10;
                                    }
                                    if (SCEditor.this._debuggingEditor) {
                                        SCEditor.this._breakPointListModel.insertElementAt(new BreakPoint(), n++);
                                    }
                                    bl = false;
                                }
                            }
                        }
                        if (n4 < n3) {
                            if (bl) {
                                if (n4 < n3 - 1) {
                                    stringBuffer.append(cArray, n4, n3 - n4 - 1);
                                }
                            } else {
                                stringBuffer.append(cArray, n4, n3 - n4);
                            }
                        }
                        if (this._boundedRangeModel == null) continue;
                        if ((n2 += n3) == this._boundedRangeModel.getMaximum()) {
                            --n2;
                        }
                        this._boundedRangeModel.setValue(n2);
                    }
                }
                catch (IOException iOException) {
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    stringBuffer = new StringBuffer();
                    System.gc();
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                try {
                    if (document != null) {
                        if (bl) {
                            stringBuffer.append("\n");
                            bl3 = true;
                        }
                        if (this._newDocument) {
                            if (SCEditor.this.getDocument() instanceof SCDocument) {
                                ((SCDocument)SCEditor.this.getDocument()).destroy();
                            }
                            SCEditor.this.setDocument(document);
                        }
                        if (bl4) {
                            if (bl2) {
                                document.putProperty("__EndOfLine__", "\r\n");
                            } else if (bl3) {
                                document.putProperty("__EndOfLine__", "\r");
                            } else {
                                document.putProperty("__EndOfLine__", "\n");
                            }
                        }
                        if (SCEditor.this._debuggingEditor) {
                            SCEditor.this._breakPointListModel.insertElementAt(new BreakPoint(), n);
                        }
                        try {
                            document.insertString(this._pos, stringBuffer.toString(), null);
                        }
                        catch (BadLocationException badLocationException) {
                            SCEditor.this.setSelectionStart(this._pos);
                            SCEditor.this.setSelectionEnd(this._pos);
                            SCEditor.this.replaceSelection(stringBuffer.toString(), true);
                        }
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (document instanceof SCDocument) {
                        ((SCDocument)document).destroy();
                    }
                    document = null;
                    System.gc();
                    SCEditor.this.setDocument(SCEditor.this._kit.createDefaultDocument());
                    System.gc();
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                try {
                    if (SCEditor.this._parent != null) {
                        SCEditor.this._parent._parent._statusText.setVisible(true);
                        SCEditor.this._parent._parent._progressBar.setVisible(false);
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                if (bl6) {
                    try {
                        SCEditor.this.getDocument().addUndoableEditListener(SCEditor.this);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                    }
                    try {
                        SCEditor.this.getDocument().addDocumentListener(SCEditor.this);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                    }
                }
                try {
                    SCEditor.this._undo.discardAllEdits();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                try {
                    if (SCEditor.this._parent != null) {
                        SCEditor.this._parent.updateUndoRedoState();
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                try {
                    SCEditor.this.setEditable(bl5);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                try {
                    SCEditor.this.setCursor(TEXT_CURSOR);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                try {
                    SCEditor.this.setCaretPosition(this._caretPositon);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                }
                if (!SCEditor.this._debuggingEditor) return;
                try {
                    SCEditor.this._breakPointContextBuffer.replace(0, SCEditor.this._breakPointContextBuffer.length(), document.getText(0, document.getLength()));
                    return;
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    SwingUtilities.invokeLater(new GiveNoticeToAsynchronousTaskListener(outOfMemoryError));
                    return;
                }
            }
            catch (Throwable throwable) {
                ExceptionHandler.handleException((Throwable)throwable);
                return;
            }
            finally {
                if (this._boundedRangeModel != null) {
                    this._boundedRangeModel.setValue(this._boundedRangeModel.getMaximum());
                }
            }
        }
    }

    class MemoryLimitingDocumentFilter
    extends DocumentFilter
    implements Runnable {
        MemoryLimitingDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (SCEditor.hasEnoughMemory(string.length())) {
                super.insertString(filterBypass, n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || SCEditor.hasEnoughMemory(string.length() - n2)) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            SCEditor.this.fireAsynchronousTaskEvent(null);
        }
    }

    static class PrinterJobListenerShim
    implements PrintJobListener {
        private PrinterJobListener _listener;

        PrinterJobListenerShim(PrinterJobListener printerJobListener) {
            this._listener = printerJobListener;
        }

        public void printingStarted() {
            this._listener.printingStarted();
        }

        public void printingStopped() {
            this._listener.printingStopped();
        }

        public void printingPage(int n) {
            this._listener.printingPage(n);
        }

        public void printerException(PrinterException printerException) {
        }
    }
}

