/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.ColorChoiceComboBox;
import com.sybase.central.editor.IntegerComboBoxEditor;
import com.sybase.central.editor.IntegerTextField;
import com.sybase.central.editor.ReflectiveAction;
import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.SCEditorProperties;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SCEditorCustomizer
extends JPanel
implements Customizer {
    protected JTabbedPane category = new JTabbedPane();
    protected CustomizeEditorPanel editorPanel = null;
    protected CustomizeTabsPanel tabsPanel = null;
    protected CustomizeFormatPanel formatPanel = null;
    protected CustomizePrintPanel printPanel = null;
    protected PropertyChangeSupport _listeners = new PropertyChangeSupport(this);
    protected SCEditor _bean;
    private final Insets _insets3333 = new Insets(3, 3, 3, 3);
    private final Insets _insets0505 = new Insets(0, 5, 0, 5);
    private final Insets _insets2525 = new Insets(2, 5, 2, 5);
    private final Insets _insets5555 = new Insets(5, 5, 5, 5);

    void destroy() {
        this.editorPanel.destroy();
        this.tabsPanel.destroy();
        this.formatPanel.destroy();
        this.printPanel.destroy();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listeners.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listeners.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void setObject(Object object) {
        this._bean = (SCEditor)object;
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        this.add((Component)this.category, "Center");
        this.category.setTabPlacement(1);
        if (this.editorPanel == null) {
            this.editorPanel = new CustomizeEditorPanel();
        }
        if (this.tabsPanel == null) {
            this.tabsPanel = new CustomizeTabsPanel();
        }
        if (this.formatPanel == null) {
            this.formatPanel = new CustomizeFormatPanel();
        }
        if (this.printPanel == null) {
            this.printPanel = new CustomizePrintPanel();
        }
        this.initialize();
        this.category.addTab(ResourceManager.getI18NMessage("Editor"), this.editorPanel);
        this.category.addTab(ResourceManager.getI18NMessage("Tabs"), this.tabsPanel);
        this.category.addTab(ResourceManager.getI18NMessage("Format"), this.formatPanel);
        this.category.addTab(ResourceManager.getI18NMessage("Print"), this.printPanel);
        this.category.setSelectedIndex(0);
        this.setVisible(true);
    }

    void initialize() {
        this.editorPanel.initialize();
        this.tabsPanel.initialize();
        this.formatPanel.initialize();
        this.printPanel.initialize();
    }

    static class CustomizePrintPanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    DocumentListener {
        protected SybLabel headerLabel = new SybLabel();
        protected JTextField header = new JTextField();
        protected SybButton headerHelperButton = new SybButton();
        protected SybLabel footerLabel = new SybLabel();
        protected JTextField footer = new JTextField();
        protected SybButton footerHelperButton = new SybButton();
        protected SybLabel fontSizeLabel = new SybLabel();
        protected JComboBox printFontSize = new JComboBox();
        protected JPanel filler = new JPanel();
        protected JPopupMenu popupMenu = new JPopupMenu();
        boolean insertIntoHeader = false;

        public CustomizePrintPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.add((Component)this.headerLabel);
            this.add(this.header);
            this.add((Component)this.headerHelperButton);
            this.add((Component)this.footerLabel);
            this.add(this.footer);
            this.add((Component)this.footerHelperButton);
            this.add((Component)this.fontSizeLabel);
            this.add(this.printFontSize);
            this.filler.setLayout(null);
            this.add(this.filler);
            this.headerLabel.setText(ResourceManager.getI18NMessage("PrintHeader"));
            this.headerLabel.setLabelFor((Component)this.header);
            this.header.getDocument().addDocumentListener(this);
            this.headerHelperButton.addActionListener((ActionListener)this);
            this.headerHelperButton.setText(">");
            this.footerLabel.setText(ResourceManager.getI18NMessage("PrintFooter"));
            this.footerLabel.setLabelFor((Component)this.footer);
            this.footer.getDocument().addDocumentListener(this);
            this.footerHelperButton.addActionListener((ActionListener)this);
            this.footerHelperButton.setText(">");
            this.printFontSize.setEditable(true);
            this.printFontSize.setEditor(new IntegerComboBoxEditor());
            this.printFontSize.addItem("8");
            this.printFontSize.addItem("10");
            this.printFontSize.addItem("12");
            this.printFontSize.addItem("14");
            this.printFontSize.addItem("16");
            this.printFontSize.addItem("18");
            this.printFontSize.addItem("20");
            this.printFontSize.addItem("22");
            this.printFontSize.addItem("24");
            this.printFontSize.setSelectedItem(String.valueOf(SCEditorProperties.getPrintFontSize()));
            this.printFontSize.addItemListener(this);
            this.fontSizeLabel.setText(ResourceManager.getI18NMessage("PrintFontSize"));
            this.fontSizeLabel.setLabelFor(this.printFontSize.getEditor().getEditorComponent());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints((Component)this.headerLabel, gridBagConstraints);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(this.header, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints((Component)this.headerHelperButton, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagLayout.setConstraints((Component)this.footerLabel, gridBagConstraints);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(this.footer, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagLayout.setConstraints((Component)this.footerHelperButton, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagLayout.setConstraints((Component)this.fontSizeLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagLayout.setConstraints(this.printFontSize, gridBagConstraints);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.filler, gridBagConstraints);
            this.popupMenu.add(new ReflectiveAction(this, "insertFileNameCode", ResourceManager.getI18NMessage("PrintFilename")));
            this.popupMenu.add(new ReflectiveAction(this, "insertFileTimeCode", ResourceManager.getI18NMessage("PrintFileTime")));
            this.popupMenu.add(new ReflectiveAction(this, "insertFileDateCode", ResourceManager.getI18NMessage("PrintFileDate")));
            this.popupMenu.addSeparator();
            this.popupMenu.add(new ReflectiveAction(this, "insertPageNumberCode", ResourceManager.getI18NMessage("PrintPageNumber")));
            this.popupMenu.add(new ReflectiveAction(this, "insertPageCountCode", ResourceManager.getI18NMessage("PrintPageCount")));
            this.popupMenu.add(new ReflectiveAction(this, "insertCurrentTimeCode", ResourceManager.getI18NMessage("PrintCurrentTime")));
            this.popupMenu.add(new ReflectiveAction(this, "insertCurrentDateCode", ResourceManager.getI18NMessage("PrintCurrentDate")));
            this.popupMenu.addSeparator();
            this.popupMenu.add(new ReflectiveAction(this, "insertLeftAlignCode", ResourceManager.getI18NMessage("PrintLeftAlign")));
            this.popupMenu.add(new ReflectiveAction(this, "insertCenterCode", ResourceManager.getI18NMessage("PrintCenter")));
            this.popupMenu.add(new ReflectiveAction(this, "insertRightAlignCode", ResourceManager.getI18NMessage("PrintRightAlign")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.headerHelperButton) {
                this.insertIntoHeader = true;
                UIUtils.showJPopupMenu((JPopupMenu)this.popupMenu, (JComponent)this.headerHelperButton, (Point)new Point(0, 0));
            } else if (object == this.footerHelperButton) {
                this.insertIntoHeader = false;
                UIUtils.showJPopupMenu((JPopupMenu)this.popupMenu, (JComponent)this.footerHelperButton, (Point)new Point(0, 0));
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.printFontSize) {
                int n = ((IntegerTextField)this.printFontSize.getEditor().getEditorComponent()).getValue();
                if (n < 4) {
                    n = 4;
                } else if (n > 255) {
                    n = 255;
                }
                SCEditorProperties.setPrintFontSize(n);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == this.header.getDocument()) {
                SCEditorProperties.setPrintHeader(this.header.getText());
            } else if (documentEvent.getDocument() == this.footer.getDocument()) {
                SCEditorProperties.setPrintFooter(this.footer.getText());
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void insertFileNameCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&F");
            } else {
                this.footer.setText(this.footer.getText() + "&F");
            }
        }

        public void insertPageNumberCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&P");
            } else {
                this.footer.setText(this.footer.getText() + "&P");
            }
        }

        public void insertPageCountCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&p");
            } else {
                this.footer.setText(this.footer.getText() + "&p");
            }
        }

        public void insertFileTimeCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&t");
            } else {
                this.footer.setText(this.footer.getText() + "&t");
            }
        }

        public void insertFileDateCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&d");
            } else {
                this.footer.setText(this.footer.getText() + "&d");
            }
        }

        public void insertCurrentTimeCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&T");
            } else {
                this.footer.setText(this.footer.getText() + "&T");
            }
        }

        public void insertCurrentDateCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&D");
            } else {
                this.footer.setText(this.footer.getText() + "&D");
            }
        }

        public void insertLeftAlignCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&L");
            } else {
                this.footer.setText(this.footer.getText() + "&L");
            }
        }

        public void insertCenterCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&C");
            } else {
                this.footer.setText(this.footer.getText() + "&C");
            }
        }

        public void insertRightAlignCode() {
            if (this.insertIntoHeader) {
                this.header.setText(this.header.getText() + "&R");
            } else {
                this.footer.setText(this.footer.getText() + "&R");
            }
        }

        void destroy() {
            this.printFontSize.removeItemListener(this);
            this.headerHelperButton.removeActionListener((ActionListener)this);
            this.footerHelperButton.removeActionListener((ActionListener)this);
            this.printFontSize.removeItemListener(this);
            this.header.getDocument().removeDocumentListener(this);
            this.footer.getDocument().removeDocumentListener(this);
        }

        void initialize() {
            this.header.setText(SCEditorProperties.getPrintHeader());
            this.footer.setText(SCEditorProperties.getPrintFooter());
            ((IntegerTextField)this.printFontSize.getEditor().getEditorComponent()).setValue(SCEditorProperties.getPrintFontSize());
        }
    }

    static class NonTraversableTextField
    extends JTextField {
        NonTraversableTextField() {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }

    static class NonTraversableTextArea
    extends JTextArea {
        NonTraversableTextArea() {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }

    class CustomizeTabsPanel
    extends JPanel
    implements FocusListener,
    ItemListener {
        protected ButtonGroup tabPanel_tab;
        protected ButtonGroup autoIndentPanel_autoIndentGroup;
        protected JPanel tabPanel;
        protected SybLabel dummyLabel;
        protected SybLabel tabSizeLabel;
        protected IntegerTextField tabSize;
        protected SybRadioButton insertSpaces;
        protected SybLabel indentSizeLabel;
        protected IntegerTextField indentSize;
        protected SybRadioButton keepTabs;
        protected JPanel autoIndentPanel;
        protected SybRadioButton noAutoIndent;
        protected SybRadioButton defaultAutoIndent;
        protected SybRadioButton smartAutoIndent;
        protected SybCheckBox indentOpenBrace;
        protected SybCheckBox indentClosingBrace;
        protected SybLabel sampleLabel;
        protected NonTraversableTextArea smartIndentSample;

        void destroy() {
            this.tabSize.removeFocusListener(this);
            this.insertSpaces.removeItemListener((ItemListener)this);
            this.indentSize.removeFocusListener(this);
            this.keepTabs.removeItemListener((ItemListener)this);
            this.noAutoIndent.removeItemListener((ItemListener)this);
            this.defaultAutoIndent.removeItemListener((ItemListener)this);
            this.smartAutoIndent.removeItemListener((ItemListener)this);
            this.indentOpenBrace.removeItemListener((ItemListener)this);
            this.indentClosingBrace.removeItemListener((ItemListener)this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == this.tabSize) {
                this.tabSize_focusLost();
            } else if (object == this.indentSize) {
                this.indentSize_focusLost();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.insertSpaces) {
                this.insertSpaces_itemStateChanged();
            } else if (object == this.keepTabs) {
                this.keepTabs_itemStateChanged();
            } else if (object == this.noAutoIndent) {
                this.noAutoIndent_itemStateChanged();
            } else if (object == this.defaultAutoIndent) {
                this.defaultAutoIndent_itemStateChanged();
            } else if (object == this.smartAutoIndent) {
                this.smartAutoIndent_itemStateChanged();
            } else if (object == this.indentOpenBrace) {
                this.indentOpenBrace_itemStateChanged();
            } else if (object == this.indentClosingBrace) {
                this.indentClosingBrace_itemStateChanged();
            }
        }

        public CustomizeTabsPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            this.tabPanel = new JPanel();
            this.tabPanel.setLayout(gridBagLayout2);
            this.add(this.tabPanel);
            this.tabSizeLabel = new SybLabel();
            this.tabPanel.add((Component)this.tabSizeLabel);
            this.indentSizeLabel = new SybLabel();
            this.tabPanel.add((Component)this.indentSizeLabel);
            this.tabSize = new IntegerTextField();
            this.tabPanel.add(this.tabSize);
            this.indentSize = new IntegerTextField();
            this.tabPanel.add(this.indentSize);
            this.insertSpaces = new SybRadioButton();
            this.tabPanel.add((Component)this.insertSpaces);
            this.keepTabs = new SybRadioButton();
            this.tabPanel.add((Component)this.keepTabs);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            this.autoIndentPanel = new JPanel();
            this.autoIndentPanel.setLayout(gridBagLayout3);
            this.add(this.autoIndentPanel);
            this.noAutoIndent = new SybRadioButton();
            this.autoIndentPanel.add((Component)this.noAutoIndent);
            this.defaultAutoIndent = new SybRadioButton();
            this.autoIndentPanel.add((Component)this.defaultAutoIndent);
            this.smartAutoIndent = new SybRadioButton();
            this.autoIndentPanel.add((Component)this.smartAutoIndent);
            this.indentOpenBrace = new SybCheckBox();
            this.autoIndentPanel.add((Component)this.indentOpenBrace);
            this.indentClosingBrace = new SybCheckBox();
            this.autoIndentPanel.add((Component)this.indentClosingBrace);
            this.sampleLabel = new SybLabel();
            this.autoIndentPanel.add((Component)this.sampleLabel);
            this.smartIndentSample = new NonTraversableTextArea();
            this.autoIndentPanel.add(this.smartIndentSample);
            this.dummyLabel = new SybLabel();
            this.autoIndentPanel.add((Component)this.dummyLabel);
            this.tabPanel.setBorder(BorderFactory.createEtchedBorder());
            this.tabSizeLabel.setText(ResourceManager.getI18NMessage("Tab size:"));
            this.tabSizeLabel.setLabelFor((Component)this.tabSize);
            this.tabSize.addFocusListener(this);
            this.tabSize.setHorizontalAlignment(2);
            this.tabSize.setToolTipText(ResourceManager.getI18NMessage("TabSizeTip"));
            this.insertSpaces.addItemListener((ItemListener)this);
            this.tabPanel_tab = new ButtonGroup();
            this.tabPanel_tab.add((AbstractButton)this.insertSpaces);
            this.insertSpaces.setText(ResourceManager.getI18NMessage("Insert spaces"));
            this.insertSpaces.setToolTipText(ResourceManager.getI18NMessage("InsertSpacesTip"));
            this.indentSizeLabel.setText(ResourceManager.getI18NMessage("Indent size:"));
            this.indentSizeLabel.setLabelFor((Component)this.indentSize);
            this.indentSize.addFocusListener(this);
            this.indentSize.setHorizontalAlignment(2);
            this.indentSize.setToolTipText(ResourceManager.getI18NMessage("IndentSizeTip"));
            this.keepTabs.addItemListener((ItemListener)this);
            this.tabPanel_tab.add((AbstractButton)this.keepTabs);
            this.keepTabs.setText(ResourceManager.getI18NMessage("Keep tabs"));
            this.keepTabs.setToolTipText(ResourceManager.getI18NMessage("KeepTabsTip"));
            this.autoIndentPanel.setBorder(BorderFactory.createTitledBorder(ResourceManager.getI18NMessage("Auto indent")));
            this.noAutoIndent.addItemListener((ItemListener)this);
            this.autoIndentPanel_autoIndentGroup = new ButtonGroup();
            this.autoIndentPanel_autoIndentGroup.add((AbstractButton)this.noAutoIndent);
            this.noAutoIndent.setText(ResourceManager.getI18NMessage("None"));
            this.noAutoIndent.setToolTipText(ResourceManager.getI18NMessage("NoneTip"));
            this.defaultAutoIndent.addItemListener((ItemListener)this);
            this.autoIndentPanel_autoIndentGroup.add((AbstractButton)this.defaultAutoIndent);
            this.defaultAutoIndent.setText(ResourceManager.getI18NMessage("Default"));
            this.defaultAutoIndent.setToolTipText(ResourceManager.getI18NMessage("DefaultTip"));
            this.smartAutoIndent.addItemListener((ItemListener)this);
            this.autoIndentPanel_autoIndentGroup.add((AbstractButton)this.smartAutoIndent);
            this.smartAutoIndent.setText(ResourceManager.getI18NMessage("Smart"));
            this.smartAutoIndent.setToolTipText(ResourceManager.getI18NMessage("SmartTip"));
            this.indentOpenBrace.addItemListener((ItemListener)this);
            this.indentOpenBrace.setText(ResourceManager.getI18NMessage("Indent open brace"));
            this.indentOpenBrace.setToolTipText(ResourceManager.getI18NMessage("IndentOpenBraceTip"));
            this.indentClosingBrace.addItemListener((ItemListener)this);
            this.indentClosingBrace.setText(ResourceManager.getI18NMessage("Indent closing brace"));
            this.indentClosingBrace.setToolTipText(ResourceManager.getI18NMessage("IndentClosingBraceTip"));
            this.sampleLabel.setText(ResourceManager.getI18NMessage("TabSample"));
            this.sampleLabel.setLabelFor((Component)this.smartIndentSample);
            this.smartIndentSample.setMargin(SCEditorCustomizer.this._insets5555);
            this.smartIndentSample.setBorder(BorderFactory.createBevelBorder(1));
            this.smartIndentSample.setFont(new Font("Monospaced", 0, 12));
            this.updateSmartIndentSample();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.tabPanel, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = SCEditorCustomizer.this._insets0505;
            gridBagLayout2.setConstraints((Component)this.tabSizeLabel, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.ipadx = 100;
            gridBagConstraints2.weightx = 1.0;
            gridBagLayout2.setConstraints(this.tabSize, gridBagConstraints2);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagLayout2.setConstraints((Component)this.insertSpaces, gridBagConstraints2);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.insets = SCEditorCustomizer.this._insets0505;
            gridBagLayout2.setConstraints((Component)this.indentSizeLabel, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.ipadx = 100;
            gridBagLayout2.setConstraints(this.indentSize, gridBagConstraints2);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagLayout2.setConstraints((Component)this.keepTabs, gridBagConstraints2);
            gridBagConstraints.anchor = 16;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.autoIndentPanel, gridBagConstraints);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
            gridBagLayout3.setConstraints((Component)this.noAutoIndent, gridBagConstraints3);
            gridBagConstraints3.gridy = 1;
            gridBagLayout3.setConstraints((Component)this.defaultAutoIndent, gridBagConstraints3);
            gridBagConstraints3.gridy = 2;
            gridBagLayout3.setConstraints((Component)this.smartAutoIndent, gridBagConstraints3);
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.insets = new Insets(5, 25, 0, 0);
            gridBagLayout3.setConstraints((Component)this.indentOpenBrace, gridBagConstraints3);
            gridBagConstraints3.gridy = 4;
            gridBagLayout3.setConstraints((Component)this.indentClosingBrace, gridBagConstraints3);
            gridBagConstraints3.gridy = 5;
            gridBagLayout3.setConstraints((Component)this.sampleLabel, gridBagConstraints3);
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 6;
            gridBagConstraints3.gridheight = 8;
            gridBagConstraints3.insets = new Insets(0, 25, 5, 5);
            gridBagLayout3.setConstraints(this.smartIndentSample, gridBagConstraints3);
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagLayout3.setConstraints((Component)this.dummyLabel, gridBagConstraints3);
        }

        void initialize() {
            this.tabSize.setText(String.valueOf(SCEditorProperties.getTabSize()));
            this.insertSpaces.setSelected(!SCEditorProperties.getKeepTabs());
            this.indentSize.setText(String.valueOf(SCEditorProperties.getIndentSize()));
            this.keepTabs.setSelected(SCEditorProperties.getKeepTabs());
            this.noAutoIndent.setSelected(SCEditorProperties.getAutoIndent() == 0);
            this.defaultAutoIndent.setSelected(SCEditorProperties.getAutoIndent() == 1);
            this.smartAutoIndent.setSelected(SCEditorProperties.getAutoIndent() == 3);
            this.indentOpenBrace.setSelected(SCEditorProperties.getSmartIndentOpenBrace());
            this.indentClosingBrace.setSelected(SCEditorProperties.getSmartIndentClosingBrace());
        }

        private void tabSize_focusLost() {
            if (this.tabSize.getValue() != SCEditorProperties.getTabSize()) {
                SCEditorProperties.setTabSize(this.tabSize.getValue());
            }
        }

        private void insertSpaces_itemStateChanged() {
            SCEditorProperties.setKeepTabs(!this.insertSpaces.isSelected());
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("insertSpaces", this.insertSpaces.isSelected(), !this.insertSpaces.isSelected());
            }
        }

        private void indentSize_focusLost() {
            if (this.indentSize.getValue() != SCEditorProperties.getIndentSize()) {
                SCEditorProperties.setIndentSize(this.indentSize.getValue());
            }
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("indentSize", 0, this.indentSize.getValue());
            }
        }

        private void keepTabs_itemStateChanged() {
            SCEditorProperties.setKeepTabs(this.keepTabs.isSelected());
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("keepTabs", !this.keepTabs.isSelected(), this.keepTabs.isSelected());
            }
        }

        private void noAutoIndent_itemStateChanged() {
            if (this.noAutoIndent.isSelected()) {
                SCEditorProperties.setAutoIndent(0);
                this.indentOpenBrace.setEnabled(false);
                this.indentClosingBrace.setEnabled(false);
                this.sampleLabel.setEnabled(false);
                this.smartIndentSample.setEnabled(false);
                if (SCEditorCustomizer.this._bean != null) {
                    SCEditorCustomizer.this._listeners.firePropertyChange("noAutoIndent", !this.noAutoIndent.isSelected(), this.noAutoIndent.isSelected());
                }
            }
        }

        private void defaultAutoIndent_itemStateChanged() {
            if (this.defaultAutoIndent.isSelected()) {
                SCEditorProperties.setAutoIndent(1);
                this.indentOpenBrace.setEnabled(false);
                this.indentClosingBrace.setEnabled(false);
                this.sampleLabel.setEnabled(false);
                this.smartIndentSample.setEnabled(false);
                if (SCEditorCustomizer.this._bean != null) {
                    SCEditorCustomizer.this._listeners.firePropertyChange("defaultAutoIndent", !this.defaultAutoIndent.isSelected(), this.defaultAutoIndent.isSelected());
                }
            }
        }

        private void smartAutoIndent_itemStateChanged() {
            if (this.smartAutoIndent.isSelected()) {
                SCEditorProperties.setAutoIndent(3);
                this.indentOpenBrace.setEnabled(true);
                this.indentClosingBrace.setEnabled(true);
                this.sampleLabel.setEnabled(true);
                this.smartIndentSample.setEnabled(true);
                if (SCEditorCustomizer.this._bean != null) {
                    SCEditorCustomizer.this._listeners.firePropertyChange("smartAutoIndent", !this.smartAutoIndent.isSelected(), this.smartAutoIndent.isSelected());
                }
            }
        }

        private void indentOpenBrace_itemStateChanged() {
            this.updateSmartIndentSample();
            SCEditorProperties.setSmartIndentOpenBrace(this.indentOpenBrace.isSelected());
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("indentOpenBrace", !this.indentOpenBrace.isSelected(), this.indentOpenBrace.isSelected());
            }
        }

        private void indentClosingBrace_itemStateChanged() {
            this.updateSmartIndentSample();
            SCEditorProperties.setSmartIndentClosingBrace(this.indentClosingBrace.isSelected());
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("indentClosingBrace", !this.indentClosingBrace.isSelected(), this.indentClosingBrace.isSelected());
            }
        }

        private void updateSmartIndentSample() {
            StringBuffer stringBuffer = new StringBuffer(" if( a == b )\n");
            boolean bl = this.indentOpenBrace.isSelected();
            boolean bl2 = this.indentClosingBrace.isSelected();
            if (bl) {
                stringBuffer.append("     {\n");
            } else {
                stringBuffer.append(" {\n");
            }
            stringBuffer.append("     c = 0;\n");
            if (bl2) {
                stringBuffer.append("     }\n");
            } else {
                stringBuffer.append(" }\n");
            }
            stringBuffer.append(" else\n");
            if (bl) {
                stringBuffer.append("     {\n");
            } else {
                stringBuffer.append(" {\n");
            }
            stringBuffer.append("     c = 1;\n");
            if (bl2) {
                stringBuffer.append("     }");
            } else {
                stringBuffer.append(" }");
            }
            this.smartIndentSample.setText(stringBuffer.toString());
        }
    }

    class CustomizeFormatPanel
    extends JPanel
    implements ItemListener,
    ListSelectionListener,
    ActionListener,
    DocumentListener {
        protected JPanel textHighlightingPanel;
        protected JPanel textHighlightingControlPanel;
        protected JScrollPane categoryScrollpane;
        protected JList category;
        protected SybLabel textForegroundLabel;
        protected SybLabel textBackgroundLabel;
        protected SybLabel textStyleLabel;
        protected ColorChoiceComboBox textForeground;
        protected ColorChoiceComboBox textBackground;
        protected JComboBox textStyle;
        protected JPanel generalPanel;
        protected SybLabel fontSizeLablel;
        protected SybLabel caretColorLabel;
        protected JComboBox fontSize;
        protected ColorChoiceComboBox caretColor;
        protected JScrollPane sampleScrollpane;
        protected JPanel samplePanel;
        protected JTextArea sampleText;
        protected SybButton resetAllButton;
        private String _keywords;
        private String _textSelection;
        private String _text;
        private String _comment;
        private String _formalComment;
        private String _number;
        private String _string;
        private String _openString;
        private String _operators;
        private String _punctuation;
        private String _breakPointMargin;
        private String _htmlElementName;
        private String _htmlAttributeName;
        private String _htmlAttributeValue;
        private String _htmlComment;
        private String _htmlTagDelimiter;
        private String _htmlOperator;
        private String _plain;
        private String _italic;
        private String _bold;
        private String _boldItalic;

        void destroy() {
            this.resetAllButton.removeActionListener((ActionListener)this);
            this.category.removeListSelectionListener(this);
            this.textForeground.removeItemListener(this);
            this.textBackground.removeItemListener(this);
            this.textStyle.removeItemListener(this);
            this.fontSize.removeItemListener(this);
            ((IntegerTextField)this.fontSize.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this);
            this.caretColor.removeItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.textForeground) {
                this.textForeground_itemStateChanged();
            } else if (object == this.textBackground) {
                this.textBackground_itemStateChanged();
            } else if (object == this.textStyle) {
                this.textStyle_itemStateChanged();
            } else if (object == this.fontSize) {
                this.fontSize_itemStateChanged();
            } else if (object == this.caretColor) {
                this.caretColor_itemStateChanged();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.fontChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.fontChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.fontChanged();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object = listSelectionEvent.getSource();
            if (object == this.category) {
                this.category_valueChanged();
            }
        }

        CustomizeFormatPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            this.textHighlightingPanel = new JPanel();
            this.textHighlightingPanel.setLayout(gridBagLayout2);
            this.textHighlightingControlPanel = new JPanel();
            this.textHighlightingControlPanel.setLayout(gridBagLayout3);
            this.add(this.textHighlightingPanel);
            this.textHighlightingPanel.add(this.textHighlightingControlPanel);
            this.categoryScrollpane = new JScrollPane();
            this.textHighlightingPanel.add(this.categoryScrollpane);
            this.category = new JList();
            this.categoryScrollpane.getViewport().add(this.category);
            this.resetAllButton = new SybButton();
            this.add((Component)this.resetAllButton);
            this.resetAllButton.setText(ResourceManager.getI18NMessage("Reset All"));
            this.resetAllButton.setToolTipText(ResourceManager.getI18NMessage("ResetAllTip"));
            this.resetAllButton.addActionListener((ActionListener)this);
            this.textForegroundLabel = new SybLabel();
            this.textHighlightingControlPanel.add((Component)this.textForegroundLabel);
            this.textBackgroundLabel = new SybLabel();
            this.textHighlightingControlPanel.add((Component)this.textBackgroundLabel);
            this.textStyleLabel = new SybLabel();
            this.textHighlightingControlPanel.add((Component)this.textStyleLabel);
            this.textForeground = new ColorChoiceComboBox();
            this.textHighlightingControlPanel.add(this.textForeground);
            this.textBackground = new ColorChoiceComboBox();
            this.textHighlightingControlPanel.add(this.textBackground);
            this.textStyle = new JComboBox();
            this.textHighlightingControlPanel.add(this.textStyle);
            this.textHighlightingPanel.add(this.textHighlightingControlPanel);
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            this.generalPanel = new JPanel();
            this.generalPanel.setLayout(gridBagLayout4);
            this.add(this.generalPanel);
            this.fontSizeLablel = new SybLabel();
            this.generalPanel.add((Component)this.fontSizeLablel);
            this.caretColorLabel = new SybLabel();
            this.generalPanel.add((Component)this.caretColorLabel);
            this.fontSize = new JComboBox();
            this.fontSize.setEditable(true);
            this.fontSize.setEditor(new IntegerComboBoxEditor());
            ((IntegerTextField)this.fontSize.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            this.generalPanel.add(this.fontSize);
            this.caretColor = new ColorChoiceComboBox();
            this.generalPanel.add(this.caretColor);
            GridBagLayout gridBagLayout5 = new GridBagLayout();
            this.samplePanel = new JPanel();
            this.samplePanel.setLayout(gridBagLayout5);
            this.add(this.samplePanel);
            this.sampleText = new JTextArea();
            this.sampleScrollpane = new JScrollPane();
            this.samplePanel.add(this.sampleScrollpane);
            this.sampleScrollpane.setViewportView(this.sampleText);
            if (Platform.isMacOS()) {
                this.sampleScrollpane.setVerticalScrollBarPolicy(22);
                this.sampleScrollpane.setHorizontalScrollBarPolicy(32);
            } else {
                this.sampleScrollpane.setVerticalScrollBarPolicy(20);
                this.sampleScrollpane.setHorizontalScrollBarPolicy(30);
            }
            this.textHighlightingPanel.setBorder(BorderFactory.createTitledBorder(ResourceManager.getI18NMessage("Text Highlighting")));
            if (Platform.isMacOS()) {
                this.categoryScrollpane.setVerticalScrollBarPolicy(22);
                this.categoryScrollpane.setHorizontalScrollBarPolicy(32);
            } else {
                this.categoryScrollpane.setVerticalScrollBarPolicy(20);
                this.categoryScrollpane.setHorizontalScrollBarPolicy(30);
            }
            this.category.addListSelectionListener(this);
            this._textSelection = ResourceManager.getI18NMessage("Text Selection");
            this._text = ResourceManager.getI18NMessage("Text");
            this._keywords = ResourceManager.getI18NMessage("Keywords");
            this._comment = ResourceManager.getI18NMessage("Comment");
            this._formalComment = ResourceManager.getI18NMessage("Formal comment");
            this._number = ResourceManager.getI18NMessage("Number");
            this._string = ResourceManager.getI18NMessage("String");
            this._openString = ResourceManager.getI18NMessage("Open String");
            this._operators = ResourceManager.getI18NMessage("Operators");
            this._punctuation = ResourceManager.getI18NMessage("Punctuation");
            this._breakPointMargin = ResourceManager.getI18NMessage("Break Point Margin");
            this._htmlElementName = ResourceManager.getI18NMessage("HTML Element Name");
            this._htmlAttributeName = ResourceManager.getI18NMessage("HTML Attribute Name");
            this._htmlAttributeValue = ResourceManager.getI18NMessage("HTML Attribute Value");
            this._htmlComment = ResourceManager.getI18NMessage("HTML Comment");
            this._htmlTagDelimiter = ResourceManager.getI18NMessage("HTML Tag Delimiter");
            this._htmlOperator = ResourceManager.getI18NMessage("HTML Operator");
            String[] stringArray = new String[]{this._textSelection, this._text, this._keywords, this._comment, this._formalComment, this._number, this._string, this._openString, this._operators, this._punctuation, this._breakPointMargin, this._htmlElementName, this._htmlAttributeName, this._htmlAttributeValue, this._htmlComment, this._htmlTagDelimiter, this._htmlOperator};
            this.category.setListData(stringArray);
            this.category.setSelectionMode(0);
            this.textForegroundLabel.setText(ResourceManager.getI18NMessage("Foreground"));
            this.textForegroundLabel.setLabelFor((Component)this.textForeground);
            this.textBackgroundLabel.setText(ResourceManager.getI18NMessage("Background"));
            this.textBackgroundLabel.setLabelFor((Component)this.textBackground);
            this.textStyleLabel.setText(ResourceManager.getI18NMessage("Style"));
            this.textStyleLabel.setLabelFor((Component)this.textStyle);
            this.textForeground.addItemListener(this);
            this.textBackground.addItemListener(this);
            this.textStyle.addItemListener(this);
            this._plain = ResourceManager.getI18NMessage("Plain");
            this._italic = ResourceManager.getI18NMessage("Italic");
            this._bold = ResourceManager.getI18NMessage("Bold");
            this._boldItalic = ResourceManager.getI18NMessage("Italic+Bold");
            this.textStyle.addItem(this._plain);
            this.textStyle.addItem(this._italic);
            this.textStyle.addItem(this._bold);
            this.textStyle.addItem(this._boldItalic);
            this.fontSizeLablel.setText(ResourceManager.getI18NMessage("Font size"));
            this.fontSizeLablel.setLabelFor(this.fontSize.getEditor().getEditorComponent());
            this.caretColorLabel.setText(ResourceManager.getI18NMessage("Caret color"));
            this.caretColorLabel.setLabelFor((Component)this.caretColor);
            this.fontSize.addItem("8");
            this.fontSize.addItem("10");
            this.fontSize.addItem("12");
            this.fontSize.addItem("14");
            this.fontSize.addItem("16");
            this.fontSize.addItem("18");
            this.fontSize.addItem("20");
            this.fontSize.addItem("22");
            this.fontSize.addItem("24");
            this.fontSize.setSelectedItem(String.valueOf(SCEditorProperties.getFontSize()));
            this.fontSize.addItemListener(this);
            this.caretColor.addItemListener(this);
            this.samplePanel.setBorder(BorderFactory.createTitledBorder(ResourceManager.getI18NMessage("HighlightSample")));
            this.sampleText.setText(ResourceManager.getI18NMessage("AaBbCcXxYyZz"));
            this.sampleText.setEditable(false);
            this.sampleText.setToolTipText(ResourceManager.getI18NMessage("Sample text"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.generalPanel, gridBagConstraints);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.textHighlightingPanel, gridBagConstraints);
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.samplePanel, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 14;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = SCEditorCustomizer.this._insets5555;
            gridBagLayout.setConstraints((Component)this.resetAllButton, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = SCEditorCustomizer.this._insets5555;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.ipadx = 5;
            gridBagLayout4.setConstraints((Component)this.fontSizeLablel, gridBagConstraints2);
            gridBagConstraints2.gridy = 1;
            gridBagLayout4.setConstraints((Component)this.caretColorLabel, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagLayout4.setConstraints(this.fontSize, gridBagConstraints2);
            gridBagConstraints2.gridy = 1;
            gridBagLayout4.setConstraints(this.caretColor, gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.gridheight = 4;
            gridBagConstraints3.insets = SCEditorCustomizer.this._insets2525;
            gridBagConstraints3.ipadx = 50;
            gridBagConstraints3.ipady = 80;
            gridBagConstraints3.ipady = 120;
            gridBagConstraints3.weighty = 1.0;
            gridBagLayout2.setConstraints(this.categoryScrollpane, gridBagConstraints3);
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 5;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = SCEditorCustomizer.this._insets2525;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.ipadx = 5;
            gridBagLayout3.setConstraints((Component)this.textForegroundLabel, gridBagConstraints4);
            gridBagConstraints4.gridy = 1;
            gridBagLayout3.setConstraints((Component)this.textBackgroundLabel, gridBagConstraints4);
            gridBagConstraints4.gridy = 2;
            gridBagLayout3.setConstraints((Component)this.textStyleLabel, gridBagConstraints4);
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            gridBagLayout3.setConstraints(this.textForeground, gridBagConstraints4);
            gridBagConstraints4.gridy = 1;
            gridBagLayout3.setConstraints(this.textBackground, gridBagConstraints4);
            gridBagConstraints4.gridy = 2;
            gridBagLayout3.setConstraints(this.textStyle, gridBagConstraints4);
            gridBagLayout2.setConstraints(this.textHighlightingControlPanel, gridBagConstraints3);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagLayout5.setConstraints(this.sampleScrollpane, gridBagConstraints5);
        }

        void initialize() {
            ((IntegerTextField)this.fontSize.getEditor().getEditorComponent()).setValue(SCEditorProperties.getFontSize());
            this.caretColor.setColor(SCEditorProperties.getCaretColor(), ResourceManager.getI18NMessage("Caret Color Title"), null);
            this.category.setSelectedIndex(2);
            this.category.setSelectedIndex(0);
            this.category.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }

        private void category_valueChanged() {
            String string = (String)this.category.getSelectedValue();
            int n = 0;
            if (string.equals(this._textSelection)) {
                this.textForeground.setCustomColor(SCEditorProperties.getTextSelectionForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getTextSelectionBackground());
                this.textForeground.setColor(SCEditorProperties.getTextSelectionForeground(), this._textSelection, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getTextSelectionBackground(), this._textSelection, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getTextStyle();
            } else if (string.equals(this._text)) {
                this.textForeground.setCustomColor(SCEditorProperties.getTextForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getTextBackground());
                this.textForeground.setColor(SCEditorProperties.getTextForeground(), this._text, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getTextBackground(), this._text, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getTextStyle();
            } else if (string.equals(this._keywords)) {
                this.textForeground.setCustomColor(SCEditorProperties.getKeywordsForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getKeywordsBackground());
                this.textForeground.setColor(SCEditorProperties.getKeywordsForeground(), this._keywords, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getKeywordsBackground(), this._keywords, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getKeywordsStyle();
            } else if (string.equals(this._comment)) {
                this.textForeground.setCustomColor(SCEditorProperties.getCommentForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getCommentBackground());
                this.textForeground.setColor(SCEditorProperties.getCommentForeground(), this._comment, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getCommentBackground(), this._comment, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getCommentStyle();
            } else if (string.equals(this._formalComment)) {
                this.textForeground.setCustomColor(SCEditorProperties.getFormalCommentForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getFormalCommentBackground());
                this.textForeground.setColor(SCEditorProperties.getFormalCommentForeground(), this._formalComment, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getFormalCommentBackground(), this._formalComment, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getFormalCommentStyle();
            } else if (string.equals(this._number)) {
                this.textForeground.setCustomColor(SCEditorProperties.getNumberForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getNumberBackground());
                this.textForeground.setColor(SCEditorProperties.getNumberForeground(), this._number, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getNumberBackground(), this._number, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getNumberStyle();
            } else if (string.equals(this._string)) {
                this.textForeground.setCustomColor(SCEditorProperties.getStringForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getStringBackground());
                this.textForeground.setColor(SCEditorProperties.getStringForeground(), this._string, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getStringBackground(), this._string, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getStringStyle();
            } else if (string.equals(this._openString)) {
                this.textForeground.setCustomColor(SCEditorProperties.getOpenStringForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getOpenStringBackground());
                this.textForeground.setColor(SCEditorProperties.getOpenStringForeground(), this._openString, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getOpenStringBackground(), this._openString, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getOpenStringStyle();
            } else if (string.equals(this._operators)) {
                this.textForeground.setCustomColor(SCEditorProperties.getOperatorsForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getOperatorsBackground());
                this.textForeground.setColor(SCEditorProperties.getOperatorsForeground(), this._operators, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getOperatorsBackground(), this._operators, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getOperatorsStyle();
            } else if (string.equals(this._punctuation)) {
                this.textForeground.setCustomColor(SCEditorProperties.getPunctuationForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getPunctuationBackground());
                this.textForeground.setColor(SCEditorProperties.getPunctuationForeground(), this._punctuation, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getPunctuationBackground(), this._punctuation, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getPunctuationStyle();
            } else if (string.equals(this._breakPointMargin)) {
                this.textForeground.setCustomColor(SCEditorProperties.getBreakPointMarginForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getBreakPointMarginBackground());
                this.textForeground.setColor(SCEditorProperties.getBreakPointMarginForeground(), this._punctuation, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getBreakPointMarginBackground(), this._punctuation, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getTextStyle();
            } else if (string.equals(this._htmlElementName)) {
                this.textForeground.setCustomColor(SCEditorProperties.getHTMLElementNameForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getHTMLElementNameBackground());
                this.textForeground.setColor(SCEditorProperties.getHTMLElementNameForeground(), this._htmlElementName, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getHTMLElementNameBackground(), this._htmlElementName, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getHTMLElementNameStyle();
            } else if (string.equals(this._htmlAttributeName)) {
                this.textForeground.setCustomColor(SCEditorProperties.getHTMLAttributeNameForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getHTMLAttributeNameBackground());
                this.textForeground.setColor(SCEditorProperties.getHTMLAttributeNameForeground(), this._htmlAttributeName, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getHTMLAttributeNameBackground(), this._htmlAttributeName, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getHTMLAttributeNameStyle();
            } else if (string.equals(this._htmlAttributeValue)) {
                this.textForeground.setCustomColor(SCEditorProperties.getHTMLAttributeValueForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getHTMLAttributeValueBackground());
                this.textForeground.setColor(SCEditorProperties.getHTMLAttributeValueForeground(), this._htmlAttributeValue, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getHTMLAttributeValueBackground(), this._htmlAttributeValue, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getHTMLAttributeValueStyle();
            } else if (string.equals(this._htmlComment)) {
                this.textForeground.setCustomColor(SCEditorProperties.getHTMLCommentForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getHTMLCommentBackground());
                this.textForeground.setColor(SCEditorProperties.getHTMLCommentForeground(), this._htmlComment, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getHTMLCommentBackground(), this._htmlComment, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getHTMLCommentStyle();
            } else if (string.equals(this._htmlTagDelimiter)) {
                this.textForeground.setCustomColor(SCEditorProperties.getHTMLTagDelimiterForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getHTMLTagDelimiterBackground());
                this.textForeground.setColor(SCEditorProperties.getHTMLTagDelimiterForeground(), this._htmlTagDelimiter, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getHTMLTagDelimiterBackground(), this._htmlTagDelimiter, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getHTMLTagDelimiterStyle();
            } else if (string.equals(this._htmlOperator)) {
                this.textForeground.setCustomColor(SCEditorProperties.getHTMLOperatorForeground());
                this.textBackground.setCustomColor(SCEditorProperties.getHTMLOperatorBackground());
                this.textForeground.setColor(SCEditorProperties.getHTMLOperatorForeground(), this._htmlOperator, ResourceManager.getI18NMessage("Foreground Title"));
                this.textBackground.setColor(SCEditorProperties.getHTMLOperatorBackground(), this._htmlOperator, ResourceManager.getI18NMessage("Background Title"));
                n = SCEditorProperties.getHTMLOperatorStyle();
            }
            if (string.equals(this._textSelection) || string.equals(this._breakPointMargin)) {
                this.textStyle.setEnabled(false);
                this.textStyle.setSelectedIndex(-1);
                this.textStyleLabel.setEnabled(false);
            } else {
                this.textStyle.setEnabled(true);
                this.textStyleLabel.setEnabled(true);
                switch (n) {
                    case 0: {
                        this.textStyle.setSelectedItem(this._plain);
                        break;
                    }
                    case 1: {
                        this.textStyle.setSelectedItem(this._bold);
                        break;
                    }
                    case 2: {
                        this.textStyle.setSelectedItem(this._italic);
                        break;
                    }
                    case 3: {
                        this.textStyle.setSelectedItem(this._boldItalic);
                        break;
                    }
                    default: {
                        this.textStyle.setSelectedItem(this._plain);
                    }
                }
            }
        }

        private void textForeground_itemStateChanged() {
            String string = (String)this.category.getSelectedValue();
            if (string.equals(this._textSelection)) {
                SCEditorProperties.setTextSelectionForeground(this.textForeground.getColor());
                this.sampleText.setSelectedTextColor(this.textForeground.getColor());
            } else if (string.equals(this._text)) {
                SCEditorProperties.setTextForeground(this.textForeground.getColor());
            } else if (string.equals(this._keywords)) {
                SCEditorProperties.setKeywordsForeground(this.textForeground.getColor());
            } else if (string.equals(this._comment)) {
                SCEditorProperties.setCommentForeground(this.textForeground.getColor());
            } else if (string.equals(this._formalComment)) {
                SCEditorProperties.setFormalCommentForeground(this.textForeground.getColor());
            } else if (string.equals(this._number)) {
                SCEditorProperties.setNumberForeground(this.textForeground.getColor());
            } else if (string.equals(this._string)) {
                SCEditorProperties.setStringForeground(this.textForeground.getColor());
            } else if (string.equals(this._openString)) {
                SCEditorProperties.setOpenStringForeground(this.textForeground.getColor());
            } else if (string.equals(this._operators)) {
                SCEditorProperties.setOperatorsForeground(this.textForeground.getColor());
            } else if (string.equals(this._punctuation)) {
                SCEditorProperties.setPunctuationForeground(this.textForeground.getColor());
            } else if (string.equals(this._breakPointMargin)) {
                SCEditorProperties.setBreakPointMarginForeground(this.textForeground.getColor());
            } else if (string.equals(this._htmlElementName)) {
                SCEditorProperties.setHTMLElementNameForeground(this.textForeground.getColor());
            } else if (string.equals(this._htmlAttributeName)) {
                SCEditorProperties.setHTMLAttributeNameForeground(this.textForeground.getColor());
            } else if (string.equals(this._htmlAttributeValue)) {
                SCEditorProperties.setHTMLAttributeValueForeground(this.textForeground.getColor());
            } else if (string.equals(this._htmlComment)) {
                SCEditorProperties.setHTMLCommentForeground(this.textForeground.getColor());
            } else if (string.equals(this._htmlTagDelimiter)) {
                SCEditorProperties.setHTMLTagDelimiterForeground(this.textForeground.getColor());
            } else if (string.equals(this._htmlOperator)) {
                SCEditorProperties.setHTMLOperatorForeground(this.textForeground.getColor());
            }
            this.sampleText.setForeground(this.textForeground.getColor());
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("textForeground", null, null);
            }
        }

        private void textBackground_itemStateChanged() {
            String string = (String)this.category.getSelectedValue();
            if (string.equals(this._textSelection)) {
                SCEditorProperties.setTextSelectionBackground(this.textBackground.getColor());
                this.sampleText.setSelectionColor(this.textBackground.getColor());
            } else if (string.equals(this._text)) {
                SCEditorProperties.setTextBackground(this.textBackground.getColor());
            } else if (string.equals(this._keywords)) {
                SCEditorProperties.setKeywordsBackground(this.textBackground.getColor());
            } else if (string.equals(this._comment)) {
                SCEditorProperties.setCommentBackground(this.textBackground.getColor());
            } else if (string.equals(this._formalComment)) {
                SCEditorProperties.setFormalCommentBackground(this.textBackground.getColor());
            } else if (string.equals(this._number)) {
                SCEditorProperties.setNumberBackground(this.textBackground.getColor());
            } else if (string.equals(this._string)) {
                SCEditorProperties.setStringBackground(this.textBackground.getColor());
            } else if (string.equals(this._openString)) {
                SCEditorProperties.setOpenStringBackground(this.textBackground.getColor());
            } else if (string.equals(this._operators)) {
                SCEditorProperties.setOperatorsBackground(this.textBackground.getColor());
            } else if (string.equals(this._punctuation)) {
                SCEditorProperties.setPunctuationBackground(this.textBackground.getColor());
            } else if (string.equals(this._breakPointMargin)) {
                SCEditorProperties.setBreakPointMarginBackground(this.textBackground.getColor());
            } else if (string.equals(this._htmlElementName)) {
                SCEditorProperties.setHTMLElementNameBackground(this.textBackground.getColor());
            } else if (string.equals(this._htmlAttributeName)) {
                SCEditorProperties.setHTMLAttributeNameBackground(this.textBackground.getColor());
            } else if (string.equals(this._htmlAttributeValue)) {
                SCEditorProperties.setHTMLAttributeValueBackground(this.textBackground.getColor());
            } else if (string.equals(this._htmlComment)) {
                SCEditorProperties.setHTMLCommentBackground(this.textBackground.getColor());
            } else if (string.equals(this._htmlTagDelimiter)) {
                SCEditorProperties.setHTMLTagDelimiterBackground(this.textBackground.getColor());
            } else if (string.equals(this._htmlOperator)) {
                SCEditorProperties.setHTMLOperatorBackground(this.textBackground.getColor());
            }
            this.sampleText.setBackground(this.textBackground.getColor());
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("textBackground", null, null);
            }
        }

        private void textStyle_itemStateChanged() {
            String string;
            int n = 0;
            String string2 = (String)this.textStyle.getSelectedItem();
            if (string2 != null) {
                if (string2.equals(this._plain)) {
                    n = 0;
                } else if (string2.equals(this._italic)) {
                    n = 2;
                } else if (string2.equals(this._bold)) {
                    n = 1;
                } else if (string2.equals(this._boldItalic)) {
                    n = 3;
                }
            }
            if ((string = (String)this.category.getSelectedValue()) != null) {
                if (string.equals(this._text)) {
                    SCEditorProperties.setTextStyle(n);
                } else if (string.equals(this._keywords)) {
                    SCEditorProperties.setKeywordsStyle(n);
                } else if (string.equals(this._comment)) {
                    SCEditorProperties.setCommentStyle(n);
                } else if (string.equals(this._formalComment)) {
                    SCEditorProperties.setFormalCommentStyle(n);
                } else if (string.equals(this._number)) {
                    SCEditorProperties.setNumberStyle(n);
                } else if (string.equals(this._string)) {
                    SCEditorProperties.setStringStyle(n);
                } else if (string.equals(this._openString)) {
                    SCEditorProperties.setOpenStringStyle(n);
                } else if (string.equals(this._operators)) {
                    SCEditorProperties.setOperatorsStyle(n);
                } else if (string.equals(this._punctuation)) {
                    SCEditorProperties.setPunctuationStyle(n);
                } else if (string.equals(this._htmlElementName)) {
                    SCEditorProperties.setHTMLElementNameStyle(n);
                } else if (string.equals(this._htmlAttributeName)) {
                    SCEditorProperties.setHTMLAttributeNameStyle(n);
                } else if (string.equals(this._htmlAttributeValue)) {
                    SCEditorProperties.setHTMLAttributeValueStyle(n);
                } else if (string.equals(this._htmlComment)) {
                    SCEditorProperties.setCommentStyle(n);
                } else if (string.equals(this._htmlTagDelimiter)) {
                    SCEditorProperties.setHTMLTagDelimiterStyle(n);
                } else if (string.equals(this._htmlOperator)) {
                    SCEditorProperties.setHTMLOperatorStyle(n);
                }
            }
            this.fontChanged();
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("textStyle", null, null);
            }
        }

        private void fontChanged() {
            int n = ((IntegerTextField)this.fontSize.getEditor().getEditorComponent()).getValue();
            if (n < 1) {
                n = 1;
            } else if (n > 1000) {
                n = 1000;
            }
            int n2 = 0;
            String string = (String)this.textStyle.getSelectedItem();
            if (string == null) {
                n2 = 0;
            } else if (string.equals(this._plain)) {
                n2 = 0;
            } else if (string.equals(this._italic)) {
                n2 = 2;
            } else if (string.equals(this._bold)) {
                n2 = 1;
            } else if (string.equals(this._boldItalic)) {
                n2 = 3;
            }
            if (SCEditor.isWindows()) {
                n = (int)Math.round((double)n * 4.0 / 3.0);
            }
            this.sampleText.setFont(new Font("Monospaced", n2, n));
            this.updateUI();
            if (SCEditorCustomizer.this._bean != null) {
                SCEditorCustomizer.this._listeners.firePropertyChange("font", null, null);
            }
        }

        private void fontSize_itemStateChanged() {
            int n = ((IntegerTextField)this.fontSize.getEditor().getEditorComponent()).getValue();
            if (n < 1) {
                n = 1;
            } else if (n > 1000) {
                n = 1000;
            }
            SCEditorProperties.setFontSize(n);
            this.fontChanged();
        }

        private void caretColor_itemStateChanged() {
            SCEditorProperties.setCaretColor(this.caretColor.getColor());
            this.fontChanged();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.resetAllButton) {
                SCEditorProperties.setFormatValuesToDefault();
                ((IntegerTextField)this.fontSize.getEditor().getEditorComponent()).setValue(SCEditorProperties.getFontSize());
                this.caretColor.setColor(SCEditorProperties.getCaretColor());
                int n = this.category.getSelectedIndex();
                if (n == 0) {
                    this.category.setSelectedIndex(2);
                    this.category.setSelectedIndex(0);
                } else {
                    this.category.setSelectedIndex(0);
                    this.category.setSelectedIndex(n);
                }
            }
        }
    }

    class CustomizeEditorPanel
    extends JPanel
    implements ItemListener {
        protected SybCheckBox verticalScrollBar;
        protected SybCheckBox horizontalScrollBar;
        protected SybCheckBox dragAndDrop;

        void destroy() {
            this.verticalScrollBar.removeItemListener((ItemListener)this);
            this.horizontalScrollBar.removeItemListener((ItemListener)this);
            this.dragAndDrop.removeItemListener((ItemListener)this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.verticalScrollBar) {
                SCEditorProperties.setVerticalScrollBar(this.verticalScrollBar.isSelected());
                if (SCEditorCustomizer.this._bean != null) {
                    SCEditorCustomizer.this._listeners.firePropertyChange("verticalScrollBar", !this.verticalScrollBar.isSelected(), this.verticalScrollBar.isSelected());
                }
            } else if (object == this.horizontalScrollBar) {
                SCEditorProperties.setHorizontalScrollBar(this.horizontalScrollBar.isSelected());
                if (SCEditorCustomizer.this._bean != null) {
                    SCEditorCustomizer.this._listeners.firePropertyChange("horizontalScrollBar", !this.horizontalScrollBar.isSelected(), this.horizontalScrollBar.isSelected());
                }
            } else if (object == this.dragAndDrop) {
                SCEditorProperties.setDragAndDropEditing(this.dragAndDrop.isSelected());
                if (SCEditorCustomizer.this._bean != null) {
                    SCEditorCustomizer.this._listeners.firePropertyChange("dragAndDrop", !this.dragAndDrop.isSelected(), this.dragAndDrop.isSelected());
                }
            }
        }

        CustomizeEditorPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.verticalScrollBar = new SybCheckBox();
            this.add((Component)this.verticalScrollBar);
            this.horizontalScrollBar = new SybCheckBox();
            this.add((Component)this.horizontalScrollBar);
            this.dragAndDrop = new SybCheckBox();
            this.add((Component)this.dragAndDrop);
            this.verticalScrollBar.addItemListener((ItemListener)this);
            this.verticalScrollBar.setText(ResourceManager.getI18NMessage("verticalScrollBar"));
            this.verticalScrollBar.setToolTipText(ResourceManager.getI18NMessage("verticalScrollBarTip"));
            this.horizontalScrollBar.addItemListener((ItemListener)this);
            this.horizontalScrollBar.setText(ResourceManager.getI18NMessage("horizontalScrollBar"));
            this.horizontalScrollBar.setToolTipText(ResourceManager.getI18NMessage("horizontalScrollBarTip"));
            this.dragAndDrop.addItemListener((ItemListener)this);
            this.dragAndDrop.setText(ResourceManager.getI18NMessage("dragAndDrop"));
            this.dragAndDrop.setToolTipText(ResourceManager.getI18NMessage("dragAndDropTip"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = SCEditorCustomizer.this._insets3333;
            gridBagLayout.setConstraints((Component)this.verticalScrollBar, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints((Component)this.horizontalScrollBar, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints((Component)this.dragAndDrop, gridBagConstraints);
        }

        void initialize() {
            this.verticalScrollBar.setSelected(SCEditorProperties.getVerticalScrollBar());
            this.horizontalScrollBar.setSelected(SCEditorProperties.getHorizontalScrollBar());
            this.dragAndDrop.setSelected(SCEditorProperties.getDragAndDropEditing());
        }
    }
}

