/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.central.editor.AboutDialog;
import com.sybase.central.editor.AsynchronousTaskListener;
import com.sybase.central.editor.Editor;
import com.sybase.central.editor.EditorCustomizationPage;
import com.sybase.central.editor.EditorEvent;
import com.sybase.central.editor.EditorFrame;
import com.sybase.central.editor.EditorListener;
import com.sybase.central.editor.FileHolder;
import com.sybase.central.editor.FindInFilesDialog;
import com.sybase.central.editor.FindReplaceDialog;
import com.sybase.central.editor.FormatCustomizationPage;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.PrintCustomizationPage;
import com.sybase.central.editor.ReflectiveAction;
import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCDesktopPane;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.SCEditorImageLoader;
import com.sybase.central.editor.SCEditorProperties;
import com.sybase.central.editor.TabsCustomizationPage;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.customization.CustomizeDialog;
import com.sybase.customization.CustomizerHost;
import com.sybase.util.DialogUtils;
import com.sybase.util.JREUtils;
import com.sybase.util.Platform;
import com.sybase.util.PrintJobListener;
import com.sybase.util.SwingFileFilter;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMenu;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybToolBarButton;
import com.sybase.util.UIUtils;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Robot;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class SCEditorFrame
extends JFrame
implements EditorFrame,
VetoableChangeListener,
PropertyChangeListener,
DropTargetListener,
WindowListener,
ComponentListener,
MouseListener,
PrintJobListener,
Customizable,
AsynchronousTaskListener {
    protected JMenuBar _menuBar;
    protected String _title;
    protected SCDesktopPane _editorPane;
    protected JList _findInFiles1List;
    protected JScrollPane _findInFiles1ScrollPane;
    protected JList _findInFiles2List;
    protected JScrollPane _findInFiles2ScrollPane;
    protected JList _resultsList;
    protected JScrollPane _resultsScrollPane;
    protected JTabbedPane _viewPane;
    protected JSplitPane _splitPane;
    protected JPanel _editorPanel;
    protected JPanel statusPanel;
    protected JPanel infoPanel;
    protected JPanel lineColumnPanel;
    protected JPanel readOnlyPanel;
    protected JLabel _lineLabel;
    protected JLabel _yLabel;
    protected JLabel _columnLabel;
    protected JLabel _xLabel;
    protected JLabel _readOnlyLabel;
    protected JLabel _statusText;
    protected JToolBar _toolBar;
    protected SybMenuItem _undoMenuItem = null;
    protected SybMenuItem _redoMenuItem = null;
    protected JButton _undoButton = null;
    protected JButton _redoButton = null;
    protected JProgressBar _progressBar;
    protected SybLabel _printStatus;
    Timer _printAnimationTimer = null;
    ImageIcon[] _printAnimationArray = new ImageIcon[]{SCEditorImageLoader.getImageIcon("printanimation1_", 1004), SCEditorImageLoader.getImageIcon("printanimation1_", 1004), SCEditorImageLoader.getImageIcon("printanimation2_", 1004)};
    int _printAnimationFrame = 0;
    protected boolean _showNewFileItem = true;
    protected boolean _showOpenFileItem = true;
    protected boolean _showCloseFileItem = true;
    protected boolean _showSaveFileItem = true;
    protected boolean _showSaveAsFileItem = true;
    protected boolean _showPrintFileItem = true;
    protected boolean _showExitFileItem = true;
    private boolean _ignoreSplitPanePropertyChange = false;
    private int _bottomPaneHeight = 0;
    private static int _instanceCount = 0;
    protected String _saveTitle;
    protected char _saveMnemonic;
    protected ImageIcon _saveIcon;
    protected String _saveToolTip;
    protected JButton _saveButton;
    protected JMenuItem _saveMenuItem;
    protected KeyStroke _saveAccelerator;
    protected String _saveShortDescription;
    protected String _saveLongDescription;
    protected String _exitTitle;
    protected char _exitMnemonic;
    protected ImageIcon _exitIcon;
    protected String _exitToolTip;
    protected JButton _exitButton;
    protected JMenuItem _exitMenuItem;
    protected KeyStroke _exitAccelerator;
    protected String _exitShortDescription;
    protected String _exitLongDescription;
    EditorEvent _editorEvent = null;
    String _defaultExtension = null;
    protected EventListenerList _listenerList;
    protected List<FileFilter> _fileFilters;
    protected File _currentDirectory = null;
    protected SybMenu _fileMenu = null;
    protected SybMenu _editMenu = null;
    protected SybMenu _searchMenu = null;
    protected SybMenu _toolsMenu = null;
    protected SybMenu _windowMenu = null;
    protected SybMenu _helpMenu = null;
    protected boolean _showHelpMenu = true;
    protected SybMenu _fileListMenu;
    static final Dimension _minimumSize = new Dimension(450, 180);
    JMenuItem emptyListItem;
    ActionListener _menuListener;
    Object[] _okOptions;
    Object[] _yesNoOptions;
    Object[] _yesNoCancelOptions;
    boolean _sdi = false;
    boolean _standalone = false;
    boolean _formCreationInProgress = false;
    int newFileCounter = 1;
    JDialog _findReplaceDialog = null;
    JDialog _findInFilesDialog = null;
    CustomizeDialog _customizeDialog = null;
    JDialog _defaultAboutDialog = null;
    static final int RECENT_FILES = 4;
    List<String> _recentFiles;
    List<JInternalFrame> _fileList;
    int windowMenuWindowOffset = 9;
    Hashtable<String, FileHolder> _fileTable;
    Hashtable<JInternalFrame, FileHolder> _windowTable;
    DropTarget dropTarget;
    FileHolder _fileHolder = null;
    Action _newAction;
    Action _openAction;
    Action _closeAction;
    Action _saveAction;
    Action _saveFileAsAction;
    Action _saveAllAction;
    Action _printAction;
    Action _exitAction;
    Action _undoAction;
    Action _redoAction;
    Action _cutAction;
    Action _copyAction;
    Action _pasteAction;
    Action _deleteAction;
    Action _selectAllAction;
    Action _goToLineAction;
    Action _indentLeftAction;
    Action _indentRightAction;
    Action _addRemoveDoubleDashCommentAction;
    Action _addRemoveDoubleSlashCommentAction;
    Action _findReplaceAction;
    Action _findNextAction;
    Action _findInFilesAction;
    Action _customizeAction;
    Action _closeWindowAction;
    Action _closeAllWindowsAction;
    Action _nextWindowAction;
    Action _previousWindowAction;
    Action _cascadeWindowsAction;
    Action _tileWindowsHorizontallyAction;
    Action _tileWindowsVerticallyAction;
    Action _windowsAction;
    Action _helpAction;
    Action _aboutAction;
    static ImageIcon EDITOR_ICON = SCEditorImageLoader.getImageIcon("editor16", 1004);
    static ArrayList _customizerList = new ArrayList();

    @Override
    public boolean create() {
        SCEditorProperties.load();
        this.pack();
        this._formCreationInProgress = true;
        String string = System.getProperty("SDI", "MDI");
        if (string.equals("SDI")) {
            this._sdi = true;
        }
        this.setResizable(true);
        Container container = this.getContentPane();
        this.setJMenuBar(this._menuBar);
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        if (this._sdi) {
            this._editorPanel = new JPanel();
            this._editorPanel.setLayout(new BorderLayout());
            container.add((Component)this._editorPanel, "Center");
        } else {
            this._editorPane = new SCDesktopPane();
            this._editorPane.setLayout(null);
            this._viewPane = new JTabbedPane(3){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(0, 0);
                }
            };
            this._splitPane = new JSplitPane(0, true, this._editorPane, this._viewPane);
            container.add((Component)this._splitPane, "Center");
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(gridBagLayout);
        container.add((Component)this.statusPanel, "South");
        FlowLayout flowLayout = new FlowLayout();
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(flowLayout);
        flowLayout.setAlignment(0);
        flowLayout.setHgap(0);
        flowLayout.setVgap(0);
        this._statusText = new JLabel();
        this.statusPanel.add(this._statusText);
        this._progressBar = new JProgressBar();
        this._progressBar.setVisible(false);
        this._printStatus = new SybLabel();
        this._printStatus.setVisible(false);
        this.statusPanel.add(this._progressBar);
        this.statusPanel.add((Component)this._printStatus);
        this.statusPanel.add(this.infoPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this._statusText, gridBagConstraints);
        gridBagLayout.setConstraints(this._progressBar, gridBagConstraints);
        gridBagLayout.setConstraints((Component)this._printStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        gridBagLayout.setConstraints(this.infoPanel, gridBagConstraints);
        FlowLayout flowLayout2 = new FlowLayout();
        this.lineColumnPanel = new JPanel();
        this.lineColumnPanel.setLayout(flowLayout2);
        flowLayout2.setAlignment(0);
        flowLayout2.setHgap(0);
        flowLayout2.setVgap(0);
        this.infoPanel.add(this.lineColumnPanel);
        this._lineLabel = new JLabel();
        this.lineColumnPanel.add(this._lineLabel);
        this._yLabel = new JLabel();
        this.lineColumnPanel.add(this._yLabel);
        this._lineLabel.setLabelFor(this._yLabel);
        this._yLabel.setLabelFor(this._lineLabel);
        this._columnLabel = new JLabel();
        this.lineColumnPanel.add(this._columnLabel);
        this._xLabel = new JLabel();
        this.lineColumnPanel.add(this._xLabel);
        this._columnLabel.setLabelFor(this._xLabel);
        this._xLabel.setLabelFor(this._columnLabel);
        FlowLayout flowLayout3 = new FlowLayout();
        this.readOnlyPanel = new JPanel();
        this.readOnlyPanel.setLayout(flowLayout3);
        flowLayout3.setAlignment(0);
        flowLayout3.setHgap(0);
        flowLayout3.setVgap(0);
        this._readOnlyLabel = new JLabel();
        this.readOnlyPanel.add(this._readOnlyLabel);
        this._readOnlyLabel.setLabelFor(this._readOnlyLabel);
        this.infoPanel.add(this.readOnlyPanel);
        container.add((Component)this._toolBar, "North");
        this.addWindowListener(this);
        this.addComponentListener(this);
        this._menuBar.setOpaque(true);
        if (this._sdi) {
            this._editorPanel.setBackground(SystemColor.desktop);
            this._editorPanel.setForeground(SystemColor.controlText);
        } else {
            this._editorPane.setBackground(SystemColor.desktop);
            this._editorPane.setForeground(SystemColor.controlText);
            this._viewPane.setTabPlacement(3);
            this._viewPane.setFont(new Font("Dialog", 0, 10));
            this._findInFiles1List = new JList();
            this._findInFiles1ScrollPane = new JScrollPane(this._findInFiles1List);
            this._findInFiles2List = new JList();
            this._findInFiles2ScrollPane = new JScrollPane(this._findInFiles2List);
            this._resultsList = new JList();
            this._resultsScrollPane = new JScrollPane(this._resultsList);
            this._viewPane.addTab(ResourceManager.getI18NMessage("Find in Files 1"), null, this._findInFiles1ScrollPane, null);
            this._viewPane.addTab(ResourceManager.getI18NMessage("Find in Files 2"), null, this._findInFiles2ScrollPane, null);
            this._viewPane.addTab(ResourceManager.getI18NMessage("Results"), null, this._resultsScrollPane, null);
            this._findInFiles1List.addMouseListener(this);
            this._findInFiles2List.addMouseListener(this);
            this._resultsList.addMouseListener(this);
            this._splitPane.setDividerLocation(SCEditorProperties.getDividerLocation());
            this._splitPane.addPropertyChangeListener(this);
        }
        this.lineColumnPanel.setBorder(BorderFactory.createBevelBorder(1));
        this._lineLabel.setText(ResourceManager.getI18NMessage("Line: "));
        this._columnLabel.setText(ResourceManager.getI18NMessage(" Column: "));
        this.readOnlyPanel.setBorder(BorderFactory.createBevelBorder(1));
        this._readOnlyLabel.setText(ResourceManager.getI18NMessage("READ ONLY"));
        this.setResizable(true);
        int n = 0;
        if (_instanceCount > 1) {
            n = 20;
        }
        int n2 = Math.max(n, SCEditorProperties.getFrameX() + n);
        int n3 = Math.max(n, SCEditorProperties.getFrameY() + n);
        int n4 = SCEditorProperties.getFrameWidth();
        int n5 = SCEditorProperties.getFrameHeight();
        this.setBounds(n2, n3, n4, n5);
        try {
            if (!this._sdi) {
                this.dropTarget = new DropTarget(this._editorPane, 1, this, true);
                this._editorPane.setDropTarget(this.dropTarget);
            } else {
                this.dropTarget = new DropTarget(this._editorPanel, 1, this, true);
                this._editorPanel.setDropTarget(this.dropTarget);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        this.buildFileMenu();
        this._menuBar.add((JMenu)this._fileMenu);
        this._editMenu = new SybMenu(ResourceManager.getI18NMessage("Edit"));
        this._undoMenuItem = this.addMenuItem(this._editMenu, this._undoAction, KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this._redoMenuItem = this.addMenuItem(this._editMenu, this._redoAction, KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this._undoMenuItem.setEnabled(false);
        this._redoMenuItem.setEnabled(false);
        this._editMenu.addSeparator();
        this.addMenuItem(this._editMenu, this._cutAction, KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.addMenuItem(this._editMenu, this._copyAction, KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.addMenuItem(this._editMenu, this._pasteAction, KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.addMenuItem(this._editMenu, this._deleteAction, KeyStroke.getKeyStroke(127, 0, false));
        this._editMenu.addSeparator();
        this.addMenuItem(this._editMenu, this._selectAllAction, KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this._editMenu.addSeparator();
        this.addMenuItem(this._editMenu, this._goToLineAction, KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this._menuBar.add((JMenu)this._editMenu);
        this._editMenu.addSeparator();
        SybMenu sybMenu = new SybMenu(ResourceManager.getI18NMessage("Advanced"));
        int n6 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.addMenuItem(sybMenu, this._indentLeftAction, KeyStroke.getKeyStroke(44, n6 | 1));
        this.addMenuItem(sybMenu, this._indentRightAction, KeyStroke.getKeyStroke(46, n6 | 1));
        this.addMenuItem(sybMenu, this._addRemoveDoubleDashCommentAction, KeyStroke.getKeyStroke(45, n6));
        this.addMenuItem(sybMenu, this._addRemoveDoubleSlashCommentAction, KeyStroke.getKeyStroke(47, n6));
        this._editMenu.add((JMenuItem)sybMenu);
        this._searchMenu = new SybMenu(ResourceManager.getI18NMessage("Search"));
        this.addMenuItem(this._searchMenu, this._findReplaceAction, KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.addMenuItem(this._searchMenu, this._findNextAction, KeyStroke.getKeyStroke(114, 0, false));
        if (!this._sdi) {
            this.addMenuItem(this._searchMenu, this._findInFilesAction, null);
        }
        this._menuBar.add((JMenu)this._searchMenu);
        this._toolsMenu = new SybMenu(ResourceManager.getI18NMessage("Tools"));
        this.addMenuItem(this._toolsMenu, this._customizeAction, null);
        this._menuBar.add((JMenu)this._toolsMenu);
        if (!this._sdi) {
            this._windowMenu = new SybMenu(ResourceManager.getI18NMessage("Window"));
            this.addMenuItem(this._windowMenu, this._closeWindowAction, null);
            this.addMenuItem(this._windowMenu, this._closeAllWindowsAction, null);
            this._windowMenu.addSeparator();
            this.addMenuItem(this._windowMenu, this._nextWindowAction, null);
            this.addMenuItem(this._windowMenu, this._previousWindowAction, null);
            this._windowMenu.addSeparator();
            this.addMenuItem(this._windowMenu, this._cascadeWindowsAction, null);
            this.addMenuItem(this._windowMenu, this._tileWindowsHorizontallyAction, null);
            this.addMenuItem(this._windowMenu, this._tileWindowsVerticallyAction, null);
            this._windowMenu.addSeparator();
            this.addMenuItem(this._windowMenu, this._windowsAction, null);
            this._menuBar.add((JMenu)this._windowMenu);
        }
        if (this._helpMenu == null && this._showHelpMenu) {
            this._helpMenu = new SybMenu(ResourceManager.getI18NMessage("Help"));
            this.addMenuItem(this._helpMenu, this._helpAction, null);
            this._helpMenu.addSeparator();
            this.addMenuItem(this._helpMenu, this._aboutAction, null);
        }
        if (this._showHelpMenu) {
            this._menuBar.add((JMenu)this._helpMenu);
        }
        this.buildToolbar();
        UIUtils.ensureWindowIsVisible((Window)this);
        this.setVisible(true);
        this._formCreationInProgress = false;
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return _minimumSize;
    }

    public Dimension getPreferedSize() {
        return _minimumSize;
    }

    private SybMenuItem addMenuItem(SybMenu sybMenu, Action action, KeyStroke keyStroke) {
        SybMenuItem sybMenuItem = new SybMenuItem(action);
        if (keyStroke != null) {
            sybMenuItem.setAccelerator(keyStroke);
        }
        sybMenuItem.addMouseListener((MouseListener)this);
        sybMenuItem.setToolTipText("");
        sybMenu.add((JMenuItem)sybMenuItem);
        return sybMenuItem;
    }

    @Override
    public synchronized boolean destroy() {
        if (this._customizeDialog != null) {
            this._customizeDialog.destroy();
            this._customizeDialog = null;
        }
        if (this._findReplaceDialog != null) {
            ((FindReplaceDialog)((Object)this._findReplaceDialog)).destroy();
            this._findReplaceDialog = null;
        }
        if (this._findInFilesDialog != null) {
            ((FindInFilesDialog)this._findInFilesDialog).destroy();
            this._findInFilesDialog = null;
        }
        if (this._defaultAboutDialog != null) {
            ((AboutDialog)((Object)this._defaultAboutDialog)).destroy();
            this._defaultAboutDialog = null;
        }
        this.removeWindowListener(this);
        this.removeComponentListener(this);
        if (!this._sdi) {
            this._findInFiles1List.removeMouseListener(this);
            this._findInFiles2List.removeMouseListener(this);
            this._resultsList.removeMouseListener(this);
            this._splitPane.removePropertyChangeListener(this);
            this._editorPane.setDropTarget(null);
        } else {
            this._editorPanel.setDropTarget(null);
        }
        this._toolBar.removeAll();
        int n = this._menuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            SybMenu sybMenu = (SybMenu)this._menuBar.getMenu(i);
            int n2 = sybMenu.getItemCount();
            for (int j = 0; j < n2; ++j) {
                JMenuItem jMenuItem = sybMenu.getItem(j);
                if (jMenuItem == null) continue;
                jMenuItem.removeMouseListener(this);
            }
            sybMenu.removeAll();
        }
        this._menuBar.removeAll();
        this.transferFocus();
        DialogUtils.removeComponents((Container)this);
        this.rootPane = null;
        if (_instanceCount == 0) {
            ResourceManager.destroy();
        }
        this._menuBar = null;
        this._editorPane = null;
        this._findInFiles1List = null;
        this._findInFiles1ScrollPane = null;
        this._findInFiles2List = null;
        this._findInFiles2ScrollPane = null;
        this._resultsList = null;
        this._resultsScrollPane = null;
        this._viewPane = null;
        this._splitPane = null;
        this._editorPanel = null;
        this.statusPanel = null;
        this.infoPanel = null;
        this.lineColumnPanel = null;
        this.readOnlyPanel = null;
        this._lineLabel = null;
        this._yLabel = null;
        this._columnLabel = null;
        this._xLabel = null;
        this._readOnlyLabel = null;
        this._statusText = null;
        this._progressBar = null;
        this._printStatus = null;
        this._toolBar = null;
        this._undoMenuItem = null;
        this._redoMenuItem = null;
        this._undoButton = null;
        this._redoButton = null;
        this._saveTitle = null;
        this._saveIcon = null;
        this._saveToolTip = null;
        this._saveButton = null;
        this._saveMenuItem = null;
        this._exitTitle = null;
        this._exitIcon = null;
        this._exitToolTip = null;
        this._exitButton = null;
        this._exitMenuItem = null;
        this._listenerList = null;
        this._fileFilters = null;
        this._currentDirectory = null;
        this._fileMenu = null;
        this._editMenu = null;
        this._searchMenu = null;
        this._toolsMenu = null;
        this._windowMenu = null;
        this._helpMenu = null;
        this._fileListMenu = null;
        this.emptyListItem = null;
        this._okOptions = null;
        this._yesNoOptions = null;
        this._yesNoCancelOptions = null;
        this._recentFiles = null;
        this._fileList = null;
        this._fileTable = null;
        this._windowTable = null;
        this.dropTarget = null;
        this._fileHolder = null;
        this._editorEvent = null;
        this._menuListener = null;
        this._newAction = null;
        this._openAction = null;
        this._closeAction = null;
        this._saveAction = null;
        this._saveFileAsAction = null;
        this._saveAllAction = null;
        this._printAction = null;
        this._exitAction = null;
        this._undoAction = null;
        this._redoAction = null;
        this._cutAction = null;
        this._copyAction = null;
        this._pasteAction = null;
        this._deleteAction = null;
        this._selectAllAction = null;
        this._findReplaceAction = null;
        this._findNextAction = null;
        this._findInFilesAction = null;
        this._customizeAction = null;
        this._closeWindowAction = null;
        this._closeAllWindowsAction = null;
        this._nextWindowAction = null;
        this._previousWindowAction = null;
        this._cascadeWindowsAction = null;
        this._tileWindowsHorizontallyAction = null;
        this._tileWindowsVerticallyAction = null;
        this._windowsAction = null;
        this._helpAction = null;
        this._aboutAction = null;
        return true;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public void exitActionPerformed() {
        if (!this._sdi) {
            SCEditorProperties.setDividerLocation(this._splitPane.getDividerLocation());
        }
        SCEditorProperties.setFrameX(this.getX());
        SCEditorProperties.setFrameY(this.getY());
        SCEditorProperties.store();
        --_instanceCount;
        if (this.closeFile()) {
            this.setVisible(false);
            this.fireEditorClosed();
            this.destroy();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.exitActionPerformed();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (this._sdi) {
            if (this._fileHolder != null && this._fileHolder.getLastModified() != this._fileHolder.getFile().lastModified()) {
                int n = SybOptionPane.showOptionDialog((Component)this, (Object)(this._fileHolder.getFileName() + ResourceManager.getI18NMessage("FILE_MODIFIED_LONG")), (String)ResourceManager.getI18NMessage("FILE_MODIFIED"), (int)0, (int)3, null, (Object[])this._yesNoOptions, (Object)this._yesNoOptions[0]);
                if (n == 1) {
                    this._fileHolder.updateLastModified();
                } else {
                    this._fileHolder.reload();
                }
            }
            if (this._fileHolder != null && JREUtils.getFullJDKVersion() < 14000) {
                this._fileHolder.getEditor().getCaret().setVisible(true);
            }
        } else {
            Component[] componentArray = this._editorPane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                FileHolder fileHolder;
                if (!(componentArray[i] instanceof JInternalFrame) || (fileHolder = this._windowTable.get(componentArray[i])).getLastModified() == fileHolder.getFile().lastModified()) continue;
                int n = SybOptionPane.showOptionDialog((Component)this, (Object)(fileHolder.getFileName() + ResourceManager.getI18NMessage("FILE_MODIFIED_LONG")), (String)ResourceManager.getI18NMessage("FILE_MODIFIED"), (int)0, (int)3, null, (Object[])this._yesNoOptions, (Object)this._yesNoOptions[0]);
                if (n == 1) {
                    fileHolder.updateLastModified();
                    continue;
                }
                fileHolder.reload();
            }
            FileHolder fileHolder = this.getSelectedFrame();
            if (fileHolder != null && JREUtils.getFullJDKVersion() < 14000) {
                fileHolder.getEditor().getCaret().setVisible(true);
            }
        }
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public SCEditorFrame() {
        this(System.getProperty("SDI", "SDI").equals("SDI"));
    }

    public SCEditorFrame(boolean bl) {
        this(bl, false);
    }

    public SCEditorFrame(boolean bl, boolean bl2) {
        this._sdi = bl;
        this._standalone = bl2;
        this.setDefaultCloseOperation(0);
        ++_instanceCount;
        this._menuBar = new JMenuBar();
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._saveTitle = ResourceManager.getI18NMessage("Save");
        this._saveMnemonic = '\u0000';
        this._saveIcon = Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("save", 1000) : SCEditorImageLoader.getImageIcon("save", 1004);
        this._saveButton = new SybButton();
        this._saveMenuItem = new JMenuItem();
        this._saveAccelerator = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        this._saveShortDescription = ResourceManager.getI18NMessage("saveTip");
        this._saveLongDescription = ResourceManager.getI18NMessage("Saves the document");
        this._exitTitle = ResourceManager.getI18NMessage("Exit");
        this._exitMnemonic = '\u0000';
        this._exitIcon = SCEditorImageLoader.getImageIcon("blank", 1004);
        this._exitButton = new SybButton();
        this._exitMenuItem = new JMenuItem();
        this._exitAccelerator = KeyStroke.getKeyStroke(115, 8, false);
        this._exitShortDescription = ResourceManager.getI18NMessage("Exit");
        this._exitLongDescription = ResourceManager.getI18NMessage("Quit this editor session");
        this._listenerList = new EventListenerList();
        this._fileFilters = new ArrayList<FileFilter>();
        this._okOptions = new Object[]{ResourceManager.getI18NMessage("OK")};
        this._yesNoOptions = new Object[]{ResourceManager.getI18NMessage("Yes"), ResourceManager.getI18NMessage("No")};
        this._yesNoCancelOptions = new Object[]{ResourceManager.getI18NMessage("Yes"), ResourceManager.getI18NMessage("No"), ResourceManager.getI18NMessage("Cancel")};
        this._fileList = new ArrayList<JInternalFrame>();
        this._fileTable = new Hashtable();
        this._windowTable = new Hashtable();
        this._newAction = new ReflectiveAction(this, "newFile", ResourceManager.getI18NMessage("New..."), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("new", 1000) : SCEditorImageLoader.getImageIcon("new", 1004), ResourceManager.getI18NMessage("newTip"), ResourceManager.getI18NMessage("Create a new document"));
        this._openAction = new ReflectiveAction(this, "openFile", ResourceManager.getI18NMessage("Open..."), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("open", 1000) : SCEditorImageLoader.getImageIcon("open", 1004), ResourceManager.getI18NMessage("openTip"), ResourceManager.getI18NMessage("Open an existing document"));
        this._closeAction = new ReflectiveAction(this, "closeFile", ResourceManager.getI18NMessage("Close"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("closeTip"), ResourceManager.getI18NMessage("Closes the document"));
        this._saveAction = new ReflectiveAction(this, "fireSave", ResourceManager.getI18NMessage("Save"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("save", 1000) : SCEditorImageLoader.getImageIcon("save", 1004));
        this._saveFileAsAction = new ReflectiveAction(this, "saveFileAsActionPerformed", ResourceManager.getI18NMessage("Save File As..."), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("saveFileAsTip"), ResourceManager.getI18NMessage("Saves the document with a new name"));
        this._saveAllAction = new ReflectiveAction(this, "saveAllActionPerformed", ResourceManager.getI18NMessage("Save All"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("saveall", 1000) : SCEditorImageLoader.getImageIcon("saveall", 1004), ResourceManager.getI18NMessage("saveAllTip"), ResourceManager.getI18NMessage("Save all documents"));
        this._printAction = new ReflectiveAction(this, "print", ResourceManager.getI18NMessage("Print..."), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("print", 1000) : SCEditorImageLoader.getImageIcon("print", 1004), ResourceManager.getI18NMessage("printTip"), ResourceManager.getI18NMessage("Print this document"));
        this._exitAction = new ReflectiveAction(this, "exitActionPerformed", ResourceManager.getI18NMessage("Exit"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004));
        this._undoAction = new ReflectiveAction(this, "undoActionPerformed", ResourceManager.getI18NMessage("Undo"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("undo", 1000) : SCEditorImageLoader.getImageIcon("undo", 1004), ResourceManager.getI18NMessage("undoTip"), ResourceManager.getI18NMessage("Undo last change"));
        this._undoAction.setEnabled(false);
        this._redoAction = new ReflectiveAction(this, "redoActionPerformed", ResourceManager.getI18NMessage("Redo"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("redo", 1000) : SCEditorImageLoader.getImageIcon("redo", 1004), ResourceManager.getI18NMessage("redoTip"), ResourceManager.getI18NMessage("Redo last change"));
        this._redoAction.setEnabled(false);
        this._cutAction = new ReflectiveAction(this, "cutActionPerformed", ResourceManager.getI18NMessage("Cut"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("cut", 1000) : SCEditorImageLoader.getImageIcon("cut", 1004), ResourceManager.getI18NMessage("cutTip"), ResourceManager.getI18NMessage("Cut selected text"));
        this._copyAction = new ReflectiveAction(this, "copyActionPerformed", ResourceManager.getI18NMessage("Copy"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("copy", 1000) : SCEditorImageLoader.getImageIcon("copy", 1004), ResourceManager.getI18NMessage("copyTip"), ResourceManager.getI18NMessage("Copy selected text to clipboard"));
        this._pasteAction = new ReflectiveAction(this, "pasteActionPerformed", ResourceManager.getI18NMessage("Paste"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("paste", 1000) : SCEditorImageLoader.getImageIcon("paste", 1004), ResourceManager.getI18NMessage("pasteTip"), ResourceManager.getI18NMessage("Paste clipboard contents to selected area"));
        this._deleteAction = new ReflectiveAction(this, "deleteActionPerformed", ResourceManager.getI18NMessage("Delete"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("delete", 1000) : SCEditorImageLoader.getImageIcon("delete", 1004), ResourceManager.getI18NMessage("deleteTip"), ResourceManager.getI18NMessage("Delete selected text"));
        this._selectAllAction = new ReflectiveAction(this, "selectAllActionPerformed", ResourceManager.getI18NMessage("SelectAll"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("selectAllTip"), ResourceManager.getI18NMessage("Select the entire document"));
        this._goToLineAction = new ReflectiveAction(this, "goToLineActionPerformed", ResourceManager.getI18NMessage("GoToMenu"), SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("goToMenuTip"), ResourceManager.getI18NMessage("Go to specified line"));
        this._indentLeftAction = new ReflectiveAction(this, "indentLeftActionPerformed", ResourceManager.getI18NMessage("IndentLeftMenu"), null, ResourceManager.getI18NMessage("IndentLeftMenuTip"), ResourceManager.getI18NMessage("IndentLeftMenuLongDesc"));
        this._indentRightAction = new ReflectiveAction(this, "indentRightActionPerformed", ResourceManager.getI18NMessage("IndentRightMenu"), null, ResourceManager.getI18NMessage("IndentRightMenuTip"), ResourceManager.getI18NMessage("IndentRightMenuLongDesc"));
        this._addRemoveDoubleDashCommentAction = new ReflectiveAction(this, "addRemoveDoubleDashCommentActionPerformed", ResourceManager.getI18NMessage("AddRemoveDoubleDashCommentMenu"), null, ResourceManager.getI18NMessage("AddRemoveDoubleDashCommentMenuTip"), ResourceManager.getI18NMessage("AddRemoveDoubleDashCommentMenuLongDesc"));
        this._addRemoveDoubleSlashCommentAction = new ReflectiveAction(this, "addRemoveDoubleSlashCommentActionPerformed", ResourceManager.getI18NMessage("AddRemoveDoubleSlashCommentMenu"), null, ResourceManager.getI18NMessage("AddRemoveDoubleSlashCommentMenuTip"), ResourceManager.getI18NMessage("AddRemoveDoubleSlashCommentMenuLongDesc"));
        this._findReplaceAction = new ReflectiveAction(this, "findReplaceActionPerformed", ResourceManager.getI18NMessage("Find/Replace..."), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("findintext", 1000) : SCEditorImageLoader.getImageIcon("findintext", 1004), ResourceManager.getI18NMessage("findReplaceTip"), ResourceManager.getI18NMessage("Find/replace text in document"));
        this._findNextAction = new ReflectiveAction(this, "findNextActionPerformed", ResourceManager.getI18NMessage("Find Next"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("findNextTip"), ResourceManager.getI18NMessage("Finds next occurrence of specified text"));
        this._findInFilesAction = new ReflectiveAction(this, "findInFilesActionPerformed", ResourceManager.getI18NMessage("Find In Files"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("findinfiles", 1000) : SCEditorImageLoader.getImageIcon("findinfiles", 1004), ResourceManager.getI18NMessage("findInFilesTip"), ResourceManager.getI18NMessage("Searches for text in files"));
        this._customizeAction = new ReflectiveAction(this, "customizeActionPerformed", Platform.isMacOS() ? ResourceManager.getI18NMessage("Customize..._Mac") : ResourceManager.getI18NMessage("Customize..."), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), Platform.isMacOS() ? ResourceManager.getI18NMessage("customizeTip_Mac") : ResourceManager.getI18NMessage("customizeTip"), ResourceManager.getI18NMessage("Customize the editors settings"));
        this._closeWindowAction = new ReflectiveAction(this, "closeFile", ResourceManager.getI18NMessage("CloseWindow"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("closeWindowTip"), ResourceManager.getI18NMessage("Closes the window"));
        this._closeAllWindowsAction = new ReflectiveAction(this, "closeAllWindowsActionPerformed", ResourceManager.getI18NMessage("Close All"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("closeAllWindowsTip"), ResourceManager.getI18NMessage("Closes all open windows"));
        this._nextWindowAction = new ReflectiveAction(this, "nextWindowActionPerformed", ResourceManager.getI18NMessage("Next"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("nextWindowTip"), ResourceManager.getI18NMessage("Activates the next window"));
        this._previousWindowAction = new ReflectiveAction(this, "previousWindowActionPerformed", ResourceManager.getI18NMessage("Previous"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("previousWindowTip"), ResourceManager.getI18NMessage("Activates the previous window"));
        this._cascadeWindowsAction = new ReflectiveAction(this, "cascadeWindowActionPerformed", ResourceManager.getI18NMessage("Cascade"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("cascadeWindowsTip"), ResourceManager.getI18NMessage("Arranges the windows as overlapping tiles"));
        this._tileWindowsHorizontallyAction = new ReflectiveAction(this, "tileWindowsHorizontallyActionPerformed", ResourceManager.getI18NMessage("Tile Horizontally"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("tileWindowsHorizontallyTip"), ResourceManager.getI18NMessage("Arranges the windows as horizontal, nonoverlapping tiles"));
        this._tileWindowsVerticallyAction = new ReflectiveAction(this, "tileWindowsVerticallyActionPerformed", ResourceManager.getI18NMessage("Tile Vertically"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("tileWindowsVerticallyTip"), ResourceManager.getI18NMessage("Arranges the windows as vertical, nonoverlapping tiles"));
        this._windowsAction = new ReflectiveAction(this, "windowsActionPerformed", ResourceManager.getI18NMessage("Windows"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), ResourceManager.getI18NMessage("windowsTip"), ResourceManager.getI18NMessage("Manages the currently open windows"));
        this._helpAction = new ReflectiveAction(this, "helpActionPerformed", "?", Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("blank", 1000) : SCEditorImageLoader.getImageIcon("blank", 1004), 63, "", "");
        this._aboutAction = new ReflectiveAction(this, "aboutActionPerformed", ResourceManager.getI18NMessage("About"), Platform.isMacOS() ? SCEditorImageLoader.getImageIcon("about", 1000) : SCEditorImageLoader.getImageIcon("about", 1004), ResourceManager.getI18NMessage("aboutTip"), "");
    }

    void buildFileMenu() {
        if (!this._sdi) {
            this._fileListMenu = new SybMenu(ResourceManager.getI18NMessage("Recent Files"));
            this.emptyListItem = new JMenuItem(ResourceManager.getI18NMessage("Empty"));
            this.emptyListItem.setEnabled(false);
            this._fileListMenu.add(this.emptyListItem);
        }
        this._fileMenu = new SybMenu(ResourceManager.getI18NMessage("File"));
        if (this._showNewFileItem) {
            this.addMenuItem(this._fileMenu, this._newAction, KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        }
        if (this._showOpenFileItem) {
            this.addMenuItem(this._fileMenu, this._openAction, KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        }
        if (this._showCloseFileItem) {
            this.addMenuItem(this._fileMenu, this._closeAction, null);
        }
        if ((this._showNewFileItem || this._showOpenFileItem || this._showCloseFileItem) && (this._showSaveFileItem || this._showSaveAsFileItem || this._showPrintFileItem || this._showExitFileItem)) {
            this._fileMenu.addSeparator();
        }
        if (this._showSaveFileItem && this._saveTitle != null && this._saveTitle.length() > 0) {
            this._saveAction.putValue("Name", this._saveTitle);
            this._saveAction.putValue("SmallIcon", this._saveIcon);
            this._saveAction.putValue("ShortDescription", this._saveShortDescription);
            this._saveAction.putValue("LongDescription", this._saveLongDescription);
            if (this._saveMnemonic != '\u0000') {
                this._saveAction.putValue("MnemonicKey", this._saveMnemonic);
            }
            this._saveMenuItem = this.addMenuItem(this._fileMenu, this._saveAction, this._saveAccelerator);
        }
        if (this._showSaveAsFileItem) {
            this.addMenuItem(this._fileMenu, this._saveFileAsAction, null);
        }
        if (!this._sdi) {
            this.addMenuItem(this._fileMenu, this._saveAllAction, null);
        }
        if ((this._showSaveFileItem || this._showSaveAsFileItem) && (this._showPrintFileItem || this._showExitFileItem)) {
            this._fileMenu.addSeparator();
        }
        if (!this._sdi) {
            this._fileMenu.addSeparator();
            this._fileMenu.add((JMenuItem)this._fileListMenu);
        }
        if (this._showPrintFileItem) {
            this.addMenuItem(this._fileMenu, this._printAction, KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            if (this._showExitFileItem) {
                this._fileMenu.addSeparator();
            }
        }
        if (this._showExitFileItem && this._exitTitle != null && this._exitTitle.length() > 0) {
            this._exitAction.putValue("Name", this._exitTitle);
            this._exitAction.putValue("SmallIcon", this._exitIcon);
            this._exitAction.putValue("ShortDescription", this._exitShortDescription);
            this._exitAction.putValue("LongDescription", this._exitLongDescription);
            if (this._exitMnemonic != '\u0000') {
                this._exitAction.putValue("MnemonicKey", new Integer(this._exitMnemonic));
            }
            this._exitMenuItem = this.addMenuItem(this._fileMenu, this._exitAction, this._exitAccelerator);
        }
        this._menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            }
        };
    }

    private JButton addToolbarButton(Action action) {
        SybToolBarButton sybToolBarButton = new SybToolBarButton(action);
        sybToolBarButton.setText("");
        sybToolBarButton.setMnemonic(' ');
        sybToolBarButton.setDisplayedMnemonicIndex(-1);
        this._toolBar.add((Component)sybToolBarButton);
        return sybToolBarButton;
    }

    void buildToolbar() {
        try {
            while (true) {
                this._toolBar.remove(this._toolBar.getComponentAtIndex(0));
            }
        }
        catch (Exception exception) {
            if (this._showNewFileItem) {
                this.addToolbarButton(this._newAction);
            }
            if (this._showOpenFileItem) {
                this.addToolbarButton(this._openAction);
            }
            if (this._showSaveFileItem && this._saveTitle != null && this._saveTitle.length() > 0 && this._saveIcon != null) {
                this._saveAction.putValue("Name", this._saveTitle);
                this._saveAction.putValue("SmallIcon", this._saveIcon);
                this._saveAction.putValue("ShortDescription", this._saveShortDescription);
                this._saveAction.putValue("LongDescription", this._saveLongDescription);
                this._saveButton = this.addToolbarButton(this._saveAction);
            }
            if (this._showPrintFileItem) {
                this.addToolbarButton(this._printAction);
            }
            if (this._showNewFileItem || this._showOpenFileItem || this._showSaveFileItem || this._showPrintFileItem) {
                this._toolBar.addSeparator();
            }
            this._undoButton = this.addToolbarButton(this._undoAction);
            this._redoButton = this.addToolbarButton(this._redoAction);
            this._toolBar.addSeparator();
            this.addToolbarButton(this._cutAction);
            this.addToolbarButton(this._copyAction);
            this.addToolbarButton(this._pasteAction);
            this.addToolbarButton(this._deleteAction);
            this._toolBar.addSeparator();
            this.addToolbarButton(this._findReplaceAction);
            if (!this._sdi) {
                this.addToolbarButton(this._findInFilesAction);
                this._toolBar.addSeparator();
                this.addToolbarButton(this._windowsAction);
            }
            return;
        }
    }

    @Override
    public boolean isShowNewFileItem() {
        return this._showNewFileItem;
    }

    @Override
    public void setShowNewFileItem(boolean bl) {
        this._showNewFileItem = bl;
        this.buildFileMenu();
        this.buildToolbar();
    }

    @Override
    public boolean isShowOpenFileItem() {
        return this._showOpenFileItem;
    }

    @Override
    public void setShowOpenFileItem(boolean bl) {
        this._showOpenFileItem = bl;
        this.buildFileMenu();
        this.buildToolbar();
    }

    @Override
    public boolean isShowCloseFileItem() {
        return this._showCloseFileItem;
    }

    @Override
    public void setShowCloseFileItem(boolean bl) {
        this._showCloseFileItem = bl;
        this.buildFileMenu();
        this.buildToolbar();
    }

    @Override
    public boolean isShowSaveFileItem() {
        return this._showSaveFileItem;
    }

    @Override
    public void setShowSaveFileItem(boolean bl) {
        this._showSaveFileItem = bl;
        this.buildFileMenu();
        this.buildToolbar();
    }

    @Override
    public boolean isShowSaveAsFileItem() {
        return this._showSaveAsFileItem;
    }

    @Override
    public void setShowSaveAsFileItem(boolean bl) {
        this._showSaveAsFileItem = bl;
        this.buildFileMenu();
        this.buildToolbar();
    }

    @Override
    public boolean isShowPrintFileItem() {
        return this._showPrintFileItem;
    }

    @Override
    public void setShowPrintFileItem(boolean bl) {
        this._showPrintFileItem = bl;
        this.buildFileMenu();
        this.buildToolbar();
    }

    @Override
    public boolean isShowExitFileItem() {
        return this._showExitFileItem;
    }

    @Override
    public void setShowExitFileItem(boolean bl) {
        this._showExitFileItem = bl;
        this.buildFileMenu();
        this.buildToolbar();
    }

    public void addRecentFile(String string) {
        int n = this._recentFiles.indexOf(string);
        if (n == -1) {
            this._recentFiles.add(0, string);
            if (this._recentFiles.size() > 4) {
                this._recentFiles.remove(4);
            }
        } else {
            this._recentFiles.remove(n);
            this._recentFiles.add(0, string);
        }
        this.buildRecentFileMenu();
    }

    public void buildRecentFileMenu() {
        if (!this._sdi) {
            this._recentFiles = new ArrayList<String>(4);
            int n = this._recentFiles.size();
            this._fileListMenu.removeAll();
            for (int i = 1; i <= n; ++i) {
                String string = this._recentFiles.get(i - 1);
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setActionCommand(string);
                jMenuItem.setText(i + " " + string);
                jMenuItem.setMnemonic(48 + i);
                this._fileListMenu.add(jMenuItem);
                jMenuItem.addActionListener(this._menuListener);
            }
        }
    }

    @Override
    public void addFileFilter(FileFilter fileFilter) {
        this._fileFilters.add(fileFilter);
    }

    protected String requestSaveFileName() {
        int n;
        String string = null;
        SybFileChooser sybFileChooser = new SybFileChooser(18);
        if (this._defaultExtension != null) {
            sybFileChooser.setDefaultExtension(this._defaultExtension);
        }
        if ((n = this._fileFilters.size()) > 0) {
            SybFileFilter[] sybFileFilterArray = new SybFileFilter[n];
            for (int i = 0; i < n; ++i) {
                FileFilter fileFilter = this._fileFilters.get(i);
                sybFileFilterArray[i] = fileFilter instanceof SwingFileFilter ? ((SwingFileFilter)fileFilter).getSybFileFilter() : SybFileFilter.createSybFilterFromSwingFilter((FileFilter)fileFilter);
            }
            sybFileChooser.setFilters(sybFileFilterArray, 0);
        }
        sybFileChooser.setTitle(ResourceManager.getI18NMessage("saveFileAsTitle"));
        if (sybFileChooser.showDialog((Window)this, this._currentDirectory, null)) {
            File file = sybFileChooser.getSelectedFile();
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getName();
            }
            this._currentDirectory = file.getParentFile();
        }
        return string;
    }

    protected String requestOpenFileName() {
        String string = null;
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        int n = this._fileFilters.size();
        if (n > 0) {
            SybFileFilter[] sybFileFilterArray = new SybFileFilter[n];
            for (int i = 0; i < n; ++i) {
                FileFilter fileFilter = this._fileFilters.get(i);
                sybFileFilterArray[i] = fileFilter instanceof SwingFileFilter ? ((SwingFileFilter)fileFilter).getSybFileFilter() : SybFileFilter.createSybFilterFromSwingFilter((FileFilter)fileFilter);
            }
            sybFileChooser.setFilters(sybFileFilterArray, 0);
        }
        sybFileChooser.setTitle(ResourceManager.getI18NMessage("Open"));
        if (sybFileChooser.showDialog((Window)this, this._currentDirectory, null)) {
            File file = sybFileChooser.getSelectedFile();
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getName();
            }
            this._currentDirectory = file.getParentFile();
        }
        return string;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        FileHolder fileHolder;
        Object object;
        if (propertyChangeEvent.getSource() instanceof JInternalFrame) {
            object = (JInternalFrame)propertyChangeEvent.getSource();
            fileHolder = this._windowTable.get(object);
        } else {
            fileHolder = this._fileHolder;
        }
        object = propertyChangeEvent.getPropertyName();
        Object object2 = propertyChangeEvent.getNewValue();
        if (((String)object).equals("closed") && ((Boolean)object2).booleanValue() && fileHolder != null) {
            if (fileHolder.isPrinting()) {
                int n = SybOptionPane.showOptionDialog((Component)this, (Object)ResourceManager.getI18NMessage("FILE_PRINTING"), (String)ResourceManager.getI18NMessage("FILE_PRINTING_TITLE"), (int)0, (int)3, null, (Object[])this._yesNoOptions, (Object)this._yesNoOptions[0]);
                if (n == 0) {
                    throw new PropertyVetoException(ResourceManager.getI18NMessage("Canceled by user"), propertyChangeEvent);
                }
                fileHolder.cancelPrint();
            }
            if (fileHolder.isChanged()) {
                Object[] objectArray = new Object[]{fileHolder.getFileName()};
                int n = SybOptionPane.showOptionDialog((Component)this, (Object)SybMessageFormat.format((String)ResourceManager.getI18NMessage("Do you want to save changes to "), (Object[])objectArray), (String)this._saveShortDescription, (int)1, (int)3, null, (Object[])this._yesNoCancelOptions, (Object)this._yesNoCancelOptions[0]);
                if (n != 1) {
                    if (n == 0) {
                        this.fireSave();
                        if (fileHolder.isChanged()) {
                            throw new PropertyVetoException(ResourceManager.getI18NMessage("Canceled by user"), propertyChangeEvent);
                        }
                    } else {
                        throw new PropertyVetoException(ResourceManager.getI18NMessage("Canceled by user"), propertyChangeEvent);
                    }
                }
            }
            fileHolder.getEditor().setDropTarget(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getSource() == this._splitPane) {
            if (!this._ignoreSplitPanePropertyChange) {
                this._bottomPaneHeight = this._splitPane.getBottomComponent().getHeight();
            } else {
                this._ignoreSplitPanePropertyChange = false;
            }
        } else if (propertyChangeEvent.getSource() instanceof JInternalFrame) {
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            FileHolder fileHolder = this._windowTable.get(jInternalFrame);
            if (string.equals("closed") && ((Boolean)object).booleanValue() && fileHolder != null) {
                this._windowTable.remove(jInternalFrame);
                this._fileTable.remove(fileHolder.getFileName());
                this._windowMenu.remove(this.windowMenuWindowOffset + this._fileList.indexOf(jInternalFrame) + 1);
                this._fileList.remove(jInternalFrame);
                fileHolder.destroy();
            }
        }
    }

    @Override
    public void setEditorType(String string) {
        if (this._sdi && this._fileHolder != null) {
            this._fileHolder.setEditorType(string);
        }
    }

    public boolean openFile() {
        return this.openFile(this.requestOpenFileName());
    }

    @Override
    public boolean openFile(String string) {
        return this.openFile(string, null, null);
    }

    @Override
    public boolean openFile(String string, Charset charset) {
        return this.openFile(string, null, charset);
    }

    @Override
    public boolean openFile(String string, Parser parser) {
        return this.openFile(string, null, null);
    }

    @Override
    public boolean openFile(String string, Parser parser, Charset charset) {
        boolean bl = true;
        Cursor cursor = this.getCursor();
        this.setCursor(SCEditor.WAIT_CURSOR);
        if (string != null) {
            this._progressBar.setMinimum(0);
            if (this._sdi) {
                if (this.setupNewSdiEditor(string, true, parser, charset)) {
                    this.setTitle(string);
                    this.setEditable(this._fileHolder.getFile().canWrite());
                    this._xLabel.setText("1");
                    this._yLabel.setText("1");
                }
            } else if (this._fileTable.containsKey(string)) {
                FileHolder fileHolder = this._fileTable.get(string);
                try {
                    fileHolder.getInternalFrame().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                File file = new File(string);
                try {
                    this.setupNewMdiEditor(string, file.canWrite(), parser, charset);
                    this.setEditable(this._fileHolder.getFile().canWrite());
                    this.addRecentFile(string);
                }
                catch (Exception exception) {
                    SybOptionPane.showOptionDialog((Component)this, (Object)(ResourceManager.getI18NMessage("Failed to open \"") + string + "\"."), (String)ResourceManager.getI18NMessage("File Read Error"), (int)0, (int)0, null, (Object[])this._okOptions, (Object)this._okOptions[0]);
                    this.getToolkit().beep();
                    bl = false;
                }
            }
        }
        this.setCursor(cursor);
        return bl;
    }

    @Override
    public void newFile() {
        this.newFile("");
    }

    @Override
    public void newFile(String string) {
        this.newFile(null, string, null);
    }

    @Override
    public void newFile(String string, String string2) {
        this.newFile(string, string2, null);
    }

    @Override
    public void newFile(String string, String string2, Parser parser) {
        if (this.createNewFile(string, parser)) {
            this.setText(string2, parser);
            this._readOnlyLabel.setEnabled(false);
        }
    }

    private boolean createNewFile(String string, Parser parser) {
        boolean bl = true;
        this._readOnlyLabel.setEnabled(false);
        if (string == null || string != null && string.length() == 0) {
            boolean bl2;
            do {
                bl2 = false;
                string = new StringBuffer("Text").append(this.newFileCounter++).toString();
                File file = new File(string);
                try {
                    bl2 = file.exists();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this._fileTable.containsKey(string) || bl2);
        }
        if (this._sdi) {
            if (this.setupNewSdiEditor(string, true, parser, null)) {
                this._fileHolder.updateLastModified();
            } else {
                bl = false;
            }
        } else {
            this.setupNewMdiEditor(string, true, parser, null);
        }
        return bl;
    }

    private boolean setupNewSdiEditor(String string, boolean bl, Parser parser, Charset charset) {
        if (this._fileHolder != null && !this.closeFile()) {
            return false;
        }
        this._fileHolder = new FileHolder(string, this._editorPanel, bl, this, parser, charset);
        this._findReplaceDialog = null;
        this._fileHolder.getEditor().setDropTarget(new DropTarget(this._fileHolder.getEditor(), 1, this, true));
        this._fileHolder.getEditor().requestFocusInWindow();
        return true;
    }

    private void setupNewMdiEditor(String string, boolean bl, Parser parser, Charset charset) {
        JInternalFrame jInternalFrame = new JInternalFrame(string, true, true, true, true);
        FileHolder fileHolder = new FileHolder(string, jInternalFrame, bl, this, parser, charset);
        this._findReplaceDialog = null;
        this._fileTable.put(string, fileHolder);
        this._windowTable.put(jInternalFrame, fileHolder);
        this._fileList.add(jInternalFrame);
        fileHolder.getEditor().setDropTarget(new DropTarget(fileHolder.getEditor(), 1, this, true));
        fileHolder.getEditor().requestFocusInWindow();
        JMenuItem jMenuItem = new JMenuItem(this._fileList.size() - 1 + " " + string, 48 + this._fileList.size() - 1);
        this._windowMenu.insert(jMenuItem, this.windowMenuWindowOffset + this._fileList.size());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = ((JMenuItem)actionEvent.getSource()).getText();
                    string = string.substring(string.indexOf(" ") + 1);
                    FileHolder fileHolder = SCEditorFrame.this._fileTable.get(string);
                    fileHolder.getInternalFrame().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        this._editorPane.addCascaded(jInternalFrame, JLayeredPane.DEFAULT_LAYER);
        jInternalFrame.addPropertyChangeListener(this);
        jInternalFrame.addVetoableChangeListener(this);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void closeAllWindowsActionPerformed() {
        this.closeFile(true);
    }

    public boolean closeFile() {
        return this.closeFile(false);
    }

    boolean closeFile(boolean bl) {
        if (this._sdi) {
            if (this._fileHolder != null) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this._fileHolder, "closed", Boolean.FALSE, Boolean.TRUE);
                try {
                    this.vetoableChange(propertyChangeEvent);
                    this.propertyChange(propertyChangeEvent);
                    this._fileHolder.destroy();
                    this._fileHolder = null;
                    this.setTitle("");
                }
                catch (PropertyVetoException propertyVetoException) {
                    return false;
                }
            }
        } else {
            Component[] componentArray = this._editorPane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JInternalFrame) || !bl && !((JInternalFrame)componentArray[i]).isSelected()) continue;
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(componentArray[i], "closed", Boolean.FALSE, Boolean.TRUE);
                try {
                    this.vetoableChange(propertyChangeEvent);
                    this.propertyChange(propertyChangeEvent);
                    break;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return false;
                }
            }
        }
        return true;
    }

    public void saveFileAsActionPerformed() {
        String string = this.requestSaveFileName();
        if (string != null) {
            this.saveFile(string);
        }
    }

    @Override
    public void saveFile() {
        FileHolder fileHolder = null;
        fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            this.saveFile(null, fileHolder.getCharset());
        }
    }

    @Override
    public void saveFile(Charset charset) {
        this.saveFile(null, charset);
    }

    @Override
    public void saveFile(String string) {
        FileHolder fileHolder = null;
        fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        this.saveFile(string, fileHolder.getCharset());
    }

    @Override
    public void saveFile(String string, Charset charset) {
        block7: {
            FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
            String string2 = null;
            if (fileHolder != null) {
                if (string == null) {
                    string = fileHolder.getFileName();
                }
                if (string != null) {
                    if (!string.equals(fileHolder.getFileName())) {
                        string2 = fileHolder.getFileName();
                        fileHolder.setFileName(string);
                    }
                    try {
                        fileHolder.saveFile(charset);
                        if (this._sdi) {
                            this.setTitle(string);
                        }
                    }
                    catch (Exception exception) {
                        if (string2 == null) break block7;
                        fileHolder.setFileName(string2);
                    }
                }
            }
        }
    }

    public void saveAllActionPerformed() {
        if (!this._sdi) {
            try {
                this.getSelectedFrame().saveFile(null);
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
    }

    @Override
    public void print() {
        FileHolder fileHolder = null;
        fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.print();
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    public void undoActionPerformed() {
        FileHolder fileHolder = null;
        fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.cut();
            try {
                fileHolder.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.err.println("Unable to undo: " + cannotUndoException);
                ExceptionHandler.handleException((Throwable)cannotUndoException);
            }
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    public void redoActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.cut();
            try {
                fileHolder.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.err.println("Unable to redo: " + cannotRedoException);
                ExceptionHandler.handleException((Throwable)cannotRedoException);
            }
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    public void cutActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.cut();
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    public void copyActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.copy();
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    public void pasteActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.paste();
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    public void deleteActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            int n = fileHolder.getEditor().getSelectionStart();
            int n2 = fileHolder.getEditor().getSelectionEnd() - n;
            try {
                fileHolder.getEditor().getDocument().remove(n, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    public void selectAllActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.selectAll();
        }
    }

    public void goToLineActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.getEditor().goToLineActionPerformed();
        }
    }

    public void indentLeftActionPerformed() {
        Editor editor = this.getEditor();
        if (editor != null) {
            editor.indentText(false);
        }
    }

    public void indentRightActionPerformed() {
        Editor editor = this.getEditor();
        if (editor != null) {
            editor.indentText(true);
        }
    }

    public void addRemoveDoubleDashCommentActionPerformed() {
        Editor editor = this.getEditor();
        if (editor != null) {
            editor.addRemoveComment("--");
        }
    }

    public void addRemoveDoubleSlashCommentActionPerformed() {
        Editor editor = this.getEditor();
        if (editor != null) {
            editor.addRemoveComment("//");
        }
    }

    public void findReplaceActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.getEditor().requestFocusInWindow();
            try {
                int n = 17;
                if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 2) {
                    n = 17;
                } else if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4) {
                    n = 157;
                }
                Robot robot = new Robot();
                robot.keyPress(n);
                robot.keyPress(70);
                robot.keyRelease(n);
                robot.keyRelease(70);
            }
            catch (AWTException aWTException) {
                fileHolder.getEditor().findReplaceActionPerformed();
            }
        }
    }

    public void cascadeWindowActionPerformed() {
        this._editorPane.cascadeAll();
    }

    public void tileWindowsHorizontallyActionPerformed() {
        this._editorPane.tileAll();
    }

    public void tileWindowsVerticallyActionPerformed() {
        this._editorPane.tileAll();
    }

    public void windowsActionPerformed() {
    }

    public void helpActionPerformed() {
    }

    private FileHolder getSelectedFrame() {
        Component[] componentArray;
        for (Component component : componentArray = this._editorPane.getComponents()) {
            if (!(component instanceof JInternalFrame) || !((JInternalFrame)component).isSelected()) continue;
            return this._windowTable.get(component);
        }
        return null;
    }

    public void findNextActionPerformed() {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            if (this._findReplaceDialog == null) {
                this._findReplaceDialog = this.loadDialog("com.sybase.central.editor.FindReplaceDialog");
            }
            ((FindReplaceDialog)((Object)this._findReplaceDialog)).attachListener(fileHolder);
            ((FindReplaceDialog)((Object)this._findReplaceDialog)).downDirection.setSelected(true);
            if (((FindReplaceDialog)((Object)this._findReplaceDialog)).getSearchText() == null || ((FindReplaceDialog)((Object)this._findReplaceDialog)).getSearchText().length() == 0) {
                UIUtils.ensureWindowIsVisible((Window)this._findReplaceDialog);
                this._findReplaceDialog.setVisible(true);
            } else {
                ((FindReplaceDialog)((Object)this._findReplaceDialog)).find();
            }
        }
    }

    public void findInFilesActionPerformed() {
        if (this._findInFilesDialog == null) {
            try {
                Class<?> clazz = Class.forName("com.sybase.central.editor.FindInFilesDialog");
                Class[] classArray = new Class[]{Frame.class, JList.class, JList.class};
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                Object[] objectArray = new Object[]{this, this._findInFiles1List, this._findInFiles2List};
                this._findInFilesDialog = (JDialog)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UIUtils.ensureWindowIsVisible((Window)this._findInFilesDialog);
        this._findInFilesDialog.setVisible(true);
    }

    public void customizeActionPerformed() {
        if (this._customizeDialog == null) {
            this._customizeDialog = new CustomizeDialog((Frame)this);
            this._customizeDialog.addCustomizationPages((Customizable)this);
        }
        UIUtils.ensureWindowIsVisible((Window)this._customizeDialog);
        this._customizeDialog.setVisible(true);
    }

    public void nextWindowActionPerformed() {
        Component[] componentArray = this._editorPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JInternalFrame) || !((JInternalFrame)componentArray[i]).isSelected()) continue;
            try {
                this._fileList.get(this._fileList.indexOf(componentArray[i]) + 1).setSelected(true);
            }
            catch (Exception exception) {
                try {
                    this._fileList.get(0).setSelected(true);
                }
                catch (Exception exception2) {}
            }
            break;
        }
    }

    public void previousWindowActionPerformed() {
        Component[] componentArray = this._editorPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JInternalFrame) || !((JInternalFrame)componentArray[i]).isSelected()) continue;
            try {
                this._fileList.get(this._fileList.indexOf(componentArray[i]) - 1).setSelected(true);
            }
            catch (Exception exception) {
                try {
                    this._fileList.get(this._fileList.size() - 1).setSelected(true);
                }
                catch (Exception exception2) {}
            }
            break;
        }
    }

    private boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        if (!SCEditorProperties.getDragAndDropEditing()) {
            return false;
        }
        return (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) && (dropTargetDragEvent.getDropAction() & 1) == 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragESCEditorFrameImages(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block10: {
            if (!SCEditorProperties.getDragAndDropEditing()) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            if (!dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && !dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor) && (dropTargetDropEvent.getDropAction() & 1) == 0) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            int n = dropTargetDropEvent.getSourceActions();
            if ((n & 1) == 0) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            try {
                dropTargetDropEvent.acceptDrop(1);
                if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    Object object = dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (object instanceof List) {
                        List list = (List)object;
                        int n2 = list.size();
                        for (int i = 0; i < n2; ++i) {
                            File file = (File)list.get(i);
                            String string = file.getCanonicalPath();
                            this.openFile(string);
                        }
                        break block10;
                    }
                    throw new NullPointerException();
                }
                if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Object object = dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (object instanceof String) {
                        this.setText((String)object);
                        break block10;
                    }
                    throw new NullPointerException();
                }
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            catch (Throwable throwable) {
                ExceptionHandler.handleException((Throwable)throwable);
                dropTargetDropEvent.dropComplete(false);
                return;
            }
        }
        dropTargetDropEvent.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private JDialog loadDialog(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Frame.class};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            return (JDialog)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
            return null;
        }
    }

    public void aboutActionPerformed() {
        if (this._defaultAboutDialog == null) {
            this._defaultAboutDialog = this.loadDialog("com.sybase.central.editor.AboutDialog");
        }
        UIUtils.ensureWindowIsVisible((Window)this._defaultAboutDialog);
        this._defaultAboutDialog.setVisible(true);
    }

    @Override
    public void setText(String string) {
        if (this._sdi) {
            if (this._fileHolder == null && this.createNewFile(null, null)) {
                this._readOnlyLabel.setEnabled(false);
            }
            this._fileHolder.setText(string);
        } else {
            this.getSelectedFrame().setText(string);
        }
    }

    @Override
    public void setText(String string, Parser parser) {
        if (this._sdi) {
            if (this._fileHolder == null && this.createNewFile(null, parser)) {
                this._readOnlyLabel.setEnabled(false);
            }
            this._fileHolder.setText(string, parser);
        } else {
            this.getSelectedFrame().setText(string, parser);
        }
    }

    @Override
    public String getText() {
        if (this._sdi) {
            if (this._fileHolder != null) {
                return this._fileHolder.getText();
            }
        } else if (this.getSelectedFrame() != null) {
            return this.getSelectedFrame().getText();
        }
        return null;
    }

    @Override
    public Editor getEditor() {
        if (this._sdi) {
            if (this._fileHolder != null) {
                return this._fileHolder.getEditor();
            }
        } else if (this.getSelectedFrame() != null) {
            return this.getSelectedFrame().getEditor();
        }
        return null;
    }

    @Override
    public void setChanged(boolean bl) {
        if (this._sdi) {
            if (this._fileHolder != null) {
                this._fileHolder.setChanged(bl);
            }
        } else {
            this.getSelectedFrame().setChanged(bl);
        }
    }

    @Override
    public boolean isChanged() {
        if (this._sdi) {
            if (this._fileHolder != null) {
                return this._fileHolder.isChanged();
            }
        } else if (this.getSelectedFrame() != null) {
            return this.getSelectedFrame().isChanged();
        }
        return false;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this._menuBar;
    }

    @Override
    public void setTitle(String string) {
        this.setTitle(string, true);
    }

    protected void setTitle(String string, boolean bl) {
        super.setTitle(string);
        if (bl) {
            this._title = string;
        }
    }

    @Override
    public JToolBar getToolBar() {
        return this._toolBar;
    }

    @Override
    public void setSaveTitle(String string) {
        this._saveTitle = string;
        this._saveAction.putValue("Name", this._saveTitle);
        this._saveButton.setText("");
        this._saveMenuItem.setText(this._saveTitle);
    }

    @Override
    public String getSaveTitle() {
        return this._saveTitle;
    }

    @Override
    public void setSaveMnemonic(char c) {
        this._saveMnemonic = c;
        if (this._saveMnemonic != '\u0000') {
            this._saveButton.setMnemonic(this._saveMnemonic);
            this._saveMenuItem.setMnemonic(this._saveMnemonic);
        }
    }

    @Override
    public char getSaveMnemonic() {
        return this._saveMnemonic;
    }

    @Override
    public void setSaveIcon(ImageIcon imageIcon) {
        if (imageIcon == null) {
            imageIcon = SCEditorImageLoader.getImageIcon("blank", 1004);
        }
        this._saveIcon = imageIcon;
        this._saveButton.setIcon(this._saveIcon);
        this._saveMenuItem.setIcon(this._saveIcon);
    }

    @Override
    public ImageIcon getSaveIcon() {
        return this._saveIcon;
    }

    @Override
    public void setSaveToolTip(String string) {
        this.setSaveLongDescription(string);
    }

    @Override
    public String getSaveToolTip() {
        return this.getSaveLongDescription();
    }

    @Override
    public void setSaveShortDescription(String string) {
        this._saveShortDescription = string;
        this._saveAction.putValue("ShortDescription", this._saveShortDescription);
        this._saveButton.setToolTipText(this._saveShortDescription);
    }

    @Override
    public String getSaveShortDescription() {
        return this._saveShortDescription;
    }

    @Override
    public void setSaveLongDescription(String string) {
        this._saveLongDescription = string;
        this._saveAction.putValue("LongDescription", string);
    }

    @Override
    public String getSaveLongDescription() {
        return this._saveLongDescription;
    }

    @Override
    public void setSaveAccelerator(KeyStroke keyStroke) {
        this._saveAccelerator = keyStroke;
    }

    @Override
    public KeyStroke getSaveAccelerator() {
        return this._saveAccelerator;
    }

    @Override
    public void setSave(String string, char c, ImageIcon imageIcon, String string2) {
        this.setSave(string, c, imageIcon, string, string2, null);
    }

    @Override
    public void setSave(String string, char c, ImageIcon imageIcon, String string2, KeyStroke keyStroke) {
        this.setSave(string, c, imageIcon, string, string2, keyStroke);
    }

    @Override
    public void setSave(String string, char c, ImageIcon imageIcon, String string2, String string3) {
        this.setSave(string, c, imageIcon, string2, string3, null);
    }

    @Override
    public void setSave(String string, char c, ImageIcon imageIcon, String string2, String string3, KeyStroke keyStroke) {
        if (imageIcon == null) {
            imageIcon = SCEditorImageLoader.getImageIcon("blank", 1004);
        }
        this._saveTitle = string;
        this._saveMnemonic = c;
        this._saveIcon = imageIcon;
        this._saveShortDescription = string2;
        this._saveLongDescription = string3;
        this._saveAccelerator = keyStroke;
        this._saveAction.putValue("Name", this._saveTitle);
        this._saveAction.putValue("SmallIcon", this._saveIcon);
        this._saveAction.putValue("ShortDescription", this._saveShortDescription);
        this._saveAction.putValue("LongDescription", this._saveLongDescription);
        this._saveButton.setText("");
        if (this._saveMnemonic != '\u0000') {
            this._saveButton.setMnemonic(this._saveMnemonic);
        }
        this._saveButton.setIcon(this._saveIcon);
        this._saveButton.setToolTipText(this._saveShortDescription);
        this._saveMenuItem.setText(this._saveTitle);
        if (this._saveMnemonic != '\u0000') {
            this._saveMenuItem.setMnemonic(this._saveMnemonic);
        }
        this._saveMenuItem.setIcon(this._saveIcon);
        this._saveMenuItem.setAccelerator(this._saveAccelerator);
    }

    @Override
    public void setExitTitle(String string) {
        this._exitTitle = string;
        this._exitAction.putValue("Name", this._exitTitle);
        this._exitButton.setText("");
        this._exitMenuItem.setText(this._exitTitle);
    }

    @Override
    public String getExitTitle() {
        return this._exitTitle;
    }

    @Override
    public void setExitMnemonic(char c) {
        this._exitMnemonic = c;
        if (this._exitMnemonic != '\u0000') {
            this._exitButton.setMnemonic(this._exitMnemonic);
            this._exitMenuItem.setMnemonic(this._exitMnemonic);
        }
    }

    @Override
    public char getExitMnemonic() {
        return this._exitMnemonic;
    }

    @Override
    public void setExitIcon(ImageIcon imageIcon) {
        if (imageIcon == null) {
            imageIcon = SCEditorImageLoader.getImageIcon("blank", 1004);
        }
        this._exitIcon = imageIcon;
        this._exitButton.setIcon(this._exitIcon);
        this._exitMenuItem.setIcon(this._exitIcon);
    }

    @Override
    public ImageIcon getExitIcon() {
        return this._exitIcon;
    }

    @Override
    public void setExitToolTip(String string) {
        this.setExitLongDescription(string);
    }

    @Override
    public String getExitToolTip() {
        return this._exitLongDescription;
    }

    @Override
    public void setExitShortDescription(String string) {
        this._exitShortDescription = string;
        this._exitAction.putValue("ShortDescription", this._exitShortDescription);
        this._exitButton.setToolTipText(this._exitShortDescription);
    }

    @Override
    public String getExitShortDescription() {
        return this._exitShortDescription;
    }

    @Override
    public void setExitLongDescription(String string) {
        this._exitLongDescription = string;
        this._exitAction.putValue("LongDescription", this._exitLongDescription);
    }

    @Override
    public String getExitLongDescription() {
        return this._exitLongDescription;
    }

    @Override
    public void setExitAccelerator(KeyStroke keyStroke) {
        this._exitAccelerator = keyStroke;
    }

    @Override
    public KeyStroke getExitAccelerator() {
        return this._exitAccelerator;
    }

    @Override
    public void setExit(String string, char c, ImageIcon imageIcon, String string2) {
        this.setExit(string, c, imageIcon, string, string2, null);
    }

    @Override
    public void setExit(String string, char c, ImageIcon imageIcon, String string2, KeyStroke keyStroke) {
        this.setExit(string, c, imageIcon, string, string2, keyStroke);
    }

    @Override
    public void setExit(String string, char c, ImageIcon imageIcon, String string2, String string3) {
        this.setExit(string, c, imageIcon, string2, string3, null);
    }

    @Override
    public void setExit(String string, char c, ImageIcon imageIcon, String string2, String string3, KeyStroke keyStroke) {
        if (imageIcon == null) {
            imageIcon = SCEditorImageLoader.getImageIcon("blank", 1004);
        }
        this._exitTitle = string;
        this._exitMnemonic = c;
        this._exitIcon = imageIcon;
        this._exitShortDescription = string2;
        this._exitLongDescription = string3;
        this._exitAccelerator = keyStroke;
        this._exitAction.putValue("Name", this._exitTitle);
        this._exitAction.putValue("SmallIcon", this._exitIcon);
        this._exitAction.putValue("ShortDescription", this._exitShortDescription);
        this._exitAction.putValue("LongDescription", this._exitLongDescription);
        this._exitButton.setText("");
        if (this._exitMnemonic != '\u0000') {
            this._exitButton.setMnemonic(this._exitMnemonic);
        }
        this._exitButton.setIcon(this._exitIcon);
        this._exitButton.setToolTipText(this._exitShortDescription);
        this._exitMenuItem.setText(this._exitTitle);
        if (this._exitMnemonic != '\u0000') {
            this._exitMenuItem.setMnemonic(this._exitMnemonic);
        }
        this._exitMenuItem.setIcon(this._exitIcon);
        this._exitMenuItem.setAccelerator(this._exitAccelerator);
    }

    @Override
    public void addEditorListener(EditorListener editorListener) {
        this._listenerList.add(EditorListener.class, editorListener);
    }

    @Override
    public void removeEditorListener(EditorListener editorListener) {
        this._listenerList.remove(EditorListener.class, editorListener);
    }

    public void fireSave() {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != EditorListener.class) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this._editorEvent == null) {
                this._editorEvent = new EditorEvent(this);
            }
            this._editorEvent.setEditor(this);
            ((EditorListener)objectArray[i + 1]).editorSaveRequested(this._editorEvent);
        }
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.getEditor().requestFocusInWindow();
        }
    }

    protected void fireEditorClosed() {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != EditorListener.class) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this._editorEvent == null) {
                this._editorEvent = new EditorEvent(this);
            }
            this._editorEvent.setEditor(this);
            ((EditorListener)objectArray[i + 1]).editorClosed(this._editorEvent);
        }
    }

    @Override
    public void setEditable(boolean bl) {
        if (this._sdi) {
            if (this._fileHolder != null) {
                this._fileHolder.setEditable(bl);
            }
        } else {
            this.getSelectedFrame().setEditable(bl);
        }
        this._readOnlyLabel.setEnabled(!bl);
        this._cutAction.setEnabled(bl);
        this._pasteAction.setEnabled(bl);
        this._deleteAction.setEnabled(bl);
    }

    @Override
    public boolean isEditable() {
        if (this._sdi) {
            if (this._fileHolder != null) {
                return this._fileHolder.isEditable();
            }
        } else if (this.getSelectedFrame() != null) {
            return this.getSelectedFrame().isEditable();
        }
        return true;
    }

    @Override
    public String getFileName() {
        String string = "";
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            string = fileHolder.getFileName();
        }
        return string;
    }

    @Override
    public void setFileName(String string) {
        FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
        if (fileHolder != null) {
            fileHolder.setFileName(string);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (!this._formCreationInProgress) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n < SCEditorFrame._minimumSize.width) {
                n = SCEditorFrame._minimumSize.width;
            }
            if (n2 < SCEditorFrame._minimumSize.height) {
                n2 = SCEditorFrame._minimumSize.height;
            }
            SCEditorProperties.setFrameWidth(n);
            SCEditorProperties.setFrameHeight(n2);
            SCEditorProperties.store();
            if (!this._sdi) {
                if (this._bottomPaneHeight == 0) {
                    this._bottomPaneHeight = this._splitPane.getBottomComponent().getHeight();
                }
                this._ignoreSplitPanePropertyChange = true;
                this._splitPane.setDividerLocation(this._splitPane.getHeight() - this._bottomPaneHeight - this._splitPane.getDividerSize());
            }
            this.setBounds(this.getX(), this.getY(), SCEditorProperties.getFrameWidth(), SCEditorProperties.getFrameHeight());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        block11: {
            Component component = mouseEvent.getComponent();
            if (component instanceof JMenuItem || component instanceof SybMenuItem) {
                this._statusText.setText("");
            } else if (component instanceof JList && mouseEvent.getClickCount() > 1) {
                try {
                    JList jList = (JList)component;
                    Object e = jList.getSelectedValue();
                    if (e == null) break block11;
                    String string = e.toString();
                    int n = string.indexOf(40);
                    String string2 = string.substring(0, n);
                    this.openFile(string2);
                    int n2 = 1;
                    int n3 = 1;
                    String string3 = string.substring(n + 1);
                    n = string3.indexOf(41);
                    string3 = string3.substring(0, n);
                    n = string3.indexOf(44);
                    if (n > -1) {
                        string3 = string3.substring(0, n);
                        String string4 = string3.substring(n + 1);
                        try {
                            n3 = Integer.parseInt(string4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        n2 = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FileHolder fileHolder = this._sdi ? this._fileHolder : this.getSelectedFrame();
                    if (fileHolder != null) {
                        fileHolder.getEditor().getCaret().setVisible(true);
                        fileHolder.getEditor().requestFocusInWindow();
                        fileHolder.goTo(n2, n3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof JMenuItem || component instanceof SybMenuItem) {
            Object object;
            Action action;
            String string = ((JMenuItem)component).getToolTipText();
            if ((string == null || string.length() == 0) && (action = ((JMenuItem)component).getAction()) != null && (object = action.getValue("LongDescription")) != null) {
                string = object.toString();
            }
            this._statusText.setText(string);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof JMenuItem || component instanceof SybMenuItem) {
            this._statusText.setText("");
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof JMenuItem || component instanceof SybMenuItem) {
            this._statusText.setText("");
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if ((component instanceof JMenuItem || component instanceof SybMenuItem) && this._statusText != null) {
            this._statusText.setText("");
        }
    }

    @Override
    public JMenu getHelpMenu() {
        return this._helpMenu;
    }

    @Override
    public void setHelpMenu(JMenu jMenu) {
        this._helpMenu = (SybMenu)jMenu;
        this._showHelpMenu = this._helpMenu != null;
    }

    @Override
    public boolean isOkToClose() {
        if (this._sdi) {
            if (this._fileHolder != null) {
                return !this._fileHolder.isChanged();
            }
        } else {
            Component[] componentArray = this._editorPane.getComponents();
            boolean bl = false;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JInternalFrame)) continue;
                bl = bl || this._windowTable.get(componentArray[i]).isChanged();
            }
            return !bl;
        }
        return true;
    }

    @Override
    public void addAction(Action action, KeyStroke keyStroke) {
        this.addAction(action, keyStroke, this._toolsMenu, true);
    }

    @Override
    public void addAction(Action[] actionArray, KeyStroke[] keyStrokeArray) {
        boolean bl = true;
        int n = actionArray.length;
        for (int i = 0; i < n; ++i) {
            this.addAction(actionArray[i], keyStrokeArray[i], this._toolsMenu, bl);
            bl = false;
        }
    }

    @Override
    public void addHelpAction(Action action, KeyStroke keyStroke) {
        this.addHelpAction(action, keyStroke, false);
    }

    @Override
    public void addHelpAction(Action action, KeyStroke keyStroke, boolean bl) {
        if (this._helpMenu == null) {
            this._helpMenu = new SybMenu(ResourceManager.getI18NMessage("Help"));
            this._menuBar.add((JMenu)this._helpMenu);
        } else if (bl) {
            this._helpMenu.removeAll();
        }
        this.addAction(action, keyStroke, this._helpMenu, !bl);
    }

    @Override
    public void addHelpAction(Action[] actionArray, KeyStroke[] keyStrokeArray) {
        this.addHelpAction(actionArray, keyStrokeArray, false);
    }

    @Override
    public void addHelpAction(Action[] actionArray, KeyStroke[] keyStrokeArray, boolean bl) {
        boolean bl2 = true;
        if (this._helpMenu == null) {
            this._helpMenu = new SybMenu(ResourceManager.getI18NMessage("Help"));
            this._menuBar.add((JMenu)this._helpMenu);
            bl2 = false;
        } else if (bl) {
            this._helpMenu.removeAll();
            bl2 = false;
        }
        int n = actionArray.length;
        for (int i = 0; i < n; ++i) {
            this.addAction(actionArray[i], keyStrokeArray[i], this._helpMenu, bl2);
            bl2 = false;
        }
    }

    private void addAction(Action action, KeyStroke keyStroke, SybMenu sybMenu, boolean bl) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon == null) {
            action.putValue("SmallIcon", SCEditorImageLoader.getImageIcon("blank", 1004));
        }
        if (bl) {
            sybMenu.addSeparator();
        }
        this.addMenuItem(sybMenu, action, keyStroke);
        if (icon != null) {
            if (bl) {
                this._toolBar.addSeparator();
            }
            this.addToolbarButton(action);
            this._toolBar.updateUI();
        }
    }

    public void printingStarted() {
        this._printAction.setEnabled(false);
        this._printAnimationFrame = 0;
        if (this._printAnimationTimer == null) {
            this._printAnimationTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ++SCEditorFrame.this._printAnimationFrame;
                    SCEditorFrame.this._printStatus.setIcon((Icon)SCEditorFrame.this._printAnimationArray[SCEditorFrame.this._printAnimationFrame % SCEditorFrame.this._printAnimationArray.length]);
                }
            });
            this._printAnimationTimer.setInitialDelay(0);
            this._printAnimationTimer.setRepeats(true);
            this._printAnimationTimer.setCoalesce(true);
        }
        this._printAnimationTimer.start();
        this._printStatus.setText("");
        this._printStatus.setVisible(true);
    }

    public void printingStopped() {
        this._printStatus.setVisible(false);
        this._printAction.setEnabled(true);
        this._printAnimationTimer.stop();
    }

    public void printingPage(int n) {
        this._printStatus.setText(String.valueOf(n));
    }

    public void printerException(PrinterException printerException) {
    }

    @Override
    public void setCurrentDirectory(File file) {
        this._currentDirectory = file;
    }

    @Override
    public File getCurrentDirectory() {
        return this._currentDirectory;
    }

    @Override
    public void setDefaultExtension(String string) {
        this._defaultExtension = string;
    }

    @Override
    public String getDefaultExtension() {
        return this._defaultExtension;
    }

    public CustomizationPage[] getCustomizationPages() {
        CustomizationPage[] customizationPageArray = new CustomizationPage[]{new EditorCustomizationPage(), new TabsCustomizationPage(), new FormatCustomizationPage(), new PrintCustomizationPage()};
        return customizationPageArray;
    }

    public Icon getCustomizationGroupIcon() {
        return SCEditor.EDITOR_ICON;
    }

    public String getCustomizationGroupTitle() {
        return ResourceManager.getI18NMessage("customizationGroupTitle");
    }

    public void acceptChanges() {
        SCEditorProperties.store();
        if (this.getEditor() != null) {
            ((SCEditor)this.getEditor()).acceptChanges();
        }
    }

    public void rejectChanges() {
        if (this.getEditor() != null) {
            ((SCEditor)this.getEditor()).rejectChanges();
        }
    }

    public CustomizerHost getCustomizerHost() {
        return null;
    }

    public void setCustomizerHost(CustomizerHost customizerHost) {
    }

    public static void setHelpFolder(String string, String string2, String string3) {
        SCEditor.setHelpFolder(string, string2, string3);
    }

    @Override
    public void loadFailed(Throwable throwable, Editor editor) {
        if (throwable instanceof OutOfMemoryError) {
            System.gc();
            editor.setText("");
            SybOptionPane.showOptionDialog((Component)this, (Object)ResourceManager.getI18NMessage("OUT_OF_MEMORY_ON_LOAD"), (String)ResourceManager.getI18NMessage("OUT_OF_MEMORY_TITLE"), (int)0, (int)0, null, (Object[])this._okOptions, (Object)this._okOptions[0]);
        }
    }
}

