/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCEditor;
import com.sybase.util.Platform;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.UIManager;

class SCEditorProperties {
    static final int NONE = 0;
    static final int DEFAULT = 1;
    static final int SMART = 3;
    private static String _propertyFileName = Platform.getUserConfigurationDirectory() + ".SybaseCentralEditor600";
    private static String _pathSeparator = System.getProperty("path.separator");
    private static boolean _dirty = false;
    private static boolean _loaded = false;
    private static String[] _recentFiles = new String[]{null};
    private static boolean _verticalScrollBar = true;
    private static boolean _horizontalScrollBar = true;
    private static boolean _dragAndDropEditing = true;
    private static int _tabSize = 8;
    private static int _indentSize = 4;
    private static boolean _keepTabs = false;
    private static int _autoIndent = 0;
    private static boolean _smartIndentOpenBrace = false;
    private static boolean _smartIndentClosingBrace = false;
    private static String _font = "Monospaced";
    private static int _fontSize = SCEditor.isWindows() ? UIManager.getDefaults().getFont("TextArea.font").getSize() * 3 / 4 : UIManager.getDefaults().getFont("TextArea.font").getSize();
    private static Color _caretColor = SystemColor.textText;
    private static Color _breakPointMarginForeground = SystemColor.controlText;
    private static Color _breakPointMarginBackground = SystemColor.controlHighlight;
    private static Color _textSelectionForeground = SystemColor.textHighlightText;
    private static Color _textSelectionBackground = SystemColor.textHighlight;
    private static Color _textForeground = SystemColor.textText;
    private static Color _textBackground = SystemColor.window;
    private static int _textStyle = 0;
    private static Color _keywordsForeground = Color.blue;
    private static Color _keywordsBackground = SystemColor.window;
    private static int _keywordsStyle = 0;
    private static Color _commentForeground = Color.green.darker();
    private static Color _commentBackground = SystemColor.window;
    private static int _commentStyle = 0;
    private static Color _formalCommentForeground = Color.magenta;
    private static Color _formalCommentBackground = SystemColor.window;
    private static int _formalCommentStyle = 0;
    private static Color _numberForeground = Color.blue;
    private static Color _numberBackground = SystemColor.window;
    private static int _numberStyle = 0;
    private static Color _stringForeground = Color.red;
    private static Color _stringBackground = SystemColor.window;
    private static Color _openStringForeground = SystemColor.window;
    private static Color _openStringBackground = Color.red;
    private static int _stringStyle = 0;
    private static int _openStringStyle = 0;
    private static Color _operatorsForeground = SystemColor.textText;
    private static Color _operatorsBackground = SystemColor.window;
    private static int _operatorsStyle = 0;
    private static Color _punctuationForeground = SystemColor.textText;
    private static Color _punctuationBackground = SystemColor.window;
    private static int _punctuationStyle = 0;
    private static Color _htmlElementNameForeground = SystemColor.textText;
    private static Color _htmlElementNameBackground = SystemColor.window;
    private static int _htmlElementNameStyle = 0;
    private static Color _htmlAttributeNameForeground = SystemColor.textText;
    private static Color _htmlAttributeNameBackground = SystemColor.window;
    private static int _htmlAttributeNameStyle = 0;
    private static Color _htmlAttributeValueForeground = SystemColor.textText;
    private static Color _htmlAttributeValueBackground = SystemColor.window;
    private static int _htmlAttributeValueStyle = 0;
    private static Color _htmlCommentForeground = SystemColor.textText;
    private static Color _htmlCommentBackground = SystemColor.window;
    private static int _htmlCommentStyle = 0;
    private static Color _htmlTagDelimiterForeground = SystemColor.textText;
    private static Color _htmlTagDelimiterBackground = SystemColor.window;
    private static int _htmlTagDelimiterStyle = 0;
    private static Color _htmlOperatorForeground = SystemColor.textText;
    private static Color _htmlOperatorBackground = SystemColor.window;
    private static int _htmlOperatorStyle = 0;
    private static String _printHeader = "";
    private static String _printFooter = "";
    private static int _printFontSize = _fontSize;
    private static int _frameX = 0;
    private static int _frameY = 0;
    private static int _frameWidth = 400;
    private static int _frameHeight = 400;
    private static int _dividerLocation = 100;
    private static String _findInFilesWhat = "";
    private static String _findInFilesType = "";
    private static String _findInFilesFolder = "";
    private static boolean _findInFilesMatchWholeWord = false;
    private static boolean _findInFilesMatchCase = false;
    private static boolean _findInFilesLookInSubfolders = false;
    private static boolean _findInFilesOutputToPane2 = false;
    private static final String EDITOR_VERTICAL_SCROLLBAR = "SybaseCentralEditor.Editor.verticalScrollBar";
    private static final String EDITOR_HORIZONTAL_SCROLLBAR = "SybaseCentralEditor.Editor.horizontalScrollBar";
    private static final String EDITOR_DRAG_AND_DROP_EDITING = "SybaseCentralEditor.Editor.dragAndDropEditing";
    private static final String TABS_TAB_SIZE = "SybaseCentralEditor.Tabs.tabSize";
    private static final String TABS_INDENT_SIZE = "SybaseCentralEditor.Tabs.indentSize";
    private static final String EDITOR_KEEP_TABS = "SybaseCentralEditor.Editor.keepTabs";
    private static final String TABS_AUTO_INDENT = "SybaseCentralEditor.Tabs.autoIndent";
    private static final String EDITOR_SMART_INDENT_OPEN_BRACE = "SybaseCentralEditor.Editor.smartIndentOpenBrace";
    private static final String EDITOR_SMART_INDENT_CLOSING_BRACE = "SybaseCentralEditor.Editor.smartIndentClosingBrace";
    private static final String FORMAT_FONT = "SybaseCentralEditor.Format.font";
    private static final String FORMAT_FONT_SIZE = "SybaseCentralEditor.Format.fontSize";
    private static final String FORMAT_CARET_COLOR = "SybaseCentralEditor.Format.caretColor";
    private static final String FORMAT_BREAK_POINT_MARGIN_FOREGROUND = "SybaseCentralEditor.Format.breakPointMargin.foreground";
    private static final String FORMAT_BREAK_POINT_MARGIN_BACKGROUND = "SybaseCentralEditor.Format.breakPointMargin.background";
    private static final String FORMAT_TEXT_SELECTION_FOREGROUND = "SybaseCentralEditor.Format.textSelection.foreground";
    private static final String FORMAT_TEXT_SELECTION_BACKGROUND = "SybaseCentralEditor.Format.textSelection.background";
    private static final String FORMAT_TEXT_FOREGROUND = "SybaseCentralEditor.Format.text.foreground";
    private static final String FORMAT_TEXT_BACKGROUND = "SybaseCentralEditor.Format.text.background";
    private static final String FORMAT_TEXT_STYLE = "SybaseCentralEditor.Format.text.style";
    private static final String FORMAT_KEYWORDS_FOREGROUND = "SybaseCentralEditor.Format.keywords.foreground";
    private static final String FORMAT_KEYWORDS_BACKGROUND = "SybaseCentralEditor.Format.keywords.background";
    private static final String FORMAT_KEYWORDS_STYLE = "SybaseCentralEditor.Format.keywords.style";
    private static final String FORMAT_COMMENT_FOREGROUND = "SybaseCentralEditor.Format.comment.foreground";
    private static final String FORMAT_COMMENT_BACKGROUND = "SybaseCentralEditor.Format.comment.background";
    private static final String FORMAT_COMMENT_STYLE = "SybaseCentralEditor.Format.comment.style";
    private static final String FORMAT_FORMAL_COMMENT_FOREGROUND = "SybaseCentralEditor.Format.formalComment.foreground";
    private static final String FORMAT_FORMAL_COMMENT_BACKGROUND = "SybaseCentralEditor.Format.formalComment.background";
    private static final String FORMAT_FORMAL_COMMENT_STYLE = "SybaseCentralEditor.Format.formalComment.style";
    private static final String FORMAT_NUMBER_FOREGROUND = "SybaseCentralEditor.Format.number.foreground";
    private static final String FORMAT_NUMBER_BACKGROUND = "SybaseCentralEditor.Format.number.background";
    private static final String FORMAT_NUMBER_STYLE = "SybaseCentralEditor.Format.number.style";
    private static final String FORMAT_STRING_FOREGROUND = "SybaseCentralEditor.Format.string.foreground";
    private static final String FORMAT_STRING_BACKGROUND = "SybaseCentralEditor.Format.string.background";
    private static final String FORMAT_OPEN_STRING_FOREGROUND = "SybaseCentralEditor.Format.openString.foreground";
    private static final String FORMAT_OPEN_STRING_BACKGROUND = "SybaseCentralEditor.Format.openString.background";
    private static final String FORMAT_STRING_STYLE = "SybaseCentralEditor.Format.string.style";
    private static final String FORMAT_OPEN_STRING_STYLE = "SybaseCentralEditor.Format.openString.style";
    private static final String FORMAT_OPERATORS_FOREGROUND = "SybaseCentralEditor.Format.operators.foreground";
    private static final String FORMAT_OPERATORS_BACKGROUND = "SybaseCentralEditor.Format.operators.background";
    private static final String FORMAT_OPERATORS_STYLE = "SybaseCentralEditor.Format.operators.style";
    private static final String FORMAT_PUNCTUATION_FOREGROUND = "SybaseCentralEditor.Format.punctuation.foreground";
    private static final String FORMAT_PUNCTUATION_BACKGROUND = "SybaseCentralEditor.Format.punctuation.background";
    private static final String FORMAT_PUNCTUATION_STYLE = "SybaseCentralEditor.Format.punctuation.style";
    private static final String FORMAT_HTML_ELEMENT_NAME_FOREGROUND = "SybaseCentralEditor.Format.htmlElementName.foreground";
    private static final String FORMAT_HTML_ELEMENT_NAME_BACKGROUND = "SybaseCentralEditor.Format.htmlElementName.background";
    private static final String FORMAT_HTML_ELEMENT_NAME_STYLE = "SybaseCentralEditor.Format.htmlElementName.style";
    private static final String FORMAT_HTML_ATTRIBUTE_NAME_FOREGROUND = "SybaseCentralEditor.Format.htmlAttributeName.foreground";
    private static final String FORMAT_HTML_ATTRIBUTE_NAME_BACKGROUND = "SybaseCentralEditor.Format.htmlAttributeName.background";
    private static final String FORMAT_HTML_ATTRIBUTE_NAME_STYLE = "SybaseCentralEditor.Format.htmlAttributeName.style";
    private static final String FORMAT_HTML_ATTRIBUTE_VALUE_FOREGROUND = "SybaseCentralEditor.Format.htmlAttributeValue.foreground";
    private static final String FORMAT_HTML_ATTRIBUTE_VALUE_BACKGROUND = "SybaseCentralEditor.Format.htmlAttributeValue.background";
    private static final String FORMAT_HTML_ATTRIBUTE_VALUE_STYLE = "SybaseCentralEditor.Format.htmlAttributeValue.style";
    private static final String FORMAT_HTML_COMMENT_FOREGROUND = "SybaseCentralEditor.Format.htmlComment.foreground";
    private static final String FORMAT_HTML_COMMENT_BACKGROUND = "SybaseCentralEditor.Format.htmlComment.background";
    private static final String FORMAT_HTML_COMMENT_STYLE = "SybaseCentralEditor.Format.htmlComment.style";
    private static final String FORMAT_HTML_TAG_DELIMITER_FOREGROUND = "SybaseCentralEditor.Format.htmlTagDelimiter.foreground";
    private static final String FORMAT_HTML_TAG_DELIMITER_BACKGROUND = "SybaseCentralEditor.Format.htmlTagDelimiter.background";
    private static final String FORMAT_HTML_TAG_DELIMITER_STYLE = "SybaseCentralEditor.Format.htmlTagDelimiter.style";
    private static final String FORMAT_HTML_OPERATOR_FOREGROUND = "SybaseCentralEditor.Format.htmlOperator.foreground";
    private static final String FORMAT_HTML_OPERATOR_BACKGROUND = "SybaseCentralEditor.Format.htmlOperator.background";
    private static final String FORMAT_HTML_OPERATOR_STYLE = "SybaseCentralEditor.Format.htmlOperator.style";
    private static final String FORMAT_PRINT_FONT_SIZE = "SybaseCentralEditor.Format.printFontSize";
    private static final String FORMAT_PRINT_HEADER = "SybaseCentralEditor.Format.printHeader";
    private static final String FORMAT_PRINT_FOOTER = "SybaseCentralEditor.Format.printFooter";
    private static final String FRAME_X = "SybaseCentralEditor.Frame.x";
    private static final String FRAME_Y = "SybaseCentralEditor.Frame.y";
    private static final String FRAME_WIDTH = "SybaseCentralEditor.Frame.width";
    private static final String FRAME_HEIGHT = "SybaseCentralEditor.Frame.height";
    private static final String EDITOR_DIVIDER_LOCATION = "SybaseCentralEditor.Editor.dividerLocation";
    private static final String FIND_IN_FILES_WHAT = "SybaseCentralEditor.FindInFiles.what";
    private static final String FIND_IN_FILES_TYPE = "SybaseCentralEditor.FindInFiles.type";
    private static final String FIND_IN_FILES_FOLDER = "SybaseCentralEditor.FindInFiles.folder";
    private static final String FIND_IN_FILES_MATCH_WHOLE_WORD = "SybaseCentralEditor.FindInFiles.matchWholeWord";
    private static final String FIND_IN_FILES_MATCH_CASE = "SybaseCentralEditor.FindInFiles.matchCase";
    private static final String FIND_IN_FILES_LOOK_IN_SUBFOLDERS = "SybaseCentralEditor.FindInFiles.lookInSubfolders";
    private static final String FIND_IN_FILES_OUTPUT_TO_PANE_2 = "SybaseCentralEditor.FindInFiles.outputToPane2";
    private static final String RECENT_FILES = "SybaseCentralEditor.recentFiles";

    SCEditorProperties() {
    }

    static void load() {
        if (_loaded) {
            return;
        }
        _loaded = true;
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load(new BufferedInputStream(new FileInputStream(_propertyFileName)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(properties);
        SCEditorProperties.reset();
    }

    static void store() {
        if (_dirty) {
            _dirty = false;
            try {
                Serializable serializable;
                if (_recentFiles == null) {
                    System.setProperty(RECENT_FILES, "");
                } else {
                    serializable = new StringBuffer();
                    for (String string : _recentFiles) {
                        ((StringBuffer)serializable).append(string).append(_pathSeparator);
                    }
                    System.setProperty(RECENT_FILES, ((StringBuffer)serializable).toString());
                }
                System.setProperty(EDITOR_VERTICAL_SCROLLBAR, String.valueOf(_verticalScrollBar));
                System.setProperty(EDITOR_HORIZONTAL_SCROLLBAR, String.valueOf(_horizontalScrollBar));
                System.setProperty(EDITOR_DRAG_AND_DROP_EDITING, String.valueOf(_dragAndDropEditing));
                System.setProperty(TABS_TAB_SIZE, String.valueOf(_tabSize));
                System.setProperty(TABS_INDENT_SIZE, String.valueOf(_indentSize));
                System.setProperty(EDITOR_KEEP_TABS, String.valueOf(_keepTabs));
                System.setProperty(TABS_AUTO_INDENT, String.valueOf(_autoIndent));
                System.setProperty(EDITOR_SMART_INDENT_OPEN_BRACE, String.valueOf(_smartIndentOpenBrace));
                System.setProperty(EDITOR_SMART_INDENT_CLOSING_BRACE, String.valueOf(_smartIndentClosingBrace));
                System.setProperty(FORMAT_FONT, _font);
                System.setProperty(FORMAT_FONT_SIZE, String.valueOf(_fontSize));
                System.setProperty(FORMAT_CARET_COLOR, String.valueOf(_caretColor.getRGB()));
                System.setProperty(FORMAT_BREAK_POINT_MARGIN_FOREGROUND, String.valueOf(_breakPointMarginForeground.getRGB()));
                System.setProperty(FORMAT_BREAK_POINT_MARGIN_BACKGROUND, String.valueOf(_breakPointMarginBackground.getRGB()));
                System.setProperty(FORMAT_TEXT_SELECTION_FOREGROUND, String.valueOf(_textSelectionForeground.getRGB()));
                System.setProperty(FORMAT_TEXT_SELECTION_BACKGROUND, String.valueOf(_textSelectionBackground.getRGB()));
                System.setProperty(FORMAT_TEXT_FOREGROUND, String.valueOf(_textForeground.getRGB()));
                System.setProperty(FORMAT_TEXT_BACKGROUND, String.valueOf(_textBackground.getRGB()));
                System.setProperty(FORMAT_TEXT_STYLE, String.valueOf(_textStyle));
                System.setProperty(FORMAT_KEYWORDS_FOREGROUND, String.valueOf(_keywordsForeground.getRGB()));
                System.setProperty(FORMAT_KEYWORDS_BACKGROUND, String.valueOf(_keywordsBackground.getRGB()));
                System.setProperty(FORMAT_KEYWORDS_STYLE, String.valueOf(_keywordsStyle));
                System.setProperty(FORMAT_COMMENT_FOREGROUND, String.valueOf(_commentForeground.getRGB()));
                System.setProperty(FORMAT_COMMENT_BACKGROUND, String.valueOf(_commentBackground.getRGB()));
                System.setProperty(FORMAT_COMMENT_STYLE, String.valueOf(_commentStyle));
                System.setProperty(FORMAT_FORMAL_COMMENT_FOREGROUND, String.valueOf(_formalCommentForeground.getRGB()));
                System.setProperty(FORMAT_FORMAL_COMMENT_BACKGROUND, String.valueOf(_formalCommentBackground.getRGB()));
                System.setProperty(FORMAT_FORMAL_COMMENT_STYLE, String.valueOf(_formalCommentStyle));
                System.setProperty(FORMAT_NUMBER_FOREGROUND, String.valueOf(_numberForeground.getRGB()));
                System.setProperty(FORMAT_NUMBER_BACKGROUND, String.valueOf(_numberBackground.getRGB()));
                System.setProperty(FORMAT_NUMBER_STYLE, String.valueOf(_numberStyle));
                System.setProperty(FORMAT_STRING_FOREGROUND, String.valueOf(_stringForeground.getRGB()));
                System.setProperty(FORMAT_STRING_BACKGROUND, String.valueOf(_stringBackground.getRGB()));
                System.setProperty(FORMAT_OPEN_STRING_FOREGROUND, String.valueOf(_openStringForeground.getRGB()));
                System.setProperty(FORMAT_OPEN_STRING_BACKGROUND, String.valueOf(_openStringBackground.getRGB()));
                System.setProperty(FORMAT_STRING_STYLE, String.valueOf(_stringStyle));
                System.setProperty(FORMAT_OPEN_STRING_STYLE, String.valueOf(_openStringStyle));
                System.setProperty(FORMAT_OPERATORS_FOREGROUND, String.valueOf(_operatorsForeground.getRGB()));
                System.setProperty(FORMAT_OPERATORS_BACKGROUND, String.valueOf(_operatorsBackground.getRGB()));
                System.setProperty(FORMAT_OPERATORS_STYLE, String.valueOf(_operatorsStyle));
                System.setProperty(FORMAT_PUNCTUATION_FOREGROUND, String.valueOf(_punctuationForeground.getRGB()));
                System.setProperty(FORMAT_PUNCTUATION_BACKGROUND, String.valueOf(_punctuationBackground.getRGB()));
                System.setProperty(FORMAT_PUNCTUATION_STYLE, String.valueOf(_punctuationStyle));
                System.setProperty(FORMAT_HTML_ELEMENT_NAME_FOREGROUND, String.valueOf(_htmlElementNameForeground.getRGB()));
                System.setProperty(FORMAT_HTML_ELEMENT_NAME_BACKGROUND, String.valueOf(_htmlElementNameBackground.getRGB()));
                System.setProperty(FORMAT_HTML_ELEMENT_NAME_STYLE, String.valueOf(_htmlElementNameStyle));
                System.setProperty(FORMAT_HTML_ATTRIBUTE_NAME_FOREGROUND, String.valueOf(_htmlAttributeNameForeground.getRGB()));
                System.setProperty(FORMAT_HTML_ATTRIBUTE_NAME_BACKGROUND, String.valueOf(_htmlAttributeNameBackground.getRGB()));
                System.setProperty(FORMAT_HTML_ATTRIBUTE_NAME_STYLE, String.valueOf(_htmlAttributeNameStyle));
                System.setProperty(FORMAT_HTML_ATTRIBUTE_VALUE_FOREGROUND, String.valueOf(_htmlAttributeValueForeground.getRGB()));
                System.setProperty(FORMAT_HTML_ATTRIBUTE_VALUE_BACKGROUND, String.valueOf(_htmlAttributeValueBackground.getRGB()));
                System.setProperty(FORMAT_HTML_ATTRIBUTE_VALUE_STYLE, String.valueOf(_htmlAttributeValueStyle));
                System.setProperty(FORMAT_HTML_COMMENT_FOREGROUND, String.valueOf(_htmlCommentForeground.getRGB()));
                System.setProperty(FORMAT_HTML_COMMENT_BACKGROUND, String.valueOf(_htmlCommentBackground.getRGB()));
                System.setProperty(FORMAT_HTML_COMMENT_STYLE, String.valueOf(_htmlCommentStyle));
                System.setProperty(FORMAT_HTML_TAG_DELIMITER_FOREGROUND, String.valueOf(_htmlTagDelimiterForeground.getRGB()));
                System.setProperty(FORMAT_HTML_TAG_DELIMITER_BACKGROUND, String.valueOf(_htmlTagDelimiterBackground.getRGB()));
                System.setProperty(FORMAT_HTML_TAG_DELIMITER_STYLE, String.valueOf(_htmlTagDelimiterStyle));
                System.setProperty(FORMAT_HTML_OPERATOR_FOREGROUND, String.valueOf(_htmlOperatorForeground.getRGB()));
                System.setProperty(FORMAT_HTML_OPERATOR_BACKGROUND, String.valueOf(_htmlOperatorBackground.getRGB()));
                System.setProperty(FORMAT_HTML_OPERATOR_STYLE, String.valueOf(_htmlOperatorStyle));
                System.setProperty(FORMAT_PRINT_FONT_SIZE, String.valueOf(_printFontSize));
                System.setProperty(FORMAT_PRINT_HEADER, String.valueOf(_printHeader));
                System.setProperty(FORMAT_PRINT_FOOTER, String.valueOf(_printFooter));
                System.setProperty(FRAME_X, String.valueOf(_frameX));
                System.setProperty(FRAME_Y, String.valueOf(_frameY));
                System.setProperty(FRAME_WIDTH, String.valueOf(_frameWidth));
                System.setProperty(FRAME_HEIGHT, String.valueOf(_frameHeight));
                System.setProperty(EDITOR_DIVIDER_LOCATION, String.valueOf(_dividerLocation));
                System.setProperty(FIND_IN_FILES_WHAT, _findInFilesWhat);
                System.setProperty(FIND_IN_FILES_TYPE, _findInFilesType);
                System.setProperty(FIND_IN_FILES_FOLDER, _findInFilesFolder);
                System.setProperty(FIND_IN_FILES_MATCH_WHOLE_WORD, String.valueOf(_findInFilesMatchWholeWord));
                System.setProperty(FIND_IN_FILES_MATCH_CASE, String.valueOf(_findInFilesMatchCase));
                System.setProperty(FIND_IN_FILES_LOOK_IN_SUBFOLDERS, String.valueOf(_findInFilesLookInSubfolders));
                System.setProperty(FIND_IN_FILES_OUTPUT_TO_PANE_2, String.valueOf(_findInFilesOutputToPane2));
                serializable = new Properties(System.getProperties());
                ((Properties)serializable).setProperty(EDITOR_VERTICAL_SCROLLBAR, System.getProperty(EDITOR_VERTICAL_SCROLLBAR));
                ((Properties)serializable).setProperty(EDITOR_HORIZONTAL_SCROLLBAR, System.getProperty(EDITOR_HORIZONTAL_SCROLLBAR));
                ((Properties)serializable).setProperty(EDITOR_DRAG_AND_DROP_EDITING, System.getProperty(EDITOR_DRAG_AND_DROP_EDITING));
                ((Properties)serializable).setProperty(TABS_TAB_SIZE, System.getProperty(TABS_TAB_SIZE));
                ((Properties)serializable).setProperty(TABS_INDENT_SIZE, System.getProperty(TABS_INDENT_SIZE));
                ((Properties)serializable).setProperty(EDITOR_KEEP_TABS, System.getProperty(EDITOR_KEEP_TABS));
                ((Properties)serializable).setProperty(TABS_AUTO_INDENT, System.getProperty(TABS_AUTO_INDENT));
                ((Properties)serializable).setProperty(EDITOR_SMART_INDENT_OPEN_BRACE, System.getProperty(EDITOR_SMART_INDENT_OPEN_BRACE));
                ((Properties)serializable).setProperty(EDITOR_SMART_INDENT_CLOSING_BRACE, System.getProperty(EDITOR_SMART_INDENT_CLOSING_BRACE));
                ((Properties)serializable).setProperty(FORMAT_FONT, System.getProperty(FORMAT_FONT));
                ((Properties)serializable).setProperty(FORMAT_FONT_SIZE, System.getProperty(FORMAT_FONT_SIZE));
                ((Properties)serializable).setProperty(FORMAT_CARET_COLOR, System.getProperty(FORMAT_CARET_COLOR));
                ((Properties)serializable).setProperty(FORMAT_BREAK_POINT_MARGIN_FOREGROUND, System.getProperty(FORMAT_BREAK_POINT_MARGIN_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_BREAK_POINT_MARGIN_BACKGROUND, System.getProperty(FORMAT_BREAK_POINT_MARGIN_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_TEXT_SELECTION_FOREGROUND, System.getProperty(FORMAT_TEXT_SELECTION_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_TEXT_SELECTION_BACKGROUND, System.getProperty(FORMAT_TEXT_SELECTION_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_TEXT_FOREGROUND, System.getProperty(FORMAT_TEXT_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_TEXT_BACKGROUND, System.getProperty(FORMAT_TEXT_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_TEXT_STYLE, System.getProperty(FORMAT_TEXT_STYLE));
                ((Properties)serializable).setProperty(FORMAT_KEYWORDS_FOREGROUND, System.getProperty(FORMAT_KEYWORDS_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_KEYWORDS_BACKGROUND, System.getProperty(FORMAT_KEYWORDS_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_KEYWORDS_STYLE, System.getProperty(FORMAT_KEYWORDS_STYLE));
                ((Properties)serializable).setProperty(FORMAT_COMMENT_FOREGROUND, System.getProperty(FORMAT_COMMENT_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_COMMENT_BACKGROUND, System.getProperty(FORMAT_COMMENT_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_COMMENT_STYLE, System.getProperty(FORMAT_COMMENT_STYLE));
                ((Properties)serializable).setProperty(FORMAT_FORMAL_COMMENT_FOREGROUND, System.getProperty(FORMAT_FORMAL_COMMENT_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_FORMAL_COMMENT_BACKGROUND, System.getProperty(FORMAT_FORMAL_COMMENT_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_FORMAL_COMMENT_STYLE, System.getProperty(FORMAT_FORMAL_COMMENT_STYLE));
                ((Properties)serializable).setProperty(FORMAT_NUMBER_FOREGROUND, System.getProperty(FORMAT_NUMBER_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_NUMBER_BACKGROUND, System.getProperty(FORMAT_NUMBER_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_NUMBER_STYLE, System.getProperty(FORMAT_NUMBER_STYLE));
                ((Properties)serializable).setProperty(FORMAT_STRING_FOREGROUND, System.getProperty(FORMAT_STRING_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_STRING_BACKGROUND, System.getProperty(FORMAT_STRING_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_OPEN_STRING_FOREGROUND, System.getProperty(FORMAT_OPEN_STRING_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_OPEN_STRING_BACKGROUND, System.getProperty(FORMAT_OPEN_STRING_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_STRING_STYLE, System.getProperty(FORMAT_STRING_STYLE));
                ((Properties)serializable).setProperty(FORMAT_OPEN_STRING_STYLE, System.getProperty(FORMAT_OPEN_STRING_STYLE));
                ((Properties)serializable).setProperty(FORMAT_OPERATORS_FOREGROUND, System.getProperty(FORMAT_OPERATORS_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_OPERATORS_BACKGROUND, System.getProperty(FORMAT_OPERATORS_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_OPERATORS_STYLE, System.getProperty(FORMAT_OPERATORS_STYLE));
                ((Properties)serializable).setProperty(FORMAT_PUNCTUATION_FOREGROUND, System.getProperty(FORMAT_PUNCTUATION_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_PUNCTUATION_BACKGROUND, System.getProperty(FORMAT_PUNCTUATION_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_PUNCTUATION_STYLE, System.getProperty(FORMAT_PUNCTUATION_STYLE));
                ((Properties)serializable).setProperty(FORMAT_HTML_ELEMENT_NAME_FOREGROUND, System.getProperty(FORMAT_HTML_ELEMENT_NAME_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_ELEMENT_NAME_BACKGROUND, System.getProperty(FORMAT_HTML_ELEMENT_NAME_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_ELEMENT_NAME_STYLE, System.getProperty(FORMAT_HTML_ELEMENT_NAME_STYLE));
                ((Properties)serializable).setProperty(FORMAT_HTML_ATTRIBUTE_NAME_FOREGROUND, System.getProperty(FORMAT_HTML_ATTRIBUTE_NAME_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_ATTRIBUTE_NAME_BACKGROUND, System.getProperty(FORMAT_HTML_ATTRIBUTE_NAME_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_ATTRIBUTE_NAME_STYLE, System.getProperty(FORMAT_HTML_ATTRIBUTE_NAME_STYLE));
                ((Properties)serializable).setProperty(FORMAT_HTML_ATTRIBUTE_VALUE_FOREGROUND, System.getProperty(FORMAT_HTML_ATTRIBUTE_VALUE_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_ATTRIBUTE_VALUE_BACKGROUND, System.getProperty(FORMAT_HTML_ATTRIBUTE_VALUE_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_ATTRIBUTE_VALUE_STYLE, System.getProperty(FORMAT_HTML_ATTRIBUTE_VALUE_STYLE));
                ((Properties)serializable).setProperty(FORMAT_HTML_COMMENT_FOREGROUND, System.getProperty(FORMAT_HTML_COMMENT_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_COMMENT_BACKGROUND, System.getProperty(FORMAT_HTML_COMMENT_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_COMMENT_STYLE, System.getProperty(FORMAT_HTML_COMMENT_STYLE));
                ((Properties)serializable).setProperty(FORMAT_HTML_TAG_DELIMITER_FOREGROUND, System.getProperty(FORMAT_HTML_TAG_DELIMITER_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_TAG_DELIMITER_BACKGROUND, System.getProperty(FORMAT_HTML_TAG_DELIMITER_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_TAG_DELIMITER_STYLE, System.getProperty(FORMAT_HTML_TAG_DELIMITER_STYLE));
                ((Properties)serializable).setProperty(FORMAT_HTML_OPERATOR_FOREGROUND, System.getProperty(FORMAT_HTML_OPERATOR_FOREGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_OPERATOR_BACKGROUND, System.getProperty(FORMAT_HTML_OPERATOR_BACKGROUND));
                ((Properties)serializable).setProperty(FORMAT_HTML_OPERATOR_STYLE, System.getProperty(FORMAT_HTML_OPERATOR_STYLE));
                ((Properties)serializable).setProperty(FORMAT_PRINT_FONT_SIZE, System.getProperty(FORMAT_PRINT_FONT_SIZE));
                ((Properties)serializable).setProperty(FORMAT_PRINT_HEADER, System.getProperty(FORMAT_PRINT_HEADER));
                ((Properties)serializable).setProperty(FORMAT_PRINT_FOOTER, System.getProperty(FORMAT_PRINT_FOOTER));
                ((Properties)serializable).setProperty(FRAME_X, System.getProperty(FRAME_X));
                ((Properties)serializable).setProperty(FRAME_Y, System.getProperty(FRAME_Y));
                ((Properties)serializable).setProperty(FRAME_WIDTH, System.getProperty(FRAME_WIDTH));
                ((Properties)serializable).setProperty(FRAME_HEIGHT, System.getProperty(FRAME_HEIGHT));
                ((Properties)serializable).setProperty(EDITOR_DIVIDER_LOCATION, System.getProperty(EDITOR_DIVIDER_LOCATION));
                ((Properties)serializable).setProperty(FIND_IN_FILES_WHAT, System.getProperty(FIND_IN_FILES_WHAT));
                ((Properties)serializable).setProperty(FIND_IN_FILES_TYPE, System.getProperty(FIND_IN_FILES_TYPE));
                ((Properties)serializable).setProperty(FIND_IN_FILES_FOLDER, System.getProperty(FIND_IN_FILES_FOLDER));
                ((Properties)serializable).setProperty(FIND_IN_FILES_MATCH_WHOLE_WORD, System.getProperty(FIND_IN_FILES_MATCH_WHOLE_WORD));
                ((Properties)serializable).setProperty(FIND_IN_FILES_MATCH_CASE, System.getProperty(FIND_IN_FILES_MATCH_CASE));
                ((Properties)serializable).setProperty(FIND_IN_FILES_LOOK_IN_SUBFOLDERS, System.getProperty(FIND_IN_FILES_LOOK_IN_SUBFOLDERS));
                ((Properties)serializable).setProperty(FIND_IN_FILES_OUTPUT_TO_PANE_2, System.getProperty(FIND_IN_FILES_OUTPUT_TO_PANE_2));
                FileOutputStream fileOutputStream = new FileOutputStream(_propertyFileName);
                ((Properties)serializable).store(fileOutputStream, "Sybase Central Editor user prefrerences");
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{_propertyFileName};
                SybOptionPane.showConfirmDialog(null, (Object)SybMessageFormat.format((String)ResourceManager.getI18NMessage("CUSTOMIZER_PROPERTY_ERROR"), (Object[])objectArray), (String)ResourceManager.getI18NMessage("CUSTOMIZER_PROPERTY_ERROR_TITLE"), (int)-1, (int)0);
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    static void reset() {
        String string = System.getProperty(RECENT_FILES, null);
        if (string == null) {
            _recentFiles = null;
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n != -1 && (n = string.indexOf(_pathSeparator, n2)) != n2) {
                n2 = n;
                ++n3;
            }
            _recentFiles = new String[n3];
            int n4 = 0;
            n = 0;
            for (int i = 0; i < n3; ++i) {
                SCEditorProperties._recentFiles[i] = (n = string.indexOf(_pathSeparator, n)) == -1 ? string.substring(n4) : string.substring(n4, n);
                n4 = n + 1;
            }
        }
        _verticalScrollBar = Boolean.valueOf(System.getProperty(EDITOR_VERTICAL_SCROLLBAR, "true"));
        _horizontalScrollBar = Boolean.valueOf(System.getProperty(EDITOR_HORIZONTAL_SCROLLBAR, "true"));
        _dragAndDropEditing = Boolean.valueOf(System.getProperty(EDITOR_DRAG_AND_DROP_EDITING, "true"));
        _tabSize = Integer.getInteger(TABS_TAB_SIZE, 8);
        _indentSize = Integer.getInteger(TABS_INDENT_SIZE, 4);
        _keepTabs = Boolean.getBoolean(EDITOR_KEEP_TABS);
        _autoIndent = Integer.getInteger(TABS_AUTO_INDENT, 0);
        _smartIndentOpenBrace = Boolean.getBoolean(EDITOR_SMART_INDENT_OPEN_BRACE);
        _smartIndentClosingBrace = Boolean.getBoolean(EDITOR_SMART_INDENT_CLOSING_BRACE);
        _font = System.getProperty(FORMAT_FONT, "Monospaced");
        _fontSize = Integer.getInteger(FORMAT_FONT_SIZE, SCEditor.isWindows() ? UIManager.getDefaults().getFont("TextArea.font").getSize() * 3 / 4 : UIManager.getDefaults().getFont("TextArea.font").getSize());
        _caretColor = Color.getColor(FORMAT_CARET_COLOR, SystemColor.textText);
        _breakPointMarginForeground = Color.getColor(FORMAT_BREAK_POINT_MARGIN_FOREGROUND, SystemColor.controlText);
        _breakPointMarginBackground = Color.getColor(FORMAT_BREAK_POINT_MARGIN_BACKGROUND, SystemColor.controlHighlight);
        _textSelectionForeground = Color.getColor(FORMAT_TEXT_SELECTION_FOREGROUND, SystemColor.textHighlightText);
        _textSelectionBackground = Color.getColor(FORMAT_TEXT_SELECTION_BACKGROUND, SystemColor.textHighlight);
        _textForeground = Color.getColor(FORMAT_TEXT_FOREGROUND, SystemColor.textText);
        _textBackground = Color.getColor(FORMAT_TEXT_BACKGROUND, SystemColor.window);
        _textStyle = Integer.getInteger(FORMAT_TEXT_STYLE, 0);
        _keywordsForeground = Color.getColor(FORMAT_KEYWORDS_FOREGROUND, Color.blue);
        _keywordsBackground = Color.getColor(FORMAT_KEYWORDS_BACKGROUND, SystemColor.window);
        _keywordsStyle = Integer.getInteger(FORMAT_KEYWORDS_STYLE, 0);
        _commentForeground = Color.getColor(FORMAT_COMMENT_FOREGROUND, Color.green.darker());
        _commentBackground = Color.getColor(FORMAT_COMMENT_BACKGROUND, SystemColor.window);
        _commentStyle = Integer.getInteger(FORMAT_COMMENT_STYLE, 0);
        _formalCommentForeground = Color.getColor(FORMAT_FORMAL_COMMENT_FOREGROUND, Color.magenta);
        _formalCommentBackground = Color.getColor(FORMAT_FORMAL_COMMENT_BACKGROUND, SystemColor.window);
        _formalCommentStyle = Integer.getInteger(FORMAT_FORMAL_COMMENT_STYLE, 0);
        _numberForeground = Color.getColor(FORMAT_NUMBER_FOREGROUND, Color.blue);
        _numberBackground = Color.getColor(FORMAT_NUMBER_BACKGROUND, SystemColor.window);
        _numberStyle = Integer.getInteger(FORMAT_NUMBER_STYLE, 0);
        _stringForeground = Color.getColor(FORMAT_STRING_FOREGROUND, Color.red);
        _stringBackground = Color.getColor(FORMAT_STRING_BACKGROUND, SystemColor.window);
        _openStringForeground = Color.getColor(FORMAT_OPEN_STRING_FOREGROUND, SystemColor.window);
        _openStringBackground = Color.getColor(FORMAT_OPEN_STRING_BACKGROUND, Color.red);
        _stringStyle = Integer.getInteger(FORMAT_STRING_STYLE, 0);
        _openStringStyle = Integer.getInteger(FORMAT_OPEN_STRING_STYLE, 0);
        _operatorsForeground = Color.getColor(FORMAT_OPERATORS_FOREGROUND, SystemColor.textText);
        _operatorsBackground = Color.getColor(FORMAT_OPERATORS_BACKGROUND, SystemColor.window);
        _operatorsStyle = Integer.getInteger(FORMAT_OPERATORS_STYLE, 0);
        _punctuationForeground = Color.getColor(FORMAT_PUNCTUATION_FOREGROUND, SystemColor.textText);
        _punctuationBackground = Color.getColor(FORMAT_PUNCTUATION_BACKGROUND, SystemColor.window);
        _punctuationStyle = Integer.getInteger(FORMAT_PUNCTUATION_STYLE, 0);
        _htmlElementNameForeground = Color.getColor(FORMAT_HTML_ELEMENT_NAME_FOREGROUND, Color.blue);
        _htmlElementNameBackground = Color.getColor(FORMAT_HTML_ELEMENT_NAME_BACKGROUND, SystemColor.window);
        _htmlElementNameStyle = Integer.getInteger(FORMAT_HTML_ELEMENT_NAME_STYLE, 0);
        _htmlAttributeNameForeground = Color.getColor(FORMAT_HTML_ATTRIBUTE_NAME_FOREGROUND, Color.green);
        _htmlAttributeNameBackground = Color.getColor(FORMAT_HTML_ATTRIBUTE_NAME_BACKGROUND, SystemColor.window);
        _htmlAttributeNameStyle = Integer.getInteger(FORMAT_HTML_ATTRIBUTE_NAME_STYLE, 0);
        _htmlAttributeValueForeground = Color.getColor(FORMAT_HTML_ATTRIBUTE_VALUE_FOREGROUND, Color.red);
        _htmlAttributeValueBackground = Color.getColor(FORMAT_HTML_ATTRIBUTE_VALUE_BACKGROUND, SystemColor.window);
        _htmlAttributeValueStyle = Integer.getInteger(FORMAT_HTML_ATTRIBUTE_VALUE_STYLE, 0);
        _htmlCommentForeground = Color.getColor(FORMAT_HTML_COMMENT_FOREGROUND, SystemColor.window);
        _htmlCommentBackground = Color.getColor(FORMAT_HTML_COMMENT_BACKGROUND, Color.green);
        _htmlCommentStyle = Integer.getInteger(FORMAT_HTML_COMMENT_STYLE, 0);
        _htmlTagDelimiterForeground = Color.getColor(FORMAT_HTML_TAG_DELIMITER_FOREGROUND, Color.darkGray);
        _htmlTagDelimiterBackground = Color.getColor(FORMAT_HTML_TAG_DELIMITER_BACKGROUND, SystemColor.window);
        _htmlTagDelimiterStyle = Integer.getInteger(FORMAT_HTML_TAG_DELIMITER_STYLE, 0);
        _htmlOperatorForeground = Color.getColor(FORMAT_HTML_OPERATOR_FOREGROUND, Color.orange);
        _htmlOperatorBackground = Color.getColor(FORMAT_HTML_OPERATOR_BACKGROUND, SystemColor.window);
        _htmlOperatorStyle = Integer.getInteger(FORMAT_HTML_OPERATOR_STYLE, 0);
        _printFontSize = Integer.getInteger(FORMAT_PRINT_FONT_SIZE, _fontSize);
        _printHeader = System.getProperty(FORMAT_PRINT_HEADER, "");
        _printFooter = System.getProperty(FORMAT_PRINT_FOOTER, "");
        _frameX = Integer.getInteger(FRAME_X, 0);
        _frameY = Integer.getInteger(FRAME_Y, 0);
        _frameWidth = Integer.getInteger(FRAME_WIDTH, 400);
        _frameHeight = Integer.getInteger(FRAME_HEIGHT, 400);
        _dividerLocation = Integer.getInteger(EDITOR_DIVIDER_LOCATION, 100);
        _findInFilesWhat = System.getProperty(FIND_IN_FILES_WHAT, "");
        _findInFilesType = System.getProperty(FIND_IN_FILES_TYPE, "");
        _findInFilesFolder = System.getProperty(FIND_IN_FILES_FOLDER, "");
        _findInFilesMatchWholeWord = Boolean.getBoolean(FIND_IN_FILES_MATCH_WHOLE_WORD);
        _findInFilesMatchCase = Boolean.getBoolean(FIND_IN_FILES_MATCH_CASE);
        _findInFilesLookInSubfolders = Boolean.getBoolean(FIND_IN_FILES_LOOK_IN_SUBFOLDERS);
        _findInFilesOutputToPane2 = Boolean.getBoolean(FIND_IN_FILES_OUTPUT_TO_PANE_2);
        _dirty = false;
    }

    static String[] getRecentFiles() {
        return _recentFiles;
    }

    static void setRecentFiles(String[] stringArray) {
        if (stringArray == null) {
            _recentFiles = new String[0];
        } else {
            _recentFiles = new String[stringArray.length];
            System.arraycopy(stringArray, 0, _recentFiles, 0, stringArray.length);
        }
        _dirty = true;
    }

    static boolean getVerticalScrollBar() {
        return _verticalScrollBar;
    }

    static void setVerticalScrollBar(boolean bl) {
        _verticalScrollBar = bl;
        _dirty = true;
    }

    static boolean getHorizontalScrollBar() {
        return _horizontalScrollBar;
    }

    static void setHorizontalScrollBar(boolean bl) {
        _horizontalScrollBar = bl;
        _dirty = true;
    }

    static boolean getDragAndDropEditing() {
        return _dragAndDropEditing;
    }

    static void setDragAndDropEditing(boolean bl) {
        _dragAndDropEditing = bl;
        _dirty = true;
    }

    static int getTabSize() {
        return _tabSize;
    }

    static void setTabSize(int n) {
        _tabSize = n;
        _dirty = true;
    }

    static int getIndentSize() {
        return _indentSize;
    }

    static void setIndentSize(int n) {
        _indentSize = n;
        _dirty = true;
    }

    static boolean getKeepTabs() {
        return _keepTabs;
    }

    static void setKeepTabs(boolean bl) {
        _keepTabs = bl;
        _dirty = true;
    }

    static int getAutoIndent() {
        return _autoIndent;
    }

    static void setAutoIndent(int n) {
        _autoIndent = n;
        _dirty = true;
    }

    static boolean getSmartIndentOpenBrace() {
        return _smartIndentOpenBrace;
    }

    static void setSmartIndentOpenBrace(boolean bl) {
        _smartIndentOpenBrace = bl;
        _dirty = true;
    }

    static boolean getSmartIndentClosingBrace() {
        return _smartIndentClosingBrace;
    }

    static void setSmartIndentClosingBrace(boolean bl) {
        _smartIndentClosingBrace = bl;
        _dirty = true;
    }

    static String getFont() {
        return _font;
    }

    static void setFont(String string) {
        _font = string;
        _dirty = true;
    }

    static int getFontSize() {
        return _fontSize;
    }

    static void setFontSize(int n) {
        _fontSize = n;
        _dirty = true;
    }

    static Color getCaretColor() {
        return _caretColor;
    }

    static void setCaretColor(Color color) {
        _caretColor = color;
        _dirty = true;
    }

    static Color getBreakPointMarginForeground() {
        return _breakPointMarginForeground;
    }

    static void setBreakPointMarginForeground(Color color) {
        _breakPointMarginForeground = color;
        _dirty = true;
    }

    static Color getBreakPointMarginBackground() {
        return _breakPointMarginBackground;
    }

    static void setBreakPointMarginBackground(Color color) {
        _breakPointMarginBackground = color;
        _dirty = true;
    }

    static Color getTextSelectionForeground() {
        return _textSelectionForeground;
    }

    static void setTextSelectionForeground(Color color) {
        _textSelectionForeground = color;
        _dirty = true;
    }

    static Color getTextSelectionBackground() {
        return _textSelectionBackground;
    }

    static void setTextSelectionBackground(Color color) {
        _textSelectionBackground = color;
        _dirty = true;
    }

    static Color getTextForeground() {
        return _textForeground;
    }

    static void setTextForeground(Color color) {
        _textForeground = color;
        _dirty = true;
    }

    static Color getTextBackground() {
        return _textBackground;
    }

    static void setTextBackground(Color color) {
        _textBackground = color;
        _dirty = true;
    }

    static int getTextStyle() {
        return _textStyle;
    }

    static void setTextStyle(int n) {
        _textStyle = n;
        _dirty = true;
    }

    static Color getKeywordsForeground() {
        return _keywordsForeground;
    }

    static void setKeywordsForeground(Color color) {
        _keywordsForeground = color;
        _dirty = true;
    }

    static Color getKeywordsBackground() {
        return _keywordsBackground;
    }

    static void setKeywordsBackground(Color color) {
        _keywordsBackground = color;
        _dirty = true;
    }

    static int getKeywordsStyle() {
        return _keywordsStyle;
    }

    static void setKeywordsStyle(int n) {
        _keywordsStyle = n;
        _dirty = true;
    }

    static Color getCommentForeground() {
        return _commentForeground;
    }

    static void setCommentForeground(Color color) {
        _commentForeground = color;
        _dirty = true;
    }

    static Color getCommentBackground() {
        return _commentBackground;
    }

    static void setCommentBackground(Color color) {
        _commentBackground = color;
        _dirty = true;
    }

    static int getCommentStyle() {
        return _commentStyle;
    }

    static void setCommentStyle(int n) {
        _commentStyle = n;
        _dirty = true;
    }

    static Color getFormalCommentForeground() {
        return _formalCommentForeground;
    }

    static void setFormalCommentForeground(Color color) {
        _formalCommentForeground = color;
        _dirty = true;
    }

    static Color getFormalCommentBackground() {
        return _formalCommentBackground;
    }

    static void setFormalCommentBackground(Color color) {
        _formalCommentBackground = color;
        _dirty = true;
    }

    static int getFormalCommentStyle() {
        return _formalCommentStyle;
    }

    static void setFormalCommentStyle(int n) {
        _formalCommentStyle = n;
        _dirty = true;
    }

    static Color getNumberForeground() {
        return _numberForeground;
    }

    static void setNumberForeground(Color color) {
        _numberForeground = color;
        _dirty = true;
    }

    static Color getNumberBackground() {
        return _numberBackground;
    }

    static void setNumberBackground(Color color) {
        _numberBackground = color;
        _dirty = true;
    }

    static int getNumberStyle() {
        return _numberStyle;
    }

    static void setNumberStyle(int n) {
        _numberStyle = n;
        _dirty = true;
    }

    static Color getStringForeground() {
        return _stringForeground;
    }

    static void setStringForeground(Color color) {
        _stringForeground = color;
        _dirty = true;
    }

    static Color getStringBackground() {
        return _stringBackground;
    }

    static void setStringBackground(Color color) {
        _stringBackground = color;
        _dirty = true;
    }

    static int getStringStyle() {
        return _stringStyle;
    }

    static void setStringStyle(int n) {
        _stringStyle = n;
        _dirty = true;
    }

    static Color getOpenStringBackground() {
        return _openStringBackground;
    }

    static void setOpenStringBackground(Color color) {
        _openStringBackground = color;
        _dirty = true;
    }

    static Color getOpenStringForeground() {
        return _openStringForeground;
    }

    static void setOpenStringForeground(Color color) {
        _openStringForeground = color;
        _dirty = true;
    }

    static int getOpenStringStyle() {
        return _openStringStyle;
    }

    static void setOpenStringStyle(int n) {
        _openStringStyle = n;
        _dirty = true;
    }

    static Color getOperatorsForeground() {
        return _operatorsForeground;
    }

    static void setOperatorsForeground(Color color) {
        _operatorsForeground = color;
        _dirty = true;
    }

    static Color getOperatorsBackground() {
        return _operatorsBackground;
    }

    static void setOperatorsBackground(Color color) {
        _operatorsBackground = color;
        _dirty = true;
    }

    static int getOperatorsStyle() {
        return _operatorsStyle;
    }

    static void setOperatorsStyle(int n) {
        _operatorsStyle = n;
        _dirty = true;
    }

    static Color getPunctuationForeground() {
        return _punctuationForeground;
    }

    static void setPunctuationForeground(Color color) {
        _punctuationForeground = color;
        _dirty = true;
    }

    static Color getPunctuationBackground() {
        return _punctuationBackground;
    }

    static void setPunctuationBackground(Color color) {
        _punctuationBackground = color;
        _dirty = true;
    }

    static int getPunctuationStyle() {
        return _punctuationStyle;
    }

    static void setPunctuationStyle(int n) {
        _punctuationStyle = n;
        _dirty = true;
    }

    static Color getHTMLElementNameForeground() {
        return _htmlElementNameForeground;
    }

    static void setHTMLElementNameForeground(Color color) {
        _htmlElementNameForeground = color;
        _dirty = true;
    }

    static Color getHTMLElementNameBackground() {
        return _htmlElementNameBackground;
    }

    static void setHTMLElementNameBackground(Color color) {
        _htmlElementNameBackground = color;
        _dirty = true;
    }

    static int getHTMLElementNameStyle() {
        return _htmlElementNameStyle;
    }

    static void setHTMLElementNameStyle(int n) {
        _htmlElementNameStyle = n;
        _dirty = true;
    }

    static Color getHTMLAttributeNameForeground() {
        return _htmlAttributeNameForeground;
    }

    static void setHTMLAttributeNameForeground(Color color) {
        _htmlAttributeNameForeground = color;
        _dirty = true;
    }

    static Color getHTMLAttributeNameBackground() {
        return _htmlAttributeNameBackground;
    }

    static void setHTMLAttributeNameBackground(Color color) {
        _htmlAttributeNameBackground = color;
        _dirty = true;
    }

    static int getHTMLAttributeNameStyle() {
        return _htmlAttributeNameStyle;
    }

    static void setHTMLAttributeNameStyle(int n) {
        _htmlAttributeNameStyle = n;
        _dirty = true;
    }

    static Color getHTMLAttributeValueForeground() {
        return _htmlAttributeValueForeground;
    }

    static void setHTMLAttributeValueForeground(Color color) {
        _htmlAttributeValueForeground = color;
        _dirty = true;
    }

    static Color getHTMLAttributeValueBackground() {
        return _htmlAttributeValueBackground;
    }

    static void setHTMLAttributeValueBackground(Color color) {
        _htmlAttributeValueBackground = color;
        _dirty = true;
    }

    static int getHTMLAttributeValueStyle() {
        return _htmlAttributeValueStyle;
    }

    static void setHTMLAttributeValueStyle(int n) {
        _htmlAttributeValueStyle = n;
        _dirty = true;
    }

    static Color getHTMLCommentForeground() {
        return _htmlCommentForeground;
    }

    static void setHTMLCommentForeground(Color color) {
        _htmlCommentForeground = color;
        _dirty = true;
    }

    static Color getHTMLCommentBackground() {
        return _htmlCommentBackground;
    }

    static void setHTMLCommentBackground(Color color) {
        _htmlCommentBackground = color;
        _dirty = true;
    }

    static int getHTMLCommentStyle() {
        return _htmlCommentStyle;
    }

    static void setHTMLCommentStyle(int n) {
        _htmlCommentStyle = n;
        _dirty = true;
    }

    static Color getHTMLTagDelimiterForeground() {
        return _htmlTagDelimiterForeground;
    }

    static void setHTMLTagDelimiterForeground(Color color) {
        _htmlTagDelimiterForeground = color;
        _dirty = true;
    }

    static Color getHTMLTagDelimiterBackground() {
        return _htmlTagDelimiterBackground;
    }

    static void setHTMLTagDelimiterBackground(Color color) {
        _htmlTagDelimiterBackground = color;
        _dirty = true;
    }

    static int getHTMLTagDelimiterStyle() {
        return _htmlTagDelimiterStyle;
    }

    static void setHTMLTagDelimiterStyle(int n) {
        _htmlTagDelimiterStyle = n;
        _dirty = true;
    }

    static Color getHTMLOperatorForeground() {
        return _htmlOperatorForeground;
    }

    static void setHTMLOperatorForeground(Color color) {
        _htmlOperatorForeground = color;
        _dirty = true;
    }

    static Color getHTMLOperatorBackground() {
        return _htmlOperatorBackground;
    }

    static void setHTMLOperatorBackground(Color color) {
        _htmlOperatorBackground = color;
        _dirty = true;
    }

    static int getHTMLOperatorStyle() {
        return _htmlOperatorStyle;
    }

    static void setHTMLOperatorStyle(int n) {
        _htmlOperatorStyle = n;
        _dirty = true;
    }

    static int getPrintFontSize() {
        return _printFontSize;
    }

    static void setPrintFontSize(int n) {
        _printFontSize = n;
        _dirty = true;
    }

    static String getPrintHeader() {
        return _printHeader;
    }

    static void setPrintHeader(String string) {
        _printHeader = string;
        _dirty = true;
    }

    static String getPrintFooter() {
        return _printFooter;
    }

    static void setPrintFooter(String string) {
        _printFooter = string;
        _dirty = true;
    }

    static int getFrameX() {
        return _frameX;
    }

    static void setFrameX(int n) {
        _frameX = n;
        _dirty = true;
    }

    static int getFrameY() {
        return _frameY;
    }

    static void setFrameY(int n) {
        _frameY = n;
        _dirty = true;
    }

    static int getFrameWidth() {
        return _frameWidth;
    }

    static void setFrameWidth(int n) {
        _frameWidth = n;
        _dirty = true;
    }

    static int getFrameHeight() {
        return _frameHeight;
    }

    static void setFrameHeight(int n) {
        _frameHeight = n;
        _dirty = true;
    }

    static int getDividerLocation() {
        return _dividerLocation;
    }

    static void setDividerLocation(int n) {
        _dividerLocation = n;
        _dirty = true;
    }

    static String getFindInFilesWhat() {
        return _findInFilesWhat;
    }

    static synchronized void setFindInFilesWhat(String string) {
        _findInFilesWhat = string;
        _dirty = true;
    }

    static String getFindInFilesType() {
        return _findInFilesType;
    }

    static synchronized void setFindInFilesType(String string) {
        _findInFilesType = string;
        _dirty = true;
    }

    static String getFindInFilesFolder() {
        return _findInFilesFolder;
    }

    static synchronized void setFindInFilesFolder(String string) {
        _findInFilesFolder = string;
        _dirty = true;
    }

    static synchronized boolean getFindInFilesMatchWholeWord() {
        return _findInFilesMatchWholeWord;
    }

    static synchronized void setFindInFilesMatchWholeWord(boolean bl) {
        _findInFilesMatchWholeWord = bl;
        _dirty = true;
    }

    static boolean getFindInFilesMatchCase() {
        return _findInFilesMatchCase;
    }

    static synchronized void setFindInFilesMatchCase(boolean bl) {
        _findInFilesMatchCase = bl;
        _dirty = true;
    }

    static boolean getFindInFilesLookInSubfolders() {
        return _findInFilesLookInSubfolders;
    }

    static synchronized void setFindInFilesLookInSubfolders(boolean bl) {
        _findInFilesLookInSubfolders = bl;
        _dirty = true;
    }

    static boolean getFindInFilesOutputToPane2() {
        return _findInFilesOutputToPane2;
    }

    static synchronized void setFindInFilesOutputToPane2(boolean bl) {
        _findInFilesOutputToPane2 = bl;
        _dirty = true;
    }

    static void setFormatValuesToDefault() {
        _fontSize = SCEditor.isWindows() ? UIManager.getDefaults().getFont("TextArea.font").getSize() * 3 / 4 : UIManager.getDefaults().getFont("TextArea.font").getSize();
        _caretColor = SystemColor.textText;
        _breakPointMarginForeground = SystemColor.controlText;
        _breakPointMarginBackground = SystemColor.controlHighlight;
        _textSelectionForeground = SystemColor.textHighlightText;
        _textSelectionBackground = SystemColor.textHighlight;
        _textForeground = SystemColor.textText;
        _textBackground = SystemColor.window;
        _textStyle = 0;
        _keywordsForeground = Color.blue;
        _keywordsBackground = SystemColor.window;
        _keywordsStyle = 0;
        _commentForeground = Color.green.darker();
        _commentBackground = SystemColor.window;
        _commentStyle = 0;
        _formalCommentForeground = Color.magenta;
        _formalCommentBackground = SystemColor.window;
        _formalCommentStyle = 0;
        _numberForeground = Color.blue;
        _numberBackground = SystemColor.window;
        _numberStyle = 0;
        _stringForeground = Color.red;
        _stringBackground = SystemColor.window;
        _openStringForeground = SystemColor.window;
        _openStringBackground = Color.red;
        _stringStyle = 0;
        _openStringStyle = 0;
        _operatorsForeground = SystemColor.textText;
        _operatorsBackground = SystemColor.window;
        _operatorsStyle = 0;
        _punctuationForeground = SystemColor.textText;
        _punctuationBackground = SystemColor.window;
        _punctuationStyle = 0;
        _htmlElementNameForeground = SystemColor.textText;
        _htmlElementNameBackground = SystemColor.window;
        _htmlElementNameStyle = 0;
        _htmlAttributeNameForeground = SystemColor.textText;
        _htmlAttributeNameBackground = SystemColor.window;
        _htmlAttributeNameStyle = 0;
        _htmlAttributeValueForeground = SystemColor.textText;
        _htmlAttributeValueBackground = SystemColor.window;
        _htmlAttributeValueStyle = 0;
        _htmlCommentForeground = SystemColor.textText;
        _htmlCommentBackground = SystemColor.window;
        _htmlCommentStyle = 0;
        _htmlTagDelimiterForeground = SystemColor.textText;
        _htmlTagDelimiterBackground = SystemColor.window;
        _htmlTagDelimiterStyle = 0;
        _htmlOperatorForeground = SystemColor.textText;
        _htmlOperatorBackground = SystemColor.window;
        _htmlOperatorStyle = 0;
        _dirty = true;
    }
}

