/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.IntegerTextField;
import com.sybase.central.editor.ResourceManager;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.SCEditorProperties;
import com.sybase.customization.CustomizationPage;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class TabsCustomizationPage
extends JPanel
implements FocusListener,
ItemListener,
CustomizationPage {
    private static HelpViewer _helpViewer = null;
    Insets _insets0505 = new Insets(0, 5, 0, 5);
    Insets _insets5555 = new Insets(5, 5, 5, 5);
    IntegerTextField _tabSize;
    SybRadioButton _insertSpaces;
    IntegerTextField _indentSize;
    SybRadioButton _keepTabs;
    SybRadioButton _noAutoIndent;
    SybRadioButton _defaultAutoIndent;
    SybRadioButton _smartAutoIndent;
    SybCheckBox _indentOpenBrace;
    SybCheckBox _indentClosingBrace;
    SybLabel _sampleLabel;
    NonTraversableTextArea _smartIndentSample;

    TabsCustomizationPage() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout2);
        this.add(jPanel);
        SybLabel sybLabel = new SybLabel();
        jPanel.add((Component)sybLabel);
        SybLabel sybLabel2 = new SybLabel();
        jPanel.add((Component)sybLabel2);
        this._tabSize = new IntegerTextField();
        jPanel.add(this._tabSize);
        this._indentSize = new IntegerTextField();
        jPanel.add(this._indentSize);
        this._insertSpaces = new SybRadioButton();
        jPanel.add((Component)this._insertSpaces);
        this._keepTabs = new SybRadioButton();
        jPanel.add((Component)this._keepTabs);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout3);
        this.add(jPanel2);
        this._noAutoIndent = new SybRadioButton();
        jPanel2.add((Component)this._noAutoIndent);
        this._defaultAutoIndent = new SybRadioButton();
        jPanel2.add((Component)this._defaultAutoIndent);
        this._smartAutoIndent = new SybRadioButton();
        jPanel2.add((Component)this._smartAutoIndent);
        this._indentOpenBrace = new SybCheckBox();
        jPanel2.add((Component)this._indentOpenBrace);
        this._indentClosingBrace = new SybCheckBox();
        jPanel2.add((Component)this._indentClosingBrace);
        this._sampleLabel = new SybLabel();
        jPanel2.add((Component)this._sampleLabel);
        this._smartIndentSample = new NonTraversableTextArea();
        jPanel2.add(this._smartIndentSample);
        SybLabel sybLabel3 = new SybLabel();
        jPanel2.add((Component)sybLabel3);
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        sybLabel.setText(ResourceManager.getI18NMessage("Tab size:"));
        sybLabel.setLabelFor((Component)this._tabSize);
        this._tabSize.addFocusListener(this);
        this._tabSize.setHorizontalAlignment(2);
        this._tabSize.setToolTipText(ResourceManager.getI18NMessage("TabSizeTip"));
        this._insertSpaces.addItemListener((ItemListener)this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._insertSpaces);
        this._insertSpaces.setText(ResourceManager.getI18NMessage("Insert spaces"));
        this._insertSpaces.setToolTipText(ResourceManager.getI18NMessage("InsertSpacesTip"));
        sybLabel2.setText(ResourceManager.getI18NMessage("Indent size:"));
        sybLabel2.setLabelFor((Component)this._indentSize);
        this._indentSize.addFocusListener(this);
        this._indentSize.setHorizontalAlignment(2);
        this._indentSize.setToolTipText(ResourceManager.getI18NMessage("IndentSizeTip"));
        this._keepTabs.addItemListener((ItemListener)this);
        buttonGroup.add((AbstractButton)this._keepTabs);
        this._keepTabs.setText(ResourceManager.getI18NMessage("Keep tabs"));
        this._keepTabs.setToolTipText(ResourceManager.getI18NMessage("KeepTabsTip"));
        jPanel2.setBorder(BorderFactory.createTitledBorder(ResourceManager.getI18NMessage("Auto indent")));
        this._noAutoIndent.addItemListener((ItemListener)this);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add((AbstractButton)this._noAutoIndent);
        this._noAutoIndent.setText(ResourceManager.getI18NMessage("None"));
        this._noAutoIndent.setToolTipText(ResourceManager.getI18NMessage("NoneTip"));
        this._defaultAutoIndent.addItemListener((ItemListener)this);
        buttonGroup2.add((AbstractButton)this._defaultAutoIndent);
        this._defaultAutoIndent.setText(ResourceManager.getI18NMessage("Default"));
        this._defaultAutoIndent.setToolTipText(ResourceManager.getI18NMessage("DefaultTip"));
        this._smartAutoIndent.addItemListener((ItemListener)this);
        buttonGroup2.add((AbstractButton)this._smartAutoIndent);
        this._smartAutoIndent.setText(ResourceManager.getI18NMessage("Smart"));
        this._smartAutoIndent.setToolTipText(ResourceManager.getI18NMessage("SmartTip"));
        this._indentOpenBrace.addItemListener((ItemListener)this);
        this._indentOpenBrace.setText(ResourceManager.getI18NMessage("Indent open brace"));
        this._indentOpenBrace.setToolTipText(ResourceManager.getI18NMessage("IndentOpenBraceTip"));
        this._indentClosingBrace.addItemListener((ItemListener)this);
        this._indentClosingBrace.setText(ResourceManager.getI18NMessage("Indent closing brace"));
        this._indentClosingBrace.setToolTipText(ResourceManager.getI18NMessage("IndentClosingBraceTip"));
        this._sampleLabel.setText(ResourceManager.getI18NMessage("TabSample"));
        this._sampleLabel.setLabelFor((Component)this._smartIndentSample);
        this._smartIndentSample.setMargin(this._insets5555);
        this._smartIndentSample.setBorder(BorderFactory.createBevelBorder(1));
        this._smartIndentSample.setFont(new Font("Monospaced", 0, 12));
        this.updateSmartIndentSample();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = this._insets0505;
        gridBagLayout2.setConstraints((Component)sybLabel, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout2.setConstraints(this._tabSize, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagLayout2.setConstraints((Component)this._insertSpaces, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = this._insets0505;
        gridBagLayout2.setConstraints((Component)sybLabel2, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout2.setConstraints(this._indentSize, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.weightx = 0.0;
        gridBagLayout2.setConstraints((Component)this._keepTabs, gridBagConstraints2);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
        gridBagLayout3.setConstraints((Component)this._noAutoIndent, gridBagConstraints3);
        gridBagConstraints3.gridy = 1;
        gridBagLayout3.setConstraints((Component)this._defaultAutoIndent, gridBagConstraints3);
        gridBagConstraints3.gridy = 2;
        gridBagLayout3.setConstraints((Component)this._smartAutoIndent, gridBagConstraints3);
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new Insets(5, 25, 0, 0);
        gridBagLayout3.setConstraints((Component)this._indentOpenBrace, gridBagConstraints3);
        gridBagConstraints3.gridy = 4;
        gridBagLayout3.setConstraints((Component)this._indentClosingBrace, gridBagConstraints3);
        gridBagConstraints3.gridy = 5;
        gridBagLayout3.setConstraints((Component)this._sampleLabel, gridBagConstraints3);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 6;
        gridBagConstraints3.gridheight = 8;
        gridBagConstraints3.insets = new Insets(0, 25, 5, 5);
        gridBagLayout3.setConstraints(this._smartIndentSample, gridBagConstraints3);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout3.setConstraints((Component)sybLabel3, gridBagConstraints3);
    }

    public void initialize() {
        this._tabSize.setText(String.valueOf(SCEditorProperties.getTabSize()));
        this._insertSpaces.setSelected(!SCEditorProperties.getKeepTabs());
        this._indentSize.setText(String.valueOf(SCEditorProperties.getIndentSize()));
        this._keepTabs.setSelected(SCEditorProperties.getKeepTabs());
        this._noAutoIndent.setSelected(SCEditorProperties.getAutoIndent() == 0);
        this._defaultAutoIndent.setSelected(SCEditorProperties.getAutoIndent() == 1);
        this._smartAutoIndent.setSelected(SCEditorProperties.getAutoIndent() == 3);
        this._indentOpenBrace.setSelected(SCEditorProperties.getSmartIndentOpenBrace());
        this._indentClosingBrace.setSelected(SCEditorProperties.getSmartIndentClosingBrace());
    }

    public boolean validateChanges() {
        return true;
    }

    public String getTitle() {
        return ResourceManager.getI18NMessage("Tabs");
    }

    public void destroy() {
        this._tabSize.removeFocusListener(this);
        this._insertSpaces.removeItemListener((ItemListener)this);
        this._indentSize.removeFocusListener(this);
        this._keepTabs.removeItemListener((ItemListener)this);
        this._noAutoIndent.removeItemListener((ItemListener)this);
        this._defaultAutoIndent.removeItemListener((ItemListener)this);
        this._smartAutoIndent.removeItemListener((ItemListener)this);
        this._indentOpenBrace.removeItemListener((ItemListener)this);
        this._indentClosingBrace.removeItemListener((ItemListener)this);
    }

    private HelpViewer getHelpViewer() {
        if (_helpViewer == null) {
            try {
                _helpViewer = FactoryHelp.getHelpViewer((String)SCEditor._helpFolder, (String)SCEditor._helpFile, (String)SCEditor._helpVersion);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                // empty catch block
            }
        }
        return _helpViewer;
    }

    public void showHelp() {
        if (this.getHelpViewer() != null) {
            this.getHelpViewer().turnPage("HELP_SCEDITOR_TAB_CUSTOMIZATION", SwingUtilities.windowForComponent(this));
        }
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this._tabSize) {
            if (this._tabSize.getValue() != SCEditorProperties.getTabSize()) {
                SCEditorProperties.setTabSize(this._tabSize.getValue());
            }
        } else if (object == this._indentSize && this._indentSize.getValue() != SCEditorProperties.getIndentSize()) {
            SCEditorProperties.setIndentSize(this._indentSize.getValue());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._insertSpaces) {
            SCEditorProperties.setKeepTabs(!this._insertSpaces.isSelected());
        } else if (object == this._keepTabs) {
            SCEditorProperties.setKeepTabs(this._keepTabs.isSelected());
        } else if (object == this._noAutoIndent) {
            if (this._noAutoIndent.isSelected()) {
                SCEditorProperties.setAutoIndent(0);
                this._indentOpenBrace.setEnabled(false);
                this._indentClosingBrace.setEnabled(false);
                this._sampleLabel.setEnabled(false);
                this._smartIndentSample.setEnabled(false);
            }
        } else if (object == this._defaultAutoIndent) {
            if (this._defaultAutoIndent.isSelected()) {
                SCEditorProperties.setAutoIndent(1);
                this._indentOpenBrace.setEnabled(false);
                this._indentClosingBrace.setEnabled(false);
                this._sampleLabel.setEnabled(false);
                this._smartIndentSample.setEnabled(false);
            }
        } else if (object == this._smartAutoIndent) {
            if (this._smartAutoIndent.isSelected()) {
                SCEditorProperties.setAutoIndent(3);
                this._indentOpenBrace.setEnabled(true);
                this._indentClosingBrace.setEnabled(true);
                this._sampleLabel.setEnabled(true);
                this._smartIndentSample.setEnabled(true);
            }
        } else if (object == this._indentOpenBrace) {
            this.updateSmartIndentSample();
            SCEditorProperties.setSmartIndentOpenBrace(this._indentOpenBrace.isSelected());
        } else if (object == this._indentClosingBrace) {
            this.updateSmartIndentSample();
            SCEditorProperties.setSmartIndentClosingBrace(this._indentClosingBrace.isSelected());
        }
    }

    private void updateSmartIndentSample() {
        StringBuffer stringBuffer = new StringBuffer(" if( a == b )\n");
        boolean bl = this._indentOpenBrace.isSelected();
        boolean bl2 = this._indentClosingBrace.isSelected();
        if (bl) {
            stringBuffer.append("     {\n");
        } else {
            stringBuffer.append(" {\n");
        }
        stringBuffer.append("     c = 0;\n");
        if (bl2) {
            stringBuffer.append("     }\n");
        } else {
            stringBuffer.append(" }\n");
        }
        stringBuffer.append(" else\n");
        if (bl) {
            stringBuffer.append("     {\n");
        } else {
            stringBuffer.append(" {\n");
        }
        stringBuffer.append("     c = 1;\n");
        if (bl2) {
            stringBuffer.append("     }");
        } else {
            stringBuffer.append(" }");
        }
        this._smartIndentSample.setText(stringBuffer.toString());
    }

    static class NonTraversableTextArea
    extends JTextArea {
        NonTraversableTextArea() {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }
}

