/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.editor;

import com.sybase.central.editor.Parser;
import com.sybase.central.editor.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WsqlParser
implements Parser {
    private String _singleLineComment = "//[^\n]*|\\-\\-[^\n]*";
    private String _multiLineComment = "/\\*.*?\\*/";
    private String _inMultiLineComment = "/\\*.*?$";
    private String _string = "'(?:[^']*'(?:'[^']*')*)";
    private String _openString = "'(?:[^'\\\\]++|\\\\.)*$";
    private String _identifierString = "\"[^\n]*?\"";
    private String _punctuation = "\\(|\\)|\\{|\\}|\\[|\\]|;|,|\\.";
    private String _operators = "[=]|[>]|[<]|[!]|[~]|[?]|[:]|[=][=]|[<][=]|[>][=]|[!][=]|[|][|]|[&][&]|[+][+]|[+]|[-]|[*]|[/]|[&]|[|]|[\\^]|[%]|[<][<]|[>][>]|[>][>][>]|[+][=]|[\\-][=]|[*][=]|[/][=]|[&][=]|[|][=]|[\\^][=]|[%][=]|[<][<][=]|[>][>][=]|[>][>][>][=]";
    private String _words = "\\b[a-zA-Z$_]\\w*\\b";
    private String _whiteSpace = "\\s";
    private String _hexNumber = "(?:[0][xX][0-9a-fA-F]+[lL]?)";
    private String _wholeNumber = "(?:[0-9]+(?![xX.eE])[lLdDfF]?)";
    private String _decimalNumber = "(?:[0-9]*[.][0-9]+[dDfF]?)";
    private String _exponentialNumber = "(?:(?:[0-9]*[.][0-9]+|[0-9]+[.]?[0-9]*)(?:[eE][+-]?[0-9]+)?[dDfF]?)";
    private String _number = "[+-]?(?:" + this._hexNumber + "|" + this._wholeNumber + "|" + this._decimalNumber + "|" + this._exponentialNumber + ")";
    private static final int PATTERN_COUNT = 11;
    private HashMap<String, String> _keywordHash = new HashMap(654);
    private Token _token;
    private Token _blankToken;
    private Pattern _pattern;
    private Matcher _matcher;
    private static WsqlParser INSTANCE;

    public WsqlParser() {
        this._keywordHash.put("select", "");
        this._keywordHash.put("and", "");
        this._keywordHash.put("or", "");
        this._keywordHash.put("prepare", "");
        this._keywordHash.put("commit", "");
        this._keywordHash.put("rollback", "");
        this._keywordHash.put("work", "");
        this._keywordHash.put("into", "");
        this._keywordHash.put("from", "");
        this._keywordHash.put("where", "");
        this._keywordHash.put("in", "");
        this._keywordHash.put("contains", "");
        this._keywordHash.put("between", "");
        this._keywordHash.put("is", "");
        this._keywordHash.put("not", "");
        this._keywordHash.put("null", "");
        this._keywordHash.put("some", "");
        this._keywordHash.put("any", "");
        this._keywordHash.put("exists", "");
        this._keywordHash.put("like", "");
        this._keywordHash.put("similar", "");
        this._keywordHash.put("regexp", "");
        this._keywordHash.put("if", "");
        this._keywordHash.put("then", "");
        this._keywordHash.put("else", "");
        this._keywordHash.put("elseif", "");
        this._keywordHash.put("endif", "");
        this._keywordHash.put("group", "");
        this._keywordHash.put("cube", "");
        this._keywordHash.put("rollup", "");
        this._keywordHash.put("with_cube", "");
        this._keywordHash.put("with_rollup", "");
        this._keywordHash.put("grouping", "");
        this._keywordHash.put("having", "");
        this._keywordHash.put("order", "");
        this._keywordHash.put("by", "");
        this._keywordHash.put("delete", "");
        this._keywordHash.put("current", "");
        this._keywordHash.put("current_timestamp", "");
        this._keywordHash.put("current_user", "");
        this._keywordHash.put("alter", "");
        this._keywordHash.put("table", "");
        this._keywordHash.put("rename", "");
        this._keywordHash.put("of", "");
        this._keywordHash.put("update", "");
        this._keywordHash.put("set", "");
        this._keywordHash.put("setuser", "");
        this._keywordHash.put("intersect", "");
        this._keywordHash.put("except", "");
        this._keywordHash.put("union", "");
        this._keywordHash.put("insert", "");
        this._keywordHash.put("values", "");
        this._keywordHash.put("create", "");
        this._keywordHash.put("sche", "");
        this._keywordHash.put("authorization", "");
        this._keywordHash.put("view", "");
        this._keywordHash.put("add", "");
        this._keywordHash.put("modify", "");
        this._keywordHash.put("char", "");
        this._keywordHash.put("integer", "");
        this._keywordHash.put("smallint", "");
        this._keywordHash.put("tinyint", "");
        this._keywordHash.put("bit", "");
        this._keywordHash.put("bigint", "");
        this._keywordHash.put("unsigned", "");
        this._keywordHash.put("decimal", "");
        this._keywordHash.put("numeric", "");
        this._keywordHash.put("float", "");
        this._keywordHash.put("real", "");
        this._keywordHash.put("double", "");
        this._keywordHash.put("date", "");
        this._keywordHash.put("precision", "");
        this._keywordHash.put("varchar", "");
        this._keywordHash.put("long", "");
        this._keywordHash.put("user", "");
        this._keywordHash.put("primary", "");
        this._keywordHash.put("foreign", "");
        this._keywordHash.put("key", "");
        this._keywordHash.put("check", "");
        this._keywordHash.put("for", "");
        this._keywordHash.put("unique", "");
        this._keywordHash.put("on", "");
        this._keywordHash.put("asc", "");
        this._keywordHash.put("desc", "");
        this._keywordHash.put("as", "");
        this._keywordHash.put("using", "");
        this._keywordHash.put("distinct", "");
        this._keywordHash.put("all", "");
        this._keywordHash.put("option", "");
        this._keywordHash.put("drop", "");
        this._keywordHash.put("index", "");
        this._keywordHash.put("grant", "");
        this._keywordHash.put("revoke", "");
        this._keywordHash.put("to", "");
        this._keywordHash.put("identified", "");
        this._keywordHash.put("privileges", "");
        this._keywordHash.put("connect", "");
        this._keywordHash.put("integrated", "");
        this._keywordHash.put("kerberos", "");
        this._keywordHash.put("login", "");
        this._keywordHash.put("connection", "");
        this._keywordHash.put("dba", "");
        this._keywordHash.put("resource", "");
        this._keywordHash.put("schedule", "");
        this._keywordHash.put("with", "");
        this._keywordHash.put("force", "");
        this._keywordHash.put("hold", "");
        this._keywordHash.put("lock", "");
        this._keywordHash.put("mode", "");
        this._keywordHash.put("dbspace", "");
        this._keywordHash.put("share", "");
        this._keywordHash.put("release", "");
        this._keywordHash.put("named", "");
        this._keywordHash.put("references", "");
        this._keywordHash.put("match", "");
        this._keywordHash.put("full", "");
        this._keywordHash.put("cascade", "");
        this._keywordHash.put("restrict", "");
        this._keywordHash.put("default", "");
        this._keywordHash.put("defaults", "");
        this._keywordHash.put("natural", "");
        this._keywordHash.put("inner", "");
        this._keywordHash.put("join", "");
        this._keywordHash.put("time", "");
        this._keywordHash.put("timestamp", "");
        this._keywordHash.put("comment", "");
        this._keywordHash.put("column", "");
        this._keywordHash.put("begin", "");
        this._keywordHash.put("end", "");
        this._keywordHash.put("subtransaction", "");
        this._keywordHash.put("savepoint", "");
        this._keywordHash.put("checkpoint", "");
        this._keywordHash.put("validate", "");
        this._keywordHash.put("temporary", "");
        this._keywordHash.put("true", "");
        this._keywordHash.put("false", "");
        this._keywordHash.put("unknown", "");
        this._keywordHash.put("escape", "");
        this._keywordHash.put("binary", "");
        this._keywordHash.put("varying", "");
        this._keywordHash.put("first", "");
        this._keywordHash.put("top", "");
        this._keywordHash.put("bottom", "");
        this._keywordHash.put("membership", "");
        this._keywordHash.put("outer", "");
        this._keywordHash.put("left", "");
        this._keywordHash.put("right", "");
        this._keywordHash.put("cross", "");
        this._keywordHash.put("cast", "");
        this._keywordHash.put("exclusive", "");
        this._keywordHash.put("variable", "");
        this._keywordHash.put("read", "");
        this._keywordHash.put("only", "");
        this._keywordHash.put("autoincrement", "");
        this._keywordHash.put("statistics", "");
        this._keywordHash.put("cache", "");
        this._keywordHash.put("optimizer", "");
        this._keywordHash.put("declare", "");
        this._keywordHash.put("procedure", "");
        this._keywordHash.put("function", "");
        this._keywordHash.put("result", "");
        this._keywordHash.put("resume", "");
        this._keywordHash.put("trigger", "");
        this._keywordHash.put("before", "");
        this._keywordHash.put("after", "");
        this._keywordHash.put("instead", "");
        this._keywordHash.put("referencing", "");
        this._keywordHash.put("when", "");
        this._keywordHash.put("each", "");
        this._keywordHash.put("row", "");
        this._keywordHash.put("statement", "");
        this._keywordHash.put("while", "");
        this._keywordHash.put("case", "");
        this._keywordHash.put("loop", "");
        this._keywordHash.put("leave", "");
        this._keywordHash.put("call", "");
        this._keywordHash.put("old", "");
        this._keywordHash.put("new", "");
        this._keywordHash.put("sqlstate", "");
        this._keywordHash.put("sqlcode", "");
        this._keywordHash.put("open", "");
        this._keywordHash.put("cursor", "");
        this._keywordHash.put("close", "");
        this._keywordHash.put("execute", "");
        this._keywordHash.put("fetch", "");
        this._keywordHash.put("last", "");
        this._keywordHash.put("prior", "");
        this._keywordHash.put("next", "");
        this._keywordHash.put("relative", "");
        this._keywordHash.put("absolute", "");
        this._keywordHash.put("no", "");
        this._keywordHash.put("dynamic", "");
        this._keywordHash.put("scroll", "");
        this._keywordHash.put("insensitive", "");
        this._keywordHash.put("sensitive", "");
        this._keywordHash.put("isolation", "");
        this._keywordHash.put("level", "");
        this._keywordHash.put("atomic", "");
        this._keywordHash.put("do", "");
        this._keywordHash.put("out", "");
        this._keywordHash.put("inout", "");
        this._keywordHash.put("value", "");
        this._keywordHash.put("exception", "");
        this._keywordHash.put("others", "");
        this._keywordHash.put("signal", "");
        this._keywordHash.put("resignal", "");
        this._keywordHash.put("recompile", "");
        this._keywordHash.put("print", "");
        this._keywordHash.put("raiserror", "");
        this._keywordHash.put("exec", "");
        this._keywordHash.put("output", "");
        this._keywordHash.put("break", "");
        this._keywordHash.put("continue", "");
        this._keywordHash.put("return", "");
        this._keywordHash.put("returns", "");
        this._keywordHash.put("save", "");
        this._keywordHash.put("immediate", "");
        this._keywordHash.put("message", "");
        this._keywordHash.put("transaction", "");
        this._keywordHash.put("global", "");
        this._keywordHash.put("local", "");
        this._keywordHash.put("preserve", "");
        this._keywordHash.put("rows", "");
        this._keywordHash.put("load", "");
        this._keywordHash.put("unload", "");
        this._keywordHash.put("truncate", "");
        this._keywordHash.put("constraint", "");
        this._keywordHash.put("constraints", "");
        this._keywordHash.put("datatype", "");
        this._keywordHash.put("quotes", "");
        this._keywordHash.put("quote", "");
        this._keywordHash.put("escapes", "");
        this._keywordHash.put("format", "");
        this._keywordHash.put("delimited", "");
        this._keywordHash.put("comments", "");
        this._keywordHash.put("introduced", "");
        this._keywordHash.put("append", "");
        this._keywordHash.put("strip", "");
        this._keywordHash.put("rtrim", "");
        this._keywordHash.put("ltrim", "");
        this._keywordHash.put("both", "");
        this._keywordHash.put("identity", "");
        this._keywordHash.put("capability", "");
        this._keywordHash.put("externlogin", "");
        this._keywordHash.put("forward", "");
        this._keywordHash.put("pctfree", "");
        this._keywordHash.put("syntax_error", "");
        this._keywordHash.put("convert", "");
        this._keywordHash.put("replicate", "");
        this._keywordHash.put("off", "");
        this._keywordHash.put("use", "");
        this._keywordHash.put("varbinary", "");
        this._keywordHash.put("publication", "");
        this._keywordHash.put("remote", "");
        this._keywordHash.put("subscription", "");
        this._keywordHash.put("type", "");
        this._keywordHash.put("info", "");
        this._keywordHash.put("warning", "");
        this._keywordHash.put("action", "");
        this._keywordHash.put("console", "");
        this._keywordHash.put("client", "");
        this._keywordHash.put("address", "");
        this._keywordHash.put("sent", "");
        this._keywordHash.put("received", "");
        this._keywordHash.put("reset", "");
        this._keywordHash.put("send", "");
        this._keywordHash.put("at", "");
        this._keywordHash.put("every", "");
        this._keywordHash.put("resend", "");
        this._keywordHash.put("rereceive", "");
        this._keywordHash.put("start", "");
        this._keywordHash.put("synchronize", "");
        this._keywordHash.put("synchronization", "");
        this._keywordHash.put("definition", "");
        this._keywordHash.put("template", "");
        this._keywordHash.put("subscribe", "");
        this._keywordHash.put("consolidate", "");
        this._keywordHash.put("confirm", "");
        this._keywordHash.put("publish", "");
        this._keywordHash.put("publisher", "");
        this._keywordHash.put("database", "");
        this._keywordHash.put("passthrough", "");
        this._keywordHash.put("stop", "");
        this._keywordHash.put("encrypted", "");
        this._keywordHash.put("compressed", "");
        this._keywordHash.put("hidden", "");
        this._keywordHash.put("clustered", "");
        this._keywordHash.put("nonclustered", "");
        this._keywordHash.put("virtual", "");
        this._keywordHash.put("external", "");
        this._keywordHash.put("internal", "");
        this._keywordHash.put("name", "");
        this._keywordHash.put("writetext", "");
        this._keywordHash.put("readtext", "");
        this._keywordHash.put("log", "");
        this._keywordHash.put("bulk", "");
        this._keywordHash.put("holdlock", "");
        this._keywordHash.put("noholdlock", "");
        this._keywordHash.put("verify", "");
        this._keywordHash.put("tsequal", "");
        this._keywordHash.put("resolve", "");
        this._keywordHash.put("deallocate", "");
        this._keywordHash.put("domain", "");
        this._keywordHash.put("fillfactor", "");
        this._keywordHash.put("maximum", "");
        this._keywordHash.put("hash", "");
        this._keywordHash.put("comparisons", "");
        this._keywordHash.put("tries", "");
        this._keywordHash.put("ignore_dup_key", "");
        this._keywordHash.put("ignore_dup_row", "");
        this._keywordHash.put("allow_dup_row", "");
        this._keywordHash.put("sorted_data", "");
        this._keywordHash.put("goto", "");
        this._keywordHash.put("char_convert", "");
        this._keywordHash.put("prefetch", "");
        this._keywordHash.put("lru", "");
        this._keywordHash.put("mru", "");
        this._keywordHash.put("mirror", "");
        this._keywordHash.put("respect", "");
        this._keywordHash.put("ignore", "");
        this._keywordHash.put("page", "");
        this._keywordHash.put("size", "");
        this._keywordHash.put("collation", "");
        this._keywordHash.put("blank", "");
        this._keywordHash.put("padding", "");
        this._keywordHash.put("ase", "");
        this._keywordHash.put("server", "");
        this._keywordHash.put("compatible", "");
        this._keywordHash.put("parallel", "");
        this._keywordHash.put("path", "");
        this._keywordHash.put("block", "");
        this._keywordHash.put("notify", "");
        this._keywordHash.put("existing", "");
        this._keywordHash.put("error", "");
        this._keywordHash.put("skip", "");
        this._keywordHash.put("byte", "");
        this._keywordHash.put("ascii", "");
        this._keywordHash.put("filler", "");
        this._keywordHash.put("datetime", "");
        this._keywordHash.put("prefix", "");
        this._keywordHash.put("bcp", "");
        this._keywordHash.put("factor", "");
        this._keywordHash.put("blanks", "");
        this._keywordHash.put("zeros", "");
        this._keywordHash.put("status", "");
        this._keywordHash.put("limit", "");
        this._keywordHash.put("readonly", "");
        this._keywordHash.put("nulls", "");
        this._keywordHash.put("location", "");
        this._keywordHash.put("write", "");
        this._keywordHash.put("#IFDEF", "");
        this._keywordHash.put("iq", "");
        this._keywordHash.put("id", "");
        this._keywordHash.put("native", "");
        this._keywordHash.put("finish", "");
        this._keywordHash.put("preview", "");
        this._keywordHash.put("utilities", "");
        this._keywordHash.put("main", "");
        this._keywordHash.put("private", "");
        this._keywordHash.put("command", "");
        this._keywordHash.put("monitor", "");
        this._keywordHash.put("allocate", "");
        this._keywordHash.put("packetsize", "");
        this._keywordHash.put("partial", "");
        this._keywordHash.put("unenforced", "");
        this._keywordHash.put("cancel", "");
        this._keywordHash.put("hg", "");
        this._keywordHash.put("hng", "");
        this._keywordHash.put("lf", "");
        this._keywordHash.put("ld", "");
        this._keywordHash.put("fp", "");
        this._keywordHash.put("cmp", "");
        this._keywordHash.put("wd", "");
        this._keywordHash.put("high", "");
        this._keywordHash.put("low", "");
        this._keywordHash.put("dttm", "");
        this._keywordHash.put("readwrite", "");
        this._keywordHash.put("relocate", "");
        this._keywordHash.put("reserve", "");
        this._keywordHash.put("space", "");
        this._keywordHash.put("writeserver", "");
        this._keywordHash.put("dbspacename", "");
        this._keywordHash.put("decoupled", "");
        this._keywordHash.put("transfer", "");
        this._keywordHash.put("encapsulated", "");
        this._keywordHash.put("word", "");
        this._keywordHash.put("aes_decrypt", "");
        this._keywordHash.put("move", "");
        this._keywordHash.put("striping", "");
        this._keywordHash.put("stripesizekb", "");
        this._keywordHash.put("online", "");
        this._keywordHash.put("offline", "");
        this._keywordHash.put("multiplex", "");
        this._keywordHash.put("#IFDEF", "");
        this._keywordHash.put("logical", "");
        this._keywordHash.put("ls", "");
        this._keywordHash.put("#ENDIF", "");
        this._keywordHash.put("host", "");
        this._keywordHash.put("port", "");
        this._keywordHash.put("role", "");
        this._keywordHash.put("reader", "");
        this._keywordHash.put("writer", "");
        this._keywordHash.put("coordinator", "");
        this._keywordHash.put("assign", "");
        this._keywordHash.put("included", "");
        this._keywordHash.put("excluded", "");
        this._keywordHash.put("active", "");
        this._keywordHash.put("version", "");
        this._keywordHash.put("versions", "");
        this._keywordHash.put("unpartition", "");
        this._keywordHash.put("metadata", "");
        this._keywordHash.put("split", "");
        this._keywordHash.put("files", "");
        this._keywordHash.put("dbspaces", "");
        this._keywordHash.put("updatetime", "");
        this._keywordHash.put("createtime", "");
        this._keywordHash.put("commitid", "");
        this._keywordHash.put("perms", "");
        this._keywordHash.put("operator", "");
        this._keywordHash.put("admin", "");
        this._keywordHash.put("#ENDIF", "");
        this._keywordHash.put("file", "");
        this._keywordHash.put("temp", "");
        this._keywordHash.put("catalog", "");
        this._keywordHash.put("store", "");
        this._keywordHash.put("install", "");
        this._keywordHash.put("remove", "");
        this._keywordHash.put("java", "");
        this._keywordHash.put("jar", "");
        this._keywordHash.put("ejb", "");
        this._keywordHash.put("class", "");
        this._keywordHash.put("package", "");
        this._keywordHash.put("retain", "");
        this._keywordHash.put("classes", "");
        this._keywordHash.put("compute", "");
        this._keywordHash.put("hexadecimal", "");
        this._keywordHash.put("upgrade", "");
        this._keywordHash.put("jconnect", "");
        this._keywordHash.put("checksum", "");
        this._keywordHash.put("backup", "");
        this._keywordHash.put("restore", "");
        this._keywordHash.put("crc", "");
        this._keywordHash.put("attended", "");
        this._keywordHash.put("incremental", "");
        this._keywordHash.put("since", "");
        this._keywordHash.put("dbfile", "");
        this._keywordHash.put("directory", "");
        this._keywordHash.put("stacker", "");
        this._keywordHash.put("session", "");
        this._keywordHash.put("component", "");
        this._keywordHash.put("language", "");
        this._keywordHash.put("sets", "");
        this._keywordHash.put("autostop", "");
        this._keywordHash.put("unconditionally", "");
        this._keywordHash.put("site", "");
        this._keywordHash.put("data", "");
        this._keywordHash.put("engine", "");
        this._keywordHash.put("event", "");
        this._keywordHash.put("handler", "");
        this._keywordHash.put("hours", "");
        this._keywordHash.put("minutes", "");
        this._keywordHash.put("seconds", "");
        this._keywordHash.put("days", "");
        this._keywordHash.put("description", "");
        this._keywordHash.put("disable", "");
        this._keywordHash.put("enable", "");
        this._keywordHash.put("consolidated", "");
        this._keywordHash.put("wait", "");
        this._keywordHash.put("reorganize", "");
        this._keywordHash.put("utc", "");
        this._keywordHash.put("express", "");
        this._keywordHash.put("activ", "");
        this._keywordHash.put("inactiv", "");
        this._keywordHash.put("jdk", "");
        this._keywordHash.put("algorithm", "");
        this._keywordHash.put("decrypted", "");
        this._keywordHash.put("decrypt", "");
        this._keywordHash.put("optimization", "");
        this._keywordHash.put("logging", "");
        this._keywordHash.put("calibration", "");
        this._keywordHash.put("calibrate", "");
        this._keywordHash.put("waitfor", "");
        this._keywordHash.put("delay", "");
        this._keywordHash.put("inserting", "");
        this._keywordHash.put("updating", "");
        this._keywordHash.put("deleting", "");
        this._keywordHash.put("xml", "");
        this._keywordHash.put("raw", "");
        this._keywordHash.put("auto", "");
        this._keywordHash.put("explicit", "");
        this._keywordHash.put("root", "");
        this._keywordHash.put("over", "");
        this._keywordHash.put("plan", "");
        this._keywordHash.put("with_lparen", "");
        this._keywordHash.put("index_lparen", "");
        this._keywordHash.put("nolock", "");
        this._keywordHash.put("paglock", "");
        this._keywordHash.put("readcommitted", "");
        this._keywordHash.put("readpast", "");
        this._keywordHash.put("readuncommitted", "");
        this._keywordHash.put("repeatableread", "");
        this._keywordHash.put("repeatable", "");
        this._keywordHash.put("committed", "");
        this._keywordHash.put("uncommitted", "");
        this._keywordHash.put("rowlock", "");
        this._keywordHash.put("serializable", "");
        this._keywordHash.put("tablock", "");
        this._keywordHash.put("tablockx", "");
        this._keywordHash.put("updlock", "");
        this._keywordHash.put("xlock", "");
        this._keywordHash.put("fastfirstrow", "");
        this._keywordHash.put("input", "");
        this._keywordHash.put("deterministic", "");
        this._keywordHash.put("elements", "");
        this._keywordHash.put("password", "");
        this._keywordHash.put("pages", "");
        this._keywordHash.put("bytes", "");
        this._keywordHash.put("kb", "");
        this._keywordHash.put("mb", "");
        this._keywordHash.put("gb", "");
        this._keywordHash.put("tb", "");
        this._keywordHash.put("computes", "");
        this._keywordHash.put("transactional", "");
        this._keywordHash.put("density", "");
        this._keywordHash.put("recursive", "");
        this._keywordHash.put("with_auto", "");
        this._keywordHash.put("lateral", "");
        this._keywordHash.put("service", "");
        this._keywordHash.put("secure", "");
        this._keywordHash.put("url", "");
        this._keywordHash.put("web", "");
        this._keywordHash.put("resizing", "");
        this._keywordHash.put("within", "");
        this._keywordHash.put("partition", "");
        this._keywordHash.put("range", "");
        this._keywordHash.put("unbounded", "");
        this._keywordHash.put("preceding", "");
        this._keywordHash.put("following", "");
        this._keywordHash.put("exclude", "");
        this._keywordHash.put("ties", "");
        this._keywordHash.put("window", "");
        this._keywordHash.put("columns", "");
        this._keywordHash.put("encoding", "");
        this._keywordHash.put("debug", "");
        this._keywordHash.put("namespace", "");
        this._keywordHash.put("certificate", "");
        this._keywordHash.put("batch", "");
        this._keywordHash.put("proxy", "");
        this._keywordHash.put("clientport", "");
        this._keywordHash.put("header", "");
        this._keywordHash.put("soapheader", "");
        this._keywordHash.put("uniqueidentifier", "");
        this._keywordHash.put("varbit", "");
        this._keywordHash.put("conflict", "");
        this._keywordHash.put("history", "");
        this._keywordHash.put("materialized", "");
        this._keywordHash.put("build", "");
        this._keywordHash.put("refresh", "");
        this._keywordHash.put("dependencies", "");
        this._keywordHash.put("copy", "");
        this._keywordHash.put("recover", "");
        this._keywordHash.put("system", "");
        this._keywordHash.put("tune", "");
        this._keywordHash.put("writers", "");
        this._keywordHash.put("snapshot", "");
        this._keywordHash.put("scripted", "");
        this._keywordHash.put("logscan", "");
        this._keywordHash.put("upload", "");
        this._keywordHash.put("download", "");
        this._keywordHash.put("nchar", "");
        this._keywordHash.put("nvarchar", "");
        this._keywordHash.put("tracing", "");
        this._keywordHash.put("attach", "");
        this._keywordHash.put("detach", "");
        this._keywordHash.put("without", "");
        this._keywordHash.put("french", "");
        this._keywordHash.put("accent", "");
        this._keywordHash.put("inline", "");
        this._keywordHash.put("simple", "");
        this._keywordHash.put("national", "");
        this._keywordHash.put("fresh", "");
        this._keywordHash.put("stale", "");
        this._keywordHash.put("disabled", "");
        this._keywordHash.put("rebuild", "");
        this._keywordHash.put("olap", "");
        this._keywordHash.put("workload", "");
        this._keywordHash.put("partner", "");
        this._keywordHash.put("failover", "");
        this._keywordHash.put("keep", "");
        this._keywordHash.put("dense_rank", "");
        this._keywordHash.put("text", "");
        this._keywordHash.put("configuration", "");
        this._keywordHash.put("term", "");
        this._keywordHash.put("breaker", "");
        this._keywordHash.put("stemmer", "");
        this._keywordHash.put("stoplist", "");
        this._keywordHash.put("minimum", "");
        this._keywordHash.put("length", "");
        this._keywordHash.put("prefilter", "");
        this._keywordHash.put("postfilter", "");
        this._keywordHash.put("populate", "");
        this._keywordHash.put("merge", "");
        this._keywordHash.put("matched", "");
        this._keywordHash.put("writefile", "");
        this._keywordHash.put("readfile", "");
        this._keywordHash.put("openstring", "");
        this._keywordHash.put("content", "");
        this._keywordHash.put("profile", "");
        this._keywordHash.put("indexonly", "");
        this._keywordHash.put("intersection", "");
        this._keywordHash.put("apply", "");
        this._keywordHash.put("manual", "");
        this._keywordHash.put("methods", "");
        this._keywordHash.put("readclientfile", "");
        this._keywordHash.put("writeclientfile", "");
        this._keywordHash.put("sql", "");
        this._keywordHash.put("security", "");
        this._keywordHash.put("invoker", "");
        this._keywordHash.put("definer", "");
        this._keywordHash.put("list", "");
        this._keywordHash.put("partitions", "");
        this._keywordHash.put("mark", "");
        this._keywordHash.put("policy", "");
        this._keywordHash.put("unlimited", "");
        this._keywordHash.put("expiry", "");
        this._keywordHash.put("environment", "");
        this._keywordHash.put("scope", "");
        this._keywordHash.put("object", "");
        this._keywordHash.put("quiesce", "");
        this._keywordHash.put("unquiesce", "");
        this._keywordHash.put("databases", "");
        this._keywordHash.put("replace", "");
        this._keywordHash.put("change", "");
        this._keywordHash.put("#IFDEF", "");
        this._keywordHash.put("aggregate", "");
        this._keywordHash.put("allowed", "");
        this._keywordHash.put("required", "");
        this._keywordHash.put("duplicate", "");
        this._keywordHash.put("frame", "");
        this._keywordHash.put("empty", "");
        this._keywordHash.put("#ENDIF", "");
        this._keywordHash.put("generic", "");
        this._keywordHash.put("ngram", "");
        this._keywordHash.put("#IFDEF", "");
        this._keywordHash.put("free", "");
        this._keywordHash.put("#ENDIF", "");
        this._keywordHash.put("dec", "");
        this._keywordHash.put("int", "");
        this._keywordHash.put("character", "");
        this._keywordHash.put("options", "");
        this._keywordHash.put("subtrans", "");
        this._keywordHash.put("reference", "");
        this._keywordHash.put("proc", "");
        this._keywordHash.put("tran", "");
        this._pattern = Pattern.compile("(" + this._singleLineComment + ")|(" + this._multiLineComment + ")|(" + this._inMultiLineComment + ")|(" + this._string + ")|(" + this._openString + ")|(" + this._identifierString + ")|(" + this._number + ")|(" + this._punctuation + ")|(" + this._operators + ")|(" + this._words + ")|(" + this._whiteSpace + ")", 32);
        this._blankToken = new Token();
        this._blankToken.image = "";
        this._blankToken.beginsAt = 0;
        this._blankToken.kind = 99;
    }

    @Override
    public void ReInit(InputStream inputStream) {
    }

    @Override
    public void ReInit(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            int n = reader.read();
            while (n > -1) {
                stringBuffer.append((char)n);
                n = reader.read();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._matcher = this._pattern.matcher(stringBuffer);
    }

    @Override
    public Token getNextToken() {
        if (this._matcher.find()) {
            for (int i = 1; i <= 11; ++i) {
                String string = this._matcher.group(i);
                if (string == null) continue;
                this._token = new Token();
                this._token.image = string;
                this._token.beginsAt = this._matcher.start();
                this._token.kind = i - 1;
                break;
            }
        }
        return this._blankToken;
    }

    @Override
    public int getBeginOffset() {
        return this._matcher.start();
    }

    @Override
    public int getEndOffset() {
        try {
            return this._matcher.end() - 1;
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    @Override
    public char readChar() throws IOException {
        return '\u0000';
    }

    @Override
    public Token getToken(int n) {
        if (this._token != null) {
            return this._token;
        }
        return this._blankToken;
    }

    @Override
    public int getCategory(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 7;
            }
            case 9: {
                if (this._keywordHash.containsKey(this._token.toString().toLowerCase())) {
                    return 1;
                }
                return 0;
            }
            case 10: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String getBlockBegin() {
        return "begin";
    }

    @Override
    public String getBlockEnd() {
        return "end";
    }

    @Override
    public String getStatementEnd() {
        return ";";
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean isScanWholeDocument() {
        return true;
    }

    public Set<String> getKeywords() {
        return WsqlParser.getInstance()._keywordHash.keySet();
    }

    public static WsqlParser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WsqlParser();
        }
        return INSTANCE;
    }
}

