/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseisqlplugin;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.asa.logon.LogonException;
import com.sybase.asa.logon.LogonSource;
import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.logon.ASEDatabaseSource;
import com.sybase.ase.logon.NewPasswordDialogProxy;
import com.sybase.aseisqlplugin.ASEBundleBase;
import com.sybase.aseisqlplugin.ASECustomizable;
import com.sybase.aseisqlplugin.ASEPlanViewer;
import com.sybase.aseisqlplugin.ConnectionData;
import com.sybase.aseisqlplugin.JConnectMessageHandler;
import com.sybase.aseisqlplugin.Preference;
import com.sybase.customization.Customizable;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.CommandLineOption;
import com.sybase.util.CommandLineOptionMetaData;
import com.sybase.util.CommandLineParser;
import com.sybase.util.LineSplitter;
import com.sybase.util.ReflectionProxyException;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLHost;
import sybase.isql.ISQLPlanViewer;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLPluginException;
import sybase.isql.ISQLPreference;

public class ASEISQLPlugin
implements ISQLPlugin {
    private static final int CONNECTION_STRING = 0;
    private static final int COMMAND_DELIMITER = 1;
    private static final int HOST = 2;
    private static final int PORT = 3;
    private static final int DEFAULT_TO_ASE = 5;
    private static final int UNKNOWN_OPTION = 6;
    private static Hashtable<ISQLConnection, ConnectionData> _connectionDataTable;
    private static ASEISQLPlugin _this;
    private static ISQLHost _isqlHost;
    private static HelpViewer _helpViewer;
    private static final String[] PreferenceNamesAndDefaults;
    static Hashtable<String, Preference> _defaultPreferences;

    public ASEISQLPlugin() {
        _this = this;
        _connectionDataTable = new Hashtable();
    }

    private CommandLineOptionMetaData[] getCommandLineOptionMetaData() {
        return new CommandLineOptionMetaData[]{new CommandLineOptionMetaData("d", 1, 1), new CommandLineOptionMetaData("c", 1, 0), new CommandLineOptionMetaData("ase", 0, 5), new CommandLineOptionMetaData("host", 1, 2), new CommandLineOptionMetaData("port", 2, 3), new CommandLineOptionMetaData("", 6, 6)};
    }

    public String[] processCommandLineOptions(String[] stringArray) {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            CommandLineOptionMetaData[] commandLineOptionMetaDataArray = this.getCommandLineOptionMetaData();
            CommandLineOption[] commandLineOptionArray = CommandLineParser.parse((String)"dbisql", (String[])stringArray, (CommandLineOptionMetaData[])commandLineOptionMetaDataArray);
            if (commandLineOptionArray != null) {
                block9: for (int i = 0; i < commandLineOptionArray.length; ++i) {
                    switch (commandLineOptionArray[i].getID()) {
                        case 1: {
                            Preference.setCommandDelimiterOverride(commandLineOptionArray[i].getValue());
                            continue block9;
                        }
                        case 2: {
                            arrayList.add("-host");
                            arrayList.add(commandLineOptionArray[i].getValue());
                            continue block9;
                        }
                        case 3: {
                            arrayList.add("-port");
                            arrayList.add(Integer.toString(commandLineOptionArray[i].getIntValue()));
                            continue block9;
                        }
                        case 0: {
                            arrayList.add("-c");
                            arrayList.add(commandLineOptionArray[i].getValue());
                            continue block9;
                        }
                        case 6: {
                            arrayList.add(commandLineOptionArray[i].getValue());
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (arrayList.size() == 0) {
            stringArray2 = stringArray;
        } else {
            stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
        }
        return stringArray2;
    }

    public AbstractConnectionInfo getConnectionInfoFromCommandLineOptions(String[] stringArray, ISQLPlugin.CommandLineOptionAffinity commandLineOptionAffinity) {
        ASEConnectionInfo aSEConnectionInfo;
        block12: {
            aSEConnectionInfo = null;
            try {
                int n;
                boolean bl;
                CommandLineOptionMetaData[] commandLineOptionMetaDataArray = this.getCommandLineOptionMetaData();
                CommandLineOption[] commandLineOptionArray = CommandLineParser.parse((String)"dbisql", (String[])stringArray, (CommandLineOptionMetaData[])commandLineOptionMetaDataArray);
                if (commandLineOptionArray == null) break block12;
                if (commandLineOptionAffinity != ISQLPlugin.CommandLineOptionAffinity.NONE) {
                    bl = false;
                    for (n = 0; n < commandLineOptionArray.length; ++n) {
                        if (commandLineOptionArray[n].getID() != 5) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    aSEConnectionInfo = new ASEConnectionInfo();
                    block8: for (n = 0; n < commandLineOptionArray.length; ++n) {
                        switch (commandLineOptionArray[n].getID()) {
                            case 2: {
                                aSEConnectionInfo.host = commandLineOptionArray[n].getValue();
                                continue block8;
                            }
                            case 3: {
                                aSEConnectionInfo.port = commandLineOptionArray[n].getIntValue();
                                continue block8;
                            }
                            case 0: {
                                aSEConnectionInfo.mergeConnectionString(commandLineOptionArray[n].getValue());
                                continue block8;
                            }
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return aSEConnectionInfo;
    }

    public AbstractConnectionInfo getConnectionInfo() {
        ASEConnectionInfo aSEConnectionInfo = new ASEConnectionInfo();
        aSEConnectionInfo.setProperty("APPLICATIONNAME", "DBISQL");
        return aSEConnectionInfo;
    }

    public boolean supportsODBCDriver(String string) {
        return false;
    }

    public Connection connect(ISQLConnection iSQLConnection, AbstractConnectionInfo abstractConnectionInfo) throws ISQLPluginException {
        Connection connection = null;
        try {
            abstractConnectionInfo.setClassLoader(this.getClass().getClassLoader());
            connection = JDBCDrivers.connect((AbstractConnectionInfo)abstractConnectionInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ISQLPluginException(ASEBundleBase.getBundle().getString("ERR_COULD_NOT_LOAD_DATABASE_DRIVER"), (Throwable)classNotFoundException);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = null;
            if (sQLException.getSQLState() == "01ZZZ") {
                String string = null;
                try {
                    while (true) {
                        NewPasswordDialogProxy newPasswordDialogProxy = new NewPasswordDialogProxy(null, abstractConnectionInfo.getPassword(), this.getClass().getClassLoader());
                        if (string != null) {
                            newPasswordDialogProxy.setNewPassword(string);
                        }
                        if ((string = newPasswordDialogProxy.create()) == null) {
                            sQLException2 = sQLException;
                        }
                        String string2 = abstractConnectionInfo.getURL();
                        string2 = string2 + "?NEWPASSWORD=" + string;
                        try {
                            connection = DriverManager.getConnection(string2.toString(), ((ASEConnectionInfo)abstractConnectionInfo).getProperties());
                            abstractConnectionInfo.setPassword(string);
                        }
                        catch (SQLException sQLException3) {
                            SybOptionPane.showMessageDialog((Component)((Component)newPasswordDialogProxy.getObject()), (Object)sQLException3.getMessage(), (String)ASEBundleBase.getBundle().getString("ISQL_CAPTION"), (int)0);
                            continue;
                        }
                        break;
                    }
                }
                catch (ReflectionProxyException reflectionProxyException) {}
            } else {
                sQLException2 = sQLException;
            }
            if (sQLException2 != null) {
                throw new ISQLPluginException(ASEBundleBase.getBundle().getFormattedString("ERR_COULD_NOT_CONNECT", sQLException2.getLocalizedMessage()), (Throwable)sQLException2);
            }
        }
        catch (LogonException logonException) {
            String string = logonException.getMessage();
            if (string == null) {
                string = "";
            }
            throw new ISQLPluginException(ASEBundleBase.getBundle().getFormattedString("ERR_COULD_NOT_CONNECT", logonException.getLocalizedMessage()), (Throwable)logonException);
        }
        if (iSQLConnection != null && connection != null) {
            this.initializeConnection(iSQLConnection, connection);
        }
        return connection;
    }

    static ConnectionData getConnectionData(ISQLConnection iSQLConnection) {
        ConnectionData connectionData = _connectionDataTable.get(iSQLConnection);
        return connectionData;
    }

    public void disconnect(ISQLConnection iSQLConnection) throws ISQLPluginException {
        block8: {
            String string;
            boolean bl = true;
            Connection connection = iSQLConnection.getJDBCConnection();
            if (connection instanceof SybConnection) {
                ((SybConnection)connection).setSybMessageHandler(null);
            }
            if ("On".equals(string = this.getStringPreference(iSQLConnection, "commitOnExit"))) {
                try {
                    if (!connection.isClosed()) {
                        connection.commit();
                    }
                }
                catch (SQLException sQLException) {
                    String string2 = ASEISQLPlugin.gatherSQLExceptionInfo("ERR_COULD_NOT_COMMIT_BEFORE_DISCONNECTING", sQLException);
                    _isqlHost.getDefaultIO().writeln(string2, 2);
                    bl = false;
                }
            }
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                if (!bl) break block8;
                throw new ISQLPluginException(ASEBundleBase.getBundle().getFormattedString("ERR_COULD_NOT_DISCONNECT", sQLException.getLocalizedMessage()), (Throwable)sQLException);
            }
        }
    }

    private static String gatherSQLExceptionInfo(String string, SQLException sQLException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ASEBundleBase.getBundle().getString(string));
        stringBuilder.append("\n");
        stringBuilder.append(ASEISQLPlugin.formatSQLExceptionMessage(sQLException));
        stringBuilder.append("\n");
        SQLException sQLException2 = sQLException.getNextException();
        if (sQLException2 != null) {
            stringBuilder.append("\n");
            stringBuilder.append(sQLException2.getMessage());
        }
        return stringBuilder.toString();
    }

    private static String formatSQLExceptionMessage(SQLException sQLException) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        ASEBundleBase aSEBundleBase = ASEBundleBase.getBundle();
        String string2 = sQLException.getLocalizedMessage();
        if (string2 != null && string2.length() > 0) {
            Pattern pattern = Pattern.compile("\\A(\\[[^\\]]+\\])+");
            Matcher matcher = pattern.matcher(string2);
            LineSplitter lineSplitter = matcher.find() ? new LineSplitter(string2.substring(matcher.end()), 72) : new LineSplitter(string2, 72);
            while (lineSplitter.hasMoreLines()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(lineSplitter.nextLine());
            }
        }
        if ((string = sQLException.getSQLState()) == null) {
            string = aSEBundleBase.getString("ERR_NO_SQLSTATE");
        }
        stringBuilder.append("\n");
        stringBuilder.append(aSEBundleBase.getFormattedString("ERR_SQLCODE_AND_ODBC_3_STATE", Integer.toString(sQLException.getErrorCode()), string));
        return stringBuilder.toString();
    }

    protected void initializeConnection(ISQLConnection iSQLConnection, Connection connection) {
        JConnectMessageHandler jConnectMessageHandler = new JConnectMessageHandler(iSQLConnection);
        if (connection instanceof SybConnection) {
            ((SybConnection)connection).setSybMessageHandler((SybMessageHandler)jConnectMessageHandler);
        }
        ConnectionData connectionData = new ConnectionData(connection, jConnectMessageHandler, this.createPreferenceSet());
        _connectionDataTable.put(iSQLConnection, connectionData);
        this.setOptions(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOptions(Connection connection) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("set quoted_identifier off");
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
    }

    static ASEISQLPlugin getPlugin() {
        return _this;
    }

    ISQLHost getISQLHost() {
        return _isqlHost;
    }

    public static String getHelpFolder() {
        String string = System.getProperty("isql.helpFolder");
        String string2 = System.getProperty("file.separator");
        if (string == null || string.isEmpty()) {
            string = System.getenv("SYBROOT");
            if (string == null || string.isEmpty()) {
                string = ".";
            } else {
                if (!string.endsWith(string2)) {
                    string = string + string2;
                }
                string = string + "dbisql" + string2 + "help";
            }
        } else if (string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        return string;
    }

    public static String getHelpPrefix() {
        return "dbma";
    }

    public static String getHelpSuffix() {
        return Integer.toString(11);
    }

    String getStringPreference(ISQLConnection iSQLConnection, String string) {
        Hashtable<String, Preference> hashtable = _connectionDataTable.get(iSQLConnection).getPreferences();
        Preference preference = hashtable.get(string);
        String string2 = preference == null ? _isqlHost.getStringPreference(iSQLConnection, this.getPluginID(), string) : preference.getValue();
        return string2;
    }

    int getIntPreference(ISQLConnection iSQLConnection, String string) {
        int n;
        String string2 = this.getStringPreference(iSQLConnection, string);
        try {
            n = Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    void setStringPreference(ISQLConnection iSQLConnection, String string, String string2) {
        ConnectionData connectionData;
        Hashtable<String, Preference> hashtable = null;
        if (iSQLConnection != null && (connectionData = _connectionDataTable.get(iSQLConnection)) != null) {
            hashtable = _connectionDataTable.get(iSQLConnection).getPreferences();
        }
        if (hashtable == null) {
            hashtable = _defaultPreferences;
        }
        Preference preference = hashtable.get(string);
        preference.setValue(string2);
    }

    void setBooleanPreference(ISQLConnection iSQLConnection, String string, boolean bl) {
        this.setStringPreference(iSQLConnection, string, bl ? "1" : "0");
    }

    void setIntPreference(ISQLConnection iSQLConnection, String string, int n) {
        this.setStringPreference(iSQLConnection, string, Integer.toString(n));
    }

    public ISQLPreference[] getPreferences(ISQLConnection iSQLConnection) {
        Hashtable<String, Preference> hashtable;
        ConnectionData connectionData;
        ISQLPreference[] iSQLPreferenceArray = null;
        if (iSQLConnection != null && (connectionData = _connectionDataTable.get(iSQLConnection)) != null && (hashtable = connectionData.getPreferences()) != null) {
            Collection<Preference> collection = hashtable.values();
            iSQLPreferenceArray = new ISQLPreference[hashtable.size()];
            int n = 0;
            for (Preference preference : collection) {
                iSQLPreferenceArray[n++] = preference;
            }
        }
        return iSQLPreferenceArray;
    }

    private Hashtable<String, Preference> createPreferenceSet() {
        Hashtable<String, Preference> hashtable = new Hashtable<String, Preference>();
        if (_defaultPreferences == null) {
            ISQLPreference[] iSQLPreferenceArray = _isqlHost.getSavedPluginPreferences(this.getPluginID());
            String[] stringArray = _isqlHost.getLockedPluginPreferences(this.getPluginID());
            String[] stringArray2 = _isqlHost.getOverriddenPluginPreferences(this.getPluginID());
            block0: for (int i = 0; i < PreferenceNamesAndDefaults.length; i += 2) {
                String string;
                int n;
                String string2 = PreferenceNamesAndDefaults[i];
                String string3 = PreferenceNamesAndDefaults[i + 1];
                if (iSQLPreferenceArray != null) {
                    for (n = 0; n < iSQLPreferenceArray.length; ++n) {
                        String string4 = iSQLPreferenceArray[n].getName();
                        if (!string4.equalsIgnoreCase(string2)) continue;
                        string = iSQLPreferenceArray[n].getValue();
                        hashtable.put(string2, new Preference(string2, string3, string, iSQLPreferenceArray[n].isLocked()));
                        continue block0;
                    }
                }
                string = string3;
                if (stringArray2 != null) {
                    for (n = 0; n < stringArray2.length; n += 2) {
                        if (!stringArray2[n].equalsIgnoreCase(string2)) continue;
                        string = stringArray2[n + 1];
                        break;
                    }
                }
                boolean bl = false;
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (!stringArray[n].equals(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                hashtable.put(string2, new Preference(string2, string3, string, bl));
            }
            _defaultPreferences = hashtable;
        } else {
            for (int i = 0; i < PreferenceNamesAndDefaults.length; i += 2) {
                String string = PreferenceNamesAndDefaults[i];
                hashtable.put(string, _defaultPreferences.get(string));
            }
        }
        return hashtable;
    }

    public String[] getPreferenceValues(ISQLConnection iSQLConnection, String ... stringArray) {
        ConnectionData connectionData;
        Hashtable<String, Preference> hashtable = null;
        if (iSQLConnection != null && (connectionData = _connectionDataTable.get(iSQLConnection)) != null) {
            hashtable = connectionData.getPreferences();
        }
        if (hashtable == null) {
            hashtable = this.createPreferenceSet();
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Preference preference = hashtable.get(stringArray[i]);
            if (preference == null) continue;
            stringArray2[i] = preference.getValue();
        }
        return stringArray2;
    }

    public void setPreferenceValue(ISQLConnection iSQLConnection, boolean bl, String string, String string2) {
        Hashtable<String, Preference> hashtable;
        Preference preference;
        boolean bl2 = false;
        ConnectionData connectionData = _connectionDataTable.get(iSQLConnection);
        if (connectionData != null && (preference = (hashtable = connectionData.getPreferences()).get(string)) != null) {
            if (bl) {
                preference.setTempValue(string2);
            } else {
                preference.setValue(string2);
            }
            bl2 = true;
        }
    }

    public boolean setISQLHost(ISQLHost iSQLHost) {
        boolean bl = true;
        int[] nArray = iSQLHost.getVersion();
        if (nArray[0] < 11) {
            bl = false;
        } else {
            _isqlHost = iSQLHost;
        }
        return bl;
    }

    public String getPluginID() {
        return "ASE";
    }

    public String getPluginName() {
        return ASEBundleBase.getBundle().getString("ASE_PLUGIN_NAME");
    }

    public Image getPluginImage(int n) {
        return ASAComponentsImageLoader.getImageIcon((String)"ase", (int)1001).getImage();
    }

    public LogonSource getLogonSource() {
        ASEDatabaseSource aSEDatabaseSource = new ASEDatabaseSource();
        aSEDatabaseSource.setClassLoader(this.getClass().getClassLoader());
        aSEDatabaseSource.setHelpFolder(ASEISQLPlugin.getHelpFolder(), ASEISQLPlugin.getHelpPrefix(), ASEISQLPlugin.getHelpSuffix());
        return aSEDatabaseSource;
    }

    public boolean supportsPlanViewer() {
        return true;
    }

    public ISQLPlanViewer getPlanViewer(ISQLConnection iSQLConnection) {
        return new ASEPlanViewer(iSQLConnection, this);
    }

    public String getPlanFileExtension() {
        return "aseplan";
    }

    public Customizable getCustomizableObject(ISQLConnection iSQLConnection) {
        return new ASECustomizable(iSQLConnection);
    }

    public boolean isPreferenceLocked(ISQLConnection iSQLConnection, String string) {
        ConnectionData connectionData;
        Hashtable<String, Preference> hashtable = null;
        if (iSQLConnection != null && (connectionData = _connectionDataTable.get(iSQLConnection)) != null) {
            hashtable = connectionData.getPreferences();
        }
        if (hashtable == null) {
            hashtable = this.createPreferenceSet();
        }
        Preference preference = hashtable.get(string);
        boolean bl = preference.isLocked();
        return bl;
    }

    public int[] getDatabaseVersion(ISQLConnection iSQLConnection) {
        int[] nArray = new int[3];
        Connection connection = iSQLConnection.getJDBCConnection();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            nArray = new int[]{databaseMetaData.getDatabaseMajorVersion(), databaseMetaData.getDatabaseMinorVersion(), 0};
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return nArray;
    }

    public boolean supportsODBCDSN(String string) {
        return false;
    }

    public String getHelpIDForError(int n) {
        return null;
    }

    public String[] getHelpIDForSQL(String string) {
        return null;
    }

    public boolean showHelp(Window window, String string) {
        return this.showHelp(window, string, false);
    }

    public boolean updateHelp(Window window, String string) {
        return this.showHelp(window, string, true);
    }

    private boolean showHelp(Window window, String string, boolean bl) {
        block6: {
            if (_helpViewer == null && !bl) {
                try {
                    _helpViewer = FactoryHelp.getViewer((String)ASEISQLPlugin.getHelpFolder(), (String)ASEISQLPlugin.getHelpPrefix(), (String)ASEISQLPlugin.getHelpSuffix());
                }
                catch (HelpNotFoundException helpNotFoundException) {
                    if (bl) break block6;
                    SybOptionPane.showMessageDialog((Component)window, (Object)(ASEBundleBase.getBundle().getString("ERR_ONLINE_HELP_IS_NOT_INSTALLED") + "\n" + helpNotFoundException.getMessage()), (String)ASEBundleBase.getBundle().getString("ISQL_CAPTION"), (int)1);
                }
            }
        }
        if (_helpViewer != null) {
            if (bl) {
                _helpViewer.turnPageSilent(string, window);
            } else {
                _helpViewer.turnPage(string, window);
            }
        }
        return true;
    }

    public String[] getConnectionProperties(ISQLConnection iSQLConnection, ISQLPlugin.ConnectionPropertyID[] connectionPropertyIDArray) throws ISQLPluginException {
        Statement statement = null;
        ResultSet resultSet = null;
        String[] stringArray = new String[connectionPropertyIDArray.length];
        String string = this.composeSQLForGetConnectionProperties(iSQLConnection, connectionPropertyIDArray);
        try {
            Connection connection = iSQLConnection.getJDBCConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            int n = 0;
            if (resultSet.next()) {
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = resultSet.getString(n + 1);
                }
                int n2 = -1;
                int n3 = -1;
                for (n = 0; n < stringArray.length; ++n) {
                    if (connectionPropertyIDArray[n] == ISQLPlugin.ConnectionPropertyID.HOST_TCPIP_ADDRESS) {
                        n3 = n;
                        continue;
                    }
                    if (connectionPropertyIDArray[n] != ISQLPlugin.ConnectionPropertyID.HOST_NAME) continue;
                    n2 = n;
                }
                if (n3 != -1 && n2 != -1 && stringArray[n2] != null && stringArray[n2].length() != 0) {
                    try {
                        InetAddress inetAddress = InetAddress.getByName(stringArray[n2]);
                        stringArray[n3] = inetAddress.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new ISQLPluginException((Throwable)sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
        return stringArray;
    }

    private String composeSQLForGetConnectionProperties(ISQLConnection iSQLConnection, ISQLPlugin.ConnectionPropertyID[] connectionPropertyIDArray) {
        StringBuilder stringBuilder = new StringBuilder();
        ASEConnectionInfo aSEConnectionInfo = (ASEConnectionInfo)iSQLConnection.getConnectionInfo();
        block11: for (int i = 0; i < connectionPropertyIDArray.length; ++i) {
            switch (connectionPropertyIDArray[i]) {
                case HOST_NAME: {
                    stringBuilder.append(",'");
                    stringBuilder.append(aSEConnectionInfo.host);
                    stringBuilder.append('\'');
                    continue block11;
                }
                case HOST_OPERATING_SYSTEM: {
                    stringBuilder.append(",null");
                    continue block11;
                }
                case HOST_TCPIP_ADDRESS: {
                    stringBuilder.append(",null");
                    continue block11;
                }
                case SERVER_NAME: {
                    stringBuilder.append(",'");
                    stringBuilder.append(aSEConnectionInfo.getServerName());
                    stringBuilder.append('\'');
                    continue block11;
                }
                case SERVER_TCPIP_PORT: {
                    stringBuilder.append(",'");
                    stringBuilder.append(aSEConnectionInfo.port);
                    stringBuilder.append('\'');
                    continue block11;
                }
                case DATABASE_NAME: {
                    stringBuilder.append(",db_name()");
                    continue block11;
                }
                case DATABASE_CHARSET: {
                    stringBuilder.append(",(select a.name + ' - ' + a.description ");
                    stringBuilder.append("from master.dbo.syscharsets a, master.dbo.syscharsets b ");
                    stringBuilder.append("where a.id = (select value from master.dbo.syscurconfigs where config = 131) ");
                    stringBuilder.append("and b.id = (select value from master.dbo.syscurconfigs where config = 123) ");
                    stringBuilder.append("and b.csid = (select value from master.dbo.syscurconfigs where config = 131))");
                    continue block11;
                }
                case CONNECTION_STRING: {
                    stringBuilder.append(",'");
                    stringBuilder.append(aSEConnectionInfo.getConnectionString());
                    stringBuilder.append('\'');
                    continue block11;
                }
                case CONNECTION_CHARSET: {
                    stringBuilder.append(",'");
                    stringBuilder.append(aSEConnectionInfo.getCharSet());
                    stringBuilder.append('\'');
                    continue block11;
                }
                default: {
                    stringBuilder.append(",null");
                }
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(0);
            stringBuilder.insert(0, "select ");
        }
        return stringBuilder.toString();
    }

    public String getHelpFilePrefix() {
        return ASEISQLPlugin.getHelpPrefix();
    }

    public String getHelpFileSuffix() {
        return ASEISQLPlugin.getHelpSuffix();
    }

    public String getHelpFileFolder() {
        return ASEISQLPlugin.getHelpFolder();
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static {
        PreferenceNamesAndDefaults = new String[]{"autoRefetch", "1", "nulls", "(NULL)", "maximumDisplayedRows", "500", "showMultipleResultSets", "1", "truncationLength", "256", "showResultsWithGrids", "1", "disableResultsEditing", "0", "showResultsRowNumber", "1", "resultSetFont", "(SYSTEM)", "showResultsForAllStatements", "0", "autoCommit", "On", "commandDelimiter", ";", "commitOnExit", "On"};
        _defaultPreferences = null;
    }
}

