/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseisqlplugin;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.aseisqlplugin.ASEBundleBase;
import com.sybase.aseisqlplugin.ASEISQLPlugin;
import com.sybase.aseisqlplugin.ConnectionData;
import com.sybase.util.ReflectionProxy;
import com.sybase.util.ReflectionProxyException;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.SAXParseException;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLPlanViewer;

class ASEPlanViewer
implements ISQLPlanViewer,
Runnable {
    private JPanel _container = null;
    private ASEPlanPanelProxy _asePlanPanel = null;
    private ASEBundleBase _bundle;
    private Vector<String> _plan = null;
    private boolean _hasPlan = false;
    private ISQLConnection _connection;
    private ClassLoader _classLoader;
    private String lineSeparator = System.getProperty("line.separator");
    private ASEISQLPlugin _plugin;
    private String _sql;
    private StringBuffer _xmlBuf;
    String XML_BEGIN_STR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    String XML_START_SYMBOL = "query";
    String XML_ELEMENT_TEXT = "text";
    String SQL_TEXT_TAG = "SQL Text:";

    ASEPlanViewer(ISQLConnection iSQLConnection, ASEISQLPlugin aSEISQLPlugin) {
        this._connection = iSQLConnection;
        this._bundle = ASEBundleBase.getBundle();
        this._classLoader = this.getClass().getClassLoader();
        this._plugin = aSEISQLPlugin;
        try {
            Class[] classArray = new Class[]{Connection.class};
            Object[] objectArray = new Object[]{this._connection.getJDBCConnection()};
            this._asePlanPanel = new ASEPlanPanelProxy(classArray, objectArray);
        }
        catch (ReflectionProxyException reflectionProxyException) {
            this.handleReflectionProxyException(reflectionProxyException);
        }
    }

    public JComponent getComponent() {
        if (this._container == null) {
            this._container = new JPanel();
            this._container.setLayout(new BoxLayout(this._container, 0));
            this._container.add(this._asePlanPanel.getPanel());
        }
        return this._container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPlan(String string) {
        try {
            this._sql = string;
            this._connection.executeOnWorkerThread((Runnable)this, true);
            if (this._hasPlan) {
                this._asePlanPanel.getPanel().requestFocusInWindow();
            } else {
                SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this._container), (Object)this._bundle.getFormattedString("PLAN_RETRIEVAL_ERROR", ""), (String)this._bundle.getString("ISQL_CAPTION"), (int)1);
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this._container), (Object)this._bundle.getFormattedString("PLAN_RETRIEVAL_ERROR", exception.getLocalizedMessage()), (String)this._bundle.getString("ISQL_CAPTION"), (int)1);
        }
        finally {
            this._sql = null;
        }
    }

    public boolean loadPlan(File file) throws IOException {
        if (file == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf8"));
        String string = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf(this.XML_BEGIN_STR) != -1) {
                bl = true;
            }
            if (string.indexOf("</" + this.XML_START_SYMBOL) != -1) {
                stringBuffer.append(string);
                bl = false;
            }
            if (!bl) continue;
            stringBuffer.append(string + this.lineSeparator);
        }
        this._xmlBuf = stringBuffer;
        this._asePlanPanel.generatePlan(stringBuffer, new StringBuffer());
        this._sql = this.getSQLFromASEPlanFile(stringBuffer);
        return true;
    }

    public boolean hasPlan() {
        return this._hasPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePlan(File file) throws IOException {
        BufferedWriter bufferedWriter = null;
        StringBuffer stringBuffer = new StringBuffer(this._xmlBuf);
        if (stringBuffer.toString().length() > 0) {
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf8"));
                bufferedWriter.write(stringBuffer.toString());
            }
            finally {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
    }

    private String getSQLFromStandardXML(String string) {
        String string2 = "";
        boolean bl = false;
        try {
            StringReader stringReader = new StringReader(string);
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(stringReader);
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.getEventType()) {
                    case 1: {
                        if (!this.XML_ELEMENT_TEXT.equals(xMLStreamReader.getLocalName().trim())) break;
                        bl = true;
                        break;
                    }
                    case 4: {
                        String string3;
                        if (!bl || (string3 = xMLStreamReader.getText().trim()).length() <= 0) break;
                        string2 = string3;
                        break;
                    }
                    case 2: {
                        if (!this.XML_ELEMENT_TEXT.equals(xMLStreamReader.getLocalName().trim())) break;
                        bl = false;
                    }
                }
                xMLStreamReader.next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2.substring(this.SQL_TEXT_TAG.length(), string2.length());
    }

    String getSQLFromASEPlanFile(StringBuffer stringBuffer) {
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        String string = "</" + this.XML_START_SYMBOL + ">";
        String[] stringArray = stringBuffer.toString().split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toString().trim().length() <= 0) continue;
            arrayList.add(new StringBuffer(stringArray[i].trim()).append(string));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (StringBuffer stringBuffer3 : arrayList) {
            stringBuffer2.append(this.getSQLFromStandardXML(stringBuffer3.toString()));
            stringBuffer2.append(this.lineSeparator);
        }
        return stringBuffer2.toString();
    }

    @Override
    public void run() {
        ConnectionData connectionData = ASEISQLPlugin.getConnectionData(this._connection);
        if (connectionData.getVersion().compareTo("15") < 0) {
            this._hasPlan = false;
            return;
        }
        if (this.getPlan(connectionData)) {
            StringBuffer stringBuffer = new StringBuffer(256);
            int n = this._plan.size();
            String string = System.getProperty("line.separator");
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(this._plan.elementAt(i));
                stringBuffer.append(string);
            }
            this._xmlBuf = stringBuffer;
            this._asePlanPanel.generatePlan(stringBuffer, new StringBuffer(this._plan.elementAt(0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPlan(ConnectionData connectionData) {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 32768;
        try {
            statement = this._connection.getJDBCConnection().createStatement();
            resultSet = statement.executeQuery("select @@textsize");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            if (n < 0x6500000) {
                statement.executeQuery("set textsize 105906176");
            }
            statement.executeUpdate("set plan for show_execio_xml to message on");
            statement.executeUpdate("set nodata on");
            statement.executeUpdate("set showplan on");
            connectionData.getMessageHandler().startIntercepting();
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = this._sql.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().toLowerCase().equals("go")) {
                    stringBuffer.append(" \n");
                    continue;
                }
                stringBuffer.append(stringArray[i]).append(" \n");
            }
            String string = stringBuffer.toString();
            if (!this.validateQuery(string)) {
                boolean bl = false;
                return bl;
            }
            statement.execute(string);
            while (statement.getMoreResults() || statement.getUpdateCount() != -1) {
            }
            String string2 = connectionData.getMessageHandler().stopIntercepting();
            this._plan = new Vector();
            this._plan.add(string2);
            statement.executeUpdate("set showplan off");
            statement.executeUpdate("set nodata off");
            resultSet = statement.executeQuery("select showplan_in_xml(0)");
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (string3 == null || string3.trim().length() == 0) continue;
                this._plan.add(string3);
            }
            statement.executeUpdate("set plan for show_execio_xml off");
            if (n < 0x6500000) {
                statement.executeUpdate("set textsize " + n);
            }
            this._hasPlan = true;
        }
        catch (SQLException sQLException) {
            this._plan = null;
            this._hasPlan = false;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
        return this._hasPlan;
    }

    public String getSQL() {
        return this._sql;
    }

    public boolean supportsHelp() {
        return true;
    }

    public void showHelp() {
        this._plugin.showHelp(null, "HELP_PLANVIEWER_PAGE");
    }

    public boolean supportsPrinting() {
        return false;
    }

    public void print() {
        if (this._hasPlan) {
            // empty if block
        }
    }

    public void destroy() {
        this._container = null;
    }

    public boolean hasOptionsDialog() {
        return false;
    }

    public boolean showOptionsDialog(Frame frame) {
        return false;
    }

    private void handleReflectionProxyException(ReflectionProxyException reflectionProxyException) {
        Throwable throwable = reflectionProxyException.getCause();
        if (throwable instanceof InvocationTargetException) {
            if ((throwable = throwable.getCause()) instanceof SAXParseException) {
                String string = throwable.getLocalizedMessage();
                SybOptionPane.showMessageDialog((Component)((JFrame)SwingUtilities.getWindowAncestor(this._container)), (Object)this._bundle.getString("ERR_COULD_NOT_DISPLAY_PLAN"), (String)this._bundle.getString("ISQL_CAPTION"), (int)1);
            } else {
                ExceptionHandler.handleException((Throwable)throwable);
            }
        } else {
            ExceptionHandler.handleException((Throwable)throwable);
        }
    }

    public void notifySQLChanged(String string) {
    }

    public boolean canSavePlanFiles() {
        return true;
    }

    public boolean canOpenPlanFiles() {
        return true;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    public boolean validateQuery(String string) {
        return string != null;
    }

    class ASEPlanPanelProxy
    extends ReflectionProxy {
        ASEPlanPanelProxy() throws ReflectionProxyException {
            super("com.sybase.ase.planviewer.ASEPlanViewer", null, null, ASEPlanViewer.this._classLoader);
        }

        ASEPlanPanelProxy(Class<Connection>[] classArray, Object[] objectArray) throws ReflectionProxyException {
            super("com.sybase.ase.planviewer.ASEPlanViewer", (Class[])classArray, objectArray, ASEPlanViewer.this._classLoader);
        }

        public void generatePlan(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            try {
                this.invokeMethod("generatePlan", new Class[]{StringBuffer.class, StringBuffer.class}, new Object[]{stringBuffer, stringBuffer2});
            }
            catch (ReflectionProxyException reflectionProxyException) {
                ASEPlanViewer.this.handleReflectionProxyException(reflectionProxyException);
            }
        }

        public JPanel getPanel() {
            try {
                return (JPanel)this.invokeMethod("getPanel", null, null);
            }
            catch (ReflectionProxyException reflectionProxyException) {
                ASEPlanViewer.this.handleReflectionProxyException(reflectionProxyException);
                return null;
            }
        }

        public void validate() {
            try {
                this.invokeMethod("validate", null, null);
            }
            catch (ReflectionProxyException reflectionProxyException) {
                ASEPlanViewer.this.handleReflectionProxyException(reflectionProxyException);
            }
        }
    }
}

