/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseisqlplugin;

import com.sybase.aseisqlplugin.BasePage;
import com.sybase.util.SybCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sybase.isql.ISQLConnection;

class CommandsCustomizerPage
extends BasePage {
    private boolean _opt_autoCommit;
    private boolean _opt_commitOnExit;
    private SybCheckBox _commitOnExit = null;
    private SybCheckBox _autoCommit = null;

    CommandsCustomizerPage(ISQLConnection iSQLConnection) {
        super(iSQLConnection);
        this.readSettings();
        this.createUI();
    }

    private void readSettings() {
        String[] stringArray = this._plugin.getPreferenceValues(this._connection, "autoCommit", "commitOnExit");
        this._opt_autoCommit = CommandsCustomizerPage.decodeBoolean(stringArray[0], true);
        this._opt_commitOnExit = CommandsCustomizerPage.decodeBoolean(stringArray[1], true);
    }

    private void createUI() {
        Insets insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createCommitPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
    }

    private JPanel createCommitPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this._autoCommit = new SybCheckBox(this._bundle.getString("AUTO_COMMIT"));
        if (this._opt_autoCommit) {
            this._autoCommit.setSelected(true);
        }
        if (this._plugin.isPreferenceLocked(this._connection, "autoCommit")) {
            this._autoCommit.setEnabled(false);
        }
        this._commitOnExit = new SybCheckBox(this._bundle.getString("COMMIT_ON_EXIT"));
        if (this._opt_commitOnExit) {
            this._commitOnExit.setSelected(true);
        }
        if (this._plugin.isPreferenceLocked(this._connection, "commitOnExit")) {
            this._commitOnExit.setEnabled(false);
        }
        jPanel.add((Component)this._autoCommit, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this._commitOnExit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        return jPanel;
    }

    @Override
    public void destroy() {
        this._commitOnExit = null;
        this._autoCommit = null;
        super.destroy();
    }

    @Override
    public void acceptChanges() {
        this._opt_autoCommit = this._autoCommit.isSelected();
        this._opt_commitOnExit = this._commitOnExit.isSelected();
        this._plugin.setBooleanPreference(this._connection, "autoCommit", this._opt_autoCommit);
        this._plugin.setBooleanPreference(this._connection, "commitOnExit", this._opt_commitOnExit);
    }

    public String getTitle() {
        return this._bundle.getString("COMMANDS_OPTIONS_PAGE_TITLE");
    }

    public void showHelp() {
        this._plugin.showHelp(SwingUtilities.getWindowAncestor(this), "HELP_ISQL_OPTIONS_COMMANDS");
    }
}

