/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseisqlplugin;

import com.sybase.aseisqlplugin.JConnectMessageHandler;
import com.sybase.aseisqlplugin.Preference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;

class ConnectionData {
    private Connection _connection;
    private Hashtable<String, Preference> _preferences;
    private JConnectMessageHandler _msgHandler;
    private String _aseVersion;

    ConnectionData(Connection connection, JConnectMessageHandler jConnectMessageHandler, Hashtable<String, Preference> hashtable) {
        this._connection = connection;
        this._preferences = hashtable;
        this._msgHandler = jConnectMessageHandler;
        this.memorizeASEVersionNumber(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memorizeASEVersionNumber(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select @@version");
            boolean bl = resultSet.next();
            String string = null;
            if (bl) {
                string = resultSet.getString(1);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                int n = stringTokenizer.countTokens();
                String[] stringArray = new String[n + 1];
                int n2 = 0;
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("Adaptive Server Enterprise")) {
                        n2 = n3;
                    }
                    stringArray[n3++] = string2;
                }
                this._aseVersion = stringArray[n2 + 1];
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
    }

    String getVersion() {
        return this._aseVersion;
    }

    Hashtable<String, Preference> getPreferences() {
        return this._preferences;
    }

    JConnectMessageHandler getMessageHandler() {
        return this._msgHandler;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

