/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseisqlplugin;

import com.sybase.aseisqlplugin.BasePage;
import com.sybase.aseisqlplugin.Preference;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybFontChooser;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UserDataComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLPlugin;

class ResultsCustomizerPage
extends BasePage
implements ItemListener {
    private String _opt_nulls;
    private int _opt_maxDisplayRows;
    private int _opt_truncationLength;
    private boolean _opt_showResultsWithGrids;
    private boolean _opt_autoRefetch;
    private boolean _opt_disableEditing;
    private boolean _opt_showRowNumber;
    private String _opt_resultSetFont;
    private boolean _opt_showMultipleResultSets;
    private boolean _opt_showResultsForAllStatements;
    private JPanel _gridOptionPanel = null;
    private Object _gridOptionsEnablingCookie = null;
    private SybCheckBox _autoRefetch;
    private SybCheckBox _disableEditing;
    private JTextField _nullsField;
    private UserDataComboBox _maxDisplayRows;
    private JTextField _truncationLength;
    private SybCheckBox _showRowNumber;
    private FontComboBox _cbFont;
    private SybRadioButton _grids = null;
    private SybRadioButton _text = null;
    private SybRadioButton _rbShowResultsFromLastStatement = null;
    private SybRadioButton _rbShowResultsFromEachStatement = null;
    private SybRadioButton _rbShowFirstResultSet = null;
    private SybRadioButton _rbShowAllResultSets = null;
    private Font _customFontObject = null;

    ResultsCustomizerPage(ISQLConnection iSQLConnection) {
        super(iSQLConnection);
        this.readSettings();
        this.createUI();
    }

    private void readSettings() {
        String[] stringArray = this._plugin.getPreferenceValues(this._connection, "maximumDisplayedRows", "showMultipleResultSets", "truncationLength", "nulls", "autoRefetch", "showResultsForAllStatements", "disableResultsEditing", "showResultsRowNumber", "resultSetFont", "showResultsWithGrids");
        this._opt_maxDisplayRows = ResultsCustomizerPage.decodeInt(stringArray[0], 500);
        this._opt_showMultipleResultSets = ResultsCustomizerPage.decodeBoolean(stringArray[1], false);
        this._opt_truncationLength = ResultsCustomizerPage.decodeInt(stringArray[2], 256);
        this._opt_nulls = ResultsCustomizerPage.decodeString(stringArray[3], "(NULL)");
        this._opt_autoRefetch = ResultsCustomizerPage.decodeBoolean(stringArray[4], true);
        this._opt_showResultsForAllStatements = ResultsCustomizerPage.decodeBoolean(stringArray[5], false);
        this._opt_disableEditing = ResultsCustomizerPage.decodeBoolean(stringArray[6], false);
        this._opt_showRowNumber = ResultsCustomizerPage.decodeBoolean(stringArray[7], true);
        this._opt_resultSetFont = ResultsCustomizerPage.decodeString(stringArray[8], "(SYSTEM)");
        this._opt_showResultsWithGrids = ResultsCustomizerPage.decodeBoolean(stringArray[9], true);
    }

    @Override
    public void destroy() {
        this._nullsField = null;
        this._maxDisplayRows = null;
        this._truncationLength = null;
        this._autoRefetch = null;
        this._disableEditing = null;
        this._showRowNumber = null;
        this._grids = null;
        this._text = null;
        this._rbShowResultsFromLastStatement = null;
        this._rbShowResultsFromLastStatement = null;
        super.destroy();
    }

    private void createUI() {
        Insets insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createDisplayGroup(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add((Component)this.createStyleGroup(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add((Component)this.createProcessingGroup(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
    }

    private JPanel createDisplayGroup() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this._bundle.getString("DISPLAY_GROUP_BOX_TITLE")));
        this._nullsField = new JTextField(16);
        this._nullsField.setText(this._opt_nulls);
        SybLabel sybLabel = new SybLabel(this._bundle.getString("DISPLAY_NULL_VALUES_AS"));
        sybLabel.setLabelFor((Component)this._nullsField);
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel.add((Component)this._nullsField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        String[] stringArray = new String[]{this._bundle.getString("DISPLAY_ALL_ROWS"), "50", "100", "500", "1000", "5000", "10000", "50000", "100000"};
        Object[] objectArray = new Object[]{Integer.MAX_VALUE, 50, 100, 500, 1000, 5000, 10000, 50000, 100000};
        this._maxDisplayRows = new UserDataComboBox(stringArray, objectArray);
        if (this._opt_maxDisplayRows <= 50) {
            this._maxDisplayRows.setSelectedIndex(1);
        } else if (this._opt_maxDisplayRows <= 100) {
            this._maxDisplayRows.setSelectedIndex(2);
        } else if (this._opt_maxDisplayRows <= 500) {
            this._maxDisplayRows.setSelectedIndex(3);
        } else if (this._opt_maxDisplayRows <= 1000) {
            this._maxDisplayRows.setSelectedIndex(4);
        } else if (this._opt_maxDisplayRows <= 5000) {
            this._maxDisplayRows.setSelectedIndex(5);
        } else if (this._opt_maxDisplayRows <= 10000) {
            this._maxDisplayRows.setSelectedIndex(6);
        } else if (this._opt_maxDisplayRows <= 50000) {
            this._maxDisplayRows.setSelectedIndex(7);
        } else if (this._opt_maxDisplayRows <= 100000) {
            this._maxDisplayRows.setSelectedIndex(8);
        } else {
            this._maxDisplayRows.setSelectedIndex(0);
        }
        sybLabel = new SybLabel(this._bundle.getString("MAX_DISPLAY_ROWS"));
        sybLabel.setLabelFor((Component)this._maxDisplayRows);
        if (this._plugin.isPreferenceLocked(this._connection, "maximumDisplayedRows")) {
            this._maxDisplayRows.setEnabled(false);
            sybLabel.setEnabled(false);
        }
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel.add((Component)this._maxDisplayRows, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._truncationLength = new JTextField(16);
        this._truncationLength.setText(Integer.toString(this._opt_truncationLength));
        sybLabel = new SybLabel(this._bundle.getString("TRUNCATION_LENGTH"));
        sybLabel.setLabelFor((Component)this._truncationLength);
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel.add((Component)this._truncationLength, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createStyleGroup() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this._bundle.getString("STYLE_GROUP_BOX_TITLE")));
        SybLabel sybLabel = new SybLabel(this._bundle.getString("HOW_DO_YOU_WANT_RESULTS_DISPLAYED"));
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._grids = new SybRadioButton(this._bundle.getString("GRIDS"));
        this._grids.addItemListener((ItemListener)this);
        jPanel.add((Component)this._grids, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._gridOptionPanel = this.createGridOptionPanel();
        jPanel.add((Component)this._gridOptionPanel, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
        this._text = new SybRadioButton(this._bundle.getString("TEXT"));
        this._text.addItemListener((ItemListener)this);
        jPanel.add((Component)this._text, new GridBagConstraints(0, 7, 0, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        sybLabel = new SybLabel(this._bundle.getString("TEXT_EXPLANATION"));
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 8, 0, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._grids);
        buttonGroup.add((AbstractButton)this._text);
        if (this._opt_showResultsWithGrids) {
            this._grids.setSelected(true);
        } else {
            this._text.setSelected(true);
        }
        return jPanel;
    }

    private JPanel createGridOptionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        SybLabel sybLabel = new SybLabel(this._bundle.getString("GRIDS_EXPLANATION"));
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._autoRefetch = new SybCheckBox(this._bundle.getString("AUTO_REFETCH"));
        this._autoRefetch.setSelected(this._opt_autoRefetch);
        if (this._plugin.isPreferenceLocked(this._connection, "autoRefetch")) {
            this._autoRefetch.setEnabled(false);
        }
        jPanel.add((Component)this._autoRefetch, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
        this._showRowNumber = new SybCheckBox(this._bundle.getString("SHOW_ROW_NUMBER"));
        this._showRowNumber.setSelected(this._opt_showRowNumber);
        jPanel.add((Component)this._showRowNumber, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
        this._disableEditing = new SybCheckBox(this._bundle.getString("DISABLE_EDITING"));
        this._disableEditing.setSelected(this._opt_disableEditing);
        if (this._plugin.isPreferenceLocked(this._connection, "disableResultsEditing")) {
            this._disableEditing.setEnabled(false);
        }
        jPanel.add((Component)this._disableEditing, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        sybLabel = new SybLabel(this._bundle.getString("FONT"));
        this._cbFont = new FontComboBox();
        sybLabel.setLabelFor((Component)((Object)this._cbFont));
        if (this._opt_resultSetFont.equals("(SYSTEM)")) {
            this._cbFont.selectSystemFontOption();
        } else if (this._opt_resultSetFont.equals("(EDITOR)")) {
            this._cbFont.selectEditorFontOption();
        } else {
            this._customFontObject = Preference.parseFontDescription(this._opt_resultSetFont);
            this._cbFont.selectCustomFontOption(this._customFontObject);
        }
        jPanel.add((Component)sybLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)((Object)this._cbFont), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createProcessingGroup() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this._bundle.getString("PROCESSING_GROUP_BOX_TITLE")));
        SybLabel sybLabel = new SybLabel(this._bundle.getString("WHEN_EXECUTING_BATCHES"));
        this._rbShowResultsFromLastStatement = new SybRadioButton(this._bundle.getString("SHOW_RESULTS_FROM_LAST_STATEMENT"));
        this._rbShowResultsFromEachStatement = new SybRadioButton(this._bundle.getString("SHOW_RESULTS_FROM_EACH_STATEMENT"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._rbShowResultsFromLastStatement);
        buttonGroup.add((AbstractButton)this._rbShowResultsFromEachStatement);
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this._rbShowResultsFromLastStatement, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._rbShowResultsFromEachStatement, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JSeparator(1), new GridBagConstraints(1, 0, 1, 3, 0.0, 1.0, 21, 3, new Insets(0, 5, 0, 10), 0, 0));
        sybLabel = new SybLabel(this._bundle.getString("FOR_STATEMENTS_THAT_RETURN_MULTIPLE_RESULT_SETS"));
        this._rbShowFirstResultSet = new SybRadioButton(this._bundle.getString("SHOW_FIRST_RESULT_SET"));
        this._rbShowAllResultSets = new SybRadioButton(this._bundle.getString("SHOW_ALL_RESULT_SETS"));
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._rbShowFirstResultSet);
        buttonGroup.add((AbstractButton)this._rbShowAllResultSets);
        jPanel.add((Component)sybLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this._rbShowFirstResultSet, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._rbShowAllResultSets, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this._opt_showMultipleResultSets) {
            this._rbShowAllResultSets.setSelected(true);
        } else {
            this._rbShowFirstResultSet.setSelected(true);
        }
        if (this._opt_showResultsForAllStatements) {
            this._rbShowResultsFromEachStatement.setSelected(true);
        } else {
            this._rbShowResultsFromLastStatement.setSelected(true);
        }
        if (this._plugin.isPreferenceLocked(this._connection, "showMultipleResultSets")) {
            this._rbShowFirstResultSet.setEnabled(false);
            this._rbShowAllResultSets.setEnabled(false);
        }
        if (this._plugin.isPreferenceLocked(this._connection, "showResultsForAllStatements")) {
            this._rbShowResultsFromLastStatement.setEnabled(false);
            this._rbShowResultsFromEachStatement.setEnabled(false);
        }
        return jPanel;
    }

    private void enableControls() {
        boolean bl = this._grids.isSelected();
        if (bl && this._gridOptionsEnablingCookie != null) {
            DialogUtils.enableControls((Object)this._gridOptionsEnablingCookie);
            this._gridOptionsEnablingCookie = null;
        } else if (!bl && this._gridOptionsEnablingCookie == null) {
            this._gridOptionsEnablingCookie = DialogUtils.disableControls((Container)this._gridOptionPanel);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.enableControls();
        }
    }

    @Override
    public void acceptChanges() {
        this._opt_nulls = this._nullsField.getText().trim();
        try {
            int n = this._maxDisplayRows.getSelectedIndex();
            if (n != -1) {
                this._opt_maxDisplayRows = (Integer)this._maxDisplayRows.getUserData(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this._opt_truncationLength = Integer.parseInt(this._truncationLength.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._opt_showResultsWithGrids = this._grids.isSelected();
        if (this._opt_showResultsWithGrids) {
            this._opt_autoRefetch = this._autoRefetch.isSelected();
            this._opt_showRowNumber = this._showRowNumber.isSelected();
            this._opt_disableEditing = this._disableEditing.isSelected();
            if (this._cbFont.isSystemFontSelected()) {
                this._opt_resultSetFont = "(SYSTEM)";
            } else if (this._cbFont.isEditorFontSelected()) {
                this._opt_resultSetFont = "(EDITOR)";
            } else {
                this._customFontObject = this._cbFont.getCustomFont();
                this._opt_resultSetFont = this._customFontObject != null ? Preference.createFontDescription(this._customFontObject) : "(SYSTEM)";
            }
        }
        this._opt_showMultipleResultSets = this._rbShowAllResultSets.isSelected();
        this._opt_showResultsForAllStatements = this._rbShowResultsFromEachStatement.isSelected();
        this._plugin.setStringPreference(this._connection, "nulls", this._opt_nulls);
        if (this._maxDisplayRows.isEnabled()) {
            this._plugin.setIntPreference(this._connection, "maximumDisplayedRows", this._opt_maxDisplayRows);
        }
        this._plugin.setIntPreference(this._connection, "truncationLength", this._opt_truncationLength);
        if (this._rbShowAllResultSets.isEnabled()) {
            this._plugin.setBooleanPreference(this._connection, "showMultipleResultSets", this._opt_showMultipleResultSets);
        }
        if (this._rbShowResultsFromEachStatement.isEnabled()) {
            this._plugin.setBooleanPreference(this._connection, "showResultsForAllStatements", this._opt_showResultsForAllStatements);
        }
        this._plugin.setBooleanPreference(this._connection, "autoRefetch", this._opt_autoRefetch);
        if (this._disableEditing.isEnabled()) {
            this._plugin.setBooleanPreference(this._connection, "disableResultsEditing", this._opt_disableEditing);
        }
        this._plugin.setBooleanPreference(this._connection, "showResultsRowNumber", this._opt_showRowNumber);
        this._plugin.setStringPreference(this._connection, "resultSetFont", this._opt_resultSetFont);
        this._plugin.setBooleanPreference(this._connection, "showResultsWithGrids", this._opt_showResultsWithGrids);
        this._plugin.getISQLHost().updateResultSetTableAppearance((ISQLPlugin)this._plugin);
    }

    public String getTitle() {
        return this._bundle.getString("RESULTS_OPTIONS_PAGE_TITLE");
    }

    public void showHelp() {
        this._plugin.showHelp(SwingUtilities.getWindowAncestor(this), "HELP_ISQL_OPTIONS_APPEARANCE");
    }

    @Override
    public Icon getCustomizationGroupIcon() {
        return ISQLImages.getImageIcon((String)"results16");
    }

    class FontComboBox
    extends SybComboBox {
        private MyActionListener _listener;
        private Font _customFont = null;
        private boolean _ignoreActionEvent = false;
        private Object _oldSelectedItem = null;

        FontComboBox() {
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(new Object[]{ResultsCustomizerPage.this._bundle.getString("RST_SYSTEM_FONT"), ResultsCustomizerPage.this._bundle.getString("RST_EDITOR_FONT"), ResultsCustomizerPage.this._bundle.getString("RST_CUSTOM_FONT")});
            this.setModel(defaultComboBoxModel);
            this._listener = new MyActionListener();
            this.addActionListener(this._listener);
            this.addPopupMenuListener(new MyPopupMenuListener());
            this.setRenderer(new MyListCellRenderer());
        }

        void destroy() {
            this.removeActionListener(this._listener);
            this._listener = null;
        }

        boolean isSystemFontSelected() {
            return this.getSelectedIndex() == 0;
        }

        boolean isEditorFontSelected() {
            return this.getSelectedIndex() == 1;
        }

        Font getCustomFont() {
            return this._customFont;
        }

        void selectSystemFontOption() {
            this._ignoreActionEvent = true;
            this.setSelectedIndex(0);
            this._ignoreActionEvent = false;
        }

        void selectEditorFontOption() {
            this._ignoreActionEvent = true;
            this.setSelectedIndex(1);
            this._ignoreActionEvent = false;
        }

        void selectCustomFontOption(Font font) {
            this._ignoreActionEvent = true;
            this.setSelectedItem(null);
            this._ignoreActionEvent = false;
            this._customFont = font;
        }

        private void handleBrowseFont() {
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, (Component)((Object)this));
            Font font = null;
            if (this._customFont != null) {
                font = this._customFont;
            } else {
                JTable jTable = new JTable();
                font = jTable.getFont();
            }
            Font font2 = SybFontChooser.create((Dialog)dialog, (Font)font);
            if (font2 != null) {
                this.setSelectedItem(null);
                this._customFont = font2;
            } else {
                this.setSelectedItem(this._oldSelectedItem);
            }
        }

        class MyListCellRenderer
        extends DefaultListCellRenderer {
            MyListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (n == -1 && FontComboBox.this._customFont != null) {
                    jLabel.setText(this.getFontText());
                }
                return jLabel;
            }

            private String getFontText() {
                StringBuilder stringBuilder = new StringBuilder(64);
                if (FontComboBox.this._customFont != null) {
                    int n = (FontComboBox.this._customFont.getSize() * 3 + 2) / 4;
                    stringBuilder.append(n);
                    stringBuilder.append(".");
                    stringBuilder.append(FontComboBox.this._customFont.getFamily());
                }
                return stringBuilder.toString();
            }
        }

        class MyPopupMenuListener
        implements PopupMenuListener {
            MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                FontComboBox.this._oldSelectedItem = FontComboBox.this.getSelectedItem();
            }
        }

        class MyActionListener
        implements ActionListener {
            MyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FontComboBox.this._ignoreActionEvent) {
                    return;
                }
                if (FontComboBox.this.getSelectedIndex() == 2) {
                    FontComboBox.this.hidePopup();
                    FontComboBox.this.handleBrowseFont();
                } else {
                    FontComboBox.this._customFont = null;
                }
            }
        }
    }
}

