/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.logon.ASEDatabaseSource;
import com.sybase.ase.logon.SyASEServerProxy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import sybase.isql.ASEParserConstants;
import sybase.isql.ASEParserTokenManager;
import sybase.isql.Dbg;
import sybase.isql.DescribeOption;
import sybase.isql.EedInfoProxy;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.IODataClient;
import sybase.isql.IOFilter;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLParser;
import sybase.isql.ISQLParserListener;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.ImporterFailedException;
import sybase.isql.InputOutputOptions;
import sybase.isql.InputStatement;
import sybase.isql.ODBCExporter;
import sybase.isql.OptionInfo;
import sybase.isql.OutputStatement;
import sybase.isql.ParseException;
import sybase.isql.ParserUtils;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;
import sybase.isql.ResultsProcessor;
import sybase.isql.SQLTextComponent;
import sybase.isql.StatementLocation;
import sybase.isql.TerminatedFileReader;
import sybase.isql.TextImporter;
import sybase.isql.Token;
import sybase.isql.TokenMgrError;
import sybase.isql.UCode_CharStream;
import sybase.isql.UserAbortedParsingError;
import sybase.isql.isql;

public class ASEParser
implements ISQLParser,
ASEParserConstants {
    private static ASEParser _currentParser = null;
    private ISQLConnection _connection = null;
    private Vector<String> _parms = null;
    private boolean _isIncludedFile = false;
    private File _fileName = null;
    private StringBuffer _lineBuffer = null;
    private Token _firstSQLToken = null;
    private Token _previousLineFirstSQLToken = null;
    private int _lineBufferStartLineNumber = 0;
    private int _lineEnd = -1;
    private int _previousLineEnd = -1;
    private StringBuffer _previousLine = null;
    private Vector<String> _messages = new Vector();
    private boolean _silent = false;
    String _redirectionFile = null;
    boolean _redirectionWithErrors;
    private int _lastErrorStartLine = -1;
    private int _lastErrorEndLine = -1;
    private String _calledFrom = null;
    private ResultsProcessor _resultsProcessor = null;
    private boolean _interruptRequested = false;
    private int _goCount = 1;
    private static Pattern _goPattern = null;
    private ASEParser _parentParser = null;
    private ISQLParserListener _parserListener = null;
    public ASEParserTokenManager token_source;
    UCode_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[73];
    private final int[] jj_la1_0 = new int[]{-536887296, 0x20000000, -16384, -16384, -16384, -4096, 0x20000000, 0, 0, 12289, 12289, -536875008, -4096, -536887296, -536887296, 0, 0, -16384, 0, -16384, 0, -16384, 0x20000000, -16384, -16384, -16384, 0x50000000, 0x50000000, 0, 0, 0, 0, 0, 0, 0, 0x40010000, 0, 0, 0, 0, 0, 0x40010000, 524288, 0, 16384, 0, 0, -16384, 0, 0, -16384, -16384, -16384, 0x8C00000, 0, 0, 0, -16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{-134349193, 134349192, -1, -1, -1, -1, 135464072, 0, 0, 0, 0, -134349193, -257, -134349193, -134349193, 0, 0, -1, 0, -1, 0, -1, 0x8000000, -1, -1, -1, -1505737696, -1505737696, 0, 0, 524288, 524288, Integer.MIN_VALUE, 0, 0, 641744928, 524288, 524288, 0, 1024, 0, 641744928, 0, 0, 0, 0, 0, -1, 0, 0, -1, -1, -1, 2129986, 0, 0, 0, -1, 0x1000000, 0, 0x1000000, 0, 0x1000000, 0, 0x1000000, 0, 8192, 0, 0, 0x10000000, 0, 65536, 65536};
    private final int[] jj_la1_2 = new int[]{-67, 66, -1, -1, -1, -1, 66, 0, 0, 0, 0, -67, -1, -67, -67, 0, 0, -1, 0, -1, 0, -1, 0, -1, -1, -1, 0x400100, 0x400100, 0, 0, 0, 0, 0, 0x20000000, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, -1, 0, 0, -1, -1, -1, 1074789505, 0x4000000, 0x4000000, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0x1000000, 0, 0, 0, 0};
    private final int[] jj_la1_3 = new int[]{-424943873, 424943872, -1, -1, -1, -1, 419700992, 0, 0, 0, 0, -423895297, -4194305, -424943873, -424943873, 0, 0, -1, 0, -1, 0, -1, 262144, -1, -1, -1, 65537, 65537, 6, 6, 0, 0, 65536, 128, 0, 524288, 0, 0, 6, 0, 256, 524288, 6, 6, 0, 0, 0, -1, 0, 0, -1, -1, -1, 67112456, 0, 0, 0x40000000, -1, 0, 0, 0, 4, 0, 0, 0, 0, 4096, 0, 131072, 0, 0, 0, 0};
    private final int[] jj_la1_4 = new int[]{536840191, 0, 536840191, 536840191, 1073711103, 536840191, 16, 30720, 30720, 0, 0, 536840191, 536840191, 536840191, 536840191, 30720, 30720, 1073711103, 0, 1073711103, 0, 536840191, 0, 1073711103, 1073711103, 536840191, 64, 64, 0, 0, 0, 0, 0, 0, 0x100000, 128, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0x100000, 0x100000, 1073711103, 30720, 30720, 1073711103, 1073711103, 1073711103, 4, 0, 0, 0, 536840191, 0, 0x100000, 0, 0, 0, 0x100000, 0, 0, 0, 512, 0, 0, 0x100000, 0, 0};
    private final int[] jj_la1_5 = new int[]{0, 0, 0, 0x2100010, 0x2100010, 0x400010, 0, 0, 0, 0, 0, 0x400010, 0x400010, 16, 0x400010, 0, 0, 16, 0x108000, 1074823184, 0, 0x2100010, 0, 0x2100010, 0x2100010, 0x2100010, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2100010, 0, 0, 0x2100010, 16, 0x2100010, 0, 0, 0, 0, 0x2100010, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[21];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    @Override
    public void setResultsProcessor(ResultsProcessor resultsProcessor) {
        this._resultsProcessor = resultsProcessor;
    }

    @Override
    public void setParserListener(ISQLParserListener iSQLParserListener) {
        this._parserListener = iSQLParserListener;
    }

    @Override
    public void interrupt() {
        this._interruptRequested = true;
    }

    static void getCurrentParserState(PrintStream printStream) {
        if (_currentParser == null) {
            printStream.println("  (No current ISQL parser)");
        } else {
            _currentParser.printParserState(printStream);
        }
    }

    @Override
    public void printParserState(PrintStream printStream) {
        String string;
        if (this._fileName != null) {
            printStream.println("  Input file: " + this._fileName.getName());
        } else {
            printStream.println("  Reading from command tail");
        }
        if (this._redirectionFile != null) {
            printStream.println("  Output " + (this._redirectionWithErrors ? " with errors " : "") + " is redirected to " + this._redirectionFile);
        }
        if (this.token != null) {
            printStream.println("  Current token: \"" + this.token.image + "\", kind=" + this.token.kind);
        }
        if ((string = this.getTokenLocation(this.token)).length() != 0) {
            printStream.println("  Current token location: " + string);
        }
    }

    @Override
    public ArrayList<StatementLocation> getStatementLocations() {
        this.token_source.setTabSize(4);
        this.token_source.setParser(this);
        ArrayList<StatementLocation> arrayList = new ArrayList<StatementLocation>();
        try {
            while (true) {
                Token token = this.getNextToken();
                if (token.kind != 0) {
                    this.matchToCommandDelimiter(null);
                    Token token2 = this.getToken(0);
                    StatementLocation statementLocation = new StatementLocation(token.beginLine, token.beginColumn, token2.endLine, token2.endColumn);
                    arrayList.add(statementLocation);
                    continue;
                }
                break;
            }
        }
        catch (ParseException parseException) {
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
        this.token_source.reset();
        return arrayList;
    }

    @Override
    public ISQLConnection parse(ISQLConnection iSQLConnection, boolean bl) throws ParseException {
        this._parms = null;
        this._interruptRequested = false;
        return this.isqlStatementList(iSQLConnection, bl);
    }

    @Override
    public int getDatabaseType() {
        return 1;
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        Token token2 = this.original_jj_consume_token(n);
        if (token != null) {
            token.next = null;
        }
        this.accumulateLine(token2);
        return token2;
    }

    String lookupParameter(String string) {
        String string2 = null;
        if (this._parms != null) {
            for (int i = 0; i < this._parms.size(); i += 2) {
                String string3 = this._parms.elementAt(i);
                if (string3 == null) {
                    this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "MISSING_PARAMETERS_STATEMENT", this._fileName.getName()));
                    break;
                }
                String string4 = string3.toString();
                if (!string4.equalsIgnoreCase(string)) continue;
                string3 = this._parms.elementAt(i + 1);
                if (string3 == null && !isql.options.quiet) {
                    this.promptForValues(this._parms);
                    string3 = this._parms.elementAt(i + 1);
                }
                if (string3 != null) {
                    string2 = string3.toString();
                    break;
                }
                this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "PARAMETER_NOT_SPECIFIED", Integer.toString(i / 2 + 1), string4));
                break;
            }
        }
        return string2;
    }

    private void promptForValues(Vector<String> vector) {
        String string = ISQLResource.getISQLString(GeneralResources.getName(), "Enter values for the following command file parameters");
        int n = vector.size() / 2;
        String[] stringArray = new String[n];
        Class[] classArray = new Class[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = vector.elementAt(i * 2);
            objectArray[i] = vector.elementAt(i * 2 + 1);
            classArray[i] = String.class;
        }
        class MyIODataClient
        implements IODataClient {
            Vector<String> _parms;

            MyIODataClient(Vector<String> vector) {
                this._parms = vector;
            }

            void clear() {
                this._parms = null;
            }

            @Override
            public int submitData(Object object, Object[] objectArray) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (objectArray[i] == null) {
                        this._parms.setElementAt(null, i * 2 + 1);
                        continue;
                    }
                    this._parms.setElementAt(objectArray[i].toString(), i * 2 + 1);
                }
                return -1;
            }
        }
        MyIODataClient myIODataClient = new MyIODataClient(vector);
        isql.getIO(this._connection).promptForData(string, stringArray, classArray, objectArray, 0, myIODataClient);
        myIODataClient.clear();
    }

    void setParameterName(String string, int n) {
        if ((n *= 2) >= this._parms.size()) {
            this._parms.setSize(n + 2);
        }
        this._parms.setElementAt(string, n);
    }

    void log(String string) {
        if (isql.options.userDebuggingLevel >= 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                System.out.println(stringTokenizer.nextElement().toString());
            }
        }
        if (this._connection != null && this._connection.isConnected() && (!this._isIncludedFile || this._redirectionFile != null || Preferences.getBooleanOption(this._connection, "echo"))) {
            isql.log(this._connection, string);
        }
    }

    private void accumulateLine(Token token) {
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (token2 != null) {
                stringBuilder.append(token2.image);
                token2 = token2.next;
            }
            this.accumulateLine(stringBuilder.toString());
        }
        if (token.image != null) {
            this.accumulateLine(token.image);
        }
    }

    public void accumulateLine(String string) {
        boolean bl = false;
        if (this._lineBuffer == null) {
            this._lineBuffer = new StringBuffer();
            this._lineBufferStartLineNumber = this.token.beginLine;
        }
        if (string == null || string.length() == 0) {
            bl = true;
        } else if (this._lineBuffer.length() == 0) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                this._lineBuffer.append(string.substring(i));
                break;
            }
        } else {
            this._lineBuffer.append(string);
        }
        if (bl) {
            this.flushLineBuffer();
        }
    }

    private void flushLineBuffer() {
        if (this._lineBuffer != null && this._lineBuffer.length() != 0) {
            this._previousLine = this._lineBuffer;
            this._previousLineEnd = this._lineEnd;
            this._previousLineFirstSQLToken = this._firstSQLToken;
            Token token = this._previousLineFirstSQLToken != null ? this._previousLineFirstSQLToken : this.token;
            Token token2 = this.token;
            if (this._parserListener != null) {
                this._parserListener.notifyStatementExecution(this._previousLine.toString(), token.beginLine, token.beginColumn, token2.beginLine, token2.beginColumn);
            }
            if (!this._previousLine.toString().equals(";")) {
                this.log(this._previousLine.toString());
            }
            this._lineBuffer = new StringBuffer();
            this._lineEnd = -1;
            this._firstSQLToken = null;
        }
    }

    public void markEndOfLine() {
        this._lineEnd = this._lineBuffer.length();
    }

    private void ensureNoMoreTokensOnLine() throws ParseException {
        Token token = this.getToken(1);
        if (token != null && token.kind != 0 && token.kind != 12 && token.kind != 139 && token.kind != 140 && token.kind != 141 && token.kind != 142) {
            this.accumulateLine(token);
            this.flushLineBuffer();
            this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "SyntaxErrorUnexpectedToken", token.image));
        }
    }

    private String getLastStatement() {
        String string = this._lineBuffer != null && this._lineBuffer.length() > 0 ? this._lineBuffer.toString() : (this._previousLine != null && this._previousLine.length() > 0 ? this._previousLine.toString() : "");
        return string;
    }

    private void handleError(String string) {
        this.handleErrorOrWarning(string, this.getLastStatement(), null, true, true);
    }

    private void handleError(String string, SQLException sQLException) {
        this.handleErrorOrWarning(string, this.getLastStatement(), sQLException, true, true);
    }

    private void handleErrorOrWarning(String string, String string2, Throwable throwable, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        String string3;
        JComponent jComponent;
        int n = -1;
        String[] stringArray = null;
        this.flushLineBuffer();
        Token token = this._previousLineFirstSQLToken != null ? this._previousLineFirstSQLToken : this.token;
        Token token2 = this.token;
        EedInfoProxy eedInfoProxy = EedInfoProxy.isInstance(throwable) ? new EedInfoProxy(throwable) : null;
        if (eedInfoProxy != null) {
            this._lastErrorEndLine = this._lastErrorStartLine = token.beginLine + eedInfoProxy.getLineNumber() - 1;
        } else {
            this._lastErrorStartLine = token.beginLine;
            this._lastErrorEndLine = token2.endLine;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        } else if (throwable != null) {
            stringBuffer.append(throwable.getLocalizedMessage());
        }
        if (throwable instanceof SQLException) {
            stringBuffer.append("\n");
            stringBuffer.append(isql.formatSQLExceptionMessage((SQLException)throwable));
            stringBuffer.append("\n");
            if (eedInfoProxy != null) {
                stringBuffer.append("Severity Level=" + eedInfoProxy.getSeverity() + ", State=" + eedInfoProxy.getState() + ", Transaction State=" + eedInfoProxy.getTranState());
            }
        }
        if (throwable == null || !(throwable instanceof TokenMgrError) && !(throwable instanceof ParseException)) {
            stringBuffer.append("\n");
            if (eedInfoProxy != null) {
                stringBuffer.append(this.getTokenLocation(token, eedInfoProxy));
            } else {
                stringBuffer.append(this.getTokenLocation(token));
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.log("-- " + stringTokenizer.nextToken());
        }
        string2 = ParserUtils.formatSQL(string2);
        if (isql.options.useGUI) {
            jComponent = SQLTextComponent.newInstanceOnScrollPane(10, 80, string2);
        } else {
            if (!this._silent) {
                stringBuffer.append("\n");
                stringBuffer.append(string2);
            }
            jComponent = null;
        }
        boolean bl5 = this._isIncludedFile;
        if (!bl5) {
            try {
                Token token3 = this.getToken(2);
                if (token3 == null || token3.kind != 0) {
                    bl5 = true;
                }
            }
            catch (TokenMgrError tokenMgrError) {
                // empty catch block
            }
        }
        if (isql.options.checkSyntaxOnly) {
            string3 = "Stop";
        } else if (!bl) {
            string3 = Preferences.getStringOption(this._connection, "on_error");
            if (string3 != null && string3.equals("Continue")) {
                string3 = "Continue";
                this._lastErrorStartLine = -1;
                this._lastErrorEndLine = -1;
            } else {
                string3 = "Notify_continue";
            }
        } else {
            string3 = Preferences.getStringOption(this._connection, "on_error");
        }
        boolean bl6 = string3.equalsIgnoreCase("Prompt");
        boolean bl7 = bl4 = string3.equalsIgnoreCase("Notify_continue") || string3.equalsIgnoreCase("Notify_stop") || string3.equalsIgnoreCase("Notify_exit");
        if ((Preferences.getIntOption(this._connection, "messages") & 2) == 0) {
            bl4 = false;
            bl6 = false;
            bl3 = false;
        } else {
            bl3 = true;
        }
        if (bl6 || bl4) {
            int n2;
            String[] stringArray2;
            stringArray = throwable != null && throwable instanceof SQLException ? ParserUtils.getHelpIDs((ISQLConnectionImpl)this._connection, ((SQLException)throwable).getErrorCode(), string2) : ParserUtils.getHelpIDs((ISQLConnectionImpl)this._connection, string2);
            ISQLResource iSQLResource = ISQLResource.getISQLResource(ErrorMessages.getName());
            if (bl6 && bl5 && bl2 && bl) {
                stringArray2 = new String[]{iSQLResource.getISQLString("Stop"), iSQLResource.getISQLString("Continue")};
                if (!this._silent) {
                    if (!stringBuffer.toString().endsWith("\n")) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(iSQLResource.getISQLString("You can continue executing, stop executing, or quit ISQL completely."));
                }
            } else {
                stringArray2 = new String[]{ISQLResource.getISQLString(GeneralResources.getName(), "OK")};
                n = 0;
            }
            if (bl) {
                n2 = isql.getIO(this._connection).promptForOptionWithAccessory(2, iSQLResource.getISQLString("ISQL Error"), stringBuffer.toString(), stringArray2, 0, n, jComponent, null);
            } else {
                String string4 = throwable instanceof SQLException ? ((SQLException)throwable).getSQLState() : null;
                if (string4 == null || !string4.equals("010P4")) {
                    isql.getIO(this._connection).writeln(stringBuffer.toString(), 1);
                }
                n2 = 1;
            }
            if (bl4) {
                if (string3.equalsIgnoreCase("Notify_continue")) {
                    string3 = "Continue";
                } else if (string3.equalsIgnoreCase("Notify_stop")) {
                    string3 = "Stop";
                } else if (string3.equalsIgnoreCase("Notify_exit")) {
                    string3 = "Exit";
                }
            } else {
                switch (n2) {
                    case 0: {
                        if (bl) {
                            string3 = "Stop";
                            break;
                        }
                        string3 = "Continue";
                        bl3 = false;
                        break;
                    }
                    case 1: {
                        string3 = "Continue";
                        break;
                    }
                    case 2: {
                        string3 = "Exit";
                    }
                }
            }
        } else if (bl3) {
            isql.getIO(this._connection).writeln(stringBuffer.toString(), 2);
        }
        if (jComponent != null) {
            SQLTextComponent.release(jComponent);
        }
        if (string3.equalsIgnoreCase("Continue")) {
            if (bl3 && bl) {
                isql.getIO(this._connection).writeln(ISQLResource.getISQLString(GeneralResources.getName(), "ContinuingAfterError"), 0);
            }
        } else {
            if (string3.equalsIgnoreCase("Stop")) {
                this._lineBuffer = null;
                isql.returnCode = 1;
                throw new ParseAbortedError();
            }
            if (string3.equalsIgnoreCase("Exit")) {
                isql.returnCode = 5;
                isql.closeUIForConnection(this._connection);
                throw new ParseAbortedError();
            }
        }
    }

    @Override
    public int getErrorStartLine() {
        return this._lastErrorStartLine;
    }

    @Override
    public int getErrorEndLine() {
        return this._lastErrorEndLine;
    }

    private String unescape(String string) {
        char c = Preferences.getStringOption(this._connection, "ISQL_escape_character").charAt(0);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (i == n - 1) {
                    stringBuffer.append(c2);
                    break;
                }
                if ((c2 = string.charAt(++i)) != c) {
                    int n2;
                    int n3;
                    if (c2 == 'n') {
                        c2 = '\n';
                    } else if (c2 == 'x' || c2 == 'X') {
                        if (i <= n - 2) {
                            n3 = Character.digit(string.charAt(i + 1), 16);
                            n2 = Character.digit(string.charAt(i + 2), 16);
                            if (n3 != -1 && n2 != -1) {
                                c2 = (char)(n3 * 16 + n2);
                                i += 2;
                            } else {
                                stringBuffer.append(c);
                            }
                        } else {
                            stringBuffer.append(c);
                        }
                    } else if (c2 == 'u' || c2 == 'U') {
                        if (i <= n - 4) {
                            n3 = Character.digit(string.charAt(i + 1), 16);
                            n2 = Character.digit(string.charAt(i + 2), 16);
                            int n4 = Character.digit(string.charAt(i + 3), 16);
                            int n5 = Character.digit(string.charAt(i + 4), 16);
                            if (n3 != -1 && n2 != -1 && n4 != -1 && n5 != -1) {
                                c2 = (char)(n3 * 4096 + n2 * 256 + n4 * 16 + n5);
                                i += 4;
                            } else {
                                stringBuffer.append(c);
                            }
                        } else {
                            stringBuffer.append(c);
                        }
                    } else {
                        stringBuffer.append(c);
                    }
                }
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private String getTokenLocation(Token token, EedInfoProxy eedInfoProxy) {
        int n = token.beginLine + eedInfoProxy.getLineNumber() - 1;
        String string = null;
        string = this._fileName == null ? ISQLResource.getFormattedString(ErrorMessages.getName(), "ERROR_LINE", Integer.toString(n)) : ISQLResource.getFormattedString(ErrorMessages.getName(), "ERROR_FILE_AND_LINE", this._fileName.getName(), Integer.toString(n));
        return string;
    }

    private String getTokenLocation(Token token) {
        String string = null;
        if (this._fileName == null) {
            if (token != null) {
                string = ISQLResource.getFormattedString(ErrorMessages.getName(), "Line {0}, column {1}", Integer.toString(token.beginLine), Integer.toString(token.beginColumn));
            }
        } else if (token != null) {
            string = ISQLResource.getFormattedString(ErrorMessages.getName(), "File: \"{0}\" on line {1}, column {2}", this._fileName.getName(), Integer.toString(token.beginLine), Integer.toString(token.beginColumn));
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private boolean shouldMeasureTime() {
        return !this._isIncludedFile && Preferences.getBooleanOption(this._connection, "ISQL_command_timing");
    }

    private void displayElapsedTime(long l, IO iO) {
        DecimalFormat decimalFormat = new DecimalFormat("########.###");
        double d = (double)l / 1000.0;
        String string = decimalFormat.format(d);
        iO.writeln(ISQLResource.getFormattedString(GeneralResources.getName(), "Execution time: {0} seconds", string), 0);
    }

    private boolean moreCommandsPending() {
        boolean bl = false;
        try {
            Token token = this.getToken(1);
            if (token == null || token.kind != 0) {
                bl = true;
            }
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
        if (!bl && this._isIncludedFile && this._parentParser != null) {
            bl = this._parentParser.moreCommandsPending();
        }
        return bl;
    }

    private boolean executeSQL(String string) {
        return this.executeSQL(string, false);
    }

    private boolean executeSQL(String string, boolean bl) {
        boolean bl2;
        if (!isql.ensureConnected(this._connection)) {
            throw new UserAbortedParsingError(ISQLResource.getISQLString(GeneralResources.getName(), "Aborted by user"));
        }
        this._messages.removeAllElements();
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ';') {
                string = string.substring(0, i);
                break;
            }
            if (i >= string.length() - 1) break;
            string = string.substring(0, i + 1);
            break;
        }
        SQLException[] sQLExceptionArray = new SQLException[]{null};
        SQLWarning[] sQLWarningArray = new SQLWarning[]{null};
        String[] stringArray = new String[]{null};
        if (isql.options.checkSyntaxOnly) {
            bl2 = this._connection.checkSyntax(string, sQLExceptionArray, stringArray);
        } else {
            boolean bl3 = this.shouldMeasureTime();
            long l = bl3 ? System.currentTimeMillis() : 0L;
            int n = this.moreCommandsPending() ? 0 : 2;
            while (bl2 = this._connection.execute(string, bl, false, n, sQLWarningArray, sQLExceptionArray, stringArray, this._resultsProcessor)) {
                --this._goCount;
                if (this._goCount > 0) continue;
            }
            this._goCount = 1;
            if (bl2 && bl3) {
                long l2 = System.currentTimeMillis();
                this.displayElapsedTime(l2 - l, isql.getIO(this._connection));
            }
        }
        if (!bl2) {
            this.handleErrorOrWarning(stringArray[0], string, sQLExceptionArray[0], true, true);
        } else if (sQLWarningArray[0] != null) {
            this.handleErrorOrWarning(null, string, sQLWarningArray[0], false, true);
        }
        return bl2;
    }

    private int isISQLOption(String string) {
        int[] nArray = new int[]{22, 23, 27, 33, 38, 47, 53, 64, 71, 74, 75, 76, 77, 78, 79, 80, 81, 83, 82, 94, 99, 105, 106, 107, 122, 130};
        int n = -1;
        string = '\"' + string + '\"';
        for (int i = 0; i < nArray.length; ++i) {
            if (!string.equalsIgnoreCase(ASEParserConstants.tokenImage[nArray[i]])) continue;
            n = nArray[i];
            break;
        }
        return n;
    }

    @Override
    public void enableDebuggingOutput() {
        this.disable_tracing();
    }

    static boolean dbgEnabled() {
        return false;
    }

    public final void sqlToken() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 147: {
                this.jj_consume_token(147);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 146: {
                this.jj_consume_token(146);
                break;
            }
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                break;
            }
            case 145: {
                this.jj_consume_token(145);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 125: {
                this.jj_consume_token(125);
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            case 127: {
                this.jj_consume_token(127);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 129: {
                this.jj_consume_token(129);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                break;
            }
            case 131: {
                this.jj_consume_token(131);
                break;
            }
            case 132: {
                this.jj_consume_token(132);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            case 134: {
                this.jj_consume_token(134);
                break;
            }
            case 135: {
                this.jj_consume_token(135);
                break;
            }
            case 136: {
                this.jj_consume_token(136);
                break;
            }
            case 137: {
                this.jj_consume_token(137);
                break;
            }
            case 138: {
                this.jj_consume_token(138);
                break;
            }
            case 148: {
                this.jj_consume_token(148);
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                break;
            }
            case 150: {
                this.jj_consume_token(150);
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                break;
            }
            case 152: {
                this.jj_consume_token(152);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                break;
            }
            case 154: {
                this.jj_consume_token(154);
                break;
            }
            case 155: {
                this.jj_consume_token(155);
                break;
            }
            case 156: {
                this.jj_consume_token(156);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void isqlCommand() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            case 116: {
                this.jj_consume_token(116);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void keyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 35: 
            case 39: 
            case 40: 
            case 49: 
            case 59: 
            case 65: 
            case 70: 
            case 104: 
            case 109: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 123: 
            case 124: {
                this.isqlCommand();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 122: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                this.sqlToken();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    boolean isDelimitedIdentifier(String string, char c, char c2) throws ParseException {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            char c3 = string.charAt(i);
            if (i == 0) {
                if (c3 == c) continue;
                bl = false;
                break;
            }
            if (i == n - 1) {
                if (c3 == c2) continue;
                bl = false;
                break;
            }
            boolean bl3 = c3 == '#' || c3 == '$' || c3 == '@' || c3 == '_' || c3 >= 'A' && c3 <= 'Z' || c3 >= 'a' && c3 <= 'z' || c3 >= '\u0080' && c3 <= '\uffff';
            boolean bl4 = bl2 = c3 >= '0' && c3 <= '9';
            if ((i != 1 || bl3) && (bl3 || bl2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public final String identifierOrString() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 180: {
                this.jj_consume_token(180);
                return this.token.image;
            }
            case 164: {
                this.jj_consume_token(164);
                return this.token.image;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                this.keyword();
                return this.token.image;
            }
            case 185: {
                this.jj_consume_token(185);
                return this.unparameterize(this.token.image);
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifierOrStringOrNumber() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 164: 
            case 180: 
            case 185: {
                String string = this.identifierOrString();
                return string;
            }
            case 157: {
                this.jj_consume_token(157);
                return this.token.image;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISQLConnection isqlStatementList(ISQLConnection iSQLConnection, boolean bl) throws ParseException {
        ISQLConnection iSQLConnection2;
        ISQLConnection iSQLConnection3 = this._connection;
        ASEParser aSEParser = this.token_source.getParser();
        _currentParser = this;
        try {
            this.token_source.setParser(this);
            this._connection = iSQLConnection;
            this._silent = bl;
            this._lastErrorStartLine = -1;
            this._lastErrorEndLine = -1;
            try {
                this.isqlStatementList_2();
            }
            catch (ParseAbortedError parseAbortedError) {
                if (this._isIncludedFile) {
                    throw parseAbortedError;
                }
            }
            catch (TokenMgrError tokenMgrError) {
                try {
                    this.handleErrorOrWarning(null, this.getLastStatement(), tokenMgrError, true, false);
                }
                catch (ParseAbortedError parseAbortedError) {
                    if (this._isIncludedFile) {
                        throw parseAbortedError;
                    }
                }
                finally {
                    this._lineBuffer = new StringBuffer();
                }
            }
        }
        catch (ParseException parseException) {
            try {
                this.handleErrorOrWarning(parseException.getMessage(), this.getLastStatement(), parseException, true, false);
            }
            catch (ParseAbortedError parseAbortedError) {
                // empty catch block
            }
        }
        finally {
            iSQLConnection2 = this._connection;
            this._connection = iSQLConnection3;
            this.token_source.reset();
            this.token_source.setParser(aSEParser);
        }
        return iSQLConnection2;
    }

    public final void isqlStatementList_2() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 164: 
                case 182: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.isqlStatement();
        }
        if (this._lineBuffer != null && this._lineBuffer.length() != 0) {
            if (this.token != null) {
                if (this.token.beginLine == 0) {
                    this.token.beginLine = 1;
                }
                if (this.token.beginColumn == 0) {
                    this.token.beginColumn = 1;
                }
            }
            this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void isqlStatement() throws ParseException {
        String string = null;
        MsgFilter msgFilter = new MsgFilter(isql.getIO(this._connection));
        isql.setIO(this._connection, msgFilter);
        try {
            if (this.jj_2_2(Integer.MAX_VALUE)) {
                this.setStatement();
                return;
            }
            if (this.jj_2_3(Integer.MAX_VALUE)) {
                this.connectStatement();
                return;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 164: 
                case 182: {
                    if (this.jj_2_1(2)) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: {
                                this.clearStatement();
                                break;
                            }
                            case 39: {
                                this.configureStatement();
                                break;
                            }
                            case 42: {
                                this.createDatabaseStatement();
                                break;
                            }
                            case 48: {
                                this.describeStatement();
                                break;
                            }
                            case 49: {
                                this.disconnectStatement();
                                break;
                            }
                            case 52: {
                                this.dropDatabaseStatement();
                                break;
                            }
                            case 29: 
                            case 59: 
                            case 114: {
                                this.exitStatement();
                                break;
                            }
                            case 65: {
                                this.helpStatement();
                                break;
                            }
                            case 70: {
                                this.inputStatement();
                                break;
                            }
                            case 104: {
                                this.outputStatement();
                                break;
                            }
                            case 109: {
                                this.parametersStatement();
                                break;
                            }
                            case 120: {
                                this.startStatement();
                                break;
                            }
                            case 123: {
                                this.stopStatement();
                                break;
                            }
                            case 124: {
                                this.systemStatement();
                                break;
                            }
                            case 132: {
                                this.useStatement();
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 139: 
                            case 140: 
                            case 141: 
                            case 142: {
                                Token token;
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 139: {
                                        token = this.jj_consume_token(139);
                                        break;
                                    }
                                    case 140: {
                                        token = this.jj_consume_token(140);
                                        break;
                                    }
                                    case 141: {
                                        token = this.jj_consume_token(141);
                                        break;
                                    }
                                    case 142: {
                                        token = this.jj_consume_token(142);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[7] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                string = this.filename();
                                isql.setIO(this._connection, msgFilter.getOriginalIO());
                                msgFilter = null;
                                if (string == null) break;
                                boolean bl = token.kind == 140 || token.kind == 142;
                                boolean bl2 = token.kind == 141 || token.kind == 142;
                                this.writeMessages(string, bl, bl2);
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 13: {
                                this.jj_consume_token(13);
                                return;
                            }
                            case 12: {
                                this.jj_consume_token(12);
                                return;
                            }
                            case 0: {
                                this.jj_consume_token(0);
                                return;
                            }
                        }
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 116: {
                            this.readStatement();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 13: {
                                    this.jj_consume_token(13);
                                    return;
                                }
                                case 12: {
                                    this.jj_consume_token(12);
                                    return;
                                }
                                case 0: {
                                    this.jj_consume_token(0);
                                    return;
                                }
                            }
                            this.jj_la1[10] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 115: 
                        case 117: 
                        case 119: 
                        case 121: 
                        case 122: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 164: 
                        case 182: {
                            this.sqlStatement();
                            return;
                        }
                        case 13: {
                            this.jj_consume_token(13);
                            return;
                        }
                        case 12: {
                            this.jj_consume_token(12);
                            return;
                        }
                    }
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        finally {
            this.flushLineBuffer();
            if (msgFilter != null && isql.getIO(this._connection) == msgFilter) {
                isql.setIO(this._connection, msgFilter.getOriginalIO());
            }
            if (isql.isShutdownRequested()) {
                throw new UserAbortedParsingError("");
            }
            this._messages.removeAllElements();
            if (this._interruptRequested) {
                throw new UserAbortedParsingError(ISQLResource.getISQLString(GeneralResources.getName(), "Aborted by user"));
            }
        }
    }

    void writeMessages(String string, boolean bl, boolean bl2) throws ParseException {
        this.writeMessages2(string, bl, bl2, true);
    }

    void writeMessages2(String string, boolean bl, boolean bl2, boolean bl3) throws ParseException {
        String string2 = System.getProperty("line.separator");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            for (int i = 0; i < this._messages.size(); ++i) {
                String string3 = this._messages.elementAt(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "\r\n");
                while (stringTokenizer.hasMoreTokens()) {
                    if (bl3) {
                        outputStreamWriter.write("-- ");
                    }
                    outputStreamWriter.write(stringTokenizer.nextToken());
                    outputStreamWriter.write(string2);
                }
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            isql.getIO(this._connection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "Error! Could not write statment output to file.\n{0}", iOException.getLocalizedMessage()), 2);
        }
        this._messages.removeAllElements();
    }

    public final void sqlStatementStart() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 164: {
                this.jj_consume_token(164);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 122: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                this.sqlToken();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this._firstSQLToken = this.token;
    }

    Token matchToCommandDelimiter(Token token) throws ParseException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        this._goCount = 1;
        Token token2 = token;
        while (true) {
            Token token3 = this.getToken(0);
            if (token3.kind == 0) {
                this.accumulateLine(token3);
                break;
            }
            if (token3.kind == 182) {
                token2 = token3;
            } else {
                if (token3.kind == 12) {
                    this._goCount = this.extractCountFromCommandDelimiter(token3.image);
                    break;
                }
                if (token3.kind == 26) {
                    ++n2;
                } else if (token3.kind == 55) {
                    --n2;
                } else if (token3.kind == 146) {
                    --n2;
                } else if (token3.kind == 50 || token3.kind == 127 || token3.kind == 91) {
                    if (n2 == 0) {
                        ++n;
                    }
                } else if ((token3.kind == 144 || token3.kind == 143 || token3.kind == 145) && n2 == 0) {
                    --n;
                }
            }
            if (token3.kind == 180 || token3.kind == 175 || token3.kind == 164 && token3.image != null && token3.image.length() > 0 && (token3.image.charAt(0) == '\"' || token3.image.charAt(0) == '[')) {
                token3.image = this.unparameterize(token3.image);
                if (token3.kind == 175 && this.isDelimitedIdentifier(token3.image, '\"', '\"')) {
                    token3.kind = 164;
                }
            }
            if (token3.kind == 185) {
                token3.image = this.unparameterize(token3.image);
                if (this.isDelimitedIdentifier(token3.image, '[', ']')) {
                    token3.kind = 164;
                }
            }
            if (bl) {
                this.accumulateLine(token3);
            } else {
                bl = true;
            }
            token3 = this.getToken(1);
            if (token3.kind == 139 || token3.kind == 140 || token3.kind == 141 || token3.kind == 142) {
                this.markEndOfLine();
                break;
            }
            this.getNextToken();
        }
        return token2;
    }

    int extractCountFromCommandDelimiter(String string) throws ParseException {
        Matcher matcher;
        int n = 1;
        if (_goPattern == null) {
            String string2 = "[ \\t]*(?:/\\*[^\\n\\r]*\\*/)*go[ \\t]*([0-9]+)?[ \\t]*(?:/\\*[^\\n\\r]*\\*/)*(?:\\r|\\n|\\r\\n|--[^\\r\\n]*(?:\\r|\\n|\\r\\n)?|//[^\\r\\n]*(?:\\r|\\n|\\r\\n)?)";
            _goPattern = Pattern.compile(string2);
        }
        if ((matcher = _goPattern.matcher(string)).matches() && matcher.groupCount() == 1) {
            String string3 = matcher.group(1);
            try {
                n = Integer.parseInt(string3);
                if (n < 1) {
                    n = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void sqlStatement() throws ParseException {
        boolean bl;
        String string;
        String string2 = null;
        Token token = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Token token2 = null;
        boolean bl5 = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 122: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 164: {
                this.sqlStatementStart();
                break;
            }
            case 182: {
                token2 = this.jj_consume_token(182);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        token2 = this.matchToCommandDelimiter(token2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 139: {
                        token = this.jj_consume_token(139);
                        break;
                    }
                    case 140: {
                        token = this.jj_consume_token(140);
                        break;
                    }
                    case 141: {
                        token = this.jj_consume_token(141);
                        break;
                    }
                    case 142: {
                        token = this.jj_consume_token(142);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                string2 = this.filename();
                if (string2 == null) break;
                bl2 = token.kind == 140 || token.kind == 142;
                bl4 = bl3 = token.kind == 141 || token.kind == 142;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        if (this._connection == null) {
            return;
        }
        if (!isql.ensureConnected(this._connection)) {
            throw new UserAbortedParsingError(ISQLResource.getISQLString(GeneralResources.getName(), "Aborted by user"));
        }
        this.flushLineBuffer();
        if (string2 == null && this._redirectionFile != null) {
            string2 = this._redirectionFile;
            bl3 = this._redirectionWithErrors;
            bl2 = true;
        }
        if (this._previousLineEnd == -1) {
            if (this._previousLine == null) return;
            string = this._previousLine.toString();
        } else {
            string = this._previousLine.substring(0, this._previousLineEnd);
        }
        if (string2 != null && bl3) {
            this._messages.add(" ");
            this._messages.add(ISQLResource.getISQLString(GeneralResources.getName(), "Executing command:"));
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                this._messages.add("  " + stringTokenizer.nextToken());
            }
            this.writeMessages(string2, bl2, bl3);
        }
        if ((bl = this.executeSQL(string, bl5 = token2 != null)) && this._connection instanceof ISQLConnectionImpl && ((ISQLConnectionImpl)this._connection).getResultSetCount(true) != 0 && string2 != null) {
            InputOutputOptions inputOutputOptions = new InputOutputOptions(this._connection);
            inputOutputOptions.setFileName(string2);
            inputOutputOptions.setFormat(Preferences.getFileFormatCode(this._connection, "output_format"));
            if (bl2) {
                inputOutputOptions.setAppend(true);
            }
            if (bl4) {
                inputOutputOptions.setVerbose(true);
            }
            OutputStatement.execute((ISQLConnectionImpl)this._connection, inputOutputOptions, this._messages);
            return;
        } else {
            if (this._messages.size() == 0 || string2 == null || !bl3) return;
            this.writeMessages(string2, bl2, bl3);
        }
    }

    public final String filename() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 190: {
                this.jj_consume_token(190);
                string = this.token.image.trim();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 164: {
                        this.jj_consume_token(164);
                        break;
                    }
                    case 157: {
                        this.jj_consume_token(157);
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: {
                        this.keyword();
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                char c = this.token.image.charAt(0);
                char c2 = this.token.image.charAt(this.token.image.length() - 1);
                if (c == '\"' && c2 == '\"' || c == '\'' && c2 == '\'' || c == '[' && c2 == ']') {
                    string = this.unescape(ParserUtils.stripQuotes(this.token.image));
                    break;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.token.image);
                while (true) {
                    Token token = this.getToken(1);
                    if (token.specialToken != null || token.kind == 0 || token.kind == 13) break;
                    stringBuilder.append(token.image);
                    this.getNextToken();
                }
                string = stringBuilder.toString();
                break;
            }
            case 175: 
            case 180: 
            case 192: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 192: {
                        this.jj_consume_token(192);
                        break;
                    }
                    case 180: {
                        this.jj_consume_token(180);
                        break;
                    }
                    case 175: {
                        this.jj_consume_token(175);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                string = this.unescape(ParserUtils.stripQuotes(this.token.image));
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.unparameterize(string);
    }

    public final String readLine() throws ParseException {
        this.token_source.SwitchTo(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 194: {
                this.jj_consume_token(194);
                int n = this.token.image.lastIndexOf(13);
                if (n == -1) {
                    n = this.token.image.lastIndexOf(10);
                }
                String string = n == -1 ? this.token.image : this.token.image.substring(0, n);
                n = this._lineBuffer.lastIndexOf("\r");
                if (n == -1) {
                    n = this._lineBuffer.lastIndexOf("\n");
                }
                if (n != -1) {
                    this._lineBuffer.setLength(n);
                }
                this.flushLineBuffer();
                return string;
            }
            case 195: {
                this.jj_consume_token(195);
                this.flushLineBuffer();
                return null;
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    String unparameterize(String string) throws ParseException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf(123, n2);
            if (n3 == -1) {
                stringBuffer.append(string.substring(n2));
                break;
            }
            int n4 = string.indexOf(125, n3 + 1);
            if (n4 == -1) {
                stringBuffer.append(string.substring(n2));
                break;
            }
            stringBuffer.append(string.substring(n2, n3));
            String string2 = string.substring(n3 + 1, n4);
            String string3 = this.lookupParameter(string2);
            if (string3 != null) {
                stringBuffer.append(string3);
            } else if (string2.indexOf(123) == -1) {
                stringBuffer.append('{');
                stringBuffer.append(string2);
                stringBuffer.append('}');
            } else {
                stringBuffer.append('{');
                n4 = n3;
            }
            n2 = n4 + 1;
        }
        return stringBuffer.toString();
    }

    public final void configureStatement() throws ParseException {
        this.jj_consume_token(39);
        this.ensureNoMoreTokensOnLine();
        if (!isql.options.checkSyntaxOnly) {
            isql.openPreferencesDialog(this._connection);
        }
    }

    public final void connectStatement() throws ParseException {
        ASEConnectionInfo aSEConnectionInfo;
        boolean bl;
        Object object;
        ASEConnectionInfo aSEConnectionInfo2 = new ASEConnectionInfo();
        this.jj_consume_token(40);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        block11: while (true) {
            Token token = this.getNextToken();
            this.accumulateLine(token);
            switch (token.kind) {
                case 0: 
                case 12: {
                    break block11;
                }
                case 134: {
                    token = this.getNextToken();
                    this.accumulateLine(token);
                    if (token.kind == 180) {
                        string7 = ParserUtils.stripQuotes(token.image);
                        break block11;
                    }
                    this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
                    break block11;
                }
                case 128: {
                    token = this.getNextToken();
                    this.accumulateLine(token);
                    if (token.kind == 18) {
                        Token token2 = this.getToken(1);
                        if (token2.kind != 12 && token2.kind != 0) {
                            token = this.getNextToken();
                            this.accumulateLine(token);
                            string2 = ParserUtils.stripQuotes(token.image);
                            continue block11;
                        }
                    }
                    string = token.image;
                    break block11;
                }
                case 43: {
                    token = this.getNextToken();
                    this.accumulateLine(token);
                    if (token.kind == 12 || token.kind == 0) {
                        this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
                    }
                    string3 = ParserUtils.stripQuotes(token.image);
                    continue block11;
                }
                case 17: {
                    token = this.getNextToken();
                    this.accumulateLine(token);
                    if (token.kind == 12 || token.kind == 0) {
                        this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
                    }
                    string4 = ParserUtils.stripQuotes(token.image);
                    continue block11;
                }
                case 67: {
                    if (this.getToken((int)1).kind != 28) continue block11;
                    token = this.getNextToken();
                    this.accumulateLine(token);
                    token = this.getNextToken();
                    this.accumulateLine(token);
                    string6 = ParserUtils.stripQuotes(token.image);
                    continue block11;
                }
                case 133: {
                    token = this.getNextToken();
                    this.accumulateLine(token);
                }
                default: {
                    string5 = ParserUtils.stripQuotes(token.image);
                    continue block11;
                }
            }
            break;
        }
        if (string != null) {
            if (!isql.ensureConnected(this._connection)) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "You are not connected to a database."));
            }
            this.executeSQL("connect to " + string, false);
            return;
        }
        if (string5 != null) {
            aSEConnectionInfo2.setUserName(string5);
        }
        if (string6 != null) {
            aSEConnectionInfo2.setPassword(string6);
        }
        if (string3 != null) {
            aSEConnectionInfo2.setDatabaseName(string3);
        }
        if (string2 != null) {
            aSEConnectionInfo2.setServerName(string2);
        }
        if (string7 != null) {
            aSEConnectionInfo2.mergeConnectionString(string7);
        }
        if (string4 != null) {
            aSEConnectionInfo2.setConnectionName(string4);
        }
        if ((string = aSEConnectionInfo2.getServerName()) != null && string.length() > 0) {
            int n = string.indexOf(":");
            if (n == -1) {
                object = ASEDatabaseSource.getServer(string);
                if (object != null && ((SyASEServerProxy)object).getHost() != null && !((SyASEServerProxy)object).getHost().isEmpty() && ((SyASEServerProxy)object).getPortNumber() != -1) {
                    aSEConnectionInfo2.host = ((SyASEServerProxy)object).getHost();
                    aSEConnectionInfo2.port = ((SyASEServerProxy)object).getPortNumber();
                }
            } else {
                aSEConnectionInfo2.host = string.substring(0, n);
                try {
                    aSEConnectionInfo2.port = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    aSEConnectionInfo2.host = null;
                    aSEConnectionInfo2.port = -1;
                }
                object = ASEDatabaseSource.getClientSideServerName(aSEConnectionInfo2.host, String.valueOf(aSEConnectionInfo2.port));
                if (object != null) {
                    aSEConnectionInfo2.setServerName((String)object);
                }
            }
        }
        if (aSEConnectionInfo2.getPassword() == null && aSEConnectionInfo2.getUserName() != null) {
            if (!isql.ensureConnected(this._connection)) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "You are not connected to a database."));
            }
            this.executeSQL("SETUSER WITH OPTIONS " + aSEConnectionInfo2.getUserName(), false);
            return;
        }
        this.ensureNoMoreTokensOnLine();
        boolean bl2 = bl = aSEConnectionInfo2.getUserName() != null || aSEConnectionInfo2.getPassword() != null || aSEConnectionInfo2.getServerName() != null || aSEConnectionInfo2.getConnectionName() != null || aSEConnectionInfo2.getDatabaseName() != null || aSEConnectionInfo2.getOtherParms() != null;
        if (this._connection != null && this._connection instanceof ISQLConnectionImpl) {
            aSEConnectionInfo = new ASEConnectionInfo((ASEConnectionInfo)((ISQLConnectionImpl)this._connection).getConnectionInfo());
            aSEConnectionInfo2.merge(aSEConnectionInfo, false);
        }
        aSEConnectionInfo = aSEConnectionInfo2;
        ISQLPlugin iSQLPlugin = PluginMgr.getPlugin("ASE");
        if (bl) {
            Vector<String> vector = new Vector<String>();
            isql.connect(this._connection, iSQLPlugin, aSEConnectionInfo, isql.options.useGUI, !isql.options.useGUI, vector);
            if (!this._connection.isConnected()) {
                object = new StringBuilder();
                for (int i = 0; i < vector.size(); ++i) {
                    ((StringBuilder)object).append(vector.get(i));
                    if (i <= 0) continue;
                    ((StringBuilder)object).append(System.getProperty("line.separator"));
                }
                this.handleError(((StringBuilder)object).toString());
                return;
            }
        } else {
            isql.connect(this._connection, iSQLPlugin, aSEConnectionInfo, true, false, null);
        }
        if (this._connection.isConnected()) {
            isql.getIO(this._connection).writeln(ISQLResource.getFormattedString(GeneralResources.getName(), "CONNECTED_TO_DATABASE", this._connection.getCatalog(), this._connection.getServerName()), 0);
        }
    }

    public final void disconnectStatement() throws ParseException {
        boolean bl = false;
        this.jj_consume_token(49);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 164: 
            case 180: 
            case 185: {
                bl = this.disconnectOption();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.ensureNoMoreTokensOnLine();
        if (!bl && this._connection != null && this._connection.isConnected()) {
            this.executeSQL("disconnect", false);
        }
    }

    public final boolean disconnectOption() throws ParseException {
        if (this.jj_2_4(2)) {
            this.disconnectAllOption();
        } else if (this.jj_2_5(2)) {
            this.disconnectCurrentOption();
        } else if (this.jj_2_6(2)) {
            this.disconnectNamedConnectionOption();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return true;
    }

    public final void disconnectAllOption() throws ParseException {
        this.jj_consume_token(14);
        isql.closeAllConnections();
    }

    public final void disconnectCurrentOption() throws ParseException {
        this.jj_consume_token(63);
        this.jj_consume_token(18);
        ISQLConnection iSQLConnection = isql.getUIActiveConnection();
        String string = iSQLConnection.getServerName();
        isql.closeConnection(iSQLConnection);
        isql.getIO(iSQLConnection).writeln(ISQLResource.getFormattedString(GeneralResources.getName(), "Disconnected.", string), 0);
    }

    public final void disconnectNamedConnectionOption() throws ParseException {
        String string = this.identifierOrString();
        isql.closeNamedConnection(ParserUtils.stripQuotes(string));
    }

    public final void clearStatement() throws ParseException {
        this.jj_consume_token(35);
        this.ensureNoMoreTokensOnLine();
        isql.clear(this._connection);
    }

    public final void exitStatement() throws ParseException {
        Token token = null;
        String string = null;
        String string2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 164: 
            case 180: 
            case 185: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 157: {
                        token = this.jj_consume_token(157);
                        break block7;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 164: 
                    case 180: 
                    case 185: {
                        string = this.identifierOrString();
                        break block7;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        this.ensureNoMoreTokensOnLine();
        if (token != null) {
            string2 = token.image;
        } else if (string != null) {
            if (this._connection != null && this._connection.isConnected()) {
                SQLException[] sQLExceptionArray = new SQLException[]{null};
                String[] stringArray = new String[]{null};
                this._connection.discardResultSets();
                boolean bl = this._connection.execute("SELECT " + string, false, false, 4, null, sQLExceptionArray, stringArray, new ParserUtils.PUResultsProcessor());
                if (bl) {
                    if (this._connection.getResultSetCount() != 0) {
                        ISQLResultSet iSQLResultSet = this._connection.getResultSet(0);
                        try {
                            string2 = iSQLResultSet.getStringValueAt(0, 0);
                        }
                        catch (SQLException sQLException) {
                            string2 = null;
                        }
                        if (string2 == null || string2.equals(Preferences.getPluginStringPreference((ISQLConnectionImpl)this._connection, "nulls", "(NULL)"))) {
                            string2 = "0";
                        }
                        this._connection.discardResultSets();
                    } else {
                        this._connection.discardResultSets();
                        this.flushLineBuffer();
                        if (stringArray[0] == null && sQLExceptionArray[0] != null) {
                            stringArray[0] = sQLExceptionArray[0].getLocalizedMessage();
                        }
                        this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "INVALID_EXIT_STATEMENT_ARGUMENT"), sQLExceptionArray[0]);
                    }
                } else {
                    this.flushLineBuffer();
                    this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "INVALID_EXIT_STATEMENT_ARGUMENT"), sQLExceptionArray[0]);
                }
            } else {
                this.flushLineBuffer();
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
            }
        }
        if (string2 != null) {
            try {
                int n;
                isql.returnCode = n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.flushLineBuffer();
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
            }
        }
        isql.closeUIForConnection(this._connection);
    }

    public final void helpStatement() throws ParseException {
        String string = null;
        this.jj_consume_token(65);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 164: 
            case 180: 
            case 185: {
                string = this.identifierOrString();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.ensureNoMoreTokensOnLine();
        string = string != null ? ParserUtils.stripQuotes(string) : "HELP_ISQL_MAIN_PAGE";
        isql.help(this._connection, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void inputStatement() throws ParseException {
        int n;
        InputOutputOptions inputOutputOptions = new InputOutputOptions(this._connection);
        this.jj_consume_token(70);
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: 
                case 30: 
                case 37: 
                case 42: 
                case 46: 
                case 54: 
                case 57: 
                case 58: 
                case 61: 
                case 63: 
                case 72: 
                case 86: 
                case 96: 
                case 112: 
                case 134: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block5;
                }
            }
            this.inputOption(inputOutputOptions);
        }
        this.ensureNoMoreTokensOnLine();
        if (inputOutputOptions.getFormat() == 0) {
            inputOutputOptions.setFormat(Preferences.getFileFormatCode(this._connection, "output_format"));
        }
        if (inputOutputOptions.getFormat() == 14) {
            if (inputOutputOptions.getFileName() == null || inputOutputOptions.getFileName().length() == 0) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "INPUT_USING_NEEDS_FROM_CLAUSE"));
            }
            if (inputOutputOptions.getTableName() == null || inputOutputOptions.getTableName().length() == 0) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "INPUT_USING_NEEDS_INTO_CLAUSE"));
            }
        } else {
            String string = inputOutputOptions.getFileName();
            if (string != null && string.length() != 0) {
                File file = ParserUtils.searchForFileForInput(string, this._fileName);
                if (file == null) {
                    this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not find \"{0}\"", string));
                    return;
                }
                string = file.getAbsolutePath();
                inputOutputOptions.setFileName(string);
            }
            if (!(string != null && string.length() != 0 || inputOutputOptions.getPrompt() || (n = inputOutputOptions.getFormat()) == 1 || n == 4)) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
                return;
            }
        }
        if (inputOutputOptions.getFormat() == 3 || inputOutputOptions.getFormat() == 13) {
            this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Bad INPUT statement. You cannot import data in the given format."));
            return;
        }
        if (inputOutputOptions.getColumnMatchingTechnique() == 2 && (n = inputOutputOptions.getFormat()) != 14) {
            this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "BY NAME is not compatible with the selected file format."));
            return;
        }
        if (inputOutputOptions.getEncoding() != null && !inputOutputOptions.getEncoding().equals(inputOutputOptions.getSystemEncoding()) && (n = inputOutputOptions.getFormat()) != 1) {
            this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "EncodingSupportedForASCIIOnly"));
        }
        if (inputOutputOptions.getPrompt()) {
            inputOutputOptions.setFormat(12);
        }
        if ((inputOutputOptions.getTableName() == null || inputOutputOptions.getTableName().length() == 0) && inputOutputOptions.getFormat() != 4) {
            this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "INPUT statement is missing a table name"));
            return;
        }
        if (isql.options.checkSyntaxOnly || !isql.ensureConnected(this._connection)) return;
        if (inputOutputOptions.getFormat() == 4) {
            inputOutputOptions.setSQLReader(new SQLFormatReader(inputOutputOptions.getEscapeCharacter()));
        } else if (inputOutputOptions.getFormat() == 1 && (inputOutputOptions.getFileName() == null || inputOutputOptions.getFileName().length() == 0)) {
            inputOutputOptions.setSQLReader(new SQLFormatReader(inputOutputOptions.getEscapeCharacter()));
            this.accumulateLine(";");
            this.flushLineBuffer();
        }
        try {
            InputStatement.execute(this._connection, inputOutputOptions);
        }
        catch (ImporterFailedException importerFailedException) {
            this.handleError(importerFailedException.getLocalizedMessage());
        }
        inputOutputOptions.setSQLReader(null);
    }

    public final void inputOption(InputOutputOptions inputOutputOptions) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.intoOption(inputOutputOptions);
                break;
            }
            case 63: 
            case 112: {
                this.inputFromOption(inputOutputOptions);
                break;
            }
            case 61: {
                this.formatOption(inputOutputOptions);
                break;
            }
            case 57: {
                this.escapeCharacterOption(inputOutputOptions);
                break;
            }
            case 58: {
                this.escapesOption(inputOutputOptions);
                break;
            }
            case 28: {
                this.byOrderOrNameOption(inputOutputOptions);
                break;
            }
            case 46: {
                this.delimitedByOption(inputOutputOptions);
                break;
            }
            case 37: {
                this.columnWidthsOption(inputOutputOptions);
                break;
            }
            case 96: {
                this.noStripOption(inputOutputOptions);
                break;
            }
            case 86: {
                this.columnList(inputOutputOptions);
                break;
            }
            case 54: {
                this.encodingOption(inputOutputOptions);
                break;
            }
            case 30: {
                this.byteOrderMarkOption(inputOutputOptions);
                break;
            }
            case 134: {
                this.usingOption(inputOutputOptions);
                break;
            }
            case 42: {
                this.createTableOption(inputOutputOptions);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void createTableOption(InputOutputOptions inputOutputOptions) throws ParseException {
        Token token = null;
        this.jj_consume_token(42);
        this.jj_consume_token(125);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 97: {
                token = this.jj_consume_token(97);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        inputOutputOptions.setDontCreateTable(token != null);
    }

    public final void usingOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(134);
        Token token = this.jj_consume_token(180);
        inputOutputOptions.setConnectionString(ParserUtils.stripQuotes(token.image));
        inputOutputOptions.setFormat(14);
    }

    public final void byteOrderMarkOption(InputOutputOptions inputOutputOptions) throws ParseException {
        Token token = null;
        this.jj_consume_token(30);
        this.jj_consume_token(103);
        this.jj_consume_token(92);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                token = this.jj_consume_token(98);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token != null) {
            inputOutputOptions.useByteOrderMark = true;
            inputOutputOptions.useByteOrderMarkSpecified = true;
        } else {
            inputOutputOptions.useByteOrderMark = false;
            inputOutputOptions.useByteOrderMarkSpecified = true;
        }
    }

    public final void encodingOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(54);
        String string = this.identifierOrString();
        String string2 = ParserUtils.stripQuotes(string);
        String string3 = string2.equalsIgnoreCase("utf16") || string2.equalsIgnoreCase("utf-16") ? "utf-16" : ParserUtils.getCanonicalEncodingName(string2);
        if (string3 != null) {
            inputOutputOptions.setEncoding(string3);
        } else {
            this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "EncodingNotSupported", string2));
        }
    }

    public final void intoOption(InputOutputOptions inputOutputOptions) throws ParseException {
        String string;
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        this.jj_consume_token(72);
        token = this.jj_consume_token(164);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                token2 = this.jj_consume_token(164);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        token3 = this.jj_consume_token(164);
                        break block0;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        String string2 = null;
        String string3 = null;
        if (token != null && token2 == null && token3 == null) {
            string = ParserUtils.stripQuotes(token.image);
        } else if (token != null && token2 != null && token3 == null) {
            string3 = ParserUtils.stripQuotes(token.image);
            string = ParserUtils.stripQuotes(token2.image);
        } else {
            string2 = ParserUtils.stripQuotes(token.image);
            string3 = ParserUtils.stripQuotes(token2.image);
            string = ParserUtils.stripQuotes(token3.image);
        }
        inputOutputOptions.setOwnerAndTableName(string2, string3, string);
    }

    public final void inputFromOption(InputOutputOptions inputOutputOptions) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.inputFromFileName(inputOutputOptions);
                break;
            }
            case 112: {
                this.inputFromPrompt(inputOutputOptions);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void inputFromFileName(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(63);
        String string = this.filename();
        inputOutputOptions.setPrompt(false);
        if (string != null && string.length() != 0) {
            inputOutputOptions.setFileName(string);
        }
    }

    public final void inputFromPrompt(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(112);
        inputOutputOptions.setPrompt(true);
        inputOutputOptions.setFormat(12);
    }

    public final void byOrderOrNameOption(InputOutputOptions inputOutputOptions) throws ParseException {
        int n;
        this.jj_consume_token(28);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                n = 1;
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                n = 2;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        inputOutputOptions.setColumnMatchingTechnique(n);
    }

    public final void noStripOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(96);
        inputOutputOptions.setNoStrip(true);
    }

    public final void columnList(InputOutputOptions inputOutputOptions) throws ParseException {
        Vector<String> vector = new Vector<String>();
        this.jj_consume_token(86);
        this.columnName(vector);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 148: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(148);
            this.columnName(vector);
        }
        this.jj_consume_token(117);
        inputOutputOptions.setColumnList(vector);
    }

    public final void columnName(Vector<String> vector) throws ParseException {
        this.jj_consume_token(164);
        vector.addElement(ParserUtils.stripQuotes(this.token.image));
    }

    public final void outputStatement() throws ParseException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        InputOutputOptions inputOutputOptions = new InputOutputOptions(this._connection);
        if (this.jj_2_7(2)) {
            int n;
            this.jj_consume_token(104);
            this.jj_consume_token(128);
            String string = this.filename();
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: 
                    case 30: 
                    case 37: 
                    case 46: 
                    case 54: 
                    case 57: 
                    case 58: 
                    case 61: 
                    case 66: 
                    case 115: 
                    case 135: {
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        break block19;
                    }
                }
                this.outputOption(inputOutputOptions);
            }
            this.ensureNoMoreTokensOnLine();
            if (inputOutputOptions.getFormat() == 0) {
                n = Preferences.getFileFormatCode(this._connection, "output_format");
                inputOutputOptions.setFormat(n);
            }
            if (string == null || string.length() == 0) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "OUTPUT statement filename is not valid"));
            } else {
                if (inputOutputOptions.getAppend() && (n = inputOutputOptions.getFormat()) != 1 && n != 2 && n != 4) {
                    this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Bad OUTPUT statement. APPEND is not compatible with the selected file format."));
                }
                if (inputOutputOptions.getVerbose() && (n = inputOutputOptions.getFormat()) != 1 && n != 2 && n != 4) {
                    this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Bad OUTPUT statement. VERBOSE is not compatible with the selected file format."));
                }
                if (inputOutputOptions.getEncoding() != null) {
                    if (!inputOutputOptions.getEncoding().equals(inputOutputOptions.getSystemEncoding()) && (n = inputOutputOptions.getFormat()) != 1) {
                        this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "EncodingSupportedForASCIIOnly"));
                    }
                } else {
                    inputOutputOptions.setEncoding(ParserUtils.getDefaultEncoding(this._connection));
                }
                if (inputOutputOptions.useByteOrderMarkSpecified) {
                    String string2;
                    if (inputOutputOptions.getFormat() != 1) {
                        this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "BOM_SUPPORTED_FOR_ASCII_ONLY"));
                    }
                    if (!((string2 = inputOutputOptions.getEncoding()) == null || string2.equals(inputOutputOptions.getSystemEncoding()) || string2.equalsIgnoreCase("utf-8") || string2.equalsIgnoreCase("utf8") || string2.equalsIgnoreCase("utf-16") || string2.equalsIgnoreCase("utf16") || string2.equalsIgnoreCase("utf-16be") || string2.equalsIgnoreCase("utf16be") || string2.equalsIgnoreCase("utf-16le") || string2.equalsIgnoreCase("utf16le"))) {
                        this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "BOM_SUPPORTED_FOR_UTF_ONLY"));
                    }
                }
                if (isql.ensureConnected(this._connection) && !isql.options.checkSyntaxOnly) {
                    inputOutputOptions.setFileName(string);
                    boolean bl = OutputStatement.execute((ISQLConnectionImpl)this._connection, inputOutputOptions, this._messages);
                    if (!bl) {
                        StringBuffer stringBuffer = new StringBuffer(128);
                        String string3 = System.getProperty("line.separator");
                        int n2 = this._messages.size();
                        for (int i = 0; i < n2; ++i) {
                            if (i > 0) {
                                stringBuffer.append(string3);
                            }
                            stringBuffer.append(this._messages.elementAt(i));
                        }
                        this.handleError(stringBuffer.toString());
                    }
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 104: {
                    String string;
                    String string4;
                    String string5;
                    this.jj_consume_token(104);
                    this.jj_consume_token(134);
                    Token token5 = this.jj_consume_token(180);
                    this.jj_consume_token(72);
                    Token token6 = this.jj_consume_token(164);
                    block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 51: {
                            this.jj_consume_token(51);
                            token = this.jj_consume_token(164);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 51: {
                                    this.jj_consume_token(51);
                                    token2 = this.jj_consume_token(164);
                                    break block6;
                                }
                            }
                            this.jj_la1[36] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                        }
                    }
                    block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 42: {
                            this.jj_consume_token(42);
                            this.jj_consume_token(125);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 98: {
                                    token3 = this.jj_consume_token(98);
                                    break block12;
                                }
                                case 97: {
                                    token4 = this.jj_consume_token(97);
                                    break block12;
                                }
                            }
                            this.jj_la1[38] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[39] = this.jj_gen;
                        }
                    }
                    if (token == null) {
                        string5 = null;
                        string4 = null;
                        string = ParserUtils.stripQuotes(token6.image);
                    } else if (token2 == null) {
                        string5 = null;
                        string4 = ParserUtils.stripQuotes(token6.image);
                        string = ParserUtils.stripQuotes(token.image);
                    } else {
                        string5 = ParserUtils.stripQuotes(token6.image);
                        string4 = ParserUtils.stripQuotes(token.image);
                        string = ParserUtils.stripQuotes(token2.image);
                    }
                    if (isql.options.checkSyntaxOnly) {
                        return;
                    }
                    if (!isql.ensureConnected(this._connection)) {
                        return;
                    }
                    boolean bl = token3 != null || token3 == null && token4 == null;
                    boolean bl2 = ODBCExporter.export((ISQLConnectionImpl)this._connection, null, ParserUtils.stripQuotes(token5.image), string5, string4, string, bl, this._messages);
                    if (bl2) break;
                    StringBuilder stringBuilder = new StringBuilder(128);
                    String string6 = System.getProperty("line.separator");
                    int n = this._messages.size();
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuilder.append(string6);
                        }
                        stringBuilder.append(this._messages.get(i));
                    }
                    this.handleError(stringBuilder.toString());
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void outputOption(InputOutputOptions inputOutputOptions) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 61: {
                this.formatOption(inputOutputOptions);
                break;
            }
            case 57: {
                this.escapeCharacterOption(inputOutputOptions);
                break;
            }
            case 46: {
                this.delimitedByOption(inputOutputOptions);
                break;
            }
            case 66: {
                this.hexadecimalOption(inputOutputOptions);
                break;
            }
            case 115: {
                this.quoteOption(inputOutputOptions);
                break;
            }
            case 37: {
                this.columnWidthsOption(inputOutputOptions);
                break;
            }
            case 16: {
                this.appendOption(inputOutputOptions);
                break;
            }
            case 135: {
                this.verboseOption(inputOutputOptions);
                break;
            }
            case 54: {
                this.encodingOption(inputOutputOptions);
                break;
            }
            case 58: {
                this.escapesOption(inputOutputOptions);
                break;
            }
            case 30: {
                this.byteOrderMarkOption(inputOutputOptions);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void hexadecimalOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(66);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                this.jj_consume_token(98);
                inputOutputOptions.setHexadecimal(1);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                inputOutputOptions.setHexadecimal(2);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                inputOutputOptions.setHexadecimal(3);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void appendOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(16);
        inputOutputOptions.setAppend(true);
    }

    public final void verboseOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(135);
        inputOutputOptions.setVerbose(true);
    }

    public final void formatOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(61);
        this.formatType(inputOutputOptions);
    }

    public final void formatType(InputOutputOptions inputOutputOptions) throws ParseException {
        String string = this.identifierOrString();
        int n = InputOutputOptions.getFormatCode(string = ParserUtils.stripQuotes(string));
        if (n != 0) {
            inputOutputOptions.setFormat(n);
        } else {
            this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Unknown file format \"{0}\"", string));
        }
    }

    public final void escapeCharacterOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(57);
        this.jj_consume_token(32);
        Token token = this.jj_consume_token(180);
        String string = ParserUtils.stripQuotes(token.image);
        if (string.length() != 0 && (string = this.unescape(string)).length() != 0) {
            inputOutputOptions.setEscapeCharacter(string.charAt(0));
        }
    }

    public final void escapesOption(InputOutputOptions inputOutputOptions) throws ParseException {
        Token token;
        this.jj_consume_token(58);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                token = this.jj_consume_token(98);
                break;
            }
            case 97: {
                token = this.jj_consume_token(97);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        inputOutputOptions.setEscapes(token.kind == 98);
    }

    public final void delimitedByOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(46);
        this.jj_consume_token(28);
        Token token = this.jj_consume_token(180);
        inputOutputOptions.setDelimiter(this.unescape(ParserUtils.stripQuotes(token.image)));
    }

    public final void quoteOption(InputOutputOptions inputOutputOptions) throws ParseException {
        Token token = null;
        this.jj_consume_token(115);
        Token token2 = this.jj_consume_token(180);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        String string = ParserUtils.stripQuotes(token2.image);
        if (string.length() != 0) {
            string = this.unescape(string);
        }
        inputOutputOptions.setQuote(string);
        if (token == null) {
            inputOutputOptions.setQuoteAll(false);
        } else {
            inputOutputOptions.setQuoteAll(true);
        }
    }

    public final void columnWidthsOption(InputOutputOptions inputOutputOptions) throws ParseException {
        this.jj_consume_token(37);
        this.jj_consume_token(136);
        this.jj_consume_token(86);
        this.columnWidth(inputOutputOptions);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 148: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(148);
            this.columnWidth(inputOutputOptions);
        }
        this.jj_consume_token(117);
    }

    public final void columnWidth(InputOutputOptions inputOutputOptions) throws ParseException {
        Token token = this.jj_consume_token(157);
        try {
            int n = Integer.parseInt(token.image);
            inputOutputOptions.addColumnWidth(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Invalid column width: {0}", token.image));
        }
    }

    public final void parametersStatement() throws ParseException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.jj_consume_token(109);
        this.parametersParm(arrayList);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 148: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(148);
            this.parametersParm(arrayList);
        }
        if (this._parms == null) {
            this._parms = new Vector(arrayList.size() * 2);
            this._parms.setSize(arrayList.size() * 2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.setParameterName(arrayList.get(n), n);
        }
        if (this._parms != null) {
            boolean bl = false;
            int n2 = this._parms.size();
            if (n2 != 0) {
                for (n = n2 - 2; n >= 0; n -= 2) {
                    if (this._parms.elementAt(n) != null) continue;
                    this._parms.removeElementAt(n + 1);
                    this._parms.removeElementAt(n);
                    bl = true;
                }
                if (bl) {
                    if (this._calledFrom == null) {
                        this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Too many parameters supplied to command file \"{0}\"", this._fileName.getName()));
                    } else {
                        this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "TooManyParametersWithCaller", this._fileName.getName(), this._calledFrom));
                    }
                }
            }
        }
    }

    public final void parametersParm(ArrayList<String> arrayList) throws ParseException {
        this.jj_consume_token(164);
        arrayList.add(this.token.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readStatement() throws ParseException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        Token token = null;
        Vector<String> vector = new Vector<String>();
        String string3 = null;
        this.jj_consume_token(116);
        if (this.jj_2_8(2)) {
            this.jj_consume_token(54);
            string3 = this.identifierOrString();
        }
        string = this.filename();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 164: 
            case 180: 
            case 185: {
                this.readParameterList(vector);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 139: {
                        token = this.jj_consume_token(139);
                        break;
                    }
                    case 140: {
                        token = this.jj_consume_token(140);
                        break;
                    }
                    case 141: {
                        token = this.jj_consume_token(141);
                        break;
                    }
                    case 142: {
                        token = this.jj_consume_token(142);
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                string2 = this.filename();
                if (string == null) break;
                bl = token.kind == 140 || token.kind == 142;
                bl2 = token.kind == 141 || token.kind == 142;
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        TerminatedFileReader terminatedFileReader = null;
        File file = null;
        this.ensureNoMoreTokensOnLine();
        this.flushLineBuffer();
        string = ParserUtils.stripQuotes(string);
        file = ParserUtils.searchForFile(string, this._fileName);
        if (file == null) {
            this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CouldNotFindFile", string));
        }
        if (string3 != null) {
            String string4 = ParserUtils.getCanonicalEncodingName(string3 = ParserUtils.stripQuotes(string3));
            if (string4 != null) {
                string3 = string4;
            } else {
                this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "EncodingNotSupported", string3));
            }
        } else {
            string3 = ParserUtils.getDefaultEncoding(this._connection);
        }
        if (file != null) {
            try {
                terminatedFileReader = new TerminatedFileReader(file, string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (terminatedFileReader != null) {
            this.log(ISQLResource.getFormattedString(GeneralResources.getName(), "\n--\n-- Start of {0}\n--", string));
            try {
                boolean bl3;
                ASEParser aSEParser = new ASEParser(terminatedFileReader);
                aSEParser.setResultsProcessor(this._resultsProcessor);
                aSEParser.enableDebuggingOutput();
                aSEParser._parms = vector;
                aSEParser._isIncludedFile = true;
                aSEParser._parentParser = this;
                aSEParser._fileName = file;
                aSEParser._calledFrom = this._fileName != null ? ISQLResource.getFormattedString(ErrorMessages.getName(), "FileLine", this._fileName.getName(), Integer.toString(this.token.beginLine)) : ISQLResource.getFormattedString(ErrorMessages.getName(), "Line {0}, column {1}", Integer.toString(this.token.beginLine), Integer.toString(this.token.beginColumn));
                if (string2 == null && this._redirectionFile != null) {
                    string2 = this._redirectionFile;
                    bl2 = this._redirectionWithErrors;
                    bl = true;
                }
                if (string2 != null) {
                    aSEParser._redirectionFile = string2;
                    aSEParser._redirectionWithErrors = bl2;
                    if (!bl) {
                        File file2 = new File(string2);
                        if (file2.exists()) {
                            file2.delete();
                        }
                        file2 = null;
                    }
                    if (bl2) {
                        this._messages.add(ISQLResource.getFormattedString(GeneralResources.getName(), "\n--\n-- Start of {0}\n--", string));
                        this.writeMessages2(string2, bl, bl2, false);
                    }
                }
                long l = (bl3 = this.shouldMeasureTime()) ? System.currentTimeMillis() : 0L;
                this._connection = aSEParser.isqlStatementList(this._connection, this._silent);
                if (bl3) {
                    long l2 = System.currentTimeMillis();
                    this.displayElapsedTime(l2 - l, isql.getIO(this._connection));
                }
            }
            catch (ParseException parseException) {
                this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Syntax error in included file \"{0}\"", string));
            }
            finally {
                try {
                    terminatedFileReader.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    terminatedFileReader = null;
                }
            }
            this.log(ISQLResource.getFormattedString(GeneralResources.getName(), "\n--\n-- End of {0}\n--", string));
            if (string2 != null && bl2) {
                this._messages.removeAllElements();
                this._messages.add(ISQLResource.getFormattedString(GeneralResources.getName(), "\n--\n-- End of {0}\n--", string));
                this.writeMessages2(string2, true, bl2, false);
            }
        }
    }

    public final String readStatementEncodingOption() throws ParseException {
        String string = null;
        this.jj_consume_token(54);
        string = this.identifierOrString();
        return string;
    }

    public final void readParameterList(Vector<String> vector) throws ParseException {
        String string = this.readParameter();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 164: 
            case 180: 
            case 185: {
                this.readParameterList(vector);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        vector.insertElementAt(null, 0);
        vector.insertElementAt(string, 1);
    }

    public final String readParameter() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 180: {
                this.jj_consume_token(180);
                return this.unparameterize(this.token.image);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 164: {
                        this.jj_consume_token(164);
                        break;
                    }
                    case 157: {
                        this.jj_consume_token(157);
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: {
                        this.keyword();
                        break;
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String string = this.unparameterize(this.token.image);
                if (string.charAt(0) == '[') {
                    return string.substring(1, string.length() - 1);
                }
                return string;
            }
            case 185: {
                this.jj_consume_token(185);
                return this.token.image.substring(1, this.token.image.length() - 1);
            }
        }
        this.jj_la1[52] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void setStatement() throws ParseException {
        this.jj_consume_token(118);
        Token token = this.getToken(1);
        if (token.kind == 73) {
            String string;
            token = this.getNextToken();
            token = this.getNextToken();
            int n = this.isISQLOption(token.image);
            if (n == -1) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
            }
            Token token2 = this.getNextToken();
            switch (token2.kind) {
                case 164: {
                    string = token2.image;
                    break;
                }
                case 175: 
                case 180: {
                    string = ParserUtils.stripQuotes(token2.image);
                    string = this.unparameterize(string);
                    break;
                }
                default: {
                    this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
                    return;
                }
            }
            this.ensureNoMoreTokensOnLine();
            this.do_setISQLOption(true, token, string);
            return;
        }
        while (true) {
            token = this.getToken(1);
            if (token.kind == 12 || token.kind == 0) break;
            if (token.kind == 184 || token.kind == 180) {
                token.image = this.unparameterize(token.image);
            }
            this.accumulateLine(token);
            this.getNextToken();
        }
        this.flushLineBuffer();
        this.executeSQL(this._previousLine.toString());
    }

    boolean stringToBoolean(String string) throws ParseException {
        boolean bl = string.equalsIgnoreCase("ON") ? true : (string.equalsIgnoreCase("OFF") ? false : Boolean.valueOf(string));
        return bl;
    }

    void do_setISQLOption(boolean bl, Token token, String string) throws ParseException {
        if (!isql.ensureConnected(this._connection)) {
            return;
        }
        string = string != null ? (token.kind == 77 ? ParserUtils.stripQuotes(string) : this.unescape(ParserUtils.stripQuotes(string))) : "";
        switch (token.kind) {
            case 94: {
                Preferences.setPluginStringPreference((ISQLConnectionImpl)this._connection, false, "nulls", string);
                break;
            }
            case 22: {
                if (Preferences.isPluginPreferenceLocked((ISQLConnectionImpl)this._connection, "autoCommit")) {
                    this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANT_CHANGE_READ_ONLY_OPTION", token.image));
                    return;
                }
                Preferences.setPluginBooleanPreference((ISQLConnectionImpl)this._connection, bl, "autoCommit", this.stringToBoolean(string));
                break;
            }
            case 38: {
                if (Preferences.isPluginPreferenceLocked((ISQLConnectionImpl)this._connection, "commitOnExit")) {
                    this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANT_CHANGE_READ_ONLY_OPTION", token.image));
                    return;
                }
                Preferences.setPluginBooleanPreference((ISQLConnectionImpl)this._connection, bl, "commitOnExit", this.stringToBoolean(string));
                break;
            }
            case 53: {
                Preferences.setBooleanOption(this._connection, "echo", this.stringToBoolean(string), bl);
                break;
            }
            case 71: {
                if (InputOutputOptions.getFormatCode(string) != 0) {
                    Preferences.setStringOption(this._connection, "input_format", string, bl);
                    break;
                }
                this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Unknown file format \"{0}\"", string));
                break;
            }
            case 105: {
                if (InputOutputOptions.getFormatCode(string) != 0) {
                    Preferences.setStringOption(this._connection, "output_format", string, bl);
                    break;
                }
                this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Unknown file format \"{0}\"", string));
                break;
            }
            case 106: {
                this.setOutputLengthOption(string, bl);
                break;
            }
            case 107: {
                if (string == null || string.length() == 0) {
                    Preferences.setStringOption(this._connection, "output_nulls", "", bl);
                    break;
                }
                Preferences.setStringOption(this._connection, "output_nulls", string, bl);
                break;
            }
            case 77: {
                if (string == null || string.length() == 0) {
                    isql.stopLogging(this._connection);
                } else {
                    this.flushLineBuffer();
                    isql.startLogging(this._connection, string);
                }
                Preferences.setStringOption(this._connection, "isql_log", string == null ? "" : string, bl);
                break;
            }
            case 79: {
                this.setMessagesOption(string, bl);
                break;
            }
            case 74: {
                this.setCommandTimingOption(string, bl);
                break;
            }
            case 75: {
                this.setEscapeCharacterOption(string, bl);
                break;
            }
            case 76: {
                this.setFieldSeparatorOption(string, bl);
                break;
            }
            case 80: {
                this.setPlanOption(string, bl);
                break;
            }
            case 78: {
                this.setMaximumDisplayedRowsOption(string, bl);
                break;
            }
            case 82: {
                this.setShowMultipleResultSetsOption(string, bl);
                break;
            }
            case 81: {
                this.setPrintResultSetToConsoleOption(string, bl);
                break;
            }
            case 83: {
                this.setQuoteOption(string, bl);
                break;
            }
            case 99: {
                String string2 = string.equalsIgnoreCase("Continue") ? "Continue" : (string.equalsIgnoreCase("Stop") ? "Stop" : (string.equalsIgnoreCase("Exit") ? "Exit" : (string.equalsIgnoreCase("Notify_continue") ? "Notify_continue" : (string.equalsIgnoreCase("Notify_stop") ? "Notify_stop" : (string.equalsIgnoreCase("Notify_exit") ? "Notify_exit" : "Prompt")))));
                Preferences.setStringOption(this._connection, "on_error", string2, bl);
                break;
            }
            case 27: {
                Preferences.setBooleanOption(this._connection, "bell", this.stringToBoolean(string), bl);
                break;
            }
            case 23: {
                Preferences.setBooleanOption(this._connection, "auto_refetch", this.stringToBoolean(string), bl);
                break;
            }
            case 122: {
                break;
            }
            case 130: {
                this.setTruncationLengthOption(string, bl);
                break;
            }
            case 47: {
                if (bl) {
                    if (string.length() == 0) {
                        ParserUtils.setDefaultEncoding(this._connection, null);
                        break;
                    }
                    String string3 = ParserUtils.getCanonicalEncodingName(string);
                    if (string3 != null) {
                        ParserUtils.setDefaultEncoding(this._connection, string3);
                        break;
                    }
                    this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "EncodingNotSupported", string));
                    break;
                }
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "CannotSetOptionPermanently"));
                break;
            }
        }
    }

    void setOutputLengthOption(String string, boolean bl) throws ParseException {
        int n = 0;
        if (string == null || string.length() == 0) {
            Preferences.setIntOption(this._connection, "output_length", 0, bl);
        } else {
            boolean bl2 = false;
            try {
                n = Integer.parseInt(string);
                bl2 = n >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bl2) {
                Preferences.setIntOption(this._connection, "output_length", n, bl);
            } else {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "OUTPUT_LENGTH must be a non-negative number."));
            }
        }
    }

    void setTruncationLengthOption(String string, boolean bl) throws ParseException {
        int n = 500;
        if (string != null) {
            string = ParserUtils.stripQuotes(string);
        }
        if (string == null || string.length() == 0) {
            string = "256";
        }
        try {
            n = Integer.parseInt(string);
            Preferences.setPluginIntPreference((ISQLConnectionImpl)this._connection, bl, "truncationLength", n);
        }
        catch (NumberFormatException numberFormatException) {
            this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "\"{0}\" is not a valid value for the TRUNCATION_LENGTH option.", string));
        }
        Preferences.setPluginIntPreference((ISQLConnectionImpl)this._connection, bl, "truncationLength", n);
    }

    void setMessagesOption(String string, boolean bl) throws ParseException {
        int n;
        if (string == null || string.length() == 0) {
            n = 3;
        } else {
            n = 3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("ASYNC")) {
                    n |= 1;
                    continue;
                }
                if (string2.equalsIgnoreCase("-ASYNC")) {
                    n &= 0xFFFFFFFE;
                    continue;
                }
                if (string2.equalsIgnoreCase("ERRORS")) {
                    n |= 2;
                    continue;
                }
                if (string2.equalsIgnoreCase("-ERRORS")) {
                    n &= 0xFFFFFFFD;
                    continue;
                }
                if (string2.startsWith("Dbg_")) {
                    Dbg.setEnabled((String)string2.substring(4), (boolean)true);
                    continue;
                }
                if (string2.startsWith("-Dbg_")) {
                    Dbg.setEnabled((String)string2.substring(5), (boolean)false);
                    continue;
                }
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
            }
        }
        Preferences.setIntOption(this._connection, "messages", n, bl);
    }

    void setCommandTimingOption(String string, boolean bl) throws ParseException {
        boolean bl2 = string == null || string.length() == 0 ? true : this.stringToBoolean(string);
        Preferences.setBooleanOption(this._connection, "ISQL_command_timing", bl2, bl);
    }

    void setEscapeCharacterOption(String string, boolean bl) throws ParseException {
        if (string == null || string.length() == 0) {
            string = "\\";
        }
        Preferences.setStringOption(this._connection, "ISQL_escape_character", string, bl);
    }

    void setQuoteOption(String string, boolean bl) throws ParseException {
        if (string == null || string.length() == 0) {
            string = "'";
        }
        Preferences.setStringOption(this._connection, "ISQL_quote", string, bl);
    }

    void setFieldSeparatorOption(String string, boolean bl) throws ParseException {
        if (string == null || string.length() == 0) {
            string = ",";
        }
        Preferences.setStringOption(this._connection, "ISQL_field_separator", string, bl);
    }

    void setPlanOption(String string, boolean bl) throws ParseException {
    }

    void setMaximumDisplayedRowsOption(String string, boolean bl) throws ParseException {
        int n = 500;
        if (string != null) {
            string = ParserUtils.stripQuotes(string);
        }
        if (string == null || string.length() == 0) {
            string = "500";
        }
        if (string.equalsIgnoreCase("all")) {
            n = Integer.MAX_VALUE;
        } else {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
            }
        }
        Preferences.setPluginIntPreference((ISQLConnectionImpl)this._connection, bl, "maximumDisplayedRows", n);
        if (this._connection != null) {
            this._connection.setMaximumRowCount(n);
        }
    }

    void setShowMultipleResultSetsOption(String string, boolean bl) throws ParseException {
        boolean bl2 = true;
        if (string != null && string.length() != 0) {
            string = ParserUtils.stripQuotes(string);
        }
        if (string == null) {
            string = "0";
        }
        bl2 = string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1");
        Preferences.setPluginBooleanPreference((ISQLConnectionImpl)this._connection, bl, "showMultipleResultSets", bl2);
    }

    void setPrintResultSetToConsoleOption(String string, boolean bl) throws ParseException {
        if (string != null && string.length() != 0) {
            if ((string = ParserUtils.stripQuotes(string)).equalsIgnoreCase("ALL")) {
                Preferences.setIntOption(null, "printResultSetToConsole", 2, bl);
            } else if (string.equalsIgnoreCase("NONE")) {
                Preferences.setIntOption(null, "printResultSetToConsole", 1, bl);
            } else if (string.equalsIgnoreCase("LAST")) {
                Preferences.setIntOption(null, "printResultSetToConsole", 0, bl);
            } else {
                this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "Syntax error"));
            }
        } else {
            Preferences.setIntOption(null, "printResultSetToConsole", 0, bl);
        }
    }

    void do_setSQLOption(String string, String string2, boolean bl) throws ParseException {
        if (!isql.ensureConnected(this._connection)) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this._connection.isConnected()) {
            boolean bl2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SET ");
            if (bl) {
                stringBuffer.append("TEMPORARY ");
            }
            stringBuffer.append("OPTION ");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            SQLException[] sQLExceptionArray = new SQLException[]{null};
            String[] stringArray = new String[]{null};
            SQLWarning[] sQLWarningArray = new SQLWarning[]{null};
            if (isql.options.checkSyntaxOnly) {
                bl2 = this._connection.checkSyntax(stringBuffer.toString(), sQLExceptionArray, stringArray);
            } else {
                boolean bl3 = this.shouldMeasureTime();
                long l = bl3 ? System.currentTimeMillis() : 0L;
                bl2 = this._connection.execute(stringBuffer.toString(), false, false, 1, sQLWarningArray, sQLExceptionArray, stringArray, null);
                if (bl2 && bl3) {
                    long l2 = System.currentTimeMillis();
                    this.displayElapsedTime(l2 - l, isql.getIO(this._connection));
                }
            }
            if (bl2) {
                SQLWarning sQLWarning = sQLWarningArray[0];
                if (sQLWarning != null) {
                    boolean bl4 = true;
                    do {
                        if (sQLWarning.getErrorCode() != 120 || this.isDatabaseOption(string)) continue;
                        bl4 = false;
                        break;
                    } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
                    if (bl4) {
                        StringBuffer stringBuffer2 = new StringBuffer(256);
                        sQLWarning = sQLWarningArray[0];
                        do {
                            stringBuffer2.append(sQLWarning.getLocalizedMessage());
                            stringBuffer2.append(System.getProperty("line.separator"));
                        } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
                        isql.getIO(this._connection).writeln(stringBuffer2.toString(), 0);
                    }
                }
            } else {
                this.handleError(stringArray[0], sQLExceptionArray[0]);
            }
        }
    }

    boolean isDatabaseOption(String string) throws ParseException {
        boolean bl = false;
        OptionInfo.Option[] optionArray = OptionInfo.getOptions();
        int n = optionArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(optionArray[i].name) || optionArray[i].type != 1 && optionArray[i].type != 4) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public final Token isqlOptionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token;
    }

    public final void systemStatement() throws ParseException {
        int n;
        this.jj_consume_token(124);
        String string = this.identifierOrString();
        this.flushLineBuffer();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        String string2 = System.getenv("comspec");
        if (string2 != null && string2.length() > 0 && (n = string2.length()) >= 2 && string2.charAt(0) == '\"' && string2.charAt(n - 1) == '\"') {
            string2 = string2.substring(1, n - 1);
        }
        if ((string2 == null || string2.length() == 0) && System.getProperty("os.name").indexOf("Windows") != -1) {
            string2 = "command.com /c";
        }
        if (string2 != null && string2.length() != 0) {
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        stringBuffer.append(ParserUtils.stripQuotes(string));
        if (!isql.options.checkSyntaxOnly) {
            try {
                Process process = Runtime.getRuntime().exec(stringBuffer.toString());
                this.waitForProcessToComplete(process);
                process = null;
            }
            catch (IOException iOException) {
                this.handleError(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not run command: {0}", iOException.getMessage()));
            }
        }
    }

    void waitForProcessToComplete(Process process) throws ParseException {
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while (true) {
            try {
                String string;
                while (bufferedReader.ready() && (string = bufferedReader.readLine()) != null) {
                    isql.getIO(this._connection).writeln(string, 0);
                }
                while (bufferedReader2.ready() && (string = bufferedReader2.readLine()) != null) {
                    isql.getIO(this._connection).writeln(string, 0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    public final void startStatement() throws ParseException {
        this.jj_consume_token(120);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                this.startLoggingOption();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.startEverythingElse();
            }
        }
    }

    public final void startLoggingOption() throws ParseException {
        this.jj_consume_token(90);
        String string = this.filename();
        this.ensureNoMoreTokensOnLine();
        this.flushLineBuffer();
        isql.startLogging(this._connection, string);
    }

    void startEverythingElse() throws ParseException {
        while (true) {
            Token token = this.getToken(1);
            if (token.kind == 12 || token.kind == 0) break;
            this.accumulateLine(token);
            this.getNextToken();
        }
        this.executeSQL(this._previousLine.toString());
    }

    public final void stopStatement() throws ParseException {
        this.jj_consume_token(123);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                this.stopLoggingOption();
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.stopEverythingElse();
            }
        }
    }

    void stopEverythingElse() throws ParseException {
        while (true) {
            Token token = this.getToken(1);
            if (token.kind == 12 || token.kind == 0) break;
            this.accumulateLine(token);
            this.getNextToken();
        }
        this.executeSQL(this._previousLine.toString());
    }

    public final void stopLoggingOption() throws ParseException {
        this.jj_consume_token(90);
        this.ensureNoMoreTokensOnLine();
        isql.stopLogging(this._connection);
    }

    public final void useStatement() throws ParseException {
        this.jj_consume_token(132);
        String string = this.identifierOrString();
        String string2 = ParserUtils.stripQuotes(string);
        this.flushLineBuffer();
        this.executeSQL("USE " + string);
        isql.notifyDatabaseSelected(this._connection, string2);
    }

    public final void createDatabaseStatement() throws ParseException {
        this.jj_consume_token(42);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        this.jj_consume_token(43);
        this.identifierOrString();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                this.jj_consume_token(98);
                if (this.jj_2_9(2)) {
                    this.jj_consume_token(44);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 164: 
                        case 180: 
                        case 185: {
                            this.identifierOrString();
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        this.identifierOrStringOrNumber();
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                    }
                }
                block44: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 148: {
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(148);
                    this.identifierOrString();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 56: {
                            this.jj_consume_token(56);
                            this.identifierOrStringOrNumber();
                            continue block44;
                        }
                    }
                    this.jj_la1[60] = this.jj_gen;
                }
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        block18 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 89: {
                this.jj_consume_token(89);
                this.jj_consume_token(98);
                this.identifierOrString();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        this.identifierOrStringOrNumber();
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                    }
                }
                block45: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 148: {
                            break;
                        }
                        default: {
                            this.jj_la1[63] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.jj_consume_token(148);
                    this.identifierOrString();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 56: {
                            this.jj_consume_token(56);
                            this.identifierOrStringOrNumber();
                            continue block45;
                        }
                    }
                    this.jj_la1[64] = this.jj_gen;
                }
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        block30 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 137: {
                this.jj_consume_token(137);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 108: {
                        this.jj_consume_token(108);
                        break block30;
                    }
                    case 45: {
                        this.jj_consume_token(45);
                        this.jj_consume_token(56);
                        this.identifierOrString();
                        break block30;
                    }
                }
                this.jj_la1[66] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        block37 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 88: {
                        this.jj_consume_token(88);
                        break block37;
                    }
                    case 113: {
                        this.jj_consume_token(113);
                        break block37;
                    }
                }
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        this.flushLineBuffer();
        String string = this._previousLineEnd == -1 ? this._previousLine.toString() : this._previousLine.substring(0, this._previousLineEnd);
        this.executeSQL(string);
        isql.notifyDatabaseListChanged(this._connection);
    }

    public final void dropDatabaseStatement() throws ParseException {
        this.jj_consume_token(52);
        this.jj_consume_token(43);
        this.identifierOrString();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 148: {
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(148);
            this.identifierOrString();
        }
        this.flushLineBuffer();
        String string = this._previousLineEnd == -1 ? this._previousLine.toString() : this._previousLine.substring(0, this._previousLineEnd);
        this.executeSQL(string);
        isql.notifyDatabaseListChanged(this._connection);
    }

    public final void describeStatement() throws ParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Token token = null;
        if (this.jj_2_21(Integer.MAX_VALUE)) {
            this.jj_consume_token(48);
            this.jj_consume_token(41);
            this.ensureNoMoreTokensOnLine();
            if (isql.options.checkSyntaxOnly) {
                return;
            }
            boolean bl = this._connection.describe(null, null, null, DescribeOption.CONNECTION, this.moreCommandsPending() ? 0 : 2, this._resultsProcessor);
            if (!bl) {
                this.handleErrorOrWarning(ISQLResource.getISQLString(ErrorMessages.getName(), "Could not describe connection"), this.getLastStatement(), null, true, true);
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 48: {
                    if (this.jj_2_18(Integer.MAX_VALUE)) {
                        this.jj_consume_token(48);
                        token = this.jj_consume_token(69);
                        this.jj_consume_token(60);
                        this.jj_consume_token(125);
                        if (this.jj_2_11(2)) {
                            if (this.jj_2_10(2)) {
                                string = this.identifierOrString();
                                this.jj_consume_token(51);
                            }
                            string2 = this.identifierOrString();
                            this.jj_consume_token(51);
                        }
                        string3 = this.identifierOrString();
                    } else if (this.jj_2_19(Integer.MAX_VALUE)) {
                        this.jj_consume_token(48);
                        token = this.jj_consume_token(125);
                        if (this.jj_2_13(2)) {
                            if (this.jj_2_12(2)) {
                                string = this.identifierOrString();
                                this.jj_consume_token(51);
                            }
                            string2 = this.identifierOrString();
                            this.jj_consume_token(51);
                        }
                        string3 = this.identifierOrString();
                    } else if (this.jj_2_20(Integer.MAX_VALUE)) {
                        this.jj_consume_token(48);
                        token = this.jj_consume_token(111);
                        if (this.jj_2_15(2)) {
                            if (this.jj_2_14(2)) {
                                string = this.identifierOrString();
                                this.jj_consume_token(51);
                            }
                            string2 = this.identifierOrString();
                            this.jj_consume_token(51);
                        }
                        string3 = this.identifierOrString();
                    } else {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 48: {
                                this.jj_consume_token(48);
                                if (this.jj_2_17(2)) {
                                    if (this.jj_2_16(2)) {
                                        string = this.identifierOrString();
                                        this.jj_consume_token(51);
                                    }
                                    string2 = this.identifierOrString();
                                    this.jj_consume_token(51);
                                }
                                string3 = this.identifierOrString();
                                break;
                            }
                            default: {
                                this.jj_la1[71] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    this.ensureNoMoreTokensOnLine();
                    DescribeOption describeOption = token == null ? DescribeOption.ANYTHING : (token.kind == 125 ? DescribeOption.TABLE : (token.kind == 69 ? DescribeOption.INDEX : DescribeOption.PROCEDURE));
                    StringBuffer stringBuffer = new StringBuffer(64);
                    if (string != null && (string = ParserUtils.stripQuotes(string)).length() > 0) {
                        stringBuffer.append(string);
                        stringBuffer.append(".");
                    }
                    if (string2 != null && (string2 = ParserUtils.stripQuotes(string2)).length() > 0) {
                        stringBuffer.append(string2);
                        stringBuffer.append(".");
                    }
                    if (string3 != null) {
                        if ((string3 = ParserUtils.stripQuotes(string3)).length() == 0) {
                            this.handleError(ISQLResource.getISQLString(ErrorMessages.getName(), "MissingObjectName"));
                        }
                        stringBuffer.append(string3);
                    }
                    if (isql.options.checkSyntaxOnly) {
                        return;
                    }
                    boolean bl = this._connection.describe(string, string2, string3, describeOption, this.moreCommandsPending() ? 0 : 2, this._resultsProcessor);
                    if (bl) break;
                    this.handleErrorOrWarning(ISQLResource.getFormattedString(ErrorMessages.getName(), "CouldNotFindDBObject", stringBuffer.toString()), this.getLastStatement(), null, true, true);
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_3();
        this.jj_save(2, n);
        return bl;
    }

    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_4();
        this.jj_save(3, n);
        return bl;
    }

    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_5();
        this.jj_save(4, n);
        return bl;
    }

    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_6();
        this.jj_save(5, n);
        return bl;
    }

    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_7();
        this.jj_save(6, n);
        return bl;
    }

    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_8();
        this.jj_save(7, n);
        return bl;
    }

    private final boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_9();
        this.jj_save(8, n);
        return bl;
    }

    private final boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_10();
        this.jj_save(9, n);
        return bl;
    }

    private final boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_11();
        this.jj_save(10, n);
        return bl;
    }

    private final boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_12();
        this.jj_save(11, n);
        return bl;
    }

    private final boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_13();
        this.jj_save(12, n);
        return bl;
    }

    private final boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_14();
        this.jj_save(13, n);
        return bl;
    }

    private final boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_15();
        this.jj_save(14, n);
        return bl;
    }

    private final boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_16();
        this.jj_save(15, n);
        return bl;
    }

    private final boolean jj_2_17(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_17();
        this.jj_save(16, n);
        return bl;
    }

    private final boolean jj_2_18(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_18();
        this.jj_save(17, n);
        return bl;
    }

    private final boolean jj_2_19(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_19();
        this.jj_save(18, n);
        return bl;
    }

    private final boolean jj_2_20(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_20();
        this.jj_save(19, n);
        return bl;
    }

    private final boolean jj_2_21(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_21();
        this.jj_save(20, n);
        return bl;
    }

    private final boolean jj_3R_209() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        Token token = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = token;
            if (this.jj_3R_66()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(104)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(128)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_208() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_207() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_206() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_205() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_204() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_203() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_202() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_201() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_200() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_199() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_198() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_197() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_196() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_195() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_194() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_193() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_192() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_191() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_190() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_189() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_188() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_187() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_186() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_185() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_184() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_183() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_182() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_181() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_180() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_179() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_178() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(132)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_177() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_176() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_175() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_108() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_174() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_173() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_172() {
        if (this.jj_scan_token(145)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_171() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_170() {
        if (this.jj_scan_token(143)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_169() {
        if (this.jj_scan_token(146)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_168() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_167() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_166() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_165() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_164() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_163() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_162() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_161() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_160() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_159() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_158() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_157() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_156() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_155() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_154() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_153() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_152() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_151() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_150() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_149() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_148() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_147() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_146() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_3R_80()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_145() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_144() {
        if (this.jj_scan_token(147)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_143() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_142() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_141() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_140() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_139() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_138() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_137() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_136() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_135() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_134() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        Token token;
        block3: {
            if (this.jj_scan_token(70)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_65()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_133() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        this.jj_la = 0;
        this.jj_scanpos = this.jj_lastpos;
        return false;
    }

    private final boolean jj_3R_132() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = token;
            if (this.jj_3R_132()) {
                this.jj_scanpos = token;
                if (this.jj_3R_133()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_134()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_135()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_136()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_137()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_138()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_139()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_140()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_141()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_142()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_143()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_144()) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_3R_145()) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_3R_146()) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_3R_147()) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_3R_148()) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_3R_149()) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_3R_150()) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_3R_151()) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_3R_152()) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_3R_153()) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_3R_154()) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_3R_155()) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_3R_156()) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_3R_157()) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_3R_158()) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_3R_159()) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_3R_160()) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_3R_161()) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_3R_162()) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_3R_163()) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_3R_164()) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_3R_165()) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_3R_166()) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_3R_167()) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_3R_168()) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_3R_169()) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_3R_170()) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_3R_171()) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_3R_172()) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_3R_173()) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_3R_174()) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_3R_175()) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_3R_176()) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_3R_177()) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_3R_178()) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_3R_179()) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_3R_180()) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_3R_181()) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_3R_182()) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_3R_183()) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_3R_184()) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_3R_185()) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_3R_186()) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_3R_187()) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_3R_188()) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_3R_189()) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_3R_190()) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_3R_191()) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_3R_192()) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_3R_193()) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_3R_194()) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_3R_195()) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_3R_196()) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_3R_197()) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_3R_198()) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_3R_199()) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_3R_200()) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_3R_201()) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_3R_202()) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_3R_203()) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_3R_204()) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_3R_205()) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_206()) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_207()) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_208()) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_209()) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_210()) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_211()) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_212()) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_213()) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_214()) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_215()) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_216()) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_217()) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_218()) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_219()) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_220()) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_221()) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_222()) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_223()) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_224()) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_225()) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_226()) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_227()) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_228()) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_229()) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_230()) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_231()) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_232()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_233()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_234()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_235()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_236()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_237()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_238()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_239()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_240()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_241()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_242()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_243()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_244()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_245()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_246()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_247()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_248()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_249()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_3R_250()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_3R_251()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_3R_252()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_3R_253()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                    return false;
                                                                                                                }
                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                return false;
                                                                                                            }
                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                            return false;
                                                                                                        }
                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                        return false;
                                                                                                    }
                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                    return false;
                                                                                                }
                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                return false;
                                                                                            }
                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                            return false;
                                                                                        }
                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                        return false;
                                                                                    }
                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                    return false;
                                                                                }
                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                return false;
                                                                            }
                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                            return false;
                                                                        }
                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_131() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_105() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_3R_82()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(123)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = token;
            if (this.jj_3R_71()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_255() {
        if (this.jj_3R_257()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_257() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_104() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_256() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_254() {
        if (this.jj_3R_256()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_254()) {
            this.jj_scanpos = token;
            if (this.jj_3R_255()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_64()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        this.jj_la = 0;
        this.jj_scanpos = this.jj_lastpos;
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_3R_81()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(120)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_68()) {
            this.jj_scanpos = token;
            if (this.jj_3R_69()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_101() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(185)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_3R_72()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_16() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(164)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_17() {
        Token token = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(180)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = token;
            if (this.jj_3R_53()) {
                this.jj_scanpos = token;
                if (this.jj_3R_54()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_55()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_15() {
        Token token = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_20() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(111)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(114)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        if (this.jj_scan_token(134)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(111)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        Token token = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_19() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(125)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_114() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = token;
            if (this.jj_3R_79()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_scan_token(157)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(125)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        Token token = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_18() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(125)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_3R_114()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_3R_113()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = token;
            if (this.jj_3R_61()) {
                this.jj_scanpos = token;
                if (this.jj_3R_62()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_3R_112()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_3R_111()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_3R_110()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_3R_109()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_3R_107()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_3R_106()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(104)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(134)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        if (this.jj_3R_105()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        if (this.jj_3R_104()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_3R_103()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_3R_102()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = token;
            if (this.jj_3R_86()) {
                this.jj_scanpos = token;
                if (this.jj_3R_87()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_88()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_89()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_90()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_91()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_92()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_93()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_94()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_95()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_96()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_97()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_98()) {
                                                                return true;
                                                            }
                                                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_101()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_73()) {
            this.jj_scanpos = token;
            if (this.jj_3R_74()) {
                this.jj_scanpos = token;
                if (this.jj_3R_75()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_76()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_21() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = token;
            if (this.jj_3R_58()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(0)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_3R_100()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_253() {
        if (this.jj_scan_token(156)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(164)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_252() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_251() {
        if (this.jj_scan_token(154)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = token;
            if (this.jj_3R_84()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_3R_99()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_250() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_130() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_129() {
        if (this.jj_scan_token(123)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_249() {
        if (this.jj_scan_token(152)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_128() {
        if (this.jj_scan_token(120)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_127() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_126() {
        if (this.jj_scan_token(116)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_125() {
        if (this.jj_scan_token(114)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_124() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_123() {
        if (this.jj_scan_token(104)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_248() {
        if (this.jj_scan_token(151)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_122() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_31()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_121() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_30()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_120() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_119() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_118() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(142)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_117() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(141)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        Token token = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = token;
            if (this.jj_3_5()) {
                this.jj_scanpos = token;
                if (this.jj_3_6()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_247() {
        if (this.jj_scan_token(150)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_116() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(140)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_3R_77()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = token;
            if (this.jj_3R_116()) {
                this.jj_scanpos = token;
                if (this.jj_3R_117()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_118()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_119()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_120()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_121()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_122()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_123()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_124()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_125()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_126()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_127()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_128()) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_3R_129()) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_3R_130()) {
                                                                        return true;
                                                                    }
                                                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_115() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = token;
            if (this.jj_3R_49()) {
                this.jj_scanpos = token;
                if (this.jj_3R_50()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_51()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_22() {
        if (this.jj_3R_45()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_246() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_21() {
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_20() {
        if (this.jj_3R_43()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_19() {
        if (this.jj_3R_42()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_18() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_17() {
        if (this.jj_3R_40()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_16() {
        if (this.jj_3R_39()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_245() {
        if (this.jj_scan_token(148)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_15() {
        if (this.jj_3R_38()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_244() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_14() {
        if (this.jj_3R_37()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_243() {
        if (this.jj_scan_token(137)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_13() {
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_242() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_12() {
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_241() {
        if (this.jj_scan_token(135)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        if (this.jj_3R_34()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_240() {
        if (this.jj_scan_token(134)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_10() {
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_239() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_238() {
        if (this.jj_scan_token(132)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_237() {
        if (this.jj_scan_token(131)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_10()) {
            this.jj_scanpos = token;
            if (this.jj_3R_11()) {
                this.jj_scanpos = token;
                if (this.jj_3R_12()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_13()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_14()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_15()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_16()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_17()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_18()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_19()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_20()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_21()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_22()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_23()) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_3R_24()) {
                                                                    return true;
                                                                }
                                                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_25()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = token;
            if (this.jj_3R_27()) {
                this.jj_scanpos = token;
                if (this.jj_3R_28()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_236() {
        if (this.jj_scan_token(130)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_235() {
        if (this.jj_scan_token(129)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_234() {
        if (this.jj_scan_token(128)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_233() {
        if (this.jj_scan_token(127)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_232() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_231() {
        if (this.jj_scan_token(125)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_230() {
        if (this.jj_scan_token(122)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_229() {
        if (this.jj_scan_token(121)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_228() {
        if (this.jj_scan_token(119)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_227() {
        if (this.jj_scan_token(117)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_67()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_226() {
        if (this.jj_scan_token(115)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_225() {
        if (this.jj_scan_token(113)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_224() {
        if (this.jj_scan_token(111)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_223() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_222() {
        if (this.jj_scan_token(110)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_221() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_220() {
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_219() {
        if (this.jj_scan_token(106)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_218() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_217() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_216() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_215() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_214() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_213() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_212() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_211() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_210() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public ASEParser(InputStream inputStream) {
        int n;
        this.jj_input_stream = new UCode_CharStream(inputStream, 1, 1);
        this.token_source = new ASEParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 73; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 73; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ASEParser(Reader reader) {
        int n;
        this.jj_input_stream = new UCode_CharStream(reader, 1, 1);
        this.token_source = new ASEParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 73; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    @Override
    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 73; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ASEParser(ASEParserTokenManager aSEParserTokenManager) {
        int n;
        this.token_source = aSEParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 73; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ASEParserTokenManager aSEParserTokenManager) {
        int n;
        this.token_source = aSEParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 73; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token original_jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration<int[]> enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[196];
        for (n2 = 0; n2 < 196; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 73; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((this.jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((this.jj_la1_2[n2] & 1 << n) != 0) {
                    blArray[64 + n] = true;
                }
                if ((this.jj_la1_3[n2] & 1 << n) != 0) {
                    blArray[96 + n] = true;
                }
                if ((this.jj_la1_4[n2] & 1 << n) != 0) {
                    blArray[128 + n] = true;
                }
                if ((this.jj_la1_5[n2] & 1 << n) != 0) {
                    blArray[160 + n] = true;
                }
                if ((this.jj_la1_6[n2] & 1 << n) == 0) continue;
                blArray[192 + n] = true;
            }
        }
        for (n2 = 0; n2 < 196; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 21; ++i) {
            JJCalls jJCalls = this.jj_2_rtns[i];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                        break;
                    }
                    case 14: {
                        this.jj_3_15();
                        break;
                    }
                    case 15: {
                        this.jj_3_16();
                        break;
                    }
                    case 16: {
                        this.jj_3_17();
                        break;
                    }
                    case 17: {
                        this.jj_3_18();
                        break;
                    }
                    case 18: {
                        this.jj_3_19();
                        break;
                    }
                    case 19: {
                        this.jj_3_20();
                        break;
                    }
                    case 20: {
                        this.jj_3_21();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    class MsgFilter
    extends IOFilter {
        MsgFilter(IO iO) {
            super(iO);
        }

        @Override
        public void writeln(String string, int n) {
            if (string != null && string.length() > 0) {
                ASEParser.this._messages.addElement(string);
            }
            super.writeln(string, n);
        }
    }

    class SQLFormatReader
    implements TextImporter.Reader {
        private boolean _eof = false;
        private char _escape;

        SQLFormatReader(char c) {
            this._escape = c;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String readLine() {
            int n;
            StringBuffer stringBuffer = null;
            String string = this.readRawLine();
            if (string == null) {
                return null;
            }
            boolean bl = true;
            int n2 = string.length();
            stringBuffer = new StringBuffer(n2);
            for (n = 0; n < n2; ++n) {
                char c;
                block13: {
                    c = string.charAt(n);
                    if (c == this._escape && n < n2 - 1) {
                        c = string.charAt(n + 1);
                        if (c == this._escape) {
                            ++n;
                        } else if (c == 'n') {
                            c = '\n';
                            ++n;
                        } else {
                            if ((c == 'x' || c == 'X') && n < n2 - 3) {
                                char c2 = string.charAt(n + 2);
                                char c3 = string.charAt(n + 3);
                                n += 3;
                                if (Character.digit(c2, 16) != -1 && Character.digit(c3, 16) != -1) {
                                    c = (char)((Character.digit(c2, 16) << 4) + Character.digit(c3, 16));
                                    break block13;
                                } else {
                                    stringBuffer.append(this._escape);
                                    stringBuffer.append(c);
                                    stringBuffer.append(c2);
                                    stringBuffer.append(c3);
                                    continue;
                                }
                            }
                            stringBuffer.append(this._escape);
                            ++n;
                        }
                    }
                }
                bl &= c < '\u0080';
                stringBuffer.append(c);
            }
            if (bl) {
                return stringBuffer.toString();
            }
            n2 = stringBuffer.length();
            byte[] byArray = new byte[n2];
            n = 0;
            while (n < n2) {
                byArray[n] = (byte)stringBuffer.charAt(n);
                ++n;
            }
            return new String(byArray, 0, n2);
        }

        private String readRawLine() {
            String string;
            while (true) {
                try {
                    string = ASEParser.this.readLine();
                }
                catch (TokenMgrError tokenMgrError) {
                    string = null;
                    this._eof = true;
                    break;
                }
                catch (ParseException parseException) {
                    if (parseException.currentToken.kind == 0) {
                        string = null;
                        this._eof = true;
                        break;
                    }
                    ASEParser.this.getNextToken();
                    continue;
                }
                if (string == null) {
                    this._eof = true;
                    break;
                }
                if (string.length() != 0 && string.trim().length() != 0) break;
            }
            return string;
        }

        @Override
        public boolean eof() {
            return this._eof;
        }

        @Override
        public void close() {
            if (!this._eof) {
                while (!this._eof) {
                    this.readLine();
                }
            }
        }
    }

    static class ParseAbortedError
    extends Error {
        ParseAbortedError() {
        }
    }
}

