/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import sybase.isql.FavoritesList;
import sybase.isql.FavoritesListItem;
import sybase.isql.FavoritesTree;
import sybase.isql.FavoritesTreeModel;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLResource;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;

class AddToFavoritesDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String F1_KEY = "F1_KEY";
    private static Rectangle _bounds = null;
    private ParentFrame _parent = null;
    private FavoritesList _favorites = null;
    private String _fileName = null;
    private String _connectionName = null;
    private ISQLResource _bundle;
    private SybRadioButton _rbConnection = null;
    private SybRadioButton _rbFile = null;
    private SybCheckBox _cbSavePassword = null;
    private JTextField _name;
    private boolean _addConnection = false;
    private boolean _addFile = false;
    private FavoritesTree _folders;
    private SybButton _newFolder = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _help = null;

    static void create(ParentFrame parentFrame) {
        AddToFavoritesDialog addToFavoritesDialog = new AddToFavoritesDialog(parentFrame);
        addToFavoritesDialog.setVisible(true);
        addToFavoritesDialog.destroy();
    }

    private AddToFavoritesDialog(ParentFrame parentFrame) {
        super((Window)parentFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        File file;
        boolean bl;
        this._parent = parentFrame;
        this._favorites = Preferences.getFavorites();
        this._bundle = ISQLResource.getISQLResource(GeneralResources.getName());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ISQLConnection iSQLConnection = parentFrame.getConnection();
        boolean bl2 = bl = iSQLConnection != null && iSQLConnection.isConnected();
        if (bl) {
            this._connectionName = iSQLConnection.getCatalog();
        }
        if ((file = parentFrame.getFile()) != null && file.exists()) {
            this._fileName = file.getName();
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        if (bl && file == null) {
            this._addConnection = true;
            SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(this._bundle.getFormattedString("ADD_FAVORITE_ADDING_CONNECTION", this._connectionName));
            this._cbSavePassword = new SybCheckBox(this._bundle.getISQLString("ADD_FAVORITE_CB_SAVE_PASSWORD"));
            jPanel2.add((Component)sybMultiLineLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (Preferences.getAllowPasswordsInFavorites()) {
                jPanel2.add((Component)this._cbSavePassword, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        } else if (!bl && file != null) {
            this._addFile = true;
            SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(this._bundle.getFormattedString("ADD_FAVORITE_ADDING_FILE", this._fileName));
            jPanel2.add((Component)sybMultiLineLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else if (bl && file != null) {
            SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(this._bundle.getISQLString("ADD_FAVORITE_WHAT_TO_DO"));
            this._rbConnection = new SybRadioButton(this._bundle.getFormattedString("ADD_FAVORITE_RB_ADD_CONNECTION", this._connectionName));
            this._cbSavePassword = new SybCheckBox(this._bundle.getISQLString("ADD_FAVORITE_CB_SAVE_PASSWORD"));
            this._rbFile = new SybRadioButton(this._bundle.getFormattedString("ADD_FAVORITE_RB_ADD_FILE", this._fileName));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._rbConnection);
            buttonGroup.add((AbstractButton)this._rbFile);
            this._rbConnection.setSelected(true);
            this._addConnection = true;
            this._rbConnection.addItemListener((ItemListener)this);
            this._rbFile.addItemListener((ItemListener)this);
            jPanel2.add((Component)sybMultiLineLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel2.add((Component)this._rbConnection, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (Preferences.getAllowPasswordsInFavorites()) {
                jPanel2.add((Component)this._cbSavePassword, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 20, 0, 0), 0, 0));
            }
            jPanel2.add((Component)this._rbFile, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            throw new IllegalStateException("Don't show this dialog unless a file and/or connection is open.");
        }
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 10, 0), 0, 0));
        SybLabel sybLabel = new SybLabel(this._bundle.getISQLString("ADD_FAVORITE_NAME"));
        this._name = new JTextField(20);
        new FontHelper((JTextComponent)this._name);
        if (this._addFile) {
            this._name.setText(file.getName());
        } else if (this._addConnection) {
            if (iSQLConnection.getDatabaseType() == 1) {
                String string = iSQLConnection.getCatalog();
                String string2 = iSQLConnection.getServerName();
                String string3 = iSQLConnection.getUserID();
                String string4 = string2 + " (" + string3 + ") / " + string;
                this._name.setText(string4);
            } else {
                this._name.setText(iSQLConnection.getCatalog());
            }
        }
        sybLabel.setLabelFor((Component)this._name);
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel.add((Component)this._name, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
        sybLabel = new SybLabel(this._bundle.getISQLString("ADD_FAVORITE_CREATE_IN"));
        this._folders = new FavoritesTree(this._favorites);
        sybLabel.setLabelFor((Component)this._folders);
        this._folders.setSelectionInterval(0, 0);
        JScrollPane jScrollPane = new JScrollPane(this._folders);
        this._newFolder = new SybButton(this._bundle.getISQLString("ADD_FAVORITE_NEW_FOLDER"));
        this._newFolder.addActionListener((ActionListener)this);
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._newFolder, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 5, 0, 0), 0, 0));
        this._ok = new SybButton(this._bundle.getISQLString("ADD_FAVORITES_OK"));
        this._ok.addActionListener((ActionListener)this);
        this._cancel = new SybButton(this._bundle.getISQLString("ADD_FAVORITES_CANCEL"));
        this._cancel.addActionListener((ActionListener)this);
        this._help = new SybButton(this._bundle.getISQLString("ADD_FAVORITES_HELP"));
        this._help.addActionListener((ActionListener)this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel, this._help});
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add((Component)this._ok);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add((Component)this._cancel);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add((Component)this._help);
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setTitle(this._bundle.getISQLString("ADD_FAVORITES_TITLE"));
        this.getRootPane().getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getRootPane().registerKeyboardAction(this, F1_KEY, KeyStroke.getKeyStroke(112, 0, true), 2);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        if (_bounds != null) {
            this.setBounds(_bounds);
            UIUtils.ensureWindowIsVisible((Window)this);
        } else {
            this.setLocationRelativeTo(parentFrame);
        }
    }

    private void destroy() {
        _bounds = this.getBounds();
        this._bundle = null;
        this._name = null;
        this._folders = null;
        if (this._rbConnection != null) {
            this._rbConnection.removeItemListener((ItemListener)this);
            this._rbConnection = null;
        }
        if (this._cbSavePassword != null) {
            this._cbSavePassword = null;
        }
        if (this._rbFile != null) {
            this._rbFile.removeItemListener((ItemListener)this);
            this._rbFile = null;
        }
        if (this._newFolder != null) {
            this._newFolder.removeActionListener((ActionListener)this);
            this._newFolder = null;
        }
        if (this._ok != null) {
            this.getRootPane().setDefaultButton(null);
            this._ok.removeActionListener((ActionListener)this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        if (this._help != null) {
            this._help.removeActionListener((ActionListener)this);
            this._help = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    private void handleNewFolder() {
        String string;
        String string2 = this._bundle.getISQLString("ADD_FAVORITE_NEW_FOLDER_TITLE");
        while ((string = SybOptionPane.showInputDialog((Component)this, (Object)this._bundle.getISQLString("ADD_FAVORITE_NEW_FOLDER_DESC"), (String)string2, (int)2)) != null) {
            if ((string = string.trim()).length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getISQLString("ADD_FAVORITE_EMPTY_NAME"), (String)this.getTitle(), (int)0);
                continue;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._folders.getLastSelectedPathComponent();
            FavoritesListItem favoritesListItem = (FavoritesListItem)defaultMutableTreeNode.getUserObject();
            if (favoritesListItem.getChildByName(string) != null) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ISQLResource.getFormattedString(GeneralResources.getName(), "ADD_FAVORITE_DUPLICATE_NAME", string, favoritesListItem.getName()), (String)string2, (int)0);
                continue;
            }
            FavoritesListItem favoritesListItem2 = new FavoritesListItem(3, string, null, null);
            this._favorites.add(favoritesListItem, favoritesListItem2, favoritesListItem.getChildCount());
            this._folders.refresh();
            FavoritesTreeModel favoritesTreeModel = (FavoritesTreeModel)this._folders.getModel();
            TreePath treePath = favoritesTreeModel.findNode((DefaultMutableTreeNode)favoritesTreeModel.getRoot(), string);
            if (treePath != null) {
                this._folders.setSelectionPath(treePath);
            }
            this._folders.requestFocusInWindow();
            break;
        }
    }

    private boolean handleAddFavorite() {
        String string;
        String string2;
        int n;
        String string3 = this._name.getText().trim();
        if (string3.length() == 0) {
            SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getISQLString("ADD_FAVORITE_EMPTY_NAME"), (String)this.getTitle(), (int)0);
            this._name.requestFocusInWindow();
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._folders.getLastSelectedPathComponent();
        FavoritesListItem favoritesListItem = (FavoritesListItem)defaultMutableTreeNode.getUserObject();
        if (favoritesListItem.getChildByName(string3) != null) {
            SybOptionPane.showMessageDialog((Component)this, (Object)ISQLResource.getFormattedString(GeneralResources.getName(), "ADD_FAVORITE_DUPLICATE_NAME", string3, favoritesListItem.getName()), (String)this.getTitle(), (int)0);
            this._name.requestFocusInWindow();
            return false;
        }
        if (this._addConnection) {
            n = 1;
            ISQLConnection iSQLConnection = this._parent.getConnection();
            AbstractConnectionInfo abstractConnectionInfo = ((ISQLConnectionImpl)iSQLConnection).getConnectionInfo();
            if (!this._cbSavePassword.isSelected()) {
                abstractConnectionInfo.setPassword(null);
            }
            if (iSQLConnection.getDatabaseType() == 1 && abstractConnectionInfo instanceof ASEConnectionInfo) {
                ((ASEConnectionInfo)abstractConnectionInfo).setDatabaseName(iSQLConnection.getCatalog());
            }
            string2 = abstractConnectionInfo.serialize();
            string = ((ISQLConnectionImpl)iSQLConnection).getPlugin().getPluginID();
        } else {
            n = 2;
            string2 = this._parent.getFile().getAbsolutePath();
            string = null;
        }
        FavoritesListItem favoritesListItem2 = new FavoritesListItem(n, string3, string2, string);
        this._favorites.add(favoritesListItem, favoritesListItem2, favoritesListItem.getChildCount());
        return true;
    }

    private void handleHelp() {
        ISQLConnection iSQLConnection = this._parent.getConnection();
        if (iSQLConnection != null) {
            ISQLHelpManager.showHelp((ISQLConnectionImpl)iSQLConnection, this, "HELP_ISQL_ADD_TO_FAVORITES");
        }
    }

    private void handleOK() {
        if (this.handleAddFavorite()) {
            ISQLConnection iSQLConnection = this._parent.getConnection();
            if (iSQLConnection != null) {
                Preferences.save(iSQLConnection);
            }
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.setVisible(false);
        } else if (object == this._help || actionEvent.getActionCommand().equals(F1_KEY)) {
            this.handleHelp();
        } else if (object == this._newFolder) {
            this.handleNewFolder();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._rbConnection.isSelected()) {
            this._cbSavePassword.setEnabled(true);
            this._name.setText(this._connectionName);
            this._addConnection = true;
            this._addFile = false;
        } else {
            this._cbSavePassword.setEnabled(false);
            this._name.setText(this._fileName);
            this._addConnection = false;
            this._addFile = true;
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

