/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.SybLabel;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLResource;
import sybase.isql.Ruler;

class ColWidthTable
extends JTable {
    Ruler _ruler = null;
    SybLabel _summary = null;

    ColWidthTable() {
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setRowMargin(0);
        this.getColumnModel().setColumnMargin(0);
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
    }

    void setRuler(Ruler ruler) {
        this._ruler = ruler;
    }

    void setSummary(SybLabel sybLabel) {
        this._summary = sybLabel;
    }

    void setData(String[] stringArray) {
        this.setModel(new TableModel(stringArray));
        this.createDefaultColumnsFromModel();
        this.sizeColumnsToFit(-1);
        this.setAutoResizeMode(0);
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(tableColumn.getMinWidth());
            tableColumn.setMaxWidth(tableColumn.getMinWidth());
            tableColumn.setResizable(false);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._ruler != null) {
            graphics.setColor(SystemColor.textHighlight);
            int n = this.getCellRect((int)0, (int)0, (boolean)true).width;
            int n2 = 0;
            Rectangle rectangle = graphics.getClipBounds();
            int n3 = rectangle.y;
            int n4 = rectangle.y + rectangle.height;
            int n5 = this._ruler.getColumnBreakCount();
            for (int i = 0; i < n5; ++i) {
                n2 = this._ruler.getColumnBreak(i) * n;
                graphics.drawLine(n2, n3, n2, n4);
            }
        }
    }

    void updateSummary() {
        if (this._summary != null) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(ISQLResource.getISQLString(GeneralResources.getName(), "ColumnBreaks"));
            int n = this._ruler.getColumnBreakCount();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(String.valueOf(this._ruler.getColumnBreak(i)));
            }
            this._summary.setText(stringBuffer.toString());
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    static class TableModel
    extends AbstractTableModel {
        private String[] _data = null;

        TableModel(String[] stringArray) {
            this._data = stringArray;
        }

        @Override
        public int getRowCount() {
            return this._data.length;
        }

        @Override
        public int getColumnCount() {
            if (this._data.length > 0) {
                return this._data[0].length();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n < this._data.length && n2 >= 0 && n2 < this._data[n].length()) {
                string = String.valueOf(this._data[n].charAt(n2));
            }
            if (string == null) {
                string = "";
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

