/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLResource;
import sybase.isql.OwnerAndName;
import sybase.isql.TableBrowserResources;

class ColumnBrowser
extends JDialog
implements ActionListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private String _name = null;
    private SybButton _ok;
    private SybButton _cancel;
    private JList _list;
    private ISQLConnection _connection;

    private ColumnBrowser(JDialog jDialog, ISQLConnection iSQLConnection, String string, OwnerAndName ownerAndName) {
        super((Window)jDialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this.constructor(jDialog, iSQLConnection, string, ownerAndName);
    }

    private ColumnBrowser(JFrame jFrame, ISQLConnection iSQLConnection, String string, OwnerAndName ownerAndName) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        this.constructor(jFrame, iSQLConnection, string, ownerAndName);
    }

    private void constructor(Component component, ISQLConnection iSQLConnection, String string, OwnerAndName ownerAndName) {
        this._connection = iSQLConnection;
        ISQLResource iSQLResource = ISQLResource.getISQLResource(TableBrowserResources.getName());
        this.setTitle(iSQLResource.getISQLString("Select Column"));
        SybLabel sybLabel = new SybLabel(ISQLResource.getFormattedString(TableBrowserResources.getName(), "Columns in {0}", ownerAndName.toString()));
        new FontHelper((JLabel)sybLabel);
        this._list = new JList();
        this._list.setCellRenderer(FontHelper.getListCellRenderer());
        this._list.setSelectionMode(0);
        sybLabel.setLabelFor((Component)this._list);
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = ColumnBrowser.this._list.locationToIndex(mouseEvent.getPoint());
                    ColumnBrowser.this._list.setSelectedIndex(n);
                    ColumnBrowser.this.handleOK();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._list);
        jScrollPane.setAlignmentX(0.0f);
        try {
            this.refreshList(string, ownerAndName);
        }
        catch (SQLException sQLException) {
            DetailsErrorDialog.showDialog((Component)component, (String)this.getTitle(), (String)ISQLResource.getISQLString(TableBrowserResources.getName(), "COULD_NOT_GET_COLUMN_LIST"), (String)sQLException.getLocalizedMessage(), null);
        }
        this._ok = new SybButton(iSQLResource.getISQLString("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton(iSQLResource.getISQLString("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel.add((Component)this._ok);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add((Component)this._cancel);
        DialogUtils.makeComponentsSameWidth((JComponent[])new SybButton[]{this._ok, this._cancel});
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel3.add((Component)sybLabel);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel3.add(jScrollPane);
        jPanel3.add(jPanel2);
        Container container = this.getContentPane();
        container.add(jPanel3);
        Dimension dimension = jPanel3.getPreferredSize();
        dimension.width = 300;
        jPanel3.setPreferredSize(dimension);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(component);
    }

    private void destroyGUI() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().setDefaultButton(null);
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._list = null;
        this._connection = null;
        DialogUtils.removeComponents((Container)this);
    }

    private void refreshList(String string, OwnerAndName ownerAndName) throws SQLException {
        String[] stringArray = this._connection.getColumnNames(string, ownerAndName.owner, ownerAndName.name);
        Arrays.sort(stringArray, new Comparator<String>(){
            private Collator _collator = Collator.getInstance();

            @Override
            public int compare(String string, String string2) {
                return this._collator.compare(string, string2);
            }
        });
        this._list.setListData(stringArray);
        if (stringArray.length > 0) {
            this._list.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.handleCancel();
        }
    }

    private void handleOK() {
        Object e = this._list.getSelectedValue();
        if (e != null) {
            this._name = e.toString();
        }
        this.setVisible(false);
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    static String create(JDialog jDialog, ISQLConnection iSQLConnection, String string, OwnerAndName ownerAndName) {
        ColumnBrowser columnBrowser = new ColumnBrowser(jDialog, iSQLConnection, string, ownerAndName);
        UIUtils.ensureWindowIsVisible((Window)columnBrowser);
        columnBrowser.setVisible(true);
        columnBrowser.destroyGUI();
        return columnBrowser._name;
    }

    static String create(JFrame jFrame, ISQLConnection iSQLConnection, String string, OwnerAndName ownerAndName) {
        ColumnBrowser columnBrowser = new ColumnBrowser(jFrame, iSQLConnection, string, ownerAndName);
        UIUtils.ensureWindowIsVisible((Window)columnBrowser);
        columnBrowser.setVisible(true);
        columnBrowser.destroyGUI();
        return columnBrowser._name;
    }
}

