/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.logon.AbstractConnectionInfo;
import java.io.File;
import sybase.isql.ISQLPlugin;
import sybase.isql.PluginMgr;

class CommandLineOptions {
    boolean quiet = false;
    boolean checkSyntaxOnly = false;
    boolean useGUI = true;
    boolean connectOnStartup = true;
    AbstractConnectionInfo connectionInfo = null;
    StringBuffer tail = new StringBuffer();
    StringBuffer commandLine = new StringBuffer();
    String initialSQL = null;
    boolean executeInitialSQL = false;
    String defaultOnErrorAction = null;
    int userDebuggingLevel = 0;
    File file = null;
    private ISQLPlugin _plugin = null;
    private int _defaultDatabaseType = -1;

    CommandLineOptions() {
    }

    void setPlugin(ISQLPlugin iSQLPlugin) {
        if (iSQLPlugin != this._plugin) {
            this._plugin = iSQLPlugin;
            this._defaultDatabaseType = -1;
        }
    }

    ISQLPlugin getPlugin() {
        return this._plugin;
    }

    int getDefaultDatabaseType() {
        if (this._defaultDatabaseType == -1 && this._plugin != null) {
            this._defaultDatabaseType = PluginMgr.getDatabaseTypeForPlugin(this._plugin);
        }
        return this._defaultDatabaseType;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CommandLineOptions");
        stringBuilder.append(string);
        stringBuilder.append("  Full command line: ");
        if (this.commandLine.length() != 0) {
            stringBuilder.append(this.commandLine.toString());
        } else {
            stringBuilder.append("(none)");
        }
        stringBuilder.append(string);
        stringBuilder.append("  ConnectionInfo: ");
        if (this.connectionInfo != null) {
            stringBuilder.append(this.connectionInfo.toString());
        } else {
            stringBuilder.append("(none)");
        }
        stringBuilder.append(string);
        stringBuilder.append("  Command tail: ");
        if (this.tail.length() == 0) {
            stringBuilder.append("(none)");
        } else {
            stringBuilder.append(this.tail.toString());
        }
        stringBuilder.append(string);
        stringBuilder.append("  Initial SQL statement: ");
        if (this.initialSQL == null) {
            stringBuilder.append("(none)");
        } else {
            stringBuilder.append(this.initialSQL);
        }
        stringBuilder.append(string);
        stringBuilder.append("  Execute initial SQL statement: ");
        if (this.executeInitialSQL) {
            stringBuilder.append("Yes");
        } else {
            stringBuilder.append("No");
        }
        stringBuilder.append(string);
        stringBuilder.append("  Use GUI: ");
        if (this.useGUI) {
            stringBuilder.append("Yes");
        } else {
            stringBuilder.append("No");
        }
        stringBuilder.append(string);
        stringBuilder.append("  Quiet mode is: ");
        if (this.quiet) {
            stringBuilder.append("On");
        } else {
            stringBuilder.append("Off");
        }
        stringBuilder.append(string);
        stringBuilder.append("  Syntax check mode is: ");
        if (this.checkSyntaxOnly) {
            stringBuilder.append("On");
        } else {
            stringBuilder.append("Off");
        }
        stringBuilder.append(string);
        stringBuilder.append("  Default database type: ");
        switch (this.getDefaultDatabaseType()) {
            case 0: {
                stringBuilder.append("ASA");
                break;
            }
            case 2: {
                stringBuilder.append("IQ");
                break;
            }
            case 1: {
                stringBuilder.append("ASE");
                break;
            }
            default: {
                stringBuilder.append("Unknown, code=" + this.getDefaultDatabaseType());
            }
        }
        stringBuilder.append(string);
        if (this._plugin == null) {
            stringBuilder.append("  No default plugin");
        } else {
            stringBuilder.append("  Default plugin: " + this._plugin.getPluginName());
        }
        stringBuilder.append(string);
        stringBuilder.append("  SQLCONNECT environment variable: ");
        String string2 = System.getenv("SQLCONNECT");
        if (string2 == null) {
            System.getenv("sqlconnect");
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append("(Undefined)");
        }
        stringBuilder.append(string);
        stringBuilder.append("  ULSQLCONNECT environment variable: ");
        String string3 = System.getenv("ULSQLCONNECT");
        if (string3 == null) {
            string3 = System.getenv("ulsqlconnect");
        }
        if (string3 != null) {
            stringBuilder.append(string3);
        } else {
            stringBuilder.append("(Undefined)");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

