/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;

class ConnectingDialog
extends JDialog
implements Runnable {
    private Runnable _client;
    private boolean _done;
    private boolean _dialogWasShown = false;

    static void showDialog(Frame frame, Runnable runnable) {
        ConnectingDialog connectingDialog = new ConnectingDialog((Window)frame, runnable);
        if (connectingDialog._dialogWasShown && System.getProperty("com.sybase.util.FastLoader", "0").equals("1")) {
            frame.setExtendedState(1);
            frame.setExtendedState(0);
            frame.repaint();
        }
    }

    private ConnectingDialog(Window window, Runnable runnable) {
        super(window, Dialog.ModalityType.DOCUMENT_MODAL);
        this._client = runnable;
        this.createGUI();
        this.setLocationRelativeTo(window);
        this._done = false;
        Thread thread = new Thread((Runnable)this, "ConnectingDialog thread");
        thread.start();
        try {
            thread.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            this._dialogWasShown = true;
            UIUtils.ensureWindowIsVisible((Window)this);
            this.setVisible(true);
            this.destroyGUI();
        }
        this._client = null;
    }

    private void createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        URL uRL = this.getClass().getResource("connecting.gif");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : ISQLImages.getImageIcon("connecting");
        SybLabel sybLabel = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "ConnectingToDatabase"));
        sybLabel.setIcon((Icon)imageIcon);
        sybLabel.setIconTextGap(10);
        imageIcon.setImageObserver((ImageObserver)sybLabel);
        jPanel.add((Component)sybLabel);
        jPanel.add(Box.createVerticalStrut(5));
        this.setTitle(ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL"));
        this.getContentPane().add(jPanel);
        this.pack();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
    }

    private void destroyGUI() {
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void run() {
        if (EventQueue.isDispatchThread()) {
            this.setVisible(false);
        } else {
            this._client.run();
            this._done = true;
            SwingUtilities.invokeLater(this);
        }
    }
}

