/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.resultSetTable.ScrollableResultSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Vector;
import sybase.isql.CommandLineOptions;
import sybase.isql.ConnectionList;
import sybase.isql.ConsoleIO;
import sybase.isql.ErrorMessages;
import sybase.isql.FrontEnd;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLEngine;
import sybase.isql.ISQLParser;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.LogFile;
import sybase.isql.ParseException;
import sybase.isql.ParserStringReader;
import sybase.isql.ParserUtils;
import sybase.isql.Preferences;
import sybase.isql.ResultsProcessor;
import sybase.isql.StaticResultSet;
import sybase.isql.TokenMgrError;
import sybase.isql.UnbufferedISQLResultSet;
import sybase.isql.UserAbortedParsingError;
import sybase.isql.isql;

class Console
implements FrontEnd,
ResultsProcessor {
    private ConnectionList _connectionList = new ConnectionList();
    private LogFile _logFile = null;
    private boolean _shutdownRequested = false;
    private ISQLConnection _uiActiveConnection = null;
    private int _resultSetCount = 0;

    Console() {
    }

    static FrontEnd create() {
        isql.setDefaultIO(new ConsoleIO());
        return new Console();
    }

    @Override
    public void run(CommandLineOptions commandLineOptions) {
        boolean bl;
        try {
            Class.forName("sun.misc.Signal");
            Class.forName("sun.misc.SignalHandler");
            Class<?> clazz = Class.forName("sybase.isql.SybHandler");
            Method method = clazz.getMethod("install", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ISQLConnectionImpl iSQLConnectionImpl = new ISQLConnectionImpl();
        this._uiActiveConnection = iSQLConnectionImpl;
        this._connectionList.add(iSQLConnectionImpl);
        if (commandLineOptions.connectionInfo != null && commandLineOptions.connectionInfo.canAttemptConnection() && !(bl = this.connect(iSQLConnectionImpl, commandLineOptions.getPlugin(), commandLineOptions.connectionInfo, FrontEnd.PromptBehavior.IF_NEEDED, false, null))) {
            isql.returnCode = 9;
        }
        if (commandLineOptions.tail.length() != 0) {
            String string = isql.stripQuotes(commandLineOptions.tail.toString());
            StringBuffer stringBuffer = new StringBuffer();
            File file = ParserUtils.searchForFile(string, null);
            if (file != null) {
                stringBuffer.append("READ \"");
                stringBuffer.append(ParserUtils.escapeFileName(file.toString()));
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(string);
            }
            isql.execute(this, iSQLConnectionImpl, stringBuffer.toString(), this);
        } else {
            String string;
            if (!isql.options.quiet && (string = Preferences.getStringOption(iSQLConnectionImpl, "on_error")) != null && string.equalsIgnoreCase("Exit")) {
                System.out.println(GeneralResources.getISQLString(GeneralResources.getName(), "WARNING_EXIT_ON_ERROR"));
            }
            this.processConsoleInput();
            isql.returnCode = 0;
        }
        Preferences.save(iSQLConnectionImpl);
        this._connectionList.disconnectAll();
        this._uiActiveConnection = null;
        isql.uiIndependentFini();
        System.exit(isql.returnCode);
    }

    @Override
    public void requestShutdown() {
        this._shutdownRequested = true;
    }

    @Override
    public boolean isShutdownRequested() {
        return this._shutdownRequested;
    }

    @Override
    public boolean destroy() {
        return true;
    }

    @Override
    public void closeUIForConnection(ISQLConnection iSQLConnection) {
        this.requestShutdown();
    }

    @Override
    public void notifyConnectionOpened(ISQLConnection iSQLConnection) {
    }

    @Override
    public void notifyConnectionClosed(ISQLConnection iSQLConnection) {
        this._connectionList.remove(iSQLConnection);
    }

    @Override
    public void notifyDatabaseSelected(ISQLConnection iSQLConnection, String string) {
    }

    @Override
    public void notifyDatabaseListChanged(ISQLConnection iSQLConnection) {
    }

    @Override
    public void notifyCurrentUserChanged(ISQLConnection iSQLConnection) {
    }

    @Override
    public ISQLConnection findConnectionByName(String string) {
        return this._connectionList.findByName(string);
    }

    @Override
    public ISQLConnection getUIActiveConnection() {
        return this._uiActiveConnection;
    }

    @Override
    public boolean activateNamedConnection(String string) {
        ISQLConnection iSQLConnection = this._connectionList.findByName(string);
        if (iSQLConnection != null) {
            this._uiActiveConnection = iSQLConnection;
        }
        return iSQLConnection != null;
    }

    @Override
    public void closeAllConnections() {
        this._connectionList.disconnectAll();
        this._uiActiveConnection = null;
    }

    @Override
    public boolean startLogging(ISQLConnection iSQLConnection, String string) {
        if (this._logFile == null) {
            this._logFile = new LogFile();
        }
        boolean bl = this._logFile.open(string, true, isql.getIO(iSQLConnection));
        return bl;
    }

    @Override
    public void log(ISQLConnection iSQLConnection, String string) {
        if (this._logFile != null) {
            this._logFile.write(string, isql.getIO(iSQLConnection));
        }
    }

    @Override
    public void stopLogging(ISQLConnection iSQLConnection) {
        if (this._logFile != null) {
            this._logFile.close(isql.getIO(iSQLConnection));
        }
    }

    @Override
    public void enableUIForConnection(ISQLConnection iSQLConnection, boolean bl) {
    }

    @Override
    public void clear(ISQLConnection iSQLConnection) {
    }

    @Override
    public boolean connect(ISQLConnection iSQLConnection, ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo, FrontEnd.PromptBehavior promptBehavior, boolean bl, Vector<String> vector) {
        block6: {
            boolean bl2 = false;
            if (iSQLPlugin == null || abstractConnectionInfo == null) {
                return false;
            }
            ((ISQLConnectionImpl)iSQLConnection).setConnectionInfo(iSQLPlugin, abstractConnectionInfo);
            try {
                iSQLConnection.connect(vector);
                Preferences.load(iSQLConnection);
                String string = Preferences.getStringOption(iSQLConnection, "isql_log");
                if (string != null && string.length() != 0) {
                    this.startLogging(iSQLConnection, string);
                }
                this._connectionList.add(iSQLConnection);
                this._uiActiveConnection = iSQLConnection;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (vector != null) {
                    vector.add(exception.getLocalizedMessage());
                }
                if (bl) break block6;
                String string = exception instanceof SQLException ? ISQLConnectionImpl.gatherSQLExceptionInfo("Could not connect to the database.", (SQLException)exception) : ISQLResource.getISQLString(ErrorMessages.getName(), "Could not connect to the database.") + "\n" + exception.getLocalizedMessage();
                System.err.println(string);
            }
        }
        return iSQLConnection.isConnected();
    }

    private void processConsoleInput() {
        ISQLParser iSQLParser = null;
        this._shutdownRequested = false;
        ISQLConnection iSQLConnection = this._uiActiveConnection;
        while (true) {
            String string;
            isql.currentlyExectuingStatments = string = this.readLineFromConsole();
            ParserStringReader parserStringReader = new ParserStringReader(string);
            iSQLParser = ParserUtils.getParser(iSQLParser, iSQLConnection, parserStringReader);
            if (!isql.options.quiet) {
                iSQLParser.setResultsProcessor(this);
            } else {
                iSQLParser.setResultsProcessor(null);
            }
            try {
                iSQLParser.parse(iSQLConnection, isql.options.quiet);
                if (this._shutdownRequested) break;
                iSQLConnection = this._uiActiveConnection;
            }
            catch (TokenMgrError tokenMgrError) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ISQLResource.getISQLString(ErrorMessages.getName(), "Could not execute statement."));
                stringBuffer.append("\n");
                stringBuffer.append(tokenMgrError.getMessage());
                isql.getIO(iSQLConnection).writeln(stringBuffer.toString(), 2);
            }
            catch (ParseException parseException) {
                isql.getIO(iSQLConnection).writeln(parseException.getMessage(), 2);
            }
            catch (UserAbortedParsingError userAbortedParsingError) {
                if (this._shutdownRequested) break;
                isql.getIO(iSQLConnection).writeln(userAbortedParsingError.getMessage(), 2);
            }
            isql.currentlyExectuingStatments = null;
        }
    }

    private static boolean shouldShowResultSetSummary(ISQLConnection iSQLConnection, String string) {
        int n = iSQLConnection.getDatabaseType();
        boolean bl = n == 1 ? ISQLConnectionImpl.statementReturnsResultSet(string) : true;
        return bl;
    }

    @Override
    public void startProcessingResults(ISQLConnection iSQLConnection) {
        this._resultSetCount = 0;
    }

    @Override
    public void endProcessingResults(ISQLConnection iSQLConnection) {
    }

    @Override
    public boolean processResultSet(ISQLConnection iSQLConnection, String string, ISQLResultSet iSQLResultSet, boolean bl) {
        ++this._resultSetCount;
        if (isql.options.quiet) {
            return true;
        }
        int n = Preferences.getIntOption((ISQLConnectionImpl)iSQLConnection, "printResultSetToConsole");
        if (n == 2 || n == 0 && bl) {
            if (StaticResultSet.isStaticResultSet(iSQLResultSet)) {
                Console.printResultSet(iSQLResultSet, -1, -1, true);
            } else {
                UnbufferedISQLResultSet unbufferedISQLResultSet = new UnbufferedISQLResultSet(iSQLResultSet.getScrollableResultSet().getJDBCResultSet(), iSQLConnection, iSQLResultSet.getSQLStatement());
                boolean bl2 = Console.shouldShowResultSetSummary(iSQLConnection, string);
                Console.printResultSet(unbufferedISQLResultSet, -1, -1, bl2);
            }
        }
        return true;
    }

    @Override
    public boolean processUpdateCount(ISQLConnection iSQLConnection, String string, int n) {
        if (!isql.options.quiet) {
            String string2;
            int n2 = ISQLEngine.guessUpdateType(string);
            switch (n2) {
                case 1: {
                    string2 = "{0} record(s) inserted";
                    break;
                }
                case 2: {
                    string2 = "{0} record(s) updated";
                    break;
                }
                case 3: {
                    string2 = "{0} record(s) deleted";
                    break;
                }
                default: {
                    if (iSQLConnection.getDatabaseType() == 1) {
                        return true;
                    }
                    string2 = "{0} record(s) affected";
                }
            }
            isql.getIO(iSQLConnection).writeln(ISQLResource.getFormattedString(GeneralResources.getName(), string2, Integer.toString(n)), 0);
        }
        return true;
    }

    @Override
    public boolean processAsyncMessages(ISQLConnection iSQLConnection, Vector<String> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i);
            System.out.println(string);
        }
        return true;
    }

    private static void printResultSet(ISQLResultSet iSQLResultSet, int n, int n2, boolean bl) {
        int n3;
        ScrollableResultSet scrollableResultSet;
        int n4;
        int n5 = iSQLResultSet.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        if (Preferences.getPluginBooleanPreference((ISQLConnectionImpl)iSQLResultSet.getConnection(), "showMultipleResultSets", "0") && n != -1) {
            stringBuffer.append(ISQLResource.getFormattedString(GeneralResources.getName(), "Result set {0} of {1} ", Integer.toString(n + 1), Integer.toString(n2)));
        }
        if ((n4 = Preferences.getPluginIntPreference((ISQLConnectionImpl)iSQLResultSet.getConnection(), "truncationLength", "truncationLength")) == 0) {
            n4 = Integer.MAX_VALUE;
        }
        if ((scrollableResultSet = iSQLResultSet.getScrollableResultSet()) != null) {
            scrollableResultSet.setMaxClobCharacters(n4);
            scrollableResultSet.setMaxBlobBytes(n4);
        }
        int[] nArray = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = Console.estimateColumnDataWidth(iSQLResultSet, n3);
            String string = iSQLResultSet.getColumnLabel(n3).trim();
            nArray[n3] = Math.max(string.length(), nArray[n3]);
            nArray[n3] = Math.min(n4, nArray[n3]);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(Console.padString(iSQLResultSet.getColumnLabel(n3), nArray[n3]));
            stringBuffer.append(" ");
            System.out.print(stringBuffer.toString());
        }
        System.out.println();
        stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n5; ++n3) {
            int n6 = nArray[n3];
            if (n3 < n5 - 1) {
                ++n6;
            }
            for (int i = 0; i < n6; ++i) {
                stringBuffer.append("-");
            }
        }
        System.out.println(stringBuffer.toString());
        boolean bl2 = false;
        stringBuffer = new StringBuffer();
        int n7 = 0;
        while (true) {
            block23: {
                try {
                    if (!iSQLResultSet.rowExists(n7)) {
                    }
                    break block23;
                }
                catch (SQLException sQLException) {
                    isql.getIO(iSQLResultSet.getConnection()).writeln(sQLException, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
                }
                break;
            }
            try {
                stringBuffer.setLength(0);
                for (n3 = 0; n3 < n5; ++n3) {
                    String string = iSQLResultSet.getStringValueAt(n7, n3);
                    stringBuffer.append(Console.padString(string, nArray[n3]));
                    stringBuffer.append(" ");
                    if (string.length() <= nArray[n3]) continue;
                    bl2 = true;
                }
                System.out.println(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                break;
            }
            ++n7;
        }
        boolean bl3 = true;
        if (n7 >= iSQLResultSet.getConnection().getMaximumRowCount()) {
            try {
                if (scrollableResultSet != null && scrollableResultSet.next()) {
                    bl3 = false;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (bl) {
            System.out.println();
            if (bl3) {
                System.out.println(ISQLResource.getFormattedString(GeneralResources.getName(), "({0} rows)", Integer.toString(n7)));
            } else {
                System.out.println(ISQLResource.getFormattedString(GeneralResources.getName(), "(First {0} rows)", Integer.toString(n7)));
            }
            if (bl2) {
                System.out.println(ISQLResource.getISQLString(ErrorMessages.getName(), "WARNING_DATA_VALUES_HAVE_BEEN_TRUNCATED"));
            }
            System.out.println();
        }
    }

    private static int estimateColumnDataWidth(ISQLResultSet iSQLResultSet, int n) {
        int n2 = 0;
        if (iSQLResultSet instanceof UnbufferedISQLResultSet) {
            n2 = iSQLResultSet.getColumnWidth(n);
        } else {
            for (int i = 0; i < 50; ++i) {
                String string;
                try {
                    string = iSQLResultSet.getStringValueAt(i, n);
                }
                catch (SQLException sQLException) {
                    continue;
                }
                if (i >= iSQLResultSet.getRowCount()) break;
                n2 = Math.max(n2, string.length());
            }
        }
        if (iSQLResultSet.isColumnBinary(n)) {
            n2 += 2;
        }
        return n2;
    }

    private static String padString(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = n - string.length();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(" ");
            }
        } else if (n2 < 0) {
            stringBuilder.setLength(n);
        }
        return stringBuilder.toString();
    }

    private String readLineFromConsole() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        string = this._uiActiveConnection != null && this._uiActiveConnection.isConnected() ? ((string = this._uiActiveConnection.getName()) != null && string.length() != 0 ? ISQLResource.getFormattedString(GeneralResources.getName(), "{0}> ", string) : ISQLResource.getFormattedString(GeneralResources.getName(), "({0})> ", this._uiActiveConnection.getUserID())) : ISQLResource.getISQLString(GeneralResources.getName(), "(Not Connected)> ");
        System.out.println();
        System.out.print(string);
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    @Override
    public Object getActiveJFrame() {
        return null;
    }

    @Override
    public Object getJFrameForConnection(ISQLConnection iSQLConnection) {
        return null;
    }

    @Override
    public void openPreferencesDialog(ISQLConnection iSQLConnection) {
        isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "The CONFIGURE statement is not supported in command line mode."), 0);
    }

    @Override
    public void openHelp(ISQLConnection iSQLConnection, String string) {
        isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "Help is not supported in command line mode."), 0);
    }

    @Override
    public void changeWindowConnection(ISQLConnection iSQLConnection, ISQLConnection iSQLConnection2) {
    }

    @Override
    public IO getIO() {
        return null;
    }
}

