/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.EmbeddedMnemonic;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.JComponent;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.IODataClient;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLResource;
import sybase.isql.Preferences;
import sybase.isql.isql;

class ConsoleIO
implements IO {
    private int _longestStatusMessage = 0;

    ConsoleIO() {
    }

    @Override
    public void writeln(Exception exception, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (exception != null) {
            if (exception instanceof SQLException) {
                for (SQLException sQLException = (SQLException)exception; sQLException != null; sQLException = sQLException.getNextException()) {
                    string = isql.formatSQLExceptionMessage(sQLException);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n\n");
                    }
                    stringBuilder.append(string);
                }
            } else {
                stringBuilder.append(exception.getLocalizedMessage());
            }
        }
        string = stringBuilder.toString();
        this.writeln(string, n);
    }

    @Override
    public void writeln(String string, int n) {
        if (!isql.options.quiet || n == 2 || n == 3) {
            if (n != 2) {
                System.out.println(string);
            } else {
                System.err.println(this.indent(string));
                this.beep();
            }
        }
    }

    private String indent(String string) {
        StringBuffer stringBuffer = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        while (true) {
            String string2;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (string2 == null) break;
            if (string2.length() == 0) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append("\n");
            }
            if (n != 0) {
                stringBuffer.append("  ");
            }
            ++n;
            stringBuffer.append(string2);
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    @Override
    public int promptForOptionWithAccessory(int n, String string, String string2, String[] stringArray, int n2, int n3, JComponent jComponent, String[] stringArray2) {
        return this.promptForOption(n, string, string2, stringArray, n2, 0);
    }

    @Override
    public int promptForOption(int n, String string, String string2, String[] stringArray, int n2, int n3) {
        int n4 = n2;
        if (!isql.options.quiet) {
            PrintStream printStream;
            if (n == 2) {
                printStream = System.err;
                printStream.println(this.indent(string2));
                this.beep();
            } else {
                printStream = System.out;
                printStream.println(string2);
            }
            int n5 = stringArray.length;
            if (n5 > 1) {
                for (int i = 0; i < n5; ++i) {
                    EmbeddedMnemonic embeddedMnemonic = EmbeddedMnemonic.getEmbeddedMnemonic((String)stringArray[i]);
                    printStream.println(ISQLResource.getFormattedString(GeneralResources.getName(), "{0}. {1}", Integer.toString(i + 1), embeddedMnemonic.getTextWithoutMnemonic()));
                }
                try {
                    int n6;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        printStream.print(ISQLResource.getISQLString(GeneralResources.getName(), "Select an option: "));
                    } while ((n6 = bufferedReader.read()) < 49 || n6 >= n5 + 49);
                    n4 = n6 - 49;
                }
                catch (IOException iOException) {}
            } else if (n != 1) {
                printStream.print(ISQLResource.getISQLString(GeneralResources.getName(), "Press any key to continue"));
                try {
                    System.in.read();
                }
                catch (IOException iOException) {}
            }
        } else if (n == 2) {
            System.err.println(string2);
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void promptForData(String var1_1, String[] var2_2, Class[] var3_3, Object[] var4_4, int var5_5, IODataClient var6_6) {
        block6: {
            var9_7 = 121;
            var10_8 = 110;
            var11_9 = null;
            System.out.println(var1_1);
            block2: while (true) {
                if (!(var7_10 = this.promptForData(var2_2, var3_3, var4_4, var6_6))) {
                    continue;
                }
                if (var5_5 == 0) break;
                if (var11_9 == null) {
                    var11_9 = ISQLResource.getISQLString(GeneralResources.getName(), "INTERACTIVE_INPUT_PROMPT");
                    var9_7 = ISQLResource.getISQLChar(GeneralResources.getName(), "INTERACTIVE_INPUT_RESPONSE_YES");
                    var10_8 = ISQLResource.getISQLChar(GeneralResources.getName(), "INTERACTIVE_INPUT_RESPONSE_NO");
                }
                System.out.print(var11_9);
                System.out.print((char)var9_7);
                System.out.print('\r');
                System.out.print(var11_9);
                while (true) {
                    try {
                        var8_11 = System.in.read();
                    }
                    catch (IOException var12_12) {
                        break block6;
                    }
                    if (var8_11 == 13) continue;
                    if (var8_11 != 10 && var8_11 != var9_7) ** break;
                    continue block2;
                    if (var8_11 == var10_8) ** break;
                }
                break;
            }
        }
    }

    private boolean promptForData(String[] stringArray, Class[] classArray, Object[] objectArray, IODataClient iODataClient) {
        boolean bl;
        int n = stringArray.length;
        Object[] objectArray2 = new Object[n];
        Arrays.fill(objectArray2, null);
        InputStream inputStream = System.in;
        System.out.println();
        for (int i = 0; i < n; ++i) {
            String string;
            System.out.print(stringArray[i]);
            System.out.print(": ");
            String string2 = null;
            if (objectArray2[i] != null) {
                string2 = objectArray2[i].toString();
            } else if (objectArray != null && objectArray[i] != null) {
                string2 = objectArray[i].toString();
            }
            if (string2 != null) {
                System.out.print(string2);
                for (int j = 0; j < string2.length(); ++j) {
                    System.out.print("\b");
                }
            }
            if ((string = this.gets(inputStream)) != null && !string.isEmpty() && objectArray != null && objectArray[i] != null) {
                string = objectArray[i].toString();
            }
            objectArray2[i] = string;
        }
        int n2 = iODataClient.submitData(null, objectArray2);
        if (n2 == -1) {
            bl = true;
        } else {
            System.out.println(ISQLResource.getFormattedString(ErrorMessages.getName(), "The value you gave for \"{0}\" is not valid.", stringArray[n2]));
            bl = false;
        }
        return bl;
    }

    private String gets(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                int n;
                if ((n = inputStream.read()) == -1) {
                    stringBuffer = null;
                } else {
                    if (n == 13) continue;
                    if (n != 10) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = stringBuffer != null ? stringBuffer.toString() : null;
        return string;
    }

    private int getStringLengthInEms(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080' && this.isFullWidth(c)) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    private boolean isFullWidth(char c) {
        return c == '\u00a1' || c == '\u00a4' || c >= '\u00a7' && c <= '\u00a8' || c == '\u00aa' || c >= '\u00ad' && c <= '\u00ae' || c >= '\u00b0' && c <= '\u00b4' || c >= '\u00b6' && c <= '\u00ba' || c >= '\u00bc' && c <= '\u00bf' || c == '\u00c6' || c == '\u00d0' || c >= '\u00d7' && c <= '\u00d8' || c >= '\u00de' && c <= '\u00e1' || c == '\u00e6' || c >= '\u00e8' && c <= '\u00ea' || c >= '\u00ec' && c <= '\u00ed' || c == '\u00f0' || c >= '\u00f2' && c <= '\u00f3' || c >= '\u00f7' && c <= '\u00fa' || c == '\u00fc' || c == '\u00fe' || c == '\u0101' || c == '\u0111' || c == '\u0113' || c == '\u011b' || c >= '\u0126' && c <= '\u0127' || c == '\u012b' || c >= '\u0131' && c <= '\u0133' || c == '\u0138' || c >= '\u013f' && c <= '\u0142' || c == '\u0144' || c >= '\u0148' && c <= '\u014b' || c == '\u014d' || c >= '\u0152' && c <= '\u0153' || c >= '\u0166' && c <= '\u0167' || c == '\u016b' || c == '\u01ce' || c == '\u01d0' || c == '\u01d2' || c == '\u01d4' || c == '\u01d6' || c == '\u01d8' || c == '\u01da' || c == '\u01dc' || c == '\u0251' || c == '\u0261' || c == '\u02c4' || c == '\u02c7' || c >= '\u02c9' && c <= '\u02cb' || c == '\u02cd' || c == '\u02d0' || c >= '\u02d8' && c <= '\u02db' || c == '\u02dd' || c == '\u02df' || c >= '\u0300' && c <= '\u034f' || c >= '\u0360' && c <= '\u036f' || c >= '\u0391' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03a9' || c >= '\u03b1' && c <= '\u03c1' || c >= '\u03c3' && c <= '\u03c9' || c == '\u0401' || c >= '\u0410' && c <= '\u044f' || c == '\u0451' || c >= '\u1100' && c <= '\u1159' || c == '\u115f' || c == '\u2010' || c >= '\u2013' && c <= '\u2016' || c >= '\u2018' && c <= '\u2019' || c >= '\u201c' && c <= '\u201d' || c >= '\u2020' && c <= '\u2022' || c >= '\u2024' && c <= '\u2027' || c == '\u2030' || c >= '\u2032' && c <= '\u2033' || c == '\u2035' || c == '\u203b' || c == '\u203e' || c == '\u2074' || c == '\u207f' || c >= '\u2081' && c <= '\u2084' || c == '\u20ac' || c == '\u2103' || c == '\u2105' || c == '\u2109' || c == '\u2113' || c == '\u2116' || c >= '\u2121' && c <= '\u2122' || c == '\u2126' || c == '\u212b' || c >= '\u2153' && c <= '\u2154' || c >= '\u215b' && c <= '\u215e' || c >= '\u2160' && c <= '\u216b' || c >= '\u2170' && c <= '\u2179' || c >= '\u2190' && c <= '\u2199' || c >= '\u21b8' && c <= '\u21b9' || c == '\u21d2' || c == '\u21d4' || c == '\u21e7' || c == '\u2200' || c >= '\u2202' && c <= '\u2203' || c >= '\u2207' && c <= '\u2208' || c == '\u220b' || c == '\u220f' || c == '\u2211' || c == '\u2215' || c == '\u221a' || c >= '\u221d' && c <= '\u2220' || c == '\u2223' || c == '\u2225' || c >= '\u2227' && c <= '\u222c' || c == '\u222e' || c >= '\u2234' && c <= '\u2237' || c >= '\u223c' && c <= '\u223d' || c == '\u2248' || c == '\u224c' || c == '\u2252' || c >= '\u2260' && c <= '\u2261' || c >= '\u2264' && c <= '\u2267' || c >= '\u226a' && c <= '\u226b' || c >= '\u226e' && c <= '\u226f' || c >= '\u2282' && c <= '\u2283' || c >= '\u2286' && c <= '\u2287' || c == '\u2295' || c == '\u2299' || c == '\u22a5' || c == '\u22bf' || c == '\u2312' || c >= '\u2329' && c <= '\u232a' || c >= '\u2460' && c <= '\u24e9' || c >= '\u24eb' && c <= '\u24fe' || c >= '\u2500' && c <= '\u254b' || c >= '\u2550' && c <= '\u2573' || c >= '\u2580' && c <= '\u258f' || c >= '\u2592' && c <= '\u2595' || c >= '\u25a0' && c <= '\u25a1' || c >= '\u25a3' && c <= '\u25a9' || c >= '\u25b2' && c <= '\u25b3' || c >= '\u25b6' && c <= '\u25b7' || c >= '\u25bc' && c <= '\u25bd' || c >= '\u25c0' && c <= '\u25c1' || c >= '\u25c6' && c <= '\u25c8' || c == '\u25cb' || c >= '\u25ce' && c <= '\u25d1' || c >= '\u25e2' && c <= '\u25e5' || c == '\u25ef' || c >= '\u2605' && c <= '\u2606' || c == '\u2609' || c >= '\u260e' && c <= '\u260f' || c == '\u261c' || c == '\u261e' || c == '\u2640' || c == '\u2642' || c >= '\u2660' && c <= '\u2661' || c >= '\u2663' && c <= '\u2665' || c >= '\u2667' && c <= '\u266a' || c >= '\u266c' && c <= '\u266d' || c == '\u266f' || c == '\u273d' || c >= '\u2776' && c <= '\u277f' || c >= '\u2e80' && c <= '\u2e99' || c >= '\u2e9b' && c <= '\u2ef3' || c >= '\u2f00' && c <= '\u2fd5' || c >= '\u2ff0' && c <= '\u2ffb' || c >= '\u3000' && c <= '\u303e' || c >= '\u3041' && c <= '\u3096' || c >= '\u3099' && c <= '\u30ff' || c >= '\u3105' && c <= '\u312c' || c >= '\u3131' && c <= '\u318e' || c >= '\u3190' && c <= '\u31b7' || c >= '\u31f0' && c <= '\u321c' || c >= '\u3220' && c <= '\u3243' || c >= '\u3251' && c <= '\u327b' || c >= '\u327f' && c <= '\u32cb' || c >= '\u32d0' && c <= '\u32fe' || c >= '\u3300' && c <= '\u3376' || c >= '\u337b' && c <= '\u33dd' || c >= '\u33e0' && c <= '\u33fe' || c >= '\u3400' && c <= '\u4db5' || c >= '\u4e00' && c <= '\u9fa5' || c >= '\ua000' && c <= '\ua48c' || c >= '\ua490' && c <= '\ua4c6' || c >= '\uac00' && c <= '\ud7a3' || c >= '\ud800' && c <= '\udb7f' || c >= '\udb80' && c <= '\udbff' || c >= '\udc00' && c <= '\udfff' || c >= '\ue000' && c <= '\uf8ff' || c >= '\uf900' && c <= '\ufa2d' || c >= '\ufa30' && c <= '\ufa6a' || c >= '\ufe00' && c <= '\ufe0f' || c >= '\ufe30' && c <= '\ufe46' || c >= '\ufe49' && c <= '\ufe52' || c >= '\ufe54' && c <= '\ufe66' || c >= '\ufe68' && c <= '\ufe6b' || c >= '\uff01' && c <= '\uff60' || c >= '\uffe0' && c <= '\uffe6' || c == '\ufffd';
    }

    @Override
    public void showProgress(String string, int n) {
        if (!isql.options.quiet) {
            if (string != null) {
                System.out.print(string);
                System.out.print("\r");
                this._longestStatusMessage = Math.max(this._longestStatusMessage, this.getStringLengthInEms(string));
            } else {
                StringBuffer stringBuffer = new StringBuffer(this._longestStatusMessage);
                for (int i = 0; i < this._longestStatusMessage; ++i) {
                    stringBuffer.append(" ");
                }
                System.out.println(stringBuffer.toString());
                this._longestStatusMessage = 0;
            }
        }
    }

    @Override
    public void setStatus(Object object, String string) {
    }

    @Override
    public void displayTable(String string, String[] stringArray, String[][] stringArray2) {
        if (!isql.options.quiet) {
            System.out.println(string);
            System.out.println();
            int n = stringArray2.length;
            int n2 = stringArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    stringBuffer.append(stringArray2[i][j]);
                    if (j >= n2 - 1) continue;
                    stringBuffer.append(" = ");
                }
                System.out.println(stringBuffer.toString());
                stringBuffer.setLength(0);
            }
        }
    }

    private void beep() {
        ISQLConnection iSQLConnection = isql.getConnectionFromIO(this);
        if (iSQLConnection == null || Preferences.getBooleanOption(iSQLConnection, "bell")) {
            // empty if block
        }
    }
}

