/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

class DataTypeMetaData {
    public static final int MAX_LENGTH = 1;
    public static final int PRECISION = 2;
    public static final int SCALE = 4;
    private int _sqlType;
    private String _name;
    private int _maxPrecision;
    private int _minScale;
    private int _maxScale;
    private boolean _isUnsigned;
    private int _annotationFlags;

    DataTypeMetaData(int n, String string, int n2, int n3, int n4, boolean bl, String string2) {
        this._sqlType = n;
        this._name = string;
        this._maxPrecision = n2;
        this._minScale = n3;
        this._maxScale = n4;
        this._isUnsigned = bl;
        this._annotationFlags = 0;
        if (string2 != null) {
            String[] stringArray = string2.split("[,]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                if (string3.equalsIgnoreCase("max length") || string3.equalsIgnoreCase("length")) {
                    this._annotationFlags |= 1;
                    continue;
                }
                if (string3.equalsIgnoreCase("precision")) {
                    this._annotationFlags |= 2;
                    continue;
                }
                if (!string3.equalsIgnoreCase("scale")) continue;
                this._annotationFlags |= 4;
            }
        }
        if (string.equals("char")) {
            this._sqlType = 1;
        }
        if (string.equals("time")) {
            this._sqlType = 92;
        }
        if (string.equals("date")) {
            this._sqlType = 91;
        }
        if (string.equals("timestamp")) {
            this._sqlType = 93;
        }
        if (string.equals("decimal")) {
            this._maxScale = 127;
        }
        if (string.equals("numeric")) {
            this._maxScale = 127;
        }
        if (string.equals("nvarchar") && n == 12 && this._annotationFlags == 0) {
            this._annotationFlags = 1;
        }
    }

    public String toString() {
        return this._name;
    }

    int getSQLType() {
        return this._sqlType;
    }

    String getName() {
        return this._name;
    }

    int getMaxPrecision() {
        return this._maxPrecision;
    }

    int getMinScale() {
        return this._minScale;
    }

    int getMaxScale() {
        return this._maxScale;
    }

    boolean isUnsigned() {
        return this._isUnsigned;
    }

    int getAnnotationFlags() {
        return this._annotationFlags;
    }
}

