/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.SybCheckBoxMenuItem;
import com.sybase.util.SybMenuItem;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import sybase.isql.AcceleratorFirer;
import sybase.isql.DynamicMenuInfo;
import sybase.isql.GuardSeparator;
import sybase.isql.ISQLJMenu;
import sybase.isql.ParentFrame;

class DynamicMenu
extends ISQLJMenu {
    private DynamicMenuInfo[] _items;
    private ParentFrame _parent;
    private boolean _populated = false;

    DynamicMenu(ParentFrame parentFrame, String string, String string2, DynamicMenuInfo[] dynamicMenuInfoArray) {
        super(string2, string);
        this._parent = parentFrame;
        this._items = dynamicMenuInfoArray;
        if (dynamicMenuInfoArray != null) {
            this.installAccelerators(dynamicMenuInfoArray);
        }
    }

    private void installAccelerators(DynamicMenuInfo[] dynamicMenuInfoArray) {
        JRootPane jRootPane = this._parent.getRootPane();
        for (int i = 0; i < dynamicMenuInfoArray.length; ++i) {
            DynamicMenuInfo dynamicMenuInfo = dynamicMenuInfoArray[i];
            if (dynamicMenuInfo.type == 1) {
                if (dynamicMenuInfo.accelerator == 0) continue;
                KeyStroke keyStroke = KeyStroke.getKeyStroke(dynamicMenuInfo.accelerator, dynamicMenuInfo.modifiers);
                jRootPane.registerKeyboardAction(new AcceleratorFirer(dynamicMenuInfo.action), keyStroke, 2);
                continue;
            }
            if (dynamicMenuInfo.type != 4) continue;
            this.installAccelerators(dynamicMenuInfo.items);
        }
    }

    void destroy() {
        if (this._items != null) {
            JRootPane jRootPane = this._parent.getRootPane();
            for (int i = 0; i < this._items.length; ++i) {
                if (this._items[i].type == 1 && this._items[i].accelerator != 0) {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(this._items[i].accelerator, this._items[i].modifiers);
                    jRootPane.unregisterKeyboardAction(keyStroke);
                }
                this._items[i] = null;
            }
            this._items = null;
        }
        this._parent = null;
    }

    protected void fireMenuSelected() {
        if (!this._populated) {
            this._populated = true;
            this.populate();
        }
        super.fireMenuSelected();
    }

    private void populate() {
        DynamicMenuInfo[] dynamicMenuInfoArray = this._items;
        block7: for (int i = 0; i < dynamicMenuInfoArray.length; ++i) {
            DynamicMenuInfo dynamicMenuInfo = dynamicMenuInfoArray[i];
            switch (dynamicMenuInfo.type) {
                case 1: {
                    KeyStroke keyStroke;
                    Action action = dynamicMenuInfo.action;
                    SybMenuItem sybMenuItem = new SybMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
                    sybMenuItem.setAction(action);
                    if (dynamicMenuInfo.accelerator != 0) {
                        keyStroke = KeyStroke.getKeyStroke(dynamicMenuInfo.accelerator, dynamicMenuInfo.modifiers);
                        sybMenuItem.setAccelerator(keyStroke);
                    }
                    this._parent.registerMenuItem((JMenuItem)sybMenuItem, action);
                    this.add((JMenuItem)sybMenuItem);
                    continue block7;
                }
                case 5: {
                    KeyStroke keyStroke;
                    Action action = dynamicMenuInfo.action;
                    SybCheckBoxMenuItem sybCheckBoxMenuItem = new SybCheckBoxMenuItem((String)action.getValue("Name"));
                    sybCheckBoxMenuItem.setAction(action);
                    sybCheckBoxMenuItem.setIcon(null);
                    if (dynamicMenuInfo.accelerator != 0) {
                        keyStroke = KeyStroke.getKeyStroke(dynamicMenuInfo.accelerator, dynamicMenuInfo.modifiers);
                        sybCheckBoxMenuItem.setAccelerator(keyStroke);
                    }
                    this._parent.registerMenuItem((JMenuItem)sybCheckBoxMenuItem, action);
                    this.add((JMenuItem)sybCheckBoxMenuItem);
                    continue block7;
                }
                case 4: {
                    DynamicMenu dynamicMenu = new DynamicMenu(this._parent, dynamicMenuInfo.text, dynamicMenuInfo.text, dynamicMenuInfo.items);
                    this._parent.registerMenu((JMenu)((Object)dynamicMenu));
                    this.add((JMenuItem)((Object)dynamicMenu));
                    continue block7;
                }
                case 2: {
                    this.addSeparator();
                    continue block7;
                }
                case 3: {
                    this.add(new GuardSeparator());
                }
            }
        }
    }
}

