/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLResource;
import sybase.isql.SQLTextComponent;

class EditorRowHeader
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int HEIGHT = 2146483647;
    private static final int MARGIN = 5;
    private int _fontLineHeight;
    private int _currentRowWidth = 0;
    private FontMetrics _fontMetrics;
    private SQLTextComponent _component;
    private int _dragSelectionAnchorLine = -1;
    private JPopupMenu _contextMenu = null;
    private int _contextMenuLine = 0;

    EditorRowHeader(SQLTextComponent sQLTextComponent) {
        this._component = sQLTextComponent;
        Color color = sQLTextComponent.getSelectionColor();
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 25);
        this.setBackground(color);
        this.setForeground(sQLTextComponent.getForeground());
        this.updateFont(sQLTextComponent.getFont());
        this.setPreferredSize(9999);
        sQLTextComponent.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
                EditorRowHeader.this.updateFont(jTextComponent.getFont());
            }
        });
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void destroy() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this._component = null;
        if (this._contextMenu != null) {
            this._contextMenu.setVisible(false);
            this._contextMenu = null;
        }
    }

    private void updateFont(Font font) {
        Font font2 = UIManager.getFont("Label.font");
        this.setFont(font2.deriveFont(0, font.getSize()));
        this._fontMetrics = this.getFontMetrics(font);
        this._fontLineHeight = this._fontMetrics.getHeight();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = this._fontLineHeight;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(SystemColor.controlDkShadow);
        int n2 = 10 + this._currentRowWidth - 1;
        graphics.drawLine(n2, rectangle.y, n2, rectangle.y + rectangle.height);
        int n3 = rectangle.y / n;
        int n4 = n3 + rectangle.height / n + 1;
        int n5 = n3 * n;
        Rectangle2D rectangle2D = this._fontMetrics.getStringBounds("0123456789", graphics);
        int n6 = n - (int)rectangle2D.getHeight();
        for (int i = n3; i < n4; ++i) {
            String string = String.valueOf(i + 1);
            int n7 = this._fontMetrics.stringWidth(string);
            graphics.drawString(string, 5 + this._currentRowWidth - n7, n5 + n - n6);
            n5 += n;
        }
        this.setPreferredSize(n4);
    }

    private void setPreferredSize(int n) {
        int n2 = this._fontMetrics.stringWidth(String.valueOf(n));
        if (this._currentRowWidth < n2) {
            this._currentRowWidth = n2;
            super.setPreferredSize(new Dimension(10 + n2, 2146483647));
        }
    }

    private void selectLineUnderMouse(int n, boolean bl) {
        this._component.setSelectedLines(n, n, bl);
    }

    private void openContextMenu(Point point) {
        this._contextMenu = this.createContextMenu();
        this._contextMenuLine = point.y / this._fontLineHeight;
        UIUtils.showJPopupMenu((JPopupMenu)this._contextMenu, (JComponent)this, (Point)point);
    }

    private JPopupMenu createContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        SybMenuItem sybMenuItem = new SybMenuItem(ISQLResource.getISQLString(GeneralResources.getName(), "EDITOR_MENU_SELECT_STATEMENT"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorRowHeader.this._component.requestFocusInWindow();
                EditorRowHeader.this._component.selectStatement(EditorRowHeader.this._contextMenuLine);
            }
        });
        jPopupMenu.add((JMenuItem)sybMenuItem);
        sybMenuItem = new SybMenuItem(ISQLResource.getISQLString(GeneralResources.getName(), "EDITOR_MENU_SELECT_LINE"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorRowHeader.this._component.requestFocusInWindow();
                EditorRowHeader.this._component.setSelectedLines(EditorRowHeader.this._contextMenuLine, EditorRowHeader.this._contextMenuLine, false);
            }
        });
        jPopupMenu.add((JMenuItem)sybMenuItem);
        return jPopupMenu;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this._component.selectStatement(mouseEvent.getY() / this._fontLineHeight);
        } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
            this.openContextMenu(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            this.selectLineUnderMouse(mouseEvent.getY() / this._fontLineHeight, mouseEvent.isShiftDown());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._dragSelectionAnchorLine = -1;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getY() / this._fontLineHeight;
        if (this._dragSelectionAnchorLine == -1) {
            int n2;
            int n3 = this._component.getSelectionStart();
            if (n3 != (n2 = this._component.getSelectionEnd())) {
                Point point = this._component.getCaretLineAndColumn(n3);
                this._dragSelectionAnchorLine = point.y - 1;
            } else {
                this._dragSelectionAnchorLine = n;
            }
        }
        this._component.setSelectedLines(this._dragSelectionAnchorLine, n, false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

