/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Set;

class EncodingDetector {
    private static final String[] MBCSEncodings = new String[]{"windows-31j", "x-windows-949", "x-windows-950", "Shift_JIS", "x-mswin-936", "GBK", "GB18030", "UTF-8"};
    private static final String[] SBCSEncodingMaps = new String[]{"Cp437", "22222222222222222222222222211112222222111111111111111111111111111111111111111111111111111111111122222222222221111111111111111111", "Cp850", "22222222222222222222222222211112222222111111111111111222111111111111112211111111222222222111112122222222222222111111111111111111", "windows-1250", "00101111012122220111111101212222111212111121111211121211122121222222222222222222222222212222222222222222222222222222222122222221", "windows-1251", "22121111012122222111111101212222122212112121111211222211222122222222222222222222222222222222222222222222222222222222222222222222", "windows-1252", "20121111112120200111111111212022111111111111111111111111111111112222222222222222222222212222222222222222222222222222222122222222", "windows-1253", "00121111010100000111111101010000112111111111111111111211222121222222222222222222220222222222222222222222222222222222222222222220", "windows-1254", "00121111112120000111111111212002111111111111111111111211111111112222222222222222222222212222222222222222222222222222222122222222", "windows-1255", "00121111110100000111111111010000101121111101111111111211010111101111111111011111211122200000000022222222222222222222222222200110", "windows-1256", "02121111110122202111111101012110111111111101111111111111111111112222222222222222222222212222222222222222222222221111211112122110", "windows-1257", "00101111010100000111111101010000111110111121111211111111112111122222222222222222222222212222222222222222222222222222222122222221", "ISO-8859-1", "00000000000000000000000000000000111111111111111111111111111111112222222222222222222222212222222222222222222222222222222122222222"};
    private File _file = null;
    private String _encoding = null;

    EncodingDetector(File file) {
        this._file = file;
        this._encoding = this.guessEncodingForFile();
    }

    boolean isDefinitelyUsingDefaultEncoding() {
        String string;
        boolean bl = this._encoding == null ? true : this.areEncodingsSame(string = System.getProperty("file.encoding"), this._encoding);
        return bl;
    }

    private boolean areEncodingsSame(String string, String string2) {
        boolean bl;
        block7: {
            bl = false;
            if (string.equalsIgnoreCase(string2)) {
                bl = true;
            } else {
                try {
                    Charset charset = Charset.forName(string);
                    if (charset.name().equalsIgnoreCase(string2)) {
                        bl = true;
                        break block7;
                    }
                    Set<String> set = charset.aliases();
                    Object[] objectArray = set.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!string2.equalsIgnoreCase(objectArray[i].toString())) continue;
                        bl = true;
                        break;
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    String getEncoding() {
        return this._encoding;
    }

    void destroy() {
        this._file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessEncodingForFile() {
        String string;
        boolean bl;
        block53: {
            boolean bl2;
            Object object;
            int n;
            int n2;
            FileInputStream fileInputStream;
            block52: {
                bl = false;
                string = null;
                fileInputStream = null;
                BufferedInputStream bufferedInputStream = null;
                try {
                    fileInputStream = new FileInputStream(this._file);
                    byte[] byArray = new byte[3];
                    n2 = fileInputStream.read(byArray, 0, 3);
                    if (n2 >= 2 && (byArray[0] == -1 && byArray[1] == -2 || byArray[0] == -2 && byArray[1] == -1)) {
                        string = "UTF-16";
                        bl = true;
                    }
                    if (!bl && n2 == 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                        string = "UTF-8";
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        fileInputStream = null;
                    }
                }
                if (!bl) {
                    try {
                        bl = true;
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(this._file));
                        do {
                            if ((n = bufferedInputStream.read()) != -1) continue;
                            break block52;
                        } while ((n & 0x80) == 0);
                        bl = false;
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (bufferedInputStream != null) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (IOException iOException) {}
                            bufferedInputStream = null;
                        }
                    }
                }
            }
            String string2 = System.getProperty("file.encoding");
            try {
                object = Charset.forName(string2);
                CharsetEncoder charsetEncoder = ((Charset)object).newEncoder();
                bl2 = charsetEncoder.maxBytesPerChar() != 1.0f;
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                bl2 = false;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                bl2 = false;
            }
            if (!bl) {
                int n3 = (int)this._file.length();
                object = new byte[n3];
                try {
                    int n4;
                    fileInputStream = new FileInputStream(this._file);
                    n2 = fileInputStream.read((byte[])object, 0, n3);
                    if (bl2 && this.canReadWithEncoding((byte[])object, n2, string2)) {
                        string = null;
                        bl = true;
                    }
                    if (!bl && (n = this.getPercentASCII((byte[])object, n2)) > 5 && n < 95) {
                        for (n4 = 0; n4 < MBCSEncodings.length; ++n4) {
                            if (!this.canReadWithEncoding((byte[])object, n2, MBCSEncodings[n4])) continue;
                            string = MBCSEncodings[n4];
                            bl = true;
                            break;
                        }
                    }
                    if (bl) break block53;
                    int n5 = 0;
                    int[] nArray = new int[SBCSEncodingMaps.length];
                    Arrays.fill(nArray, 0);
                    for (n4 = 0; n4 < SBCSEncodingMaps.length / 2; ++n4) {
                        String string3 = SBCSEncodingMaps[n4 + n4 + 1];
                        nArray[n4] = this.getScore(string3, (byte[])object);
                        n5 = Math.max(nArray[n4], n5);
                    }
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        if (nArray[n4] != n5 || !this.areEncodingsSame(SBCSEncodingMaps[n4 + n4], string2)) continue;
                        string = null;
                        bl = true;
                        break;
                    }
                    if (bl) break block53;
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        if (nArray[n4] != n5) continue;
                        string = SBCSEncodingMaps[n4 + n4];
                        bl = true;
                        break;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        fileInputStream = null;
                    }
                }
            }
        }
        if (!bl) {
            string = "";
        }
        return string;
    }

    int getScore(String string, byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (n2 < 128) continue;
            if ((n2 = (int)string.charAt(n2 - 128)) == 48) {
                n = -1;
                break;
            }
            if (n2 == 49) {
                ++n;
                continue;
            }
            n += 5;
        }
        return n;
    }

    private boolean canReadWithEncoding(byte[] byArray, int n, String string) {
        boolean bl = false;
        CharBuffer charBuffer = CharBuffer.allocate(n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put(byArray, 0, n);
        byteBuffer.flip();
        CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
        charsetDecoder.reset();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
        if (coderResult == CoderResult.UNDERFLOW || coderResult == CoderResult.OVERFLOW) {
            bl = true;
        }
        return bl;
    }

    private int getPercentASCII(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < 0) continue;
            ++n2;
        }
        return n2 * 100 / n;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

