/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sybase.isql.EncodingDialogResources;
import sybase.isql.EncodingDialogResourcesBase;
import sybase.isql.ISQLResource;
import sybase.isql.InputOutputOptions;

class EncodingDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static byte[] _fileContents = null;
    private static String _encoding = null;
    private static String _userSelectedEncoding = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _showMoreEncodings = null;
    private JList _encodings = null;
    private SybTextArea _preview = null;
    private Font _defaultFont = null;
    private Font[] _fontList = null;
    private boolean _showingAllEncodings = false;
    private String _initialEncoding = null;

    static String create(JFrame jFrame, String string, File file, String string2, String string3) {
        EncodingDialog encodingDialog = new EncodingDialog(jFrame, string, file, string2, string3);
        encodingDialog.setVisible(true);
        encodingDialog.destroy();
        return _encoding;
    }

    private EncodingDialog(JFrame jFrame, String string, File file, String string2, String string3) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._initialEncoding = string2;
        _userSelectedEncoding = string3;
        EncodingDialogResourcesBase encodingDialogResourcesBase = (EncodingDialogResourcesBase)ISQLResource.getISQLResource(EncodingDialogResources.getName());
        int n = (int)file.length();
        n = Math.min(n, 4000000);
        _fileContents = new byte[n];
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedInputStream.read(_fileContents, 0, n);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            _fileContents = new byte[0];
            SybOptionPane.showMessageDialog((Component)this, (Object)EncodingDialogResources.getFormattedString(EncodingDialogResources.getName(), "ErrorReadingFile", file.getName(), iOException.getLocalizedMessage()), (String)string, (int)0);
        }
        this._preview = new SybTextArea(8, 60);
        this._preview.setEditable(false);
        this._preview.setTabMovesFocus(true);
        this._preview.setAlignmentX(0.0f);
        this._defaultFont = this._preview.getFont();
        Vector<String> vector = this.getEncodingList();
        this._encodings = new JList<String>(vector);
        this._encodings.setVisibleRowCount(6);
        this._showMoreEncodings = new SybButton(encodingDialogResourcesBase.getISQLString("ShowFewerEncodings"));
        this._showMoreEncodings.addActionListener((ActionListener)this);
        Dimension dimension = this._showMoreEncodings.getPreferredSize();
        this._showMoreEncodings.setText(encodingDialogResourcesBase.getISQLString("ShowMoreEncodings"));
        Dimension dimension2 = this._showMoreEncodings.getPreferredSize();
        dimension.width = Math.max(dimension.width, dimension2.width);
        dimension.height = Math.max(dimension.height, dimension2.height);
        this._showMoreEncodings.setPreferredSize(dimension);
        this._showMoreEncodings.setMinimumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this._showMoreEncodings);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        jPanel.setAlignmentX(0.0f);
        this._ok = new SybButton(encodingDialogResourcesBase.getISQLString("OK"));
        this._cancel = new SybButton(encodingDialogResourcesBase.getISQLString("CANCEL"));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._ok);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._cancel);
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SybLabel sybLabel = new SybLabel(encodingDialogResourcesBase.getISQLString("ChooseEncoding"));
        sybLabel.setLabelFor((Component)this._encodings);
        jPanel3.add((Component)sybLabel);
        jPanel3.add(Box.createVerticalStrut(3));
        JScrollPane jScrollPane = new JScrollPane(this._encodings);
        jScrollPane.setAlignmentX(0.0f);
        jPanel3.add(jScrollPane);
        jPanel3.add(jPanel);
        jPanel3.add(Box.createVerticalStrut(10));
        sybLabel = new SybLabel(encodingDialogResourcesBase.getISQLString("Preview"));
        sybLabel.setLabelFor((Component)this._preview);
        jPanel3.add((Component)sybLabel);
        jPanel3.add(Box.createVerticalStrut(3));
        jScrollPane = new JScrollPane((Component)this._preview);
        jScrollPane.setAlignmentX(0.0f);
        jPanel3.add(jScrollPane);
        jPanel3.add(Box.createVerticalStrut(10));
        jPanel3.add(jPanel2);
        this.getContentPane().add(jPanel3);
        this._ok.addActionListener((ActionListener)this);
        this._cancel.addActionListener((ActionListener)this);
        this._encodings.addListSelectionListener(this);
        if (string2 == null || string2.length() == 0) {
            this._encodings.setSelectedIndex(0);
        } else {
            this._encodings.setSelectedValue(string2, true);
        }
        this.setTitle(string);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(jFrame);
    }

    private void destroy() {
        this._fontList = null;
        _fileContents = null;
        this._preview = null;
        if (this._encodings != null) {
            this._encodings.removeListSelectionListener(this);
            this._encodings = null;
        }
        if (this._showMoreEncodings != null) {
            this._showMoreEncodings.removeActionListener((ActionListener)this);
            this._showMoreEncodings = null;
        }
        if (this._ok != null) {
            this.getRootPane().setDefaultButton(null);
            this._ok.removeActionListener((ActionListener)this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    private Vector<String> getEncodingList() {
        Vector<String> vector = InputOutputOptions.getEncodingListForDisplay(this._showingAllEncodings, _userSelectedEncoding);
        if (this._initialEncoding != null && this._initialEncoding.length() != 0 && !vector.contains(this._initialEncoding)) {
            vector.add(this._initialEncoding);
        }
        return vector;
    }

    private void handleShowMoreEncodings() {
        boolean bl = this._showingAllEncodings = !this._showingAllEncodings;
        if (this._showingAllEncodings) {
            this._showMoreEncodings.setText(ISQLResource.getISQLString(EncodingDialogResources.getName(), "ShowFewerEncodings"));
        } else {
            this._showMoreEncodings.setText(ISQLResource.getISQLString(EncodingDialogResources.getName(), "ShowMoreEncodings"));
        }
        Object e = this._encodings.getSelectedValue();
        this._encodings.setListData(this.getEncodingList());
        if (e != null) {
            this._encodings.setSelectedValue(e, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.setVisible(false);
            _encoding = this._encodings.getSelectedIndex() == 0 ? null : this._encodings.getSelectedValue().toString();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.setVisible(false);
            _encoding = "";
        } else if (object == this._showMoreEncodings) {
            this.handleShowMoreEncodings();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            Object e = this._encodings.getSelectedValue();
            boolean bl = e != null;
            this._ok.setEnabled(bl);
            if (bl) {
                if (this._encodings.getSelectedIndex() == 0) {
                    this.updatePreview(null);
                } else {
                    this.updatePreview(e.toString());
                }
            }
        }
    }

    private void updatePreview(String string) {
        int n;
        String string2;
        if (string != null) {
            try {
                int n2;
                int n3;
                if ((string.equalsIgnoreCase("utf8") || string.equalsIgnoreCase("utf-8")) && _fileContents.length > 3 && _fileContents[0] == -17 && _fileContents[1] == -69 && _fileContents[2] == -65) {
                    n3 = 3;
                    n2 = _fileContents.length - 3;
                } else {
                    n3 = 0;
                    n2 = _fileContents.length;
                }
                string2 = new String(_fileContents, n3, n2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = null;
            }
        } else {
            string2 = new String(_fileContents);
        }
        if (string2 != null) {
            for (n = 0; n < string2.length(); ++n) {
                char c = string2.charAt(n);
                if (Character.isDefined(c)) continue;
                string2 = null;
                break;
            }
        }
        if (string2 != null) {
            this._preview.setText(string2);
            this._preview.setCaretPosition(0);
            this._preview.setForeground((Color)SystemColor.controlText);
        } else {
            string2 = ISQLResource.getISQLString(EncodingDialogResources.getName(), "17");
            this._preview.setText(string2);
            this._preview.setForeground((Color)SystemColor.textInactiveText);
        }
        boolean bl = false;
        int n4 = -1;
        int n5 = 0;
        if (this._defaultFont.canDisplayUpTo(string2) == -1) {
            if (!this._preview.getFont().equals(this._defaultFont)) {
                this._preview.setFont(this._defaultFont);
            }
            bl = true;
        } else if (this._preview.getFont().canDisplayUpTo(string2) != -1) {
            if (this._fontList == null) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this._fontList = graphicsEnvironment.getAllFonts();
            }
            for (n = 0; n < this._fontList.length; ++n) {
                int n6 = this._fontList[n].canDisplayUpTo(string2);
                if (n6 == -1) {
                    this._preview.setFont(this._fontList[n].deriveFont(this._defaultFont.getStyle(), this._defaultFont.getSize()));
                    bl = true;
                    break;
                }
                if (n6 <= n5) continue;
                n4 = n;
                n5 = n6;
            }
        }
        if (!bl && n4 >= 0) {
            this._preview.setFont(this._fontList[n4].deriveFont(this._defaultFont.getStyle(), this._defaultFont.getSize()));
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

