/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.asa.logon.LogonDialogClient;
import com.sybase.asa.logon.LogonSource;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.KeySelectionHelper;
import com.sybase.util.MRUComboBox;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;
import sybase.isql.GeneralResources;
import sybase.isql.HistoryItem;
import sybase.isql.IO;
import sybase.isql.IOFilter;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.InputOutputOptions;
import sybase.isql.InputStatementWizard;
import sybase.isql.LimitedTextField;
import sybase.isql.ODBCExporter;
import sybase.isql.OutputStatement;
import sybase.isql.ParentFrame;
import sybase.isql.ParserUtils;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;
import sybase.isql.isql;

class ExportWizard
extends JDialog
implements ActionListener {
    private static final String SHOW_NEXT_BUTTON = "Next";
    private static final String SHOW_EXPORT_BUTTON = "Export";
    private static final String SHOW_ABORT_BUTTON = "Abort";
    private static final String SHOW_CLOSE_BUTTON = "Close";
    private static final String FORMAT_PAGE = "FORMAT_PAGE";
    private static final String FILE_PAGE = "FILE_PAGE";
    private static final String DSN_PAGE = "DSN_PAGE";
    private static final String TABLE_PAGE = "TABLE_PAGE";
    private static final String STATUS_PAGE = "STATUS_PAGE";
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private ISQLResource _bundle;
    private ISQLConnectionImpl _connection;
    private ISQLResultSet[] _resultSets = null;
    private String _mruFileNameList;
    private String _mruDSNList;
    private String _mruDriverList;
    private int _format = 1;
    private String _dstFileName;
    private String _dstDelimiter;
    private String _dstEncoding;
    private String _dstEscapeCharacter;
    private ISQLPlugin _dstPlugin;
    private String _dstConnectionParameters;
    private String _secureDstConnectionParameters;
    private String _dstTableCatalog;
    private String _dstTableOwner;
    private String _dstTableName;
    private boolean _createDestinationTable;
    private String _dstQuoteString;
    private boolean _dstSQLNeedsSchema = false;
    private boolean _dstSQLNeedsCatalog = false;
    private Connection _dstConnection;
    private ArrayList<TableInfo> _dstTables;
    private JPanel _pagePanel;
    private CardLayout _pagePanelLayout;
    private SybButton _back;
    private SybButton _next;
    private SybButton _export;
    private SybButton _cancel;
    private SybButton _abort;
    private SybButton _close;
    private CardLayout _nextOrExportPanelLayout;
    private JPanel _nextOrExportPanel;
    private boolean _aborted = false;

    static void create(JFrame jFrame, ISQLConnectionImpl iSQLConnectionImpl) {
        ISQLResultSet[] iSQLResultSetArray = OutputStatement.getResultSetsForLastStatement(iSQLConnectionImpl);
        if (iSQLResultSetArray == null || iSQLResultSetArray.length == 0) {
            SybOptionPane.showMessageDialog((Component)jFrame, (Object)ISQLResource.getISQLString(GeneralResources.getName(), "EW_NOTHING_TO_EXPORT"), (String)ISQLResource.getISQLString(GeneralResources.getName(), "EDExportTitle"), (int)0);
            return;
        }
        ExportWizard exportWizard = new ExportWizard(jFrame, iSQLConnectionImpl, iSQLResultSetArray);
        UIUtils.ensureWindowIsVisible((Window)exportWizard);
        exportWizard.setVisible(true);
        exportWizard.destroy();
    }

    static String sanitizeString(String string) {
        int n;
        if (string != null && (n = string.indexOf(0)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private ExportWizard(JFrame jFrame, ISQLConnectionImpl iSQLConnectionImpl, ISQLResultSet[] iSQLResultSetArray) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._resultSets = iSQLResultSetArray;
        this._connection = iSQLConnectionImpl;
        JPanel jPanel = new JPanel(new BorderLayout());
        this._bundle = ISQLResource.getISQLResource(GeneralResources.getName());
        this._dstDelimiter = Preferences.getStringOption(iSQLConnectionImpl, "ISQL_field_separator");
        this._dstEncoding = Preferences.getStringOption(iSQLConnectionImpl, "defaultISQLEncoding");
        String string = Preferences.getStringOption(iSQLConnectionImpl, "ISQL_escape_character");
        this._dstEscapeCharacter = string != null && string.length() == 1 ? string : null;
        this._mruFileNameList = Preferences.getExportWizardMRUFileNameList();
        this._mruDSNList = Preferences.getExportWizardMRUDSNList();
        this._mruDriverList = Preferences.getExportWizardMRUDriverList();
        this._pagePanelLayout = new CardLayout();
        this._pagePanel = new JPanel(this._pagePanelLayout);
        this._pagePanel.add((Component)new FormatPage(), FORMAT_PAGE);
        this._pagePanel.add((Component)new FilePage(), FILE_PAGE);
        this._pagePanel.add((Component)new DSNPage(), DSN_PAGE);
        this._pagePanel.add((Component)new TablePage(), TABLE_PAGE);
        this._pagePanel.add((Component)new StatusPage(), STATUS_PAGE);
        this._pagePanelLayout.show(this._pagePanel, FORMAT_PAGE);
        this.getSelectedPage().refresh();
        jPanel.add((Component)this._pagePanel, "Center");
        this._cancel = new SybButton(this._bundle.getISQLString("EDCancelButton"));
        this._cancel.setDefaultCapable(false);
        this._cancel.addActionListener((ActionListener)this);
        this._back = new SybButton(this._bundle.getISQLString("EW_BACK_BUTTON"));
        this._back.setEnabled(false);
        this._back.addActionListener((ActionListener)this);
        this._next = new SybButton(this._bundle.getISQLString("EW_NEXT_BUTTON"));
        this._next.addActionListener((ActionListener)this);
        this._export = new SybButton(this._bundle.getISQLString("EW_EXPORT_BUTTON"));
        this._export.addActionListener((ActionListener)this);
        this._abort = new SybButton(this._bundle.getISQLString("EW_ABORT_BUTTON"));
        this._abort.addActionListener((ActionListener)this);
        this._close = new SybButton(this._bundle.getISQLString("EW_CLOSE_BUTTON"));
        this._close.addActionListener((ActionListener)this);
        this._nextOrExportPanelLayout = new CardLayout();
        this._nextOrExportPanel = new JPanel(this._nextOrExportPanelLayout);
        this._nextOrExportPanel.add((Component)this._next, SHOW_NEXT_BUTTON);
        this._nextOrExportPanel.add((Component)this._export, SHOW_EXPORT_BUTTON);
        this._nextOrExportPanel.add((Component)this._abort, SHOW_ABORT_BUTTON);
        this._nextOrExportPanel.add((Component)this._close, SHOW_CLOSE_BUTTON);
        Dimension dimension = this._nextOrExportPanel.getMinimumSize();
        this._nextOrExportPanel.setMaximumSize(dimension);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._back, this._next, this._export, this._cancel});
        this.getRootPane().setDefaultButton((JButton)this._next);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._back);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._nextOrExportPanel);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._cancel);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.setTitle(this._bundle.getISQLString("EDExportTitle"));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(jFrame);
        this.setDefaultCloseOperation(1);
    }

    private void destroy() {
        if (this._dstConnection != null) {
            try {
                this._dstConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._dstConnection = null;
        }
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._connection = null;
        this._resultSets = null;
        this._back.removeActionListener((ActionListener)this);
        this._back = null;
        this._next.removeActionListener((ActionListener)this);
        this._next = null;
        this._export.removeActionListener((ActionListener)this);
        this._export = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._pagePanel = null;
        this._pagePanelLayout = null;
        this._nextOrExportPanel = null;
        this._nextOrExportPanelLayout = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._back) {
            this.handleBack();
        } else if (object == this._next) {
            this.handleNext();
        } else if (object == this._export) {
            this.handleExport();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._abort) {
            this.handleAbort();
        } else if (object == this._close) {
            this.setVisible(false);
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    private Page getSelectedPage() {
        Page page = null;
        Component[] componentArray = this._pagePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            page = (Page)componentArray[i];
            break;
        }
        return page;
    }

    private void handleAbort() {
        this._abort.setEnabled(false);
        ParentFrame parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, this);
        parentFrame.requestInterrupt(1);
        this._aborted = true;
    }

    private void handleBack() {
        Page page = this.getSelectedPage();
        page.commit();
        String string = page.getPreviousPageID();
        this._pagePanelLayout.show(this._pagePanel, string);
        page = this.getSelectedPage();
        page.setInitialFocus();
        this._back.setEnabled(page.getPreviousPageID() != null);
        this._nextOrExportPanelLayout.show(this._nextOrExportPanel, SHOW_NEXT_BUTTON);
        this.getRootPane().setDefaultButton((JButton)this._next);
    }

    private void handleNext() {
        String string;
        Page page = this.getSelectedPage();
        page.commit();
        if (page.validatePage() && (string = page.getNextPageID()) != null) {
            this._pagePanelLayout.show(this._pagePanel, string);
            this._back.setEnabled(true);
            page = this.getSelectedPage();
            page.refresh();
            page.setInitialFocus();
            if (page.getNextPageID() != null) {
                this._nextOrExportPanelLayout.show(this._nextOrExportPanel, SHOW_NEXT_BUTTON);
                this.getRootPane().setDefaultButton((JButton)this._next);
            } else {
                this._nextOrExportPanelLayout.show(this._nextOrExportPanel, SHOW_EXPORT_BUTTON);
                this.getRootPane().setDefaultButton((JButton)this._export);
            }
        }
    }

    private void handleExport() {
        Page page = this.getSelectedPage();
        page.commit();
        if (page.validatePage()) {
            this._back.setEnabled(false);
            this._cancel.setEnabled(false);
            this.setDefaultCloseOperation(0);
            this._pagePanelLayout.show(this._pagePanel, STATUS_PAGE);
            this._nextOrExportPanelLayout.show(this._nextOrExportPanel, SHOW_ABORT_BUTTON);
            page = this.getSelectedPage();
            page.refresh();
            this._nextOrExportPanelLayout.show(this._nextOrExportPanel, SHOW_CLOSE_BUTTON);
            this.setDefaultCloseOperation(1);
            this.getRootPane().setDefaultButton((JButton)this._close);
            ((StatusPage)page).setFocusToMessageList();
        }
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static class WarningIcon
    implements Icon {
        private Stroke _stroke;
        private int _size;

        WarningIcon(int n) {
            this._size = n;
            this._stroke = new BasicStroke(3.0f, 1, 1, 3.0f);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.orange.darker());
            graphics2D.fillOval(0, 0, this._size - 1, this._size - 1);
            graphics2D.setColor(SystemColor.window);
            graphics2D.setStroke(this._stroke);
            graphics2D.drawLine(this._size / 2 - 1, this._size / 4 - 1 + 1, this._size / 2 - 1, this._size * 5 / 8 - 1 - 1);
            graphics2D.drawLine(this._size / 2 - 1, this._size * 3 / 4 - 1, this._size / 2 - 1, this._size * 3 / 4 - 1);
        }

        @Override
        public int getIconWidth() {
            return this._size;
        }

        @Override
        public int getIconHeight() {
            return this._size;
        }
    }

    static class ErrorIcon
    implements Icon {
        private Stroke _stroke;
        private int _size;

        ErrorIcon(int n) {
            this._size = n;
            this._stroke = new BasicStroke(3.0f, 1, 1, 3.0f);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.red.darker());
            graphics2D.fillOval(0, 0, this._size - 1, this._size - 1);
            graphics2D.setColor(SystemColor.window);
            graphics2D.setStroke(this._stroke);
            graphics2D.drawLine(this._size / 4 - 1 + 1, this._size / 4 - 1 + 1, this._size * 3 / 4 - 1 - 1, this._size * 3 / 4 - 1 - 1);
            graphics2D.drawLine(this._size / 4 - 1 + 1, this._size * 3 / 4 - 1 - 1, this._size * 3 / 4 - 1 - 1, this._size / 4 - 1 + 1);
        }

        @Override
        public int getIconWidth() {
            return this._size;
        }

        @Override
        public int getIconHeight() {
            return this._size;
        }
    }

    static class OKIcon
    implements Icon {
        private Stroke _stroke;
        private int _size;
        private int[] _xPoints;
        private int[] _yPoints;

        OKIcon(int n) {
            this._size = n;
            this._stroke = new BasicStroke(3.0f, 1, 1, 3.0f);
            this._xPoints = new int[]{this._size / 4, this._size * 3 / 8, this._size * 3 / 4};
            this._yPoints = new int[]{this._size / 2, this._size * 3 / 4, this._size * 1 / 4};
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.green.darker());
            graphics2D.fillOval(0, 0, this._size - 1, this._size - 1);
            graphics2D.setColor(SystemColor.window);
            graphics2D.setStroke(this._stroke);
            graphics2D.drawPolyline(this._xPoints, this._yPoints, this._xPoints.length);
        }

        @Override
        public int getIconWidth() {
            return this._size;
        }

        @Override
        public int getIconHeight() {
            return this._size;
        }
    }

    static class InstructionLabel
    extends SybLabel {
        InstructionLabel(String string) {
            super(string);
            Font font = this.getFont();
            font = font.deriveFont(1, font.getSize2D() * 1.25f);
            this.setFont(font);
            this.setForeground(SystemColor.textHighlight);
        }
    }

    static class GradientPanel
    extends JPanel {
        private Color _color;

        GradientPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.init();
        }

        GradientPanel() {
            this.init();
        }

        private void init() {
            this.setOpaque(true);
            this.setBackground(SystemColor.window);
            this._color = this.getBackground();
            this.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        }

        void setGradientColor(Color color) {
            int n = color.getRGB();
            int n2 = (n & 0xFF0000) >>> 16;
            int n3 = (n & 0xFF00) >>> 8;
            int n4 = n & 0xFF;
            n = this.getBackground().getRGB();
            int n5 = (n & 0xFF0000) >>> 16;
            int n6 = (n & 0xFF00) >>> 8;
            int n7 = n & 0xFF;
            int n8 = 8;
            int n9 = (n2 - n5) / n8;
            n2 = n9 > 0 ? Math.min(255, n5 + n9) : Math.max(0, n5 + n9);
            n9 = (n3 - n6) / n8;
            n3 = n9 > 0 ? Math.min(255, n6 + n9) : Math.max(0, n6 + n9);
            n9 = (n4 - n7) / n8;
            n4 = n9 > 0 ? Math.min(255, n7 + n9) : Math.max(0, n7 + n9);
            this._color = new Color(n2, n3, n4);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Color color = this.getBackground();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this._color, n, 0.0f, color);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
        }
    }

    class StatusPage
    extends Page {
        private InstructionLabel _iLabel;
        private JProgressBar _progressBar;
        private SybLabel _text;
        private JTextArea _messages;
        private GradientPanel _gradientPanel;

        StatusPage() {
            this._iLabel = new InstructionLabel(ExportWizard.this._bundle.getISQLString("EW_STATUS_PAGE_INSTRUCTION"));
            this._gradientPanel = new GradientPanel(new GridBagLayout());
            this._gradientPanel.setGradientColor(Color.blue);
            this._gradientPanel.add((Component)((Object)this._iLabel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this._gradientPanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            this._text = new SybLabel();
            new FontHelper((JLabel)this._text);
            this._text.setText("MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM");
            Dimension dimension = this._text.getPreferredSize();
            this._text.setMinimumSize(dimension);
            this._text.setText(" ");
            this.add((Component)this._text, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 30, 5, 30), 0, 0));
            this._progressBar = new JProgressBar();
            this._progressBar.setIndeterminate(true);
            this.add((Component)this._progressBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 30, 0, 30), 0, 0));
            this._messages = new JTextArea();
            this._messages.setLineWrap(true);
            this._messages.setWrapStyleWord(true);
            this._messages.setEditable(false);
            this._messages.setFont(this._text.getFont());
            new FontHelper((JTextComponent)this._messages);
            JScrollPane jScrollPane = new JScrollPane(this._messages);
            this.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 21, 1, new Insets(10, 30, 0, 30), 0, 0));
        }

        @Override
        void setInitialFocus() {
            this._messages.requestFocusInWindow();
        }

        @Override
        void refresh() {
            int n;
            boolean bl;
            MyIOFilter myIOFilter = new MyIOFilter(isql.getIO(ExportWizard.this._connection));
            isql.setIO(ExportWizard.this._connection, myIOFilter);
            this.addEquivalentSQLToHistory();
            Vector<String> vector = new Vector<String>();
            if (ExportWizard.this._format == 14) {
                bl = ODBCExporter.export(ExportWizard.this._connection, ExportWizard.this._dstPlugin, ExportWizard.this._dstConnectionParameters, ExportWizard.this._dstTableCatalog, ExportWizard.this._dstTableOwner, ExportWizard.this._dstTableName, ExportWizard.this._createDestinationTable, vector);
            } else {
                InputOutputOptions inputOutputOptions = this.createOptions();
                bl = OutputStatement.execute(ExportWizard.this._connection, inputOutputOptions, vector);
            }
            isql.setIO(ExportWizard.this._connection, myIOFilter.getOriginalIO());
            this._progressBar.setIndeterminate(false);
            this._progressBar.setValue(this._progressBar.getMaximum());
            for (n = 0; n < vector.size(); ++n) {
                myIOFilter.writeln(vector.get(n), 2);
            }
            if (bl) {
                Component[] componentArray = this.getParent().getComponents();
                for (n = 0; n < componentArray.length; ++n) {
                    ((Page)componentArray[n]).updateMRULists();
                }
            }
            if (bl) {
                if (!ExportWizard.this._aborted) {
                    this._gradientPanel.setGradientColor(Color.green);
                    this._iLabel.setText(ExportWizard.this._bundle.getISQLString("EW_EXPORT_COMPLETED"));
                    this._iLabel.setIcon(new OKIcon(24));
                } else {
                    this._gradientPanel.setGradientColor(Color.orange.darker());
                    this._iLabel.setText(ExportWizard.this._bundle.getISQLString("EW_EXPORT_ABORTED"));
                    this._iLabel.setIcon(new WarningIcon(24));
                }
            } else {
                this._gradientPanel.setGradientColor(Color.red);
                this._iLabel.setText(ExportWizard.this._bundle.getISQLString("EW_EXPORT_FAILED"));
                this._iLabel.setIcon(new ErrorIcon(24));
            }
            this._iLabel.setIconTextGap(10);
        }

        private InputOutputOptions createOptions() {
            InputOutputOptions inputOutputOptions = new InputOutputOptions(ExportWizard.this._connection);
            inputOutputOptions.setFormat(ExportWizard.this._format);
            inputOutputOptions.setFileName(ExportWizard.this._dstFileName);
            if (ExportWizard.this._format == 1) {
                if (ExportWizard.this._dstEscapeCharacter != null) {
                    inputOutputOptions.setEscapes(true);
                    inputOutputOptions.setEscapeCharacter(ExportWizard.this._dstEscapeCharacter.charAt(0));
                }
                if (ExportWizard.this._dstDelimiter != null) {
                    inputOutputOptions.setDelimiter(ExportWizard.this._dstDelimiter);
                }
                if (ExportWizard.this._dstEncoding != null) {
                    inputOutputOptions.setEncoding(ExportWizard.this._dstEncoding);
                }
            }
            return inputOutputOptions;
        }

        private void addEquivalentSQLToHistory() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ExportWizard.this._bundle.getISQLString("EW_GENERATED_SQL_COMMENT"));
            stringBuilder.append("output ");
            if (ExportWizard.this._format == 14) {
                stringBuilder.append("using '");
                if (ExportWizard.this._secureDstConnectionParameters != null) {
                    stringBuilder.append(ParserUtils.escapeApostrophes(ExportWizard.this._secureDstConnectionParameters));
                }
                stringBuilder.append("' into ");
                if (ExportWizard.this._dstTableCatalog != null) {
                    if (ExportWizard.this._dstQuoteString != null) {
                        stringBuilder.append(ExportWizard.this._dstQuoteString);
                    }
                    stringBuilder.append(ExportWizard.this._dstTableCatalog);
                    if (ExportWizard.this._dstQuoteString != null) {
                        stringBuilder.append(ExportWizard.this._dstQuoteString);
                    }
                    stringBuilder.append('.');
                }
                if (ExportWizard.this._dstTableOwner != null) {
                    if (ExportWizard.this._dstQuoteString != null) {
                        stringBuilder.append(ExportWizard.this._dstQuoteString);
                    }
                    stringBuilder.append(ExportWizard.this._dstTableOwner);
                    if (ExportWizard.this._dstQuoteString != null) {
                        stringBuilder.append(ExportWizard.this._dstQuoteString);
                    }
                    stringBuilder.append('.');
                }
                if (ExportWizard.this._dstQuoteString != null) {
                    stringBuilder.append(ExportWizard.this._dstQuoteString);
                }
                stringBuilder.append(ExportWizard.this._dstTableName);
                if (ExportWizard.this._dstQuoteString != null) {
                    stringBuilder.append(ExportWizard.this._dstQuoteString);
                }
                stringBuilder.append(" create table ");
                if (ExportWizard.this._createDestinationTable) {
                    stringBuilder.append("on");
                } else {
                    stringBuilder.append("off");
                }
            } else {
                stringBuilder.append("to '");
                stringBuilder.append(ParserUtils.escapeFileName(ExportWizard.this._dstFileName));
                stringBuilder.append("' ");
                if (ExportWizard.this._format == 1) {
                    stringBuilder.append("format ascii");
                    if (ExportWizard.this._dstEscapeCharacter != null) {
                        stringBuilder.append(" escapes on escape character '");
                        stringBuilder.append(ExportWizard.this._dstEscapeCharacter.charAt(0));
                        stringBuilder.append("'");
                    }
                    if (ExportWizard.this._dstDelimiter != null) {
                        stringBuilder.append(" delimited by '");
                        stringBuilder.append(ExportWizard.this._dstDelimiter);
                        stringBuilder.append("'");
                    }
                    if (ExportWizard.this._dstEncoding != null) {
                        stringBuilder.append(" encoding '");
                        stringBuilder.append(ExportWizard.this._dstEncoding);
                        stringBuilder.append("'");
                    }
                } else if (ExportWizard.this._format == 2) {
                    stringBuilder.append("format fixed");
                } else if (ExportWizard.this._format == 3) {
                    stringBuilder.append("format html");
                } else if (ExportWizard.this._format == 13) {
                    stringBuilder.append("format xml");
                }
            }
            String string = stringBuilder.toString();
            ParentFrame parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, this);
            parentFrame.getHistory().add(new HistoryItem(string));
        }

        @Override
        void commit() {
        }

        @Override
        boolean validatePage() {
            return true;
        }

        @Override
        String getPreviousPageID() {
            return null;
        }

        @Override
        String getNextPageID() {
            return null;
        }

        @Override
        void destroy() {
            this._iLabel = null;
            this._progressBar = null;
            this._text = null;
            this._messages = null;
        }

        void setFocusToMessageList() {
            this._messages.requestFocusInWindow();
        }

        class MyIOFilter
        extends IOFilter
        implements Runnable {
            private Vector<String> _messages;
            private String _progress;

            MyIOFilter(IO iO) {
                super(iO);
                this._messages = new Vector();
            }

            @Override
            public synchronized void writeln(String string, int n) {
                this._messages.add(string);
                SwingUtilities.invokeLater(this);
            }

            @Override
            public synchronized void showProgress(String string, int n) {
                this._progress = string;
                SwingUtilities.invokeLater(this);
            }

            @Override
            public synchronized void run() {
                if (this._progress != null) {
                    StatusPage.this._text.setText(this._progress);
                    this._progress = null;
                }
                while (this._messages.size() > 0) {
                    String string = this._messages.get(0);
                    this._messages.remove(0);
                    StatusPage.this._messages.append(string);
                    StatusPage.this._messages.append("\n");
                }
                StatusPage.this._messages.setCaretPosition(StatusPage.this._messages.getText().length());
            }
        }
    }

    static class TableInfo {
        String owner;
        String tableName;
        String type;

        TableInfo(String string, String string2, String string3) {
            this.owner = string;
            this.tableName = string2;
            this.type = string3;
        }
    }

    static class MyTableModel
    extends DefaultTableModel {
        MyTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class TablePage
    extends Page
    implements ItemListener,
    Runnable {
        private SybRadioButton _useExistingTable;
        private SybRadioButton _createTable;
        private JPanel _createTablePanel;
        private JTable _tables;
        private KeySelectionHelper _ksh;
        private Object _cookie;
        private SybComboBox _newCatalogCB;
        private SybLabel _newCatalogLabel;
        private SybComboBox _owner;
        private SybLabel _ownerLabel;
        private JTextField _tableName;
        private Object _enablingCookie;
        private SybLabel _dbName;
        private SybLabel _dbType;
        private SybLabel _dbVersion;
        private String _dbProductName;
        private SybComboBox _catalogsCB;
        private SybLabel _catalogsCBLabel;
        private Vector<String> _catalogs;
        private String _currentCatalog;
        private JPanel _catalogPanel;
        private boolean _refreshCatalogList;

        TablePage() {
            this._cookie = null;
            this._enablingCookie = null;
            this._catalogsCB = null;
            this._catalogsCBLabel = null;
            this._catalogs = null;
            this._currentCatalog = null;
            InstructionLabel instructionLabel = new InstructionLabel(ExportWizard.this._bundle.getISQLString("EW_TABLE_PAGE_INSTRUCTION"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            SybLabel sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DB_DESCRIPTION_LABEL"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DB_DESCRIPTION_NAME"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 0), 0, 0));
            this._dbName = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DB_DESCRIPTION_UNKNOWN"));
            new FontHelper((JLabel)this._dbName);
            jPanel.add((Component)this._dbName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DB_DESCRIPTION_TYPE"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 0), 0, 0));
            this._dbType = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DB_DESCRIPTION_UNKNOWN"));
            jPanel.add((Component)this._dbType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DB_DESCRIPTION_VERSION"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 0), 0, 0));
            this._dbVersion = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DB_DESCRIPTION_UNKNOWN"));
            jPanel.add((Component)this._dbVersion, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            this._useExistingTable = new SybRadioButton(ExportWizard.this._bundle.getISQLString("EW_IN_AN_EXISTING_TABLE"));
            this._useExistingTable.setOpaque(false);
            this._createTable = new SybRadioButton(ExportWizard.this._bundle.getISQLString("EW_CREATE_A_NEW_TABLE"));
            this._createTable.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._useExistingTable);
            buttonGroup.add((AbstractButton)this._createTable);
            this._catalogsCB = new SybComboBox();
            this._catalogsCB.addItemListener((ItemListener)this);
            this._catalogsCBLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DATABASE_LABEL"));
            this._catalogsCBLabel.setLabelFor((Component)this._catalogsCB);
            this._catalogPanel = new JPanel(new GridBagLayout());
            this._catalogPanel.setOpaque(false);
            this._catalogPanel.add((Component)this._catalogsCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            this._catalogPanel.add((Component)this._catalogsCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this._tables = new JTable();
            this._tables.setDefaultRenderer(Object.class, FontHelper.getTableCellRenderer());
            this._ksh = new KeySelectionHelper((JComponent)this._tables);
            this._tables.getTableHeader().setReorderingAllowed(false);
            this._tables.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this._tables);
            this._tables.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportWizard.this.handleExport();
                }
            }, KeyStroke.getKeyStroke(10, 0), 0);
            jScrollPane.setPreferredSize(new Dimension(200, 175));
            this._createTablePanel = new JPanel(new GridBagLayout());
            this._createTablePanel.setOpaque(false);
            this._newCatalogLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DATABASE_LABEL"));
            this._newCatalogLabel.setLabelFor((Component)this._newCatalogCB);
            this._newCatalogCB = new SybComboBox();
            this._createTablePanel.add((Component)this._newCatalogLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
            this._createTablePanel.add((Component)this._newCatalogCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 10), 0, 0));
            this._ownerLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_OWNER"));
            this._owner = new SybComboBox();
            new FontHelper((JComboBox)this._owner);
            this._ownerLabel.setLabelFor((Component)this._owner);
            this._createTablePanel.add((Component)this._ownerLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            this._createTablePanel.add((Component)this._owner, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
            sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_TABLE_NAME"));
            this._tableName = new JTextField(20);
            new FontHelper((JTextComponent)this._tableName);
            sybLabel.setLabelFor((Component)this._tableName);
            this._createTablePanel.add((Component)sybLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            this._createTablePanel.add((Component)this._tableName, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 20, 0), 0, 0));
            this.add((Component)this._useExistingTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._catalogPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 5, 0), 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.add((Component)this._createTable, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)this._createTablePanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            this._useExistingTable.addItemListener((ItemListener)this);
            this._createTable.addItemListener((ItemListener)this);
            this._useExistingTable.setSelected(true);
        }

        @Override
        void setInitialFocus() {
            SybRadioButton sybRadioButton = this._useExistingTable.isSelected() ? this._useExistingTable : this._createTable;
            sybRadioButton.requestFocusInWindow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void refresh() {
            if (ExportWizard.this._dstConnection != null) {
                String string;
                String string2;
                String string3;
                block35: {
                    string3 = null;
                    string2 = null;
                    string = null;
                    ExportWizard.this._dstQuoteString = null;
                    ExportWizard.this._dstSQLNeedsSchema = false;
                    ExportWizard.this._dstSQLNeedsCatalog = false;
                    try {
                        DatabaseMetaData databaseMetaData = ExportWizard.this._dstConnection.getMetaData();
                        try {
                            string2 = databaseMetaData.getDatabaseProductName();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        try {
                            string3 = databaseMetaData.getDatabaseProductVersion();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        ExportWizard.this._dstSQLNeedsSchema = databaseMetaData.supportsSchemasInDataManipulation();
                        ExportWizard.this._dstSQLNeedsCatalog = databaseMetaData.supportsCatalogsInDataManipulation();
                        ExportWizard.this._dstQuoteString = databaseMetaData.getIdentifierQuoteString();
                        if (ExportWizard.this._dstQuoteString != null && ExportWizard.this._dstQuoteString.isEmpty()) {
                            ExportWizard.this._dstQuoteString = null;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this._dbProductName = string2;
                    if (ExportWizard.this._dstSQLNeedsCatalog) {
                        try {
                            string = ExportWizard.this._dstConnection.getCatalog();
                            string = ExportWizard.sanitizeString(string);
                            if (string == null || string.isEmpty()) {
                                string = null;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (string2 != null && (string2.indexOf("SQL Anywhere") != -1 || string2.indexOf("Adaptive Server Anywhere") != -1)) {
                                Statement statement = null;
                                try {
                                    statement = ExportWizard.this._dstConnection.createStatement();
                                    ResultSet resultSet = statement.executeQuery("select db_name()");
                                    if (resultSet.next()) {
                                        string = resultSet.getString(1);
                                    }
                                }
                                catch (SQLException sQLException2) {
                                    break block35;
                                }
                                finally {
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (SQLException sQLException3) {}
                                    }
                                }
                            }
                            string = null;
                        }
                    }
                }
                if (string != null) {
                    this._dbName.setText(string);
                }
                if (string2 != null) {
                    this._dbType.setText(string2);
                }
                if (string3 != null) {
                    this._dbVersion.setText(string3);
                }
                this.refreshTableList(true);
                if (this._catalogs != null && this._catalogs.size() > 0) {
                    this._catalogsCB.setModel(new DefaultComboBoxModel<String>(this._catalogs));
                    if (this._currentCatalog != null) {
                        this._catalogsCB.setSelectedItem((Object)this._currentCatalog);
                    }
                    this._catalogPanel.setVisible(true);
                    this._newCatalogCB.setModel(new DefaultComboBoxModel<String>(this._catalogs));
                    if (this._currentCatalog != null) {
                        this._newCatalogCB.setSelectedItem((Object)this._currentCatalog);
                    }
                    this._newCatalogCB.setVisible(true);
                    this._newCatalogLabel.setVisible(true);
                } else {
                    this._catalogPanel.setVisible(false);
                    this._newCatalogCB.setVisible(false);
                    this._newCatalogLabel.setVisible(false);
                }
            }
            if (ExportWizard.this._createDestinationTable) {
                this._tableName.requestFocusInWindow();
            } else {
                this._tables.requestFocusInWindow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshSchemaList() {
            Object object;
            ResultSet resultSet = null;
            Vector<String> vector = new Vector<String>();
            String string = null;
            if (this._newCatalogCB.isVisible() && (object = this._newCatalogCB.getSelectedItem()) != null) {
                string = object.toString();
            }
            try {
                DatabaseMetaData databaseMetaData = ExportWizard.this._dstConnection.getMetaData();
                resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    try {
                        String string2 = resultSet.getString(2);
                        if (string2 != null && string != null && !string2.equals(string)) {
                            continue;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    vector.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            this._owner.setModel(new DefaultComboBoxModel(vector));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshTableList(boolean bl) {
            Window window = SwingUtilities.getWindowAncestor(this);
            Object object = DialogUtils.disableControls((Container)window);
            window.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this._refreshCatalogList = bl;
                ExportWizard.this._connection.executeOnWorkerThread(this, true);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getFormattedString("EW_COULD_NOT_GET_TABLE_LIST", exception.getLocalizedMessage()), (String)ExportWizard.this.getTitle(), (int)0);
            }
            finally {
                DialogUtils.enableControls((Object)object);
                window.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        void commit() {
            ExportWizard.this._createDestinationTable = this._createTable.isSelected();
            if (ExportWizard.this._createDestinationTable) {
                String string;
                if (this._newCatalogCB.isVisible()) {
                    ExportWizard.this._dstTableCatalog = this._newCatalogCB.getSelectedItem().toString();
                } else {
                    ExportWizard.this._dstTableCatalog = null;
                }
                if (this._owner.isVisible()) {
                    string = this._owner.getSelectedItem().toString();
                    if (string.isEmpty()) {
                        string = null;
                    }
                    ExportWizard.this._dstTableOwner = string;
                } else {
                    ExportWizard.this._dstTableOwner = null;
                }
                string = this._tableName.getText().trim();
                ExportWizard.this._dstTableName = string;
            } else {
                int n = this._tables.getSelectedRow();
                if (n != -1) {
                    if (this._catalogPanel.isVisible()) {
                        ExportWizard.this._dstTableCatalog = this._catalogsCB.getSelectedItem().toString();
                    } else {
                        ExportWizard.this._dstTableCatalog = null;
                    }
                    Object object = this._tables.getValueAt(n, 1);
                    if (object == null) {
                        ExportWizard.this._dstTableOwner = null;
                    } else {
                        ExportWizard.this._dstTableOwner = object.toString();
                    }
                    ExportWizard.this._dstTableName = this._tables.getValueAt(n, 0).toString();
                } else {
                    ExportWizard.this._dstTableCatalog = null;
                    ExportWizard.this._dstTableOwner = null;
                    ExportWizard.this._dstTableName = null;
                }
            }
        }

        @Override
        boolean validatePage() {
            if (ExportWizard.this._createDestinationTable) {
                int n;
                if (ExportWizard.this._dstTableName == null || ExportWizard.this._dstTableName.length() == 0) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getISQLString("EW_MISSING_TABLE_NAME"), (String)ExportWizard.this.getTitle(), (int)0);
                    this._tableName.requestFocusInWindow();
                    return false;
                }
                if (ExportWizard.this._dstTables != null && ExportWizard.this._dstTableName != null) {
                    for (n = 0; n < ExportWizard.this._dstTables.size(); ++n) {
                        TableInfo tableInfo = (TableInfo)ExportWizard.this._dstTables.get(n);
                        if (!ExportWizard.this._dstTableName.equals(tableInfo.tableName) || (ExportWizard.this._dstTableOwner != null || tableInfo.owner != null) && (ExportWizard.this._dstTableOwner == null || !ExportWizard.this._dstTableOwner.equals(tableInfo.owner))) continue;
                        SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getFormattedString("EW_TABLE_ALREADY_EXISTS", ExportWizard.this._dstTableName), (String)ExportWizard.this.getTitle(), (int)0);
                        this._tableName.requestFocusInWindow();
                        return false;
                    }
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (n = 0; n < ExportWizard.this._resultSets[0].getColumnCount(); ++n) {
                    String string = ExportWizard.this._resultSets[0].getColumnName(n);
                    if (hashSet.contains(string)) {
                        SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getFormattedString("EW_CANT_CREATE_TABLE_DUP_COLUMNS", string), (String)ExportWizard.this.getTitle(), (int)0);
                        return false;
                    }
                    hashSet.add(string);
                }
            } else if (ExportWizard.this._dstTableName == null || ExportWizard.this._dstTableName.length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getISQLString("EW_SELECT_A_TABLE"), (String)ExportWizard.this.getTitle(), (int)0);
                this._tables.requestFocusInWindow();
                return false;
            }
            return true;
        }

        @Override
        String getPreviousPageID() {
            return ExportWizard.DSN_PAGE;
        }

        @Override
        String getNextPageID() {
            return null;
        }

        @Override
        void destroy() {
            this._ksh.destroy();
            this._ksh = null;
            this._catalogsCB.removeItemListener((ItemListener)this);
            this._catalogsCB = null;
            this._catalogPanel = null;
            this._tables = null;
            this._owner = null;
            this._ownerLabel = null;
            this._tableName = null;
            this._useExistingTable.removeItemListener((ItemListener)this);
            this._useExistingTable = null;
            this._createTable.removeItemListener((ItemListener)this);
            this._createTable = null;
            this._dbVersion = null;
            this._dbType = null;
            this._dbName = null;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this._catalogsCB) {
                this._currentCatalog = this._catalogsCB.getSelectedItem().toString();
                this.refreshTableList(false);
            } else if (this._useExistingTable.isSelected()) {
                this._catalogsCB.setEnabled(true);
                this._catalogsCBLabel.setEnabled(true);
                this._tables.setEnabled(true);
                if (this._enablingCookie == null) {
                    this._enablingCookie = DialogUtils.disableControls((Container)this._createTablePanel);
                }
            } else {
                this._catalogsCB.setEnabled(false);
                this._catalogsCBLabel.setEnabled(false);
                this._tables.setEnabled(false);
                if (this._enablingCookie != null) {
                    DialogUtils.enableControls((Object)this._enablingCookie);
                    this._enablingCookie = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResultSet resultSet = null;
            resultSet = null;
            try {
                DatabaseMetaData databaseMetaData = ExportWizard.this._dstConnection.getMetaData();
                if (ExportWizard.this._dstSQLNeedsCatalog && this._refreshCatalogList) {
                    this._catalogs = new Vector();
                    try {
                        resultSet = databaseMetaData.getCatalogs();
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            if (string == null || string.isEmpty()) continue;
                            this._catalogs.add(string);
                        }
                        if (this._catalogs.size() != 0) {
                            this._currentCatalog = ExportWizard.this._dstConnection.getCatalog();
                            this._currentCatalog = ExportWizard.sanitizeString(this._currentCatalog);
                        } else {
                            this._catalogs = null;
                            this._currentCatalog = null;
                        }
                    }
                    catch (SQLException sQLException) {
                        this._catalogs = null;
                        this._currentCatalog = null;
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                            resultSet = null;
                        }
                    }
                }
                boolean bl = this._dbProductName != null && this._dbProductName.equals("SQL Anywhere");
                ExportWizard.this._dstTables = new ArrayList();
                resultSet = databaseMetaData.getTables(bl ? null : this._currentCatalog, null, "%", null);
                while (resultSet.next()) {
                    String string = resultSet.getString(2);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    if (string3.toLowerCase().indexOf("system") != -1 || string != null && string.toLowerCase().equals("sys") || string3.toLowerCase().indexOf("view") != -1 || bl && string != null && string.equalsIgnoreCase("dbo")) continue;
                    ExportWizard.this._dstTables.add(new TableInfo(string, string2, string3));
                }
                resultSet.close();
                resultSet = null;
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                    resultSet = null;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n;
                    int n2 = ExportWizard.this._dstTables.size();
                    Object[][] objectArray = new Object[n2][2];
                    for (n = 0; n < n2; ++n) {
                        TableInfo tableInfo = (TableInfo)ExportWizard.this._dstTables.get(n);
                        objectArray[n][0] = tableInfo.tableName;
                        objectArray[n][1] = tableInfo.owner;
                    }
                    Object[] objectArray2 = new Object[]{ExportWizard.this._bundle.getISQLString("EW_TABLE_NAME_COLUMN_HEADING"), ExportWizard.this._bundle.getISQLString("EW_TABLE_OWNER_COLUMN_HEADING")};
                    TablePage.this._tables.setModel(new MyTableModel(objectArray, objectArray2));
                    TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(TablePage.this._tables.getModel());
                    ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
                    arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
                    arrayList.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
                    tableRowSorter.setSortKeys(arrayList);
                    TablePage.this._tables.setRowSorter(tableRowSorter);
                    if (ExportWizard.this._dstTableName != null && ExportWizard.this._dstTableName.length() != 0) {
                        for (n = 0; n < n2; ++n) {
                            if (!objectArray[n][0].equals(ExportWizard.this._dstTableName)) continue;
                            int n3 = TablePage.this._tables.convertRowIndexToView(n);
                            TablePage.this._tables.setRowSelectionInterval(n3, n3);
                            Rectangle rectangle = TablePage.this._tables.getCellRect(n3, 0, true);
                            TablePage.this._tables.scrollRectToVisible(rectangle);
                            break;
                        }
                    }
                    if (TablePage.this._tables.getSelectedRow() == -1 && TablePage.this._tables.getRowCount() > 0) {
                        TablePage.this._tables.setRowSelectionInterval(0, 0);
                    }
                    TablePage.this._owner.setVisible(ExportWizard.this._dstSQLNeedsSchema);
                    TablePage.this._ownerLabel.setVisible(ExportWizard.this._dstSQLNeedsSchema);
                    if (ExportWizard.this._dstSQLNeedsSchema) {
                        TablePage.this.refreshSchemaList();
                    }
                }
            });
        }
    }

    class DSNPage
    extends Page
    implements ItemListener {
        private CardLayout _cardLayout;
        private JPanel _cardPanel;
        private InputStatementWizard.DBTypeComboBox _dbType;
        private LogonSource _selectedLogonSource;
        private ISQLPlugin[] _plugins;

        DSNPage() {
            this.setName(ExportWizard.DSN_PAGE);
            this.setLayout(new GridBagLayout());
            InstructionLabel instructionLabel = new InstructionLabel(ExportWizard.this._bundle.getISQLString("EW_DSN_PAGE_INSTRUCTION"));
            SybLabel sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DSN_PAGE_LABEL"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)sybLabel, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 15, 0), 0, 0));
            this._cardLayout = new CardLayout();
            this._cardPanel = new JPanel(this._cardLayout);
            this._plugins = PluginMgr.getPluginList();
            LogonSource[] logonSourceArray = new LogonSource[this._plugins.length];
            for (int i = 0; i < this._plugins.length; ++i) {
                logonSourceArray[i] = this._plugins[i].getLogonSource();
                JPanel jPanel = logonSourceArray[i].getPanel(1);
                jPanel.setBackground(SystemColor.window);
                this._cardPanel.add((Component)jPanel, logonSourceArray[i].getDisplayName());
            }
            this._dbType = new InputStatementWizard.DBTypeComboBox(logonSourceArray);
            this._dbType.addItemListener(this);
            if (logonSourceArray.length > 0) {
                this._dbType.setSelectedIndex(0);
                this._selectedLogonSource = logonSourceArray[0];
            } else {
                this._selectedLogonSource = null;
            }
            sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_DATABASE_TYPE_LABEL"));
            sybLabel.setLabelFor((Component)((Object)this._dbType));
            this.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)((Object)this._dbType), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this._cardPanel, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 99, 1, 1, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        void setInitialFocus() {
            this._dbType.requestFocusInWindow();
        }

        @Override
        void destroy() {
            this._dbType.removeItemListener(this);
            this._dbType = null;
            this._cardLayout = null;
            this._cardPanel = null;
            this._plugins = null;
        }

        @Override
        void refresh() {
            this._dbType.requestFocusInWindow();
        }

        @Override
        void commit() {
            String string;
            AbstractConnectionInfo abstractConnectionInfo = this._selectedLogonSource.getConnectionInfo();
            String string2 = abstractConnectionInfo.getURL();
            if (string2.regionMatches(true, 0, string = "jdbc:odbc:", 0, string.length())) {
                string2 = string2.substring(string.length());
                ExportWizard.this._dstConnectionParameters = string2;
            } else {
                ExportWizard.this._dstConnectionParameters = abstractConnectionInfo.getConnectionString();
            }
            String string3 = abstractConnectionInfo.getPassword();
            if (string3 != null && !string3.isEmpty()) {
                abstractConnectionInfo.setPassword("***");
                string2 = abstractConnectionInfo.getURL();
                if (string2.regionMatches(true, 0, string, 0, string.length())) {
                    string2 = string2.substring(string.length());
                    ExportWizard.this._secureDstConnectionParameters = string2;
                } else {
                    ExportWizard.this._secureDstConnectionParameters = abstractConnectionInfo.getConnectionString();
                }
                abstractConnectionInfo.setPassword(string3);
            } else {
                ExportWizard.this._secureDstConnectionParameters = ExportWizard.this._dstConnectionParameters;
            }
        }

        @Override
        boolean validatePage() {
            boolean bl;
            block9: {
                if (ExportWizard.this._dstConnection != null) {
                    try {
                        ExportWizard.this._dstConnection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ExportWizard.this._dstConnection = null;
                }
                bl = false;
                ExportWizard.this._dstPlugin = null;
                if (this._selectedLogonSource != null) {
                    int n = this._dbType.getSelectedIndex();
                    ISQLPlugin iSQLPlugin = this._plugins[n];
                    ClassLoader classLoader = iSQLPlugin.getClass().getClassLoader();
                    ExportWizard.this._dstConnection = this._selectedLogonSource.connect(null, null, classLoader);
                    if (ExportWizard.this._dstConnection != null) {
                        ExportWizard.this._dstPlugin = iSQLPlugin;
                        bl = true;
                    }
                }
                if (bl) {
                    try {
                        DatabaseMetaData databaseMetaData = ExportWizard.this._dstConnection.getMetaData();
                        String string = databaseMetaData.getDatabaseProductName();
                        if (string == null || !string.equalsIgnoreCase("UltraLite")) break block9;
                        for (int i = 0; i < ExportWizard.this._resultSets[0].getColumnCount(); ++i) {
                            String string2 = ExportWizard.this._resultSets[0].getColumnTypeName(i);
                            if (!string2.equalsIgnoreCase("NCHAR") && !string2.equalsIgnoreCase("NVARCHAR")) continue;
                            int n = SybOptionPane.showConfirmDialog((Component)this, (Object)ExportWizard.this._bundle.getISQLString("EW_WARNING_NCHAR_AND_ULTRALITE"), (String)ExportWizard.this.getTitle(), (int)0, (int)2);
                            bl = n == 0;
                            break;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            return bl;
        }

        @Override
        protected void updateMRULists() {
            if (ExportWizard.this._format == 14 && this._selectedLogonSource != null) {
                this._selectedLogonSource.notifyConnectOK();
                com.sybase.asa.logon.Preferences.makePermanent();
            }
        }

        @Override
        String getPreviousPageID() {
            return ExportWizard.FORMAT_PAGE;
        }

        @Override
        String getNextPageID() {
            return ExportWizard.TABLE_PAGE;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this._dbType && itemEvent.getStateChange() == 1) {
                LogonSource logonSource = (LogonSource)this._dbType.getSelectedItem();
                this._cardLayout.show(this._cardPanel, logonSource.getDisplayName());
                this._selectedLogonSource = logonSource;
            }
        }

        private class ConnectionClient
        implements LogonDialogClient {
            private AbstractConnectionInfo _connectionInfo = null;

            private ConnectionClient() {
            }

            @Override
            public boolean handleOK(JDialog jDialog, LogonSource logonSource) {
                this._connectionInfo = logonSource.getConnectionInfo();
                return true;
            }

            AbstractConnectionInfo getConnectionInfo() {
                return this._connectionInfo;
            }
        }
    }

    class FilePage
    extends Page
    implements ActionListener,
    ItemListener {
        private MRUComboBox _fileName;
        private SybButton _browse;
        private SybComboBox _delimiter;
        private SybComboBox _encoding;
        private SybCheckBox _escapeTextData;
        private JTextField _escapeCharacter;
        private SybLabel _escapeCharacterLabel;
        private Object _enablingCookie;
        private JPanel _asciiPanel;

        FilePage() {
            this._enablingCookie = null;
            this._asciiPanel = null;
            InstructionLabel instructionLabel = new InstructionLabel(ExportWizard.this._bundle.getISQLString("EW_FILE_PAGE_INSTRUCTION"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            SybLabel sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_FILE_NAME_LABEL"));
            this._fileName = new MRUComboBox(ExportWizard.this._mruFileNameList);
            new FontHelper((JComboBox)this._fileName);
            sybLabel.setLabelFor((Component)this._fileName);
            this._browse = new SybButton(ExportWizard.this._bundle.getISQLString("EW_BROWSE_BUTTON"));
            this._browse.addActionListener((ActionListener)this);
            this.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this._fileName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this._browse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            this._asciiPanel = new JPanel(new GridBagLayout());
            this._asciiPanel.setOpaque(false);
            sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_FIELD_SEPARATOR"));
            this._delimiter = new SybComboBox(new Object[]{ExportWizard.this._bundle.getISQLString("EW_COMMA_SEPARATOR"), ExportWizard.this._bundle.getISQLString("EW_TAB_SEPARATOR")});
            this._delimiter.setEditable(true);
            sybLabel.setLabelFor((Component)this._delimiter);
            this._asciiPanel.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
            this._asciiPanel.add((Component)this._delimiter, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            sybLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EW_ENCODING_LABEL"));
            this._encoding = new SybComboBox(InputOutputOptions.getEncodingListForDisplay());
            if (ExportWizard.this._dstEncoding == null) {
                this._encoding.setSelectedIndex(0);
            } else {
                this._encoding.setSelectedItem((Object)ExportWizard.this._dstEncoding);
            }
            sybLabel.setLabelFor((Component)this._encoding);
            this._asciiPanel.add((Component)sybLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
            this._asciiPanel.add((Component)this._encoding, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            this._escapeTextData = new SybCheckBox(ExportWizard.this._bundle.getISQLString("EDEscapeTextData"));
            this._escapeTextData.setOpaque(false);
            this._escapeTextData.setSelected(true);
            this._escapeTextData.addItemListener((ItemListener)this);
            this._escapeCharacterLabel = new SybLabel(ExportWizard.this._bundle.getISQLString("EDEscapeCharacter"));
            this._escapeCharacter = new LimitedTextField(1);
            this._escapeCharacter.setText(" ");
            this._escapeCharacterLabel.setLabelFor((Component)this._escapeCharacter);
            Dimension dimension = this._escapeCharacter.getPreferredSize();
            dimension.width *= 3;
            this._escapeCharacter.setPreferredSize(dimension);
            if (ExportWizard.this._dstEscapeCharacter != null) {
                this._escapeCharacter.setText(ExportWizard.this._dstEscapeCharacter);
            }
            this._asciiPanel.add((Component)this._escapeTextData, new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._asciiPanel.add((Component)this._escapeCharacterLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 5), 0, 0));
            this._asciiPanel.add((Component)this._escapeCharacter, new GridBagConstraints(1, 5, 0, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._asciiPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(99, 99, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._asciiPanel, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
        }

        @Override
        void setInitialFocus() {
            this._fileName.requestFocusInWindow();
        }

        @Override
        void refresh() {
            if (ExportWizard.this._dstDelimiter == null || ExportWizard.this._dstDelimiter.equals(",")) {
                this._delimiter.setSelectedIndex(0);
            } else if (ExportWizard.this._dstDelimiter.equals("\t")) {
                this._delimiter.setSelectedIndex(1);
            } else {
                this._delimiter.setSelectedItem((Object)ExportWizard.this._dstDelimiter);
            }
            if (ExportWizard.this._format == 1) {
                if (this._enablingCookie != null) {
                    DialogUtils.enableControls((Object)this._enablingCookie);
                    this._enablingCookie = null;
                }
            } else if (this._enablingCookie == null) {
                this._enablingCookie = DialogUtils.disableControls((Container)this._asciiPanel);
            }
            this._fileName.requestFocusInWindow();
        }

        @Override
        void commit() {
            ExportWizard.this._dstFileName = this._fileName.getStringValue().trim();
            if (ExportWizard.this._format == 1) {
                String string = this._delimiter.getSelectedItem().toString();
                if (string.equals(ExportWizard.this._bundle.getISQLString("EW_COMMA_SEPARATOR"))) {
                    string = ",";
                } else if (string.equals(ExportWizard.this._bundle.getISQLString("EW_TAB_SEPARATOR"))) {
                    string = "\t";
                }
                ExportWizard.this._dstDelimiter = string;
                int n = this._encoding.getSelectedIndex();
                if (n > 0) {
                    ExportWizard.this._dstEncoding = this._encoding.getSelectedItem().toString();
                } else {
                    ExportWizard.this._dstEncoding = null;
                }
                if (this._escapeTextData.isSelected()) {
                    string = this._escapeCharacter.getText().trim();
                    ExportWizard.this._dstEscapeCharacter = string;
                }
            }
        }

        @Override
        boolean validatePage() {
            boolean bl = true;
            if (ExportWizard.this._dstFileName.length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getISQLString("EW_MISSING_FILE_NAME"), (String)ExportWizard.this.getTitle(), (int)0);
                this._fileName.requestFocusInWindow();
                bl = false;
            }
            if (ExportWizard.this._format == 1 && this._escapeTextData.isSelected() && ExportWizard.this._dstEscapeCharacter.length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getISQLString("EW_MISSING_ESCAPE_CHARACTER"), (String)ExportWizard.this.getTitle(), (int)0);
                bl = false;
            }
            return bl;
        }

        @Override
        protected void updateMRULists() {
            if (ExportWizard.this._format != 14) {
                ExportWizard.this._mruFileNameList = this._fileName.getMRUList();
                Preferences.setExportWizardMRUFileNameList(ExportWizard.this._mruFileNameList);
                Preferences.setStringOption(ExportWizard.this._connection, "lastExportFolder", new File(ExportWizard.this._dstFileName).getParent());
            }
        }

        @Override
        String getPreviousPageID() {
            return ExportWizard.FORMAT_PAGE;
        }

        @Override
        String getNextPageID() {
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.handleBrowse();
        }

        private void handleBrowse() {
            SybFileFilter[] sybFileFilterArray;
            File file;
            File file2 = null;
            String string = this._fileName.getStringValue();
            if (string.length() > 0) {
                file = new File(string);
                if (file.isDirectory()) {
                    file2 = file;
                    file = null;
                }
            } else {
                file = null;
            }
            if (file2 == null && file == null && Preferences.getBooleanOption(ExportWizard.this._connection, "setInitialFolderForFileBrowsers") && (string = Preferences.getStringOption(ExportWizard.this._connection, "lastExportFolder")) != null && string.length() != 0 && !(file2 = new File(string)).exists()) {
                file2 = null;
            }
            SybFileChooser sybFileChooser = new SybFileChooser(274);
            switch (ExportWizard.this._format) {
                case 13: {
                    sybFileFilterArray = new SybFileFilter[]{new SybFileFilter("xml", ISQLResource.getISQLString(GeneralResources.getName(), "XML (*.{0})")), SybFileFilter.getAllFilesFilter()};
                    break;
                }
                case 3: {
                    sybFileFilterArray = new SybFileFilter[]{new SybFileFilter(new String[]{"html", "htm"}, ISQLResource.getISQLString(GeneralResources.getName(), "HTML (*.{0})")), SybFileFilter.getAllFilesFilter()};
                    break;
                }
                case 2: {
                    sybFileFilterArray = new SybFileFilter[]{new SybFileFilter("txt", ISQLResource.getISQLString(GeneralResources.getName(), "Fixed (*.{0})")), SybFileFilter.getAllFilesFilter()};
                    break;
                }
                default: {
                    sybFileFilterArray = new SybFileFilter[]{new SybFileFilter(new String[]{"csv", "txt"}, ISQLResource.getISQLString(GeneralResources.getName(), "ASCII/Fixed (*.{0})")), SybFileFilter.getAllFilesFilter()};
                }
            }
            sybFileChooser.setFilters(sybFileFilterArray, 0);
            if (sybFileChooser.showDialog((Window)ExportWizard.this, file2, file)) {
                File file3 = sybFileChooser.getSelectedFile();
                this._fileName.setSelectedItem((Object)file3.getAbsolutePath());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = this._escapeTextData.isSelected();
            this._escapeCharacter.setEnabled(bl);
            this._escapeCharacterLabel.setEnabled(bl);
        }

        @Override
        void destroy() {
            this._fileName = null;
            this._browse.removeActionListener((ActionListener)this);
            this._browse = null;
            this._delimiter = null;
            this._encoding = null;
            if (this._escapeTextData != null) {
                this._escapeTextData.removeItemListener((ItemListener)this);
                this._escapeTextData = null;
            }
            this._escapeCharacter = null;
            this._escapeCharacterLabel = null;
        }
    }

    class FormatPage
    extends Page {
        private SybRadioButton _ascii;
        private SybRadioButton _fixed;
        private SybRadioButton _html;
        private SybRadioButton _xml;
        private SybRadioButton _odbc;

        FormatPage() {
            InstructionLabel instructionLabel = new InstructionLabel(ExportWizard.this._bundle.getISQLString("EW_FORMAT_PAGE_INSTRUCTION"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            this._ascii = new SybRadioButton(ExportWizard.this._bundle.getISQLString("EW_DELIMITED_TEXT_FILE"));
            this._ascii.setOpaque(false);
            this._odbc = new SybRadioButton(ExportWizard.this._bundle.getISQLString("EW_ODBC_DATABASE"));
            this._odbc.setOpaque(false);
            this._fixed = new SybRadioButton(ExportWizard.this._bundle.getISQLString("EW_FIXED_WIDTH_TEXT_FILE"));
            this._fixed.setOpaque(false);
            this._html = new SybRadioButton(ExportWizard.this._bundle.getISQLString("EW_HTML_FILE"));
            this._html.setOpaque(false);
            this._xml = new SybRadioButton(ExportWizard.this._bundle.getISQLString("EW_XML_FILE"));
            this._xml.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._ascii);
            buttonGroup.add((AbstractButton)this._odbc);
            buttonGroup.add((AbstractButton)this._fixed);
            buttonGroup.add((AbstractButton)this._html);
            buttonGroup.add((AbstractButton)this._xml);
            this.add((Component)this._ascii, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            if (ExportWizard.this._connection.getPlugin() == null || !ExportWizard.this._connection.getPlugin().getPluginID().equals("ASE")) {
                this.add((Component)this._odbc, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)this._fixed, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._html, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._xml, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        void setInitialFocus() {
            SybRadioButton sybRadioButton = this._ascii.isSelected() ? this._ascii : (this._html.isSelected() ? this._html : (this._odbc.isSelected() ? this._odbc : (this._fixed.isSelected() ? this._fixed : this._xml)));
            sybRadioButton.requestFocusInWindow();
        }

        @Override
        void refresh() {
            if (ExportWizard.this._format == 13) {
                this._xml.setSelected(true);
            } else if (ExportWizard.this._format == 2) {
                this._fixed.setSelected(true);
            } else if (ExportWizard.this._format == 14) {
                this._odbc.setSelected(true);
            } else if (ExportWizard.this._format == 3) {
                this._html.setSelected(true);
            } else {
                this._ascii.setSelected(true);
            }
        }

        @Override
        void commit() {
            if (this._ascii.isSelected()) {
                ExportWizard.this._format = 1;
            } else if (this._fixed.isSelected()) {
                ExportWizard.this._format = 2;
            } else if (this._xml.isSelected()) {
                ExportWizard.this._format = 13;
            } else if (this._html.isSelected()) {
                ExportWizard.this._format = 3;
            } else if (this._odbc.isSelected()) {
                ExportWizard.this._format = 14;
            }
        }

        @Override
        boolean validatePage() {
            boolean bl = true;
            if (ExportWizard.this._resultSets.length > 1) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ExportWizard.this._bundle.getISQLString("EW_CANT_EXPORT_MULTIPLE_RESULT_SETS"), (String)ExportWizard.this.getTitle(), (int)0);
                bl = false;
            }
            return bl;
        }

        @Override
        String getPreviousPageID() {
            return null;
        }

        @Override
        String getNextPageID() {
            if (ExportWizard.this._format == 14) {
                return ExportWizard.DSN_PAGE;
            }
            return ExportWizard.FILE_PAGE;
        }

        @Override
        void destroy() {
            this._odbc = null;
            this._xml = null;
            this._html = null;
            this._fixed = null;
            this._ascii = null;
        }
    }

    abstract class Page
    extends JPanel {
        Page() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            this.setBackground(SystemColor.window);
            this.setOpaque(true);
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 99, 1, 1, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
        }

        abstract void refresh();

        abstract void commit();

        abstract boolean validatePage();

        abstract String getPreviousPageID();

        abstract String getNextPageID();

        abstract void destroy();

        abstract void setInitialFocus();

        protected void updateMRULists() {
        }
    }
}

