/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.NumericTextField;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.UserDataComboBox;

class FastLoaderConfigurationDialog
extends JDialog
implements ActionListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private boolean _retcode;
    private int _inactivityTimeout;
    private int _port;
    private int _defaultInactivityTimeout;
    private int _defaultPort;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _useDefaults = null;
    private JTextField _portNumber = null;
    private UserDataComboBox _inactivityTimer = null;

    FastLoaderConfigurationDialog(Dialog dialog, int n, int n2, int n3, int n4) {
        super((Window)dialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(ISQLResource.getISQLString(GeneralResources.getName(), "FastLoaderConfigurationTitle"));
        this._port = n;
        this._inactivityTimeout = n2;
        this._defaultPort = n3;
        this._defaultInactivityTimeout = n4;
        this._retcode = false;
        this.createUI();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(dialog);
    }

    boolean isOK() {
        return this._retcode;
    }

    int getPort() {
        return this._port;
    }

    int getInactivityTimeout() {
        return this._inactivityTimeout;
    }

    void destroy() {
        this._portNumber = null;
        this._inactivityTimer = null;
        if (this._useDefaults != null) {
            this._useDefaults.removeActionListener((ActionListener)this);
            this._useDefaults = null;
        }
        if (this._ok != null) {
            this._ok.removeActionListener((ActionListener)this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    private void createUI() {
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(iSQLResource.getISQLString("FastLoaderPortNumberTitle")), BorderFactory.createEmptyBorder(5, 5, 10, 5)));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SybLabel sybLabel = new SybLabel((Icon)ISQLImages.getImageIcon("port_number"));
        sybLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        SybTextArea sybTextArea = new SybTextArea(iSQLResource.getISQLString("FastLoaderAboutPortNumber"));
        sybTextArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        sybTextArea.setFont(sybLabel.getFont());
        sybTextArea.setLineWrap(true);
        sybTextArea.setWrapStyleWord(true);
        sybTextArea.setColumns(48);
        sybTextArea.setEditable(false);
        sybTextArea.setForeground(sybLabel.getForeground());
        sybTextArea.setBackground(sybLabel.getBackground());
        sybTextArea.setSelectionColor(sybLabel.getBackground());
        sybTextArea.setSelectedTextColor(sybLabel.getForeground());
        sybTextArea.setFocusable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)sybTextArea, gridBagConstraints);
        sybLabel = new SybLabel(iSQLResource.getISQLString("FastLoaderPortNumber"));
        sybLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._portNumber = new NumericTextField();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._portNumber, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._portNumber);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(iSQLResource.getISQLString("FastLoaderInactivityTimerTitle")), BorderFactory.createEmptyBorder(5, 5, 10, 5)));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        sybLabel = new SybLabel((Icon)ISQLImages.getImageIcon("inactivity_timer"));
        sybLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        sybTextArea = new SybTextArea(iSQLResource.getISQLString("FastLoaderAboutInactivityTimer"));
        sybTextArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        sybTextArea.setFont(sybLabel.getFont());
        sybTextArea.setLineWrap(true);
        sybTextArea.setWrapStyleWord(true);
        sybTextArea.setColumns(48);
        sybTextArea.setEditable(false);
        sybTextArea.setForeground(sybLabel.getForeground());
        sybTextArea.setBackground(sybLabel.getBackground());
        sybTextArea.setSelectionColor(sybLabel.getBackground());
        sybTextArea.setSelectedTextColor(sybLabel.getForeground());
        sybTextArea.setFocusable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)sybTextArea, gridBagConstraints);
        sybLabel = new SybLabel(iSQLResource.getISQLString("FastLoaderInactivityTimer"));
        sybLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        String[] stringArray = new String[]{iSQLResource.getISQLString("FastLoaderNever"), iSQLResource.getISQLString("FastLoader15Min"), iSQLResource.getISQLString("FastLoader30Min"), iSQLResource.getISQLString("FastLoader1Hour"), iSQLResource.getISQLString("FastLoader2Hours"), iSQLResource.getISQLString("FastLoader3Hours"), iSQLResource.getISQLString("FastLoader4Hours"), iSQLResource.getISQLString("FastLoader5Hours")};
        Object[] objectArray = new Object[]{0, 15, 30, 60, 120, 180, 240, 300};
        this._inactivityTimer = new UserDataComboBox(stringArray, objectArray);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._inactivityTimer, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._inactivityTimer);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this._ok = new SybButton(iSQLResource.getISQLString("FastLoaderOK"));
        this._ok.addActionListener((ActionListener)this);
        this._cancel = new SybButton(iSQLResource.getISQLString("FastLoaderCancel"));
        this._cancel.addActionListener((ActionListener)this);
        this._useDefaults = new SybButton(iSQLResource.getISQLString("FastLoaderUseDefaults"));
        this._useDefaults.addActionListener((ActionListener)this);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._useDefaults);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._ok);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._cancel);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jPanel2);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this.setControlValues(this._port, this._inactivityTimeout);
        this.getContentPane().add(jPanel);
    }

    private void setControlValues(int n, int n2) {
        this._inactivityTimer.setSelectedByUserData(n2);
        this._portNumber.setText(Integer.toString(n));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._useDefaults) {
            this.setControlValues(this._defaultPort, this._defaultInactivityTimeout);
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    private void handleOK() {
        int n;
        String string = this._portNumber.getText();
        if (string != null && string.length() != 0) {
            try {
                this._port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((n = this._inactivityTimer.getSelectedIndex()) >= 0) {
            this._inactivityTimeout = (Integer)this._inactivityTimer.getUserData(n);
        }
        this._retcode = true;
        this.setVisible(false);
    }

    private void handleCancel() {
        this._retcode = false;
        this.setVisible(false);
    }
}

